/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.dataset.AbstractDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.DefaultTableDataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetAdapter;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetAdapter;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.system.DasLogger;

public class DataSetAdapter {
    private static final Logger logger = DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG);
    public static final String PROPERTY_SOURCE = "adapterSource";

    protected static Map<String, Object> adaptSubstitutions(Map<String, Object> das2props) {
        Pattern ptrn = Pattern.compile("(%\\{)(.+?)(\\})");
        for (Map.Entry<String, Object> e : das2props.entrySet()) {
            Object o = e.getValue();
            if (!(o instanceof String)) continue;
            String s = (String)o;
            Matcher m = ptrn.matcher(s);
            while (m.find()) {
                if (m.group(2).contains("USER_PROPERTIES")) continue;
                s = String.format("%sUSER_PROPERTIES.%s%s", s.substring(0, m.end(1)), s.substring(m.start(2), m.end(2)), s.substring(m.start(3), s.length()));
                m = ptrn.matcher(s);
            }
            e.setValue(s);
        }
        return das2props;
    }

    public static AbstractDataSet create(DataSet ds) {
        if (ds == null) {
            throw new NullPointerException("dataset is null");
        }
        if (ds instanceof VectorDataSet) {
            int i;
            boolean newCodeWhichSupportsBinMinPlanes = false;
            if (newCodeWhichSupportsBinMinPlanes) {
                VectorDataSet vds = (VectorDataSet)ds;
                return DataSetAdapter.createVectorQds(vds);
            }
            if (ds.getPlaneIds().length <= 1) {
                Vector v = new Vector((VectorDataSet)ds);
                String sname = (String)ds.getProperty("name");
                if (sname == null) {
                    sname = "y";
                }
                v.putProperty("NAME", sname);
                return v;
            }
            VectorDataSet vds = (VectorDataSet)ds;
            Vector v = new Vector(vds);
            String sname = (String)ds.getProperty("name");
            if (sname == null) {
                sname = "y";
            }
            v.putProperty("NAME", sname);
            AbstractDataSet bds = (AbstractDataSet)Ops.bundle(null, (QDataSet)v);
            String[] planes = ds.getPlaneIds();
            Units unitsY = null;
            boolean bCommonYUnits = false;
            HashMap<String, Integer> names = new HashMap<String, Integer>();
            names.put("x", 0);
            for (i = 1; i < planes.length; ++i) {
                names.put(planes[i], i);
            }
            for (i = 1; i < planes.length; ++i) {
                int i0;
                AbstractDataSet v0;
                String bas;
                AbstractDataSet.ViewDataSet view = (AbstractDataSet.ViewDataSet)vds.getPlanarView(planes[i]);
                if (unitsY == null) {
                    unitsY = view.getYUnits();
                } else {
                    bCommonYUnits = unitsY == view.getYUnits();
                }
                v = new Vector((VectorDataSet)vds.getPlanarView(planes[i]), planes[i]);
                int iext = planes[i].lastIndexOf(".");
                String ext = planes[i].substring(iext + 1);
                if (ext.length() == planes[i].length()) {
                    bas = ext;
                    ext = "";
                    v0 = null;
                    i0 = -1;
                } else {
                    bas = planes[i].substring(0, planes[i].length() - ext.length() - 1);
                    v0 = (AbstractDataSet)Ops.unbundle((QDataSet)bds, (String)bas);
                    i0 = (Integer)names.get(bas);
                }
                MutablePropertyDataSet bundleDescriptor = (MutablePropertyDataSet)bds.property("BUNDLE_1");
                v.putProperty("NAME", planes[i]);
                if (ext.equals("min") && v0 != null) {
                    v0.putProperty("BIN_MIN", (Object)v);
                    bundleDescriptor.putProperty("BIN_MIN_NAME", i0, (Object)planes[i]);
                } else if (ext.equals("max") && v0 != null) {
                    v0.putProperty("BIN_MAX", (Object)v);
                    bundleDescriptor.putProperty("BIN_MAX_NAME", i0, (Object)planes[i]);
                } else if (ext.equals("stddev") && v0 != null) {
                    v0.putProperty("DELTA_MINUS", (Object)v);
                    v0.putProperty("DELTA_PLUS", (Object)v);
                    bundleDescriptor.putProperty("DELTA_MINUS_NAME", i0, (Object)planes[i]);
                    bundleDescriptor.putProperty("DELTA_PLUS_NAME", i0, (Object)planes[i]);
                }
                Ops.bundle((QDataSet)bds, (QDataSet)v);
            }
            Map<String, Object> dasProps = DataSetAdapter.adaptSubstitutions(vds.getProperties());
            bds.putProperty("USER_PROPERTIES", dasProps);
            bds.putProperty("DEPEND_0", (Object)new XTagsDataSet(vds));
            bds.putProperty("TITLE", dasProps.get("title"));
            if (bCommonYUnits) {
                bds.putProperty("UNITS", (Object)unitsY);
                bds.putProperty("LABEL", (Object)unitsY.toString());
            }
            bds.putProperty("SCALE_TYPE", vds.getProperty("yScaleType"));
            DatumRange yRng = (DatumRange)vds.getProperty("yRange");
            if (yRng != null) {
                bds.putProperty("TYPICAL_MIN", (Object)yRng.min().value());
                bds.putProperty("TYPICAL_MAX", (Object)yRng.max().value());
            }
            if ("xyzScatter".equals(ds.getProperty("schema"))) {
                BundleDataSet bbds = (BundleDataSet)bds;
                return (BundleDataSet)Ops.bundle((QDataSet)new XTagsDataSet(vds), (QDataSet)bbds.unbundle(0), (QDataSet)bbds.unbundle(1));
            }
            if (bds.length(0) == 1) {
                return DDataSet.copy((QDataSet)Ops.unbundle((QDataSet)bds, (int)0));
            }
            return DDataSet.copy((QDataSet)bds);
        }
        if (ds instanceof TableDataSet) {
            TableDataSet tds = (TableDataSet)ds;
            if (tds.tableCount() <= 1) {
                return DataSetAdapter.createSimpleTableDS(tds);
            }
            if (tds instanceof DefaultTableDataSet && tds.tableCount() > tds.getXLength() / 2) {
                return ((DefaultTableDataSet)tds).toQDataSet();
            }
            return new MultipleTable(tds);
        }
        throw new IllegalArgumentException("unsupported dataset type: " + ds.getClass().getName());
    }

    private static AbstractDataSet createVectorQds(VectorDataSet vds) {
        String sSource;
        String sOp;
        DataSet ds;
        String[] lPlanes = vds.getPlaneIds();
        HashMap<String, AdapterPDim> lPDims = new HashMap<String, AdapterPDim>();
        int nStashed = 0;
        Units commonY = null;
        boolean bCommonYUnits = false;
        for (String sId : lPlanes) {
            ds = vds.getPlanarView(sId);
            sOp = (String)ds.getProperty("operation");
            if (sOp != null && !sOp.equals("BIN_AVG")) continue;
            if (lPDims.containsKey(sId)) {
                throw new IllegalArgumentException("Non-unique plane IDs in das2 X-multi-Y packet");
            }
            sSource = (String)ds.getProperty("source");
            lPDims.put(sSource, new AdapterPDim(sId));
            if (commonY == null) {
                commonY = ds.getYUnits();
            } else {
                bCommonYUnits = commonY == ds.getYUnits();
            }
            ++nStashed;
        }
        for (String sId : lPlanes) {
            if (sId == null || (sOp = (String)(ds = vds.getPlanarView(sId)).getProperty("operation")) == null || sOp.equals("BIN_AVG")) continue;
            sSource = (String)ds.getProperty("source");
            AdapterPDim pdim = (AdapterPDim)lPDims.get(sSource);
            if (pdim == null) {
                throw new IllegalArgumentException("Statistics plane has no parent in x-multi-y packet");
            }
            pdim.vars.put(sOp, sId);
            ++nStashed;
        }
        if (nStashed != lPlanes.length) {
            throw new IllegalArgumentException("Not all plane purposes understood in x-multi-y packet");
        }
        AbstractDataSet bds = null;
        Vector v = null;
        for (Map.Entry e : lPDims.entrySet()) {
            AdapterPDim pdim = (AdapterPDim)e.getValue();
            AbstractDataSet.ViewDataSet view = (AbstractDataSet.ViewDataSet)vds.getPlanarView(pdim.sId);
            v = new Vector((VectorDataSet)((Object)view), pdim.sId);
            String sName = (String)view.getProperty("name");
            if (sName == null) {
                sName = "y";
            }
            v.putProperty("NAME", sName);
            for (String sOp2 : pdim.vars.keySet()) {
                if (sOp2 == null) continue;
                String sId = pdim.vars.get(sOp2);
                Vector qdsStats = new Vector((VectorDataSet)vds.getPlanarView(sId), sId);
                if (sOp2.equals("BIN_MAX")) {
                    v.putProperty("BIN_MAX", (Object)qdsStats);
                }
                if (sOp2.equals("BIN_MIN")) {
                    v.putProperty("BIN_MIN", (Object)qdsStats);
                }
                if (sOp2.equals("DELTA_PLUS")) {
                    v.putProperty("DELTA_PLUS", (Object)qdsStats);
                }
                if (!sOp2.equals("DELTA_MINUS")) continue;
                v.putProperty("DELTA_MINUS", (Object)qdsStats);
            }
            if (lPDims.size() <= 1) continue;
            if (bds == null) {
                bds = (AbstractDataSet)Ops.bundle(null, (QDataSet)v);
                if (bCommonYUnits && commonY != null) {
                    bds.putProperty("UNITS", (Object)commonY);
                    bds.putProperty("LABEL", (Object)commonY.toString());
                }
                Map<String, Object> dasProps = DataSetAdapter.adaptSubstitutions(vds.getProperties());
                bds.putProperty("USER_PROPERTIES", dasProps);
                bds.putProperty("DEPEND_0", (Object)new XTagsDataSet(vds));
                bds.putProperty("TITLE", dasProps.get("title"));
                bds.putProperty("SCALE_TYPE", vds.getProperty("yScaleType"));
                DatumRange yRng = (DatumRange)vds.getProperty("yRange");
                if (yRng == null) continue;
                bds.putProperty("TYPICAL_MIN", (Object)yRng.min().value());
                bds.putProperty("TYPICAL_MAX", (Object)yRng.max().value());
                continue;
            }
            Ops.bundle(bds, (QDataSet)v);
        }
        if (bds != null) {
            return DDataSet.copy(bds);
        }
        return v;
    }

    @Deprecated
    public static DataSet createLegacyDataSet(QDataSet ds) {
        if (ds.rank() == 1) {
            return VectorDataSetAdapter.create(ds);
        }
        if (SemanticOps.isBundle((QDataSet)ds)) {
            return VectorDataSetAdapter.createFromBundle(ds);
        }
        if (ds.rank() == 2) {
            return TableDataSetAdapter.create(ds);
        }
        if (ds.rank() == 3) {
            return TableDataSetAdapter.create(ds);
        }
        throw new IllegalArgumentException("unsupported rank: " + ds.rank());
    }

    private static AbstractDataSet createSimpleTableDS(TableDataSet tds) {
        String sTopDs = null;
        String sTopSrc = null;
        String[] lPlanes = tds.getPlaneIds();
        if (lPlanes.length == 1) {
            sTopDs = lPlanes[0];
        } else {
            for (String sPlane : lPlanes) {
                DataSet ds = tds.getPlanarView(sPlane);
                sTopSrc = (String)ds.getProperty("source");
                if (sTopSrc == null) {
                    sTopDs = sPlane;
                    break;
                }
                String sOp = (String)ds.getProperty("operation");
                if (sOp == null || !sOp.equals("BIN_AVG")) continue;
                sTopDs = sPlane;
                break;
            }
        }
        if (sTopDs == null) {
            throw new IllegalArgumentException("Couldn't locate the top-level <yscan> in the set of <yscans>.  HINT: If this is simple bundle then you've hit a missing feature in Autoplot. If this is a peak and averages dataset, use the 'source' and 'operation' properties to clairify the <yscan> relationships. ");
        }
        SimpleTable qds = new SimpleTable((TableDataSet)tds.getPlanarView(sTopDs));
        for (String sPlane : lPlanes) {
            String sOp;
            TableDataSet dsPlane;
            String sPlaneSrc;
            if (sPlane.equals(sTopDs) || ((sPlaneSrc = (String)(dsPlane = (TableDataSet)tds.getPlanarView(sPlane)).getProperty("source")) != null || sTopSrc != null) && !sTopSrc.equals(sPlaneSrc) || (sOp = (String)dsPlane.getProperty("operation")) == null) continue;
            SimpleTable qdsAncillary = new SimpleTable(dsPlane);
            if (sOp.equals("BIN_MAX")) {
                qds.putProperty("BIN_MAX", (Object)qdsAncillary);
            }
            if (sOp.equals("BIN_MIN")) {
                qds.putProperty("BIN_MIN", (Object)qdsAncillary);
            }
            if (sOp.equals("DELTA_PLUS")) {
                qds.putProperty(sOp, (Object)qdsAncillary);
            }
            if (!sOp.equals("DELTA_MINUS")) continue;
            qds.putProperty(sOp, (Object)qdsAncillary);
        }
        return qds;
    }

    static class MultipleTable
    extends AbstractDataSet {
        TableDataSet source;

        MultipleTable(TableDataSet source) {
            this.source = source;
            Map<String, Object> dasProps = DataSetAdapter.adaptSubstitutions(source.getProperties());
            this.properties.put("USER_PROPERTIES", dasProps);
            this.properties.put("JOIN_0", DDataSet.create((int[])new int[0]));
            this.properties.put("UNITS", source.getZUnits());
            this.properties.put(DataSetAdapter.PROPERTY_SOURCE, source);
            this.properties.put("TITLE", dasProps.get("title"));
            DatumRange zRng = (DatumRange)dasProps.get("zRange");
            if (zRng != null) {
                this.properties.put("TYPICAL_MIN", zRng.min().value());
                this.properties.put("TYPICAL_MAX", zRng.max().value());
            }
            this.properties.put("RENDER_TYPE", dasProps.get("renderer"));
            this.properties.put("FILL_VALUE", dasProps.get("zFill"));
            this.properties.put("VALID_MIN", dasProps.get("zValidMin"));
            this.properties.put("VALID_MAX", dasProps.get("zValidMax"));
            this.properties.put("SCALE_TYPE", dasProps.get("zScaleType"));
            this.properties.put("LABEL", dasProps.get("zLabel"));
        }

        public int rank() {
            return 3;
        }

        public int length() {
            return this.source.tableCount();
        }

        public int length(int i) {
            return this.source.tableEnd(i) - this.source.tableStart(i);
        }

        public int length(int i, int j) {
            return this.source.getYLength(i);
        }

        public double value(int i, int j, int k) {
            int ts = this.source.tableStart(i);
            return this.source.getDouble(ts + j, k, this.source.getZUnits());
        }

        public Object property(String name, int i) {
            if (name.equals("DEPEND_0")) {
                return new MultiTableXTagsDataSet(this.source, this.source.tableStart(i), this.source.tableEnd(i) - this.source.tableStart(i));
            }
            if (name.equals("DEPEND_1")) {
                return new YTagsDataSet(this.source, i);
            }
            return super.property(name, i);
        }
    }

    static class SimpleTable
    extends AbstractDataSet {
        TableDataSet source;

        SimpleTable(TableDataSet source) {
            if (source.tableCount() > 1) {
                throw new IllegalArgumentException("only simple tables are supported");
            }
            this.source = source;
            Map<String, Object> dasProps = DataSetAdapter.adaptSubstitutions(source.getProperties());
            this.properties.put("USER_PROPERTIES", dasProps);
            this.properties.put("UNITS", source.getZUnits());
            this.properties.put("LABEL", dasProps.get("zLabel"));
            this.properties.put("TITLE", dasProps.get("title"));
            XTagsDataSet xtags = new XTagsDataSet(source);
            this.properties.put("DEPEND_0", xtags);
            YTagsDataSet ytags = new YTagsDataSet(source, 0);
            this.properties.put("DEPEND_1", ytags);
            this.properties.put("QUBE", Boolean.TRUE);
            this.properties.put(DataSetAdapter.PROPERTY_SOURCE, source);
            DatumRange zRng = (DatumRange)dasProps.get("zRange");
            if (zRng != null) {
                this.properties.put("TYPICAL_MIN", zRng.min().value());
                this.properties.put("TYPICAL_MAX", zRng.max().value());
            }
            this.properties.put("RENDER_TYPE", dasProps.get("renderer"));
            this.properties.put("FILL_VALUE", dasProps.get("zFill"));
            this.properties.put("VALID_MIN", dasProps.get("zValidMin"));
            this.properties.put("VALID_MAX", dasProps.get("zValidMax"));
            this.properties.put("SCALE_TYPE", dasProps.get("zScaleType"));
            this.properties.put("LABEL", dasProps.get("zLabel"));
        }

        public int rank() {
            return 2;
        }

        public int length(int i) {
            return this.source.getYLength(0);
        }

        public double value(int i, int j) {
            return this.source.getDouble(i, j, this.source.getZUnits());
        }

        public int length() {
            return this.source.getXLength();
        }
    }

    static class YTagsDataSet
    extends AbstractDataSet {
        TableDataSet source;
        int table;

        YTagsDataSet(TableDataSet source, int table) {
            DatumRange yRng;
            this.source = source;
            this.table = table;
            this.properties.put("UNITS", source.getYUnits());
            this.properties.put("LABEL", source.getProperty("yLabel"));
            this.properties.put("SCALE_TYPE", source.getProperty("yScaleType"));
            Datum d = (Datum)source.getProperty("yTagWidth");
            if (d != null) {
                this.properties.put("CADENCE", DRank0DataSet.create((Datum)d));
            }
            if ((yRng = (DatumRange)source.getProperty("yRange")) != null) {
                this.properties.put("TYPICAL_MIN", yRng.min().value());
                this.properties.put("TYPICAL_MAX", yRng.max().value());
            }
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            return this.source.getYTagDouble(this.table, i, this.source.getYUnits());
        }

        public int length() {
            return this.source.tableCount() > 0 ? this.source.getYLength(this.table) : 99;
        }
    }

    static class Vector
    extends AbstractDataSet {
        VectorDataSet source;

        Vector(VectorDataSet source) {
            this(source, null);
        }

        private static Object hack(Map<String, Object> m, String k, String id) {
            if (id == null || id.isEmpty()) {
                return m.get(k);
            }
            return m.get(id + "." + k);
        }

        Vector(VectorDataSet source, String sPlaneID) {
            Datum d;
            Object obj;
            this.source = source;
            Map<String, Object> dasProps = DataSetAdapter.adaptSubstitutions(source.getProperties());
            this.properties.put("USER_PROPERTIES", dasProps);
            this.properties.put("TITLE", Vector.hack(dasProps, "title", sPlaneID));
            this.properties.put("UNITS", source.getYUnits());
            this.properties.put("LABEL", Vector.hack(dasProps, "yLabel", sPlaneID));
            this.properties.put("FORMAT", Vector.hack(dasProps, "yFormat", sPlaneID));
            XTagsDataSet xds = new XTagsDataSet(source);
            xds.putProperty("CACHE_TAG", Vector.hack(dasProps, "cacheTag", sPlaneID));
            this.properties.put("DEPEND_0", xds);
            this.properties.put(DataSetAdapter.PROPERTY_SOURCE, source);
            String syValid = (String)dasProps.get("valid_range");
            if (syValid != null) {
                try {
                    DatumRange yValid = DatumRangeUtil.parseDatumRange((String)syValid, (Units)source.getYUnits());
                    double val = yValid.min().doubleValue(source.getYUnits());
                    this.properties.put("VALID_MIN", val);
                    val = yValid.max().doubleValue(source.getYUnits());
                    this.properties.put("VALID_MAX", val);
                }
                catch (ParseException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            if ((obj = Vector.hack(dasProps, "yValidMin", sPlaneID)) != null) {
                if (obj instanceof Double) {
                    this.properties.put("VALID_MIN", (Double)obj);
                } else if (obj instanceof Datum) {
                    this.properties.put("VALID_MIN", ((Datum)obj).doubleValue(source.getYUnits()));
                } else {
                    logger.warning("property yValidMin should be type Double");
                }
            }
            if ((obj = Vector.hack(dasProps, "yValidMax", sPlaneID)) != null) {
                if (obj instanceof Double) {
                    this.properties.put("VALID_MAX", (Double)obj);
                } else if (obj instanceof Datum) {
                    this.properties.put("VALID_MAX", ((Datum)obj).doubleValue(source.getYUnits()));
                } else {
                    logger.warning("property yValidMax should be type Double");
                }
            }
            this.properties.put("FILL_VALUE", Vector.hack(dasProps, "yFill", sPlaneID));
            this.properties.put("SCALE_TYPE", Vector.hack(dasProps, "yScaleType", sPlaneID));
            this.properties.put("MONOTONIC", Vector.hack(dasProps, "yMonotonic", sPlaneID));
            this.properties.put("DESCRIPTION", Vector.hack(dasProps, "ySummary", sPlaneID));
            DatumRange yRng = (DatumRange)Vector.hack(dasProps, "yRange", sPlaneID);
            if (yRng != null) {
                try {
                    this.properties.put("TYPICAL_MIN", yRng.min().doubleValue(source.getYUnits()));
                    this.properties.put("TYPICAL_MAX", yRng.max().doubleValue(source.getYUnits()));
                }
                catch (InconvertibleUnitsException ex) {
                    logger.info("yRange has inconvertible units");
                }
            }
            if ((d = (Datum)Vector.hack(dasProps, "yTagWidth", sPlaneID)) != null) {
                this.properties.put("CADENCE", DRank0DataSet.create((Datum)d));
            }
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            return this.source.getDouble(i, this.source.getYUnits());
        }

        public int length() {
            return this.source.getXLength();
        }
    }

    static class XTagsDataSet
    extends AbstractDataSet {
        DataSet source;

        XTagsDataSet(DataSet source) {
            Object o;
            this.source = source;
            this.properties.put("UNITS", source.getXUnits());
            this.properties.put("LABEL", source.getProperty("xLabel"));
            Datum d = (Datum)source.getProperty("xTagWidth");
            if (d != null) {
                this.properties.put("CADENCE", DRank0DataSet.create((Datum)d));
            }
            if ((o = source.getProperty("xMonotonic")) != null) {
                this.properties.put("MONOTONIC", o);
            }
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            return this.source.getXTagDouble(i, this.source.getXUnits());
        }

        public int length() {
            return this.source.getXLength();
        }
    }

    static class MultiTableXTagsDataSet
    extends AbstractDataSet {
        DataSet source;
        int offset;
        int length;

        MultiTableXTagsDataSet(DataSet source, int offset, int length) {
            Datum xTagWidth;
            this.source = source;
            this.offset = offset;
            this.length = length;
            this.properties.put("UNITS", source.getXUnits());
            this.properties.put("LABEL", source.getProperty("xLabel"));
            Object o = source.getProperty("xMonotonic");
            if (o != null) {
                this.properties.put("MONOTONIC", o);
            }
            if ((xTagWidth = (Datum)source.getProperty("xTagWidth")) != null) {
                this.properties.put("CADENCE", DataSetUtil.asDataSet((Datum)xTagWidth));
            }
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            return this.source.getXTagDouble(i + this.offset, this.source.getXUnits());
        }

        public int length() {
            return this.length;
        }
    }

    private static class AdapterPDim {
        String sId;
        Map<String, String> vars = new HashMap<String, String>();

        AdapterPDim(String _sId) {
            this.sId = _sId;
        }
    }
}

