/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.DasException;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;

public class KernelRebinner
implements DataSetRebinner {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.data.rebinner");
    Type type;

    public KernelRebinner(Type t) {
        this.type = t;
    }

    public static QDataSet makeFlatKernel(RebinDescriptor ddX, RebinDescriptor ddY, int nx, int ny) {
        int i;
        DDataSet k = DDataSet.createRank2((int)nx, (int)ny);
        for (i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                k.putValue(i, j, 1.0);
            }
        }
        for (i = 0; i < nx; ++i) {
            k.putValue(i, 0, 0.3);
            k.putValue(i, 1, 0.6);
            k.putValue(i, ny - 1, 0.3);
            k.putValue(i, ny - 2, 0.6);
        }
        for (int j = 1; j < ny - 1; ++j) {
            k.putValue(0, j, 0.3);
            k.putValue(1, j, 0.6);
            k.putValue(nx - 1, j, 0.3);
            k.putValue(nx - 2, j, 0.6);
        }
        return k;
    }

    public static QDataSet makeConeKernel(RebinDescriptor ddX, RebinDescriptor ddY, int nx, int ny) {
        double nx2 = nx / 2;
        double ny2 = ny / 2;
        DDataSet kernel = DDataSet.createRank2((int)nx, (int)ny);
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                double v = Math.max(1.0 - Math.sqrt(Math.pow(Math.abs(nx2 - (double)i) / nx2, 2.0) + Math.pow(Math.abs(ny2 - (double)j) / ny2, 2.0)), 0.0);
                kernel.putValue(i, j, v);
            }
        }
        int nx14 = nx / 4;
        int ny14 = ny / 4;
        int nx34 = (int)Math.ceil((double)nx - (double)nx / 4.0);
        int ny34 = (int)Math.ceil((double)ny - (double)ny / 4.0);
        DDataSet mask = DDataSet.createRank2((int)nx, (int)ny);
        for (int i = nx14; i < nx34; ++i) {
            for (int j = ny14; j < ny34; ++j) {
                mask.putValue(i, j, 1.0);
            }
        }
        mask.putProperty("NAME", (Object)"mask");
        kernel.putProperty("WEIGHTS", (Object)mask);
        kernel.putProperty("NAME", (Object)"bilinear");
        return kernel;
    }

    public static QDataSet makeCircleKernel(RebinDescriptor ddX, RebinDescriptor ddY, int nx, int ny) {
        double nx2 = nx / 2;
        double ny2 = ny / 2;
        double nx4 = nx / 4;
        DDataSet k = DDataSet.createRank2((int)nx, (int)ny);
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                double r = Math.sqrt(Math.pow(Math.abs(nx2 - (double)i), 2.0) + Math.pow(Math.abs(ny2 - (double)j), 2.0));
                if (r > nx4 && r < nx2) {
                    k.putValue(i, j, 1.0);
                    continue;
                }
                k.putValue(i, j, 0.0);
            }
        }
        return k;
    }

    private QDataSet makeKernel(RebinDescriptor ddX, RebinDescriptor ddY, Datum xwidth, Datum ywidth) {
        QDataSet k;
        int ny;
        int nx;
        switch (this.type) {
            case flat: {
                try {
                    Datum xx = UnitsUtil.isRatiometric((Units)xwidth.getUnits()) ? ddX.binStart(0).add(ddX.binStart(0).multiply(1.0 + xwidth.convertTo(Units.percentIncrease).value() / 100.0)) : ddX.binStart(0).add(xwidth);
                    nx = 2 + Math.max(1, ddX.whichBin(xx.doubleValue(xx.getUnits()), xx.getUnits()));
                }
                catch (InconvertibleUnitsException ex) {
                    nx = 2;
                }
                try {
                    Datum yy;
                    if (UnitsUtil.isRatiometric((Units)ywidth.getUnits())) {
                        ywidth.convertTo(Units.percentIncrease);
                        yy = ddY.binStart(0).add(ddY.binStart(0).multiply(1.0 + ywidth.convertTo(Units.percentIncrease).value() / 100.0));
                    } else {
                        yy = ddY.binStart(0).add(ywidth);
                    }
                    ny = 2 + Math.max(1, ddY.whichBin(yy.doubleValue(yy.getUnits()), yy.getUnits()));
                }
                catch (InconvertibleUnitsException ex) {
                    ny = 2;
                }
                k = KernelRebinner.makeFlatKernel(ddX, ddY, nx, ny);
                break;
            }
            case cone: {
                try {
                    Datum xx = UnitsUtil.isRatiometric((Units)xwidth.getUnits()) ? ddX.binStart(0).add(ddX.binStart(0).multiply(1.0 + xwidth.convertTo(Units.percentIncrease).value() / 100.0)) : ddX.binStart(0).add(xwidth);
                    nx = 2 + (int)Math.ceil(2.0 * (double)Math.max(1, ddX.whichBin(xx.doubleValue(xx.getUnits()), xx.getUnits())));
                }
                catch (InconvertibleUnitsException ex) {
                    nx = 1;
                }
                try {
                    Datum yy;
                    if (UnitsUtil.isRatiometric((Units)ywidth.getUnits())) {
                        ywidth.convertTo(Units.percentIncrease);
                        yy = ddY.binStart(0).add(ddY.binStart(0).multiply(1.0 + ywidth.convertTo(Units.percentIncrease).value() / 100.0));
                    } else {
                        yy = ddY.binStart(0).add(ywidth);
                    }
                    ny = 2 + (int)Math.ceil(2.0 * (double)Math.max(1, ddY.whichBin(yy.doubleValue(yy.getUnits()), yy.getUnits())));
                }
                catch (InconvertibleUnitsException ex) {
                    ny = 2;
                }
                k = KernelRebinner.makeConeKernel(ddX, ddY, nx, ny);
                break;
            }
            case disk: {
                try {
                    Datum xx = UnitsUtil.isRatiometric((Units)xwidth.getUnits()) ? ddX.binStart(0).add(ddX.binStart(0).multiply(1.0 + xwidth.convertTo(Units.percentIncrease).value() / 100.0)) : ddX.binStart(0).add(xwidth);
                    nx = 2 + (int)(2.0 * (double)Math.max(1, ddX.whichBin(xx.doubleValue(xx.getUnits()), xx.getUnits())));
                }
                catch (InconvertibleUnitsException ex) {
                    nx = 2;
                }
                try {
                    Datum yy;
                    if (UnitsUtil.isRatiometric((Units)ywidth.getUnits())) {
                        ywidth.convertTo(Units.percentIncrease);
                        yy = ddY.binStart(0).add(ddY.binStart(0).multiply(1.0 + ywidth.convertTo(Units.percentIncrease).value() / 100.0));
                    } else {
                        yy = ddY.binStart(0).add(ywidth);
                    }
                    ny = 2 + (int)(2.0 * (double)Math.max(1, ddY.whichBin(yy.doubleValue(yy.getUnits()), yy.getUnits())));
                }
                catch (InconvertibleUnitsException ex) {
                    ny = 2;
                }
                k = KernelRebinner.makeCircleKernel(ddX, ddY, nx, ny);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad type:" + (Object)((Object)this.type));
            }
        }
        return Ops.link((QDataSet)Ops.linspace((Object)xwidth.negative(), (Object)xwidth, (int)nx), (QDataSet)Ops.linspace((Object)ywidth.negative(), (Object)ywidth, (int)ny), (QDataSet)k);
    }

    private void applyKernel(QDataSet kernel, QDataSet mask, int x, int y, double value, double weight, DDataSet ss, DDataSet ww, DDataSet mm) {
        int nx = ss.length();
        int ny = ss.length(0);
        int dx0 = kernel.length() / 2;
        int dy0 = kernel.length(0) / 2;
        int x0 = x - dx0;
        int x1 = x0 + kernel.length();
        int y0 = y - dy0;
        int y1 = y0 + kernel.length(0);
        int xbase = x0;
        int ybase = y0;
        if (x0 < 0) {
            x0 = 0;
        } else if (x0 > nx) {
            x0 = nx;
        }
        if (x1 < 0) {
            x1 = 0;
        } else if (x1 > nx) {
            x1 = nx + 1;
        }
        if (y0 < 0) {
            y0 = 0;
        } else if (y0 > ny) {
            y0 = ny;
        }
        if (y1 < 0) {
            y1 = 0;
        } else if (y1 > ny) {
            y1 = ny + 1;
        }
        for (int i = x0; i < x1; ++i) {
            for (int j = y0; j < y1; ++j) {
                try {
                    int ik = i - xbase;
                    int jk = j - ybase;
                    double w = weight * kernel.value(ik, jk);
                    ss.addValue(i, j, value * w);
                    ww.addValue(i, j, w);
                    mm.addValue(i, j, mask.value(ik, jk) * w);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public QDataSet rebin(QDataSet ds, RebinDescriptor ddX, RebinDescriptor ddY, RebinDescriptor ddZ) throws IllegalArgumentException, DasException {
        QDataSet wds;
        boolean isBundle;
        logger.finest("enter QernalTableRebinner.rebin");
        if (ds == null) {
            throw new NullPointerException("null data set");
        }
        long t0 = System.currentTimeMillis();
        boolean bl = isBundle = SemanticOps.isBundle((QDataSet)ds) && ds.length(0) < 4;
        if (ds.rank() == 2 && !isBundle) {
            ds = Ops.join(null, (QDataSet)ds);
        }
        int nx = ddX.numberOfBins();
        int ny = ddY.numberOfBins();
        DDataSet rebinData = DDataSet.createRank2((int)nx, (int)ny);
        DDataSet rebinWeights = DDataSet.createRank2((int)nx, (int)ny);
        DDataSet rebinMask = DDataSet.createRank2((int)nx, (int)ny);
        if (ds.rank() == 1 || ds.rank() == 2 && isBundle) {
            QDataSet zds;
            QDataSet xds;
            QDataSet yds;
            if (ds.rank() == 1) {
                yds = ds;
                xds = SemanticOps.xtagsDataSet((QDataSet)yds);
                zds = (QDataSet)ds.property("PLANE_0");
                if (zds == null) {
                    zds = Ops.zeros((int)yds.length());
                }
            } else {
                zds = Ops.unbundle((QDataSet)ds, (int)(ds.length(0) - 1));
                xds = SemanticOps.xtagsDataSet((QDataSet)ds);
                yds = SemanticOps.ytagsDataSet((QDataSet)ds);
            }
            wds = Ops.valid((QDataSet)zds);
            RankZeroDataSet xBinWidth = DataSetUtil.guessCadenceNew((QDataSet)xds, (QDataSet)zds);
            RankZeroDataSet yBinWidth = DataSetUtil.guessCadenceNew((QDataSet)yds, (QDataSet)zds);
            if (xBinWidth == null) {
                xBinWidth = xds instanceof IndexGenDataSet ? Ops.dataset((Object)1) : Ops.dataset((Object)ddX.binWidthDatum());
            }
            if (yBinWidth == null) {
                yBinWidth = yds instanceof IndexGenDataSet ? Ops.dataset((Object)1) : Ops.dataset((Object)ddY.binWidthDatum());
            }
            Units xUnits = SemanticOps.getUnits((QDataSet)xds);
            Units yUnits = SemanticOps.getUnits((QDataSet)yds);
            logger.log(Level.FINEST, "Allocating rebinData and rebinWeights: {0} x {1}", new Object[]{nx, ny});
            QDataSet kernel = this.makeKernel(ddX, ddY, Ops.datum((Object)xBinWidth), Ops.datum((Object)yBinWidth));
            QDataSet mask = DataSetUtil.weightsDataSet((QDataSet)kernel);
            for (int i = 0; i < xds.length(); ++i) {
                int ibiny;
                int ibinx = ddX.whichBin(xds.value(i), xUnits);
                if (ibinx == -1 || (ibiny = ddY.whichBin(yds.value(i), yUnits)) == -1) continue;
                double z = zds.value(i);
                double w = wds.value(i);
                this.applyKernel(kernel, mask, ibinx, ibiny, z, w, rebinData, rebinWeights, rebinMask);
            }
        } else {
            int nTables = ds.length();
            for (int iTable = 0; iTable < nTables; ++iTable) {
                RankZeroDataSet yBinWidth;
                QDataSet zds = ds.slice(iTable);
                wds = DataSetUtil.weightsDataSet((QDataSet)zds);
                QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)zds);
                QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)zds);
                RankZeroDataSet xBinWidth = DataSetUtil.guessCadenceNew((QDataSet)xds, (QDataSet)zds);
                if (xBinWidth == null) {
                    xBinWidth = DataSetUtil.guessCadence((QDataSet)xds, (QDataSet)zds);
                }
                if (yds.rank() == 1) {
                    yBinWidth = DataSetUtil.guessCadenceNew((QDataSet)yds, (QDataSet)zds.slice(0));
                    if (yBinWidth == null) {
                        yBinWidth = DataSetUtil.guessCadence((QDataSet)yds, (QDataSet)zds.slice(0));
                    }
                } else if (yds.rank() == 2 && "min,max".equals(yds.property("BINS_1"))) {
                    yBinWidth = Ops.reduceMax((QDataSet)Ops.subtract((QDataSet)Ops.slice1((QDataSet)yds, (int)1), (QDataSet)Ops.slice1((QDataSet)yds, (int)0)), (int)0);
                    yds = Ops.reduceMean((QDataSet)yds, (int)1);
                } else {
                    yBinWidth = DataSetUtil.guessCadenceNew((QDataSet)yds.slice(0), (QDataSet)zds.slice(0));
                    if (yBinWidth == null) {
                        yBinWidth = DataSetUtil.guessCadence((QDataSet)yds.slice(0), (QDataSet)zds.slice(0));
                    }
                }
                if (xBinWidth == null) {
                    xBinWidth = xds instanceof IndexGenDataSet ? Ops.dataset((Object)1) : Ops.dataset((Object)ddX.binWidthDatum());
                }
                if (yBinWidth == null) {
                    yBinWidth = yds instanceof IndexGenDataSet ? Ops.dataset((Object)1) : Ops.dataset((Object)ddY.binWidthDatum());
                }
                Units xUnits = SemanticOps.getUnits((QDataSet)xds);
                Units yUnits = SemanticOps.getUnits((QDataSet)yds);
                logger.log(Level.FINEST, "Allocating rebinData and rebinWeights: {0} x {1}", new Object[]{nx, ny});
                QDataSet kernel = this.makeKernel(ddX, ddY, Ops.datum((Object)xBinWidth), Ops.datum((Object)yBinWidth));
                QDataSet mask = DataSetUtil.weightsDataSet((QDataSet)kernel);
                int[] ibiny = null;
                QDataSet ydss = null;
                if (yds.rank() == 1) {
                    ibiny = new int[yds.length()];
                    for (int j = 0; j < ibiny.length; ++j) {
                        ibiny[j] = ddY.whichBin(yds.value(j), yUnits);
                    }
                } else if (yds.rank() == 2) {
                    ydss = yds;
                } else {
                    throw new IllegalArgumentException("yds rank must be 1 or 2");
                }
                for (int i = 0; i < xds.length(); ++i) {
                    int j;
                    int ibinx = ddX.whichBin(xds.value(i), xUnits);
                    if (ibinx == -1) continue;
                    if (ydss != null) {
                        yds = ydss.slice(i);
                        ibiny = new int[yds.length()];
                        for (j = 0; j < ibiny.length; ++j) {
                            ibiny[j] = ddY.whichBin(yds.value(j), yUnits);
                        }
                    }
                    assert (ibiny != null);
                    for (j = 0; j < ibiny.length; ++j) {
                        if (ibiny[j] == -1) continue;
                        double z = zds.value(i, j);
                        double w = wds.value(i, j);
                        this.applyKernel(kernel, mask, ibinx, ibiny[j], z, w, rebinData, rebinWeights, rebinMask);
                    }
                }
            }
        }
        logger.finest("normalize sums by weights");
        for (int i = 0; i < nx; ++i) {
            QDataSet w1 = rebinWeights.slice(i);
            QDataSet m1 = rebinMask.slice(i);
            for (int j = 0; j < ny; ++j) {
                double w11 = w1.value(j);
                double m11 = m1.value(j);
                if (w11 > 0.0 && m11 > 0.0) {
                    rebinData.putValue(i, j, rebinData.value(i, j) / w11);
                    continue;
                }
                rebinData.putValue(i, j, Double.NaN);
            }
        }
        rebinData.putProperty("WEIGHTS", (Object)rebinWeights);
        logger.finest("create new DataSet");
        QDataSet xtags = Ops.dataset((Object)ddX.binCentersDV());
        QDataSet ytags = Ops.dataset((Object)ddY.binCentersDV());
        logger.log(Level.FINER, "time to complete (ms): {0}", System.currentTimeMillis() - t0);
        logger.finest("done, QernalTableRebinner.rebin");
        return Ops.link((QDataSet)xtags, (QDataSet)ytags, (QDataSet)rebinData);
    }

    public static enum Type {
        flat,
        cone,
        disk;

    }
}

