/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import org.das2.dataset.DataSetConsumer;
import org.das2.event.CrossHairRenderer;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.MouseModule;
import org.das2.event.MousePointSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.qds.QDataSet;

public class CrossHairMouseModule
extends MouseModule {
    private DasAxis xaxis;
    private DasAxis yaxis;
    private DasPlot plot;
    protected DataPointSelectionEvent de;
    DataSetConsumer dataSetConsumer;
    private EventListenerList listenerList = new EventListenerList();

    public CrossHairMouseModule(DasPlot parent, DasAxis xaxis, DasAxis yaxis) {
        this(parent, null, xaxis, yaxis);
    }

    public CrossHairMouseModule(DasPlot parent, DataSetConsumer dataSetConsumer, DasAxis xAxis, DasAxis yAxis) {
        super(parent, new CrossHairRenderer(parent, dataSetConsumer, xAxis, yAxis), "Crosshair Digitizer");
        this.plot = parent;
        this.dataSetConsumer = dataSetConsumer;
        this.xaxis = xAxis;
        this.yaxis = yAxis;
        this.de = new DataPointSelectionEvent(this, null, null);
    }

    public static CrossHairMouseModule create(DasPlot parent) {
        DasAxis xaxis = null;
        DasAxis yaxis = null;
        return new CrossHairMouseModule(parent, null, xaxis, yaxis);
    }

    private QDataSet getContextDataSet() {
        Renderer[] rends;
        Object ds = this.dataSetConsumer != null ? this.dataSetConsumer.getConsumedDataSet() : ((rends = ((DasPlot)this.parent).getRenderers()).length > 0 ? rends[0].getConsumedDataSet() : null);
        return ds;
    }

    protected DataPointSelectionEvent getDataPointSelectionEvent(MousePointSelectionEvent e) {
        this.de.setDataSet(this.getContextDataSet());
        DasAxis xa = this.xaxis == null ? this.plot.getXAxis() : this.xaxis;
        DasAxis ya = this.yaxis == null ? this.plot.getYAxis() : this.yaxis;
        this.de.set(xa.invTransform(e.getX()), ya.invTransform(e.getY()));
        return this.de;
    }

    @Override
    public void mousePointSelected(MousePointSelectionEvent e) {
        this.fireDataPointSelectionListenerDataPointSelected(this.getDataPointSelectionEvent(e));
    }

    public void addDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList.add(DataPointSelectionListener.class, listener);
    }

    public void removeDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList.remove(DataPointSelectionListener.class, listener);
    }

    protected void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)listeners[i + 1]).dataPointSelected(event);
        }
    }

    @Override
    public String getDirections() {
        return "Press P to pin, C to copy data to clipboard";
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        logger.log(Level.FINE, "keyTyped {0} {1}", new Object[]{Character.valueOf(keyEvent.getKeyChar()), keyEvent.isMetaDown()});
        if (keyEvent.getKeyChar() == 'c') {
            CrossHairRenderer r = (CrossHairRenderer)this.dragRenderer;
            String text = r.label.replaceAll("!c", " ");
            StringSelection stringSelection = new StringSelection(text);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, (clipboard1, contents) -> {});
            logger.log(Level.FINE, "copied to mouse buffer: {0}", text);
        }
    }
}

