/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.AWTException;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import org.das2.dataset.DataSetConsumer;
import org.das2.datum.Datum;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.DragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.MousePointSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;

public class DataPointSelectorMouseModule
extends MouseModule {
    DasAxis xaxis;
    DasAxis yaxis;
    EventListenerList listenerList = new EventListenerList();
    MousePointSelectionEvent lastMousePoint;
    private boolean dragEvents = true;
    private boolean keyEvents = true;
    private boolean releaseEvents = false;

    public DataPointSelectorMouseModule(DasPlot parent, DataSetConsumer consumer, DragRenderer dragRenderer, String label) {
        super(parent, dragRenderer, label);
        this.xaxis = parent.getXAxis();
        this.yaxis = parent.getYAxis();
    }

    private DataPointSelectionEvent getDataPointSelectionEvent(MousePointSelectionEvent e) {
        Datum x = this.xaxis.invTransform(e.getX());
        Datum y = this.yaxis.invTransform(e.getY());
        DataPointSelectionEvent de = new DataPointSelectionEvent(this, x, y);
        return de;
    }

    @Override
    public void mousePointSelected(MousePointSelectionEvent e) {
        this.lastMousePoint = e;
        if (this.keyEvents) {
            this.parent.requestFocus();
        }
        if (this.dragEvents) {
            this.fireDataPointSelectionListenerDataPointSelected(this.getDataPointSelectionEvent(e));
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.lastMousePoint != null) {
            if (keyCode == 37 || keyCode == 39 || keyCode == 38 || keyCode == 40) {
                boolean x = false;
                boolean y = false;
                try {
                    int xOff = this.parent.getLocationOnScreen().x - this.parent.getX();
                    int yOff = this.parent.getLocationOnScreen().y - this.parent.getY();
                    Robot robot = new Robot();
                    switch (keyCode) {
                        case 37: {
                            robot.mouseMove(this.lastMousePoint.getX() + xOff - 1, this.lastMousePoint.getY() + yOff);
                            break;
                        }
                        case 39: {
                            robot.mouseMove(this.lastMousePoint.getX() + xOff + 1, this.lastMousePoint.getY() + yOff);
                            break;
                        }
                        case 38: {
                            robot.mouseMove(this.lastMousePoint.getX() + xOff, this.lastMousePoint.getY() + yOff - 1);
                            break;
                        }
                        case 40: {
                            robot.mouseMove(this.lastMousePoint.getX() + xOff, this.lastMousePoint.getY() + yOff + 1);
                            break;
                        }
                        default: {
                            logger.log(Level.FINE, "keypress: {0}", keyCode);
                            break;
                        }
                    }
                }
                catch (AWTException e1) {
                    logger.log(Level.SEVERE, null, e1);
                }
            } else {
                DataPointSelectionEvent dpse = this.getDataPointSelectionEvent(this.lastMousePoint);
                HashMap<String, String> planes = new HashMap<String, String>();
                planes.put("keyChar", String.valueOf(e.getKeyChar()));
                dpse = new DataPointSelectionEvent(this, dpse.getX(), dpse.getY(), planes);
                this.fireDataPointSelectionListenerDataPointSelected(dpse);
            }
        }
    }

    public void addDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList.add(DataPointSelectionListener.class, listener);
    }

    public void removeDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList.remove(DataPointSelectionListener.class, listener);
    }

    protected void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)listeners[i + 1]).dataPointSelected(event);
        }
    }

    public boolean isDragEvents() {
        return this.dragEvents;
    }

    public void setDragEvents(boolean dragEvents) {
        this.dragEvents = dragEvents;
    }

    public boolean isKeyEvents() {
        return this.keyEvents;
    }

    public void setKeyEvents(boolean keyEvents) {
        this.keyEvents = keyEvents;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.releaseEvents) {
            this.fireDataPointSelectionListenerDataPointSelected(this.getDataPointSelectionEvent(this.lastMousePoint));
        }
    }

    public boolean isReleaseEvents() {
        return this.releaseEvents;
    }

    public void setReleaseEvents(boolean releaseEvents) {
        this.releaseEvents = releaseEvents;
    }
}

