/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.DisplayDataMouseModuleGUI;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.QDataSetTableModel;

public class DisplayDataMouseModule
extends MouseModule {
    private static final String LABEL = "Display Data";
    private final DasPlot plot;
    private JFrame myFrame;
    private DisplayDataMouseModuleGUI myPanel2;
    private Renderer[] rends;
    private Renderer currentRenderer;
    private DatumRange xrange;
    private DatumRange yrange;
    private QDataSet theData;
    private final ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (DisplayDataMouseModule.this.rends == null) {
                return;
            }
            int i = DisplayDataMouseModule.this.myPanel2.getRenderersComboBox().getSelectedIndex();
            if (i < DisplayDataMouseModule.this.rends.length) {
                DisplayDataMouseModule.this.setDataSet(DisplayDataMouseModule.this.rends[i].getDataSet(), DisplayDataMouseModule.this.xrange, DisplayDataMouseModule.this.yrange);
            }
            DisplayDataMouseModule.this.currentRenderer = DisplayDataMouseModule.this.rends[i];
        }
    };
    private boolean yclip = true;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public DisplayDataMouseModule(DasPlot parent) {
        super(parent, new BoxRenderer(parent), LABEL);
        this.plot = parent;
    }

    private void maybeCreateFrame(Object source) {
        if (this.myFrame == null) {
            Window w;
            this.myFrame = new JFrame(LABEL);
            if (source != null && source instanceof JComponent && (w = SwingUtilities.getWindowAncestor((JComponent)source)) instanceof JFrame) {
                this.myFrame.setIconImage(((JFrame)w).getIconImage());
            }
            this.myPanel2 = new DisplayDataMouseModuleGUI();
            final JPopupMenu pm = new JPopupMenu();
            pm.add(new CopyAction(this.myPanel2.getMyEdit()));
            this.myPanel2.getMyEdit().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.doPopup(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.doPopup(e);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.doPopup(e);
                    }
                }

                protected void doPopup(MouseEvent e) {
                    pm.show(e.getComponent(), e.getX(), e.getY());
                }
            });
            this.myPanel2.getRenderersComboBox().addItemListener(this.itemListener);
            this.myPanel2.getYClipCheckBox().setSelected(this.yclip);
            this.myPanel2.getYClipCheckBox().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DisplayDataMouseModule.this.yclip = DisplayDataMouseModule.this.myPanel2.getYClipCheckBox().isSelected();
                    int i = DisplayDataMouseModule.this.myPanel2.getRenderersComboBox().getSelectedIndex();
                    if (i < DisplayDataMouseModule.this.rends.length) {
                        DisplayDataMouseModule.this.setDataSet(DisplayDataMouseModule.this.rends[i].getDataSet(), DisplayDataMouseModule.this.xrange, DisplayDataMouseModule.this.yrange);
                    }
                }
            });
            this.myPanel2.getMyEdit().getSelectionModel().addListSelectionListener(e -> this.updateRecordCountMessage());
            this.myFrame.getContentPane().add(this.myPanel2);
            this.myFrame.pack();
            this.myFrame.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this.plot));
        }
    }

    private String unitsStr(Units u) {
        return u == Units.dimensionless ? "" : "(" + u.toString() + ")";
    }

    @Override
    public void mouseRangeSelected(MouseDragEvent e0) {
        if (!(e0 instanceof MouseBoxEvent)) {
            throw new IllegalArgumentException("Event should be MouseBoxEvent");
        }
        MouseBoxEvent e = (MouseBoxEvent)e0;
        if (Point.distance(e.getXMaximum(), e.getYMinimum(), e.getXMaximum(), e.getYMaximum()) < 5.0) {
            return;
        }
        this.maybeCreateFrame(e0.getSource());
        this.xrange = this.plot.getXAxis().invTransform(e.getXMaximum(), e.getXMinimum());
        this.yrange = this.plot.getYAxis().invTransform(e.getYMinimum(), e.getYMaximum());
        this.myPanel2.getYClipCheckBox().setText("Show only data where Y is within " + this.yrange);
        final Renderer[] rends1 = this.plot.getRenderers();
        this.myPanel2.getInstructionsLabel().setText("The plot contains " + rends1.length + " renderer" + (rends1.length > 1 ? "s" : "") + ".");
        if (rends1.length == 0) {
            return;
        }
        this.myFrame.setVisible(true);
        String[] rlabels = new String[rends1.length];
        int firstActive = -1;
        for (int i = 0; i < rends1.length; ++i) {
            String label = rends1[i].getLegendLabel();
            if (label == null || label.equals("")) {
                label = "Renderer " + i;
            }
            if (!rends1[i].isActive()) {
                label = label + " (not visible)";
            } else if (firstActive == -1) {
                firstActive = i;
            }
            QDataSet ds = rends1[i].getDataSet();
            if (ds != null) {
                label = label + ": " + ds.toString();
            }
            rlabels[i] = label;
        }
        if (firstActive == -1) {
            firstActive = 0;
        }
        if (this.currentRenderer == null) {
            this.currentRenderer = rends1[firstActive];
        }
        int icurrent = -1;
        for (int i = 0; i < rends1.length; ++i) {
            Renderer r = rends1[i];
            if (this.currentRenderer != r) continue;
            icurrent = i;
        }
        if (icurrent == -1) {
            this.currentRenderer = rends1[firstActive];
            icurrent = firstActive;
        }
        this.rends = rends1;
        this.myPanel2.getRenderersComboBox().setModel(new DefaultComboBoxModel<String>(rlabels));
        this.myPanel2.getRenderersComboBox().setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index > -1 && index < rends1.length) {
                    label.setIcon(rends1[index].getListIcon());
                } else {
                    label.setIcon(null);
                }
                return label;
            }
        });
        this.myPanel2.getRenderersComboBox().setSelectedIndex(icurrent);
        this.setDataSet(this.currentRenderer.getDataSet(), this.xrange, this.yrange);
    }

    private void showMessageInTable(JTable t, final String message) {
        DefaultTableModel result = new DefaultTableModel(1, 1){

            @Override
            public Object getValueAt(int row, int col) {
                return message;
            }
        };
        t.setModel(result);
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        TableColumn c = new TableColumn(0);
        c.setHeaderValue("");
        c.setPreferredWidth(250);
        tcm.addColumn(c);
        t.setColumnModel(tcm);
    }

    private void setDataSet(QDataSet ds, DatumRange xrange, DatumRange yrange) {
        TableColumnModel tcm;
        QDataSetTableModel tm;
        DatumRange yrng;
        Object object = yrng = this.isYclip() ? yrange : null;
        if (ds == null) {
            this.showMessageInTable(this.myPanel2.getMyEdit(), "no dataset");
            return;
        }
        if (ds.rank() > 2) {
            QDataSet ds2 = SemanticOps.getSimpleTableContaining((QDataSet)ds, (Datum)xrange.min(), (Datum)yrange.min());
            if (ds2 == null) {
                this.showMessageInTable(this.myPanel2.getMyEdit(), "data cannot be displayed");
                return;
            }
            ds = ds2;
        }
        try {
            QDataSet tds;
            QDataSet dep0;
            boolean isQube = DataSetUtil.isQube((QDataSet)ds);
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
            if (dep1 != null && dep1.rank() == 2) {
                isQube = false;
            }
            if ((dep0 = (QDataSet)(tds = isQube ? SemanticOps.trim((QDataSet)ds, (DatumRange)xrange, (DatumRange)yrng) : SemanticOps.trim((QDataSet)ds, (DatumRange)xrange, null)).property("DEPEND_0")) != null && dep0.length() > 0 && Ops.gt((Object)dep0.slice(dep0.length() - 1), (Object)xrange.max()).value() > 0.0) {
                tds = tds.trim(0, tds.length() - 1);
            }
            tm = new QDataSetTableModel(tds);
            tcm = tm.getTableColumnModel();
            if (dep1 != null && dep1.rank() == 2) {
                this.myPanel2.getMyEdit().getTableHeader().setToolTipText("Column labels reported are from the first record");
            }
            this.theData = tds;
            this.updateRecordCountMessage();
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            tm = new QDataSetTableModel(ds);
            tcm = tm.getTableColumnModel();
            this.myPanel2.getMessageLabel().setText(ex.getMessage());
        }
        this.myPanel2.getMyEdit().setModel((TableModel)tm);
        this.myPanel2.getMyEdit().setColumnModel(tcm);
        this.myPanel2.getMyEdit().setRowSorter(QDataSetTableModel.getRowSorter((TableModel)tm));
    }

    public void updateRecordCountMessage() {
        String message;
        QDataSet tds = this.theData;
        if (tds == null) {
            message = "no data";
        } else if (tds.rank() == 1) {
            message = "" + tds.length() + " records.  Right-click to copy data to clipboard.";
        } else if (tds.length() > 0) {
            int[] qube = DataSetUtil.qubeDims((QDataSet)tds);
            int[] qube1 = DataSetUtil.qubeDims((QDataSet)tds.slice(0));
            message = qube != null ? "" + tds.length() + " records, each is " + DataSetUtil.toString((int[])qube1) : "" + tds.length() + " records, first is " + DataSetUtil.toString((int[])qube1);
        } else {
            message = "no records";
        }
        int nselect = this.myPanel2.getMyEdit().getSelectedRows().length;
        if (nselect > 0) {
            message = message + " (" + nselect + " selected)";
        }
        this.myPanel2.getMessageLabel().setText(message);
    }

    @Override
    public String getListLabel() {
        return this.getLabel();
    }

    @Override
    public Icon getListIcon() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/icons/showDataMouseModule.png"));
        return icon;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isYclip() {
        return this.yclip;
    }

    public void setYclip(boolean yclip) {
        boolean oldYclip = this.yclip;
        this.yclip = yclip;
        this.propertyChangeSupport.firePropertyChange("yclip", oldYclip, yclip);
    }

    private static final class CopyAction
    extends AbstractAction {
        private final JTable table;

        public CopyAction(JTable table) {
            this.table = table;
            this.putValue("Name", "Copy");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringBuilder build = new StringBuilder();
            int[] rows = this.table.getSelectedRows();
            int[] cols = this.table.getSelectedColumns();
            for (int j = 0; j < rows.length; ++j) {
                if (j > 0) {
                    build.append("\n");
                }
                for (int i = 0; i < cols.length; ++i) {
                    if (i > 0) {
                        build.append(",");
                    }
                    build.append(this.table.getValueAt(rows[j], cols[i]));
                }
            }
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(new CellTransferable(build.toString()), null);
        }
    }

    public static class CellTransferable
    implements Transferable {
        public static final DataFlavor CELL_DATA_FLAVOR = DataFlavor.stringFlavor;
        private final Object cellValue;

        public CellTransferable(Object cellValue) {
            this.cellValue = cellValue;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{CELL_DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return CELL_DATA_FLAVOR.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.cellValue;
        }
    }
}

