/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.event.Gesture;
import org.das2.event.HorizontalRangeGesturesRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.event.MouseRangeSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;

public class HorizontalRangeSelectorMouseModule
extends MouseModule {
    DasAxis axis;
    long t0;
    long tbirth;
    private EventListenerList listenerList = new EventListenerList();

    public HorizontalRangeSelectorMouseModule(DasCanvasComponent parent, DasAxis axis) {
        super(parent, new HorizontalRangeGesturesRenderer(parent), "Zoom X");
        if (!axis.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not horizontal");
        }
        this.axis = axis;
    }

    public static HorizontalRangeSelectorMouseModule create(DasPlot parent) {
        HorizontalRangeSelectorMouseModule result = new HorizontalRangeSelectorMouseModule(parent, parent.getXAxis());
        return result;
    }

    @Override
    public void mouseRangeSelected(MouseDragEvent e0) {
        if (!e0.isGesture()) {
            if (!(e0 instanceof MouseRangeSelectionEvent)) {
                throw new IllegalArgumentException("Event should be MouseRangeSelectionEvent");
            }
            MouseRangeSelectionEvent e = (MouseRangeSelectionEvent)e0;
            DatumRange dr = this.axis.invTransform(e.getMinimum(), e.getMaximum());
            DatumRange nndr = this.axis.getTickV().enclosingRange(dr, true);
            DataRangeSelectionEvent te = new DataRangeSelectionEvent(e0.getSource(), nndr.min(), nndr.max());
            this.fireDataRangeSelectionListenerDataRangeSelected(te);
        } else if (e0.getGesture() == Gesture.BACK) {
            this.axis.setDataRangePrev();
        } else if (e0.getGesture() == Gesture.ZOOMOUT) {
            this.axis.setDataRangeZoomOut();
        } else if (e0.getGesture() == Gesture.FORWARD) {
            this.axis.setDataRangeForward();
        } else if (e0.getGesture() == Gesture.SCANPREV) {
            this.axis.scanPrevious();
        } else if (e0.getGesture() == Gesture.SCANNEXT) {
            this.axis.scanNext();
        } else {
            logger.log(Level.FINE, "unsupported gesture: {0}", e0.getGesture());
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double nmax;
        double nmin;
        double shift = 0.0;
        if (e.isControlDown()) {
            if (e.getWheelRotation() < 0) {
                nmin = -0.2;
                nmax = 0.8;
            } else {
                nmin = 0.2;
                nmax = 1.2;
            }
        } else if (e.isShiftDown()) {
            if (e.getWheelRotation() < 0) {
                nmin = -0.005;
                nmax = 0.995;
            } else {
                nmin = 0.005;
                nmax = 1.005;
            }
        } else if (e.getWheelRotation() < 0) {
            nmin = 0.1;
            nmax = 0.9;
        } else {
            nmin = -0.125;
            nmax = 1.125;
        }
        Point ep = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
        MouseModule.Pos xpos = this.axis == null ? MouseModule.Pos._null : this.position(this.axis.getColumn(), ep.x, 20);
        switch (xpos) {
            case min: {
                shift = -nmin;
                break;
            }
            case max: {
                shift = nmin;
                break;
            }
            default: {
                logger.log(Level.FINE, "xpos: {0}", (Object)xpos);
            }
        }
        int clickMag = 1;
        long t1 = System.nanoTime();
        long limitNanos = 40000000L;
        if ((t1 - this.t0) / (long)clickMag < limitNanos) {
            clickMag = (int)Math.floor((double)(t1 - this.t0) / (double)limitNanos);
        }
        if (clickMag == 0) {
            return;
        }
        this.t0 = System.nanoTime();
        logger.log(Level.FINEST, ":ns:  {0}  {1}", new Object[]{System.nanoTime() - this.tbirth, clickMag});
        DatumRange dr = this.axis.getDatumRange();
        for (int i = 0; i < clickMag; ++i) {
            dr = this.axis.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)dr, (double)(nmin + shift), (double)(nmax + shift)) : DatumRangeUtil.rescale((DatumRange)dr, (double)(nmin + shift), (double)(nmax + shift));
        }
        if (!DatumRangeUtil.isAcceptable((DatumRange)(dr = HorizontalRangeSelectorMouseModule.maybeRound(this.axis, dr)), (boolean)this.axis.isLog())) {
            dr = null;
        }
        DatumRange xdrnew = dr;
        if (HorizontalRangeSelectorMouseModule.axisIsAdjustable(this.axis) && xdrnew == null) {
            return;
        }
        if (HorizontalRangeSelectorMouseModule.axisIsAdjustable(this.axis)) {
            this.axis.setDatumRange(xdrnew);
        }
        super.mouseWheelMoved(e);
    }

    public void addDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.add(DataRangeSelectionListener.class, listener);
    }

    public void removeDataRangeSelectionListener(DataRangeSelectionListener listener) {
        this.listenerList.remove(DataRangeSelectionListener.class, listener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataRangeSelectionListener.class) continue;
            ((DataRangeSelectionListener)listeners[i + 1]).dataRangeSelected(event);
        }
    }
}

