/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.das2.components.GrannyTextEditor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.ColorUtil;
import org.das2.graph.ContoursRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.FillStyle;
import org.das2.graph.HugeScatterRenderer;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.TickVDescriptor;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.DasMath;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.Converter;

public class GraphUtil {
    public static String FILL_TEXTURE_CROSSHASH = "crosshash";
    public static String FILL_TEXTURE_HASH = "hash";
    public static String FILL_TEXTURE_BACKHASH = "backhash";
    public static String FILL_TEXTURE_SOLID = "solid";
    public static String FILL_TEXTURE_NONE = "none";
    private static final Logger logger = LoggerManager.getLogger((String)"das2.graphics.util");
    public static final String CONNECT_MODE_HISTOGRAM = "histogram";
    public static final String CONNECT_MODE_SCATTER = "scatter";
    public static final String CONNECT_MODE_SERIES = "series";
    public static final int MAX_TICKS = 480;

    private static GrannyTextRenderer.Painter createBlockPainter() {
        return (g, args) -> {
            double fontSize = g.getFont().getSize2D();
            int s = (int)(fontSize * 2.0 / 3.0);
            g.fillRect(1, -s + 2, s - 2, s - 4);
            return new Rectangle(0, (int)(-fontSize), (int)fontSize, (int)fontSize);
        };
    }

    public static void fillWithTexture(Graphics2D g, GeneralPath pbox, Color fillColor, String fillTexture) {
        Line2D.Double line;
        double limxx;
        double xx;
        double w;
        double yy;
        Rectangle2D r;
        Shape oldClip;
        Color oldColor = g.getColor();
        if (fillColor != null) {
            g.setColor(fillColor);
        }
        if (fillTexture.equals("hash") || fillTexture.equals("crosshash")) {
            oldClip = g.getClip();
            r = pbox.getBounds2D();
            g.setClip(pbox);
            yy = r.getY();
            w = r.getHeight();
            limxx = xx + r.getWidth() + w;
            for (xx = r.getX(); xx < limxx; xx += 10.0) {
                line = new Line2D.Double(xx, yy, xx - w, yy + w);
                g.draw(line);
            }
            g.setClip(oldClip);
        }
        if (fillTexture.equals("backhash") || fillTexture.equals("crosshash")) {
            oldClip = g.getClip();
            r = pbox.getBounds2D();
            g.setClip(pbox);
            yy = r.getY();
            w = r.getHeight();
            limxx = xx + r.getWidth() + w;
            for (xx = r.getX(); xx < limxx; xx += 10.0) {
                line = new Line2D.Double(xx - w, yy, xx, yy + w);
                g.draw(line);
            }
            g.setClip(oldClip);
        }
        if (fillTexture.equals("") || fillTexture.equals("solid")) {
            g.fill(pbox);
        }
        if (fillColor != null) {
            g.setColor(oldColor);
        }
    }

    private static GrannyTextRenderer.Painter createImagePainter() {
        return new ImagePainter();
    }

    public static GrannyTextRenderer newGrannyTextRenderer() {
        GrannyTextRenderer result = new GrannyTextRenderer();
        result.addPainter("psym", GraphUtil.createPlotSymbolPainter());
        result.addPainter("block", GraphUtil.createBlockPainter());
        result.addPainter("img", GraphUtil.createImagePainter());
        return result;
    }

    private static GrannyTextRenderer.Painter createPlotSymbolPainter() {
        return (g, args) -> {
            int i;
            DefaultPlotSymbol p;
            Color returnColor = null;
            if (args.length == 0) {
                p = DefaultPlotSymbol.BOX;
            } else {
                switch (args[0]) {
                    case "boxes": {
                        p = DefaultPlotSymbol.BOX;
                        break;
                    }
                    case "circles": {
                        p = DefaultPlotSymbol.CIRCLES;
                        break;
                    }
                    case "crosses": {
                        p = DefaultPlotSymbol.CROSS;
                        break;
                    }
                    case "diamonds": {
                        p = DefaultPlotSymbol.DIAMOND;
                        break;
                    }
                    case "exes": {
                        p = DefaultPlotSymbol.EX;
                        break;
                    }
                    case "triangles": {
                        p = DefaultPlotSymbol.TRIANGLES;
                        break;
                    }
                    case "trianglesNorth": {
                        p = DefaultPlotSymbol.TRIANGLES_NORTH;
                        break;
                    }
                    case "trianglesEast": {
                        p = DefaultPlotSymbol.TRIANGLES_EAST;
                        break;
                    }
                    case "trianglesWest": {
                        p = DefaultPlotSymbol.TRIANGLES_WEST;
                        break;
                    }
                    case "trianglesSouth": {
                        p = DefaultPlotSymbol.TRIANGLES_SOUTH;
                        break;
                    }
                    case "stars": {
                        p = DefaultPlotSymbol.STAR;
                        break;
                    }
                    case "none": {
                        p = DefaultPlotSymbol.NONE;
                        break;
                    }
                    default: {
                        p = DefaultPlotSymbol.DIAMOND;
                    }
                }
            }
            double size = 8.0;
            double fontSize = g.getFont().getSize2D();
            FillStyle fillStyle = FillStyle.STYLE_SOLID;
            float thick = 1.5f;
            for (i = 1; i < args.length; ++i) {
                if (args[i].startsWith("size=")) {
                    String sspec = args[i].substring(5);
                    if (Character.isDigit(sspec.charAt(sspec.length() - 1))) {
                        size = Double.parseDouble(sspec);
                        continue;
                    }
                    size = DasDevicePosition.parseLayoutStr(sspec, g.getFont().getSize(), g.getFont().getSize(), size);
                    continue;
                }
                if (args[i].startsWith("fillStyle=")) {
                    String sfillStyle = args[i].substring(10);
                    if (sfillStyle.equals("outline")) {
                        fillStyle = FillStyle.STYLE_OUTLINE;
                        continue;
                    }
                    if (!sfillStyle.equals("none")) continue;
                    fillStyle = FillStyle.STYLE_NONE;
                    continue;
                }
                if (args[i].startsWith("color=")) {
                    String scolor = args[i].substring(6);
                    Color c = org.das2.util.ColorUtil.decodeColor((String)scolor);
                    returnColor = g.getColor();
                    g.setColor(c);
                    continue;
                }
                if (!args[i].startsWith("lineThick=")) continue;
                String sthick = args[i].substring(10);
                try {
                    Float dthick = Float.valueOf(Float.parseFloat(sthick));
                    thick = 1.5f * dthick.floatValue();
                    continue;
                }
                catch (NumberFormatException ex) {
                    logger.log(Level.WARNING, "unable to parse lineThick: {0}", Float.valueOf(thick));
                }
            }
            p.draw(g, fontSize / 2.0, -fontSize * 2.0 / 3.0 / 2.0, (float)size, fillStyle);
            for (i = 1; i < args.length; ++i) {
                if (!args[i].startsWith("connect=")) continue;
                String sconnect = args[i].substring(8);
                PsymConnector connect = sconnect.equals("solid") ? PsymConnector.SOLID : (sconnect.equals("dots") ? PsymConnector.DOTS : PsymConnector.SOLID);
                double x = fontSize / 2.0;
                double y = -fontSize * 2.0 / 3.0 / 2.0;
                connect.drawLine(g, x - size, y + size * 4.0 / 11.0, x + size, y - size * 4.0 / 11.0, thick);
            }
            Rectangle r = new Rectangle(0, (int)(-fontSize), (int)fontSize, (int)fontSize);
            if (returnColor != null) {
                g.setColor(returnColor);
            }
            return r;
        };
    }

    public static GrannyTextEditor newGrannyTextEditor() {
        GrannyTextEditor result = new GrannyTextEditor();
        result.addPainter("psym", GraphUtil.createPlotSymbolPainter());
        result.addPainter("block", GraphUtil.createBlockPainter());
        result.addPainter("img", GraphUtil.createImagePainter());
        return result;
    }

    public static DasPlot newDasPlot(DasCanvas canvas, DatumRange x, DatumRange y) {
        DasAxis xaxis = new DasAxis(x.min(), x.max(), 2);
        DasAxis yaxis = new DasAxis(y.min(), y.max(), 3);
        DasRow row = new DasRow(canvas, null, 0.0, 1.0, 2.0, -3.0, 0, 0);
        DasColumn col = new DasColumn(canvas, null, 0.0, 1.0, 5.0, -3.0, 0, 0);
        DasPlot result = new DasPlot(xaxis, yaxis);
        canvas.add(result, row, col);
        return result;
    }

    public static GeneralPath getPath(DasAxis xAxis, DasAxis yAxis, QDataSet ds, boolean histogram, boolean clip) {
        return GraphUtil.getPath(xAxis, yAxis, SemanticOps.xtagsDataSet((QDataSet)ds), ds, histogram, clip);
    }

    public static GeneralPath getPath(DasAxis xAxis, DasAxis yAxis, QDataSet xds, QDataSet yds, boolean histogram, boolean clip) {
        return GraphUtil.getPath(xAxis, yAxis, xds, yds, histogram ? CONNECT_MODE_HISTOGRAM : CONNECT_MODE_SERIES, clip);
    }

    public static final String getSegNameFor(int type) {
        switch (type) {
            case 0: {
                return "SEG_MOVETO";
            }
            case 1: {
                return "SEG_LINETO";
            }
            case 4: {
                return "SEG_CLOSE";
            }
        }
        return "SEG_???";
    }

    public static GeneralPath getPath(DasAxis xAxis, DasAxis yAxis, QDataSet xds, QDataSet yds, String mode, boolean clip) {
        QDataSet cadence;
        GeneralPath newPath = new GeneralPath();
        Units xUnits = SemanticOps.getUnits((QDataSet)xds);
        Units yUnits = SemanticOps.getUnits((QDataSet)yds);
        QDataSet tagds = (QDataSet)yds.property("DEPEND_0");
        if (tagds == null) {
            tagds = new IndexGenDataSet(yds.length());
        }
        double dcadence = (cadence = (QDataSet)tagds.property("CADENCE")) == null || cadence.rank() > 0 ? Double.MAX_VALUE : cadence.value();
        double i0 = -1.7976931348623157E308;
        double j0 = -1.7976931348623157E308;
        boolean v0 = false;
        boolean skippedLast = true;
        int n = xds.length();
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)yds);
        Rectangle rclip = clip ? DasDevicePosition.toRectangle(yAxis.getRow(), xAxis.getColumn()) : null;
        boolean histogram = mode.equals(CONNECT_MODE_HISTOGRAM);
        boolean scatter = mode.equals(CONNECT_MODE_SCATTER);
        double lastTag = tagds.length() > 0 ? tagds.value(0) : -999.0;
        for (int index = 0; index < n; ++index) {
            boolean v;
            double x = xds.value(index);
            double y = yds.value(index);
            double tag = tagds.value(index);
            double dtag = tag - lastTag;
            double i = xAxis.transform(x, xUnits);
            double j = yAxis.transform(y, yUnits);
            boolean bl = v = rclip == null || rclip.contains(i, j);
            if (dtag > dcadence) {
                skippedLast = true;
            }
            lastTag = tag;
            if (wds.value(index) == 0.0 || Double.isNaN(y)) {
                skippedLast = true;
            } else if (skippedLast) {
                newPath.moveTo((float)i, (float)j);
                if (scatter) {
                    newPath.lineTo((float)i, (float)j);
                }
                skippedLast = !v;
            } else {
                if (v || v0) {
                    if (histogram) {
                        double i1 = (i0 + i) / 2.0;
                        newPath.lineTo((float)i1, (float)j0);
                        newPath.lineTo((float)i1, (float)j);
                        newPath.lineTo((float)i, (float)j);
                    } else if (scatter) {
                        newPath.moveTo((float)i, (float)j);
                        newPath.lineTo((float)i, (float)j);
                    } else {
                        newPath.lineTo((float)i, (float)j);
                    }
                }
                skippedLast = false;
            }
            i0 = i;
            j0 = j;
            v0 = v;
        }
        return newPath;
    }

    public static AffineTransform calculateAT(DasAxis xaxis0, DasAxis yaxis0, DasAxis xaxis1, DasAxis yaxis1) {
        return GraphUtil.calculateAT(xaxis0.getDatumRange(), yaxis0.getDatumRange(), xaxis1, yaxis1);
    }

    public static AffineTransform calculateAT(DatumRange xaxis0, DatumRange yaxis0, DasAxis xaxis1, DasAxis yaxis1) {
        AffineTransform at = new AffineTransform();
        double dmin0 = xaxis1.transform(xaxis0.min());
        double dmax0 = xaxis1.transform(xaxis0.max());
        double dmin1 = xaxis1.transform(xaxis1.getDataMinimum());
        double dmax1 = xaxis1.transform(xaxis1.getDataMaximum());
        double scalex = (dmin0 - dmax0) / (dmin1 - dmax1);
        double transx = -1.0 * dmin1 * scalex + dmin0;
        at.translate(transx, 0.0);
        at.scale(scalex, 1.0);
        if (at.getDeterminant() == 0.0) {
            return null;
        }
        dmin0 = yaxis1.transform(yaxis0.min());
        dmax0 = yaxis1.transform(yaxis0.max());
        dmin1 = yaxis1.transform(yaxis1.getDataMinimum());
        dmax1 = yaxis1.transform(yaxis1.getDataMaximum());
        double scaley = (dmin0 - dmax0) / (dmin1 - dmax1);
        double transy = -1.0 * dmin1 * scaley + dmin0;
        at.translate(0.0, transy);
        at.scale(1.0, scaley);
        return at;
    }

    public static DasAxis guessYAxis(QDataSet dsz) {
        DasAxis result;
        boolean log = false;
        if (dsz.property("SCALE_TYPE") != null && dsz.property("SCALE_TYPE").equals("log")) {
            log = true;
        }
        if (SemanticOps.isSimpleTableDataSet((QDataSet)dsz)) {
            QDataSet ds = dsz;
            QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)ds);
            DatumRange yrange = DataSetUtil.asDatumRange((QDataSet)Ops.extent((QDataSet)yds), (boolean)true);
            yrange = DatumRangeUtil.rescale((DatumRange)yrange, (double)-0.1, (double)1.1);
            Datum dy = DataSetUtil.asDatum((RankZeroDataSet)DataSetUtil.guessCadenceNew((QDataSet)yds, null));
            if (UnitsUtil.isRatiometric((Units)dy.getUnits())) {
                log = true;
            }
            result = new DasAxis(yrange.min(), yrange.max(), 3, log);
        } else if (!SemanticOps.isTableDataSet((QDataSet)dsz)) {
            QDataSet yds = dsz;
            if (SemanticOps.isBundle((QDataSet)dsz)) {
                dsz = yds = DataSetOps.unbundleDefaultDataSet((QDataSet)dsz);
            }
            DatumRange yrange = DataSetUtil.asDatumRange((QDataSet)Ops.extent((QDataSet)yds), (boolean)true);
            yrange = DatumRangeUtil.rescale((DatumRange)yrange, (double)-0.1, (double)1.1);
            result = new DasAxis(yrange.min(), yrange.max(), 3, log);
        } else {
            throw new IllegalArgumentException("not supported: " + dsz);
        }
        if (dsz.property("LABEL") != null) {
            result.setLabel((String)dsz.property("LABEL"));
        }
        return result;
    }

    public static DasAxis guessXAxis(QDataSet ds) {
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
        DatumRange range = DataSetUtil.asDatumRange((QDataSet)Ops.extent((QDataSet)xds), (boolean)true);
        range = DatumRangeUtil.rescale((DatumRange)range, (double)-0.1, (double)1.1);
        return new DasAxis(range.min(), range.max(), 2);
    }

    public static DasAxis guessZAxis(QDataSet dsz) {
        if (!SemanticOps.isTableDataSet((QDataSet)dsz)) {
            throw new IllegalArgumentException("only TableDataSet supported");
        }
        QDataSet ds = dsz;
        DatumRange range = DataSetUtil.asDatumRange((QDataSet)Ops.extent((QDataSet)ds), (boolean)true);
        boolean log = false;
        if ("log".equals(dsz.property("SCALE_TYPE"))) {
            log = true;
            if (range.min().doubleValue(range.getUnits()) <= 0.0) {
                double max = range.max().doubleValue(range.getUnits());
                range = new DatumRange(max / 1000.0, max, range.getUnits());
            }
        }
        DasAxis result = new DasAxis(range.min(), range.max(), 3, log);
        if (dsz.property("LABEL") != null) {
            result.setLabel((String)dsz.property("LABEL"));
        }
        return result;
    }

    public static Renderer guessRenderer(QDataSet ds) {
        Renderer rend = null;
        if (!SemanticOps.isTableDataSet((QDataSet)ds)) {
            if (ds.length() > 10000) {
                rend = new HugeScatterRenderer(null);
                rend.setDataSet(ds);
            } else {
                rend = new SeriesRenderer();
                rend.setDataSet(ds);
                ((SeriesRenderer)rend).setPsym(DefaultPlotSymbol.CIRCLES);
                ((SeriesRenderer)rend).setSymSize(2.0);
            }
        } else if (SemanticOps.isTableDataSet((QDataSet)ds)) {
            DasAxis zaxis = GraphUtil.guessZAxis(ds);
            DasColorBar colorbar = new DasColorBar(zaxis.getDataMinimum(), zaxis.getDataMaximum(), zaxis.isLog());
            colorbar.setLabel(zaxis.getLabel());
            rend = new SpectrogramRenderer(null, colorbar);
            rend.setDataSet(ds);
        }
        return rend;
    }

    public static DasPlot guessPlot(QDataSet ds) {
        DasAxis xaxis = GraphUtil.guessXAxis(ds);
        DasAxis yaxis = GraphUtil.guessYAxis(ds);
        DasPlot plot = new DasPlot(xaxis, yaxis);
        plot.addRenderer(GraphUtil.guessRenderer(ds));
        return plot;
    }

    public static DasAxis copyAxis(DasAxis a) {
        DasAxis c = new DasAxis(a.getDatumRange(), a.getOrientation());
        c.setDataMinimum(a.getDataMinimum());
        c.setDataMaximum(a.getDataMaximum());
        c.setLog(a.isLog());
        c.setLabel(a.getLabel());
        c.setFlipLabel(a.isFlipLabel());
        c.setFlipped(a.isFlipped());
        c.setEnabled(a.isEnabled());
        c.setEnableHistory(a.isEnableHistory());
        c.setLog(a.isLog());
        c.setOpaque(a.isOpaque());
        c.setOppositeAxisVisible(a.isOppositeAxisVisible());
        c.setTickLabelsVisible(a.isTickLabelsVisible());
        c.setUseDomainDivider(a.isUseDomainDivider());
        c.setUserDatumFormatter(a.getUserDatumFormatter());
        return c;
    }

    public static DasColorBar copyColorBar(DasColorBar a) {
        DasColorBar c = new DasColorBar(a.getDataMinimum(), a.getDataMaximum(), a.getOrientation(), a.isLog());
        c.setLabel(a.getLabel());
        c.setFlipLabel(a.isFlipLabel());
        c.setType(a.getType());
        return c;
    }

    public static DasPlot copyPlot(DasPlot p) {
        DasAxis xaxis = GraphUtil.copyAxis(p.getXAxis());
        DasAxis yaxis = GraphUtil.copyAxis(p.getYAxis());
        DasPlot c = new DasPlot(xaxis, yaxis);
        c.setTitle(p.getTitle());
        c.setDisplayTitle(p.isDisplayTitle());
        c.setDrawGrid(p.isDrawGrid());
        c.setPreviewEnabled(p.isPreviewEnabled());
        c.setLegendPosition(p.getLegendPosition());
        c.setDisplayLegend(p.isDisplayLegend());
        for (Renderer r : p.getRenderers()) {
            Renderer sr;
            Renderer cr;
            if (r instanceof Copyable) {
                Copyable copyable = (Copyable)((Object)r);
                cr = (Renderer)copyable.copy();
            } else if (r instanceof SpectrogramRenderer) {
                DasColorBar cb = GraphUtil.copyColorBar(((SpectrogramRenderer)r).getColorBar());
                cr = new SpectrogramRenderer(null, cb);
                SpectrogramRenderer sr2 = (SpectrogramRenderer)cr;
                sr2.setRebinner(((SpectrogramRenderer)r).getRebinner());
            } else if (r instanceof SeriesRenderer) {
                cr = new SeriesRenderer();
                sr = (SeriesRenderer)cr;
                ((SeriesRenderer)cr).setAntiAliased(((SeriesRenderer)r).isAntiAliased());
                ((SeriesRenderer)sr).setColor(((SeriesRenderer)r).getColor());
                ((SeriesRenderer)sr).setFillColor(((SeriesRenderer)r).getFillColor());
                ((SeriesRenderer)sr).setFillStyle(((SeriesRenderer)r).getFillStyle());
                ((SeriesRenderer)sr).setLineWidth(((SeriesRenderer)r).getLineWidth());
                ((SeriesRenderer)sr).setFillToReference(((SeriesRenderer)r).isFillToReference());
                ((SeriesRenderer)sr).setReference(((SeriesRenderer)r).getReference());
                ((SeriesRenderer)sr).setSymSize(((SeriesRenderer)r).getSymSize());
                ((SeriesRenderer)sr).setPsym(((SeriesRenderer)r).getPsym());
                ((SeriesRenderer)sr).setPsymConnector(((SeriesRenderer)r).getPsymConnector());
                sr.setLegendLabel(((SeriesRenderer)r).getLegendLabel());
                sr.setDrawLegendLabel(((SeriesRenderer)r).isDrawLegendLabel());
                ((SeriesRenderer)sr).setCadenceCheck(((SeriesRenderer)r).isCadenceCheck());
            } else if (r instanceof HugeScatterRenderer) {
                cr = new HugeScatterRenderer(null);
                sr = (HugeScatterRenderer)cr;
                ((HugeScatterRenderer)sr).setColor(((HugeScatterRenderer)r).getColor());
            } else if (r instanceof ContoursRenderer) {
                cr = new ContoursRenderer();
                sr = (ContoursRenderer)r;
                cr.setControl(((ContoursRenderer)sr).getControl());
            } else {
                logger.log(Level.WARNING, "source renderer {0} cannot be copied. Skipping.", r.getLegendLabel());
                continue;
            }
            cr.setControl(r.getControl());
            cr.setDataSet(r.getDataSet());
            c.addRenderer(cr);
        }
        if (c.getRenderers().length == 0) {
            throw new UnsupportedOperationException("No copyable renderers.");
        }
        return c;
    }

    public static DasPlot visualize(QDataSet ds) {
        JFrame jframe = new JFrame("DataSetUtil.visualize");
        DasCanvas canvas = new DasCanvas(400, 400);
        jframe.getContentPane().add(canvas);
        DasPlot result = GraphUtil.guessPlot(ds);
        canvas.add(result, new DasRow(canvas, 0.1, 0.9), DasColumn.create(canvas, null, "5em", "100%-10em"));
        jframe.pack();
        jframe.setVisible(true);
        jframe.setDefaultCloseOperation(3);
        return result;
    }

    public static int clipPath(PathIterator it, GeneralPath result, Rectangle clip) {
        logger.entering("GraphUtil", "clipPath");
        float[] p = new float[6];
        Point2D.Float lastP = null;
        boolean initialMoveTo = true;
        while (!it.isDone()) {
            Point2D clipP;
            Point2D.Float thisP;
            int type = it.currentSegment(p);
            it.next();
            float xx = p[0];
            float yy = p[1];
            if (type == 0) {
                if (lastP != null) {
                    thisP = new Point2D.Float(xx, yy);
                    clipP = GraphUtil.lineRectangleIntersection(lastP, thisP, clip);
                    if (clip.contains(lastP)) {
                        result.moveTo(((Point2D)thisP).getX(), ((Point2D)thisP).getY());
                        initialMoveTo = false;
                    } else if (clip.contains(thisP)) {
                        result.moveTo(clipP.getX(), clipP.getY());
                        result.moveTo(((Point2D)thisP).getX(), ((Point2D)thisP).getY());
                        initialMoveTo = false;
                    }
                    lastP = thisP;
                    continue;
                }
                thisP = new Point2D.Float(xx, yy);
                if (clip.contains(thisP)) {
                    result.moveTo(((Point2D)thisP).getX(), ((Point2D)thisP).getY());
                    initialMoveTo = false;
                }
                lastP = thisP;
                continue;
            }
            if (type != 1) continue;
            if (lastP != null) {
                thisP = new Point2D.Float(xx, yy);
                clipP = GraphUtil.lineRectangleIntersection(lastP, thisP, clip);
                if (clip.contains(lastP)) {
                    if (clip.contains(thisP)) {
                        if (initialMoveTo) {
                            result.moveTo(((Point2D)lastP).getX(), ((Point2D)lastP).getY());
                            initialMoveTo = false;
                        }
                        result.lineTo(((Point2D)thisP).getX(), ((Point2D)thisP).getY());
                    } else {
                        if (initialMoveTo) {
                            result.moveTo(((Point2D)lastP).getX(), ((Point2D)lastP).getY());
                            initialMoveTo = false;
                        }
                        try {
                            result.lineTo(clipP.getX(), clipP.getY());
                        }
                        catch (NullPointerException ex) {
                            result.lineTo(clipP.getX(), clipP.getY());
                        }
                    }
                } else if (clip.contains(thisP)) {
                    if (clipP != null) {
                        result.moveTo(clipP.getX(), clipP.getY());
                        result.lineTo(((Point2D)thisP).getX(), ((Point2D)thisP).getY());
                    }
                } else {
                    Line2D clipP2 = GraphUtil.lineRectangleMask(lastP, thisP, clip);
                    if (clipP2 != null) {
                        result.moveTo(clipP2.getX1(), clipP2.getY1());
                        result.lineTo(clipP2.getX2(), clipP2.getY2());
                    }
                }
                lastP = thisP;
                continue;
            }
            thisP = new Point2D.Float(xx, yy);
            if (clip.contains(thisP)) {
                result.lineTo(((Point2D)thisP).getX(), ((Point2D)thisP).getY());
            } else {
                logger.info("TODO: what about this branch?");
            }
            lastP = thisP;
        }
        logger.exiting("GraphUtil", "clipPath");
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int reducePath20140622(PathIterator it, GeneralPath result, int resn, int resd) {
        logger.entering("GraphUtil", "reducePath20140622");
        long t0 = System.currentTimeMillis();
        float[] p = new float[6];
        int x0 = -99999;
        int y0 = -99999;
        int entryy = -99999;
        int miny = 99999;
        int maxy = -99999;
        int type0 = -999;
        int points = 0;
        int inCount = 0;
        boolean atMiny = false;
        boolean atMaxy = false;
        while (!it.isDone()) {
            ++inCount;
            int type = it.currentSegment(p);
            it.next();
            int xx = (int)(p[0] * (float)resd) / resn;
            int yy = (int)(p[1] * (float)resd) / resn;
            if (type0 == -999) {
                result.moveTo((float)xx / (float)resd, (float)yy / (float)resd);
                x0 = xx;
                entryy = yy;
                miny = yy;
                maxy = yy;
            }
            if (!(type == 0 && xx == x0 || type != 1 && type != type0 || xx != x0)) {
                miny = Math.min(miny, yy);
                maxy = Math.max(maxy, yy);
            }
            if (xx != x0) {
                atMiny = false;
                atMaxy = false;
                int exity = y0;
                if (miny == maxy) {
                    atMaxy = true;
                    atMiny = true;
                } else if (entryy == miny) {
                    result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                    ++points;
                    atMiny = true;
                } else if (entryy == maxy) {
                    result.lineTo((float)x0 * (float)resn / (float)resd, (float)maxy * (float)resn / (float)resd);
                    ++points;
                    atMaxy = true;
                } else {
                    result.lineTo((float)x0 * (float)resn / (float)resd, (float)entryy * (float)resn / (float)resd);
                    ++points;
                    result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                    ++points;
                    atMiny = true;
                }
                if (miny < maxy) {
                    if (atMiny) {
                        result.lineTo((float)x0 * (float)resn / (float)resd, (float)maxy * (float)resn / (float)resd);
                        ++points;
                        atMaxy = true;
                    } else if (!atMiny) {
                        result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                        ++points;
                        atMiny = true;
                    }
                }
                if (miny != maxy) {
                    if (exity == miny) {
                        if (atMiny) {
                            result.lineTo((float)x0 * (float)resn / (float)resd, (float)exity * (float)resn / (float)resd);
                            ++points;
                        } else {
                            if (!atMaxy) throw new RuntimeException("shouldn't get here line608");
                            result.lineTo((float)x0 * (float)resn / (float)resd, (float)exity * (float)resn / (float)resd);
                            ++points;
                        }
                    } else if (exity == maxy) {
                        if (!atMaxy) {
                            if (!atMiny) throw new RuntimeException("shouldn't get here line616");
                            throw new RuntimeException("shouldn't get here line614");
                        }
                    } else {
                        result.lineTo((float)x0 * (float)resn / (float)resd, (float)exity * (float)resn / (float)resd);
                        ++points;
                    }
                }
                if (type == 1) {
                    result.lineTo((float)xx * (float)resn / (float)resd, (float)yy * (float)resn / (float)resd);
                    ++points;
                } else if (type == 0) {
                    result.moveTo((float)xx * (float)resn / (float)resd, (float)yy * (float)resn / (float)resd);
                    ++points;
                }
                entryy = yy;
                miny = yy;
                maxy = yy;
            }
            if (type == 0) {
                result.moveTo((float)xx * (float)resn / (float)resd, (float)yy * (float)resn / (float)resd);
                ++points;
            }
            x0 = xx;
            y0 = yy;
            type0 = type;
        }
        if (miny != maxy) {
            if (entryy == miny) {
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                ++points;
                atMiny = true;
            } else if (entryy == maxy) {
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)maxy * (float)resn / (float)resd);
                ++points;
                atMiny = false;
            } else {
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)entryy * (float)resn / (float)resd);
                ++points;
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                ++points;
                atMiny = true;
            }
        }
        if (miny < maxy) {
            if (atMiny) {
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)maxy * (float)resn / (float)resd);
                ++points;
            } else if (!atMiny) {
                result.lineTo((float)x0 * (float)resn / (float)resd, (float)miny * (float)resn / (float)resd);
                ++points;
            }
        }
        logger.log(Level.FINE, "reduce {0} to {1} in {2}ms", new Object[]{inCount, points, System.currentTimeMillis() - t0});
        logger.exiting("GraphUtil", "reducePath20140622");
        return points;
    }

    public static int reducePath(PathIterator it, GeneralPath result) {
        return GraphUtil.reducePath(it, result, 1);
    }

    public static int reducePath(PathIterator it, GeneralPath result, int res) {
        float ay0;
        float ax0;
        logger.fine("enter reducePath");
        long t0 = System.currentTimeMillis();
        float[] p = new float[6];
        float x0 = Float.MAX_VALUE;
        float y0 = Float.MAX_VALUE;
        float sx0 = 0.0f;
        float sy0 = 0.0f;
        int nx0 = 0;
        int ny0 = 0;
        int type0 = -999;
        float xres = res;
        float yres = res;
        int points = 0;
        int inCount = 0;
        while (!it.isDone()) {
            ++inCount;
            int type = it.currentSegment(p);
            it.next();
            float dx = p[0] - x0;
            float dy = p[1] - y0;
            if ((type == 0 || type == type0) && Math.abs(dx) < xres && Math.abs(dy) < yres) {
                sx0 += p[0];
                sy0 += p[1];
                ++nx0;
                ++ny0;
                continue;
            }
            x0 = 0.5f + (float)((int)Math.floor(p[0]));
            y0 = 0.5f + (float)((int)Math.floor(p[1]));
            ax0 = nx0 > 0 ? sx0 / (float)nx0 : p[0];
            ay0 = ny0 > 0 ? sy0 / (float)ny0 : p[1];
            sx0 = p[0];
            sy0 = p[1];
            nx0 = 1;
            ny0 = 1;
            switch (type0) {
                case 1: {
                    result.lineTo(ax0, ay0);
                    ++points;
                    break;
                }
                case 0: {
                    result.moveTo(ax0, ay0);
                    break;
                }
                case 3: {
                    result.lineTo(ax0, ay0);
                    break;
                }
                case 4: {
                    break;
                }
                case -999: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not supported");
                }
            }
            type0 = type;
        }
        ax0 = nx0 > 0 ? sx0 / (float)nx0 : p[0];
        ay0 = ny0 > 0 ? sy0 / (float)ny0 : p[1];
        switch (type0) {
            case 1: {
                result.lineTo(ax0, ay0);
                ++points;
                break;
            }
            case 0: {
                result.moveTo(ax0, ay0);
                break;
            }
            case 3: {
                result.lineTo(ax0, ay0);
                break;
            }
            case 4: {
                break;
            }
            case -999: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not supported");
            }
        }
        logger.log(Level.FINE, "reduce {0} to {1} in {2}ms", new Object[]{inCount, points, System.currentTimeMillis() - t0});
        return points;
    }

    public static double pointsAlongCurve(PathIterator it, double[] pathlen, Point2D.Double[] result, double[] orientation, boolean stopAtMoveTo) {
        return GraphUtil.pointsAlongCurve(it, pathlen, result, orientation, stopAtMoveTo, new HashMap<String, Object>());
    }

    public static double pointsAlongCurve(PathIterator it, double[] pathlen, Point2D.Double[] result, double[] orientation, boolean stopAtMoveTo, Map<String, Object> props) {
        float[] point = new float[6];
        float fx0 = Float.NaN;
        float fy0 = Float.NaN;
        double slen = 0.0;
        int pathlenIndex = 0;
        if (pathlen == null) {
            pathlen = new double[]{};
        }
        if (!it.isDone() && props != null) {
            props.put("PROP_FIRST_POINT", Arrays.copyOf(point, point.length));
        }
        while (!it.isDone()) {
            int type = it.currentSegment(point);
            it.next();
            if (!Float.isNaN(fx0) && type == 0 && stopAtMoveTo) break;
            switch (type) {
                case 3: {
                    throw new IllegalArgumentException("cubicto not supported");
                }
                case 2: {
                    throw new IllegalArgumentException("quadto not supported");
                }
                case 1: {
                    break;
                }
            }
            if (Float.isNaN(fx0)) {
                fx0 = point[0];
                fy0 = point[1];
                continue;
            }
            double thislen = (float)Point.distance(fx0, fy0, point[0], point[1]);
            if (thislen == 0.0) continue;
            slen += thislen;
            while (pathlenIndex < pathlen.length && slen >= pathlen[pathlenIndex]) {
                double alpha = 1.0 - (slen - pathlen[pathlenIndex]) / thislen;
                double dx = point[0] - fx0;
                double dy = point[1] - fy0;
                if (result != null) {
                    result[pathlenIndex] = new Point2D.Double((double)fx0 + dx * alpha, (double)fy0 + dy * alpha);
                }
                if (orientation != null) {
                    orientation[pathlenIndex] = Math.atan2(dy, dx);
                }
                ++pathlenIndex;
            }
            fx0 = point[0];
            fy0 = point[1];
        }
        if (props != null) {
            props.put("PROP_LAST_POINT", Arrays.copyOf(point, point.length));
        }
        double remaining = pathlenIndex > 0 ? slen - pathlen[pathlenIndex - 1] : slen;
        if (result != null) {
            while (pathlenIndex < result.length) {
                result[pathlenIndex] = null;
                ++pathlenIndex;
            }
        }
        return remaining;
    }

    public static double parseLayoutLength(String s, double totalWidth, double em) {
        try {
            double[] dd = DasDevicePosition.parseLayoutStr(s);
            if (dd[0] == 0.0 && dd[1] == 1.0 && dd[2] == 0.0) {
                return em;
            }
            double parentSize = em;
            double newSize = dd[0] * totalWidth + dd[1] * parentSize + dd[2];
            return newSize;
        }
        catch (ParseException ex) {
            logger.log(Level.WARNING, null, ex.getMessage());
            return 0.0;
        }
    }

    public static String getATScaleTranslateString(AffineTransform at) {
        DecimalFormat nf = new DecimalFormat("0.00");
        if (at == null) {
            return "null";
        }
        if (!at.isIdentity()) {
            String atDesc = "scaleX:" + nf.format(at.getScaleX()) + " translateX:" + nf.format(at.getTranslateX());
            atDesc = atDesc + "!cscaleY:" + nf.format(at.getScaleY()) + " translateY:" + nf.format(at.getTranslateY());
            return atDesc;
        }
        return "identity";
    }

    public static double[] getSlopeIntercept(double x0, double y0, double x1, double y1) {
        double slope = (y1 - y0) / (x1 - x0);
        double intercept = y0 - slope * x0;
        return new double[]{slope, intercept};
    }

    public static Color getRicePaperColor() {
        return ColorUtil.getRicePaperColor();
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        int i;
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        for (i = -radius; i <= radius; ++i) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    public static BufferedImage blurImage(BufferedImage im, int size) {
        ConvolveOp op = GraphUtil.getGaussianBlurFilter(size, true);
        BufferedImage out = new BufferedImage(im.getWidth(), im.getHeight(), im.getType());
        op.filter(im, out);
        op = GraphUtil.getGaussianBlurFilter(size, false);
        im = out;
        out = new BufferedImage(im.getWidth(), im.getHeight(), im.getType());
        return op.filter(im, out);
    }

    public static String describe(GeneralPath path, boolean enumeratePoints) {
        PathIterator it = path.getPathIterator(null);
        int count = 0;
        int lineToCount = 0;
        double[] seg = new double[6];
        while (!it.isDone()) {
            int type = it.currentSegment(seg);
            if (type == 1) {
                ++lineToCount;
            }
            if (enumeratePoints) {
                if (type == 0) {
                    System.err.println(String.format(Locale.US, "moveTo( %9.2f, %9.2f )\n", seg[0], seg[1]));
                } else if (type == 1) {
                    System.err.println(String.format(Locale.US, "lineTo( %9.2f, %9.2f )\n", seg[0], seg[1]));
                } else {
                    System.err.println(String.format(Locale.US, "%4d( %9.2f, %9.2f )\n", type, seg[0], seg[1]));
                }
            }
            ++count;
            it.next();
        }
        System.err.println("count: " + count + "  lineToCount: " + lineToCount);
        return "count: " + count + "  lineToCount: " + lineToCount;
    }

    static String toString(Line2D line) {
        return "" + line.getX1() + "," + line.getY1() + " " + line.getX2() + "," + line.getY2();
    }

    public static Point2D lineIntersection(Line2D line1, Line2D line2, boolean noBoundsCheck) {
        double a1 = line1.getY2() - line1.getY1();
        double b1 = line1.getX1() - line1.getX2();
        double c1 = line1.getX2() * line1.getY1() - line1.getX1() * line1.getY2();
        double a2 = line2.getY2() - line2.getY1();
        double b2 = line2.getX1() - line2.getX2();
        double c2 = line2.getX2() * line2.getY1() - line2.getX1() * line2.getY2();
        double denom = a1 * b2 - a2 * b1;
        if (denom != 0.0) {
            Point2D.Double result = new Point2D.Double((b1 * c2 - b2 * c1) / denom, (a2 * c1 - a1 * c2) / denom);
            if (noBoundsCheck) {
                return result;
            }
            double epsilon = -1.0 * Math.min(line1.getP1().distance(line1.getP2()), line2.getP1().distance(line2.getP2())) / 10000.0;
            if ((((Point2D)result).getX() - line1.getX1()) * (line1.getX2() - ((Point2D)result).getX()) >= epsilon && (((Point2D)result).getY() - line1.getY1()) * (line1.getY2() - ((Point2D)result).getY()) >= epsilon && (((Point2D)result).getX() - line2.getX1()) * (line2.getX2() - ((Point2D)result).getX()) >= epsilon && (((Point2D)result).getY() - line2.getY1()) * (line2.getY2() - ((Point2D)result).getY()) >= epsilon) {
                return result;
            }
            return null;
        }
        return null;
    }

    public static Line2D lineRectangleMask(Point2D p0, Point2D p1, Rectangle2D r) {
        Line2D.Double line = new Line2D.Double(p0, p1);
        Point2D.Double r0 = new Point2D.Double(r.getX(), r.getY());
        Point2D.Double r1 = new Point2D.Double(r.getX() + r.getWidth(), r.getY() + r.getHeight());
        Point2D point1 = null;
        Point2D point2 = null;
        Point2D p = GraphUtil.lineIntersection(line, new Line2D.Double(r0.x, r0.y, r1.x, r0.y), false);
        if (p != null) {
            point1 = p;
        }
        if ((p = GraphUtil.lineIntersection(line, new Line2D.Double(r1.x, r0.y, r1.x, r1.y), false)) != null) {
            if (point1 == null) {
                point1 = p;
            } else {
                point2 = p;
            }
        }
        if ((p = GraphUtil.lineIntersection(line, new Line2D.Double(r1.x, r1.y, r0.x, r1.y), false)) != null) {
            if (point1 == null) {
                point1 = p;
            } else {
                point2 = p;
            }
        }
        if ((p = GraphUtil.lineIntersection(line, new Line2D.Double(r0.x, r1.y, r0.x, r0.y), false)) != null) {
            if (point1 == null) {
                point1 = p;
            } else {
                point2 = p;
            }
        }
        if (point1 == null) {
            return null;
        }
        if (point2 == null) {
            if (r.contains(p1)) {
                return new Line2D.Double(point1, p1);
            }
            return new Line2D.Double(p0, point1);
        }
        if (Point2D.distance(p0.getX(), p0.getY(), point1.getX(), point1.getY()) < Point2D.distance(p0.getX(), p0.getY(), point2.getX(), point2.getY())) {
            return new Line2D.Double(point1, point2);
        }
        return new Line2D.Double(point2, point1);
    }

    public static Point2D lineRectangleIntersection(Point2D p0, Point2D p1, Rectangle2D r0) {
        PathIterator it = r0.getPathIterator(null);
        Line2D.Double line = new Line2D.Double(p0, p1);
        float[] c0 = new float[6];
        float[] c1 = new float[6];
        it.currentSegment(c0);
        it.next();
        while (!it.isDone()) {
            Line2D.Double seg;
            Point2D result;
            int type = it.currentSegment(c1);
            if (type == 1 && (result = GraphUtil.lineIntersection(line, seg = new Line2D.Double(c0[0], c0[1], c1[0], c1[1]), false)) != null) {
                return result;
            }
            it.next();
            c0[0] = c1[0];
            c0[1] = c1[1];
        }
        return null;
    }

    public static double[] transformRange(DasAxis axis, DatumRange range) {
        double x2;
        double x1 = axis.transform(range.min());
        if (x1 > (x2 = axis.transform(range.max()))) {
            double t = x2;
            x2 = x1;
            x1 = t;
        }
        return new double[]{x1, x2};
    }

    public static DatumRange invTransformRange(DasAxis axis, double x1, double x2) {
        Datum d2;
        Datum d1 = axis.invTransform(x1);
        if (d1.gt(d2 = axis.invTransform(x2))) {
            Datum t = d2;
            d2 = d1;
            d1 = t;
        }
        return new DatumRange(d1, d2);
    }

    public static Icon colorIcon(Color iconColor, int w, int h) {
        return GraphUtil.colorImageIcon(iconColor, w, h);
    }

    public static ImageIcon colorImageIcon(Color iconColor, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        if (iconColor.getAlpha() != 255) {
            for (int j = 0; j < 4; ++j) {
                for (int i = 0; i < 4; ++i) {
                    g.setColor((i - j) % 2 == 0 ? Color.GRAY : Color.WHITE);
                    g.fillRect(0 + i * 4, 0 + j * 4, 4, 4);
                }
            }
        }
        g.setColor(iconColor);
        g.fillRect(0, 0, w, h);
        return new ImageIcon(image);
    }

    public static Rectangle shrinkRectangle(Rectangle bounds, int percent) {
        Rectangle result = new Rectangle(bounds.x + (int)((double)bounds.width * (100.0 - (double)percent) / 2.0 / 100.0), bounds.y + (int)((double)bounds.height * (100.0 - (double)percent) / 2.0 / 100.0), (int)((double)bounds.width * ((double)percent / 100.0)), (int)((double)bounds.height * ((double)percent / 100.0)));
        return result;
    }

    public static Line2D shortenLine(Line2D line, double l1, double l2) {
        double len = line.getP1().distance(line.getP2());
        if (len == 0.0) {
            return line;
        }
        double sx = (line.getX2() - line.getX1()) / len;
        double sy = (line.getY2() - line.getY1()) / len;
        return new Line2D.Double(line.getX1() + sx * l1, line.getY1() + sy * l1, line.getX2() - sx * l2, line.getY2() - sy * l2);
    }

    public static Line2D perpendicularLine(Line2D line, Point p, double len) {
        throw new IllegalArgumentException("not implemented.");
    }

    public static Converter getFontConverter(final DasCanvasComponent dcc, final String fallbackFont) {
        return new Converter(){

            public Object convertForward(Object s) {
                try {
                    double[] dd = DasDevicePosition.parseLayoutStr((String)s);
                    Font f = dcc.getFont();
                    if (f == null) {
                        f = Font.decode(fallbackFont);
                    }
                    if (dd[1] == 1.0 && dd[2] == 0.0) {
                        return Float.valueOf(f.getSize2D());
                    }
                    double parentSize = f.getSize2D();
                    double newSize = dd[1] * parentSize + dd[2];
                    return Float.valueOf((float)newSize);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                    return Float.valueOf(0.0f);
                }
            }

            public Object convertReverse(Object t) {
                float size = ((Float)t).floatValue();
                Font f = dcc.getFont();
                if (f == null) {
                    f = Font.decode(fallbackFont);
                }
                if (size == 0.0f) {
                    return "1em";
                }
                double parentSize = f.getSize2D();
                double relativeSize = (double)size / parentSize;
                return String.format(Locale.US, "%.2fem", relativeSize);
            }
        };
    }

    private static int updateTickVManualTicksMinor(double dt) {
        int scale;
        if ((dt /= Math.pow(10.0, scale = (int)Math.log10(dt))) == 1.0) {
            return 4;
        }
        if (dt == 2.0) {
            return 2;
        }
        if (dt == 4.0) {
            return 2;
        }
        if (dt == 5.0) {
            return 5;
        }
        if (dt == 3.0) {
            return 3;
        }
        if (dt == 9.0) {
            return 3;
        }
        if (dt == 1.5) {
            return 3;
        }
        return 1;
    }

    public static TickVDescriptor calculateManualTicks(String lticks, DatumRange dr, boolean log) {
        TickVDescriptor result;
        Datum tickM;
        String[] ss;
        Units u = dr.getUnits();
        int islash = lticks.indexOf(47);
        int minorMult = 0;
        double[] minorList = null;
        double[] minorListAbs = null;
        String minorTicksSpec = null;
        if (islash > -1) {
            TickVDescriptor minorT;
            minorTicksSpec = lticks.substring(islash + 1);
            lticks = lticks.substring(0, islash);
            if (minorTicksSpec.startsWith("+")) {
                minorT = GraphUtil.calculateManualTicks(minorTicksSpec, dr, log);
                if (minorT != null) {
                    minorListAbs = minorT.tickV.toDoubleArray(u);
                }
            } else if (minorTicksSpec.startsWith("*")) {
                minorT = GraphUtil.calculateManualTicks(minorTicksSpec, dr, log);
                if (minorT != null) {
                    minorListAbs = minorT.tickV.toDoubleArray(u);
                }
            } else if (minorTicksSpec.contains(",")) {
                ss = minorTicksSpec.split(",");
                minorList = new double[ss.length];
                for (int i = 0; i < ss.length; ++i) {
                    minorList[i] = Double.parseDouble(ss[i]);
                }
            } else {
                try {
                    minorMult = Integer.parseInt(minorTicksSpec);
                }
                catch (NumberFormatException ex) {
                    logger.log(Level.INFO, "unable to parse integer after slash: {0}", lticks);
                }
            }
        }
        if (lticks.startsWith("+")) {
            try {
                TickVDescriptor majorTicks;
                double[] dticksMinor;
                tickM = u.getOffsetUnits().parse(lticks.substring(1));
                double min = dr.min().doubleValue(u);
                double max = dr.max().doubleValue(u);
                double dt = tickM.doubleValue(u.getOffsetUnits());
                if (dt == 0.0) {
                    logger.warning("delta ticks cannot be 0.");
                    return null;
                }
                double firstTick = Math.floor(min / dt) * dt;
                double lastTick = Math.ceil(max / dt) * dt;
                int ntick = (int)((lastTick - firstTick) / dt) + 1;
                ntick = Math.max(0, ntick);
                ntick = Math.min(480, ntick);
                double[] dticks = new double[ntick];
                for (int i = 0; i < dticks.length; ++i) {
                    dticks[i] = firstTick + (double)i * dt;
                }
                if (minorList != null) {
                    double minorUnitsMult = 1.0;
                    try {
                        minorUnitsMult = DatumUtil.parse((String)lticks.substring(1)).getUnits().convertDoubleTo(u.getOffsetUnits(), 1.0);
                    }
                    catch (ParseException | InconvertibleUnitsException ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                    dticksMinor = new double[ntick * minorList.length];
                    for (int i = 0; i < dticks.length; ++i) {
                        double dd = dticks[i];
                        for (int j = 0; j < minorList.length; ++j) {
                            dticksMinor[i * minorList.length + j] = dd + minorList[j] * minorUnitsMult;
                        }
                    }
                } else if (minorListAbs != null) {
                    dticksMinor = minorListAbs;
                } else {
                    int minorTicks = minorMult > 0 ? minorMult : GraphUtil.updateTickVManualTicksMinor(dt);
                    dt /= (double)minorTicks;
                    dticksMinor = new double[ntick * minorTicks];
                    for (int i = 0; i < dticksMinor.length; ++i) {
                        dticksMinor[i] = firstTick + (double)i * dt;
                    }
                }
                result = majorTicks = new TickVDescriptor(dticksMinor, dticks, u);
            }
            catch (ParseException ex) {
                logger.warning(ex.getMessage());
                result = null;
            }
        } else if (lticks.startsWith("*")) {
            try {
                TickVDescriptor majorTicks;
                tickM = u.getOffsetUnits().parse(lticks.substring(1));
                if (tickM.value() <= 0.0) {
                    logger.warning("delta ticks cannot be less than or equal to 0.");
                    return null;
                }
                double dt = Math.log10(tickM.doubleValue(u.getOffsetUnits()));
                if (dt == 0.0) {
                    logger.warning("delta ticks cannot be 1.");
                    return null;
                }
                double min = dr.min().doubleValue(u);
                double max = dr.max().doubleValue(u);
                if (max <= 0.0) {
                    max = 100.0;
                }
                if (min <= 0.0) {
                    min = max / 1000.0;
                }
                double firstTick = Math.floor(Math.log10(min) / dt) * dt;
                double lastTick = Math.ceil(Math.log10(max) / dt) * dt;
                int ntick = (int)((lastTick - firstTick) / dt) + 1;
                ntick = Math.max(0, ntick);
                ntick = Math.min(480, ntick);
                double[] dticks = new double[ntick];
                for (int i = 0; i < dticks.length; ++i) {
                    dticks[i] = Math.pow(10.0, firstTick + (double)i * dt);
                }
                ArrayList<Double> dticksMinorList = new ArrayList<Double>();
                if (minorTicksSpec != null && minorTicksSpec.startsWith("+")) {
                    TickVDescriptor minorTicksOneCycle = GraphUtil.calculateManualTicks(minorTicksSpec, DatumRange.newDatumRange((double)1.0, (double)tickM.value(), (Units)Units.dimensionless), false);
                    minorList = minorTicksOneCycle.getMajorTicks().toDoubleArray(Units.dimensionless);
                } else if (minorList == null) {
                    switch (minorMult) {
                        case 2: {
                            minorList = new double[]{10.0};
                            break;
                        }
                        case 3: {
                            minorList = new double[]{10.0, 100.0};
                            break;
                        }
                        default: {
                            minorList = new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
                        }
                    }
                }
                for (int i = 0; i < dticks.length - 1; ++i) {
                    double d = dticks[i];
                    dticksMinorList.add(d);
                    for (int j = 0; j < minorList.length; ++j) {
                        dticksMinorList.add(d * minorList[j]);
                    }
                }
                double[] dticksMinor = new double[dticksMinorList.size()];
                for (int i = 0; i < dticksMinor.length; ++i) {
                    dticksMinor[i] = (Double)dticksMinorList.get(i);
                }
                result = majorTicks = new TickVDescriptor(dticksMinor, dticks, u);
            }
            catch (ParseException ex) {
                logger.warning(ex.getMessage());
                result = null;
            }
        } else {
            TickVDescriptor majorTicks;
            double[] dticksMinor;
            if (lticks.equals("none")) {
                return new TickVDescriptor(new double[0], new double[0], u);
            }
            ss = lticks.split(",");
            double[] dticks = new double[ss.length];
            for (int i = 0; i < dticks.length; ++i) {
                try {
                    dticks[i] = u.parse(ss[i]).doubleValue(u);
                    continue;
                }
                catch (ParseException ex) {
                    logger.log(Level.WARNING, "failed to parse tick: {0}", ss[i]);
                    dticks[i] = 0.0;
                }
            }
            if (minorList != null) {
                dticksMinor = new double[minorList.length];
                System.arraycopy(minorList, 0, dticksMinor, 0, dticksMinor.length);
            } else if (dticks.length > 2) {
                double dt = DasMath.gcd((double[])dticks, (double)((dticks[1] - dticks[0]) / 100.0));
                int minorTicks = minorMult > 0 ? minorMult : GraphUtil.updateTickVManualTicksMinor(dt);
                double firstTick = DasMath.min((double[])dticks);
                double lastTick = DasMath.max((double[])dticks);
                int ntick = (int)(Math.ceil(lastTick - firstTick) / (dt /= (double)minorTicks)) + 1;
                dticksMinor = new double[ntick];
                for (int i = 0; i < dticksMinor.length; ++i) {
                    dticksMinor[i] = firstTick + (double)i * dt;
                }
            } else {
                dticksMinor = dticks;
            }
            result = majorTicks = new TickVDescriptor(dticksMinor, dticks, u);
        }
        return result;
    }

    public static class DebuggingGeneralPath {
        GeneralPath delegate;
        int count = 0;
        double lastfx0 = 0.0;
        double lastfy0 = 0.0;
        double initx = 0.0;
        double inity = 0.0;
        boolean arrows = false;
        boolean printRoute = true;

        DebuggingGeneralPath(int rule, int capacity) {
            this.delegate = new GeneralPath(rule, capacity);
            System.err.println(String.format("==newPath==", new Object[0]));
            this.count = 0;
        }

        DebuggingGeneralPath() {
            this.delegate = new GeneralPath(1, 20);
            System.err.println(String.format("==newPath==", new Object[0]));
            this.count = 0;
        }

        public void setArrows(boolean drawArrows) {
            this.arrows = drawArrows;
        }

        public void lineTo(double fx, double fy) {
            int len;
            double n;
            double perpx;
            double perpy;
            if (this.printRoute) {
                System.err.println(new Formatter().format(Locale.US, "lineTo(%5.1f,%5.1f) %d", fx, fy, this.count).toString());
            }
            if (this.arrows && this.inity == this.lastfy0 && this.initx == this.lastfx0) {
                perpy = fx - this.lastfx0;
                perpx = -1.0 * (fy - this.lastfy0);
                n = Math.sqrt(perpx * perpx + perpy * perpy);
                len = 4;
                this.delegate.lineTo(this.lastfx0 - (perpx /= n) * (double)len, this.lastfy0 - (perpy /= n) * (double)len);
                this.delegate.lineTo(this.lastfx0 + perpx * (double)len, this.lastfy0 + perpy * (double)len);
                this.delegate.moveTo(this.lastfx0, this.lastfy0);
            }
            this.delegate.lineTo(fx, fy);
            if (this.arrows) {
                perpy = fx - this.lastfx0;
                perpx = -1.0 * (fy - this.lastfy0);
                n = Math.sqrt(perpx * perpx + perpy * perpy);
                len = 4;
                this.delegate.lineTo(fx + (perpx /= n) * (double)len - (perpy /= n) * (double)len, fy + perpy * (double)len + perpx * (double)len);
                this.delegate.lineTo(fx, fy);
            }
            this.lastfx0 = fx;
            this.lastfy0 = fy;
            ++this.count;
        }

        public void moveTo(double fx, double fy) {
            if (this.printRoute) {
                System.err.println(new Formatter().format(Locale.US, "moveTo(%5.1f,%5.1f) %d", fx, fy, this.count).toString());
            }
            this.delegate.moveTo(fx, fy);
            this.lastfx0 = fx;
            this.lastfy0 = fy;
            if (this.count == 0) {
                this.initx = fx;
                this.inity = fy;
            }
            ++this.count;
        }

        PathIterator getPathIterator(AffineTransform at) {
            return this.delegate.getPathIterator(at);
        }

        GeneralPath getGeneralPath() {
            return this.delegate;
        }
    }

    public static interface Copyable<T> {
        public T copy();
    }

    private static class ImagePainter
    implements GrannyTextRenderer.Painter {
        private static Map<String, BufferedImage> cache = new HashMap<String, BufferedImage>();
        private static Map<String, Long> cacheBirthMilli = new HashMap<String, Long>();
        private static long CACHE_TIMEOUT_MS = 10000L;

        private ImagePainter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Rectangle2D paint(Graphics2D g, String[] args) {
            try {
                double scale;
                BufferedImage im;
                ImagePainter imagePainter = this;
                synchronized (imagePainter) {
                    Long milli = cacheBirthMilli.get(args[0]);
                    if (milli == null || System.currentTimeMillis() - milli > CACHE_TIMEOUT_MS) {
                        URI uri = FileSystemUtil.toUri((String)args[0]);
                        File f = FileSystemUtil.downloadResourceAsFile((URI)uri, (ProgressMonitor)new AlertNullProgressMonitor("load image"));
                        im = ImageIO.read(f);
                        cache.put(args[0], im);
                        cacheBirthMilli.put(args[0], System.currentTimeMillis());
                    } else {
                        im = cache.get(args[0]);
                    }
                }
                if (args.length < 2) {
                    scale = 1.0;
                } else {
                    double ws;
                    try {
                        ws = Double.parseDouble(args[1]);
                    }
                    catch (NumberFormatException ex) {
                        ws = DasDevicePosition.parseLayoutStr(args[1], g.getFont().getSize2D(), im.getWidth(), im.getWidth());
                    }
                    scale = ws / (double)im.getWidth();
                }
                int h = (int)((double)im.getHeight() * scale);
                int w = (int)((double)im.getWidth() * scale);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.scale(scale, scale);
                g.drawImage((Image)im, 0, -im.getHeight(), null);
                Rectangle r = new Rectangle(0, -h, w, h);
                return r;
            }
            catch (IOException | NumberFormatException ex) {
                g.drawLine(0, 0, 16, 16);
                g.drawLine(0, 16, 16, 0);
                Rectangle r = new Rectangle(0, 0, 16, 16);
                g.draw(r);
                return r;
            }
        }
    }
}

