/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.graph.Arrow;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.graph.TickVDescriptor;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;

public class PolarPlotRenderer
extends Renderer {
    private GeneralPath path;
    private Shape _shape;
    private DasAxis tinyX;
    private DasAxis tinyY;
    private Icon icon;
    PropertyChangeListener rebinListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            PolarPlotRenderer.this.update();
            PolarPlotRenderer.this.updateCacheImage();
        }
    };
    private Color color = Color.BLACK;
    private double lineWidth = 1.0;
    public static final String PROP_LINEWIDTH = "lineWidth";
    public static final String PROP_ORIGINNORTH = "originNorth";
    protected boolean originNorth = false;
    private boolean clockwise = false;
    public static final String PROP_CLOCKWISE = "clockwise";
    public static final String PROP_ORIGIN = "origin";
    protected String origin = "";
    private boolean drawPolarAxes = false;
    public static final String PROP_DRAWPOLARAXES = "drawPolarAxes";
    protected boolean mirror = false;
    public static final String PROP_MIRROR = "mirror";

    public PolarPlotRenderer(DasColorBar cb) {
        this.setColorBar(cb);
    }

    @Override
    public Icon getListIcon() {
        QDataSet dsl = this.getDataSet();
        if (dsl == null) {
            return super.getListIcon();
        }
        if (this.icon != null) {
            return this.icon;
        }
        BufferedImage result = new BufferedImage(64, 64, 1);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 64, 64);
        QDataSet bounds = PolarPlotRenderer.doAutorange(dsl);
        DatumRange xrange = DataSetUtil.asDatumRange((QDataSet)bounds.slice(0));
        DatumRange yrange = DataSetUtil.asDatumRange((QDataSet)bounds.slice(1));
        if (this.tinyX == null) {
            this.tinyX = new DasAxis(xrange, 2);
            this.tinyX.setColumn(new DasColumn(this.getParent().getCanvas(), null, 0.0, 0.0, 0.0, 0.0, 0, 64));
            this.tinyY = new DasAxis(yrange, 3);
            this.tinyY.setRow(new DasRow(this.getParent().getCanvas(), null, 0.0, 0.0, 0.0, 0.0, 0, 64));
        } else {
            this.tinyX.setDatumRange(xrange);
            this.tinyY.setDatumRange(yrange);
        }
        try {
            this.render(g, this.tinyX, this.tinyY);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            g.drawLine(0, 0, 64, 64);
        }
        this.icon = new ImageIcon(result.getScaledInstance(16, 16, 4));
        return this.icon;
    }

    @Override
    public boolean acceptContext(int x, int y) {
        return this.selectionArea().contains(x, y);
    }

    public Shape selectionArea() {
        Shape s;
        if (this.path == null) {
            DasRow row = this.getParent().getRow();
            DasColumn column = this.getParent().getColumn();
            return DasDevicePosition.toRectangle(row, column);
        }
        if (this._shape != null) {
            return this._shape;
        }
        this._shape = s = new BasicStroke(Math.min(14.0f, 9.0f), 1, 1).createStrokedShape(this.path);
        return s;
    }

    private static Double isAngleRange(QDataSet ds, boolean strict) {
        return Ops.isAngleRange((QDataSet)ds, (boolean)strict);
    }

    public static boolean acceptsData(QDataSet ds) {
        switch (ds.rank()) {
            case 2: {
                if (SemanticOps.isTimeSeries((QDataSet)ds)) {
                    return false;
                }
                if (SemanticOps.isBundle((QDataSet)ds)) {
                    return false;
                }
                QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)ds);
                QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
                if (PolarPlotRenderer.isAngleRange(xds, true) != null) {
                    return true;
                }
                return PolarPlotRenderer.isAngleRange(yds, true) != null;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void setColorBar(DasColorBar colorBar) {
        DasColorBar oldColorBar = this.colorBar;
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("log", this.rebinListener);
            this.colorBar.removePropertyChangeListener("type", this.rebinListener);
            this.colorBar.removePropertyChangeListener("fillColor", this.rebinListener);
        }
        this.colorBar = colorBar;
        if (this.colorBar != null) {
            colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            colorBar.addPropertyChangeListener("log", this.rebinListener);
            colorBar.addPropertyChangeListener("type", this.rebinListener);
            colorBar.addPropertyChangeListener("fillColor", this.rebinListener);
        }
        this.propertyChangeSupport.firePropertyChange("colorBar", oldColorBar, colorBar);
    }

    @Override
    public void update() {
        super.update();
        this.icon = null;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        double oldLineWidth = this.lineWidth;
        this.lineWidth = lineWidth;
        this.update();
        this.propertyChangeSupport.firePropertyChange(PROP_LINEWIDTH, oldLineWidth, lineWidth);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.update();
        this.propertyChangeSupport.firePropertyChange("color", oldColor, color);
    }

    private static QDataSet doAutorangeRank1(QDataSet rds) {
        DDataSet xdesc;
        if (PolarPlotRenderer.isAngleRange(rds, true) != null) {
            rds = SemanticOps.xtagsDataSet((QDataSet)rds);
        }
        Units yunits = SemanticOps.getUnits((QDataSet)rds);
        DDataSet ydesc = xdesc = DDataSet.wrap((double[])new double[]{0.0, Ops.extent((QDataSet)rds).value(1)}, (Units)yunits);
        xdesc = ArrayDataSet.maybeCopy((QDataSet)Ops.rescaleRangeLogLin((QDataSet)xdesc, (double)-1.1, (double)1.1));
        ydesc = ArrayDataSet.maybeCopy((QDataSet)Ops.rescaleRangeLogLin((QDataSet)ydesc, (double)-1.1, (double)1.1));
        JoinDataSet bds = new JoinDataSet(2);
        bds.join((QDataSet)xdesc);
        bds.join((QDataSet)ydesc);
        return bds;
    }

    public static QDataSet doAutorange(QDataSet tds) {
        DDataSet xdesc;
        if (tds.rank() == 1) {
            return PolarPlotRenderer.doAutorangeRank1(tds);
        }
        Object zdesc = SemanticOps.isBundle((QDataSet)tds) ? (tds.length(0) > 2 ? Ops.extent((QDataSet)Ops.unbundle((QDataSet)tds, (int)2)) : null) : Ops.extent((QDataSet)tds);
        if (zdesc != null) {
            if (zdesc.value(0) == zdesc.value(1)) {
                if (zdesc.value(0) > 0.0) {
                    zdesc = DDataSet.wrap((double[])new double[]{0.0, zdesc.value(1)});
                    zdesc = Ops.putProperty((QDataSet)zdesc, (String)"UNITS", (Object)tds.property("UNITS"));
                } else {
                    zdesc = DDataSet.wrap((double[])new double[]{0.0, 1.0});
                    zdesc = Ops.putProperty((QDataSet)zdesc, (String)"UNITS", (Object)tds.property("UNITS"));
                }
            }
            zdesc = Ops.putProperty((QDataSet)zdesc, (String)"SCALE_TYPE", (Object)tds.property("SCALE_TYPE"));
        }
        QDataSet ads = SemanticOps.xtagsDataSet((QDataSet)tds);
        QDataSet rds = SemanticOps.ytagsDataSet((QDataSet)tds);
        if (PolarPlotRenderer.isAngleRange(rds, true) != null && PolarPlotRenderer.isAngleRange(ads, true) == null) {
            rds = SemanticOps.xtagsDataSet((QDataSet)tds);
        }
        Units yunits = SemanticOps.getUnits((QDataSet)rds);
        DDataSet ydesc = xdesc = DDataSet.wrap((double[])new double[]{0.0, Ops.extent((QDataSet)rds).value(1)}, (Units)yunits);
        xdesc = ArrayDataSet.maybeCopy((QDataSet)Ops.rescaleRangeLogLin((QDataSet)xdesc, (double)-1.1, (double)1.1));
        ydesc = ArrayDataSet.maybeCopy((QDataSet)Ops.rescaleRangeLogLin((QDataSet)ydesc, (double)-1.1, (double)1.1));
        JoinDataSet bds = new JoinDataSet(2);
        bds.join((QDataSet)xdesc);
        bds.join((QDataSet)ydesc);
        if (zdesc != null) {
            bds.join(zdesc);
        }
        return bds;
    }

    private void renderRank1(Graphics g1, DasAxis xAxis, DasAxis yAxis) {
        double dy;
        double dx;
        Double angleFactor1;
        QDataSet cds;
        QDataSet rds;
        QDataSet ads;
        Graphics2D g = (Graphics2D)g1;
        if (SemanticOps.isBundle((QDataSet)this.ds)) {
            ads = Ops.slice1((QDataSet)this.ds, (int)0);
            rds = Ops.slice1((QDataSet)this.ds, (int)1);
            cds = this.ds.length(0) == 3 ? Ops.slice1((QDataSet)this.ds, (int)2) : null;
        } else {
            ads = SemanticOps.xtagsDataSet((QDataSet)this.ds);
            rds = SemanticOps.ytagsDataSet((QDataSet)this.ds);
            cds = null;
        }
        Double angleFactor = PolarPlotRenderer.isAngleRange(ads, true);
        if (angleFactor == null && (angleFactor1 = PolarPlotRenderer.isAngleRange(rds, true)) != null) {
            QDataSet t = rds;
            rds = ads;
            ads = t;
            angleFactor = PolarPlotRenderer.isAngleRange(ads, false);
        }
        if (angleFactor == null) {
            angleFactor = 1.0;
        }
        WritableDataSet wds = Ops.copy((QDataSet)SemanticOps.weightsDataSet((QDataSet)rds));
        if (ads.rank() != 1) {
            throw new IllegalArgumentException("ads should be rank 1");
        }
        if (rds.rank() != 1) {
            throw new IllegalArgumentException("rds should be rank 1");
        }
        RankZeroDataSet cadence = DataSetUtil.guessCadenceNew((QDataSet)ads, (QDataSet)rds);
        QDataSet tds = SemanticOps.xtagsDataSet((QDataSet)ads);
        boolean close = !UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)tds));
        int i = 0;
        while (i < ads.length() && !(wds.value(i) > 0.0)) {
        }
        if (i == ads.length()) {
            this.postMessage("no valid data", Level.WARNING, null, null);
            return;
        }
        int i0 = i;
        double x = rds.value(i) * Math.cos(ads.value(i) * angleFactor);
        double y = rds.value(i) * Math.sin(ads.value(i) * angleFactor);
        ++i;
        GeneralPath gp = new GeneralPath();
        Units xunits = xAxis.getUnits();
        Units yunits = yAxis.getUnits();
        Units zunits = cds == null ? null : SemanticOps.getUnits((QDataSet)cds);
        gp.moveTo(xAxis.transform(x, xunits), yAxis.transform(y, yunits));
        boolean penDown = true;
        int lastIndex = -1;
        while (i < ads.length()) {
            if (wds.value(i) == 0.0) {
                penDown = false;
            } else {
                lastIndex = i;
                x = rds.value(i) * Math.cos(ads.value(i) * angleFactor);
                y = rds.value(i) * Math.sin(ads.value(i) * angleFactor);
                if (penDown) {
                    double dx2 = xAxis.transform(x, xunits);
                    double dy2 = yAxis.transform(y, yunits);
                    gp.lineTo(dx2, dy2);
                } else {
                    gp.moveTo(xAxis.transform(x, xunits), yAxis.transform(y, yunits));
                }
                penDown = true;
            }
            ++i;
        }
        if (close) {
            double da = Math.abs((ads.value(i0) - ads.value(lastIndex)) * angleFactor);
            if (da > Math.PI) {
                da = Math.PI * 2 - da;
            }
            if (cadence != null && cadence.rank() == 0 && da < 1.1 * cadence.value() * angleFactor) {
                x = rds.value(i0) * Math.cos(ads.value(i0) * angleFactor);
                y = rds.value(i0) * Math.sin(ads.value(i0) * angleFactor);
                dx = xAxis.transform(x, xunits);
                dy = yAxis.transform(y, yunits);
                gp.lineTo(dx, dy);
            }
        }
        g.setColor(this.color);
        g.setStroke(new BasicStroke((float)this.lineWidth));
        g.draw(gp);
        if (cds != null) {
            for (i = 0; i < ads.length(); ++i) {
                if (!(wds.value(i) > 0.0)) continue;
                double s = 3.0;
                x = rds.value(i) * Math.cos(ads.value(i) * angleFactor);
                y = rds.value(i) * Math.sin(ads.value(i) * angleFactor);
                dx = xAxis.transform(x, xunits);
                dy = yAxis.transform(y, yunits);
                int zz = this.colorBar.rgbTransform(cds.value(i), zunits);
                g.setColor(new Color(zz));
                g.fill(new Ellipse2D.Double(dx - s, dy - s, s * 2.0 + 1.0, s * 2.0 + 1.0));
            }
        }
        if (xAxis != this.tinyX) {
            this.path = gp;
            this._shape = null;
        }
    }

    private void renderRank2(Graphics2D g, DasAxis xAxis, DasAxis yAxis) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        QDataSet tds = this.ds;
        if (this.colorBar == null) {
            return;
        }
        QDataSet ads = SemanticOps.xtagsDataSet((QDataSet)tds);
        QDataSet rds = SemanticOps.ytagsDataSet((QDataSet)tds);
        Units yunits = SemanticOps.getUnits((QDataSet)rds);
        Double angleFactor = PolarPlotRenderer.isAngleRange(ads, false);
        if (PolarPlotRenderer.isAngleRange(rds, false) != null && angleFactor == null) {
            rds = SemanticOps.xtagsDataSet((QDataSet)tds);
            ads = SemanticOps.ytagsDataSet((QDataSet)tds);
            yunits = SemanticOps.getUnits((QDataSet)rds);
            tds = Ops.transpose((QDataSet)tds);
            angleFactor = PolarPlotRenderer.isAngleRange(ads, false);
        }
        if (angleFactor == null) {
            throw new IllegalArgumentException("neither dimension appears to be angles");
        }
        if (angleFactor != 1.0) {
            ads = Ops.multiply((Object)ads, (Object)angleFactor);
        }
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)tds);
        float[][] xx = new float[tds.length() + 1][tds.length(0) + 1];
        float[][] yy = new float[tds.length() + 1][tds.length(0) + 1];
        Units zunits = SemanticOps.getUnits((QDataSet)tds);
        double amin = Double.NEGATIVE_INFINITY;
        double amax = Double.POSITIVE_INFINITY;
        double da = (ads.value(1) - ads.value(0)) / 2.0;
        QDataSet rangea = Ops.extent((QDataSet)ads);
        if (rangea.value(1) - rangea.value(0) < 4.71238898038469) {
            amin = Math.PI * (double)((int)(ads.value(1) / 180.0));
            amax = Math.PI * (double)(1 + (int)(ads.value(ads.length() - 2) / 180.0));
        }
        ArrayDataSet damin = ArrayDataSet.copy((QDataSet)ads);
        ArrayDataSet damax = ArrayDataSet.copy((QDataSet)ads);
        for (int i = 0; i < damin.length(); ++i) {
            if (i == 0) {
                damin.putValue(i, Math.max(amin, ads.value(i) - da));
                damax.putValue(i, (ads.value(i + 1) + ads.value(i)) / 2.0);
                continue;
            }
            if (i < damin.length() - 1) {
                damin.putValue(i, (ads.value(i - 1) + ads.value(i)) / 2.0);
                damax.putValue(i, (ads.value(i + 1) + ads.value(i)) / 2.0);
                continue;
            }
            damin.putValue(i, (ads.value(i - 1) + ads.value(i)) / 2.0);
            damax.putValue(i, Math.min(amax, ads.value(i) + da));
        }
        if (xAxis.getUnits() != yAxis.getUnits()) {
            this.postMessage("xaxis and yaxis should have same units", Level.WARNING, null, null);
            return;
        }
        double x0 = xAxis.transform(0.0, yunits);
        double y0 = yAxis.transform(0.0, yunits);
        if (!SemanticOps.isBins((QDataSet)rds)) {
            QDataSet cadence = DataSetUtil.guessCadence((QDataSet)rds, null);
            DDataSet newRds = DDataSet.createRank2((int)rds.length(), (int)2);
            if (cadence == null) {
                for (int i = 0; i < rds.length(); ++i) {
                    double c = i == 0 ? rds.value(1) - rds.value(0) : rds.value(i) - rds.value(i - 1);
                    newRds.putValue(i, 0, rds.value(i) - c / 2.0);
                    newRds.putValue(i, 1, rds.value(i) + c / 2.0);
                }
            } else {
                double c = cadence.value();
                for (int i = 0; i < rds.length(); ++i) {
                    newRds.putValue(i, 0, rds.value(i) - c / 2.0);
                    newRds.putValue(i, 1, rds.value(i) + c / 2.0);
                }
            }
            rds = newRds;
        }
        for (int iflip = 0; iflip < 2; ++iflip) {
            if (!this.mirror && iflip == 1) continue;
            for (int j = 0; j < rds.length() - 1; ++j) {
                double v1 = rds.value(j, 0);
                double v2 = rds.value(j, 1);
                double r0x = xAxis.transform(v1, yunits) - x0;
                double r0y = y0 - yAxis.transform(v1, yunits);
                double r1x = xAxis.transform(v2, yunits) - x0;
                double r1y = y0 - yAxis.transform(v2, yunits);
                for (int i = 0; i < ads.length(); ++i) {
                    double a0 = damin.value(i);
                    double a1 = damax.value(i);
                    if (this.clockwise) {
                        a0 = -a0;
                        a1 = -a1;
                    }
                    if (iflip == 1) {
                        a0 = -a0;
                        a1 = -a1;
                    }
                    if (this.origin.length() > 0) {
                        if (this.origin.equalsIgnoreCase("N")) {
                            a0 += 1.5707963267948966;
                            a1 += 1.5707963267948966;
                        } else if (!this.origin.equalsIgnoreCase("E")) {
                            if (this.origin.equalsIgnoreCase("S")) {
                                a0 -= 1.5707963267948966;
                                a1 -= 1.5707963267948966;
                            } else if (this.origin.equalsIgnoreCase("W")) {
                                a0 += Math.PI;
                                a1 += Math.PI;
                            }
                        }
                    }
                    if (this.originNorth) {
                        yy[i][j] = (float)(y0 - Math.cos(a0) * r0y);
                        xx[i][j] = (float)(x0 - Math.sin(a0) * r0x);
                        yy[i][j + 1] = (float)(y0 - Math.cos(a0) * r1y);
                        xx[i][j + 1] = (float)(x0 - Math.sin(a0) * r1x);
                        yy[i + 1][j] = (float)(y0 - Math.cos(a1) * r0y);
                        xx[i + 1][j] = (float)(x0 - Math.sin(a1) * r0x);
                        yy[i + 1][j + 1] = (float)(y0 - Math.cos(a1) * r1y);
                        xx[i + 1][j + 1] = (float)(x0 - Math.sin(a1) * r1x);
                    } else {
                        xx[i][j] = (float)(x0 + Math.cos(a0) * r0x);
                        yy[i][j] = (float)(y0 - Math.sin(a0) * r0y);
                        xx[i][j + 1] = (float)(x0 + Math.cos(a0) * r1x);
                        yy[i][j + 1] = (float)(y0 - Math.sin(a0) * r1y);
                        xx[i + 1][j] = (float)(x0 + Math.cos(a1) * r0x);
                        yy[i + 1][j] = (float)(y0 - Math.sin(a1) * r0y);
                        xx[i + 1][j + 1] = (float)(x0 + Math.cos(a1) * r1x);
                        yy[i + 1][j + 1] = (float)(y0 - Math.sin(a1) * r1y);
                    }
                    if (!(wds.value(i, j) > 0.0)) continue;
                    int zz = this.colorBar.rgbTransform(tds.value(i, j), zunits);
                    g.setColor(new Color(zz));
                    GeneralPath gp = new GeneralPath(1, 6);
                    gp.moveTo(xx[i][j], yy[i][j]);
                    gp.lineTo(xx[i][j + 1], yy[i][j + 1]);
                    Arc2D.Double arc0 = new Arc2D.Double(x0 - r0x, y0 - r0y, r0x * 2.0, r0y * 2.0, Math.toDegrees(a0), Math.toDegrees(a1 - a0), 0);
                    gp.append(arc0.getPathIterator(null), true);
                    gp.lineTo(xx[i + 1][j + 1], yy[i + 1][j + 1]);
                    Arc2D.Double arc1 = new Arc2D.Double(x0 - r1x, y0 - r1y, r1x * 2.0, r1y * 2.0, Math.toDegrees(a1), Math.toDegrees(a0 - a1), 0);
                    gp.append(arc1.getPathIterator(null), true);
                    gp.lineTo(xx[i][j], yy[i][j]);
                    g.fill(gp);
                    g.draw(gp);
                }
            }
        }
    }

    @Override
    public void render(Graphics2D g1, DasAxis xAxis, DasAxis yAxis) {
        QDataSet tds = this.ds;
        Graphics2D g = g1;
        DasPlot parent = this.getParent();
        if (tds == null) {
            logger.fine("null data set");
            parent.postMessage((Renderer)this, "no data set", DasPlot.INFO, null, null);
            return;
        }
        if (tds.rank() == 1) {
            this.renderRank1(g1, xAxis, yAxis);
        } else {
            if (!SemanticOps.isTableDataSet((QDataSet)tds)) {
                if (SemanticOps.isBundle((QDataSet)tds)) {
                    this.renderRank1(g1, xAxis, yAxis);
                    return;
                }
                parent.postException(this, new IllegalArgumentException("expected Table: " + tds));
                return;
            }
            if (!xAxis.getUnits().isConvertibleTo(yAxis.getUnits())) {
                parent.postException(this, new IllegalArgumentException("x and y axes have different units, x=" + xAxis.getUnits() + " y=" + yAxis.getUnits()));
                return;
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.renderRank2(g, xAxis, yAxis);
        }
        if (this.drawPolarAxes) {
            double yc1;
            double xc1;
            double yc0;
            double xc0;
            Datum t;
            int i;
            Units yunits = yAxis.getUnits();
            double x0 = xAxis.transform(0.0, yunits);
            double y0 = yAxis.transform(0.0, yunits);
            Font f0 = g.getFont();
            g.setFont(f0.deriveFont((float)f0.getSize() / 2.0f));
            g.setColor(xAxis.getForeground());
            g.setStroke(new BasicStroke(0.4f));
            int dx = f0.getSize() / 6;
            DatumFormatter df = xAxis.getDatumFormatter();
            TickVDescriptor rr = xAxis.getTickV();
            DatumVector ticks = rr.tickV;
            Units u = ticks.getUnits();
            for (i = 0; i < ticks.getLength(); ++i) {
                t = ticks.get(i);
                if (!(t.doubleValue(ticks.getUnits()) > 0.0)) continue;
                xc0 = xAxis.transform(t.multiply(-1.0));
                yc0 = yAxis.transform(t);
                xc1 = xAxis.transform(t);
                yc1 = yAxis.transform(t.multiply(-1.0));
                g.drawOval((int)xc0, (int)yc0, (int)(xc1 - xc0), (int)(yc1 - yc0));
                if (xAxis.isVisible()) continue;
                g.drawString(df.format(t, xAxis.getUnits()), (int)xc1 + dx, (int)y0 - dx);
                g.drawString(df.format(t, xAxis.getUnits()), (int)xc0 + dx, (int)y0 - dx);
            }
            ticks = rr.minorTickV;
            for (i = 0; i < ticks.getLength(); ++i) {
                t = ticks.get(i);
                if (!(t.doubleValue(ticks.getUnits()) > 0.0)) continue;
                xc0 = xAxis.transform(t.multiply(-1.0));
                yc0 = yAxis.transform(t);
                xc1 = xAxis.transform(t);
                yc1 = yAxis.transform(t.multiply(-1.0));
                g.drawLine((int)xc0, (int)y0 - 1, (int)xc0, (int)(y0 + 1.0));
                g.drawLine((int)xc1, (int)y0 - 1, (int)xc1, (int)(y0 + 1.0));
                g.drawLine((int)x0 - 1, (int)yc0, (int)(x0 + 1.0), (int)yc0);
                g.drawLine((int)x0 - 1, (int)yc1, (int)(x0 + 1.0), (int)yc1);
            }
            g.setFont(f0);
            Datum rmax = ticks.get(0).abs();
            Datum rmax1 = ticks.get(ticks.getLength() - 1);
            if (rmax.lt(rmax1)) {
                rmax = rmax1;
            }
            for (int i2 = 0; i2 < 360; i2 += 30) {
                double xr0 = xAxis.transform(0.0, u);
                double yr0 = yAxis.transform(0.0, u);
                double xr1 = xAxis.transform(rmax.value() * Math.cos((double)i2 * Math.PI / 180.0), u);
                double yr1 = yAxis.transform(rmax.value() * Math.sin((double)i2 * Math.PI / 180.0), u);
                g.drawLine((int)xr0, (int)yr0, (int)xr1, (int)yr1);
            }
            if (this.originNorth) {
                Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                Point2D.Double p0 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.getRow().getDMinimum());
                Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
            } else if (this.origin.length() > 0) {
                if (this.origin.equalsIgnoreCase("N")) {
                    Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                    Point2D.Double p0 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.getRow().getDMinimum());
                    Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
                } else if (this.origin.equalsIgnoreCase("S")) {
                    Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                    Point2D.Double p0 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.getRow().getDMaximum());
                    Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
                } else if (this.origin.equalsIgnoreCase("W")) {
                    Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                    Point2D.Double p0 = new Point2D.Double(xAxis.getColumn().getDMinimum(), yAxis.transform(0.0, u));
                    Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
                } else if (this.origin.equalsIgnoreCase("E")) {
                    Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                    Point2D.Double p0 = new Point2D.Double(xAxis.getColumn().getDMaximum(), yAxis.transform(0.0, u));
                    Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
                }
            } else {
                Point2D.Double p1 = new Point2D.Double(xAxis.transform(0.0, u), yAxis.transform(0.0, u));
                Point2D.Double p0 = new Point2D.Double(xAxis.getColumn().getDMaximum(), yAxis.transform(0.0, u));
                Arrow.paintArrow(g, p0, p1, 10.0, Arrow.HeadStyle.DRAFTING);
            }
            if (!xAxis.isVisible()) {
                // empty if block
            }
        }
    }

    @Override
    protected void installRenderer() {
        DasPlot parent = this.getParent();
        if (parent != null && parent.getCanvas() != null && this.colorBar != null) {
            parent.getCanvas().add(this.colorBar, parent.getRow(), this.colorBar.getColumn());
        }
    }

    @Override
    protected void uninstallRenderer() {
    }

    @Override
    public String getControl() {
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put(PROP_MIRROR, PolarPlotRenderer.encodeBooleanControl(this.mirror));
        controls.put(PROP_ORIGINNORTH, PolarPlotRenderer.encodeBooleanControl(this.originNorth));
        controls.put(PROP_DRAWPOLARAXES, PolarPlotRenderer.encodeBooleanControl(this.drawPolarAxes));
        if (this.origin.length() > 0 && this.origin.equalsIgnoreCase("E")) {
            controls.put(PROP_ORIGIN, this.origin);
            controls.remove(PROP_ORIGINNORTH);
        }
        if (this.clockwise) {
            controls.put(PROP_CLOCKWISE, "T");
        }
        controls.put("color", PolarPlotRenderer.encodeColorControl(this.color));
        controls.put(PROP_LINEWIDTH, String.valueOf(this.lineWidth));
        return Renderer.formatControl(controls);
    }

    @Override
    public void setControl(String s) {
        super.setControl(s);
        this.mirror = this.getBooleanControl(PROP_MIRROR, false);
        this.originNorth = this.getBooleanControl(PROP_ORIGINNORTH, false);
        this.drawPolarAxes = this.getBooleanControl(PROP_DRAWPOLARAXES, false);
        this.origin = this.getControl(PROP_ORIGIN, "");
        this.clockwise = this.getBooleanControl(PROP_CLOCKWISE, false);
        this.color = this.getColorControl("color", this.color);
        this.lineWidth = this.getDoubleControl(PROP_LINEWIDTH, this.lineWidth);
    }

    public boolean isOriginNorth() {
        return this.originNorth;
    }

    public void setOriginNorth(boolean originNorth) {
        boolean oldOriginNorth = this.originNorth;
        this.originNorth = originNorth;
        this.propertyChangeSupport.firePropertyChange(PROP_ORIGINNORTH, oldOriginNorth, originNorth);
        this.update();
    }

    public boolean isClockwise() {
        return this.clockwise;
    }

    public void setClockwise(boolean clockwise) {
        boolean oldClockwise = this.clockwise;
        this.clockwise = clockwise;
        this.propertyChangeSupport.firePropertyChange(PROP_CLOCKWISE, oldClockwise, clockwise);
        this.update();
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        String oldOrigin = this.origin;
        this.origin = origin;
        this.propertyChangeSupport.firePropertyChange(PROP_ORIGIN, oldOrigin, origin);
        this.update();
    }

    public boolean isDrawPolarAxes() {
        return this.drawPolarAxes;
    }

    public void setDrawPolarAxes(boolean drawPolarAxes) {
        boolean oldDrawPolarAxes = this.drawPolarAxes;
        this.drawPolarAxes = drawPolarAxes;
        this.propertyChangeSupport.firePropertyChange(PROP_DRAWPOLARAXES, oldDrawPolarAxes, drawPolarAxes);
        this.update();
    }

    public boolean isMirror() {
        return this.mirror;
    }

    public void setMirror(boolean mirror) {
        boolean oldMirror = this.mirror;
        this.mirror = mirror;
        this.propertyChangeSupport.firePropertyChange(PROP_MIRROR, oldMirror, mirror);
        this.update();
    }
}

