/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.das2.DasProperties;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Enumeration;

public class PsymConnector
implements Enumeration,
Displayable {
    String name;
    Icon imageIcon;
    BasicStroke stroke;
    BasicStroke cacheStroke;
    float cacheWidth;
    Line2D line = new Line2D.Double();
    public static final PsymConnector NONE = new PsymConnector("None", null);
    public static final PsymConnector SOLID = new PsymConnector("Solid", new BasicStroke(1.0f, 1, 1));
    public static final PsymConnector DOTFINE = new PsymConnector("DotFine", new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{1.5f, 2.0f}, 0.0f));
    public static final PsymConnector DASHFINE = new PsymConnector("DashFine", new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{3.0f, 2.0f}, 2.5f));
    public static final PsymConnector DASHES = new PsymConnector("Dashes", new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{6.0f, 4.0f}, 5.0f));
    public static final PsymConnector DOTDASHES = new PsymConnector("DotDashes", new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 3.0f, 6.0f, 3.0f}, 4.5f));
    public static final PsymConnector DOTS = new PsymConnector("Dots", new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 3.0f}, 0.0f));

    private PsymConnector(String name, BasicStroke stroke) {
        this.name = name;
        this.stroke = stroke;
        this.cacheStroke = stroke;
        if (stroke != null) {
            this.cacheWidth = this.cacheStroke.getLineWidth();
        }
        BufferedImage i = new BufferedImage(15, 10, 1);
        Graphics2D g = (Graphics2D)((Image)i).getGraphics();
        g.setRenderingHints(DasProperties.getRenderingHints());
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, 15, 10);
        g.setColor(Color.black);
        this.drawLine(g, 2.0, 3.0, 13.0, 7.0, 2.0f);
        this.imageIcon = new ImageIcon(i);
    }

    protected Stroke getStroke(float width) {
        if (width != this.cacheWidth) {
            if (this == NONE) {
                this.cacheStroke = new BasicStroke(width);
                this.cacheWidth = width;
            } else {
                float[] dashArray = this.stroke.getDashArray();
                float[] dashArrayWidth = null;
                if (dashArray != null) {
                    dashArrayWidth = new float[dashArray.length];
                    for (int i = 0; i < dashArray.length; ++i) {
                        dashArrayWidth[i] = dashArray[i] * width;
                    }
                }
                this.cacheStroke = new BasicStroke(width, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), dashArrayWidth, this.stroke.getDashPhase() * width);
                this.cacheWidth = width;
            }
        }
        return this.cacheStroke;
    }

    public void draw(Graphics2D g, GeneralPath path, float width) {
        if (this.stroke != null) {
            Stroke s = g.getStroke();
            g.setStroke(this.getStroke(width));
            g.draw(path);
            g.setStroke(s);
        }
    }

    public final void drawLine(Graphics2D g, double x1, double y1, double x2, double y2, float width) {
        if (this.stroke != null) {
            Line2D _line = !SwingUtilities.isEventDispatchThread() ? new Line2D.Double() : this.line;
            _line.setLine(x1, y1, x2, y2);
            g.setStroke(this.getStroke(width));
            g.draw(_line);
        }
    }

    @Override
    public Icon getListIcon() {
        return this.imageIcon;
    }

    @Override
    public void drawListIcon(Graphics2D g, int x, int y) {
        ImageIcon i = (ImageIcon)this.getListIcon();
        g.drawImage(i.getImage(), x, y, null);
    }

    @Override
    public String getListLabel() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

