/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumVector;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.stream.DataTransferType;
import org.das2.stream.SkeletonDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamTool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StreamScalarDescriptor
implements SkeletonDescriptor,
Cloneable {
    private static Logger logger = LoggerManager.getLogger((String)"das2.d2s.multiy");
    private static final String[] g_sCkAry = new String[]{"type"};
    private String name = "";
    private Units units = Units.dimensionless;
    private DataTransferType transferType = DataTransferType.SUN_REAL4;
    Map properties = new HashMap();

    public StreamScalarDescriptor(Element element) throws StreamException {
        if (element.getTagName().equals("y")) {
            this.processElement(element);
        } else if (element.getTagName().equals("z")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    protected void processElement(Element element) throws StreamException {
        logger.log(Level.FINE, "processElement {0} name={1}", new Object[]{element, element.getAttribute("name")});
        for (String s : g_sCkAry) {
            if (element.hasAttribute(s)) continue;
            throw new StreamException("Das2 Stream Format error: Required Attribute '" + s + "' missing in <" + element.getTagName() + "> plane.");
        }
        if (!element.hasAttribute("units")) {
            logger.warning("required attribute units is missing, using dimensionless.");
        }
        this.name = element.getAttribute("name");
        String typeStr = element.getAttribute("type");
        DataTransferType type = DataTransferType.getByName(typeStr);
        String unitsString = element.getAttribute("units");
        this.units = Units.lookupUnits((String)unitsString);
        logger.log(Level.FINER, "element y has {0} attributes", element.getAttributes().getLength());
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node n = attrs.item(i);
            this.properties.put(n.getNodeName(), n.getNodeValue());
        }
        NodeList nl = element.getChildNodes();
        ArrayList<String> kids = new ArrayList<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            kids.add(((Element)nl.item(i)).getNodeName());
        }
        kids.remove("properties");
        for (String kid : kids) {
            logger.log(Level.WARNING, "found invalid node under y: {0}", kid);
        }
        nl = element.getElementsByTagName("properties");
        logger.log(Level.FINER, "element y has {0} properties", nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            Map<String, Object> m = StreamTool.processPropertiesElement(el);
            for (String sPropName : m.keySet()) {
                if (!sPropName.equals("name") && !sPropName.equals("type") && !sPropName.equals("units")) continue;
                throw new StreamException("Can't use reserved property names 'name''type' or 'units' in side a y-plane properties element.");
            }
            this.properties.putAll(m);
        }
        this.transferType = type;
    }

    private void processLegacyElement(Element element) {
        DataTransferType type;
        logger.log(Level.FINE, "processLegacyElement {0} name={1}", new Object[]{element, element.getAttribute("name")});
        this.name = element.getAttribute("name");
        String typeStr = element.getAttribute("type");
        this.transferType = type = DataTransferType.getByName(typeStr);
    }

    public StreamScalarDescriptor() {
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getSizeBytes() {
        return this.transferType.getSizeBytes();
    }

    public void setDataTransferType(DataTransferType transferType) {
        this.transferType = transferType;
    }

    public DataTransferType getDataTransferType() {
        return this.transferType;
    }

    @Override
    public DatumVector read(ByteBuffer input) {
        return DatumVector.newDatumVector((double[])new double[]{this.transferType.read(input)}, (Units)this.units);
    }

    @Override
    public void write(DatumVector input, ByteBuffer output) {
        this.transferType.write(input.doubleValue(0, this.units), output);
    }

    @Override
    public Element getDOMElement(Document document) {
        Element element = document.createElement("y");
        element.setAttribute("units", this.units.toString());
        element.setAttribute("type", this.transferType.toString());
        if (!this.name.equals("")) {
            element.setAttribute("name", this.name);
        }
        return element;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Map getProperties() {
        return new HashMap(this.properties);
    }
}

