/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.graph.AnchorPosition;
import org.das2.graph.AnchorType;
import org.das2.graph.DasAnnotation;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;

public class AnnotationDemo {
    JPanel contentPane;
    protected DasPlot plot1;
    protected DasPlot plot2;

    private synchronized JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
        }
        return this.contentPane;
    }

    public JFrame showFrame() {
        JFrame frame = new JFrame("Annotation Demo");
        frame.getContentPane().add(this.getContentPane());
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        return frame;
    }

    public AnnotationDemo() {
        int width = 500;
        int height = 400;
        this.getContentPane().setLayout(new BorderLayout());
        DasCanvas canvas = new DasCanvas(width, height);
        this.getContentPane().add((Component)canvas, "Center");
        DatumRange xrange = DatumRange.newRange((double)0.0, (double)10.0, (Units)Units.seconds);
        DatumRange yrange = DatumRange.newRange((double)0.1, (double)100.0, (Units)Units.dimensionless);
        this.plot1 = GraphUtil.newDasPlot(canvas, xrange, yrange);
        this.plot2 = GraphUtil.newDasPlot(canvas, xrange, yrange);
        this.plot1.getXAxis().setUseDomainDivider(true);
        this.plot1.getYAxis().setUseDomainDivider(true);
        this.plot2.getXAxis().setUseDomainDivider(true);
        this.plot2.getYAxis().setUseDomainDivider(true);
        this.plot2.setColumn(this.plot1.getColumn());
        this.plot2.getXAxis().setColumn(this.plot1.getColumn());
        this.plot2.getYAxis().setColumn(this.plot1.getColumn());
        this.plot1.getColumn().setMaxLayout("100%-20em");
        this.plot2.getYAxis().setOrientation(4);
        DasAnnotation anno = new DasAnnotation("");
        anno.setAnchorType(AnchorType.PLOT);
        anno.setAnchorPosition(AnchorPosition.OutsideNE);
        anno.setAnchorOffset("+5.0em,-0.0em");
        anno.setText("!(painter;psym;boxes;size=0.8em;connect=solid;color=red)  Annotation 1<br>!(painter;psym;boxes;size=0.8em;connect=solid;color=blue)  Second Anno");
        canvas.add(anno, this.plot1.getRow(), this.plot1.getColumn());
    }

    public static void main(String[] args) {
        new AnnotationDemo().showFrame();
    }
}

