/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.DasNameException;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.qds.AbstractQFunction;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QFunction;
import org.das2.qds.ops.Ops;

public class SlowTCABatchDemo {
    private static final Logger logger = Logger.getLogger("test.slowtca");

    public static void main(String[] args) {
        QDataSet tds;
        int width = 500;
        int height = 400;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        DasCanvas canvas1 = new DasCanvas(width, height);
        try {
            canvas1.setDasName("canvas1");
        }
        catch (DasNameException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        canvas1.setAntiAlias(true);
        panel.add(canvas1);
        QDataSet yds = Ops.sin((QDataSet)Ops.linspace((double)0.0, (double)10.0, (int)1000));
        try {
            tds = Ops.timegen((String)"2010-01-01T00:00", (String)"1 s", (int)1000);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        QDataSet ds = Ops.link((QDataSet)tds, (QDataSet)yds);
        DasAxis xaxis = GraphUtil.guessXAxis(ds);
        DasAxis yaxis = GraphUtil.guessYAxis(ds);
        DasPlot plot = new DasPlot(xaxis, yaxis);
        Renderer r = GraphUtil.guessRenderer(ds);
        plot.addRenderer(r);
        if (r instanceof SeriesRenderer) {
            ((SeriesRenderer)r).setAntiAliased(true);
        }
        xaxis.setTcaFunction((QFunction)new AbstractQFunction(){

            public QDataSet value(QDataSet parm) {
                if (parm.rank() != 1) {
                    throw new IllegalArgumentException("rank should be 1");
                }
                parm = new JoinDataSet(parm);
                QDataSet result = this.values(parm);
                return result.slice(0);
            }

            public QDataSet values(QDataSet parms) {
                BundleDataSet outbds1 = BundleDataSet.createRank1Bundle();
                DDataSet sec = DDataSet.createRank1((int)parms.length());
                sec.putProperty("LABEL", (Object)"Sec");
                DDataSet rand1 = DDataSet.createRank1((int)parms.length());
                rand1.putProperty("LABEL", (Object)"Rand");
                rand1.putProperty("FORMAT", (Object)"%5.2f");
                DDataSet rand2 = DDataSet.createRank1((int)parms.length());
                rand2.putProperty("LABEL", (Object)"Rand2");
                rand2.putProperty("FORMAT", (Object)"%5.3f");
                for (int i = 0; i < parms.length(); ++i) {
                    QDataSet parm = parms.slice(i);
                    QDataSet time = parm.slice(0);
                    sec.putValue(i, Ops.mod((QDataSet)time, (QDataSet)DataSetUtil.asDataSet((double)3600.0, (Units)Units.seconds)).value());
                    rand1.putValue(i, Ops.randu((int)1).slice(0).value());
                    rand2.putValue(i, Ops.randu((int)1).slice(0).value());
                }
                outbds1.bundle((QDataSet)sec);
                outbds1.bundle((QDataSet)rand1);
                outbds1.bundle((QDataSet)rand2);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                return outbds1;
            }

            public QDataSet exampleInput() {
                BundleDataSet inbds = BundleDataSet.createRank0Bundle();
                DRank0DataSet dd = DataSetUtil.asDataSet((double)0.0, (Units)Units.t2000);
                dd.putProperty("LABEL", (Object)"Time");
                inbds.bundle((QDataSet)dd);
                return inbds;
            }
        });
        xaxis.setDrawTca(true);
        canvas1.add(plot, DasRow.create(canvas1, null, "0%+2em", "100%-7em"), DasColumn.create(canvas1, null, "0%+5em", "100%-7em"));
        JFrame frame = new JFrame();
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
    }
}

