/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import javax.swing.JFrame;
import org.das2.DasException;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.graph.DasColorBar;
import org.das2.graph.SpectrogramRenderer;
import org.das2.qds.QDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import test.graph.PlotDemo;

public class SpectrogramRendererDemoRebinner
extends PlotDemo {
    public SpectrogramRendererDemoRebinner() {
        DasColorBar cb = new DasColorBar(Datum.create((int)0), Datum.create((int)1), false);
        SpectrogramRenderer rend = new SpectrogramRenderer(null, cb);
        rend.setRebinner(new MyRebinnerEnum("My Rebinner"));
        rend.setDataSet(Ops.ripples((int)20, (int)20));
        this.plot.addRenderer(rend);
        this.plot.getColumn().setEmMaximum(-10.0);
        this.plot.getXAxis().setDatumRange(DatumRange.newDatumRange((double)0.0, (double)20.0, (Units)Units.dimensionless));
    }

    public static void main(String[] args) {
        JFrame frame = new SpectrogramRendererDemoRebinner().showFrame();
        frame.setSize(800, 800);
    }

    public class MyRebinnerEnum
    extends SpectrogramRenderer.RebinnerEnum {
        public MyRebinnerEnum(String label) {
            super(new MyRebinner(), label);
        }
    }

    public class MyRebinner
    implements DataSetRebinner {
        @Override
        public QDataSet rebin(QDataSet ds, RebinDescriptor x, RebinDescriptor y, RebinDescriptor z) throws IllegalArgumentException, DasException {
            WritableDataSet result = Ops.zeros((int)x.numberOfBins(), (int)y.numberOfBins());
            for (int i = 0; i < x.numberOfBins(); ++i) {
                for (int j = 0; j < y.numberOfBins(); ++j) {
                    if ((i + j) % 2 != 0) continue;
                    result.putValue(i, j, 1.0);
                }
            }
            return result;
        }
    }
}

