/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;
import test.graph.TimeAxisDemo;

public class StackPlot {
    DasCanvas canvas;
    JPanel contentPane;
    protected DasPlot plot;
    protected DasPlot plot2;

    private synchronized JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
        }
        return this.contentPane;
    }

    public JFrame showFrame() {
        JFrame frame = new JFrame("StackPlot");
        frame.getContentPane().add(this.getContentPane());
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        return frame;
    }

    public StackPlot() {
        try {
            int width = 500;
            int height = 500;
            this.getContentPane().setLayout(new BorderLayout());
            this.canvas = new DasCanvas(width, height);
            this.getContentPane().add((Component)this.canvas, "Center");
            DatumRange xrange = DatumRangeUtil.parseTimeRange((String)"2023-08-01/P1M");
            DatumRange yrange = DatumRange.newRange((double)0.1, (double)100.0, (Units)Units.dimensionless);
            this.plot = GraphUtil.newDasPlot(this.canvas, xrange, yrange);
            this.plot.getRow().setMinLayout("+2em");
            this.plot.getRow().setMaxLayout("50%-3em");
            this.plot2 = GraphUtil.newDasPlot(this.canvas, xrange, yrange);
            this.plot2.getRow().setMinLayout("50%+1em");
            this.plot2.getRow().setMaxLayout("100%-4em");
            this.canvas.prepareForOutput(width, height);
        }
        catch (ParseException ex) {
            Logger.getLogger(TimeAxisDemo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) throws IOException {
        StackPlot p = new StackPlot();
        BufferedImage im = p.canvas.getImage(p.canvas.getWidth(), p.canvas.getHeight());
        ImageIO.write((RenderedImage)im, "png", new File("/tmp/StackPlot.png"));
        System.exit(0);
    }
}

