/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.table;

import gov.nasa.arc.pds.xml.generated.FieldBinary;
import gov.nasa.arc.pds.xml.generated.FieldBit;
import gov.nasa.arc.pds.xml.generated.GroupFieldBinary;
import gov.nasa.arc.pds.xml.generated.TableBinary;
import gov.nasa.pds.label.object.FieldDescription;
import gov.nasa.pds.label.object.FieldType;
import gov.nasa.pds.objectAccess.InvalidTableException;
import gov.nasa.pds.objectAccess.table.TableAdapter;
import java.util.ArrayList;
import java.util.List;

public class TableBinaryAdapter
implements TableAdapter {
    TableBinary table;
    List<FieldDescription> fields;

    public TableBinaryAdapter(TableBinary table) throws InvalidTableException {
        this.table = table;
        this.fields = new ArrayList<FieldDescription>();
        this.expandFields(table.getRecordBinary().getFieldBinariesAndGroupFieldBinaries(), 0);
    }

    private void expandFields(List<Object> fields, int baseOffset) throws InvalidTableException {
        for (Object field : fields) {
            if (field instanceof FieldBinary) {
                this.expandField((FieldBinary)field, baseOffset);
                continue;
            }
            this.expandGroupField((GroupFieldBinary)field, baseOffset);
        }
    }

    private void expandField(FieldBinary field, int baseOffset) {
        if (field.getPackedDataFields() != null) {
            this.expandPackedField(field, baseOffset);
        } else {
            this.expandBinaryField(field, baseOffset);
        }
    }

    private void expandBinaryField(FieldBinary field, int baseOffset) {
        FieldDescription desc = new FieldDescription();
        desc.setName(field.getName());
        desc.setType(FieldType.getFieldType(field.getDataType()));
        desc.setOffset(field.getFieldLocation().getValue().intValueExact() - 1 + baseOffset);
        desc.setLength(field.getFieldLength().getValue().intValueExact());
        if (field.getFieldFormat() != null) {
            desc.setFieldFormat(field.getFieldFormat());
        }
        if (field.getFieldStatistics() != null) {
            if (field.getFieldStatistics().getMinimum() != null) {
                desc.setMinimum(field.getFieldStatistics().getMinimum());
            }
            if (field.getFieldStatistics().getMaximum() != null) {
                desc.setMaximum(field.getFieldStatistics().getMaximum());
            }
        }
        if (desc.getType().equals((Object)FieldType.SIGNEDBITSTRING) || desc.getType().equals((Object)FieldType.UNSIGNEDBITSTRING)) {
            desc.setStartBit(0);
            desc.setStopBit(desc.getLength() - 1);
        }
        this.fields.add(desc);
    }

    private void expandPackedField(FieldBinary field, int baseOffset) {
        for (FieldBit bitField : field.getPackedDataFields().getFieldBits()) {
            this.expandBitField(field, bitField, baseOffset);
        }
    }

    private void expandBitField(FieldBinary field, FieldBit bitField, int baseOffset) {
        FieldDescription desc = new FieldDescription();
        desc.setName(bitField.getName());
        desc.setType(FieldType.getFieldType(bitField.getDataType()));
        desc.setOffset(field.getFieldLocation().getValue().intValueExact() - 1 + baseOffset);
        desc.setLength(field.getFieldLength().getValue().intValueExact());
        int startBit = 0;
        if (bitField.getStartBit() != null) {
            startBit = bitField.getStartBit().intValueExact();
        } else if (bitField.getStartBitLocation() != null) {
            startBit = bitField.getStartBitLocation().intValueExact();
        }
        desc.setStartBit(startBit - 1);
        int stopBit = 0;
        if (bitField.getStopBit() != null) {
            stopBit = bitField.getStopBit().intValueExact();
        } else if (bitField.getStopBitLocation() != null) {
            stopBit = bitField.getStopBitLocation().intValueExact();
        }
        desc.setStopBit(stopBit - 1);
        this.fields.add(desc);
    }

    private void expandGroupField(GroupFieldBinary group, int outerOffset) throws InvalidTableException {
        int actualGroupLength;
        int baseOffset = outerOffset + group.getGroupLocation().getValue().intValueExact() - 1;
        int groupLength = group.getGroupLength().getValue().intValueExact() / group.getRepetitions().intValueExact();
        if (groupLength < (actualGroupLength = this.getGroupExtent(group))) {
            groupLength = actualGroupLength;
            String msg = "ERROR: GroupFieldBinary attribute group_length is smaller than size of contained fields: " + groupLength * group.getRepetitions().intValueExact() + "<" + actualGroupLength * group.getRepetitions().intValueExact() + ".";
            throw new InvalidTableException(msg);
        }
        if (groupLength > actualGroupLength) {
            groupLength = actualGroupLength;
            String msg = "ERROR: GroupFieldBinary attribute group_length is larger than size of contained fields: " + groupLength * group.getRepetitions().intValueExact() + ">" + actualGroupLength * group.getRepetitions().intValueExact() + ".";
            throw new InvalidTableException(msg);
        }
        for (int i = 0; i < group.getRepetitions().intValueExact(); ++i) {
            this.expandFields(group.getFieldBinariesAndGroupFieldBinaries(), baseOffset);
            baseOffset += groupLength;
        }
    }

    private int getGroupExtent(GroupFieldBinary group) {
        int groupExtent = 0;
        for (Object o : group.getFieldBinariesAndGroupFieldBinaries()) {
            int fieldEnd;
            Object field;
            if (o instanceof GroupFieldBinary) {
                field = (GroupFieldBinary)o;
                fieldEnd = ((GroupFieldBinary)field).getGroupLocation().getValue().intValueExact() + this.getGroupExtent((GroupFieldBinary)field) - 1;
                groupExtent = Math.max(groupExtent, fieldEnd);
                continue;
            }
            field = (FieldBinary)o;
            fieldEnd = ((FieldBinary)field).getFieldLocation().getValue().intValueExact() + ((FieldBinary)field).getFieldLength().getValue().intValueExact() - 1;
            groupExtent = Math.max(groupExtent, fieldEnd);
        }
        return groupExtent;
    }

    @Override
    public int getRecordCount() {
        return this.table.getRecords().intValueExact();
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public FieldDescription getField(int index) {
        return this.fields.get(index);
    }

    @Override
    public FieldDescription[] getFields() {
        return this.fields.toArray(new FieldDescription[this.fields.size()]);
    }

    @Override
    public long getOffset() {
        return this.table.getOffset().getValue().longValueExact();
    }

    @Override
    public int getRecordLength() {
        return this.table.getRecordBinary().getRecordLength().getValue().intValueExact();
    }
}

