/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.DataSourceController;
import org.das2.components.DasProgressPanel;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;

public class ExportDataPanel
extends JPanel {
    private QDataSet originalDataSet;
    private QDataSet processedDataSet;
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.export");
    DataSourceFormatEditorPanel editorPanel = null;
    private JButton additionalOptionsButton;
    private ButtonGroup buttonGroup1;
    private JButton chooseFileB;
    private JTextField filenameTF;
    private JComboBox formatDL;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JRadioButton originalDataB;
    private JRadioButton processedDataB;
    private JRadioButton processedWithinXRangeB;
    private JLabel warningMessageLabel;

    public ExportDataPanel() {
        this.initComponents();
        this.warningMessageLabel.setText(" ");
    }

    public static Action createExportDataAction(final Component parent, final DataSource source) {
        return new AbstractAction("Export Data..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                QDataSet ds;
                LoggerManager.logGuiEvent((ActionEvent)e);
                try {
                    ds = source.getDataSet((ProgressMonitor)new AlertNullProgressMonitor("retrieve data"));
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                    return;
                }
                ExportDataPanel edp = new ExportDataPanel();
                Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotUI.class);
                String currentFileString = prefs.get("ExportDataCurrentFile", "");
                String currentExtString = prefs.get("ExportDataCurrentExt", ".txt");
                if (!currentExtString.equals("")) {
                    edp.getFormatDL().setSelectedItem(currentExtString);
                }
                if (!currentFileString.equals("")) {
                    URISplit split = URISplit.parse((String)currentFileString);
                    edp.getFilenameTF().setText(split.file);
                    edp.getFormatDL().setSelectedItem("." + split.ext);
                    if (currentFileString.contains("/") && (currentFileString.startsWith("file:") || currentFileString.startsWith("/"))) {
                        edp.setFile(currentFileString);
                        if (split.params != null && edp.getDataSourceFormatEditorPanel() != null) {
                            edp.getDataSourceFormatEditorPanel().setURI(currentFileString);
                        }
                    }
                }
                edp.setDataSet(ds);
                if (AutoplotUtil.showConfirmDialog2(parent, edp, "Export Data", 2) == 0) {
                    String opts = edp.getDataSourceFormatEditorPanel() == null ? null : edp.getDataSourceFormatEditorPanel().getURI();
                    String name = edp.getFilename();
                    if (opts != null) {
                        URISplit splitopts = URISplit.parse((String)opts);
                        if (splitopts.params != null && splitopts.params.length() == 0) {
                            splitopts.params = null;
                        }
                        URISplit splits = URISplit.parse((String)edp.getFilename());
                        splitopts.file = splits.file;
                        String s = URISplit.format((URISplit)splitopts);
                        name = DataSourceUtil.unescape((String)s);
                    }
                    String ext = edp.getExtension();
                    DataSourceFormat format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                    if (format == null) {
                        JOptionPane.showMessageDialog(parent, "No formatter for extension: " + ext);
                        return;
                    }
                    final String f = name;
                    prefs.put("ExportDataCurrentFile", name);
                    prefs.put("ExportDataCurrentExt", ext);
                    try {
                        format.formatData(f, ds, (ProgressMonitor)DasProgressPanel.createFramed((String)"export slice data"));
                        JPanel panel = new JPanel();
                        panel.setLayout(new BoxLayout(panel, 1));
                        panel.add(new JLabel("<html>Data formatted to<br>" + f));
                        panel.add(new JButton(new AbstractAction("Copy filename to clipboard"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                StringSelection stringSelection = new StringSelection(f);
                                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                                clipboard.setContents(stringSelection, new ClipboardOwner(){

                                    @Override
                                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                                    }
                                });
                            }
                        }));
                        JOptionPane.showMessageDialog(parent, panel);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(parent, "Exception while formatting: " + ex.getMessage());
                    }
                }
            }
        };
    }

    public void setDataSet(Application model) {
        DataSourceController dsc = model.getController().getDataSourceFilter().getController();
        this.originalDataSet = dsc.getFillDataSet();
        if (this.originalDataSet != null) {
            String name = (String)this.originalDataSet.property("NAME");
            if (name == null) {
                name = "data";
            }
            String f = new File(".").getAbsoluteFile().getParent();
            f = f.replaceAll("\\\\", "/");
            f = f + "/" + name.toLowerCase();
            this.filenameTF.setText(f);
            this.originalDataB.setToolTipText(String.format("<html>%s<br>%s</html>", this.originalDataB.getToolTipText(), this.originalDataSet));
        }
        this.processedDataSet = model.getController().getPlotElement().getController().getDataSet();
        if (this.processedDataSet != null) {
            if (!this.processedDataSet.equals(this.originalDataSet)) {
                this.processedDataB.setToolTipText(String.format("<html>%s<br>%s</html>", this.processedDataB.getToolTipText(), this.processedDataSet));
            } else {
                this.processedDataB.setToolTipText(String.format("<html>%s</html>", "No processing is done to the dataset before plotting"));
                this.processedDataB.setEnabled(false);
            }
        } else {
            this.processedDataB.setEnabled(false);
        }
    }

    public void setDataSet(QDataSet ds) {
        this.originalDataSet = ds;
        this.processedDataB.setEnabled(false);
        this.processedWithinXRangeB.setEnabled(false);
        List exts = DataSourceRegistry.getInstance().getFormatterExtensions();
        Collections.sort(exts);
        this.getFormatDL().setModel(new DefaultComboBoxModel<Object>(exts.toArray()));
        this.getFormatDL().setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String ext = String.valueOf(value);
                DataSourceFormat format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                Component parent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (parent instanceof JLabel && format != null) {
                    ((JLabel)parent).setText(value.toString() + " " + format.getDescription());
                }
                return parent;
            }
        });
        Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotUI.class);
        String currentFileString = prefs.get("ExportDataCurrentFile", "");
        String currentExtString = prefs.get("ExportDataCurrentExt", ".txt");
        if (!currentExtString.equals("")) {
            this.getFormatDL().setSelectedItem(currentExtString);
        }
        if (!currentFileString.equals("")) {
            URISplit split = URISplit.parse((String)currentFileString);
            this.getFilenameTF().setText(split.file);
            this.getFormatDL().setSelectedItem("." + split.ext);
            if (currentFileString.contains("/")) {
                this.setFile(currentFileString);
                if (split.params != null && this.getDataSourceFormatEditorPanel() != null) {
                    this.getDataSourceFormatEditorPanel().setURI(currentFileString);
                }
            }
        }
    }

    public String getFilename() {
        String s1;
        String osName;
        String name = this.getFilenameTF().getText();
        String ext = (String)this.getFormatDL().getSelectedItem();
        List exts = DataSourceRegistry.getInstance().getFormatterExtensions();
        if (name.startsWith("file://")) {
            name = name.substring(7);
        }
        if (name.startsWith("file:")) {
            name = name.substring(5);
        }
        if ((osName = System.getProperty("os.name", "applet")).startsWith("Windows") && name.startsWith("/") && name.length() > 3 && name.charAt(2) == ':') {
            name = name.substring(1);
        }
        URISplit split = URISplit.parse((String)name);
        if (split.file == null) {
            try {
                name = new File(FileSystemUtil.getPresentWorkingDirectory(), name).toString();
                split = URISplit.parse((String)name);
                if (split.file == null) {
                    throw new IllegalArgumentException("Can't use this filename: " + name);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ExportDataPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!split.file.endsWith(ext)) {
            String s = split.file;
            boolean addExt = true;
            for (String ext1 : exts) {
                if (!s.endsWith(ext1)) continue;
                addExt = false;
                ext = ext1;
            }
            if (addExt) {
                split.file = s + ext;
            }
        }
        if ((s1 = split.file).startsWith("file://")) {
            s1 = s1.substring(7);
        }
        if (s1.startsWith("file:")) {
            s1 = s1.substring(5);
        }
        Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotUI.class);
        prefs.put("ExportDataCurrentFile", s1);
        prefs.put("ExportDataCurrentExt", ext);
        return s1;
    }

    public String getExtension() {
        return (String)this.getFormatDL().getSelectedItem();
    }

    public boolean isFormatPlotElement() {
        return this.processedDataB.isSelected() && this.processedWithinXRangeB.isEnabled();
    }

    public boolean isFormatPlotElementAndTrim() {
        return this.processedWithinXRangeB.isSelected() && this.processedWithinXRangeB.isEnabled();
    }

    public boolean isOriginalData() {
        return this.originalDataB.isSelected() && this.originalDataB.isEnabled();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel2 = new JLabel();
        this.processedDataB = new JRadioButton();
        this.originalDataB = new JRadioButton();
        this.formatDL = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.filenameTF = new JTextField();
        this.chooseFileB = new JButton();
        this.additionalOptionsButton = new JButton();
        this.processedWithinXRangeB = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.warningMessageLabel = new JLabel();
        this.jLabel2.setText("Select Output Format:");
        this.buttonGroup1.add(this.processedDataB);
        this.processedDataB.setText("Processed Data or Component");
        this.processedDataB.setToolTipText("Data as displayed, including slice and other operations.  This is the loaded data, and may extend past plot boundaries.\n");
        this.buttonGroup1.add(this.originalDataB);
        this.originalDataB.setSelected(true);
        this.originalDataB.setText("Original Data");
        this.originalDataB.setToolTipText("Data read in from data source");
        this.formatDL.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.formatDL.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportDataPanel.this.formatDLItemStateChanged(evt);
            }
        });
        this.formatDL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.formatDLActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Select Data to Export:");
        this.jLabel3.setText("Filename:");
        this.filenameTF.setText("data");
        this.chooseFileB.setText("Select...");
        this.chooseFileB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.chooseFileBActionPerformed(evt);
            }
        });
        this.additionalOptionsButton.setText("Additional options for output format...");
        this.additionalOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.additionalOptionsButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.processedWithinXRangeB);
        this.processedWithinXRangeB.setText("Processed Data within X Axis Range");
        this.processedWithinXRangeB.setToolTipText("Processed data, but also trim to the data to the X axis bounds.\n");
        this.jLabel4.setText("<html><i>Data from the selected plot element can be exported to a format by data sources that provide a method to export data.");
        this.jLabel4.setVerticalAlignment(1);
        this.warningMessageLabel.setText("<html><i>(warning message)");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel4, -2, 0, Short.MAX_VALUE).add((Component)this.warningMessageLabel));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel4, -2, 51, -2).addPreferredGap(0).add((Component)this.warningMessageLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.formatDL, 0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.filenameTF).addPreferredGap(0).add((Component)this.chooseFileB)))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.originalDataB).add((Component)this.processedDataB).add((Component)this.processedWithinXRangeB))).add((Component)this.jLabel3).add((Component)this.additionalOptionsButton).add((Component)this.jLabel2).add((Component)this.jLabel1)).add(0, 258, Short.MAX_VALUE)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.originalDataB).addPreferredGap(0).add((Component)this.processedDataB).addPreferredGap(0).add((Component)this.processedWithinXRangeB).add(18, 18, 18).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.formatDL, -2, 33, -2).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.filenameTF, -2, -1, -2).add((Component)this.chooseFileB)).addPreferredGap(0).add((Component)this.additionalOptionsButton)));
    }

    private void chooseFileBActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        JFileChooser chooser = new JFileChooser();
        List exts = DataSourceRegistry.getInstance().getFormatterExtensions();
        FileFilter deflt = null;
        Iterator iterator = exts.iterator();
        while (iterator.hasNext()) {
            String ext;
            final String ex = ext = (String)iterator.next();
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().endsWith(ex) || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "*" + ex;
                }
            };
            if (ext.equals(".qds")) {
                deflt = ff;
            }
            chooser.addChoosableFileFilter(ff);
        }
        chooser.setFileFilter(deflt);
        String deft = this.filenameTF.getText();
        try {
            URL url = new URL(URISplit.parse((String)deft).file);
            chooser.setSelectedFile(new File(url.getFile()));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, null, e);
        }
        int r = chooser.showSaveDialog(this);
        if (r == 0) {
            DataSourceFormat format;
            String s = chooser.getSelectedFile().toString();
            String ext = DataSetURI.getExt((String)s);
            if (ext == null) {
                ext = "";
            }
            if ((format = DataSourceRegistry.getInstance().getFormatByExt(ext)) == null) {
                if (chooser.getFileFilter().getDescription().startsWith("*.")) {
                    ext = chooser.getFileFilter().getDescription().substring(1);
                    format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                    if (format == null) {
                        JOptionPane.showMessageDialog(this, "No formatter for extension: " + ext);
                        return;
                    }
                    s = s + ext;
                } else {
                    JOptionPane.showMessageDialog(this, "No formatter for extension: " + ext);
                    return;
                }
            }
            this.filenameTF.setText(s);
            this.formatDL.setSelectedItem("." + ext);
        }
    }

    private void formatDLActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        String ff = this.filenameTF.getText();
        if (!ff.endsWith((String)this.formatDL.getSelectedItem())) {
            int ii;
            int ii2 = ff.lastIndexOf(47);
            if (ii2 == -1) {
                ii2 = 0;
            }
            if ((ii = ff.lastIndexOf(46)) > -1 && ii > ii2) {
                this.filenameTF.setText(ff.substring(0, ii) + this.formatDL.getSelectedItem());
            }
        }
    }

    private void updateEditorPanel(String ss, boolean updateProcessing) {
        Object oeditorPanel = DataSourceRegistry.getInstance().getDataSourceFormatEditorByExt(ss);
        if (oeditorPanel != null) {
            String t;
            if (oeditorPanel instanceof String) {
                this.editorPanel = (DataSourceFormatEditorPanel)DataSourceRegistry.getInstanceFromClassName((String)((String)oeditorPanel));
                if (this.editorPanel == null) {
                    throw new IllegalArgumentException("unable to create instance: " + oeditorPanel);
                }
            } else {
                this.editorPanel = (DataSourceFormatEditorPanel)oeditorPanel;
            }
            if ((t = this.getFilenameTF().getText()).contains("/") && t.startsWith("file:")) {
                this.editorPanel.setURI(t);
            } else {
                t = URISplit.makeCanonical((String)t);
                this.editorPanel.setURI(t);
            }
        } else {
            this.editorPanel = null;
        }
        if (updateProcessing) {
            DataSourceFormat form = DataSourceRegistry.getInstance().getFormatByExt(ss);
            if (form != null) {
                this.originalDataB.setEnabled(this.originalDataSet != null && form.canFormat(this.originalDataSet));
                this.processedDataB.setEnabled(this.processedDataSet != null && form.canFormat(this.processedDataSet));
                this.processedWithinXRangeB.setEnabled(this.processedDataSet != null && form.canFormat(this.processedDataSet));
            } else {
                this.originalDataB.setEnabled(true);
                this.processedDataB.setEnabled(true);
                this.processedWithinXRangeB.setEnabled(true);
            }
            if (this.originalDataSet.equals(this.processedDataSet)) {
                this.processedDataB.setEnabled(false);
            }
            if (!this.originalDataB.isEnabled() && this.originalDataB.isSelected() && this.processedDataB.isEnabled()) {
                this.processedDataB.setSelected(true);
            }
            if (!this.processedDataB.isEnabled() && this.processedDataB.isSelected() && this.processedWithinXRangeB.isEnabled()) {
                this.processedWithinXRangeB.setSelected(true);
            }
            this.additionalOptionsButton.setEnabled(this.editorPanel != null);
        }
    }

    private void formatDLItemStateChanged(ItemEvent evt) {
        String ss = (String)evt.getItem();
        this.updateEditorPanel(ss, evt.getStateChange() == 1);
    }

    private void additionalOptionsButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        JPanel j = this.editorPanel.getPanel();
        AutoplotUtil.showConfirmDialog(this, j, "Additional Options", 2);
    }

    public JTextField getFilenameTF() {
        return this.filenameTF;
    }

    public JComboBox getFormatDL() {
        return this.formatDL;
    }

    public DataSourceFormatEditorPanel getDataSourceFormatEditorPanel() {
        return this.editorPanel;
    }

    public void setFile(String currentFileString) {
        URISplit split = URISplit.parse((String)currentFileString);
        this.filenameTF.setText(split.file);
        this.formatDLActionPerformed(null);
        if (this.editorPanel != null && currentFileString.startsWith("file:")) {
            this.editorPanel.setURI(currentFileString);
        }
        try {
            this.updateEditorPanel(split.ext, true);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    void setTsb(boolean b) {
        if (b) {
            this.warningMessageLabel.setText("<html><i>Exporting data at native resolution.</i></html>");
            this.warningMessageLabel.setToolTipText("<html><i>This data comes from a reader that can return data at multiple resolutions.  Data will be reread at native resolution before writing output.</i></html>");
        }
    }
}

