/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.fits;

import java.io.IOException;
import java.util.Enumeration;
import org.eso.fits.Fits;
import org.eso.fits.FitsColumn;
import org.eso.fits.FitsException;
import org.eso.fits.FitsFile;
import org.eso.fits.FitsHDUnit;
import org.eso.fits.FitsHeader;
import org.eso.fits.FitsKeyword;
import org.eso.fits.FitsMatrix;
import org.eso.fits.FitsTable;

public class TestFits {
    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.out.println("Error: must have at least one argument");
            System.exit(1);
        }
        System.out.println("-- Test FITS files --------");
        FitsFile file = null;
        for (int na = 0; na < argv.length; ++na) {
            try {
                file = new FitsFile(argv[na]);
            }
            catch (FitsException e) {
                System.out.println("Error: is not a FITS file >" + argv[na] + "<");
                continue;
            }
            catch (IOException e) {
                System.out.println("Error: cannot open file >" + argv[na] + "<");
                continue;
            }
            int noHDU = file.getNoHDUnits();
            System.out.println("FITS file has " + noHDU + " HDUnits");
            for (int i = 0; i < noHDU; ++i) {
                FitsMatrix dm;
                FitsHDUnit hdu = file.getHDUnit(i);
                FitsHeader hdr = hdu.getHeader();
                int noKw = hdr.getNoKeywords();
                int type = hdr.getType();
                int size = (int)hdr.getDataSize();
                System.out.println("  " + i + ": >" + hdr.getName() + "< of type >" + Fits.getType((int)type) + "< with " + noKw + " keywords and " + size + " bytes of data");
                System.out.println("   Keywords:");
                Enumeration itr = hdr.getKeywords();
                while (itr.hasMoreElements()) {
                    FitsKeyword kw = (FitsKeyword)itr.nextElement();
                    System.out.print("     " + kw.getName());
                    switch (kw.getType()) {
                        case 1: {
                            System.out.print("(C) " + kw.getComment());
                            break;
                        }
                        case 2: {
                            System.out.print("(S)= '" + kw.getString() + "'");
                            break;
                        }
                        case 3: {
                            System.out.print("(B)= " + kw.getBool());
                            break;
                        }
                        case 4: {
                            System.out.print("(I)= " + kw.getInt());
                            break;
                        }
                        case 5: {
                            System.out.print("(R)= " + kw.getReal());
                            break;
                        }
                        case 6: {
                            System.out.print("(D)= " + kw.getString());
                            break;
                        }
                    }
                    if (0 < kw.getComment().length() && kw.getType() != 1) {
                        System.out.print(" / " + kw.getComment());
                    }
                    System.out.println();
                }
                if (type == 1) {
                    System.out.println("\n  Check data matrix - compute mean and rms");
                    dm = (FitsMatrix)hdu.getData();
                    int[] naxis = dm.getNaxis();
                    double[] crval = dm.getCrval();
                    double[] crpix = dm.getCrpix();
                    double[] cdelt = dm.getCdelt();
                    System.out.println("  Dimension of matrix: " + naxis.length);
                    for (int n = 0; n < naxis.length; ++n) {
                        System.out.println("   Axis " + n + ": " + naxis[n] + ",  " + crpix[n] + ",  " + crval[n] + ",  " + cdelt[n]);
                    }
                    System.out.println("\n");
                    int nval = dm.getNoValues();
                    if (0 >= nval) continue;
                    int ncol = naxis[0];
                    int nrow = nval / ncol;
                    System.out.println(" Npixel,row,col: " + nval + ", " + nrow + ", " + ncol);
                    float[] data = new float[ncol];
                    int npix = 0;
                    int nv = 0;
                    int off = 0;
                    double rms = 0.0;
                    double mean = 0.0;
                    long time = System.currentTimeMillis();
                    for (int nr = 0; nr < nrow; ++nr) {
                        try {
                            dm.getFloatValues(off, ncol, data);
                            for (int n = 0; n < ncol; ++n) {
                                double val = data[n];
                                ++npix;
                                mean += val;
                                rms += val * val;
                            }
                        }
                        catch (FitsException fitsException) {
                            // empty catch block
                        }
                        off += ncol;
                    }
                    rms = 0.0 < (rms = rms / (double)npix - (mean /= (double)npix) * mean) ? Math.sqrt(rms) : 0.0;
                    float dtime = (float)(1000.0 * (double)(System.currentTimeMillis() - time) / (double)nval);
                    System.out.println("  Mean: " + (float)mean + ", rms: " + (float)rms + ", Time: " + dtime + " S/Mp, Pixels: " + npix);
                    continue;
                }
                if (type != 2 && type != 3) continue;
                System.out.println("\n  Check table data - list columns");
                dm = (FitsTable)hdu.getData();
                int nrow = dm.getNoRows();
                int ncol = dm.getNoColumns();
                FitsColumn[] col = new FitsColumn[ncol];
                System.out.println("  Columns: " + ncol + ", Rows: " + nrow);
                for (int n = 0; n < ncol; ++n) {
                    double val;
                    long time;
                    double mean;
                    double rms;
                    int npix;
                    col[n] = dm.getColumn(n);
                    System.out.print("  " + n + " >" + col[n].getLabel() + "<, ");
                    System.out.print(col[n].getRepeat() + " ");
                    System.out.print(col[n].getDataType() + ", >");
                    System.out.print(col[n].getDisplay() + "<, >");
                    System.out.println(col[n].getUnit() + "<");
                    if (col[n].getDataType() == 'F' || col[n].getDataType() == 'E' || col[n].getDataType() == 'D') {
                        npix = 0;
                        rms = 0.0;
                        mean = 0.0;
                        time = System.currentTimeMillis();
                        for (int nr = 0; nr < nrow; ++nr) {
                            val = col[n].getReal(nr);
                            if (Double.isNaN(val)) continue;
                            ++npix;
                            mean += val;
                            rms += val * val;
                        }
                        float dtime = (float)(1000.0 * (double)(System.currentTimeMillis() - time) / (double)nrow);
                        rms = 0.0 < (rms = rms / (double)npix - (mean /= (double)npix) * mean) ? Math.sqrt(rms) : 0.0;
                        System.out.println("      no,mean,rms: " + npix + ", " + (float)mean + ", " + (float)rms + "; " + dtime + " S/Mp");
                        continue;
                    }
                    if (col[n].getDataType() != 'I' && col[n].getDataType() != 'J' && col[n].getDataType() != 'B') continue;
                    npix = 0;
                    rms = 0.0;
                    mean = 0.0;
                    time = System.currentTimeMillis();
                    for (int nr = 0; nr < nrow; ++nr) {
                        val = col[n].getInt(nr);
                        if (val == -9.223372036854776E18) continue;
                        ++npix;
                        mean += val;
                        rms += val * val;
                    }
                    float dtime = (float)(1000.0 * (double)(System.currentTimeMillis() - time) / (double)nrow);
                    rms = 0.0 < (rms = rms / (double)npix - (mean /= (double)npix) * mean) ? Math.sqrt(rms) : 0.0;
                    System.out.println("      no,mean,rms: " + npix + ", " + (float)mean + ", " + (float)rms + "; " + dtime + " S/Mp");
                }
            }
            System.out.println("-- Test finished -----------------");
        }
        System.exit(0);
    }
}

