/*
 * Decompiled with CFR 0.152.
 */
package ftpfs;

import ftpfs.FTPBeanFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.filesystem.WriteCapability;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class FtpFileObject
extends WebFileObject {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.filesystem");
    FTPBeanFileSystem ftpfs;
    WriteCapability write = new WriteCapability(){

        public OutputStream getOutputStream() throws IOException {
            return FtpFileObject.this.getOutputStream(false);
        }

        public boolean canWrite() {
            return true;
        }

        public synchronized boolean delete() throws IOException {
            File localFile;
            File listingFile = new File(FtpFileObject.this.getLocalFile().getParent(), ".listing");
            if (listingFile.exists()) {
                FtpFileObject.this.ftpfs.resetListCache(FtpFileObject.this.getParent().getNameExt());
            }
            if ((localFile = FtpFileObject.this.getLocalFile()).exists() && !localFile.delete()) {
                throw new IOException("unable to delete local file " + localFile);
            }
            return FtpFileObject.this.ftpfs.delete(FtpFileObject.this);
        }

        public boolean commit(String message) throws IOException {
            logger.info("commit has no effect");
            return true;
        }
    };

    protected FtpFileObject(WebFileSystem wfs, String pathname, Date modifiedDate) {
        super(wfs, pathname, modifiedDate);
        this.ftpfs = (FTPBeanFileSystem)wfs;
    }

    public long getSize() {
        boolean tinyGzFib = true;
        File listing = new File(this.getLocalFile().getParent(), ".listing");
        if (listing.exists()) {
            try {
                FileSystem.DirectoryEntry[] list = this.ftpfs.parseLslNew(null, listing);
                int ii = this.getNameExt().lastIndexOf(47);
                String lookFor = this.getNameExt().substring(ii + 1);
                String lookForGz = this.getNameExt().substring(ii + 1) + ".gz";
                for (int i = 0; i < list.length; ++i) {
                    if (list[i].name.equals(lookFor)) {
                        return list[i].size;
                    }
                    if (!tinyGzFib || !list[i].name.equals(lookForGz)) continue;
                    logger.log(Level.FINE, "approximating size of gzipped file {0} when it is uncompressed", list[i].name);
                    return 2000L * Math.round((double)list[i].size / 2000.0) * 5L;
                }
                return -1L;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return -1L;
            }
        }
        return -1L;
    }

    public boolean exists() {
        if (this.getLocalFile() != null && this.getLocalFile().exists()) {
            return true;
        }
        File listing = new File(this.getLocalFile().getParent(), ".listing");
        if (!listing.exists()) {
            try {
                this.ftpfs.listDirectory(this.getParent().getNameExt());
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
        }
        if (listing.exists()) {
            try {
                FileSystem.DirectoryEntry[] list = this.ftpfs.parseLslNew(null, listing);
                int ii = this.getNameExt().lastIndexOf(47);
                String lookFor = this.getNameExt().substring(ii + 1);
                for (int i = 0; i < list.length; ++i) {
                    if (!list[i].name.equals(lookFor)) continue;
                    return true;
                }
                return false;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
        }
        if (!this.ftpfs.isOffline()) {
            FileSystem.getExceptionHandler().handleUncaught((Throwable)new IOException("local listing file (.listing) not found"));
        }
        return false;
    }

    public <T> T getCapability(Class<T> clazz) {
        if (clazz == WriteCapability.class) {
            return (T)this.write;
        }
        return (T)super.getCapability(clazz);
    }

    public OutputStream getOutputStream(boolean append) throws IOException {
        try {
            this.getFile((ProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!append && this.exists()) {
            throw new IllegalArgumentException("file exists in file system already!");
        }
        return new FileOutputStream(this.getLocalFile(), append){

            @Override
            public void close() throws IOException {
                super.close();
                FtpFileObject.this.ftpfs.uploadFile(FtpFileObject.this.getNameExt(), FtpFileObject.this.getLocalFile(), (ProgressMonitor)new NullProgressMonitor());
            }
        };
    }

    public InputStream getInputStream(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (this.isFolder()) {
            throw new IllegalArgumentException("is a folder");
        }
        if (this.lastModified().getTime() == 0L) {
            FileSystem.DirectoryEntry result = this.ftpfs.maybeUpdateDirectoryEntry(this.getNameExt(), true);
            this.setLastModified(new Date(result.modified));
        }
        File localFile = this.getLocalFile();
        if (!this.getLocalFile().exists() || this.lastModified().getTime() - this.getLocalFile().lastModified() > 10L) {
            this.ftpfs.downloadFile(this.getNameExt(), localFile, this.ftpfs.getPartFile(localFile), monitor);
        }
        FtpFileObject ftpFileObject = this;
        ftpFileObject.ftpfs.getLogger().log(Level.FINE, "read local file {0}", localFile);
        return new FileInputStream(localFile);
    }
}

