/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.TimeRangeEditor;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.WindowManager;
import org.das2.datum.DatumRange;
import org.das2.util.LoggerManager;

public class DataSetSelectorSupport {
    private static final Logger logger = Logger.getLogger("apdss.dss");
    DataSetSelector ui;
    private JMenu recentMenu = null;

    DataSetSelectorSupport(DataSetSelector ui) {
        this.ui = ui;
    }

    private static File userHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String browseLocalVap(Component parent, String initialSelection) {
        DatumRange tr;
        URISplit split;
        Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotSettings.class);
        String currentDirectory = prefs.get("last_open_vap_folder", prefs.get("last_open_folder", DataSetSelectorSupport.userHome().toString()));
        String currentFile = prefs.get("last_open_vap_file", "");
        boolean isRemote = initialSelection != null && (initialSelection.startsWith("https:/") || initialSelection.startsWith("http:/") || initialSelection.startsWith("ftp:/") || initialSelection.startsWith("sftp:/"));
        boolean isLocal = initialSelection == null || initialSelection.isEmpty() || !isRemote;
        JFileChooser chooser = new JFileChooser();
        WindowManager.getInstance().recallWindowSizePosition(chooser);
        try {
            chooser.setCurrentDirectory(new File(currentDirectory));
        }
        catch (SecurityException ex) {
            logger.info("unable to set current directory");
        }
        if (initialSelection != null) {
            split = URISplit.parse(initialSelection);
            if (".vap".equals(split.ext) && "file".equals(split.scheme)) {
                chooser.setSelectedFile(new File(split.file));
                currentFile = "";
            }
        }
        if (currentFile.length() > 0) {
            try {
                chooser.setSelectedFile(new File(currentFile));
            }
            catch (SecurityException ex) {
                logger.info("unable to set current file");
            }
        }
        if (initialSelection != null && isLocal) {
            split = URISplit.parse(initialSelection);
            if (split.file != null && "vap".equals(split.ext)) {
                chooser.setSelectedFile(new File(split.file));
            }
        }
        JPanel trPanel = new JPanel();
        trPanel.setLayout(new BoxLayout(trPanel, 1));
        trPanel.setMaximumSize(new Dimension(230, 9999));
        trPanel.setPreferredSize(new Dimension(230, 200));
        ButtonGroup bg = new ButtonGroup();
        JCheckBox b1 = new JCheckBox("Use timerange in .vap file");
        bg.add(b1);
        final TimeRangeEditor t = new TimeRangeEditor();
        if (parent != null && parent instanceof DataSetSelector && (tr = ((DataSetSelector)parent).getTimeRange()) != null) {
            t.setRange(tr);
        }
        t.makeThinner();
        final JCheckBox b2 = new JCheckBox("Reset the .vap timerange:");
        bg.add(b2);
        boolean notimerange = initialSelection == null || !initialSelection.contains("?timerange=");
        b1.setSelected(notimerange);
        b2.setSelected(!notimerange);
        b1.setAlignmentX(0.0f);
        b2.setAlignmentX(0.0f);
        t.setAlignmentX(0.0f);
        trPanel.add(b1);
        trPanel.add(Box.createVerticalStrut(14));
        trPanel.add(b2);
        trPanel.add(t);
        ActionListener enableTR = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                t.setEnabled(b2.isSelected());
            }
        };
        b1.addActionListener(enableTR);
        b2.addActionListener(enableTR);
        t.setEnabled(b2.isSelected());
        trPanel.add(Box.createVerticalGlue());
        if (chooser != null) {
            chooser.setAccessory(trPanel);
            FileNameExtensionFilter ff = new FileNameExtensionFilter(".vap files", "vap");
            chooser.addChoosableFileFilter(ff);
            chooser.setFileFilter(ff);
            Window w = parent == null ? null : SwingUtilities.getWindowAncestor(parent);
            int result = chooser.showOpenDialog(w);
            if (result == 0) {
                prefs.put("last_open_vap_folder", chooser.getSelectedFile().getParent());
                WindowManager.getInstance().recordWindowSizePosition(chooser);
                if (b2.isSelected()) {
                    return chooser.getSelectedFile().toURI().toString() + "?timerange=" + t.getRange().toString().replaceAll("\\s+", "+");
                }
                return chooser.getSelectedFile().toURI().toString();
            }
            return null;
        }
        if (JOptionPane.showConfirmDialog(parent, trPanel, "New Time Range", 2) == 0) {
            URISplit split2 = URISplit.parse(initialSelection);
            LinkedHashMap<String, String> params = URISplit.parseParams(split2.params);
            if (b2.isSelected()) {
                params.put("timerange", t.getRange().toString().replaceAll("\\s", "+"));
            } else {
                params.remove("timerange");
            }
            split2.params = params.isEmpty() ? null : URISplit.formatParams(params);
            return URISplit.format(split2);
        }
        return null;
    }

    public static String browseLocal(Component parent) {
        Preferences prefs = AutoplotSettings.settings().getPreferences(DataSetSelectorSupport.class);
        String currentDirectory = prefs.get("last_open_folder", DataSetSelectorSupport.userHome().toString());
        final HashMap<String, Object> exts = DataSourceRegistry.getInstance().dataSourcesByExt;
        JFileChooser chooser = new JFileChooser();
        try {
            chooser.setCurrentDirectory(new File(currentDirectory));
        }
        catch (SecurityException ex) {
            logger.info("unable to set current directory because of security");
        }
        final boolean isAutoplotApp = parent instanceof DataSetSelector ? ((DataSetSelector)parent).actionTriggers.containsKey("vapfile:(.*)") : true;
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String t = f.getName();
                String ext = DataSetURI.getExt(t);
                if (ext != null) {
                    ext = "." + ext;
                }
                return t.endsWith(".zip") || t.endsWith(".ZIP") || t.endsWith(".tar") || t.endsWith(".tgz") || t.endsWith(".tar.gz") || ext != null && exts.containsKey(ext) || isAutoplotApp && t.endsWith(".vap");
            }

            @Override
            public String getDescription() {
                return "supported formats";
            }
        };
        chooser.addChoosableFileFilter(ff);
        FileFilter select = ff;
        ArrayList<String> s = new ArrayList<String>(exts.keySet());
        Collections.sort(s);
        HashSet<String> skip = new HashSet<String>();
        skip.add(".cdfj");
        skip.add(".cdfn");
        skip.add(".csv0");
        for (String ext1 : s) {
            DataSourceFactory factory;
            if (skip.contains(ext1) || !(factory = DataSourceRegistry.getInstance().getSource(ext1)).isFileResource()) continue;
            String extf = ext1;
            String desc = DataSourceRegistry.getInstance().describe(factory, extf);
            desc = desc.length() == 0 || desc.startsWith(".") ? "*" + ext1 : "*" + ext1 + " " + desc;
            ff = new FileNameExtensionFilter(desc, extf.substring(1));
            chooser.addChoosableFileFilter(ff);
        }
        if (isAutoplotApp) {
            ff = new FileNameExtensionFilter("*.vap", "vap");
            chooser.addChoosableFileFilter(ff);
        }
        chooser.setFileFilter(select);
        int result = chooser.showOpenDialog(parent);
        if (result == 0) {
            prefs.put("last_open_folder", chooser.getSelectedFile().getParent());
            return chooser.getSelectedFile().toURI().toString();
        }
        return null;
    }

    public Action openLocalAction() {
        return new AbstractAction("Add Plot from Local File..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                String result = DataSetSelectorSupport.browseLocal(DataSetSelectorSupport.this.ui);
                if (result != null) {
                    DataSetSelectorSupport.this.ui.setValue(result);
                    DataSetSelectorSupport.this.ui.maybePlot(8);
                }
            }
        };
    }

    public Action openLocalVapAction() {
        return new AbstractAction("Open .vap File..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                String result = DataSetSelectorSupport.browseLocalVap(DataSetSelectorSupport.this.ui, DataSetSelectorSupport.this.ui.getValue());
                if (result != null) {
                    DataSetSelectorSupport.this.ui.setValue(result);
                    DataSetSelectorSupport.this.ui.maybePlot(false);
                }
            }
        };
    }

    protected void refreshRecentFilesMenu() {
        if (this.recentMenu != null) {
            this.recentMenu.removeAll();
            ArrayList<String> recent = new ArrayList<String>(this.ui.getRecent());
            Collections.reverse(recent);
            Iterator<String> iterator = recent.iterator();
            while (iterator.hasNext()) {
                String s;
                final String f = s = iterator.next();
                AbstractAction a = new AbstractAction(String.valueOf(f)){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        DataSetSelectorSupport.this.ui.setValue(f);
                        DataSetSelectorSupport.this.ui.maybePlot(false);
                    }
                };
                this.recentMenu.add(a);
            }
        }
    }

    public static String getPluginsText() {
        return DataSourceRegistry.getPluginsText();
    }

    JMenu recentMenu() {
        if (this.recentMenu == null) {
            this.recentMenu = new JMenu("Open Recent");
            this.refreshRecentFilesMenu();
        }
        return this.recentMenu;
    }

    protected void browseSourceTypes() {
    }
}

