/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.LoggerManager;

public class DefaultTimeSeriesBrowse
implements TimeSeriesBrowse {
    public String uri;
    DatumRange timeRange;
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.util");

    public static TimeSeriesBrowse create(String uri, String timerange) throws ParseException {
        DefaultTimeSeriesBrowse tsb = new DefaultTimeSeriesBrowse();
        tsb.setURI(uri);
        if (timerange != null) {
            tsb.setTimeRange(DatumRangeUtil.parseTimeRange((String)timerange));
        }
        return tsb;
    }

    @Override
    public void setURI(String suri) throws ParseException {
        logger.log(Level.FINE, "setURI {0}", suri);
        this.uri = suri;
        URISplit split = URISplit.parse(this.uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String sdr = (String)params.get("timerange");
        if (sdr != null && sdr.trim().length() > 0) {
            if (sdr.startsWith("'") && sdr.endsWith("'") && sdr.length() > 1) {
                sdr = sdr.substring(1, sdr.length() - 1);
            }
            this.timeRange = DatumRangeUtil.parseTimeRange((String)sdr.replaceAll("\\+", " "));
        }
    }

    @Override
    public String getURI() {
        if (this.uri == null) {
            throw new NullPointerException("uri has not been set");
        }
        return this.uri;
    }

    @Override
    public void setTimeRange(DatumRange dr) {
        logger.log(Level.FINE, "setTimeRange {0}", dr);
        if (this.uri != null) {
            URISplit split = URISplit.parse(this.uri);
            LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            params.put("timerange", dr.toString().replaceAll(" ", "+"));
            if (split.file != null && split.file.equals("file:///")) {
                split.file = null;
            }
            split.params = URISplit.formatParams(params);
            this.uri = URISplit.format(split);
        }
        this.timeRange = dr;
    }

    @Override
    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    @Override
    public void setTimeResolution(Datum d) {
        if (d == null) {
            URISplit split = URISplit.parse(this.uri);
            LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            params.remove("resolution");
            split.params = URISplit.formatParams(params);
            this.uri = URISplit.format(split);
        }
    }

    @Override
    public Datum getTimeResolution() {
        return null;
    }

    public static boolean reject(Map map, List<String> problems) {
        if (!map.containsKey("timerange")) {
            problems.add("no timerange provided");
            return true;
        }
        String timeRange = (String)map.get("timerange");
        if ((timeRange = timeRange.replaceAll("\\+", " ")).length() < 3) {
            problems.add("no timerange provided");
            return true;
        }
        try {
            DatumRange dr = DatumRangeUtil.parseTimeRange((String)timeRange);
            logger.log(Level.FINEST, "timeRange parses to {0}", dr);
        }
        catch (ParseException ex) {
            problems.add("parse error in timeRange");
            return true;
        }
        return false;
    }

    @Override
    public String blurURI() {
        if (this.uri == null) {
            throw new NullPointerException("uri has not been set");
        }
        URISplit split = URISplit.parse(this.uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        params.remove("timerange");
        params.remove("resolution");
        split.params = URISplit.formatParams(params);
        return URISplit.format(split);
    }
}

