/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdaweb;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.cdaweb.CDAWebDB;
import org.autoplot.cdf.CdfDataSource;
import org.autoplot.cdf.CdfUtil;
import org.autoplot.cdf.CdfVirtualVars;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.metatree.IstpMetadataModel;
import org.autoplot.netCDF.NetCDFDataSource;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;

public class CDAWebDataSource
extends AbstractDataSource {
    protected static final Logger logger = LoggerManager.getLogger((String)"apdss.cdaweb");
    public static final String PARAM_ID = "id";
    public static final String PARAM_DS = "ds";
    public static final String PARAM_TIMERANGE = "timerange";
    public static final String PARAM_WS = "ws";
    public static final String PARAM_AVAIL = "avail";
    Map<String, Object> metadata;
    Map<String, Object>[] metadatas;
    DatumRange tr;
    String ds;
    String id;
    String ws;
    String savail;

    public CDAWebDataSource(URI uri) {
        super(uri);
        String timerange = this.getParam(PARAM_TIMERANGE, "2010-01-17").replaceAll("\\+", " ");
        try {
            this.tr = DatumRangeUtil.parseTimeRange((String)timerange);
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new IllegalArgumentException(ex);
        }
        this.ds = this.getParam(PARAM_DS, "ac_k0_epm");
        this.id = this.getParam("arg_0", null);
        this.ws = this.getParam(PARAM_WS, null);
        this.savail = this.getParam(PARAM_AVAIL, "F");
        if (this.id == null) {
            this.id = this.getParam(PARAM_ID, null);
        }
        if (this.id == null) {
            throw new IllegalArgumentException("param not specified");
        }
    }

    private DataSourceFactory getDelegateFactory(String ext) {
        DataSourceFactory cdfFileDataSourceFactory = DataSourceRegistry.getInstance().getSource(ext);
        return cdfFileDataSourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        MutablePropertyDataSet result;
        block70: {
            CDAWebDB db = CDAWebDB.getInstance();
            if (!db.isOnline()) {
                throw new IOException("CDAWeb is not accessible.");
            }
            mon.started();
            result = null;
            MutablePropertyDataSet accum = null;
            try {
                String master;
                Map dep1p;
                String ext;
                try {
                    mon.setProgressMessage("refreshing database");
                    db.maybeRefresh(mon.getSubtaskMonitor(0, 10, "refreshing database"));
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    mon.setProgressMessage("unable to connect via ftp");
                    throw ex;
                }
                String[] files = db.getFiles(this.ds.toUpperCase(), this.tr, this.ws, mon.getSubtaskMonitor("lookup files"));
                if ("T".equals(this.savail)) {
                    logger.log(Level.FINE, "availablility {0} ", new Object[]{this.tr});
                    DataSetBuilder build = new DataSetBuilder(2, files.length, 4);
                    TimeLocationUnits u = Units.us2000;
                    EnumerationUnits eu = new EnumerationUnits("default");
                    for (String file : files) {
                        String[] ss = file.split("\\|");
                        file = ss[0];
                        DatumRange dr = DatumRangeUtil.parseTimeRange((String)(ss[1] + " to " + ss[2]));
                        build.putValues(-1, (QDataSet)DDataSet.wrap((double[])new double[]{dr.min().doubleValue((Units)u), dr.max().doubleValue((Units)u), 8454016.0, eu.createDatum((Object)ss[0]).doubleValue((Units)eu)}), 4);
                        build.nextRecord();
                    }
                    DDataSet tresult = build.getDataSet();
                    DDataSet bds = DDataSet.createRank2((int)4, (int)0);
                    bds.putProperty("NAME__0", (Object)"StartTime");
                    bds.putProperty("UNITS__0", (Object)u);
                    bds.putProperty("NAME__1", (Object)"StopTime");
                    bds.putProperty("UNITS__1", (Object)u);
                    bds.putProperty("NAME__2", (Object)"Color");
                    bds.putProperty("NAME__3", (Object)"Filename");
                    bds.putProperty("UNITS__3", (Object)eu);
                    tresult.putProperty("BUNDLE_1", (Object)bds);
                    tresult.putProperty("RENDER_TYPE", (Object)"eventsBar");
                    tresult.putProperty("LABEL", (Object)(this.ds.toUpperCase() + "!cAvailability"));
                    tresult.putProperty("TITLE", (Object)(this.ds.toUpperCase() + " Availability"));
                    DDataSet dDataSet = tresult;
                    return dDataSet;
                }
                if (files.length == 0) {
                    ext = ".cdf";
                } else {
                    String s = files[0];
                    int i = s.indexOf("|");
                    if (i > -1) {
                        s = s.substring(0, i);
                    }
                    URISplit split = URISplit.parse((String)s);
                    ext = split.ext;
                }
                DataSourceFactory fileDataSourceFactory = this.getDelegateFactory(ext);
                mon.setTaskSize((long)(files.length * 10 + 10));
                if (mon.isCancelled()) {
                    throw new CancelledOperationException("user cancelled task");
                }
                mon.setTaskProgress(0L);
                mon.setProgressMessage("getting metadata for " + this.ds);
                this.getMetadata((ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)mon, (long)0L, (long)10L));
                String virtual = null;
                String[] virtuals = null;
                if (this.metadata != null) {
                    virtual = (String)this.metadata.get("VIRTUAL");
                } else {
                    virtuals = new String[this.metadatas.length];
                    for (int i = 0; i < this.metadatas.length; ++i) {
                        String s = (String)this.metadatas[i].get("VIRTUAL");
                        virtuals[i] = s != null && s.trim().length() > 0 ? s : null;
                    }
                }
                DatumRange range = null;
                for (int i = 0; i < files.length && !mon.isCancelled(); ++i) {
                    MutablePropertyDataSet ds1;
                    DatumRange range1;
                    String file;
                    block69: {
                        file = files[i];
                        String[] ss = file.split("\\|");
                        file = ss[0];
                        range1 = DatumRangeUtil.parseTimeRange((String)(ss[1] + " to " + ss[2]));
                        mon.setTaskProgress((long)((i + 1) * 10));
                        mon.setProgressMessage("load " + file);
                        SubTaskMonitor t1 = SubTaskMonitor.create((ProgressMonitor)mon, (long)((i + 1) * 10), (long)((i + 2) * 10));
                        ds1 = null;
                        try {
                            if (virtual != null && !virtual.equals("")) {
                                ds1 = this.readVirtualVariable(file, this.metadata, fileDataSourceFactory, (ProgressMonitor)t1);
                                break block69;
                            }
                            if (virtuals != null) {
                                QDataSet dss = null;
                                String[] ids = this.id.split(";", -2);
                                for (int i2 = 0; i2 < this.metadatas.length; ++i2) {
                                    ds1 = virtuals[i2] != null ? this.readVirtualVariable(file, this.metadatas[i2], fileDataSourceFactory, (ProgressMonitor)t1) : this.readVariable(file, ids[i2], this.metadatas[i2], fileDataSourceFactory, (ProgressMonitor)t1);
                                    if (ds1.rank() == 2) {
                                        int n = ds1.length(0);
                                        QDataSet ll = (QDataSet)ds1.property("DEPEND_1");
                                        QDataSet bb = (QDataSet)ds1.property("BUNDLE_1");
                                        String dslabel = Ops.guessName((QDataSet)ds1);
                                        for (int j = 0; j < n; ++j) {
                                            QDataSet slice = Ops.slice1((QDataSet)ds1, (int)j);
                                            if (ll != null) {
                                                slice = Ops.putProperty((QDataSet)slice, (String)"NAME", (Object)(dslabel + "_" + Ops.safeName((String)ll.slice(j).svalue())));
                                                slice = Ops.putProperty((QDataSet)slice, (String)"LABEL", (Object)(dslabel + " " + Ops.safeName((String)ll.slice(j).svalue())));
                                            } else if (bb != null) {
                                                slice = Ops.putProperty((QDataSet)slice, (String)"NAME", (Object)(dslabel + "_" + bb.property("NAME", j)));
                                                slice = Ops.putProperty((QDataSet)slice, (String)"LABEL", (Object)(dslabel + " " + bb.property("LABEL", j)));
                                            }
                                            dss = Ops.bundle((QDataSet)dss, (QDataSet)slice);
                                        }
                                        continue;
                                    }
                                    dss = Ops.bundle(dss, (QDataSet)ds1);
                                }
                                ds1 = DataSetOps.makePropertiesMutable(dss);
                                break block69;
                            }
                            ds1 = this.readVariable(file, this.id, this.metadata, fileDataSourceFactory, (ProgressMonitor)t1);
                        }
                        catch (NoDataInIntervalException dss) {
                            // empty catch block
                        }
                    }
                    if (ds1 != null) {
                        ArrayList p = new ArrayList();
                        if (!DataSetUtil.validate(ds1, p)) {
                            if (p.size() > 0) {
                                logger.warning((String)p.get(0));
                                continue;
                            }
                            logger.warning("problem");
                        } else {
                            logger.log(Level.FINE, "load {0} -> {1}", new Object[]{file, ds1});
                        }
                        if (ds1.length() == 1) {
                            logger.log(Level.WARNING, "bug 2001: files with only one record are skipped: {0}", file);
                            continue;
                        }
                        if (result == null && accum == null) {
                            range = range1;
                            if (files.length == 1) {
                                result = ds1;
                                continue;
                            }
                            accum = ArrayDataSet.maybeCopy((QDataSet)ds1);
                            accum.grow(accum.length() * files.length * 11 / 10);
                            continue;
                        }
                        assert (accum != null);
                        ArrayDataSet ads1 = ArrayDataSet.maybeCopy((Class)accum.getComponentType(), (QDataSet)ds1);
                        if (accum.canAppend(ads1)) {
                            accum.append(ads1);
                        } else {
                            accum.grow(accum.length() + ads1.length() * (files.length - i));
                            accum.append(ads1);
                        }
                        range = DatumRangeUtil.union((DatumRange)range, (DatumRange)range1);
                        continue;
                    }
                    logger.log(Level.FINE, "failed to read data for granule: {0}", files[i]);
                }
                if (result == null) {
                    result = accum;
                }
                if (result != null && result.property("UNITS") == null && this.metadata != null && this.metadata.containsKey("UNIT_PTR_VALUE")) {
                    QDataSet unitss = (QDataSet)this.metadata.get("UNIT_PTR_VALUE");
                    boolean allSame = true;
                    for (int i = 0; i < unitss.length(); ++i) {
                        if (unitss.value(i) == unitss.value(0)) continue;
                        allSame = false;
                    }
                    if (allSame) {
                        result = Ops.putProperty(result, (String)"UNITS", (Object)Units.lookupUnits((String)unitss.slice(0).toString()));
                    }
                }
                if (result != null && result.property("DEPEND_1") == null && this.metadata != null && (dep1p = (Map)this.metadata.get("DEPEND_1")) != null && dep1p.containsKey("NAME") && result.rank() > 1) {
                    String dep1 = (String)dep1p.get("NAME");
                    String master2 = db.getMasterFile(this.ds.toUpperCase(), (ProgressMonitor)new NullProgressMonitor());
                    if (!master2.endsWith(".cdf")) {
                        throw new IllegalArgumentException("master should end in .cdf");
                    }
                    CdfDataSource masterSource = new CdfDataSource(DataSetURI.getURI((String)(master2 + "?" + dep1 + "[0]&doDep=no")));
                    try {
                        MutablePropertyDataSet ds1 = (MutablePropertyDataSet)masterSource.getDataSet((ProgressMonitor)new NullProgressMonitor());
                        int[] qube = DataSetUtil.qubeDims((QDataSet)result);
                        if (qube.length > 1 && qube[1] == ds1.length() - 1 && ds1.rank() == 1) {
                            logger.info("off-by-one error in DEPEND_1, replacing with findgen");
                            ds1 = Ops.findgen((int)qube[1]);
                        }
                        result = Ops.putProperty((QDataSet)result, (String)"DEPEND_1", (Object)ds1);
                    }
                    catch (NoDataInIntervalException ex) {
                        logger.info("DEPEND_1 refers to time varying quantity.  (Something went wrong, DEPEND_1 should have been loaded along with the data");
                    }
                }
                if (result != null && result.rank() == 2 && this.metadata != null) {
                    QDataSet labels = (QDataSet)result.property("DEPEND_1");
                    String labelVar = (String)this.metadata.get("LABL_PTR_1");
                    String renderType = (String)result.property("RENDER_TYPE");
                    if (labelVar != null && (renderType == null || renderType.equals("time_series"))) {
                        labels = null;
                    }
                    if (labels == null && labelVar != null) {
                        master = db.getMasterFile(this.ds.toLowerCase(), mon.getSubtaskMonitor("get master file"));
                        URISplit split = URISplit.parse((String)master);
                        DataSource labelDss = this.getDelegateFactory(split.ext).getDataSource(DataSetURI.getURI((String)(master + "?" + labelVar)));
                        MutablePropertyDataSet labelDs = (MutablePropertyDataSet)labelDss.getDataSet((ProgressMonitor)new NullProgressMonitor());
                        if (labelDs != null) {
                            if (labelDs.rank() > 1 && labelDs.length() == 1) {
                                labelDs = labelDs.slice(0);
                            }
                            result = Ops.putProperty((QDataSet)result, (String)"BUNDLE_1", (Object)DataSetUtil.toBundleDs((QDataSet)labelDs));
                        }
                    }
                }
                String slice1 = this.getParam("slice1", "");
                if (result != null && slice1.length() > 0 && this.metadata != null) {
                    int islice1 = Integer.parseInt(slice1);
                    String labelVar = (String)this.metadata.get("LABL_PTR_1");
                    if (labelVar != null) {
                        master = db.getMasterFile(this.ds.toLowerCase(), mon.getSubtaskMonitor("get master file"));
                        DataSource labelDss = this.getDelegateFactory(ext).getDataSource(DataSetURI.getURI((String)(master + "?" + labelVar)));
                        MutablePropertyDataSet labelDs = (MutablePropertyDataSet)labelDss.getDataSet((ProgressMonitor)new NullProgressMonitor());
                        if (labelDs != null) {
                            if (labelDs.rank() > 1 && labelDs.length() == 1) {
                                labelDs = labelDs.slice(0);
                            }
                            result = Ops.putProperty((QDataSet)result, (String)"LABEL", (Object)DataSetUtil.getStringValue((QDataSet)labelDs.slice(islice1)).trim());
                        }
                    }
                }
                if (result == null) break block70;
                MutablePropertyDataSet dep0 = (MutablePropertyDataSet)result.property("DEPEND_0");
                if (dep0 != null && range != null) {
                    Units dep0units = (Units)dep0.property("UNITS");
                    if (range.getUnits().isConvertibleTo(dep0units)) {
                        dep0 = Ops.putProperty((QDataSet)dep0, (String)"TYPICAL_MIN", (Object)range.min().doubleValue(dep0units));
                        dep0 = Ops.putProperty((QDataSet)dep0, (String)"TYPICAL_MAX", (Object)range.max().doubleValue(dep0units));
                    }
                    dep0 = Ops.putProperty((QDataSet)dep0, (String)"CACHE_TAG", (Object)new CacheTag(range, null));
                    try {
                        DatumRange extent = Ops.datumRange((Object)CDAWebDB.getInstance().getTimeRange(this.ds));
                        if (extent.getUnits().isConvertibleTo(dep0units)) {
                            dep0 = Ops.putProperty((QDataSet)dep0, (String)"VALID_MIN", (Object)extent.min().doubleValue(dep0units));
                            dep0 = Ops.putProperty((QDataSet)dep0, (String)"VALID_MAX", (Object)extent.max().doubleValue(dep0units));
                        }
                    }
                    catch (IllegalArgumentException extent) {
                        // empty catch block
                    }
                    result = Ops.putProperty((QDataSet)result, (String)"DEPEND_0", (Object)dep0);
                }
                HashMap<String, String> user = new HashMap<String, String>();
                for (int i = 0; i < Math.min(files.length, 10); ++i) {
                    user.put("delegate_" + i, files[i]);
                }
                if (files.length >= 10) {
                    user.put("delegate_10", files.length - 10 + " more files.");
                }
                if (!result.isImmutable()) {
                    result.putProperty("USER_PROPERTIES", user);
                }
            }
            finally {
                if (!mon.isFinished()) {
                    mon.finished();
                }
            }
        }
        if (result != null) {
            ArrayList problems;
            String displayType = (String)result.property("RENDER_TYPE");
            if (displayType != null && displayType.equals("spectrogram")) {
                int rank = result.rank();
                int nphys = 0;
                for (int i = 1; i < rank; ++i) {
                    QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
                    if (dep1 != null && UnitsUtil.isNominalMeasurement((Units)SemanticOps.getUnits((QDataSet)dep1))) continue;
                    ++nphys;
                }
                if (nphys == 0) {
                    logger.fine("removing display type because of ordinal units");
                    result = Ops.putProperty((QDataSet)result, (String)"RENDER_TYPE", null);
                }
            }
            if (!DataSetUtil.validate(result, problems = new ArrayList())) {
                throw new Exception("calculated dataset is not well-formed: " + this.uri + ". " + problems);
            }
        }
        return result;
    }

    private MutablePropertyDataSet readVariable(String file, String id, Map<String, Object> lmetadata, DataSourceFactory fileDataSourceFactory, ProgressMonitor t1) throws URISyntaxException, Exception {
        MutablePropertyDataSet ds1;
        HashMap<String, String> fileParams = new HashMap<String, String>(this.getParams());
        fileParams.remove(PARAM_TIMERANGE);
        fileParams.remove(PARAM_DS);
        fileParams.put(PARAM_ID, id);
        URI file1 = DataSetURI.getURI((String)(file + "?" + URISplit.formatParams(fileParams)));
        logger.log(Level.FINE, "loading {0}", file1);
        if (file.endsWith(".nc")) {
            NetCDFDataSource dataSource = (NetCDFDataSource)fileDataSourceFactory.getDataSource(file1);
            try {
                ds1 = (MutablePropertyDataSet)dataSource.getDataSet(t1);
                CdfUtil.doApplyAttributes(lmetadata, (MutablePropertyDataSet)ds1, null, null);
                ds1.putProperty("METADATA", lmetadata);
                ds1.putProperty("METADATA_MODEL", (Object)"ISTP-CDF");
            }
            catch (IllegalArgumentException ex) {
                String p = (String)this.params.get(PARAM_ID);
                logger.log(Level.INFO, "parameter not found for interval: {0}", p);
                throw new NoDataInIntervalException("parameter not found for interval: " + p);
            }
        }
        CdfDataSource dataSource = (CdfDataSource)fileDataSourceFactory.getDataSource(file1);
        try {
            ds1 = (MutablePropertyDataSet)dataSource.getDataSet(t1, lmetadata);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            String p = (String)this.params.get(PARAM_ID);
            logger.log(Level.INFO, "parameter not found for interval: {0}", p);
            throw new NoDataInIntervalException("parameter not found for interval: " + p);
        }
        return ds1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MutablePropertyDataSet readVirtualVariable(String file, Map<String, Object> meta, DataSourceFactory fileDataSourceFactory, ProgressMonitor t1) throws Exception {
        MutablePropertyDataSet ds1 = null;
        int nc = 0;
        ArrayList<MutablePropertyDataSet> comps = new ArrayList<MutablePropertyDataSet>();
        String function = (String)meta.get("FUNCTION");
        if (function == null) {
            function = (String)meta.get("FUNCT");
        }
        String missingComponentName = null;
        if (function == null) throw new IllegalArgumentException("The virtual variable " + this.id + " cannot be plotted because the function is not identified");
        String comp = (String)meta.get("COMPONENT_" + nc);
        while (comp != null) {
            HashMap<String, String> fileParams = new HashMap<String, String>(this.getParams());
            fileParams.remove(PARAM_TIMERANGE);
            fileParams.remove(PARAM_DS);
            fileParams.put(PARAM_ID, comp);
            URI file1 = DataSetURI.getURI((String)(file + "?" + URISplit.formatParams(fileParams)));
            logger.log(Level.FINER, "loading component for virtual variable: {0}", file1);
            DataSource dataSource = fileDataSourceFactory.getDataSource(file1);
            try {
                ds1 = (MutablePropertyDataSet)dataSource.getDataSet(t1.getSubtaskMonitor("load " + comp));
            }
            catch (Exception ex) {
                ds1 = null;
                logger.log(Level.WARNING, ex.getMessage(), ex);
                missingComponentName = comp;
            }
            comps.add(ds1);
            comp = (String)meta.get("COMPONENT_" + ++nc);
        }
        boolean missingComponent = false;
        for (QDataSet qDataSet : comps) {
            if (qDataSet != null) continue;
            missingComponent = true;
        }
        if (missingComponent) throw new IllegalArgumentException("The virtual variable " + this.id + " cannot be plotted because a component " + missingComponentName + " is missing");
        try {
            ds1 = (MutablePropertyDataSet)CdfVirtualVars.execute(meta, (String)function, comps, (ProgressMonitor)t1);
            String id_ = (String)this.getParams().get(PARAM_ID);
            return CDAWebDataSource.maybeImplementSlice(id_, ds1);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("The virtual variable " + this.id + " cannot be plotted because the function is not supported: " + function, ex);
        }
    }

    public synchronized Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        if ("T".equals(this.savail)) {
            return null;
        }
        Pattern slicePattern = Pattern.compile(".+\\[:\\,(\\d+)\\]");
        if (this.metadata == null && this.metadatas == null) {
            String slice1;
            mon.started();
            CDAWebDB db = CDAWebDB.getInstance();
            String master = db.getMasterFile(this.ds.toLowerCase(), mon.getSubtaskMonitor("getMasterFile"));
            URISplit split = URISplit.parse((String)master);
            master = master + "?" + this.id;
            String x = this.getParam("x", null);
            String y = this.getParam("y", null);
            if (x != null) {
                master = master + "&x=" + x;
            }
            if (y != null) {
                master = master + "&y=" + y;
            }
            if (this.id.contains(";")) {
                String[] params = this.id.split(";");
                this.metadatas = new Map[params.length];
                for (int i = 0; i < params.length; ++i) {
                    String m = URISplit.removeParam((String)master, (String[])new String[]{"arg_0"}) + "?" + params[i];
                    DataSource cdf = this.getDelegateFactory(split.ext).getDataSource(DataSetURI.getURI((String)m));
                    this.metadatas[i] = cdf.getMetadata(mon.getSubtaskMonitor("getMetadata for " + params[i]));
                    Matcher matcher = slicePattern.matcher(params[i]);
                    if (!matcher.matches()) continue;
                    this.metadatas[i].put("slice1", matcher.group(1));
                }
            } else {
                DataSource cdf = this.getDelegateFactory(split.ext).getDataSource(DataSetURI.getURI((String)master));
                this.metadata = cdf.getMetadata(mon.getSubtaskMonitor("getMetadata"));
                Matcher matcher = slicePattern.matcher(this.id);
                if (matcher.matches()) {
                    this.metadata.put("slice1", matcher.group(1));
                }
            }
            if (!(slice1 = this.getParam("slice1", "")).equals("")) {
                this.metadata.remove("LABLAXIS");
                this.metadata.put("slice1", slice1);
                String labelVar = (String)this.metadata.get("LABL_PTR_1");
                if (labelVar != null) {
                    String master1 = db.getMasterFile(this.ds.toLowerCase(), mon.getSubtaskMonitor("getMasterFile"));
                    DataSource labelDss = this.getDelegateFactory(split.ext).getDataSource(DataSetURI.getURI((String)(master1 + "?" + labelVar)));
                    MutablePropertyDataSet labelDs = (MutablePropertyDataSet)labelDss.getDataSet((ProgressMonitor)new NullProgressMonitor());
                    if (labelDs != null) {
                        if (labelDs.rank() > 1 && labelDs.length() == 1) {
                            labelDs = labelDs.slice(0);
                        }
                        this.metadata.put("LABLAXIS", DataSetUtil.getStringValue((QDataSet)labelDs.slice(Integer.parseInt(slice1))));
                    }
                }
            }
            mon.finished();
        }
        return this.metadata;
    }

    public MetadataModel getMetadataModel() {
        return new IstpMetadataModel();
    }

    public <T> T getCapability(Class<T> clazz) {
        if (clazz == TimeSeriesBrowse.class) {
            return (T)new TimeSeriesBrowse(){

                public void setTimeRange(DatumRange dr) {
                    CDAWebDataSource.this.tr = dr;
                }

                public DatumRange getTimeRange() {
                    return CDAWebDataSource.this.tr;
                }

                public void setTimeResolution(Datum d) {
                }

                public Datum getTimeResolution() {
                    return null;
                }

                public String getURI() {
                    Map p = CDAWebDataSource.this.getParams();
                    p.put(CDAWebDataSource.PARAM_TIMERANGE, CDAWebDataSource.this.tr.toString().replace(' ', '+'));
                    return "vap+cdaweb:" + URISplit.formatParams((Map)p);
                }

                public String blurURI() {
                    Map p = CDAWebDataSource.this.getParams();
                    p.remove(CDAWebDataSource.PARAM_TIMERANGE);
                    return "vap+cdaweb:" + URISplit.formatParams((Map)p);
                }

                public void setURI(String suri) throws ParseException {
                    URISplit split = URISplit.parse((String)suri);
                    LinkedHashMap params = URISplit.parseParams((String)split.params);
                    String str = (String)params.get(CDAWebDataSource.PARAM_TIMERANGE);
                    if (str != null) {
                        CDAWebDataSource.this.tr = DatumRangeUtil.parseTimeRange((String)((String)params.get(CDAWebDataSource.PARAM_TIMERANGE)));
                    }
                }
            };
        }
        return null;
    }

    public static void main(String[] args) throws URISyntaxException, Exception {
        CDAWebDataSource dss = new CDAWebDataSource(new URI("vap+cdaweb:file:///foo.xml?ds=cl_sp_fgm&id=B_mag&timerange=2001-10-10"));
        QDataSet ds = dss.getDataSet((ProgressMonitor)new NullProgressMonitor());
        logger.fine(ds.toString());
    }

    private static MutablePropertyDataSet maybeImplementSlice(String id_, MutablePropertyDataSet ds1) {
        int i = id_.lastIndexOf(91);
        if (i > -1) {
            String subset = id_.substring(i);
            long[] lqubeDims = new long[ds1.rank()];
            int[] iqubeDims = DataSetUtil.qubeDims((QDataSet)ds1);
            for (int i2 = 0; i2 < lqubeDims.length; ++i2) {
                lqubeDims[i2] = iqubeDims[i2];
            }
            try {
                Map mc = DataSourceUtil.parseConstraint((String)subset, (long[])lqubeDims);
                long[] constr = (long[])mc.get(0);
                if (constr[0] == 0L && constr[1] == lqubeDims[0] && constr[2] == 1L && (constr = (long[])mc.get(1)) != null && constr[1] == -1L && constr[2] == -1L) {
                    ds1 = Ops.maybeCopy((QDataSet)Ops.slice1((QDataSet)ds1, (int)((int)constr[0])));
                }
                return ds1;
            }
            catch (ParseException ex) {
                logger.log(Level.WARNING, "parse exception", ex);
                return ds1;
            }
        }
        return ds1;
    }
}

