/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datasource;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.RecentComboBox;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.WindowManager;
import org.das2.DasException;
import org.das2.client.Das2ServerGUI;
import org.das2.client.DasServer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Das2ServerDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.das2server");
    private static final char EXAMPLE_TIMERANGE_LABEL_DELIM = '|';
    private static final String EXAMPLE_TIME_RANGES = "<html><i>Example Time Ranges</i>";
    private final String DEFAULT_TIMERANGE = "2001-01-01";
    private String dsdfContent;
    private List<String> d2ss;
    private DatumRange validTimeRange = null;
    private final Map<String, String> readerParams = new HashMap<String, String>();
    private final Map<String, String> otherParams = new HashMap<String, String>();
    private String userTimeRange = null;
    private final Map<String, String> tcaItem = new HashMap<String, String>();
    private final LinkedHashMap<String, Example> theExamples = new LinkedHashMap();
    private static final Map<String, ImageIcon> icons = Collections.synchronizedMap(new HashMap());
    private final transient ListCellRenderer myListCellRenderer = new IconCellRenderer();
    public JComboBox das2ServerComboBox;
    public JLabel descriptionLabel;
    public JCheckBox discoveryCb;
    public JButton editParamsButton;
    public JComboBox examplesComboBox;
    public JCheckBox intrinsicCb;
    public JComboBox<String> itemsComboBox;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JLabel jLabel6;
    public JLabel jLabel7;
    public JScrollPane jScrollPane1;
    public JScrollPane jScrollPane2;
    public JTree jTree1;
    public JTextArea readerParamsTextArea;
    public RecentComboBox recentComboBox1;
    public JTextField tcaTextField;
    public JButton timeRangeTool;
    public JLabel validRangeLabel;
    public JButton viewDsdfButton;
    protected String serverURL = "";
    public static final String PROP_SERVERURL = "serverURL";
    protected String dataSetId = null;
    public static final String PROP_DATASETID = "dataSetId";

    public Das2ServerDataSourceEditorPanel() {
        this.initComponents();
        this.recentComboBox1.setPreferenceNode("timerange");
    }

    private void initComponents() {
        this.das2ServerComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.readerParamsTextArea = new JTextArea();
        this.jLabel5 = new JLabel();
        this.tcaTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.viewDsdfButton = new JButton();
        this.validRangeLabel = new JLabel();
        this.discoveryCb = new JCheckBox();
        this.examplesComboBox = new JComboBox();
        this.jLabel7 = new JLabel();
        this.descriptionLabel = new JLabel();
        this.timeRangeTool = new JButton();
        this.intrinsicCb = new JCheckBox();
        this.recentComboBox1 = new RecentComboBox();
        this.itemsComboBox = new JComboBox();
        this.editParamsButton = new JButton();
        this.setName("das2serverDataSourceEditorPanel");
        this.das2ServerComboBox.setEditable(true);
        this.das2ServerComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"https://planet.physics.uiowa.edu/das/das2Server", "https://jupiter.physics.uiowa.edu/das/server"}));
        this.das2ServerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.das2ServerComboBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Das2 Server URL:");
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Loading DataSets List...");
        this.jTree1.setModel(new DefaultTreeModel(treeNode1));
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jLabel2.setText("Data Set Id:");
        this.jLabel3.setText("Time Range:");
        this.jLabel4.setText("Reader Parameters:");
        this.jLabel4.setToolTipText("Special parameters for the reader that implements the data source.  ");
        this.readerParamsTextArea.setColumns(20);
        this.readerParamsTextArea.setRows(5);
        this.jScrollPane2.setViewportView(this.readerParamsTextArea);
        this.jLabel5.setText("Sampling Interval (sec):");
        this.jLabel5.setToolTipText("<html> Interval (in seconds) to use for arbitrary resolution data.<br>Typically used for spacecraft positions or models, leave blank for most datasets.<br> </html> ");
        this.tcaTextField.setText(" ");
        this.tcaTextField.setToolTipText("<html> Interval (in seconds) to use for TCA (ephemeris) data.<br> Leave blank for most datasets.<br> </html> ");
        this.jLabel6.setText("TCA Item:");
        this.jLabel6.setToolTipText("The optional item number for TCAs.");
        this.viewDsdfButton.setText("View DSDF");
        this.viewDsdfButton.setToolTipText("View the DSDF configuration file on the server");
        this.viewDsdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.viewDsdfButtonActionPerformed(evt);
            }
        });
        this.validRangeLabel.setFont(new Font("DejaVu LGC Sans", 0, 10));
        this.validRangeLabel.setText("<html><i>no valid range for dataset provided</i></html>");
        this.discoveryCb.setText("require example time");
        this.discoveryCb.setToolTipText("Show only datasets that have identified example times.  These should be a higher quality, and can be tested by a machine.");
        this.discoveryCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.discoveryCbActionPerformed(evt);
            }
        });
        this.examplesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{EXAMPLE_TIME_RANGES, " "}));
        this.examplesComboBox.setToolTipText("Example times specified in the data set descriptor file");
        this.examplesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.examplesComboBoxActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Description:");
        this.jLabel7.setToolTipText("Description provided by the server (in its dsdf file)");
        this.descriptionLabel.setText(" ");
        this.timeRangeTool.setIcon(new ImageIcon(this.getClass().getResource("/org/das2/datasource/calendar.png")));
        this.timeRangeTool.setToolTipText("Time Range Tool");
        this.timeRangeTool.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.timeRangeToolActionPerformed(evt);
            }
        });
        this.intrinsicCb.setText("Force Intrinsic Resolution");
        this.intrinsicCb.setToolTipText("Force the load of data at its intrinsic resolution, or for modelled quantities, always load at the sampling interval.");
        this.intrinsicCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.intrinsicCbActionPerformed(evt);
            }
        });
        this.recentComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Das2ServerDataSourceEditorPanel.this.recentComboBox1ItemStateChanged(evt);
            }
        });
        this.itemsComboBox.setEditable(true);
        this.itemsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" ", " "}));
        this.editParamsButton.setText("Edit Params");
        this.editParamsButton.setToolTipText("The DSDF can be used to describe the parameters, and this experimental GUI will be generated.");
        this.editParamsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.editParamsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.das2ServerComboBox, 0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.discoveryCb)).add((Component)this.jScrollPane1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.descriptionLabel, -1, -1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((Component)this.validRangeLabel, -2, 267, -2).addPreferredGap(0).add((Component)this.examplesComboBox, 0, -1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.recentComboBox1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.timeRangeTool)).add(2, (Component)this.jScrollPane2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.viewDsdfButton).add((Component)this.editParamsButton))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel4).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.intrinsicCb).add(28, 28, 28).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.tcaTextField, -2, 70, -2).add(26, 26, 26).add((Component)this.jLabel6).addPreferredGap(0).add(this.itemsComboBox, -2, -1, -2))).add(0, 27, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.das2ServerComboBox, -2, -1, -2).add(5, 5, 5).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.discoveryCb)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 240, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.descriptionLabel)).add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.viewDsdfButton).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.recentComboBox1, -2, -1, -2)).add(2, (Component)this.timeRangeTool)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.examplesComboBox, -2, -1, -2).add((Component)this.validRangeLabel, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane2, -2, 53, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.tcaTextField, -2, -1, -2).add((Component)this.jLabel6).add((Component)this.intrinsicCb).add(this.itemsComboBox, -2, -1, -2))).add((Component)this.editParamsButton)).addContainerGap()));
    }

    private static Example parseExample(String s, Example e) {
        int j;
        if (e == null) {
            e = new Example();
        }
        if ((j = s.indexOf(124)) > -1) {
            e.timeRange = s.substring(0, j);
            e.label = s.substring(j + 1).trim();
        } else {
            e.timeRange = s;
        }
        return e;
    }

    private static Example addParamsToExample(String s, Example e) {
        if (e == null) {
            e = new Example();
        }
        e.params = s;
        return e;
    }

    private InputStream openConnection(URL url) throws IOException {
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        int nStatus = httpConn.getResponseCode();
        if (nStatus == 301) {
            String newUrl = httpConn.getHeaderField("Location");
            httpConn.disconnect();
            if (newUrl == null) {
                throw new IllegalArgumentException("301 response but no new location");
            }
            httpConn = (HttpURLConnection)new URL(newUrl).openConnection();
            nStatus = httpConn.getResponseCode();
        }
        return httpConn.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataSetSelected(final URL url) {
        InputStream in = null;
        try {
            in = this.openConnection(url);
            StringBuilder sb = new StringBuilder();
            int by = in.read();
            while (by != -1) {
                sb.append((char)by);
                by = in.read();
            }
            in.close();
            String s = sb.toString();
            int packetTagLength = 10;
            int contentLength = Integer.parseInt(s.substring(4, 10));
            String sxml = s.substring(10, 10 + contentLength);
            BufferedReader xin = new BufferedReader(new StringReader(sxml));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(xin);
            final Document document = builder.parse(source);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultComboBoxModel<String> aModel;
                        Das2ServerDataSourceEditorPanel.this.validTimeRange = null;
                        boolean isTca = false;
                        XPathFactory factory = XPathFactory.newInstance();
                        XPath xpath = factory.newXPath();
                        String curr = Das2ServerDataSourceEditorPanel.this.recentComboBox1.getText();
                        Node description = (Node)xpath.evaluate("/stream/properties/@description", document, XPathConstants.NODE);
                        Das2ServerDataSourceEditorPanel.this.descriptionLabel.setText(description == null ? "" : description.getNodeValue());
                        NodeList exs = (NodeList)xpath.evaluate("/stream/properties/@*", document, XPathConstants.NODESET);
                        Example example = null;
                        HashMap<String, String> items = new HashMap<String, String>();
                        Pattern itemPattern = Pattern.compile("item_(\\d\\d)");
                        for (int i = 0; i < exs.getLength(); ++i) {
                            Matcher m;
                            Example e;
                            String s;
                            Node ex = exs.item(i);
                            String name = ex.getNodeName();
                            if (name.startsWith("exampleRange")) {
                                s = ex.getNodeValue();
                                name = name.replace("exampleRange", "example");
                                e = (Example)Das2ServerDataSourceEditorPanel.this.theExamples.get(name);
                                Das2ServerDataSourceEditorPanel.this.theExamples.put(name, Das2ServerDataSourceEditorPanel.parseExample(s, e));
                                example = Das2ServerDataSourceEditorPanel.parseExample(s, e);
                                continue;
                            }
                            if (name.startsWith("exampleParams")) {
                                s = ex.getNodeValue();
                                name = name.replace("exampleParams", "example");
                                e = (Example)Das2ServerDataSourceEditorPanel.this.theExamples.get(name);
                                Das2ServerDataSourceEditorPanel.this.theExamples.put(name, Das2ServerDataSourceEditorPanel.addParamsToExample(s, e));
                                Das2ServerDataSourceEditorPanel.addParamsToExample(s, example);
                                continue;
                            }
                            if (name.equals("items")) {
                                isTca = true;
                                continue;
                            }
                            if (name.equals("requiresInterval")) {
                                isTca = !ex.getNodeValue().equals("0");
                                continue;
                            }
                            if (!name.startsWith("item_") || !(m = itemPattern.matcher(name)).matches()) continue;
                            String s2 = ex.getNodeValue();
                            int ipipe = s2.indexOf(124);
                            if (ipipe > -1) {
                                s2 = s2.substring(0, ipipe);
                            }
                            s2 = s2.trim();
                            items.put(name, s2);
                        }
                        String selectedItem = (String)Das2ServerDataSourceEditorPanel.this.tcaItem.get(url.toString());
                        if (items.size() > 0 && isTca) {
                            Object e;
                            aModel = new DefaultComboBoxModel();
                            aModel.addElement("");
                            int index = 0;
                            do {
                                if ((e = (String)items.get(String.format("item_%02d", index))) != null) {
                                    if (index == 0) {
                                        aModel.addElement("0 (" + (String)e + ")");
                                    } else {
                                        aModel.addElement((String)e);
                                    }
                                }
                                ++index;
                            } while (e != null);
                            Das2ServerDataSourceEditorPanel.this.itemsComboBox.setModel(aModel);
                        } else {
                            aModel = new DefaultComboBoxModel<String>();
                            aModel.addElement("");
                            Das2ServerDataSourceEditorPanel.this.itemsComboBox.setModel(aModel);
                        }
                        if (selectedItem != null) {
                            Das2ServerDataSourceEditorPanel.this.itemsComboBox.setSelectedItem(selectedItem);
                        }
                        if (example != null && curr.equals("2001-01-01")) {
                            Das2ServerDataSourceEditorPanel.this.recentComboBox1.setText(example.timeRange);
                        }
                        if (example != null) {
                            try {
                                Das2ServerDataSourceEditorPanel.this.validTimeRange = DatumRangeUtil.parseTimeRange((String)example.timeRange);
                            }
                            catch (ParseException ex) {
                                logger.info("default timerange doesn't parse!");
                            }
                        }
                        if (Das2ServerDataSourceEditorPanel.this.theExamples.size() > 0) {
                            ArrayList<String> keys = new ArrayList<String>(Das2ServerDataSourceEditorPanel.this.theExamples.size());
                            keys.add("LABEL");
                            if (Das2ServerDataSourceEditorPanel.this.theExamples.containsKey("example")) {
                                keys.add("example");
                            }
                            for (String k : Das2ServerDataSourceEditorPanel.this.theExamples.keySet()) {
                                if (k.equals("example")) continue;
                                keys.add(k);
                            }
                            if (Das2ServerDataSourceEditorPanel.this.theExamples.size() > 0) {
                                String anExample = ((Example)Das2ServerDataSourceEditorPanel.this.theExamples.entrySet().iterator().next().getValue()).timeRange;
                                if (Das2ServerDataSourceEditorPanel.this.userTimeRange != null) {
                                    anExample = Das2ServerDataSourceEditorPanel.this.userTimeRange;
                                }
                                Das2ServerDataSourceEditorPanel.this.recentComboBox1.setText(anExample);
                            }
                            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(keys.toArray());
                            Das2ServerDataSourceEditorPanel.this.examplesComboBox.setModel(model);
                            Das2ServerDataSourceEditorPanel.this.examplesComboBox.setEnabled(true);
                        } else {
                            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{"NONEFOUND"});
                            Das2ServerDataSourceEditorPanel.this.examplesComboBox.setModel(model);
                            Das2ServerDataSourceEditorPanel.this.examplesComboBox.setEnabled(false);
                        }
                        Das2ServerDataSourceEditorPanel.this.examplesComboBox.setRenderer(new ListCellRenderer(){

                            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                                JLabel def = new JLabel();
                                if (value.equals("LABEL")) {
                                    def.setText(String.format(Locale.US, "<html><i>Example Time Ranges (%d)</i>", Das2ServerDataSourceEditorPanel.this.theExamples.size()));
                                } else if (value.equals("NONEFOUND")) {
                                    def.setText(String.format(Locale.US, "No example time ranges found...", new Object[0]));
                                } else {
                                    Example e = (Example)Das2ServerDataSourceEditorPanel.this.theExamples.get((String)value);
                                    def.setText("<html>" + e.timeRange + " <i><nbsp>" + e.label + "</i>");
                                }
                                return def;
                            }
                        });
                        if (example == null) {
                            Node exampleRange = (Node)xpath.evaluate("/stream/properties/@x_range", document, XPathConstants.NODE);
                            if (exampleRange != null && curr.equals("2001-01-01")) {
                                Das2ServerDataSourceEditorPanel.this.recentComboBox1.setText(exampleRange.getNodeValue());
                            }
                            if (exampleRange != null) {
                                try {
                                    Das2ServerDataSourceEditorPanel.this.validTimeRange = DatumRangeUtil.parseTimeRange((String)exampleRange.getNodeValue());
                                }
                                catch (ParseException ex) {
                                    logger.info("example timerange doesn't parse!");
                                }
                            }
                        }
                        String rp = (String)Das2ServerDataSourceEditorPanel.this.readerParams.get(Das2ServerDataSourceEditorPanel.this.getDataSetId(url));
                        Das2ServerDataSourceEditorPanel.this.readerParamsTextArea.setText(rp == null ? "" : rp);
                        Node validRange = (Node)xpath.evaluate("/stream/properties/@validRange", document, XPathConstants.NODE);
                        if (validRange != null) {
                            Das2ServerDataSourceEditorPanel.this.validRangeLabel.setText("valid range: " + validRange.getNodeValue());
                        } else {
                            Das2ServerDataSourceEditorPanel.this.validRangeLabel.setText("<html><i>no valid range for dataset provided</i></html>");
                        }
                        if (isTca) {
                            Das2ServerDataSourceEditorPanel.this.tcaTextField.setText("60");
                        } else {
                            Das2ServerDataSourceEditorPanel.this.tcaTextField.setText("");
                        }
                    }
                    catch (XPathExpressionException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
        catch (SAXException ex) {
            JOptionPane.showMessageDialog(this.examplesComboBox, "Unable to parse dsdf: " + ex.getMessage());
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException | ParserConfigurationException ex) {
            JOptionPane.showMessageDialog(this.examplesComboBox, "Unable to parse dsdf: " + ex.getMessage());
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private String getDataSetId(TreePath p) {
        Object[] oo = p.getPath();
        StringBuilder ds = new StringBuilder(String.valueOf(oo[0]));
        ds.append("?").append(oo[1]);
        for (int i = 2; i < oo.length; ++i) {
            ds.append("/").append(oo[i]);
        }
        return ds.toString();
    }

    private String getDataSetId(URL url) {
        LinkedHashMap p = URISplit.parseParams((String)url.getQuery());
        return url.getProtocol() + "://" + url.getHost() + url.getPath() + "?" + (String)p.get("dataset");
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        TreePath p = evt.getPath();
        TreePath old = evt.getOldLeadSelectionPath();
        TreeModel m = ((JTree)evt.getSource()).getModel();
        if (old != null && m.isLeaf(old.getLastPathComponent())) {
            String osurl = this.getDataSetId(old);
            this.readerParams.put(osurl, this.readerParamsTextArea.getText());
        }
        this.dsdfContent = null;
        if (!m.isLeaf(p.getLastPathComponent())) {
            this.descriptionLabel.setText("");
            this.validRangeLabel.setText("<html><i>no dataset selected</i></html>");
            this.viewDsdfButton.setEnabled(false);
        } else {
            this.viewDsdfButton.setEnabled(true);
            this.validRangeLabel.setText("<html><i>retrieving dataset info...</i></html>");
            String ds = this.getDataSetId(p);
            int i = ds.indexOf(63);
            String surl = p.getPath()[0] + "?server=dsdf&dataset=" + ds.substring(i + 1);
            try {
                final URL url = new URL(surl);
                RequestProcessor.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Das2ServerDataSourceEditorPanel.this.updateDataSetSelected(url);
                    }
                });
            }
            catch (MalformedURLException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                JOptionPane.showConfirmDialog(this, "Internal Error: " + ex.toString());
            }
        }
    }

    private void updateDas2Servers() {
        Runnable runOffEvt = new Runnable(){

            @Override
            public void run() {
                Das2ServerDataSourceEditorPanel.this.updateDas2ServersImmediately();
            }
        };
        new Thread(runOffEvt).start();
    }

    private void updateDas2ServersImmediately() {
        this.d2ss = this.listDas2Servers();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Das2ServerDataSourceEditorPanel.this.das2ServerComboBox.setModel(new DefaultComboBoxModel<Object>(Das2ServerDataSourceEditorPanel.this.d2ss.toArray()));
                if (Das2ServerDataSourceEditorPanel.this.serverURL.length() == 0) {
                    Das2ServerDataSourceEditorPanel.this.serverURL = (String)Das2ServerDataSourceEditorPanel.this.d2ss.get(0);
                    RequestProcessor.invokeLater((Runnable)Das2ServerDataSourceEditorPanel.this.getDataSetsRunnable());
                }
                Das2ServerDataSourceEditorPanel.this.das2ServerComboBox.setSelectedItem(Das2ServerDataSourceEditorPanel.this.serverURL);
                Das2ServerDataSourceEditorPanel.this.das2ServerComboBox.setRenderer(Das2ServerDataSourceEditorPanel.this.myListCellRenderer);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private static Icon iconFor(Object o, boolean wait) {
        ImageIcon result = icons.get(o.toString());
        if (result == null && wait) {
            try {
                long t1 = System.currentTimeMillis();
                result = new ImageIcon(new URL("" + o + "?server=logo"));
                Image im = result.getImage();
                int h = im.getWidth(null);
                int w = im.getHeight(null);
                int s = 20;
                int h1 = Math.min(24, s * w / h);
                BufferedImage bi = new BufferedImage(s, h1, 2);
                Graphics2D g = bi.createGraphics();
                g.drawImage(im, 0, 0, s, h1, null, null);
                result = new ImageIcon(bi);
                logger.log(Level.FINE, "time to load icon for {0}: {1} ms", new Object[]{o, System.currentTimeMillis() - t1});
                icons.put(o.toString(), result);
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listPeers(String suri) {
        String uri = suri + "?server=peers";
        ArrayList<String> result = new ArrayList<String>();
        InputStream in = null;
        try {
            in = new URL(uri).openStream();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(in);
            Document initialDocument = builder.parse(source);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            NodeList urls = (NodeList)xpath.evaluate("//das2server/peers/server/url/text()", initialDocument, XPathConstants.NODESET);
            for (int i = 0; i < urls.getLength(); ++i) {
                result.add(urls.item(i).getNodeValue());
            }
        }
        catch (MalformedURLException ex) {
            logger.log(Level.SEVERE, "listPeers(" + uri + ")\n" + ex.getMessage(), ex);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            logger.log(Level.SEVERE, "listPeers(" + uri + ")\nresults in:\n" + ex.getMessage(), ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listDas2Servers() {
        ArrayList<String> d2ss1 = new ArrayList<String>();
        d2ss1.add("https://planet.physics.uiowa.edu/das/das2Server");
        if (this.serverURL.length() == 0) {
            d2ss1.addAll(this.listPeers("https://planet.physics.uiowa.edu/das/das2Server"));
        } else {
            d2ss1.addAll(this.listPeers(this.serverURL));
        }
        File home = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
        File book = new File(home, "bookmarks");
        File hist = new File(book, "history.txt");
        long t0 = System.currentTimeMillis();
        logger.log(Level.FINE, "reading recent datasources from {0}", hist.toString());
        if (hist.exists()) {
            BufferedReader r = null;
            try {
                String seek = "das2server:";
                int ttaglen = 25;
                r = new BufferedReader(new FileReader(hist));
                String s = r.readLine();
                LinkedHashSet<String> dss = new LinkedHashSet<String>();
                while (s != null) {
                    if (s.length() > ttaglen + 15 && s.substring(ttaglen + 4, ttaglen + 15).equalsIgnoreCase(seek)) {
                        String key;
                        int i = s.indexOf(63);
                        if (i == -1) {
                            i = s.length();
                        }
                        if (dss.contains(key = s.substring(ttaglen + 4 + seek.length(), i))) {
                            dss.remove(key);
                        }
                        dss.add(key);
                    }
                    s = r.readLine();
                }
                d2ss1.removeAll(dss);
                ArrayList<String> d2ssDiscoveryList = new ArrayList<String>(dss);
                Collections.reverse(d2ssDiscoveryList);
                d2ssDiscoveryList.addAll(d2ss1);
                d2ss1 = d2ssDiscoveryList;
                logger.log(Level.FINE, "read extra das2servers in {0} millis\n", System.currentTimeMillis() - t0);
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "IOException when reading in {0}", hist);
                JOptionPane.showConfirmDialog(this.examplesComboBox, "IOException when reading in " + hist);
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        } else {
            logger.log(Level.FINE, "no history file found: {0}", hist);
        }
        final ArrayList<String> fd2ss1 = d2ss1;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                for (String s : fd2ss1) {
                    Icon i = Das2ServerDataSourceEditorPanel.iconFor(s, true);
                    logger.log(Level.FINER, "iconHeight={0}", i.getIconHeight());
                }
            }
        };
        new Thread(run, "loadDas2ServerIcons").start();
        return d2ss1;
    }

    private String readDsdf(URL url) throws IOException {
        try (InputStream in = this.openConnection(url);){
            String sxml;
            StringBuilder sb = new StringBuilder();
            int by = in.read();
            while (by != -1) {
                sb.append((char)by);
                by = in.read();
            }
            String s = sb.toString();
            int contentLength = Integer.parseInt(s.substring(4, 10));
            String string = sxml = s.substring(10, 10 + contentLength);
            return string;
        }
    }

    private void showDsdf(URL url) {
        try {
            String sxml = this.readDsdf(url);
            BufferedReader xin = new BufferedReader(new StringReader(sxml));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(xin);
            Document document = builder.parse(source);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            NodeList o = (NodeList)xpath.evaluate("/stream/properties/@*", document, XPathConstants.NODESET);
            StringBuilder result = new StringBuilder("");
            for (int ii = 0; ii < o.getLength(); ++ii) {
                result.append(o.item(ii).getNodeName()).append("  =  ").append(o.item(ii).getNodeValue()).append("\n");
            }
            final String fresult = result.toString();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    JTextArea area = new JTextArea();
                    area.setText(fresult);
                    area.setEditable(false);
                    final JPopupMenu copyMenu = new JPopupMenu();
                    copyMenu.add(new DefaultEditorKit.CopyAction()).setText("Copy");
                    area.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (e.isPopupTrigger()) {
                                copyMenu.show(e.getComponent(), e.getX(), e.getY());
                            }
                        }

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            if (e.isPopupTrigger()) {
                                copyMenu.show(e.getComponent(), e.getX(), e.getY());
                            }
                        }
                    });
                    JScrollPane sp = new JScrollPane(area, 20, 30);
                    sp.setPreferredSize(new Dimension(480, 480));
                    JOptionPane.showMessageDialog(Das2ServerDataSourceEditorPanel.this, sp);
                }
            };
            SwingUtilities.invokeLater(run);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            JOptionPane.showMessageDialog(this.examplesComboBox, "Unable to parse dsdf: " + ex.getMessage());
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void viewDsdfButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        TreePath p = this.jTree1.getSelectionPath();
        TreeModel m = this.jTree1.getModel();
        if (p == null) {
            JOptionPane.showConfirmDialog(this, "No dataset selected");
            return;
        }
        if (m.isLeaf(p.getLastPathComponent())) {
            try {
                Object[] oo = p.getPath();
                StringBuilder ds = new StringBuilder(String.valueOf(oo[1]));
                for (int i = 2; i < oo.length; ++i) {
                    ds.append("/").append(oo[i]);
                }
                String surl = oo[0] + "?server=dsdf&dataset=" + ds.toString();
                final URL url = new URL(surl);
                RequestProcessor.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Das2ServerDataSourceEditorPanel.this.showDsdf(url);
                    }
                });
            }
            catch (MalformedURLException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                JOptionPane.showConfirmDialog(this, "Internal Error: " + ex.toString());
            }
        }
    }

    private void das2ServerComboBoxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        Object o = this.das2ServerComboBox.getSelectedItem();
        if (o != null && String.valueOf(o).length() > 0) {
            try {
                URL url = new URL(String.valueOf(o));
                this.setServerURL(url.toString());
            }
            catch (MalformedURLException ex) {
                if (!String.valueOf(o).contains(":")) {
                    JOptionPane.showMessageDialog(this, "<html>Invalid URL (no http):<br>" + o);
                }
                JOptionPane.showMessageDialog(this, "<html>Invalid URL:<br>" + o);
            }
        }
    }

    private void discoveryCbActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.jTree1.setModel(this.waitTreeModel());
        RequestProcessor.invokeLater((Runnable)this.getDataSetsRunnable());
    }

    private void examplesComboBoxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        String item = (String)this.examplesComboBox.getSelectedItem();
        if (item.startsWith("example")) {
            logger.log(Level.FINE, "example item: {0}", item);
            Example e = this.theExamples.get(item);
            if (e == null) {
                logger.warning("whoops, where is the label");
            } else {
                this.recentComboBox1.setText(e.timeRange);
                this.readerParamsTextArea.setText(e.params);
            }
        }
    }

    private void timeRangeToolActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        TimeRangeTool tt = new TimeRangeTool();
        RecentComboBox tf = this.recentComboBox1;
        tt.setSelectedRange(tf.getText());
        int r = JOptionPane.showConfirmDialog(this, tt, "Select Time Range", 2);
        if (r == 0) {
            tf.setText(tt.getSelectedRange());
        }
    }

    private void intrinsicCbActionPerformed(ActionEvent evt) {
    }

    private void recentComboBox1ItemStateChanged(ItemEvent evt) {
        logger.log(Level.FINEST, "changed {0}", evt.getItem());
    }

    private void editParamsButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        TreePath p = this.jTree1.getSelectionPath();
        TreeModel m = this.jTree1.getModel();
        if (p == null) {
            JOptionPane.showConfirmDialog(this, "No dataset selected");
            return;
        }
        if (m.isLeaf(p.getLastPathComponent())) {
            try {
                Object[] oo = p.getPath();
                StringBuilder ds = new StringBuilder(String.valueOf(oo[1]));
                for (int i = 2; i < oo.length; ++i) {
                    ds.append("/").append(oo[i]);
                }
                String surl = oo[0] + "?server=dsdf&dataset=" + ds.toString();
                final URL url = new URL(surl);
                RequestProcessor.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (Das2ServerDataSourceEditorPanel.this.dsdfContent == null) {
                            try {
                                Das2ServerDataSourceEditorPanel.this.dsdfContent = Das2ServerDataSourceEditorPanel.this.readDsdf(url);
                            }
                            catch (IOException ex) {
                                logger.log(Level.SEVERE, null, ex);
                            }
                        }
                        if (Das2ServerDataSourceEditorPanel.this.dsdfContent != null) {
                            Das2ServerDataSourceEditorPanel.this.editDsdfContent();
                        }
                    }
                });
            }
            catch (MalformedURLException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                JOptionPane.showConfirmDialog(this, "Internal Error: " + ex.toString());
            }
        }
    }

    public void editDsdfContent() {
        Das2ServerGUI x = new Das2ServerGUI();
        x.setSpecification(this.dsdfContent);
        x.setParameters(this.readerParamsTextArea.getText());
        JScrollPane sp = new JScrollPane(x.getPanel());
        sp.setMaximumSize(new Dimension(500, 800));
        sp.setPreferredSize(new Dimension(300, 500));
        sp.getVerticalScrollBar().setUnitIncrement(sp.getFont().getSize());
        int response = WindowManager.showConfirmDialog((Component)this, (Object)sp, (String)"Edit reader params", (int)2);
        if (response == 0) {
            this.readerParamsTextArea.setText(x.getParameters());
        }
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        String oldServerURL = this.serverURL;
        this.serverURL = serverURL;
        if (!this.serverURL.equals(oldServerURL)) {
            this.descriptionLabel.setText("");
            this.jTree1.setModel(this.waitTreeModel());
            RequestProcessor.invokeLater((Runnable)this.getDataSetsRunnable());
        }
        this.firePropertyChange(PROP_SERVERURL, oldServerURL, serverURL);
    }

    public String getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(String dataSetId) {
        String oldDataSetId = this.dataSetId;
        this.dataSetId = dataSetId;
        this.firePropertyChange(PROP_DATASETID, oldDataSetId, dataSetId);
    }

    public JPanel getPanel() {
        return this;
    }

    public boolean reject(String uri) throws Exception {
        String s;
        URISplit split = URISplit.parse((String)uri);
        if (split.file == null || split.file.equals("file:///")) {
            split.file = "https://planet.physics.uiowa.edu/das/das2Server";
        }
        if ((s = split.file).equals("https://planet.physics.uiowa.edu/das/das2Server")) {
            return false;
        }
        return false;
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) {
        return true;
    }

    public void setURI(String uri) {
        String item;
        String uriServerUrl;
        URISplit split = URISplit.parse((String)uri);
        this.serverURL = split.resourceUri == null ? "" : ((uriServerUrl = DataSetURI.fromUri((URI)split.resourceUri)).length() > 0 && !uriServerUrl.startsWith("file:/") ? uriServerUrl : "");
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        this.dataSetId = (String)params.remove("dataset");
        if (this.dataSetId == null) {
            this.dataSetId = (String)params.remove("arg_0");
        }
        if (this.dataSetId != null && this.dataSetId.startsWith("/")) {
            this.dataSetId = this.dataSetId.substring(1);
        }
        String startTime = (String)params.remove("start_time");
        String endTime = (String)params.remove("end_time");
        String str = (String)params.remove("timerange");
        if (str != null) {
            this.userTimeRange = str;
            try {
                DatumRange tr = DatumRangeUtil.parseTimeRange((String)str);
                startTime = tr.min().toString();
                endTime = tr.max().toString();
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (startTime != null && endTime != null) {
            try {
                Datum t1 = TimeUtil.create((String)startTime);
                Datum t2 = TimeUtil.create((String)endTime);
                DatumRange dr = new DatumRange(t1, t2);
                if (this.userTimeRange == null) {
                    this.userTimeRange = dr.toString();
                }
                this.recentComboBox1.setText(dr.toString());
            }
            catch (ParseException ex) {
                this.recentComboBox1.setText("2001-01-01");
            }
        } else {
            this.recentComboBox1.setText("2001-01-01");
        }
        String intrinsic = (String)params.remove("intrinsic");
        this.intrinsicCb.setSelected("true".equals(intrinsic));
        String interval = (String)params.remove("interval");
        if (interval != null) {
            this.tcaTextField.setText(interval);
        }
        if ((item = (String)params.remove("item")) != null) {
            this.itemsComboBox.setSelectedItem(item);
            this.tcaItem.put("" + this.serverURL + "?server=dsdf&dataset=" + this.dataSetId, item);
        }
        this.otherParams.put("qubeSubset", (String)params.remove("qubeSubset"));
        StringBuilder paramsStr = new StringBuilder();
        for (Map.Entry e : params.entrySet()) {
            if (((String)e.getKey()).startsWith("arg_")) {
                paramsStr.append((String)e.getValue()).append("\n");
                continue;
            }
            paramsStr.append((String)e.getKey()).append("=").append((String)e.getValue()).append("\n");
        }
        this.readerParamsTextArea.setText(paramsStr.toString());
        String key = this.serverURL + "?" + this.dataSetId;
        this.readerParams.put(key, paramsStr.toString());
        this.das2ServerComboBox.setSelectedItem(this.serverURL);
        this.updateDas2Servers();
        if (this.serverURL.length() > 0) {
            RequestProcessor.invokeLater((Runnable)this.getDataSetsRunnable());
        }
    }

    TreeModel waitTreeModel() {
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("updating, please wait...");
        return new DefaultTreeModel(treeNode1);
    }

    private void updateTree(TreeModel model) {
        this.jTree1.setModel(model);
        this.jTree1.setCellRenderer(new DataSetItemRenderer());
        if (this.dataSetId != null) {
            this.selectDataSetId();
        }
    }

    Runnable getDataSetsRunnable() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String ss1 = Das2ServerDataSourceEditorPanel.this.serverURL;
                try {
                    DasServer server = DasServer.create((URL)new URL(ss1));
                    final TreeModel model = Das2ServerDataSourceEditorPanel.this.discoveryCb.isSelected() ? server.getDataSetListWithDiscovery() : server.getDataSetList();
                    Das2ServerDataSourceEditorPanel.this.updateDas2ServersImmediately();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Das2ServerDataSourceEditorPanel.this.updateTree(model);
                        }
                    });
                }
                catch (DasException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Error connecting to " + ss1 + ", \n" + (Object)((Object)ex));
                    Das2ServerDataSourceEditorPanel.this.jTree1.setModel(new DefaultTreeModel(treeNode1));
                }
                catch (MalformedURLException ex) {
                    DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Error connecting to " + ss1 + ", \n" + ex);
                    Das2ServerDataSourceEditorPanel.this.jTree1.setModel(new DefaultTreeModel(treeNode1));
                }
            }
        };
        return run;
    }

    private void selectDataSetId() {
        String[] ss = this.dataSetId.split("/");
        Object[] oo = new TreeNode[ss.length + 1];
        oo[0] = (TreeNode)this.jTree1.getModel().getRoot();
        for (int i = 1; i < oo.length; ++i) {
            for (int j = 0; j < oo[i - 1].getChildCount(); ++j) {
                DefaultMutableTreeNode kid = (DefaultMutableTreeNode)oo[i - 1].getChildAt(j);
                if (!((DasServer.DataSrcListItem)kid.getUserObject()).name().equals(ss[i - 1])) continue;
                oo[i] = kid;
                break;
            }
            if (oo[i] != null) continue;
            return;
        }
        final TreePath tp = new TreePath(oo);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Das2ServerDataSourceEditorPanel.this.jTree1.setSelectionPath(tp);
                Das2ServerDataSourceEditorPanel.this.jTree1.scrollPathToVisible(tp);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public String getURI() {
        String s;
        String tcaInterval;
        DatumRange timeRange;
        Object[] tp0;
        boolean folder;
        block17: {
            TreePath tp = this.jTree1.getSelectionPath();
            if (tp == null) {
                return "vap+das2server:" + this.serverURL + "?";
            }
            folder = !this.jTree1.getModel().isLeaf(tp.getLastPathComponent());
            tp0 = tp.getPath();
            try {
                timeRange = DatumRangeUtil.parseTimeRange((String)this.recentComboBox1.getText());
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                timeRange = this.validTimeRange;
                if (timeRange != null) break block17;
                throw new IllegalArgumentException("No timerange for the URI.");
            }
        }
        StringBuilder ldataSetId = new StringBuilder("");
        if (tp0.length > 1) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)tp0[1];
            DasServer.DataSrcListItem li = (DasServer.DataSrcListItem)tn.getUserObject();
            ldataSetId = new StringBuilder(li.name());
            for (int i = 2; i < tp0.length; ++i) {
                tn = (DefaultMutableTreeNode)tp0[i];
                li = (DasServer.DataSrcListItem)tn.getUserObject();
                ldataSetId.append("/").append(li.name());
            }
        }
        if (folder) {
            ldataSetId.append("/");
        }
        StringBuilder params = new StringBuilder();
        String lreaderParams = this.readerParamsTextArea.getText();
        String[] ss = lreaderParams.split("\n");
        for (int i = 0; i < ss.length; ++i) {
            String ss1 = ss[i].trim();
            if (ss1.length() == 0) continue;
            String[] ss2 = ss1.split("\\s+");
            for (int j = 0; j < ss2.length; ++j) {
                String[] ss3 = ss2[j].split("\\s*=\\s*", -2);
                if (ss3.length == 1) {
                    params.append(URLEncoder.encode(ss3[0].trim()));
                } else {
                    params.append(URLEncoder.encode(ss3[0].trim())).append("=").append(URLEncoder.encode(ss3[1].trim()));
                }
                if (i >= ss.length - 1 && j >= ss2.length - 1) continue;
                params.append("%20");
            }
        }
        StringBuilder result = new StringBuilder("vap+das2server:");
        result.append(this.serverURL).append("?").append("dataset=").append(ldataSetId.toString());
        if (timeRange != null) {
            result.append("&start_time=").append(timeRange.min()).append("&end_time=").append(timeRange.max());
        }
        if (this.intrinsicCb.isSelected()) {
            result.append("&intrinsic=true");
        }
        if (!(tcaInterval = this.tcaTextField.getText().trim()).equals("")) {
            result.append("&interval=").append(tcaInterval);
        }
        if (!(s = this.itemsComboBox.getSelectedItem().toString().trim()).equals("")) {
            if (s.startsWith("0 (")) {
                s = "0";
            }
            result.append("&item=").append(s);
        }
        if (params.length() > 0) {
            result.append("&").append(params.toString());
        }
        if (this.otherParams.get("qubeSubset") != null) {
            result.append("&qubeSubset=").append(this.otherParams.get("qubeSubset"));
        }
        return result.toString();
    }

    public void markProblems(List<String> problems) {
    }

    public void setExpertMode(boolean expert) {
        this.discoveryCb.setSelected(!expert);
    }

    private static class DataSetItemRenderer
    extends DefaultTreeCellRenderer {
        private DataSetItemRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bIsLeaf, int iRow, boolean bHasFocus) {
            super.getTreeCellRendererComponent(tree, value, bSelected, bExpanded, bIsLeaf, iRow, bHasFocus);
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)value;
            Object obj = tn.getUserObject();
            if (obj instanceof DasServer.DataSrcListItem) {
                DasServer.DataSrcListItem li = (DasServer.DataSrcListItem)obj;
                if (li.description() == null) {
                    this.setText(String.format("<html><b>%s</b>", li.name()));
                } else {
                    this.setText(String.format("<html><b>%s</b> &nbsp;<i>%s</i>", li.name(), li.description()));
                }
            }
            return this;
        }
    }

    private static class IconCellRenderer
    implements ListCellRenderer {
        DefaultListCellRenderer r = new DefaultListCellRenderer();

        private IconCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.r.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Icon icon = Das2ServerDataSourceEditorPanel.iconFor(value, false);
            ((DefaultListCellRenderer)c).setIcon(icon);
            return c;
        }
    }

    private static class Example {
        private String timeRange;
        private String label = "";
        private String params = "";

        private Example() {
        }
    }
}

