/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datasource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.datasource.Das2ServerDataSource;
import org.das2.datasource.Das2ServerTimeSeriesBrowse;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Das2ServerDataSourceFactory
implements DataSourceFactory {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.das2server");
    Map<String, List<String>> datasetsList = null;
    public static final String PROB_DS = "Dataset ID is not specified";
    public static final String PROB_TIMERANGE = "Timerange is not specified";

    public DataSource getDataSource(URI uri) throws Exception {
        return new Das2ServerDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        ArrayList<CompletionContext> result;
        block9: {
            String paramName;
            block10: {
                block8: {
                    result = new ArrayList<CompletionContext>();
                    if (cc.context != CompletionContext.CONTEXT_PARAMETER_NAME) break block8;
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "dataset=", "dataset identifier"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "start_time=", "ISO8601 start time"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "end_time=", "ISO8601 end time"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "timerange=", "time range"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "intrinsic=true", "do not reduce on server"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "interval=", "cadence in seconds for TCAs"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "item=", "item number for TCAs"));
                    break block9;
                }
                if (cc.context != CompletionContext.CONTEXT_PARAMETER_VALUE) break block9;
                paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
                if (!paramName.equals("dataset")) break block10;
                URI uri = cc.resourceURI;
                if (uri == null) {
                    throw new IllegalArgumentException("expected das2server location");
                }
                List<String> dss = this.getDatasetsList(uri.toString());
                for (String ds : dss) {
                    if (!ds.startsWith(cc.completable)) continue;
                    int i = ds.indexOf(124);
                    if (i == -1) {
                        result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, ds));
                        continue;
                    }
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, ds.substring(0, i), ds.substring(i + 1).trim()));
                }
                break block9;
            }
            if (!paramName.equals("timerange")) break block9;
            URI uri = cc.resourceURI;
            URISplit split = URISplit.parse((URI)uri);
            LinkedHashMap params = URISplit.parseParams((String)cc.params);
            String dataset = (String)params.get("dataset");
            if (dataset != null) {
                String surl = split.resourceUri + "?server=dsdf&dataset=" + dataset;
                InputStream in = new URL(surl).openStream();
                StringBuilder sb = new StringBuilder();
                int by = in.read();
                while (by != -1) {
                    sb.append((char)by);
                    by = in.read();
                }
                in.close();
                String s = sb.toString();
                int packetTagLength = 10;
                int contentLength = Integer.parseInt(s.substring(4, 10));
                String sxml = s.substring(10, 10 + contentLength);
                BufferedReader xin = new BufferedReader(new StringReader(sxml));
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                InputSource source = new InputSource(xin);
                try {
                    Document document = builder.parse(source);
                    XPathFactory factory = XPathFactory.newInstance();
                    XPath xpath = factory.newXPath();
                    NodeList exs = (NodeList)xpath.evaluate("/stream/properties/@*", document, XPathConstants.NODESET);
                    for (int i = 0; i < exs.getLength(); ++i) {
                        Node ex = exs.item(i);
                        String name = ex.getNodeName();
                        if (!name.startsWith("exampleRange")) continue;
                        String ss = ex.getNodeValue();
                        result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, ss));
                    }
                }
                catch (SAXException ex) {
                    System.err.println("SAX Exception: " + surl);
                }
            }
        }
        return result;
    }

    private synchronized List<String> getDatasetsList(String surl) {
        List<String> result;
        if (this.datasetsList == null) {
            this.datasetsList = new HashMap<String, List<String>>();
        }
        if ((result = this.datasetsList.get(surl)) == null) {
            BufferedReader reader = null;
            try {
                HttpURLConnection httpConn;
                int nStatus;
                URL url = new URL(surl + "?server=list");
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
                conn.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
                InputStream in = null;
                if (conn instanceof HttpURLConnection && (nStatus = (httpConn = (HttpURLConnection)conn).getResponseCode()) >= 400) {
                    throw new IOException("Server returned HTTP response code:" + nStatus + " for URL: " + url);
                }
                in = conn.getInputStream();
                reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                String s = reader.readLine();
                ArrayList<String> list = new ArrayList<String>();
                while (s != null) {
                    list.add(s);
                    s = reader.readLine();
                }
                this.datasetsList.put(surl, list);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                throw new RuntimeException(ex);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        return this.datasetsList.get(surl);
    }

    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        URISplit split = URISplit.parse((String)surl);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String ds = (String)params.get("dataset");
        if (params.get("arg_0") != null) {
            ds = (String)params.get("arg_0");
        }
        if (ds == null || ds.length() == 0) {
            problems.add(PROB_DS);
            return true;
        }
        if (ds.endsWith("/")) {
            problems.add(PROB_DS);
            return true;
        }
        String str = (String)params.get("timerange");
        if (str != null) {
            str = str.replaceAll("\\+", " ");
            try {
                DatumRange tr = DatumRangeUtil.parseTimeRange((String)str);
                params.put("start_time", tr.min().toString());
                params.put("end_time", tr.max().toString());
            }
            catch (ParseException ex) {
                logger.log(Level.WARNING, "unable to parse timerange {0}", str);
            }
        }
        if (!params.containsKey("start_time") || !params.containsKey("end_time")) {
            problems.add(PROB_TIMERANGE);
            return true;
        }
        return false;
    }

    public boolean supportsDiscovery() {
        return true;
    }

    public boolean isFileResource() {
        return false;
    }

    public <T> T getCapability(Class<T> clazz) {
        if (clazz == TimeSeriesBrowse.class) {
            return (T)new Das2ServerTimeSeriesBrowse();
        }
        return null;
    }

    public String getDescription() {
        return "Das2 Data Servers";
    }
}

