/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d.viewer;

import ProGAL.geom2d.Circle;
import ProGAL.geom2d.LSC;
import ProGAL.geom2d.Line;
import ProGAL.geom2d.LineSegment;
import ProGAL.geom2d.Point;
import ProGAL.geom2d.Polygon;
import ProGAL.geom2d.Shape;
import ProGAL.geom2d.Triangle;
import ProGAL.geom2d.Vector;
import ProGAL.geom2d.viewer.CirclePainter;
import ProGAL.geom2d.viewer.ClickListener;
import ProGAL.geom2d.viewer.LSCPainter;
import ProGAL.geom2d.viewer.LinePainter;
import ProGAL.geom2d.viewer.LineSegmentPainter;
import ProGAL.geom2d.viewer.PolygonPainter;
import ProGAL.geom2d.viewer.ShapePainter;
import ProGAL.geom2d.viewer.TextPainter;
import ProGAL.geom2d.viewer.TextShape;
import ProGAL.geom2d.viewer.TrianglePainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class J2DScene {
    public JFrame frame;
    private final PaintPanel canvasPanel;
    private final List<ClickListener> clickListeners = new LinkedList<ClickListener>();
    private final List<ShapeOptions> shapes = new ArrayList<ShapeOptions>();
    private Point camCenter;
    double scale = 100.0;
    private static final ShapePainter[] shapePainters = new ShapePainter[]{new CirclePainter(), new LineSegmentPainter(), new TextPainter(), new LSCPainter(), new TrianglePainter(), new PolygonPainter(), new LinePainter()};

    public J2DScene() {
        this.canvasPanel = new PaintPanel();
        this.camCenter = new Point(0.0, 0.0);
        this.canvasPanel.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 67) {
                    J2DScene.this.centerCamera();
                }
                if (e.getKeyCode() == 90) {
                    J2DScene.this.autoZoom();
                }
                if (e.getKeyCode() == 83) {
                    J2DScene.this.savePng("J2DSnapshot.png");
                }
            }
        });
        this.canvasPanel.addMouseListener(this.canvasPanel);
        this.canvasPanel.addMouseMotionListener(this.canvasPanel);
        this.canvasPanel.addMouseWheelListener(this.canvasPanel);
        this.canvasPanel.setFocusable(true);
    }

    public JPanel getCanvas() {
        return this.canvasPanel;
    }

    public void centerCamera() {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (ShapeOptions so : this.shapes) {
            Point p = so.shape.getCenter();
            if (p.x() < minX) {
                minX = p.x();
            }
            if (p.y() < minY) {
                minY = p.y();
            }
            if (p.x() > maxX) {
                maxX = p.x();
            }
            if (!(p.y() > maxY)) continue;
            maxY = p.y();
        }
        this.camCenter = new Point((minX + maxX) / 2.0, (minY + maxY) / 2.0);
        this.repaint();
    }

    public void autoZoom() {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (ShapeOptions so : this.shapes) {
            Point p = so.shape.getCenter();
            if (p.x() < minX) {
                minX = p.x();
            }
            if (p.y() < minY) {
                minY = p.y();
            }
            if (p.x() > maxX) {
                maxX = p.x();
            }
            if (!(p.y() > maxY)) continue;
            maxY = p.y();
        }
        int w = this.canvasPanel.getWidth();
        int h = this.canvasPanel.getHeight();
        if (w == 0) {
            w = 1000;
        }
        if (h == 0) {
            h = 700;
        }
        this.scale = Math.min((double)w / (maxX - minX), (double)h / (maxY - minY)) * 0.9;
        this.repaint();
    }

    public void addShape(Shape s) {
        this.addShape(s, Color.GRAY, 0.01, false);
    }

    public void addShape(Shape s, Color c) {
        this.addShape(s, c, 0.01, false);
    }

    public void addShape(Shape s, Color c, double border) {
        this.addShape(s, c, border, false);
    }

    public void addShape(Shape s, Color c, double border, boolean fill) {
        this.shapes.add(new ShapeOptions(s, c, border, fill));
    }

    public void savePng(String fName) {
        BufferedImage bImg = new BufferedImage(this.canvasPanel.getWidth(), this.canvasPanel.getHeight(), 1);
        Graphics2D cg = bImg.createGraphics();
        this.canvasPanel.paintAll(cg);
        try {
            if (ImageIO.write((RenderedImage)bImg, "png", new File(fName))) {
                System.out.println("Successfully wrote " + fName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeShape(Shape s) {
        ShapeOptions opt = null;
        for (ShapeOptions so : this.shapes) {
            if (so.shape != s) continue;
            opt = so;
            break;
        }
        this.shapes.remove(opt);
    }

    public void removeAllShapes() {
        this.shapes.clear();
    }

    public void addClickListener(ClickListener cl) {
        this.clickListeners.add(cl);
    }

    public void repaint() {
        this.canvasPanel.repaint();
    }

    private static ShapePainter getShapePainter(Shape s) {
        if (s instanceof Circle) {
            return shapePainters[0];
        }
        if (s instanceof LineSegment) {
            return shapePainters[1];
        }
        if (s instanceof TextShape) {
            return shapePainters[2];
        }
        if (s instanceof LSC) {
            return shapePainters[3];
        }
        if (s instanceof Triangle) {
            return shapePainters[4];
        }
        if (s instanceof Polygon) {
            return shapePainters[5];
        }
        if (s instanceof Line) {
            return shapePainters[6];
        }
        return null;
    }

    public java.awt.Point transformPoint(Point p) {
        int w = this.canvasPanel.getWidth();
        int h = this.canvasPanel.getHeight();
        int gX = (int)(this.scale * (p.x() - this.camCenter.x()) + (double)(w / 2));
        int gY = (int)(-this.scale * (p.y() - this.camCenter.y()) + (double)(h / 2));
        return new java.awt.Point(gX, gY);
    }

    public Point transformPoint(java.awt.Point p) {
        int w = this.canvasPanel.getWidth();
        int h = this.canvasPanel.getHeight();
        int gX = p.x;
        int gY = p.y;
        double x = (double)(gX - w / 2) / this.scale + this.camCenter.x();
        double y = (double)(gY - h / 2) / -this.scale + this.camCenter.y();
        return new Point(x, y);
    }

    public static J2DScene createJ2DSceneInFrame() {
        J2DScene scene = new J2DScene();
        JFrame frame = new JFrame("J2DScene");
        frame.getContentPane().add(scene.canvasPanel);
        frame.setSize(1000, 1000);
        frame.setVisible(true);
        scene.frame = frame;
        return scene;
    }

    public static void main(String[] args) {
        J2DScene scene = J2DScene.createJ2DSceneInFrame();
        scene.addShape(new LineSegment(new Point(0.0, 0.0), new Point(1.0, 0.0)), Color.BLACK);
        scene.addShape(new LineSegment(new Point(0.0, 0.0), new Point(0.0, 1.0)), Color.BLACK);
        scene.addShape(new TextShape("(1,0)", new Point(1.0, 0.0), 0.2));
        scene.addShape(new TextShape("(0,1)", new Point(0.0, 1.0), 0.2));
        scene.addShape(new Circle(new Point(0.1, 0.1), 0.01), Color.BLACK, 0.0, true);
        scene.addShape(new Circle(new Point(0.2, 0.2), 0.01), Color.BLACK, 0.0, true);
        scene.addShape(new LSC(new Point(0.0, -0.5), new Point(1.0, -0.4), 0.2), Color.RED);
        scene.addShape(new LSC(new Point(0.0, -0.9), new Point(1.0, -0.9), 0.1), Color.RED, 0.0, true);
        Point p = new Point(-2.0, 0.0);
        scene.addShape(new Triangle(new Point(-1.0, 0.0), new Point(-1.0, 1.0), p), Color.GREEN, 0.0, true);
        scene.addShape(new Polygon(new Point[]{new Point(-1.0, 2.0), new Point(-1.0, 2.4), new Point(-1.4, 2.1), new Point(-1.6, 2.8)}), Color.BLUE, 0.0, true);
        scene.addShape(new Line(new Point(3.0, 0.0), new Vector(0.01, -0.03)));
        scene.centerCamera();
        while (true) {
            p.addThis(new Vector(0.01, 0.0));
            scene.repaint();
            try {
                Thread.sleep(30L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    class ShapeOptions {
        Shape shape;
        Color color;
        double borderWidth;
        boolean fill;

        ShapeOptions(Shape s, Color c, double bw, boolean f) {
            this.shape = s;
            this.color = c;
            this.borderWidth = bw;
            this.fill = f;
        }

        java.awt.Point transformPoint(Point p) {
            return J2DScene.this.transformPoint(p);
        }

        Point transformPoint(java.awt.Point p) {
            return J2DScene.this.transformPoint(p);
        }

        double getScale() {
            return J2DScene.this.scale;
        }
    }

    private class PaintPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private static final long serialVersionUID = 1L;
        java.awt.Point lastPoint = null;

        private PaintPanel() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (ShapeOptions so : new LinkedList(J2DScene.this.shapes)) {
                if (so == null) continue;
                Stroke oldStroke = g2d.getStroke();
                g2d.setStroke(new BasicStroke((float)(J2DScene.this.scale * so.borderWidth), 1, 1));
                g2d.setPaint(so.color);
                ShapePainter sp = J2DScene.getShapePainter(so.shape);
                if (sp == null) {
                    System.err.println("J2DScene: ShapePainter not implemented for " + so.shape.getClass().getSimpleName());
                } else {
                    sp.paintShape(so, g2d);
                }
                g2d.setStroke(oldStroke);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            java.awt.Point p = e.getLocationOnScreen();
            Point p0 = this.transformPoint(this.lastPoint);
            Point p1 = this.transformPoint(p);
            J2DScene.this.camCenter.addThis(new Vector(p0.x() - p1.x(), p0.y() - p1.y()));
            this.repaint();
            this.lastPoint = p;
        }

        Point transformPoint(java.awt.Point p) {
            int w = this.getWidth();
            int h = this.getHeight();
            double pX = (double)(p.x - w / 2) / J2DScene.this.scale + J2DScene.this.camCenter.x();
            double pY = (double)(-(p.y - h / 2)) / J2DScene.this.scale + J2DScene.this.camCenter.y();
            return new Point(pX, pY);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = null;
            Shape shapeClicked = null;
            for (ShapeOptions so : new LinkedList(J2DScene.this.shapes)) {
                if (!so.fill) continue;
                if (p == null) {
                    p = this.transformPoint(e.getPoint());
                }
                if (!so.shape.contains(p)) continue;
                shapeClicked = so.shape;
            }
            for (ClickListener cl : J2DScene.this.clickListeners) {
                cl.shapeClicked(shapeClicked, e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.lastPoint = e.getLocationOnScreen();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            double factor = Math.pow(0.97, e.getWheelRotation());
            J2DScene.this.scale *= factor;
            this.repaint();
        }
    }
}

