/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.predicates;

import ProGAL.geom3d.LineSegment;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Triangle;
import ProGAL.geom3d.predicates.Predicates;
import ProGAL.geom3d.volumes.Tetrahedron;

public class ExactJavaPredicates
extends Predicates {
    private double splitter;
    private double epsilon;
    private double resulterrbound;
    private double ccwerrboundA;
    private double ccwerrboundB;
    private double ccwerrboundC;
    private double o3derrboundA;
    private double o3derrboundB;
    private double o3derrboundC;
    private double iccerrboundA;
    private double iccerrboundB;
    private double iccerrboundC;
    private double isperrboundA;
    private double isperrboundB;
    private double isperrboundC;
    double[] p0 = new double[3];
    double[] p1 = new double[3];
    double[] p2 = new double[3];
    double[] p3 = new double[3];
    double[] p4 = new double[3];

    public ExactJavaPredicates() {
        this.exactinit();
    }

    @Override
    public double circumradius(Point p0, Point p1, Point p2, Point p3) {
        double x0 = p0.x();
        double y0 = p0.y();
        double z0 = p0.z();
        double x1 = p1.x();
        double y1 = p1.y();
        double z1 = p1.z();
        double x2 = p2.x();
        double y2 = p2.y();
        double z2 = p2.z();
        double x3 = p3.x();
        double y3 = p3.y();
        double z3 = p3.z();
        return this.tetcircumradius(x0, y0, z0, x1, y1, z1, x2, y2, z2, x3, y3, z3);
    }

    @Override
    public double circumradius(Tetrahedron t) {
        return this.circumradius(t.getPoint(0), t.getPoint(1), t.getPoint(2), t.getPoint(3));
    }

    @Override
    public double circumradius(Point p0, Point p1, Point p2) {
        double radius = this.tricircumradius3d(p0.x(), p0.y(), p0.z(), p1.x(), p1.y(), p1.z(), p2.x(), p2.y(), p2.z());
        return radius;
    }

    @Override
    public double circumradius(Triangle tri) {
        return tri.circumradius();
    }

    @Override
    public double orient(Point p0, Point p1, Point p2, Point q) {
        double orient = this.orient3d(p0.x(), p0.y(), p0.z(), p1.x(), p1.y(), p1.z(), p2.x(), p2.y(), p2.z(), q.x(), q.y(), q.z());
        return orient;
    }

    @Override
    public Predicates.SphereConfig insphere(Point p0, Point p1, Point p2, Point p3, Point q) {
        double orient = this.orient(p0, p1, p2, p3);
        if (orient == 0.0) {
            return Predicates.SphereConfig.COPLANAR;
        }
        double result = this.insphere(p0.x(), p0.y(), p0.z(), p1.x(), p1.y(), p1.z(), p2.x(), p2.y(), p2.z(), p3.x(), p3.y(), p3.z(), q.x(), q.y(), q.z());
        if (result == 0.0) {
            return Predicates.SphereConfig.ON;
        }
        if (Math.signum(result) * Math.signum(orient) < 0.0) {
            return Predicates.SphereConfig.OUTSIDE;
        }
        return Predicates.SphereConfig.INSIDE;
    }

    @Override
    public Predicates.SphereConfig insphere(Tetrahedron t, Point q) {
        return this.insphere(t.getPoint(0), t.getPoint(1), t.getPoint(2), t.getPoint(3), q);
    }

    @Override
    public Predicates.SphereConfig insphere(Point p0, Point p1, Point p2, Point q) {
        double result = this.inspheretri(p0.x(), p0.y(), p0.z(), p1.x(), p1.y(), p1.z(), p2.x(), p2.y(), p2.z(), q.x(), q.y(), q.z());
        if (result > 0.0) {
            return Predicates.SphereConfig.INSIDE;
        }
        if (result < 0.0) {
            return Predicates.SphereConfig.OUTSIDE;
        }
        return Predicates.SphereConfig.ON;
    }

    @Override
    public Predicates.SphereConfig insphere(Triangle tri, Point q) {
        return this.insphere(tri.getPoint(0), tri.getPoint(1), tri.getPoint(2), q);
    }

    @Override
    public Predicates.PlaneConfig diffsides(Point p0, Point p1, Point p2, Point q0, Point q1) {
        double a = this.orient(p0, p1, p2, q0);
        double b = this.orient(p0, p1, p2, q1);
        if (a == 0.0 || b == 0.0) {
            return Predicates.PlaneConfig.COPLANAR;
        }
        if (a > 0.0 && b < 0.0 || a < 0.0 && b > 0.0) {
            return Predicates.PlaneConfig.DIFF;
        }
        if (a > 0.0 && b > 0.0 || a < 0.0 && b < 0.0) {
            return Predicates.PlaneConfig.SAME;
        }
        return null;
    }

    @Override
    public boolean inplane(Point p0, Point p1, Point p2, Point p3) {
        return this.orient(p0, p1, p2, p3) == 0.0;
    }

    @Override
    public Predicates.SphereConfig edgeinsphere(LineSegment ls, Point q) {
        double r_sq;
        double d_sq = ls.getMidPoint().distanceSquared(q);
        if (d_sq == (r_sq = ls.getLengthSquared() / 4.0)) {
            return Predicates.SphereConfig.ON;
        }
        if (d_sq < r_sq) {
            return Predicates.SphereConfig.INSIDE;
        }
        return Predicates.SphereConfig.OUTSIDE;
    }

    @Override
    public double edgecircumradius(LineSegment ls) {
        return ls.getLength() / 2.0;
    }

    private void exactinit() {
        double lastcheck;
        boolean every_other = true;
        double half = 0.5;
        this.epsilon = 1.0;
        this.splitter = 1.0;
        double check = 1.0;
        do {
            lastcheck = check;
            this.epsilon *= half;
            if (every_other) {
                this.splitter *= 2.0;
            }
            every_other = !every_other;
        } while ((check = 1.0 + this.epsilon) != 1.0 && check != lastcheck);
        this.splitter += 1.0;
        this.resulterrbound = (3.0 + 8.0 * this.epsilon) * this.epsilon;
        this.ccwerrboundA = (3.0 + 16.0 * this.epsilon) * this.epsilon;
        this.ccwerrboundB = (2.0 + 12.0 * this.epsilon) * this.epsilon;
        this.ccwerrboundC = (9.0 + 64.0 * this.epsilon) * this.epsilon * this.epsilon;
        this.o3derrboundA = (7.0 + 56.0 * this.epsilon) * this.epsilon;
        this.o3derrboundB = (3.0 + 28.0 * this.epsilon) * this.epsilon;
        this.o3derrboundC = (26.0 + 288.0 * this.epsilon) * this.epsilon * this.epsilon;
        this.iccerrboundA = (10.0 + 96.0 * this.epsilon) * this.epsilon;
        this.iccerrboundB = (4.0 + 48.0 * this.epsilon) * this.epsilon;
        this.iccerrboundC = (44.0 + 576.0 * this.epsilon) * this.epsilon * this.epsilon;
        this.isperrboundA = (16.0 + 224.0 * this.epsilon) * this.epsilon;
        this.isperrboundB = (5.0 + 72.0 * this.epsilon) * this.epsilon;
        this.isperrboundC = (71.0 + 1408.0 * this.epsilon) * this.epsilon * this.epsilon;
    }

    private int fast_expansion_sum_zeroelim(int elen, double[] e, int flen, double[] f, double[] h) {
        double around;
        double bround;
        double avirt;
        double hh;
        double bvirt;
        double Qnew;
        double Q;
        double enow = e[0];
        double fnow = f[0];
        int findex = 0;
        int eindex = 0;
        if (fnow > enow == fnow > -enow) {
            Q = enow;
            enow = e[++eindex];
        } else {
            Q = fnow;
            fnow = f[++findex];
        }
        int hindex = 0;
        if (eindex < elen && findex < flen) {
            if (fnow > enow == fnow > -enow) {
                Qnew = enow + Q;
                bvirt = Qnew - enow;
                hh = Q - bvirt;
                enow = e[++eindex];
            } else {
                Qnew = fnow + Q;
                bvirt = Qnew - fnow;
                hh = Q - bvirt;
                fnow = f[++findex];
            }
            Q = Qnew;
            if (hh != 0.0) {
                h[hindex++] = hh;
            }
            while (eindex < elen && findex < flen) {
                if (fnow > enow == fnow > -enow) {
                    Qnew = Q + enow;
                    bvirt = Qnew - Q;
                    avirt = Qnew - bvirt;
                    bround = enow - bvirt;
                    around = Q - avirt;
                    hh = around + bround;
                    enow = e[++eindex];
                } else {
                    Qnew = Q + fnow;
                    bvirt = Qnew - Q;
                    avirt = Qnew - bvirt;
                    bround = fnow - bvirt;
                    around = Q - avirt;
                    hh = around + bround;
                    fnow = f[++findex];
                }
                Q = Qnew;
                if (hh == 0.0) continue;
                h[hindex++] = hh;
            }
        }
        while (eindex < elen) {
            Qnew = Q + enow;
            bvirt = Qnew - Q;
            avirt = Qnew - bvirt;
            bround = enow - bvirt;
            around = Q - avirt;
            hh = around + bround;
            enow = e[++eindex];
            Q = Qnew;
            if (hh == 0.0) continue;
            h[hindex++] = hh;
        }
        while (findex < flen) {
            Qnew = Q + fnow;
            bvirt = Qnew - Q;
            avirt = Qnew - bvirt;
            bround = fnow - bvirt;
            around = Q - avirt;
            hh = around + bround;
            fnow = f[++findex];
            Q = Qnew;
            if (hh == 0.0) continue;
            h[hindex++] = hh;
        }
        if (Q != 0.0 || hindex == 0) {
            h[hindex++] = Q;
        }
        return hindex;
    }

    private int scale_expansion_zeroelim(int elen, double[] e, double b, double[] h) {
        double c = this.splitter * b;
        double abig = c - b;
        double bhi = c - abig;
        double blo = b - bhi;
        double Q = e[0] * b;
        c = this.splitter * e[0];
        abig = c - e[0];
        double ahi = c - abig;
        double alo = e[0] - ahi;
        double err1 = Q - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double hh = alo * blo - err3;
        int hindex = 0;
        if (hh != 0.0) {
            h[hindex++] = hh;
        }
        for (int eindex = 1; eindex < elen; ++eindex) {
            double enow = e[eindex];
            c = this.splitter * enow;
            abig = c - enow;
            ahi = c - abig;
            alo = enow - ahi;
            double product1 = enow * b;
            err1 = product1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double product0 = alo * blo - err3;
            double sum = Q + product0;
            double bvirt = sum - Q;
            double avirt = sum - bvirt;
            double around = Q - avirt;
            double bround = product0 - bvirt;
            hh = around + bround;
            if (hh != 0.0) {
                h[hindex++] = hh;
            }
            if ((hh = sum - (bvirt = (Q = product1 + sum) - product1)) == 0.0) continue;
            h[hindex++] = hh;
        }
        if (Q != 0.0 || hindex == 0) {
            h[hindex++] = Q;
        }
        return hindex;
    }

    private double estimate(int elen, double[] e) {
        double Q = e[0];
        for (int eindex = 1; eindex < elen; ++eindex) {
            Q += e[eindex];
        }
        return Q;
    }

    private double orient2dexact(double[] pa, double[] pb, double[] pc) {
        double[] aterms = new double[4];
        double[] bterms = new double[4];
        double[] cterms = new double[4];
        double[] v = new double[8];
        double[] w = new double[12];
        double axby1 = pa[0] * pb[1];
        double c = this.splitter * pa[0];
        double abig = c - pa[0];
        double ahi = c - abig;
        double alo = pa[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        double bhi = c - abig;
        double blo = pb[1] - bhi;
        double err1 = axby1 - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double axby0 = alo * blo - err3;
        double axcy1 = pa[0] * pc[1];
        c = this.splitter * pa[0];
        abig = c - pa[0];
        ahi = c - abig;
        alo = pa[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = axcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double axcy0 = alo * blo - err3;
        double _i = axby0 - axcy0;
        double bvirt = axby0 - _i;
        double avirt = _i + bvirt;
        double bround = bvirt - axcy0;
        double around = axby0 - avirt;
        aterms[0] = around + bround;
        double _j = axby1 + _i;
        bvirt = _j - axby1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = axby1 - avirt;
        double _0 = around + bround;
        _i = _0 - axcy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axcy1;
        around = _0 - avirt;
        aterms[1] = around + bround;
        double aterms3 = _j + _i;
        bvirt = aterms3 - _j;
        avirt = aterms3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        aterms[2] = around + bround;
        aterms[3] = aterms3;
        double bxcy1 = pb[0] * pc[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = bxcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxcy0 = alo * blo - err3;
        double bxay1 = pb[0] * pa[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = bxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxay0 = alo * blo - err3;
        _i = bxcy0 - bxay0;
        bvirt = bxcy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bxay0;
        around = bxcy0 - avirt;
        bterms[0] = around + bround;
        _j = bxcy1 + _i;
        bvirt = _j - bxcy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bxcy1 - avirt;
        _0 = around + bround;
        _i = _0 - bxay1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bxay1;
        around = _0 - avirt;
        bterms[1] = around + bround;
        double bterms3 = _j + _i;
        bvirt = bterms3 - _j;
        avirt = bterms3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bterms[2] = around + bround;
        bterms[3] = bterms3;
        double cxay1 = pc[0] * pa[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = cxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxay0 = alo * blo - err3;
        double cxby1 = pc[0] * pb[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        bhi = c - abig;
        blo = pb[1] - bhi;
        err1 = cxby1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxby0 = alo * blo - err3;
        _i = cxay0 - cxby0;
        bvirt = cxay0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxby0;
        around = cxay0 - avirt;
        cterms[0] = around + bround;
        _j = cxay1 + _i;
        bvirt = _j - cxay1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cxay1 - avirt;
        _0 = around + bround;
        _i = _0 - cxby1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxby1;
        around = _0 - avirt;
        cterms[1] = around + bround;
        double cterms3 = _j + _i;
        bvirt = cterms3 - _j;
        avirt = cterms3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        cterms[2] = around + bround;
        cterms[3] = cterms3;
        int vlength = this.fast_expansion_sum_zeroelim(4, aterms, 4, bterms, v);
        int wlength = this.fast_expansion_sum_zeroelim(vlength, v, 4, cterms, w);
        return w[wlength - 1];
    }

    private double orient2dslow(double[] pa, double[] pb, double[] pc) {
        double[] axby = new double[8];
        double[] bxay = new double[8];
        double[] deter = new double[16];
        double acx = pa[0] - pc[0];
        double bvirt = pa[0] - acx;
        double avirt = acx + bvirt;
        double bround = bvirt - pc[0];
        double around = pa[0] - avirt;
        double acxtail = around + bround;
        double acy = pa[1] - pc[1];
        bvirt = pa[1] - acy;
        avirt = acy + bvirt;
        bround = bvirt - pc[1];
        around = pa[1] - avirt;
        double acytail = around + bround;
        double bcx = pb[0] - pc[0];
        bvirt = pb[0] - bcx;
        avirt = bcx + bvirt;
        bround = bvirt - pc[0];
        around = pb[0] - avirt;
        double bcxtail = around + bround;
        double bcy = pb[1] - pc[1];
        bvirt = pb[1] - bcy;
        avirt = bcy + bvirt;
        bround = bvirt - pc[1];
        around = pb[1] - avirt;
        double bcytail = around + bround;
        double c = this.splitter * acxtail;
        double abig = c - acxtail;
        double a0hi = c - abig;
        double a0lo = acxtail - a0hi;
        c = this.splitter * bcytail;
        abig = c - bcytail;
        double bhi = c - abig;
        double blo = bcytail - bhi;
        double _i = acxtail * bcytail;
        double err1 = _i - a0hi * bhi;
        double err2 = err1 - a0lo * bhi;
        double err3 = err2 - a0hi * blo;
        axby[0] = a0lo * blo - err3;
        c = this.splitter * acx;
        abig = c - acx;
        double a1hi = c - abig;
        double a1lo = acx - a1hi;
        double _j = acx * bcytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        double _0 = a1lo * blo - err3;
        double _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        double _1 = around + bround;
        double _l = _j + _k;
        bvirt = _l - _j;
        double _2 = _k - bvirt;
        c = this.splitter * bcy;
        abig = c - bcy;
        bhi = c - abig;
        blo = bcy - bhi;
        _i = acxtail * bcy;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        double _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = acx * bcy;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        double _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        axby[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        axby[5] = around + bround;
        double axby7 = _m + _k;
        bvirt = axby7 - _m;
        avirt = axby7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        axby[6] = around + bround;
        axby[7] = axby7;
        double negate = -acy;
        double negatetail = -acytail;
        c = this.splitter * bcxtail;
        abig = c - bcxtail;
        a0hi = c - abig;
        a0lo = bcxtail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = bcxtail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        bxay[0] = a0lo * blo - err3;
        c = this.splitter * bcx;
        abig = c - bcx;
        a1hi = c - abig;
        a1lo = bcx - a1hi;
        _j = bcx * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = bcxtail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = bcx * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        bxay[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        bxay[5] = around + bround;
        double bxay7 = _m + _k;
        bvirt = bxay7 - _m;
        avirt = bxay7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        bxay[6] = around + bround;
        bxay[7] = bxay7;
        int deterlen = this.fast_expansion_sum_zeroelim(8, axby, 8, bxay, deter);
        return deter[deterlen - 1];
    }

    private double orient2dadapt(double[] pa, double[] pb, double[] pc, double detsum) {
        double errbound;
        double[] B = new double[4];
        double[] C1 = new double[8];
        double[] C2 = new double[12];
        double[] D = new double[16];
        double[] u = new double[4];
        double acx = pa[0] - pc[0];
        double bcx = pb[0] - pc[0];
        double acy = pa[1] - pc[1];
        double bcy = pb[1] - pc[1];
        double detleft = acx * bcy;
        double c = this.splitter * acx;
        double abig = c - acx;
        double ahi = c - abig;
        double alo = acx - ahi;
        c = this.splitter * bcy;
        abig = c - bcy;
        double bhi = c - abig;
        double blo = bcy - bhi;
        double err1 = detleft - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double detlefttail = alo * blo - err3;
        double detright = acy * bcx;
        c = this.splitter * acy;
        abig = c - acy;
        ahi = c - abig;
        alo = acy - ahi;
        c = this.splitter * bcx;
        abig = c - bcx;
        bhi = c - abig;
        blo = bcx - bhi;
        err1 = detright - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double detrighttail = alo * blo - err3;
        double _i = detlefttail - detrighttail;
        double bvirt = detlefttail - _i;
        double avirt = _i + bvirt;
        double bround = bvirt - detrighttail;
        double around = detlefttail - avirt;
        B[0] = around + bround;
        double _j = detleft + _i;
        bvirt = _j - detleft;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = detleft - avirt;
        double _0 = around + bround;
        _i = _0 - detright;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - detright;
        around = _0 - avirt;
        B[1] = around + bround;
        double B3 = _j + _i;
        bvirt = B3 - _j;
        avirt = B3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        B[2] = around + bround;
        B[3] = B3;
        double det = this.estimate(4, B);
        if (det >= (errbound = this.ccwerrboundB * detsum) || -det >= errbound) {
            return det;
        }
        bvirt = pa[0] - acx;
        avirt = acx + bvirt;
        bround = bvirt - pc[0];
        around = pa[0] - avirt;
        double acxtail = around + bround;
        bvirt = pb[0] - bcx;
        avirt = bcx + bvirt;
        bround = bvirt - pc[0];
        around = pb[0] - avirt;
        double bcxtail = around + bround;
        bvirt = pa[1] - acy;
        avirt = acy + bvirt;
        bround = bvirt - pc[1];
        around = pa[1] - avirt;
        double acytail = around + bround;
        bvirt = pb[1] - bcy;
        avirt = bcy + bvirt;
        bround = bvirt - pc[1];
        around = pb[1] - avirt;
        double bcytail = around + bround;
        if (acxtail == 0.0 && acytail == 0.0 && bcxtail == 0.0 && bcytail == 0.0) {
            return det;
        }
        errbound = this.ccwerrboundC * detsum + this.resulterrbound * (det >= 0.0 ? det : -det);
        if ((det += acx * bcytail + bcy * acxtail - (acy * bcxtail + bcx * acytail)) >= errbound || -det >= errbound) {
            return det;
        }
        double s1 = acxtail * bcy;
        c = this.splitter * acxtail;
        abig = c - acxtail;
        ahi = c - abig;
        alo = acxtail - ahi;
        c = this.splitter * bcy;
        abig = c - bcy;
        bhi = c - abig;
        blo = bcy - bhi;
        err1 = s1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double s0 = alo * blo - err3;
        double t1 = acytail * bcx;
        c = this.splitter * acytail;
        abig = c - acytail;
        ahi = c - abig;
        alo = acytail - ahi;
        c = this.splitter * bcx;
        abig = c - bcx;
        bhi = c - abig;
        blo = bcx - bhi;
        err1 = t1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double t0 = alo * blo - err3;
        _i = s0 - t0;
        bvirt = s0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - t0;
        around = s0 - avirt;
        u[0] = around + bround;
        _j = s1 + _i;
        bvirt = _j - s1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = s1 - avirt;
        _0 = around + bround;
        _i = _0 - t1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - t1;
        around = _0 - avirt;
        u[1] = around + bround;
        double u3 = _j + _i;
        bvirt = u3 - _j;
        avirt = u3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        u[2] = around + bround;
        u[3] = u3;
        int C1length = this.fast_expansion_sum_zeroelim(4, B, 4, u, C1);
        s1 = acx * bcytail;
        c = this.splitter * acx;
        abig = c - acx;
        ahi = c - abig;
        alo = acx - ahi;
        c = this.splitter * bcytail;
        abig = c - bcytail;
        bhi = c - abig;
        blo = bcytail - bhi;
        err1 = s1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        s0 = alo * blo - err3;
        t1 = acy * bcxtail;
        c = this.splitter * acy;
        abig = c - acy;
        ahi = c - abig;
        alo = acy - ahi;
        c = this.splitter * bcxtail;
        abig = c - bcxtail;
        bhi = c - abig;
        blo = bcxtail - bhi;
        err1 = t1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        t0 = alo * blo - err3;
        _i = s0 - t0;
        bvirt = s0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - t0;
        around = s0 - avirt;
        u[0] = around + bround;
        _j = s1 + _i;
        bvirt = _j - s1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = s1 - avirt;
        _0 = around + bround;
        _i = _0 - t1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - t1;
        around = _0 - avirt;
        u[1] = around + bround;
        u3 = _j + _i;
        bvirt = u3 - _j;
        avirt = u3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        u[2] = around + bround;
        u[3] = u3;
        int C2length = this.fast_expansion_sum_zeroelim(C1length, C1, 4, u, C2);
        s1 = acxtail * bcytail;
        c = this.splitter * acxtail;
        abig = c - acxtail;
        ahi = c - abig;
        alo = acxtail - ahi;
        c = this.splitter * bcytail;
        abig = c - bcytail;
        bhi = c - abig;
        blo = bcytail - bhi;
        err1 = s1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        s0 = alo * blo - err3;
        t1 = acytail * bcxtail;
        c = this.splitter * acytail;
        abig = c - acytail;
        ahi = c - abig;
        alo = acytail - ahi;
        c = this.splitter * bcxtail;
        abig = c - bcxtail;
        bhi = c - abig;
        blo = bcxtail - bhi;
        err1 = t1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        t0 = alo * blo - err3;
        _i = s0 - t0;
        bvirt = s0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - t0;
        around = s0 - avirt;
        u[0] = around + bround;
        _j = s1 + _i;
        bvirt = _j - s1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = s1 - avirt;
        _0 = around + bround;
        _i = _0 - t1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - t1;
        around = _0 - avirt;
        u[1] = around + bround;
        u3 = _j + _i;
        bvirt = u3 - _j;
        avirt = u3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        u[2] = around + bround;
        u[3] = u3;
        int Dlength = this.fast_expansion_sum_zeroelim(C2length, C2, 4, u, D);
        return D[Dlength - 1];
    }

    private double orient2d(double[] pa, double[] pb, double[] pc) {
        double detsum;
        double detleft = (pa[0] - pc[0]) * (pb[1] - pc[1]);
        double detright = (pa[1] - pc[1]) * (pb[0] - pc[0]);
        double det = detleft - detright;
        if (detleft > 0.0) {
            if (detright <= 0.0) {
                return det;
            }
            detsum = detleft + detright;
        } else if (detleft < 0.0) {
            if (detright >= 0.0) {
                return det;
            }
            detsum = -detleft - detright;
        } else {
            return det;
        }
        double errbound = this.ccwerrboundA * detsum;
        if (det >= errbound || -det >= errbound) {
            return det;
        }
        return this.orient2dadapt(pa, pb, pc, detsum);
    }

    double orient3dexact(double[] pa, double[] pb, double[] pc, double[] pd) {
        double[] ab = new double[4];
        double[] bc = new double[4];
        double[] cd = new double[4];
        double[] da = new double[4];
        double[] ac = new double[4];
        double[] bd = new double[4];
        double[] temp8 = new double[8];
        double[] abc = new double[12];
        double[] bcd = new double[12];
        double[] cda = new double[12];
        double[] dab = new double[12];
        double[] adet = new double[24];
        double[] bdet = new double[24];
        double[] cdet = new double[24];
        double[] ddet = new double[24];
        double[] abdet = new double[48];
        double[] cddet = new double[48];
        double[] deter = new double[96];
        double axby1 = pa[0] * pb[1];
        double c = this.splitter * pa[0];
        double abig = c - pa[0];
        double ahi = c - abig;
        double alo = pa[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        double bhi = c - abig;
        double blo = pb[1] - bhi;
        double err1 = axby1 - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double axby0 = alo * blo - err3;
        double bxay1 = pb[0] * pa[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = bxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxay0 = alo * blo - err3;
        double _i = axby0 - bxay0;
        double bvirt = axby0 - _i;
        double avirt = _i + bvirt;
        double bround = bvirt - bxay0;
        double around = axby0 - avirt;
        ab[0] = around + bround;
        double _j = axby1 + _i;
        bvirt = _j - axby1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = axby1 - avirt;
        double _0 = around + bround;
        _i = _0 - bxay1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bxay1;
        around = _0 - avirt;
        ab[1] = around + bround;
        ab[3] = _j + _i;
        bvirt = ab[3] - _j;
        avirt = ab[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ab[2] = around + bround;
        double bxcy1 = pb[0] * pc[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = bxcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxcy0 = alo * blo - err3;
        double cxby1 = pc[0] * pb[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        bhi = c - abig;
        blo = pb[1] - bhi;
        err1 = cxby1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxby0 = alo * blo - err3;
        _i = bxcy0 - cxby0;
        bvirt = bxcy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxby0;
        around = bxcy0 - avirt;
        bc[0] = around + bround;
        _j = bxcy1 + _i;
        bvirt = _j - bxcy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bxcy1 - avirt;
        _0 = around + bround;
        _i = _0 - cxby1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxby1;
        around = _0 - avirt;
        bc[1] = around + bround;
        bc[3] = _j + _i;
        bvirt = bc[3] - _j;
        avirt = bc[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bc[2] = around + bround;
        double cxdy1 = pc[0] * pd[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = cxdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxdy0 = alo * blo - err3;
        double dxcy1 = pd[0] * pc[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = dxcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxcy0 = alo * blo - err3;
        _i = cxdy0 - dxcy0;
        bvirt = cxdy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxcy0;
        around = cxdy0 - avirt;
        cd[0] = around + bround;
        _j = cxdy1 + _i;
        bvirt = _j - cxdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cxdy1 - avirt;
        _0 = around + bround;
        _i = _0 - dxcy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxcy1;
        around = _0 - avirt;
        cd[1] = around + bround;
        cd[3] = _j + _i;
        bvirt = cd[3] - _j;
        avirt = cd[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        cd[2] = around + bround;
        double dxay1 = pd[0] * pa[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = dxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxay0 = alo * blo - err3;
        double axdy1 = pa[0] * pd[1];
        c = this.splitter * pa[0];
        abig = c - pa[0];
        ahi = c - abig;
        alo = pa[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = axdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double axdy0 = alo * blo - err3;
        _i = dxay0 - axdy0;
        bvirt = dxay0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axdy0;
        around = dxay0 - avirt;
        da[0] = around + bround;
        _j = dxay1 + _i;
        bvirt = _j - dxay1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = dxay1 - avirt;
        _0 = around + bround;
        _i = _0 - axdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axdy1;
        around = _0 - avirt;
        da[1] = around + bround;
        da[3] = _j + _i;
        bvirt = da[3] - _j;
        avirt = da[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        da[2] = around + bround;
        double axcy1 = pa[0] * pc[1];
        c = this.splitter * pa[0];
        abig = c - pa[0];
        ahi = c - abig;
        alo = pa[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = axcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double axcy0 = alo * blo - err3;
        double cxay1 = pc[0] * pa[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = cxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxay0 = alo * blo - err3;
        _i = axcy0 - cxay0;
        bvirt = axcy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxay0;
        around = axcy0 - avirt;
        ac[0] = around + bround;
        _j = axcy1 + _i;
        bvirt = _j - axcy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = axcy1 - avirt;
        _0 = around + bround;
        _i = _0 - cxay1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxay1;
        around = _0 - avirt;
        ac[1] = around + bround;
        ac[3] = _j + _i;
        bvirt = ac[3] - _j;
        avirt = ac[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ac[2] = around + bround;
        double bxdy1 = pb[0] * pd[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = bxdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxdy0 = alo * blo - err3;
        double dxby1 = pd[0] * pb[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        bhi = c - abig;
        blo = pb[1] - bhi;
        err1 = dxby1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxby0 = alo * blo - err3;
        _i = bxdy0 - dxby0;
        bvirt = bxdy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxby0;
        around = bxdy0 - avirt;
        bd[0] = around + bround;
        _j = bxdy1 + _i;
        bvirt = _j - bxdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bxdy1 - avirt;
        _0 = around + bround;
        _i = _0 - dxby1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxby1;
        around = _0 - avirt;
        bd[1] = around + bround;
        bd[3] = _j + _i;
        bvirt = bd[3] - _j;
        avirt = bd[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bd[2] = around + bround;
        int templen = this.fast_expansion_sum_zeroelim(4, cd, 4, da, temp8);
        int cdalen = this.fast_expansion_sum_zeroelim(templen, temp8, 4, ac, cda);
        templen = this.fast_expansion_sum_zeroelim(4, da, 4, ab, temp8);
        int dablen = this.fast_expansion_sum_zeroelim(templen, temp8, 4, bd, dab);
        for (int i = 0; i < 4; ++i) {
            bd[i] = -bd[i];
            ac[i] = -ac[i];
        }
        templen = this.fast_expansion_sum_zeroelim(4, ab, 4, bc, temp8);
        int abclen = this.fast_expansion_sum_zeroelim(templen, temp8, 4, ac, abc);
        templen = this.fast_expansion_sum_zeroelim(4, bc, 4, cd, temp8);
        int bcdlen = this.fast_expansion_sum_zeroelim(templen, temp8, 4, bd, bcd);
        int alen = this.scale_expansion_zeroelim(bcdlen, bcd, pa[2], adet);
        int blen = this.scale_expansion_zeroelim(cdalen, cda, -pb[2], bdet);
        int clen = this.scale_expansion_zeroelim(dablen, dab, pc[2], cdet);
        int dlen = this.scale_expansion_zeroelim(abclen, abc, -pd[2], ddet);
        int ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        int cdlen = this.fast_expansion_sum_zeroelim(clen, cdet, dlen, ddet, cddet);
        int deterlen = this.fast_expansion_sum_zeroelim(ablen, abdet, cdlen, cddet, deter);
        return deter[deterlen - 1];
    }

    double orient3dslow(double[] pa, double[] pb, double[] pc, double[] pd) {
        double[] axby = new double[8];
        double[] bxcy = new double[8];
        double[] axcy = new double[8];
        double[] bxay = new double[8];
        double[] cxby = new double[8];
        double[] cxay = new double[8];
        double[] temp16 = new double[16];
        double[] temp32 = new double[32];
        double[] temp32t = new double[32];
        double[] adet = new double[64];
        double[] bdet = new double[64];
        double[] cdet = new double[64];
        double[] abdet = new double[128];
        double[] deter = new double[192];
        double adx = pa[0] - pd[0];
        double bvirt = pa[0] - adx;
        double avirt = adx + bvirt;
        double bround = bvirt - pd[0];
        double around = pa[0] - avirt;
        double adxtail = around + bround;
        double ady = pa[1] - pd[1];
        bvirt = pa[1] - ady;
        avirt = ady + bvirt;
        bround = bvirt - pd[1];
        around = pa[1] - avirt;
        double adytail = around + bround;
        double adz = pa[2] - pd[2];
        bvirt = pa[2] - adz;
        avirt = adz + bvirt;
        bround = bvirt - pd[2];
        around = pa[2] - avirt;
        double adztail = around + bround;
        double bdx = pb[0] - pd[0];
        bvirt = pb[0] - bdx;
        avirt = bdx + bvirt;
        bround = bvirt - pd[0];
        around = pb[0] - avirt;
        double bdxtail = around + bround;
        double bdy = pb[1] - pd[1];
        bvirt = pb[1] - bdy;
        avirt = bdy + bvirt;
        bround = bvirt - pd[1];
        around = pb[1] - avirt;
        double bdytail = around + bround;
        double bdz = pb[2] - pd[2];
        bvirt = pb[2] - bdz;
        avirt = bdz + bvirt;
        bround = bvirt - pd[2];
        around = pb[2] - avirt;
        double bdztail = around + bround;
        double cdx = pc[0] - pd[0];
        bvirt = pc[0] - cdx;
        avirt = cdx + bvirt;
        bround = bvirt - pd[0];
        around = pc[0] - avirt;
        double cdxtail = around + bround;
        double cdy = pc[1] - pd[1];
        bvirt = pc[1] - cdy;
        avirt = cdy + bvirt;
        bround = bvirt - pd[1];
        around = pc[1] - avirt;
        double cdytail = around + bround;
        double cdz = pc[2] - pd[2];
        bvirt = pc[2] - cdz;
        avirt = cdz + bvirt;
        bround = bvirt - pd[2];
        around = pc[2] - avirt;
        double cdztail = around + bround;
        double c = this.splitter * adxtail;
        double abig = c - adxtail;
        double a0hi = c - abig;
        double a0lo = adxtail - a0hi;
        c = this.splitter * bdytail;
        abig = c - bdytail;
        double bhi = c - abig;
        double blo = bdytail - bhi;
        double _i = adxtail * bdytail;
        double err1 = _i - a0hi * bhi;
        double err2 = err1 - a0lo * bhi;
        double err3 = err2 - a0hi * blo;
        axby[0] = a0lo * blo - err3;
        c = this.splitter * adx;
        abig = c - adx;
        double a1hi = c - abig;
        double a1lo = adx - a1hi;
        double _j = adx * bdytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        double _0 = a1lo * blo - err3;
        double _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        double _1 = around + bround;
        double _l = _j + _k;
        bvirt = _l - _j;
        double _2 = _k - bvirt;
        c = this.splitter * bdy;
        abig = c - bdy;
        bhi = c - abig;
        blo = bdy - bhi;
        _i = adxtail * bdy;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        double _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = adx * bdy;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        double _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        axby[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        axby[5] = around + bround;
        double axby7 = _m + _k;
        bvirt = axby7 - _m;
        avirt = axby7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        axby[6] = around + bround;
        axby[7] = axby7;
        double negate = -ady;
        double negatetail = -adytail;
        c = this.splitter * bdxtail;
        abig = c - bdxtail;
        a0hi = c - abig;
        a0lo = bdxtail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = bdxtail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        bxay[0] = a0lo * blo - err3;
        c = this.splitter * bdx;
        abig = c - bdx;
        a1hi = c - abig;
        a1lo = bdx - a1hi;
        _j = bdx * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = bdxtail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = bdx * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        bxay[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        bxay[5] = around + bround;
        double bxay7 = _m + _k;
        bvirt = bxay7 - _m;
        avirt = bxay7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        bxay[6] = around + bround;
        bxay[7] = bxay7;
        c = this.splitter * bdxtail;
        abig = c - bdxtail;
        a0hi = c - abig;
        a0lo = bdxtail - a0hi;
        c = this.splitter * cdytail;
        abig = c - cdytail;
        bhi = c - abig;
        blo = cdytail - bhi;
        _i = bdxtail * cdytail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        bxcy[0] = a0lo * blo - err3;
        c = this.splitter * bdx;
        abig = c - bdx;
        a1hi = c - abig;
        a1lo = bdx - a1hi;
        _j = bdx * cdytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * cdy;
        abig = c - cdy;
        bhi = c - abig;
        blo = cdy - bhi;
        _i = bdxtail * cdy;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxcy[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = bdx * cdy;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxcy[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxcy[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        bxcy[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        bxcy[5] = around + bround;
        double bxcy7 = _m + _k;
        bvirt = bxcy7 - _m;
        avirt = bxcy7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        bxcy[6] = around + bround;
        bxcy[7] = bxcy7;
        negate = -bdy;
        negatetail = -bdytail;
        c = this.splitter * cdxtail;
        abig = c - cdxtail;
        a0hi = c - abig;
        a0lo = cdxtail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = cdxtail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        cxby[0] = a0lo * blo - err3;
        c = this.splitter * cdx;
        abig = c - cdx;
        a1hi = c - abig;
        a1lo = cdx - a1hi;
        _j = cdx * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = cdxtail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxby[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = cdx * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxby[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxby[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        cxby[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        cxby[5] = around + bround;
        double cxby7 = _m + _k;
        bvirt = cxby7 - _m;
        avirt = cxby7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        cxby[6] = around + bround;
        cxby[7] = cxby7;
        c = this.splitter * cdxtail;
        abig = c - cdxtail;
        a0hi = c - abig;
        a0lo = cdxtail - a0hi;
        c = this.splitter * adytail;
        abig = c - adytail;
        bhi = c - abig;
        blo = adytail - bhi;
        _i = cdxtail * adytail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        cxay[0] = a0lo * blo - err3;
        c = this.splitter * cdx;
        abig = c - cdx;
        a1hi = c - abig;
        a1lo = cdx - a1hi;
        _j = cdx * adytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * ady;
        abig = c - ady;
        bhi = c - abig;
        blo = ady - bhi;
        _i = cdxtail * ady;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxay[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = cdx * ady;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxay[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxay[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        cxay[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        cxay[5] = around + bround;
        double cxay7 = _m + _k;
        bvirt = cxay7 - _m;
        avirt = cxay7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        cxay[6] = around + bround;
        cxay[7] = cxay7;
        negate = -cdy;
        negatetail = -cdytail;
        c = this.splitter * adxtail;
        abig = c - adxtail;
        a0hi = c - abig;
        a0lo = adxtail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = adxtail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        axcy[0] = a0lo * blo - err3;
        c = this.splitter * adx;
        abig = c - adx;
        a1hi = c - abig;
        a1lo = adx - a1hi;
        _j = adx * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = adxtail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axcy[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = adx * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axcy[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axcy[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        axcy[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        axcy[5] = around + bround;
        double axcy7 = _m + _k;
        bvirt = axcy7 - _m;
        avirt = axcy7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        axcy[6] = around + bround;
        axcy[7] = axcy7;
        int temp16len = this.fast_expansion_sum_zeroelim(8, bxcy, 8, cxby, temp16);
        int temp32len = this.scale_expansion_zeroelim(temp16len, temp16, adz, temp32);
        int temp32tlen = this.scale_expansion_zeroelim(temp16len, temp16, adztail, temp32t);
        int alen = this.fast_expansion_sum_zeroelim(temp32len, temp32, temp32tlen, temp32t, adet);
        temp16len = this.fast_expansion_sum_zeroelim(8, cxay, 8, axcy, temp16);
        temp32len = this.scale_expansion_zeroelim(temp16len, temp16, bdz, temp32);
        temp32tlen = this.scale_expansion_zeroelim(temp16len, temp16, bdztail, temp32t);
        int blen = this.fast_expansion_sum_zeroelim(temp32len, temp32, temp32tlen, temp32t, bdet);
        temp16len = this.fast_expansion_sum_zeroelim(8, axby, 8, bxay, temp16);
        temp32len = this.scale_expansion_zeroelim(temp16len, temp16, cdz, temp32);
        temp32tlen = this.scale_expansion_zeroelim(temp16len, temp16, cdztail, temp32t);
        int clen = this.fast_expansion_sum_zeroelim(temp32len, temp32, temp32tlen, temp32t, cdet);
        int ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        int deterlen = this.fast_expansion_sum_zeroelim(ablen, abdet, clen, cdet, deter);
        return deter[deterlen - 1];
    }

    double orient3dadapt(double[] pa, double[] pb, double[] pc, double[] pd, double permanent) {
        double u3;
        double _k;
        int vlength;
        int ct_blen;
        int ct_alen;
        int bt_alen;
        int bt_clen;
        double negate;
        int at_clen;
        int at_blen;
        double errbound;
        double[] bc = new double[4];
        double[] ca = new double[4];
        double[] ab = new double[4];
        double[] adet = new double[8];
        double[] bdet = new double[8];
        double[] cdet = new double[8];
        double[] abdet = new double[16];
        double[] fin1 = new double[192];
        double[] fin2 = new double[192];
        double[] at_b = new double[4];
        double[] at_c = new double[4];
        double[] bt_c = new double[4];
        double[] bt_a = new double[4];
        double[] ct_a = new double[4];
        double[] ct_b = new double[4];
        double[] bct = new double[8];
        double[] cat = new double[8];
        double[] abt = new double[8];
        double[] u = new double[4];
        double[] v = new double[12];
        double[] w = new double[16];
        double adx = pa[0] - pd[0];
        double bdx = pb[0] - pd[0];
        double cdx = pc[0] - pd[0];
        double ady = pa[1] - pd[1];
        double bdy = pb[1] - pd[1];
        double cdy = pc[1] - pd[1];
        double adz = pa[2] - pd[2];
        double bdz = pb[2] - pd[2];
        double cdz = pc[2] - pd[2];
        double bdxcdy1 = bdx * cdy;
        double c = this.splitter * bdx;
        double abig = c - bdx;
        double ahi = c - abig;
        double alo = bdx - ahi;
        c = this.splitter * cdy;
        abig = c - cdy;
        double bhi = c - abig;
        double blo = cdy - bhi;
        double err1 = bdxcdy1 - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double bdxcdy0 = alo * blo - err3;
        double cdxbdy1 = cdx * bdy;
        c = this.splitter * cdx;
        abig = c - cdx;
        ahi = c - abig;
        alo = cdx - ahi;
        c = this.splitter * bdy;
        abig = c - bdy;
        bhi = c - abig;
        blo = bdy - bhi;
        err1 = cdxbdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cdxbdy0 = alo * blo - err3;
        double _i = bdxcdy0 - cdxbdy0;
        double bvirt = bdxcdy0 - _i;
        double avirt = _i + bvirt;
        double bround = bvirt - cdxbdy0;
        double around = bdxcdy0 - avirt;
        bc[0] = around + bround;
        double _j = bdxcdy1 + _i;
        bvirt = _j - bdxcdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bdxcdy1 - avirt;
        double _0 = around + bround;
        _i = _0 - cdxbdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cdxbdy1;
        around = _0 - avirt;
        bc[1] = around + bround;
        double bc3 = _j + _i;
        bvirt = bc3 - _j;
        avirt = bc3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bc[2] = around + bround;
        bc[3] = bc3;
        int alen = this.scale_expansion_zeroelim(4, bc, adz, adet);
        double cdxady1 = cdx * ady;
        c = this.splitter * cdx;
        abig = c - cdx;
        ahi = c - abig;
        alo = cdx - ahi;
        c = this.splitter * ady;
        abig = c - ady;
        bhi = c - abig;
        blo = ady - bhi;
        err1 = cdxady1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cdxady0 = alo * blo - err3;
        double adxcdy1 = adx * cdy;
        c = this.splitter * adx;
        abig = c - adx;
        ahi = c - abig;
        alo = adx - ahi;
        c = this.splitter * cdy;
        abig = c - cdy;
        bhi = c - abig;
        blo = cdy - bhi;
        err1 = adxcdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double adxcdy0 = alo * blo - err3;
        _i = cdxady0 - adxcdy0;
        bvirt = cdxady0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - adxcdy0;
        around = cdxady0 - avirt;
        ca[0] = around + bround;
        _j = cdxady1 + _i;
        bvirt = _j - cdxady1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cdxady1 - avirt;
        _0 = around + bround;
        _i = _0 - adxcdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - adxcdy1;
        around = _0 - avirt;
        ca[1] = around + bround;
        double ca3 = _j + _i;
        bvirt = ca3 - _j;
        avirt = ca3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ca[2] = around + bround;
        ca[3] = ca3;
        int blen = this.scale_expansion_zeroelim(4, ca, bdz, bdet);
        double adxbdy1 = adx * bdy;
        c = this.splitter * adx;
        abig = c - adx;
        ahi = c - abig;
        alo = adx - ahi;
        c = this.splitter * bdy;
        abig = c - bdy;
        bhi = c - abig;
        blo = bdy - bhi;
        err1 = adxbdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double adxbdy0 = alo * blo - err3;
        double bdxady1 = bdx * ady;
        c = this.splitter * bdx;
        abig = c - bdx;
        ahi = c - abig;
        alo = bdx - ahi;
        c = this.splitter * ady;
        abig = c - ady;
        bhi = c - abig;
        blo = ady - bhi;
        err1 = bdxady1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bdxady0 = alo * blo - err3;
        _i = adxbdy0 - bdxady0;
        bvirt = adxbdy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bdxady0;
        around = adxbdy0 - avirt;
        ab[0] = around + bround;
        _j = adxbdy1 + _i;
        bvirt = _j - adxbdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = adxbdy1 - avirt;
        _0 = around + bround;
        _i = _0 - bdxady1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bdxady1;
        around = _0 - avirt;
        ab[1] = around + bround;
        double ab3 = _j + _i;
        bvirt = ab3 - _j;
        avirt = ab3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ab[2] = around + bround;
        ab[3] = ab3;
        int clen = this.scale_expansion_zeroelim(4, ab, cdz, cdet);
        int ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        int finlength = this.fast_expansion_sum_zeroelim(ablen, abdet, clen, cdet, fin1);
        double det = this.estimate(finlength, fin1);
        if (det >= (errbound = this.o3derrboundB * permanent) || -det >= errbound) {
            return det;
        }
        bvirt = pa[0] - adx;
        avirt = adx + bvirt;
        bround = bvirt - pd[0];
        around = pa[0] - avirt;
        double adxtail = around + bround;
        bvirt = pb[0] - bdx;
        avirt = bdx + bvirt;
        bround = bvirt - pd[0];
        around = pb[0] - avirt;
        double bdxtail = around + bround;
        bvirt = pc[0] - cdx;
        avirt = cdx + bvirt;
        bround = bvirt - pd[0];
        around = pc[0] - avirt;
        double cdxtail = around + bround;
        bvirt = pa[1] - ady;
        avirt = ady + bvirt;
        bround = bvirt - pd[1];
        around = pa[1] - avirt;
        double adytail = around + bround;
        bvirt = pb[1] - bdy;
        avirt = bdy + bvirt;
        bround = bvirt - pd[1];
        around = pb[1] - avirt;
        double bdytail = around + bround;
        bvirt = pc[1] - cdy;
        avirt = cdy + bvirt;
        bround = bvirt - pd[1];
        around = pc[1] - avirt;
        double cdytail = around + bround;
        bvirt = pa[2] - adz;
        avirt = adz + bvirt;
        bround = bvirt - pd[2];
        around = pa[2] - avirt;
        double adztail = around + bround;
        bvirt = pb[2] - bdz;
        avirt = bdz + bvirt;
        bround = bvirt - pd[2];
        around = pb[2] - avirt;
        double bdztail = around + bround;
        bvirt = pc[2] - cdz;
        avirt = cdz + bvirt;
        bround = bvirt - pd[2];
        around = pc[2] - avirt;
        double cdztail = around + bround;
        if (adxtail == 0.0 && bdxtail == 0.0 && cdxtail == 0.0 && adytail == 0.0 && bdytail == 0.0 && cdytail == 0.0 && adztail == 0.0 && bdztail == 0.0 && cdztail == 0.0) {
            return det;
        }
        errbound = this.o3derrboundC * permanent + this.resulterrbound * (det >= 0.0 ? det : -det);
        if ((det += adz * (bdx * cdytail + cdy * bdxtail - (bdy * cdxtail + cdx * bdytail)) + adztail * (bdx * cdy - bdy * cdx) + (bdz * (cdx * adytail + ady * cdxtail - (cdy * adxtail + adx * cdytail)) + bdztail * (cdx * ady - cdy * adx)) + (cdz * (adx * bdytail + bdy * adxtail - (ady * bdxtail + bdx * adytail)) + cdztail * (adx * bdy - ady * bdx))) >= errbound || -det >= errbound) {
            return det;
        }
        double[] finnow = fin1;
        double[] finother = fin2;
        if (adxtail == 0.0) {
            if (adytail == 0.0) {
                at_b[0] = 0.0;
                at_blen = 1;
                at_c[0] = 0.0;
                at_clen = 1;
            } else {
                negate = -adytail;
                double at_blarge = negate * bdx;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * bdx;
                abig = c - bdx;
                bhi = c - abig;
                blo = bdx - bhi;
                err1 = at_blarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                at_b[0] = alo * blo - err3;
                at_b[1] = at_blarge;
                at_blen = 2;
                double at_clarge = adytail * cdx;
                c = this.splitter * adytail;
                abig = c - adytail;
                ahi = c - abig;
                alo = adytail - ahi;
                c = this.splitter * cdx;
                abig = c - cdx;
                bhi = c - abig;
                blo = cdx - bhi;
                err1 = at_clarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                at_c[0] = alo * blo - err3;
                at_c[1] = at_clarge;
                at_clen = 2;
            }
        } else if (adytail == 0.0) {
            double at_blarge = adxtail * bdy;
            c = this.splitter * adxtail;
            abig = c - adxtail;
            ahi = c - abig;
            alo = adxtail - ahi;
            c = this.splitter * bdy;
            abig = c - bdy;
            bhi = c - abig;
            blo = bdy - bhi;
            err1 = at_blarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            at_b[0] = alo * blo - err3;
            at_b[1] = at_blarge;
            at_blen = 2;
            negate = -adxtail;
            double at_clarge = negate * cdy;
            c = this.splitter * negate;
            abig = c - negate;
            ahi = c - abig;
            alo = negate - ahi;
            c = this.splitter * cdy;
            abig = c - cdy;
            bhi = c - abig;
            blo = cdy - bhi;
            err1 = at_clarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            at_c[0] = alo * blo - err3;
            at_c[1] = at_clarge;
            at_clen = 2;
        } else {
            double adxt_bdy1 = adxtail * bdy;
            c = this.splitter * adxtail;
            abig = c - adxtail;
            ahi = c - abig;
            alo = adxtail - ahi;
            c = this.splitter * bdy;
            abig = c - bdy;
            bhi = c - abig;
            blo = bdy - bhi;
            err1 = adxt_bdy1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double adxt_bdy0 = alo * blo - err3;
            double adyt_bdx1 = adytail * bdx;
            c = this.splitter * adytail;
            abig = c - adytail;
            ahi = c - abig;
            alo = adytail - ahi;
            c = this.splitter * bdx;
            abig = c - bdx;
            bhi = c - abig;
            blo = bdx - bhi;
            err1 = adyt_bdx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double adyt_bdx0 = alo * blo - err3;
            _i = adxt_bdy0 - adyt_bdx0;
            bvirt = adxt_bdy0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - adyt_bdx0;
            around = adxt_bdy0 - avirt;
            at_b[0] = around + bround;
            _j = adxt_bdy1 + _i;
            bvirt = _j - adxt_bdy1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = adxt_bdy1 - avirt;
            _0 = around + bround;
            _i = _0 - adyt_bdx1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - adyt_bdx1;
            around = _0 - avirt;
            at_b[1] = around + bround;
            double at_blarge = _j + _i;
            bvirt = at_blarge - _j;
            avirt = at_blarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            at_b[2] = around + bround;
            at_b[3] = at_blarge;
            at_blen = 4;
            double adyt_cdx1 = adytail * cdx;
            c = this.splitter * adytail;
            abig = c - adytail;
            ahi = c - abig;
            alo = adytail - ahi;
            c = this.splitter * cdx;
            abig = c - cdx;
            bhi = c - abig;
            blo = cdx - bhi;
            err1 = adyt_cdx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double adyt_cdx0 = alo * blo - err3;
            double adxt_cdy1 = adxtail * cdy;
            c = this.splitter * adxtail;
            abig = c - adxtail;
            ahi = c - abig;
            alo = adxtail - ahi;
            c = this.splitter * cdy;
            abig = c - cdy;
            bhi = c - abig;
            blo = cdy - bhi;
            err1 = adxt_cdy1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double adxt_cdy0 = alo * blo - err3;
            _i = adyt_cdx0 - adxt_cdy0;
            bvirt = adyt_cdx0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - adxt_cdy0;
            around = adyt_cdx0 - avirt;
            at_c[0] = around + bround;
            _j = adyt_cdx1 + _i;
            bvirt = _j - adyt_cdx1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = adyt_cdx1 - avirt;
            _0 = around + bround;
            _i = _0 - adxt_cdy1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - adxt_cdy1;
            around = _0 - avirt;
            at_c[1] = around + bround;
            double at_clarge = _j + _i;
            bvirt = at_clarge - _j;
            avirt = at_clarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            at_c[2] = around + bround;
            at_c[3] = at_clarge;
            at_clen = 4;
        }
        if (bdxtail == 0.0) {
            if (bdytail == 0.0) {
                bt_c[0] = 0.0;
                bt_clen = 1;
                bt_a[0] = 0.0;
                bt_alen = 1;
            } else {
                negate = -bdytail;
                double bt_clarge = negate * cdx;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * cdx;
                abig = c - cdx;
                bhi = c - abig;
                blo = cdx - bhi;
                err1 = bt_clarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                bt_c[0] = alo * blo - err3;
                bt_c[1] = bt_clarge;
                bt_clen = 2;
                double bt_alarge = bdytail * adx;
                c = this.splitter * bdytail;
                abig = c - bdytail;
                ahi = c - abig;
                alo = bdytail - ahi;
                c = this.splitter * adx;
                abig = c - adx;
                bhi = c - abig;
                blo = adx - bhi;
                err1 = bt_alarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                bt_a[0] = alo * blo - err3;
                bt_a[1] = bt_alarge;
                bt_alen = 2;
            }
        } else if (bdytail == 0.0) {
            double bt_clarge = bdxtail * cdy;
            c = this.splitter * bdxtail;
            abig = c - bdxtail;
            ahi = c - abig;
            alo = bdxtail - ahi;
            c = this.splitter * cdy;
            abig = c - cdy;
            bhi = c - abig;
            blo = cdy - bhi;
            err1 = bt_clarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            bt_c[0] = alo * blo - err3;
            bt_c[1] = bt_clarge;
            bt_clen = 2;
            negate = -bdxtail;
            double bt_alarge = negate * ady;
            c = this.splitter * negate;
            abig = c - negate;
            ahi = c - abig;
            alo = negate - ahi;
            c = this.splitter * ady;
            abig = c - ady;
            bhi = c - abig;
            blo = ady - bhi;
            err1 = bt_alarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            bt_a[0] = alo * blo - err3;
            bt_a[1] = bt_alarge;
            bt_alen = 2;
        } else {
            double bdxt_cdy1 = bdxtail * cdy;
            c = this.splitter * bdxtail;
            abig = c - bdxtail;
            ahi = c - abig;
            alo = bdxtail - ahi;
            c = this.splitter * cdy;
            abig = c - cdy;
            bhi = c - abig;
            blo = cdy - bhi;
            err1 = bdxt_cdy1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double bdxt_cdy0 = alo * blo - err3;
            double bdyt_cdx1 = bdytail * cdx;
            c = this.splitter * bdytail;
            abig = c - bdytail;
            ahi = c - abig;
            alo = bdytail - ahi;
            c = this.splitter * cdx;
            abig = c - cdx;
            bhi = c - abig;
            blo = cdx - bhi;
            err1 = bdyt_cdx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double bdyt_cdx0 = alo * blo - err3;
            _i = bdxt_cdy0 - bdyt_cdx0;
            bvirt = bdxt_cdy0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - bdyt_cdx0;
            around = bdxt_cdy0 - avirt;
            bt_c[0] = around + bround;
            _j = bdxt_cdy1 + _i;
            bvirt = _j - bdxt_cdy1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = bdxt_cdy1 - avirt;
            _0 = around + bround;
            _i = _0 - bdyt_cdx1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - bdyt_cdx1;
            around = _0 - avirt;
            bt_c[1] = around + bround;
            double bt_clarge = _j + _i;
            bvirt = bt_clarge - _j;
            avirt = bt_clarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            bt_c[2] = around + bround;
            bt_c[3] = bt_clarge;
            bt_clen = 4;
            double bdyt_adx1 = bdytail * adx;
            c = this.splitter * bdytail;
            abig = c - bdytail;
            ahi = c - abig;
            alo = bdytail - ahi;
            c = this.splitter * adx;
            abig = c - adx;
            bhi = c - abig;
            blo = adx - bhi;
            err1 = bdyt_adx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double bdyt_adx0 = alo * blo - err3;
            double bdxt_ady1 = bdxtail * ady;
            c = this.splitter * bdxtail;
            abig = c - bdxtail;
            ahi = c - abig;
            alo = bdxtail - ahi;
            c = this.splitter * ady;
            abig = c - ady;
            bhi = c - abig;
            blo = ady - bhi;
            err1 = bdxt_ady1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double bdxt_ady0 = alo * blo - err3;
            _i = bdyt_adx0 - bdxt_ady0;
            bvirt = bdyt_adx0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - bdxt_ady0;
            around = bdyt_adx0 - avirt;
            bt_a[0] = around + bround;
            _j = bdyt_adx1 + _i;
            bvirt = _j - bdyt_adx1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = bdyt_adx1 - avirt;
            _0 = around + bround;
            _i = _0 - bdxt_ady1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - bdxt_ady1;
            around = _0 - avirt;
            bt_a[1] = around + bround;
            double bt_alarge = _j + _i;
            bvirt = bt_alarge - _j;
            avirt = bt_alarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            bt_a[2] = around + bround;
            bt_a[3] = bt_alarge;
            bt_alen = 4;
        }
        if (cdxtail == 0.0) {
            if (cdytail == 0.0) {
                ct_a[0] = 0.0;
                ct_alen = 1;
                ct_b[0] = 0.0;
                ct_blen = 1;
            } else {
                negate = -cdytail;
                double ct_alarge = negate * adx;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * adx;
                abig = c - adx;
                bhi = c - abig;
                blo = adx - bhi;
                err1 = ct_alarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ct_a[0] = alo * blo - err3;
                ct_a[1] = ct_alarge;
                ct_alen = 2;
                double ct_blarge = cdytail * bdx;
                c = this.splitter * cdytail;
                abig = c - cdytail;
                ahi = c - abig;
                alo = cdytail - ahi;
                c = this.splitter * bdx;
                abig = c - bdx;
                bhi = c - abig;
                blo = bdx - bhi;
                err1 = ct_blarge - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ct_b[0] = alo * blo - err3;
                ct_b[1] = ct_blarge;
                ct_blen = 2;
            }
        } else if (cdytail == 0.0) {
            double ct_alarge = cdxtail * ady;
            c = this.splitter * cdxtail;
            abig = c - cdxtail;
            ahi = c - abig;
            alo = cdxtail - ahi;
            c = this.splitter * ady;
            abig = c - ady;
            bhi = c - abig;
            blo = ady - bhi;
            err1 = ct_alarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            ct_a[0] = alo * blo - err3;
            ct_a[1] = ct_alarge;
            ct_alen = 2;
            negate = -cdxtail;
            double ct_blarge = negate * bdy;
            c = this.splitter * negate;
            abig = c - negate;
            ahi = c - abig;
            alo = negate - ahi;
            c = this.splitter * bdy;
            abig = c - bdy;
            bhi = c - abig;
            blo = bdy - bhi;
            err1 = ct_blarge - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            ct_b[0] = alo * blo - err3;
            ct_b[1] = ct_blarge;
            ct_blen = 2;
        } else {
            double cdxt_ady1 = cdxtail * ady;
            c = this.splitter * cdxtail;
            abig = c - cdxtail;
            ahi = c - abig;
            alo = cdxtail - ahi;
            c = this.splitter * ady;
            abig = c - ady;
            bhi = c - abig;
            blo = ady - bhi;
            err1 = cdxt_ady1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double cdxt_ady0 = alo * blo - err3;
            double cdyt_adx1 = cdytail * adx;
            c = this.splitter * cdytail;
            abig = c - cdytail;
            ahi = c - abig;
            alo = cdytail - ahi;
            c = this.splitter * adx;
            abig = c - adx;
            bhi = c - abig;
            blo = adx - bhi;
            err1 = cdyt_adx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double cdyt_adx0 = alo * blo - err3;
            _i = cdxt_ady0 - cdyt_adx0;
            bvirt = cdxt_ady0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - cdyt_adx0;
            around = cdxt_ady0 - avirt;
            ct_a[0] = around + bround;
            _j = cdxt_ady1 + _i;
            bvirt = _j - cdxt_ady1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = cdxt_ady1 - avirt;
            _0 = around + bround;
            _i = _0 - cdyt_adx1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - cdyt_adx1;
            around = _0 - avirt;
            ct_a[1] = around + bround;
            double ct_alarge = _j + _i;
            bvirt = ct_alarge - _j;
            avirt = ct_alarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            ct_a[2] = around + bround;
            ct_a[3] = ct_alarge;
            ct_alen = 4;
            double cdyt_bdx1 = cdytail * bdx;
            c = this.splitter * cdytail;
            abig = c - cdytail;
            ahi = c - abig;
            alo = cdytail - ahi;
            c = this.splitter * bdx;
            abig = c - bdx;
            bhi = c - abig;
            blo = bdx - bhi;
            err1 = cdyt_bdx1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double cdyt_bdx0 = alo * blo - err3;
            double cdxt_bdy1 = cdxtail * bdy;
            c = this.splitter * cdxtail;
            abig = c - cdxtail;
            ahi = c - abig;
            alo = cdxtail - ahi;
            c = this.splitter * bdy;
            abig = c - bdy;
            bhi = c - abig;
            blo = bdy - bhi;
            err1 = cdxt_bdy1 - ahi * bhi;
            err2 = err1 - alo * bhi;
            err3 = err2 - ahi * blo;
            double cdxt_bdy0 = alo * blo - err3;
            _i = cdyt_bdx0 - cdxt_bdy0;
            bvirt = cdyt_bdx0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - cdxt_bdy0;
            around = cdyt_bdx0 - avirt;
            ct_b[0] = around + bround;
            _j = cdyt_bdx1 + _i;
            bvirt = _j - cdyt_bdx1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = cdyt_bdx1 - avirt;
            _0 = around + bround;
            _i = _0 - cdxt_bdy1;
            bvirt = _0 - _i;
            avirt = _i + bvirt;
            bround = bvirt - cdxt_bdy1;
            around = _0 - avirt;
            ct_b[1] = around + bround;
            double ct_blarge = _j + _i;
            bvirt = ct_blarge - _j;
            avirt = ct_blarge - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            ct_b[2] = around + bround;
            ct_b[3] = ct_blarge;
            ct_blen = 4;
        }
        int bctlen = this.fast_expansion_sum_zeroelim(bt_clen, bt_c, ct_blen, ct_b, bct);
        int wlength = this.scale_expansion_zeroelim(bctlen, bct, adz, w);
        finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
        double[] finswap = finnow;
        finnow = finother;
        finother = finswap;
        int catlen = this.fast_expansion_sum_zeroelim(ct_alen, ct_a, at_clen, at_c, cat);
        wlength = this.scale_expansion_zeroelim(catlen, cat, bdz, w);
        finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
        finswap = finnow;
        finnow = finother;
        finother = finswap;
        int abtlen = this.fast_expansion_sum_zeroelim(at_blen, at_b, bt_alen, bt_a, abt);
        wlength = this.scale_expansion_zeroelim(abtlen, abt, cdz, w);
        finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
        finswap = finnow;
        finnow = finother;
        finother = finswap;
        if (adztail != 0.0) {
            vlength = this.scale_expansion_zeroelim(4, bc, adztail, v);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, vlength, v, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (bdztail != 0.0) {
            vlength = this.scale_expansion_zeroelim(4, ca, bdztail, v);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, vlength, v, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (cdztail != 0.0) {
            vlength = this.scale_expansion_zeroelim(4, ab, cdztail, v);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, vlength, v, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (adxtail != 0.0) {
            if (bdytail != 0.0) {
                double adxt_bdyt1 = adxtail * bdytail;
                c = this.splitter * adxtail;
                abig = c - adxtail;
                ahi = c - abig;
                alo = adxtail - ahi;
                c = this.splitter * bdytail;
                abig = c - bdytail;
                bhi = c - abig;
                blo = bdytail - bhi;
                err1 = adxt_bdyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double adxt_bdyt0 = alo * blo - err3;
                c = this.splitter * cdz;
                abig = c - cdz;
                bhi = c - abig;
                blo = cdz - bhi;
                _i = adxt_bdyt0 * cdz;
                c = this.splitter * adxt_bdyt0;
                abig = c - adxt_bdyt0;
                ahi = c - abig;
                alo = adxt_bdyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = adxt_bdyt1 * cdz;
                c = this.splitter * adxt_bdyt1;
                abig = c - adxt_bdyt1;
                ahi = c - abig;
                alo = adxt_bdyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (cdztail != 0.0) {
                    c = this.splitter * cdztail;
                    abig = c - cdztail;
                    bhi = c - abig;
                    blo = cdztail - bhi;
                    _i = adxt_bdyt0 * cdztail;
                    c = this.splitter * adxt_bdyt0;
                    abig = c - adxt_bdyt0;
                    ahi = c - abig;
                    alo = adxt_bdyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = adxt_bdyt1 * cdztail;
                    c = this.splitter * adxt_bdyt1;
                    abig = c - adxt_bdyt1;
                    ahi = c - abig;
                    alo = adxt_bdyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
            if (cdytail != 0.0) {
                negate = -adxtail;
                double adxt_cdyt1 = negate * cdytail;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * cdytail;
                abig = c - cdytail;
                bhi = c - abig;
                blo = cdytail - bhi;
                err1 = adxt_cdyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double adxt_cdyt0 = alo * blo - err3;
                c = this.splitter * bdz;
                abig = c - bdz;
                bhi = c - abig;
                blo = bdz - bhi;
                _i = adxt_cdyt0 * bdz;
                c = this.splitter * adxt_cdyt0;
                abig = c - adxt_cdyt0;
                ahi = c - abig;
                alo = adxt_cdyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = adxt_cdyt1 * bdz;
                c = this.splitter * adxt_cdyt1;
                abig = c - adxt_cdyt1;
                ahi = c - abig;
                alo = adxt_cdyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (bdztail != 0.0) {
                    c = this.splitter * bdztail;
                    abig = c - bdztail;
                    bhi = c - abig;
                    blo = bdztail - bhi;
                    _i = adxt_cdyt0 * bdztail;
                    c = this.splitter * adxt_cdyt0;
                    abig = c - adxt_cdyt0;
                    ahi = c - abig;
                    alo = adxt_cdyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = adxt_cdyt1 * bdztail;
                    c = this.splitter * adxt_cdyt1;
                    abig = c - adxt_cdyt1;
                    ahi = c - abig;
                    alo = adxt_cdyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
        }
        if (bdxtail != 0.0) {
            if (cdytail != 0.0) {
                double bdxt_cdyt1 = bdxtail * cdytail;
                c = this.splitter * bdxtail;
                abig = c - bdxtail;
                ahi = c - abig;
                alo = bdxtail - ahi;
                c = this.splitter * cdytail;
                abig = c - cdytail;
                bhi = c - abig;
                blo = cdytail - bhi;
                err1 = bdxt_cdyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double bdxt_cdyt0 = alo * blo - err3;
                c = this.splitter * adz;
                abig = c - adz;
                bhi = c - abig;
                blo = adz - bhi;
                _i = bdxt_cdyt0 * adz;
                c = this.splitter * bdxt_cdyt0;
                abig = c - bdxt_cdyt0;
                ahi = c - abig;
                alo = bdxt_cdyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = bdxt_cdyt1 * adz;
                c = this.splitter * bdxt_cdyt1;
                abig = c - bdxt_cdyt1;
                ahi = c - abig;
                alo = bdxt_cdyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (adztail != 0.0) {
                    c = this.splitter * adztail;
                    abig = c - adztail;
                    bhi = c - abig;
                    blo = adztail - bhi;
                    _i = bdxt_cdyt0 * adztail;
                    c = this.splitter * bdxt_cdyt0;
                    abig = c - bdxt_cdyt0;
                    ahi = c - abig;
                    alo = bdxt_cdyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = bdxt_cdyt1 * adztail;
                    c = this.splitter * bdxt_cdyt1;
                    abig = c - bdxt_cdyt1;
                    ahi = c - abig;
                    alo = bdxt_cdyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
            if (adytail != 0.0) {
                negate = -bdxtail;
                double bdxt_adyt1 = negate * adytail;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * adytail;
                abig = c - adytail;
                bhi = c - abig;
                blo = adytail - bhi;
                err1 = bdxt_adyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double bdxt_adyt0 = alo * blo - err3;
                c = this.splitter * cdz;
                abig = c - cdz;
                bhi = c - abig;
                blo = cdz - bhi;
                _i = bdxt_adyt0 * cdz;
                c = this.splitter * bdxt_adyt0;
                abig = c - bdxt_adyt0;
                ahi = c - abig;
                alo = bdxt_adyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = bdxt_adyt1 * cdz;
                c = this.splitter * bdxt_adyt1;
                abig = c - bdxt_adyt1;
                ahi = c - abig;
                alo = bdxt_adyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (cdztail != 0.0) {
                    c = this.splitter * cdztail;
                    abig = c - cdztail;
                    bhi = c - abig;
                    blo = cdztail - bhi;
                    _i = bdxt_adyt0 * cdztail;
                    c = this.splitter * bdxt_adyt0;
                    abig = c - bdxt_adyt0;
                    ahi = c - abig;
                    alo = bdxt_adyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = bdxt_adyt1 * cdztail;
                    c = this.splitter * bdxt_adyt1;
                    abig = c - bdxt_adyt1;
                    ahi = c - abig;
                    alo = bdxt_adyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
        }
        if (cdxtail != 0.0) {
            if (adytail != 0.0) {
                double cdxt_adyt1 = cdxtail * adytail;
                c = this.splitter * cdxtail;
                abig = c - cdxtail;
                ahi = c - abig;
                alo = cdxtail - ahi;
                c = this.splitter * adytail;
                abig = c - adytail;
                bhi = c - abig;
                blo = adytail - bhi;
                err1 = cdxt_adyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double cdxt_adyt0 = alo * blo - err3;
                c = this.splitter * bdz;
                abig = c - bdz;
                bhi = c - abig;
                blo = bdz - bhi;
                _i = cdxt_adyt0 * bdz;
                c = this.splitter * cdxt_adyt0;
                abig = c - cdxt_adyt0;
                ahi = c - abig;
                alo = cdxt_adyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = cdxt_adyt1 * bdz;
                c = this.splitter * cdxt_adyt1;
                abig = c - cdxt_adyt1;
                ahi = c - abig;
                alo = cdxt_adyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (bdztail != 0.0) {
                    c = this.splitter * bdztail;
                    abig = c - bdztail;
                    bhi = c - abig;
                    blo = bdztail - bhi;
                    _i = cdxt_adyt0 * bdztail;
                    c = this.splitter * cdxt_adyt0;
                    abig = c - cdxt_adyt0;
                    ahi = c - abig;
                    alo = cdxt_adyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = cdxt_adyt1 * bdztail;
                    c = this.splitter * cdxt_adyt1;
                    abig = c - cdxt_adyt1;
                    ahi = c - abig;
                    alo = cdxt_adyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
            if (bdytail != 0.0) {
                negate = -cdxtail;
                double cdxt_bdyt1 = negate * bdytail;
                c = this.splitter * negate;
                abig = c - negate;
                ahi = c - abig;
                alo = negate - ahi;
                c = this.splitter * bdytail;
                abig = c - bdytail;
                bhi = c - abig;
                blo = bdytail - bhi;
                err1 = cdxt_bdyt1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                double cdxt_bdyt0 = alo * blo - err3;
                c = this.splitter * adz;
                abig = c - adz;
                bhi = c - abig;
                blo = adz - bhi;
                _i = cdxt_bdyt0 * adz;
                c = this.splitter * cdxt_bdyt0;
                abig = c - cdxt_bdyt0;
                ahi = c - abig;
                alo = cdxt_bdyt0 - ahi;
                err1 = _i - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                u[0] = alo * blo - err3;
                _j = cdxt_bdyt1 * adz;
                c = this.splitter * cdxt_bdyt1;
                abig = c - cdxt_bdyt1;
                ahi = c - abig;
                alo = cdxt_bdyt1 - ahi;
                err1 = _j - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                _0 = alo * blo - err3;
                _k = _i + _0;
                bvirt = _k - _i;
                avirt = _k - bvirt;
                bround = _0 - bvirt;
                around = _i - avirt;
                u[1] = around + bround;
                u3 = _j + _k;
                bvirt = u3 - _j;
                u[2] = _k - bvirt;
                u[3] = u3;
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (adztail != 0.0) {
                    c = this.splitter * adztail;
                    abig = c - adztail;
                    bhi = c - abig;
                    blo = adztail - bhi;
                    _i = cdxt_bdyt0 * adztail;
                    c = this.splitter * cdxt_bdyt0;
                    abig = c - cdxt_bdyt0;
                    ahi = c - abig;
                    alo = cdxt_bdyt0 - ahi;
                    err1 = _i - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    u[0] = alo * blo - err3;
                    _j = cdxt_bdyt1 * adztail;
                    c = this.splitter * cdxt_bdyt1;
                    abig = c - cdxt_bdyt1;
                    ahi = c - abig;
                    alo = cdxt_bdyt1 - ahi;
                    err1 = _j - ahi * bhi;
                    err2 = err1 - alo * bhi;
                    err3 = err2 - ahi * blo;
                    _0 = alo * blo - err3;
                    _k = _i + _0;
                    bvirt = _k - _i;
                    avirt = _k - bvirt;
                    bround = _0 - bvirt;
                    around = _i - avirt;
                    u[1] = around + bround;
                    u3 = _j + _k;
                    bvirt = u3 - _j;
                    u[2] = _k - bvirt;
                    u[3] = u3;
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, 4, u, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
            }
        }
        if (adztail != 0.0) {
            wlength = this.scale_expansion_zeroelim(bctlen, bct, adztail, w);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (bdztail != 0.0) {
            wlength = this.scale_expansion_zeroelim(catlen, cat, bdztail, w);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (cdztail != 0.0) {
            wlength = this.scale_expansion_zeroelim(abtlen, abt, cdztail, w);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, wlength, w, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        return finnow[finlength - 1];
    }

    double orient3d(double[] pa, double[] pb, double[] pc, double[] pd) {
        double adz = pa[2] - pd[2];
        double bdx = pb[0] - pd[0];
        double cdy = pc[1] - pd[1];
        double bdxcdy = bdx * cdy;
        double cdx = pc[0] - pd[0];
        double bdy = pb[1] - pd[1];
        double cdxbdy = cdx * bdy;
        double bdz = pb[2] - pd[2];
        double ady = pa[1] - pd[1];
        double cdxady = cdx * ady;
        double adx = pa[0] - pd[0];
        double adxcdy = adx * cdy;
        double cdz = pc[2] - pd[2];
        double adxbdy = adx * bdy;
        double bdxady = bdx * ady;
        double det = adz * (bdxcdy - cdxbdy) + bdz * (cdxady - adxcdy) + cdz * (adxbdy - bdxady);
        double permanent = ((bdxcdy >= 0.0 ? bdxcdy : -bdxcdy) + (cdxbdy >= 0.0 ? cdxbdy : -cdxbdy)) * (adz >= 0.0 ? adz : -adz) + ((cdxady >= 0.0 ? cdxady : -cdxady) + (adxcdy >= 0.0 ? adxcdy : -adxcdy)) * (bdz >= 0.0 ? bdz : -bdz) + ((adxbdy >= 0.0 ? adxbdy : -adxbdy) + (bdxady >= 0.0 ? bdxady : -bdxady)) * (cdz >= 0.0 ? cdz : -cdz);
        double errbound = this.o3derrboundA * permanent;
        if (det > errbound || -det > errbound) {
            return det;
        }
        return this.orient3dadapt(pa, pb, pc, pd, permanent);
    }

    double incirclefast(double[] pa, double[] pb, double[] pc, double[] pd) {
        double adx = pa[0] - pd[0];
        double ady = pa[1] - pd[1];
        double bdx = pb[0] - pd[0];
        double bdy = pb[1] - pd[1];
        double cdx = pc[0] - pd[0];
        double cdy = pc[1] - pd[1];
        double abdet = adx * bdy - bdx * ady;
        double bcdet = bdx * cdy - cdx * bdy;
        double cadet = cdx * ady - adx * cdy;
        double alift = adx * adx + ady * ady;
        double blift = bdx * bdx + bdy * bdy;
        double clift = cdx * cdx + cdy * cdy;
        return alift * bcdet + blift * cadet + clift * abdet;
    }

    double incircleexact(double[] pa, double[] pb, double[] pc, double[] pd) {
        double[] ab = new double[4];
        double[] bc = new double[4];
        double[] cd = new double[4];
        double[] da = new double[4];
        double[] ac = new double[4];
        double[] bd = new double[4];
        double[] temp8 = new double[8];
        double[] abc = new double[12];
        double[] bcd = new double[12];
        double[] cda = new double[12];
        double[] dab = new double[12];
        double[] det24x = new double[24];
        double[] det24y = new double[24];
        double[] det48x = new double[48];
        double[] det48y = new double[48];
        double[] adet = new double[96];
        double[] bdet = new double[96];
        double[] cdet = new double[96];
        double[] ddet = new double[96];
        double[] abdet = new double[192];
        double[] cddet = new double[192];
        double[] deter = new double[384];
        double axby1 = pa[0] * pb[1];
        double c = this.splitter * pa[0];
        double abig = c - pa[0];
        double ahi = c - abig;
        double alo = pa[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        double bhi = c - abig;
        double blo = pb[1] - bhi;
        double err1 = axby1 - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double axby0 = alo * blo - err3;
        double bxay1 = pb[0] * pa[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = bxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxay0 = alo * blo - err3;
        double _i = axby0 - bxay0;
        double bvirt = axby0 - _i;
        double avirt = _i + bvirt;
        double bround = bvirt - bxay0;
        double around = axby0 - avirt;
        ab[0] = around + bround;
        double _j = axby1 + _i;
        bvirt = _j - axby1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = axby1 - avirt;
        double _0 = around + bround;
        _i = _0 - bxay1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bxay1;
        around = _0 - avirt;
        ab[1] = around + bround;
        ab[3] = _j + _i;
        bvirt = ab[3] - _j;
        avirt = ab[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ab[2] = around + bround;
        double bxcy1 = pb[0] * pc[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = bxcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxcy0 = alo * blo - err3;
        double cxby1 = pc[0] * pb[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        bhi = c - abig;
        blo = pb[1] - bhi;
        err1 = cxby1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxby0 = alo * blo - err3;
        _i = bxcy0 - cxby0;
        bvirt = bxcy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxby0;
        around = bxcy0 - avirt;
        bc[0] = around + bround;
        _j = bxcy1 + _i;
        bvirt = _j - bxcy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bxcy1 - avirt;
        _0 = around + bround;
        _i = _0 - cxby1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxby1;
        around = _0 - avirt;
        bc[1] = around + bround;
        bc[3] = _j + _i;
        bvirt = bc[3] - _j;
        avirt = bc[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bc[2] = around + bround;
        double cxdy1 = pc[0] * pd[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = cxdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxdy0 = alo * blo - err3;
        double dxcy1 = pd[0] * pc[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = dxcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxcy0 = alo * blo - err3;
        _i = cxdy0 - dxcy0;
        bvirt = cxdy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxcy0;
        around = cxdy0 - avirt;
        cd[0] = around + bround;
        _j = cxdy1 + _i;
        bvirt = _j - cxdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cxdy1 - avirt;
        _0 = around + bround;
        _i = _0 - dxcy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxcy1;
        around = _0 - avirt;
        cd[1] = around + bround;
        cd[3] = _j + _i;
        bvirt = cd[3] - _j;
        avirt = cd[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        cd[2] = around + bround;
        double dxay1 = pd[0] * pa[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = dxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxay0 = alo * blo - err3;
        double axdy1 = pa[0] * pd[1];
        c = this.splitter * pa[0];
        abig = c - pa[0];
        ahi = c - abig;
        alo = pa[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = axdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double axdy0 = alo * blo - err3;
        _i = dxay0 - axdy0;
        bvirt = dxay0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axdy0;
        around = dxay0 - avirt;
        da[0] = around + bround;
        _j = dxay1 + _i;
        bvirt = _j - dxay1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = dxay1 - avirt;
        _0 = around + bround;
        _i = _0 - axdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axdy1;
        around = _0 - avirt;
        da[1] = around + bround;
        da[3] = _j + _i;
        bvirt = da[3] - _j;
        avirt = da[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        da[2] = around + bround;
        double axcy1 = pa[0] * pc[1];
        c = this.splitter * pa[0];
        abig = c - pa[0];
        ahi = c - abig;
        alo = pa[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = axcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double axcy0 = alo * blo - err3;
        double cxay1 = pc[0] * pa[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = cxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxay0 = alo * blo - err3;
        _i = axcy0 - cxay0;
        bvirt = axcy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxay0;
        around = axcy0 - avirt;
        ac[0] = around + bround;
        _j = axcy1 + _i;
        bvirt = _j - axcy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = axcy1 - avirt;
        _0 = around + bround;
        _i = _0 - cxay1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxay1;
        around = _0 - avirt;
        ac[1] = around + bround;
        ac[3] = _j + _i;
        bvirt = ac[3] - _j;
        avirt = ac[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ac[2] = around + bround;
        double bxdy1 = pb[0] * pd[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = bxdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxdy0 = alo * blo - err3;
        double dxby1 = pd[0] * pb[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        bhi = c - abig;
        blo = pb[1] - bhi;
        err1 = dxby1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxby0 = alo * blo - err3;
        _i = bxdy0 - dxby0;
        bvirt = bxdy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxby0;
        around = bxdy0 - avirt;
        bd[0] = around + bround;
        _j = bxdy1 + _i;
        bvirt = _j - bxdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bxdy1 - avirt;
        _0 = around + bround;
        _i = _0 - dxby1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxby1;
        around = _0 - avirt;
        bd[1] = around + bround;
        bd[3] = _j + _i;
        bvirt = bd[3] - _j;
        avirt = bd[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bd[2] = around + bround;
        int templen = this.fast_expansion_sum_zeroelim(4, cd, 4, da, temp8);
        int cdalen = this.fast_expansion_sum_zeroelim(templen, temp8, 4, ac, cda);
        templen = this.fast_expansion_sum_zeroelim(4, da, 4, ab, temp8);
        int dablen = this.fast_expansion_sum_zeroelim(templen, temp8, 4, bd, dab);
        for (int i = 0; i < 4; ++i) {
            bd[i] = -bd[i];
            ac[i] = -ac[i];
        }
        templen = this.fast_expansion_sum_zeroelim(4, ab, 4, bc, temp8);
        int abclen = this.fast_expansion_sum_zeroelim(templen, temp8, 4, ac, abc);
        templen = this.fast_expansion_sum_zeroelim(4, bc, 4, cd, temp8);
        int bcdlen = this.fast_expansion_sum_zeroelim(templen, temp8, 4, bd, bcd);
        int xlen = this.scale_expansion_zeroelim(bcdlen, bcd, pa[0], det24x);
        xlen = this.scale_expansion_zeroelim(xlen, det24x, pa[0], det48x);
        int ylen = this.scale_expansion_zeroelim(bcdlen, bcd, pa[1], det24y);
        ylen = this.scale_expansion_zeroelim(ylen, det24y, pa[1], det48y);
        int alen = this.fast_expansion_sum_zeroelim(xlen, det48x, ylen, det48y, adet);
        xlen = this.scale_expansion_zeroelim(cdalen, cda, pb[0], det24x);
        xlen = this.scale_expansion_zeroelim(xlen, det24x, -pb[0], det48x);
        ylen = this.scale_expansion_zeroelim(cdalen, cda, pb[1], det24y);
        ylen = this.scale_expansion_zeroelim(ylen, det24y, -pb[1], det48y);
        int blen = this.fast_expansion_sum_zeroelim(xlen, det48x, ylen, det48y, bdet);
        xlen = this.scale_expansion_zeroelim(dablen, dab, pc[0], det24x);
        xlen = this.scale_expansion_zeroelim(xlen, det24x, pc[0], det48x);
        ylen = this.scale_expansion_zeroelim(dablen, dab, pc[1], det24y);
        ylen = this.scale_expansion_zeroelim(ylen, det24y, pc[1], det48y);
        int clen = this.fast_expansion_sum_zeroelim(xlen, det48x, ylen, det48y, cdet);
        xlen = this.scale_expansion_zeroelim(abclen, abc, pd[0], det24x);
        xlen = this.scale_expansion_zeroelim(xlen, det24x, -pd[0], det48x);
        ylen = this.scale_expansion_zeroelim(abclen, abc, pd[1], det24y);
        ylen = this.scale_expansion_zeroelim(ylen, det24y, -pd[1], det48y);
        int dlen = this.fast_expansion_sum_zeroelim(xlen, det48x, ylen, det48y, ddet);
        int ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        int cdlen = this.fast_expansion_sum_zeroelim(clen, cdet, dlen, ddet, cddet);
        int deterlen = this.fast_expansion_sum_zeroelim(ablen, abdet, cdlen, cddet, deter);
        return deter[deterlen - 1];
    }

    double incircleslow(double[] pa, double[] pb, double[] pc, double[] pd) {
        double[] axby = new double[8];
        double[] bxcy = new double[8];
        double[] axcy = new double[8];
        double[] bxay = new double[8];
        double[] cxby = new double[8];
        double[] cxay = new double[8];
        double[] temp16 = new double[16];
        double[] detx = new double[32];
        double[] detxx = new double[64];
        double[] detxt = new double[32];
        double[] detxxt = new double[64];
        double[] detxtxt = new double[64];
        double[] x1 = new double[128];
        double[] x2 = new double[192];
        double[] dety = new double[32];
        double[] detyy = new double[64];
        double[] detyt = new double[32];
        double[] detyyt = new double[64];
        double[] detytyt = new double[64];
        double[] y1 = new double[128];
        double[] y2 = new double[192];
        double[] adet = new double[384];
        double[] bdet = new double[384];
        double[] cdet = new double[384];
        double[] abdet = new double[768];
        double[] deter = new double[1152];
        double adx = pa[0] - pd[0];
        double bvirt = pa[0] - adx;
        double avirt = adx + bvirt;
        double bround = bvirt - pd[0];
        double around = pa[0] - avirt;
        double adxtail = around + bround;
        double ady = pa[1] - pd[1];
        bvirt = pa[1] - ady;
        avirt = ady + bvirt;
        bround = bvirt - pd[1];
        around = pa[1] - avirt;
        double adytail = around + bround;
        double bdx = pb[0] - pd[0];
        bvirt = pb[0] - bdx;
        avirt = bdx + bvirt;
        bround = bvirt - pd[0];
        around = pb[0] - avirt;
        double bdxtail = around + bround;
        double bdy = pb[1] - pd[1];
        bvirt = pb[1] - bdy;
        avirt = bdy + bvirt;
        bround = bvirt - pd[1];
        around = pb[1] - avirt;
        double bdytail = around + bround;
        double cdx = pc[0] - pd[0];
        bvirt = pc[0] - cdx;
        avirt = cdx + bvirt;
        bround = bvirt - pd[0];
        around = pc[0] - avirt;
        double cdxtail = around + bround;
        double cdy = pc[1] - pd[1];
        bvirt = pc[1] - cdy;
        avirt = cdy + bvirt;
        bround = bvirt - pd[1];
        around = pc[1] - avirt;
        double cdytail = around + bround;
        double c = this.splitter * adxtail;
        double abig = c - adxtail;
        double a0hi = c - abig;
        double a0lo = adxtail - a0hi;
        c = this.splitter * bdytail;
        abig = c - bdytail;
        double bhi = c - abig;
        double blo = bdytail - bhi;
        double _i = adxtail * bdytail;
        double err1 = _i - a0hi * bhi;
        double err2 = err1 - a0lo * bhi;
        double err3 = err2 - a0hi * blo;
        axby[0] = a0lo * blo - err3;
        c = this.splitter * adx;
        abig = c - adx;
        double a1hi = c - abig;
        double a1lo = adx - a1hi;
        double _j = adx * bdytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        double _0 = a1lo * blo - err3;
        double _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        double _1 = around + bround;
        double _l = _j + _k;
        bvirt = _l - _j;
        double _2 = _k - bvirt;
        c = this.splitter * bdy;
        abig = c - bdy;
        bhi = c - abig;
        blo = bdy - bhi;
        _i = adxtail * bdy;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        double _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = adx * bdy;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        double _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        axby[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        axby[5] = around + bround;
        double axby7 = _m + _k;
        bvirt = axby7 - _m;
        avirt = axby7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        axby[6] = around + bround;
        axby[7] = axby7;
        double negate = -ady;
        double negatetail = -adytail;
        c = this.splitter * bdxtail;
        abig = c - bdxtail;
        a0hi = c - abig;
        a0lo = bdxtail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = bdxtail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        bxay[0] = a0lo * blo - err3;
        c = this.splitter * bdx;
        abig = c - bdx;
        a1hi = c - abig;
        a1lo = bdx - a1hi;
        _j = bdx * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = bdxtail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = bdx * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        bxay[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        bxay[5] = around + bround;
        double bxay7 = _m + _k;
        bvirt = bxay7 - _m;
        avirt = bxay7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        bxay[6] = around + bround;
        bxay[7] = bxay7;
        c = this.splitter * bdxtail;
        abig = c - bdxtail;
        a0hi = c - abig;
        a0lo = bdxtail - a0hi;
        c = this.splitter * cdytail;
        abig = c - cdytail;
        bhi = c - abig;
        blo = cdytail - bhi;
        _i = bdxtail * cdytail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        bxcy[0] = a0lo * blo - err3;
        c = this.splitter * bdx;
        abig = c - bdx;
        a1hi = c - abig;
        a1lo = bdx - a1hi;
        _j = bdx * cdytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * cdy;
        abig = c - cdy;
        bhi = c - abig;
        blo = cdy - bhi;
        _i = bdxtail * cdy;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxcy[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = bdx * cdy;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxcy[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxcy[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        bxcy[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        bxcy[5] = around + bround;
        double bxcy7 = _m + _k;
        bvirt = bxcy7 - _m;
        avirt = bxcy7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        bxcy[6] = around + bround;
        bxcy[7] = bxcy7;
        negate = -bdy;
        negatetail = -bdytail;
        c = this.splitter * cdxtail;
        abig = c - cdxtail;
        a0hi = c - abig;
        a0lo = cdxtail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = cdxtail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        cxby[0] = a0lo * blo - err3;
        c = this.splitter * cdx;
        abig = c - cdx;
        a1hi = c - abig;
        a1lo = cdx - a1hi;
        _j = cdx * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = cdxtail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxby[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = cdx * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxby[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxby[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        cxby[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        cxby[5] = around + bround;
        double cxby7 = _m + _k;
        bvirt = cxby7 - _m;
        avirt = cxby7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        cxby[6] = around + bround;
        cxby[7] = cxby7;
        c = this.splitter * cdxtail;
        abig = c - cdxtail;
        a0hi = c - abig;
        a0lo = cdxtail - a0hi;
        c = this.splitter * adytail;
        abig = c - adytail;
        bhi = c - abig;
        blo = adytail - bhi;
        _i = cdxtail * adytail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        cxay[0] = a0lo * blo - err3;
        c = this.splitter * cdx;
        abig = c - cdx;
        a1hi = c - abig;
        a1lo = cdx - a1hi;
        _j = cdx * adytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * ady;
        abig = c - ady;
        bhi = c - abig;
        blo = ady - bhi;
        _i = cdxtail * ady;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxay[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = cdx * ady;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxay[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxay[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        cxay[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        cxay[5] = around + bround;
        double cxay7 = _m + _k;
        bvirt = cxay7 - _m;
        avirt = cxay7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        cxay[6] = around + bround;
        cxay[7] = cxay7;
        negate = -cdy;
        negatetail = -cdytail;
        c = this.splitter * adxtail;
        abig = c - adxtail;
        a0hi = c - abig;
        a0lo = adxtail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = adxtail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        axcy[0] = a0lo * blo - err3;
        c = this.splitter * adx;
        abig = c - adx;
        a1hi = c - abig;
        a1lo = adx - a1hi;
        _j = adx * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = adxtail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axcy[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = adx * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axcy[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axcy[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        axcy[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        axcy[5] = around + bround;
        double axcy7 = _m + _k;
        bvirt = axcy7 - _m;
        avirt = axcy7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        axcy[6] = around + bround;
        axcy[7] = axcy7;
        int temp16len = this.fast_expansion_sum_zeroelim(8, bxcy, 8, cxby, temp16);
        int xlen = this.scale_expansion_zeroelim(temp16len, temp16, adx, detx);
        int xxlen = this.scale_expansion_zeroelim(xlen, detx, adx, detxx);
        int xtlen = this.scale_expansion_zeroelim(temp16len, temp16, adxtail, detxt);
        int xxtlen = this.scale_expansion_zeroelim(xtlen, detxt, adx, detxxt);
        int i = 0;
        while (i < xxtlen) {
            int n = i++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        int xtxtlen = this.scale_expansion_zeroelim(xtlen, detxt, adxtail, detxtxt);
        int x1len = this.fast_expansion_sum_zeroelim(xxlen, detxx, xxtlen, detxxt, x1);
        int x2len = this.fast_expansion_sum_zeroelim(x1len, x1, xtxtlen, detxtxt, x2);
        int ylen = this.scale_expansion_zeroelim(temp16len, temp16, ady, dety);
        int yylen = this.scale_expansion_zeroelim(ylen, dety, ady, detyy);
        int ytlen = this.scale_expansion_zeroelim(temp16len, temp16, adytail, detyt);
        int yytlen = this.scale_expansion_zeroelim(ytlen, detyt, ady, detyyt);
        i = 0;
        while (i < yytlen) {
            int n = i++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        int ytytlen = this.scale_expansion_zeroelim(ytlen, detyt, adytail, detytyt);
        int y1len = this.fast_expansion_sum_zeroelim(yylen, detyy, yytlen, detyyt, y1);
        int y2len = this.fast_expansion_sum_zeroelim(y1len, y1, ytytlen, detytyt, y2);
        int alen = this.fast_expansion_sum_zeroelim(x2len, x2, y2len, y2, adet);
        temp16len = this.fast_expansion_sum_zeroelim(8, cxay, 8, axcy, temp16);
        xlen = this.scale_expansion_zeroelim(temp16len, temp16, bdx, detx);
        xxlen = this.scale_expansion_zeroelim(xlen, detx, bdx, detxx);
        xtlen = this.scale_expansion_zeroelim(temp16len, temp16, bdxtail, detxt);
        xxtlen = this.scale_expansion_zeroelim(xtlen, detxt, bdx, detxxt);
        i = 0;
        while (i < xxtlen) {
            int n = i++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = this.scale_expansion_zeroelim(xtlen, detxt, bdxtail, detxtxt);
        x1len = this.fast_expansion_sum_zeroelim(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = this.fast_expansion_sum_zeroelim(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = this.scale_expansion_zeroelim(temp16len, temp16, bdy, dety);
        yylen = this.scale_expansion_zeroelim(ylen, dety, bdy, detyy);
        ytlen = this.scale_expansion_zeroelim(temp16len, temp16, bdytail, detyt);
        yytlen = this.scale_expansion_zeroelim(ytlen, detyt, bdy, detyyt);
        i = 0;
        while (i < yytlen) {
            int n = i++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = this.scale_expansion_zeroelim(ytlen, detyt, bdytail, detytyt);
        y1len = this.fast_expansion_sum_zeroelim(yylen, detyy, yytlen, detyyt, y1);
        y2len = this.fast_expansion_sum_zeroelim(y1len, y1, ytytlen, detytyt, y2);
        int blen = this.fast_expansion_sum_zeroelim(x2len, x2, y2len, y2, bdet);
        temp16len = this.fast_expansion_sum_zeroelim(8, axby, 8, bxay, temp16);
        xlen = this.scale_expansion_zeroelim(temp16len, temp16, cdx, detx);
        xxlen = this.scale_expansion_zeroelim(xlen, detx, cdx, detxx);
        xtlen = this.scale_expansion_zeroelim(temp16len, temp16, cdxtail, detxt);
        xxtlen = this.scale_expansion_zeroelim(xtlen, detxt, cdx, detxxt);
        i = 0;
        while (i < xxtlen) {
            int n = i++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = this.scale_expansion_zeroelim(xtlen, detxt, cdxtail, detxtxt);
        x1len = this.fast_expansion_sum_zeroelim(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = this.fast_expansion_sum_zeroelim(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = this.scale_expansion_zeroelim(temp16len, temp16, cdy, dety);
        yylen = this.scale_expansion_zeroelim(ylen, dety, cdy, detyy);
        ytlen = this.scale_expansion_zeroelim(temp16len, temp16, cdytail, detyt);
        yytlen = this.scale_expansion_zeroelim(ytlen, detyt, cdy, detyyt);
        i = 0;
        while (i < yytlen) {
            int n = i++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = this.scale_expansion_zeroelim(ytlen, detyt, cdytail, detytyt);
        y1len = this.fast_expansion_sum_zeroelim(yylen, detyy, yytlen, detyyt, y1);
        y2len = this.fast_expansion_sum_zeroelim(y1len, y1, ytytlen, detytyt, y2);
        int clen = this.fast_expansion_sum_zeroelim(x2len, x2, y2len, y2, cdet);
        int ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        int deterlen = this.fast_expansion_sum_zeroelim(ablen, abdet, clen, cdet, deter);
        return deter[deterlen - 1];
    }

    double incircleadapt(double[] pa, double[] pb, double[] pc, double[] pd, double permanent) {
        int temp64len;
        int temp32blen;
        int temp8len;
        double v3;
        double negate;
        double u3;
        double tj0;
        double tj1;
        double ti0;
        double ti1;
        double[] finswap;
        int temp48len;
        int temp32alen;
        int temp16clen;
        int temp16blen;
        int temp16alen;
        double errbound;
        double _0;
        double _j;
        double _i;
        double err3;
        double blo;
        double err2;
        double alo;
        double err1;
        double bhi;
        double ahi;
        double abig;
        double c;
        double[] bc = new double[4];
        double[] ca = new double[4];
        double[] ab = new double[4];
        double[] axbc = new double[8];
        double[] axxbc = new double[16];
        double[] aybc = new double[8];
        double[] ayybc = new double[16];
        double[] adet = new double[32];
        double[] bxca = new double[8];
        double[] bxxca = new double[16];
        double[] byca = new double[8];
        double[] byyca = new double[16];
        double[] bdet = new double[32];
        double[] cxab = new double[8];
        double[] cxxab = new double[16];
        double[] cyab = new double[8];
        double[] cyyab = new double[16];
        double[] cdet = new double[32];
        double[] abdet = new double[64];
        double[] fin1 = new double[1152];
        double[] fin2 = new double[1152];
        double[] aa = new double[4];
        double[] bb = new double[4];
        double[] cc = new double[4];
        double[] u = new double[4];
        double[] v = new double[4];
        double[] temp8 = new double[8];
        double[] temp16a = new double[16];
        double[] temp16b = new double[16];
        double[] temp16c = new double[16];
        double[] temp32a = new double[32];
        double[] temp32b = new double[32];
        double[] temp48 = new double[48];
        double[] temp64 = new double[64];
        double[] axtbb = new double[8];
        double[] axtcc = new double[8];
        double[] aytbb = new double[8];
        double[] aytcc = new double[8];
        double[] bxtaa = new double[8];
        double[] bxtcc = new double[8];
        double[] bytaa = new double[8];
        double[] bytcc = new double[8];
        double[] cxtaa = new double[8];
        double[] cxtbb = new double[8];
        double[] cytaa = new double[8];
        double[] cytbb = new double[8];
        double[] axtbc = new double[8];
        double[] aytbc = new double[8];
        double[] bxtca = new double[8];
        double[] bytca = new double[8];
        double[] cxtab = new double[8];
        double[] cytab = new double[8];
        int axtbclen = 0;
        int aytbclen = 0;
        int bxtcalen = 0;
        int bytcalen = 0;
        int cxtablen = 0;
        int cytablen = 0;
        double[] axtbct = new double[16];
        double[] aytbct = new double[16];
        double[] bxtcat = new double[16];
        double[] bytcat = new double[16];
        double[] cxtabt = new double[16];
        double[] cytabt = new double[16];
        double[] axtbctt = new double[8];
        double[] aytbctt = new double[8];
        double[] bxtcatt = new double[8];
        double[] bytcatt = new double[8];
        double[] cxtabtt = new double[8];
        double[] cytabtt = new double[8];
        double[] abt = new double[8];
        double[] bct = new double[8];
        double[] cat = new double[8];
        double[] abtt = new double[4];
        double[] bctt = new double[4];
        double[] catt = new double[4];
        double adx = pa[0] - pd[0];
        double bdx = pb[0] - pd[0];
        double cdx = pc[0] - pd[0];
        double ady = pa[1] - pd[1];
        double bdy = pb[1] - pd[1];
        double cdy = pc[1] - pd[1];
        double bdxcdy1 = bdx * cdy;
        double d = this.splitter * bdx;
        void var259_90 = c - bdx;
        void var261_91 = c - abig;
        double d2 = bdx - ahi;
        c = this.splitter * cdy;
        abig = c - cdy;
        double d3 = c - abig;
        double d4 = cdy - bhi;
        double d5 = bdxcdy1 - ahi * bhi;
        void var271_96 = err1 - alo * bhi;
        void var273_97 = err2 - ahi * blo;
        void bdxcdy0 = alo * blo - err3;
        double cdxbdy1 = cdx * bdy;
        c = this.splitter * cdx;
        abig = c - cdx;
        ahi = c - abig;
        alo = cdx - ahi;
        c = this.splitter * bdy;
        abig = c - bdy;
        bhi = c - abig;
        blo = bdy - bhi;
        err1 = cdxbdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cdxbdy0 = alo * blo - err3;
        void var275_101 = bdxcdy0 - cdxbdy0;
        double bvirt = bdxcdy0 - _i;
        double avirt = _i + bvirt;
        double bround = bvirt - cdxbdy0;
        double around = bdxcdy0 - avirt;
        bc[0] = around + bround;
        double d6 = bdxcdy1 + _i;
        bvirt = _j - bdxcdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bdxcdy1 - avirt;
        double d7 = around + bround;
        _i = _0 - cdxbdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cdxbdy1;
        around = _0 - avirt;
        bc[1] = around + bround;
        void bc3 = _j + _i;
        bvirt = bc3 - _j;
        avirt = bc3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bc[2] = around + bround;
        bc[3] = bc3;
        int axbclen = this.scale_expansion_zeroelim(4, bc, adx, axbc);
        int axxbclen = this.scale_expansion_zeroelim(axbclen, axbc, adx, axxbc);
        int aybclen = this.scale_expansion_zeroelim(4, bc, ady, aybc);
        int ayybclen = this.scale_expansion_zeroelim(aybclen, aybc, ady, ayybc);
        int alen = this.fast_expansion_sum_zeroelim(axxbclen, axxbc, ayybclen, ayybc, adet);
        double cdxady1 = cdx * ady;
        c = this.splitter * cdx;
        abig = c - cdx;
        ahi = c - abig;
        alo = cdx - ahi;
        c = this.splitter * ady;
        abig = c - ady;
        bhi = c - abig;
        blo = ady - bhi;
        err1 = cdxady1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cdxady0 = alo * blo - err3;
        double adxcdy1 = adx * cdy;
        c = this.splitter * adx;
        abig = c - adx;
        ahi = c - abig;
        alo = adx - ahi;
        c = this.splitter * cdy;
        abig = c - cdy;
        bhi = c - abig;
        blo = cdy - bhi;
        err1 = adxcdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double adxcdy0 = alo * blo - err3;
        _i = cdxady0 - adxcdy0;
        bvirt = cdxady0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - adxcdy0;
        around = cdxady0 - avirt;
        ca[0] = around + bround;
        _j = cdxady1 + _i;
        bvirt = _j - cdxady1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cdxady1 - avirt;
        _0 = around + bround;
        _i = _0 - adxcdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - adxcdy1;
        around = _0 - avirt;
        ca[1] = around + bround;
        double ca3 = _j + _i;
        bvirt = ca3 - _j;
        avirt = ca3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ca[2] = around + bround;
        ca[3] = ca3;
        int bxcalen = this.scale_expansion_zeroelim(4, ca, bdx, bxca);
        int bxxcalen = this.scale_expansion_zeroelim(bxcalen, bxca, bdx, bxxca);
        int bycalen = this.scale_expansion_zeroelim(4, ca, bdy, byca);
        int byycalen = this.scale_expansion_zeroelim(bycalen, byca, bdy, byyca);
        int blen = this.fast_expansion_sum_zeroelim(bxxcalen, bxxca, byycalen, byyca, bdet);
        double adxbdy1 = adx * bdy;
        c = this.splitter * adx;
        abig = c - adx;
        ahi = c - abig;
        alo = adx - ahi;
        c = this.splitter * bdy;
        abig = c - bdy;
        bhi = c - abig;
        blo = bdy - bhi;
        err1 = adxbdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double adxbdy0 = alo * blo - err3;
        double bdxady1 = bdx * ady;
        c = this.splitter * bdx;
        abig = c - bdx;
        ahi = c - abig;
        alo = bdx - ahi;
        c = this.splitter * ady;
        abig = c - ady;
        bhi = c - abig;
        blo = ady - bhi;
        err1 = bdxady1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bdxady0 = alo * blo - err3;
        _i = adxbdy0 - bdxady0;
        bvirt = adxbdy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bdxady0;
        around = adxbdy0 - avirt;
        ab[0] = around + bround;
        _j = adxbdy1 + _i;
        bvirt = _j - adxbdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = adxbdy1 - avirt;
        _0 = around + bround;
        _i = _0 - bdxady1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bdxady1;
        around = _0 - avirt;
        ab[1] = around + bround;
        double ab3 = _j + _i;
        bvirt = ab3 - _j;
        avirt = ab3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ab[2] = around + bround;
        ab[3] = ab3;
        int cxablen = this.scale_expansion_zeroelim(4, ab, cdx, cxab);
        int cxxablen = this.scale_expansion_zeroelim(cxablen, cxab, cdx, cxxab);
        int cyablen = this.scale_expansion_zeroelim(4, ab, cdy, cyab);
        int cyyablen = this.scale_expansion_zeroelim(cyablen, cyab, cdy, cyyab);
        int clen = this.fast_expansion_sum_zeroelim(cxxablen, cxxab, cyyablen, cyyab, cdet);
        int ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        int finlength = this.fast_expansion_sum_zeroelim(ablen, abdet, clen, cdet, fin1);
        double det = this.estimate(finlength, fin1);
        if (det >= (errbound = this.iccerrboundB * permanent) || -det >= errbound) {
            return det;
        }
        bvirt = pa[0] - adx;
        avirt = adx + bvirt;
        bround = bvirt - pd[0];
        around = pa[0] - avirt;
        double adxtail = around + bround;
        bvirt = pa[1] - ady;
        avirt = ady + bvirt;
        bround = bvirt - pd[1];
        around = pa[1] - avirt;
        double adytail = around + bround;
        bvirt = pb[0] - bdx;
        avirt = bdx + bvirt;
        bround = bvirt - pd[0];
        around = pb[0] - avirt;
        double bdxtail = around + bround;
        bvirt = pb[1] - bdy;
        avirt = bdy + bvirt;
        bround = bvirt - pd[1];
        around = pb[1] - avirt;
        double bdytail = around + bround;
        bvirt = pc[0] - cdx;
        avirt = cdx + bvirt;
        bround = bvirt - pd[0];
        around = pc[0] - avirt;
        double cdxtail = around + bround;
        bvirt = pc[1] - cdy;
        avirt = cdy + bvirt;
        bround = bvirt - pd[1];
        around = pc[1] - avirt;
        double cdytail = around + bround;
        if (adxtail == 0.0 && bdxtail == 0.0 && cdxtail == 0.0 && adytail == 0.0 && bdytail == 0.0 && cdytail == 0.0) {
            return det;
        }
        errbound = this.iccerrboundC * permanent + this.resulterrbound * (det >= 0.0 ? det : -det);
        if ((det += (adx * adx + ady * ady) * (bdx * cdytail + cdy * bdxtail - (bdy * cdxtail + cdx * bdytail)) + 2.0 * (adx * adxtail + ady * adytail) * (bdx * cdy - bdy * cdx) + ((bdx * bdx + bdy * bdy) * (cdx * adytail + ady * cdxtail - (cdy * adxtail + adx * cdytail)) + 2.0 * (bdx * bdxtail + bdy * bdytail) * (cdx * ady - cdy * adx)) + ((cdx * cdx + cdy * cdy) * (adx * bdytail + bdy * adxtail - (ady * bdxtail + bdx * adytail)) + 2.0 * (cdx * cdxtail + cdy * cdytail) * (adx * bdy - ady * bdx))) >= errbound || -det >= errbound) {
            return det;
        }
        double[] finnow = fin1;
        double[] finother = fin2;
        if (bdxtail != 0.0 || bdytail != 0.0 || cdxtail != 0.0 || cdytail != 0.0) {
            double adxadx1 = adx * adx;
            c = this.splitter * adx;
            abig = c - adx;
            ahi = c - abig;
            alo = adx - ahi;
            err1 = adxadx1 - ahi * ahi;
            err3 = err1 - (ahi + ahi) * alo;
            double adxadx0 = alo * alo - err3;
            double adyady1 = ady * ady;
            c = this.splitter * ady;
            abig = c - ady;
            ahi = c - abig;
            alo = ady - ahi;
            err1 = adyady1 - ahi * ahi;
            err3 = err1 - (ahi + ahi) * alo;
            double adyady0 = alo * alo - err3;
            _i = adxadx0 + adyady0;
            bvirt = _i - adxadx0;
            avirt = _i - bvirt;
            bround = adyady0 - bvirt;
            around = adxadx0 - avirt;
            aa[0] = around + bround;
            _j = adxadx1 + _i;
            bvirt = _j - adxadx1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = adxadx1 - avirt;
            _0 = around + bround;
            _i = _0 + adyady1;
            bvirt = _i - _0;
            avirt = _i - bvirt;
            bround = adyady1 - bvirt;
            around = _0 - avirt;
            aa[1] = around + bround;
            double aa3 = _j + _i;
            bvirt = aa3 - _j;
            avirt = aa3 - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            aa[2] = around + bround;
            aa[3] = aa3;
        }
        if (cdxtail != 0.0 || cdytail != 0.0 || adxtail != 0.0 || adytail != 0.0) {
            double bdxbdx1 = bdx * bdx;
            c = this.splitter * bdx;
            abig = c - bdx;
            ahi = c - abig;
            alo = bdx - ahi;
            err1 = bdxbdx1 - ahi * ahi;
            err3 = err1 - (ahi + ahi) * alo;
            double bdxbdx0 = alo * alo - err3;
            double bdybdy1 = bdy * bdy;
            c = this.splitter * bdy;
            abig = c - bdy;
            ahi = c - abig;
            alo = bdy - ahi;
            err1 = bdybdy1 - ahi * ahi;
            err3 = err1 - (ahi + ahi) * alo;
            double bdybdy0 = alo * alo - err3;
            _i = bdxbdx0 + bdybdy0;
            bvirt = _i - bdxbdx0;
            avirt = _i - bvirt;
            bround = bdybdy0 - bvirt;
            around = bdxbdx0 - avirt;
            bb[0] = around + bround;
            _j = bdxbdx1 + _i;
            bvirt = _j - bdxbdx1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = bdxbdx1 - avirt;
            _0 = around + bround;
            _i = _0 + bdybdy1;
            bvirt = _i - _0;
            avirt = _i - bvirt;
            bround = bdybdy1 - bvirt;
            around = _0 - avirt;
            bb[1] = around + bround;
            double bb3 = _j + _i;
            bvirt = bb3 - _j;
            avirt = bb3 - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            bb[2] = around + bround;
            bb[3] = bb3;
        }
        if (adxtail != 0.0 || adytail != 0.0 || bdxtail != 0.0 || bdytail != 0.0) {
            double cdxcdx1 = cdx * cdx;
            c = this.splitter * cdx;
            abig = c - cdx;
            ahi = c - abig;
            alo = cdx - ahi;
            err1 = cdxcdx1 - ahi * ahi;
            err3 = err1 - (ahi + ahi) * alo;
            double cdxcdx0 = alo * alo - err3;
            double cdycdy1 = cdy * cdy;
            c = this.splitter * cdy;
            abig = c - cdy;
            ahi = c - abig;
            alo = cdy - ahi;
            err1 = cdycdy1 - ahi * ahi;
            err3 = err1 - (ahi + ahi) * alo;
            double cdycdy0 = alo * alo - err3;
            _i = cdxcdx0 + cdycdy0;
            bvirt = _i - cdxcdx0;
            avirt = _i - bvirt;
            bround = cdycdy0 - bvirt;
            around = cdxcdx0 - avirt;
            cc[0] = around + bround;
            _j = cdxcdx1 + _i;
            bvirt = _j - cdxcdx1;
            avirt = _j - bvirt;
            bround = _i - bvirt;
            around = cdxcdx1 - avirt;
            _0 = around + bround;
            _i = _0 + cdycdy1;
            bvirt = _i - _0;
            avirt = _i - bvirt;
            bround = cdycdy1 - bvirt;
            around = _0 - avirt;
            cc[1] = around + bround;
            double cc3 = _j + _i;
            bvirt = cc3 - _j;
            avirt = cc3 - bvirt;
            bround = _i - bvirt;
            around = _j - avirt;
            cc[2] = around + bround;
            cc[3] = cc3;
        }
        if (adxtail != 0.0) {
            axtbclen = this.scale_expansion_zeroelim(4, bc, adxtail, axtbc);
            temp16alen = this.scale_expansion_zeroelim(axtbclen, axtbc, 2.0 * adx, temp16a);
            int axtcclen = this.scale_expansion_zeroelim(4, cc, adxtail, axtcc);
            temp16blen = this.scale_expansion_zeroelim(axtcclen, axtcc, bdy, temp16b);
            int axtbblen = this.scale_expansion_zeroelim(4, bb, adxtail, axtbb);
            temp16clen = this.scale_expansion_zeroelim(axtbblen, axtbb, -cdy, temp16c);
            temp32alen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32a);
            temp48len = this.fast_expansion_sum_zeroelim(temp16clen, temp16c, temp32alen, temp32a, temp48);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (adytail != 0.0) {
            aytbclen = this.scale_expansion_zeroelim(4, bc, adytail, aytbc);
            temp16alen = this.scale_expansion_zeroelim(aytbclen, aytbc, 2.0 * ady, temp16a);
            int aytbblen = this.scale_expansion_zeroelim(4, bb, adytail, aytbb);
            temp16blen = this.scale_expansion_zeroelim(aytbblen, aytbb, cdx, temp16b);
            int aytcclen = this.scale_expansion_zeroelim(4, cc, adytail, aytcc);
            temp16clen = this.scale_expansion_zeroelim(aytcclen, aytcc, -bdx, temp16c);
            temp32alen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32a);
            temp48len = this.fast_expansion_sum_zeroelim(temp16clen, temp16c, temp32alen, temp32a, temp48);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (bdxtail != 0.0) {
            bxtcalen = this.scale_expansion_zeroelim(4, ca, bdxtail, bxtca);
            temp16alen = this.scale_expansion_zeroelim(bxtcalen, bxtca, 2.0 * bdx, temp16a);
            int bxtaalen = this.scale_expansion_zeroelim(4, aa, bdxtail, bxtaa);
            temp16blen = this.scale_expansion_zeroelim(bxtaalen, bxtaa, cdy, temp16b);
            int bxtcclen = this.scale_expansion_zeroelim(4, cc, bdxtail, bxtcc);
            temp16clen = this.scale_expansion_zeroelim(bxtcclen, bxtcc, -ady, temp16c);
            temp32alen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32a);
            temp48len = this.fast_expansion_sum_zeroelim(temp16clen, temp16c, temp32alen, temp32a, temp48);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (bdytail != 0.0) {
            bytcalen = this.scale_expansion_zeroelim(4, ca, bdytail, bytca);
            temp16alen = this.scale_expansion_zeroelim(bytcalen, bytca, 2.0 * bdy, temp16a);
            int bytcclen = this.scale_expansion_zeroelim(4, cc, bdytail, bytcc);
            temp16blen = this.scale_expansion_zeroelim(bytcclen, bytcc, adx, temp16b);
            int bytaalen = this.scale_expansion_zeroelim(4, aa, bdytail, bytaa);
            temp16clen = this.scale_expansion_zeroelim(bytaalen, bytaa, -cdx, temp16c);
            temp32alen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32a);
            temp48len = this.fast_expansion_sum_zeroelim(temp16clen, temp16c, temp32alen, temp32a, temp48);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (cdxtail != 0.0) {
            cxtablen = this.scale_expansion_zeroelim(4, ab, cdxtail, cxtab);
            temp16alen = this.scale_expansion_zeroelim(cxtablen, cxtab, 2.0 * cdx, temp16a);
            int cxtbblen = this.scale_expansion_zeroelim(4, bb, cdxtail, cxtbb);
            temp16blen = this.scale_expansion_zeroelim(cxtbblen, cxtbb, ady, temp16b);
            int cxtaalen = this.scale_expansion_zeroelim(4, aa, cdxtail, cxtaa);
            temp16clen = this.scale_expansion_zeroelim(cxtaalen, cxtaa, -bdy, temp16c);
            temp32alen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32a);
            temp48len = this.fast_expansion_sum_zeroelim(temp16clen, temp16c, temp32alen, temp32a, temp48);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (cdytail != 0.0) {
            cytablen = this.scale_expansion_zeroelim(4, ab, cdytail, cytab);
            temp16alen = this.scale_expansion_zeroelim(cytablen, cytab, 2.0 * cdy, temp16a);
            int cytaalen = this.scale_expansion_zeroelim(4, aa, cdytail, cytaa);
            temp16blen = this.scale_expansion_zeroelim(cytaalen, cytaa, bdx, temp16b);
            int cytbblen = this.scale_expansion_zeroelim(4, bb, cdytail, cytbb);
            temp16clen = this.scale_expansion_zeroelim(cytbblen, cytbb, -adx, temp16c);
            temp32alen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32a);
            temp48len = this.fast_expansion_sum_zeroelim(temp16clen, temp16c, temp32alen, temp32a, temp48);
            finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
            finswap = finnow;
            finnow = finother;
            finother = finswap;
        }
        if (adxtail != 0.0 || adytail != 0.0) {
            int bcttlen;
            int bctlen;
            if (bdxtail != 0.0 || bdytail != 0.0 || cdxtail != 0.0 || cdytail != 0.0) {
                ti1 = bdxtail * cdy;
                c = this.splitter * bdxtail;
                abig = c - bdxtail;
                ahi = c - abig;
                alo = bdxtail - ahi;
                c = this.splitter * cdy;
                abig = c - cdy;
                bhi = c - abig;
                blo = cdy - bhi;
                err1 = ti1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ti0 = alo * blo - err3;
                tj1 = bdx * cdytail;
                c = this.splitter * bdx;
                abig = c - bdx;
                ahi = c - abig;
                alo = bdx - ahi;
                c = this.splitter * cdytail;
                abig = c - cdytail;
                bhi = c - abig;
                blo = cdytail - bhi;
                err1 = tj1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                tj0 = alo * blo - err3;
                _i = ti0 + tj0;
                bvirt = _i - ti0;
                avirt = _i - bvirt;
                bround = tj0 - bvirt;
                around = ti0 - avirt;
                u[0] = around + bround;
                _j = ti1 + _i;
                bvirt = _j - ti1;
                avirt = _j - bvirt;
                bround = _i - bvirt;
                around = ti1 - avirt;
                _0 = around + bround;
                _i = _0 + tj1;
                bvirt = _i - _0;
                avirt = _i - bvirt;
                bround = tj1 - bvirt;
                around = _0 - avirt;
                u[1] = around + bround;
                u3 = _j + _i;
                bvirt = u3 - _j;
                avirt = u3 - bvirt;
                bround = _i - bvirt;
                around = _j - avirt;
                u[2] = around + bround;
                u[3] = u3;
                negate = -bdy;
                ti1 = cdxtail * negate;
                c = this.splitter * cdxtail;
                abig = c - cdxtail;
                ahi = c - abig;
                alo = cdxtail - ahi;
                c = this.splitter * negate;
                abig = c - negate;
                bhi = c - abig;
                blo = negate - bhi;
                err1 = ti1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ti0 = alo * blo - err3;
                negate = -bdytail;
                tj1 = cdx * negate;
                c = this.splitter * cdx;
                abig = c - cdx;
                ahi = c - abig;
                alo = cdx - ahi;
                c = this.splitter * negate;
                abig = c - negate;
                bhi = c - abig;
                blo = negate - bhi;
                err1 = tj1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                tj0 = alo * blo - err3;
                _i = ti0 + tj0;
                bvirt = _i - ti0;
                avirt = _i - bvirt;
                bround = tj0 - bvirt;
                around = ti0 - avirt;
                v[0] = around + bround;
                _j = ti1 + _i;
                bvirt = _j - ti1;
                avirt = _j - bvirt;
                bround = _i - bvirt;
                around = ti1 - avirt;
                _0 = around + bround;
                _i = _0 + tj1;
                bvirt = _i - _0;
                avirt = _i - bvirt;
                bround = tj1 - bvirt;
                around = _0 - avirt;
                v[1] = around + bround;
                v3 = _j + _i;
                bvirt = v3 - _j;
                avirt = v3 - bvirt;
                bround = _i - bvirt;
                around = _j - avirt;
                v[2] = around + bround;
                v[3] = v3;
                bctlen = this.fast_expansion_sum_zeroelim(4, u, 4, v, bct);
                ti1 = bdxtail * cdytail;
                c = this.splitter * bdxtail;
                abig = c - bdxtail;
                ahi = c - abig;
                alo = bdxtail - ahi;
                c = this.splitter * cdytail;
                abig = c - cdytail;
                bhi = c - abig;
                blo = cdytail - bhi;
                err1 = ti1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ti0 = alo * blo - err3;
                tj1 = cdxtail * bdytail;
                c = this.splitter * cdxtail;
                abig = c - cdxtail;
                ahi = c - abig;
                alo = cdxtail - ahi;
                c = this.splitter * bdytail;
                abig = c - bdytail;
                bhi = c - abig;
                blo = bdytail - bhi;
                err1 = tj1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                tj0 = alo * blo - err3;
                _i = ti0 - tj0;
                bvirt = ti0 - _i;
                avirt = _i + bvirt;
                bround = bvirt - tj0;
                around = ti0 - avirt;
                bctt[0] = around + bround;
                _j = ti1 + _i;
                bvirt = _j - ti1;
                avirt = _j - bvirt;
                bround = _i - bvirt;
                around = ti1 - avirt;
                _0 = around + bround;
                _i = _0 - tj1;
                bvirt = _0 - _i;
                avirt = _i + bvirt;
                bround = bvirt - tj1;
                around = _0 - avirt;
                bctt[1] = around + bround;
                double bctt3 = _j + _i;
                bvirt = bctt3 - _j;
                avirt = bctt3 - bvirt;
                bround = _i - bvirt;
                around = _j - avirt;
                bctt[2] = around + bround;
                bctt[3] = bctt3;
                bcttlen = 4;
            } else {
                bct[0] = 0.0;
                bctlen = 1;
                bctt[0] = 0.0;
                bcttlen = 1;
            }
            if (adxtail != 0.0) {
                temp16alen = this.scale_expansion_zeroelim(axtbclen, axtbc, adxtail, temp16a);
                int axtbctlen = this.scale_expansion_zeroelim(bctlen, bct, adxtail, axtbct);
                temp32alen = this.scale_expansion_zeroelim(axtbctlen, axtbct, 2.0 * adx, temp32a);
                temp48len = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp32alen, temp32a, temp48);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (bdytail != 0.0) {
                    temp8len = this.scale_expansion_zeroelim(4, cc, adxtail, temp8);
                    temp16alen = this.scale_expansion_zeroelim(temp8len, temp8, bdytail, temp16a);
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp16alen, temp16a, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
                if (cdytail != 0.0) {
                    temp8len = this.scale_expansion_zeroelim(4, bb, -adxtail, temp8);
                    temp16alen = this.scale_expansion_zeroelim(temp8len, temp8, cdytail, temp16a);
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp16alen, temp16a, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
                temp32alen = this.scale_expansion_zeroelim(axtbctlen, axtbct, adxtail, temp32a);
                int axtbcttlen = this.scale_expansion_zeroelim(bcttlen, bctt, adxtail, axtbctt);
                temp16alen = this.scale_expansion_zeroelim(axtbcttlen, axtbctt, 2.0 * adx, temp16a);
                temp16blen = this.scale_expansion_zeroelim(axtbcttlen, axtbctt, adxtail, temp16b);
                temp32blen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32b);
                temp64len = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp64len, temp64, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
            }
            if (adytail != 0.0) {
                temp16alen = this.scale_expansion_zeroelim(aytbclen, aytbc, adytail, temp16a);
                int aytbctlen = this.scale_expansion_zeroelim(bctlen, bct, adytail, aytbct);
                temp32alen = this.scale_expansion_zeroelim(aytbctlen, aytbct, 2.0 * ady, temp32a);
                temp48len = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp32alen, temp32a, temp48);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                temp32alen = this.scale_expansion_zeroelim(aytbctlen, aytbct, adytail, temp32a);
                int aytbcttlen = this.scale_expansion_zeroelim(bcttlen, bctt, adytail, aytbctt);
                temp16alen = this.scale_expansion_zeroelim(aytbcttlen, aytbctt, 2.0 * ady, temp16a);
                temp16blen = this.scale_expansion_zeroelim(aytbcttlen, aytbctt, adytail, temp16b);
                temp32blen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32b);
                temp64len = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp64len, temp64, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
            }
        }
        if (bdxtail != 0.0 || bdytail != 0.0) {
            int cattlen;
            int catlen;
            if (cdxtail != 0.0 || cdytail != 0.0 || adxtail != 0.0 || adytail != 0.0) {
                ti1 = cdxtail * ady;
                c = this.splitter * cdxtail;
                abig = c - cdxtail;
                ahi = c - abig;
                alo = cdxtail - ahi;
                c = this.splitter * ady;
                abig = c - ady;
                bhi = c - abig;
                blo = ady - bhi;
                err1 = ti1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ti0 = alo * blo - err3;
                tj1 = cdx * adytail;
                c = this.splitter * cdx;
                abig = c - cdx;
                ahi = c - abig;
                alo = cdx - ahi;
                c = this.splitter * adytail;
                abig = c - adytail;
                bhi = c - abig;
                blo = adytail - bhi;
                err1 = tj1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                tj0 = alo * blo - err3;
                _i = ti0 + tj0;
                bvirt = _i - ti0;
                avirt = _i - bvirt;
                bround = tj0 - bvirt;
                around = ti0 - avirt;
                u[0] = around + bround;
                _j = ti1 + _i;
                bvirt = _j - ti1;
                avirt = _j - bvirt;
                bround = _i - bvirt;
                around = ti1 - avirt;
                _0 = around + bround;
                _i = _0 + tj1;
                bvirt = _i - _0;
                avirt = _i - bvirt;
                bround = tj1 - bvirt;
                around = _0 - avirt;
                u[1] = around + bround;
                u3 = _j + _i;
                bvirt = u3 - _j;
                avirt = u3 - bvirt;
                bround = _i - bvirt;
                around = _j - avirt;
                u[2] = around + bround;
                u[3] = u3;
                negate = -cdy;
                ti1 = adxtail * negate;
                c = this.splitter * adxtail;
                abig = c - adxtail;
                ahi = c - abig;
                alo = adxtail - ahi;
                c = this.splitter * negate;
                abig = c - negate;
                bhi = c - abig;
                blo = negate - bhi;
                err1 = ti1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ti0 = alo * blo - err3;
                negate = -cdytail;
                tj1 = adx * negate;
                c = this.splitter * adx;
                abig = c - adx;
                ahi = c - abig;
                alo = adx - ahi;
                c = this.splitter * negate;
                abig = c - negate;
                bhi = c - abig;
                blo = negate - bhi;
                err1 = tj1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                tj0 = alo * blo - err3;
                _i = ti0 + tj0;
                bvirt = _i - ti0;
                avirt = _i - bvirt;
                bround = tj0 - bvirt;
                around = ti0 - avirt;
                v[0] = around + bround;
                _j = ti1 + _i;
                bvirt = _j - ti1;
                avirt = _j - bvirt;
                bround = _i - bvirt;
                around = ti1 - avirt;
                _0 = around + bround;
                _i = _0 + tj1;
                bvirt = _i - _0;
                avirt = _i - bvirt;
                bround = tj1 - bvirt;
                around = _0 - avirt;
                v[1] = around + bround;
                v3 = _j + _i;
                bvirt = v3 - _j;
                avirt = v3 - bvirt;
                bround = _i - bvirt;
                around = _j - avirt;
                v[2] = around + bround;
                v[3] = v3;
                catlen = this.fast_expansion_sum_zeroelim(4, u, 4, v, cat);
                ti1 = cdxtail * adytail;
                c = this.splitter * cdxtail;
                abig = c - cdxtail;
                ahi = c - abig;
                alo = cdxtail - ahi;
                c = this.splitter * adytail;
                abig = c - adytail;
                bhi = c - abig;
                blo = adytail - bhi;
                err1 = ti1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ti0 = alo * blo - err3;
                tj1 = adxtail * cdytail;
                c = this.splitter * adxtail;
                abig = c - adxtail;
                ahi = c - abig;
                alo = adxtail - ahi;
                c = this.splitter * cdytail;
                abig = c - cdytail;
                bhi = c - abig;
                blo = cdytail - bhi;
                err1 = tj1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                tj0 = alo * blo - err3;
                _i = ti0 - tj0;
                bvirt = ti0 - _i;
                avirt = _i + bvirt;
                bround = bvirt - tj0;
                around = ti0 - avirt;
                catt[0] = around + bround;
                _j = ti1 + _i;
                bvirt = _j - ti1;
                avirt = _j - bvirt;
                bround = _i - bvirt;
                around = ti1 - avirt;
                _0 = around + bround;
                _i = _0 - tj1;
                bvirt = _0 - _i;
                avirt = _i + bvirt;
                bround = bvirt - tj1;
                around = _0 - avirt;
                catt[1] = around + bround;
                double catt3 = _j + _i;
                bvirt = catt3 - _j;
                avirt = catt3 - bvirt;
                bround = _i - bvirt;
                around = _j - avirt;
                catt[2] = around + bround;
                catt[3] = catt3;
                cattlen = 4;
            } else {
                cat[0] = 0.0;
                catlen = 1;
                catt[0] = 0.0;
                cattlen = 1;
            }
            if (bdxtail != 0.0) {
                temp16alen = this.scale_expansion_zeroelim(bxtcalen, bxtca, bdxtail, temp16a);
                int bxtcatlen = this.scale_expansion_zeroelim(catlen, cat, bdxtail, bxtcat);
                temp32alen = this.scale_expansion_zeroelim(bxtcatlen, bxtcat, 2.0 * bdx, temp32a);
                temp48len = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp32alen, temp32a, temp48);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (cdytail != 0.0) {
                    temp8len = this.scale_expansion_zeroelim(4, aa, bdxtail, temp8);
                    temp16alen = this.scale_expansion_zeroelim(temp8len, temp8, cdytail, temp16a);
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp16alen, temp16a, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
                if (adytail != 0.0) {
                    temp8len = this.scale_expansion_zeroelim(4, cc, -bdxtail, temp8);
                    temp16alen = this.scale_expansion_zeroelim(temp8len, temp8, adytail, temp16a);
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp16alen, temp16a, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
                temp32alen = this.scale_expansion_zeroelim(bxtcatlen, bxtcat, bdxtail, temp32a);
                int bxtcattlen = this.scale_expansion_zeroelim(cattlen, catt, bdxtail, bxtcatt);
                temp16alen = this.scale_expansion_zeroelim(bxtcattlen, bxtcatt, 2.0 * bdx, temp16a);
                temp16blen = this.scale_expansion_zeroelim(bxtcattlen, bxtcatt, bdxtail, temp16b);
                temp32blen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32b);
                temp64len = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp64len, temp64, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
            }
            if (bdytail != 0.0) {
                temp16alen = this.scale_expansion_zeroelim(bytcalen, bytca, bdytail, temp16a);
                int bytcatlen = this.scale_expansion_zeroelim(catlen, cat, bdytail, bytcat);
                temp32alen = this.scale_expansion_zeroelim(bytcatlen, bytcat, 2.0 * bdy, temp32a);
                temp48len = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp32alen, temp32a, temp48);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                temp32alen = this.scale_expansion_zeroelim(bytcatlen, bytcat, bdytail, temp32a);
                int bytcattlen = this.scale_expansion_zeroelim(cattlen, catt, bdytail, bytcatt);
                temp16alen = this.scale_expansion_zeroelim(bytcattlen, bytcatt, 2.0 * bdy, temp16a);
                temp16blen = this.scale_expansion_zeroelim(bytcattlen, bytcatt, bdytail, temp16b);
                temp32blen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32b);
                temp64len = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp64len, temp64, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
            }
        }
        if (cdxtail != 0.0 || cdytail != 0.0) {
            int abttlen;
            int abtlen;
            if (adxtail != 0.0 || adytail != 0.0 || bdxtail != 0.0 || bdytail != 0.0) {
                ti1 = adxtail * bdy;
                c = this.splitter * adxtail;
                abig = c - adxtail;
                ahi = c - abig;
                alo = adxtail - ahi;
                c = this.splitter * bdy;
                abig = c - bdy;
                bhi = c - abig;
                blo = bdy - bhi;
                err1 = ti1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ti0 = alo * blo - err3;
                tj1 = adx * bdytail;
                c = this.splitter * adx;
                abig = c - adx;
                ahi = c - abig;
                alo = adx - ahi;
                c = this.splitter * bdytail;
                abig = c - bdytail;
                bhi = c - abig;
                blo = bdytail - bhi;
                err1 = tj1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                tj0 = alo * blo - err3;
                _i = ti0 + tj0;
                bvirt = _i - ti0;
                avirt = _i - bvirt;
                bround = tj0 - bvirt;
                around = ti0 - avirt;
                u[0] = around + bround;
                _j = ti1 + _i;
                bvirt = _j - ti1;
                avirt = _j - bvirt;
                bround = _i - bvirt;
                around = ti1 - avirt;
                _0 = around + bround;
                _i = _0 + tj1;
                bvirt = _i - _0;
                avirt = _i - bvirt;
                bround = tj1 - bvirt;
                around = _0 - avirt;
                u[1] = around + bround;
                u3 = _j + _i;
                bvirt = u3 - _j;
                avirt = u3 - bvirt;
                bround = _i - bvirt;
                around = _j - avirt;
                u[2] = around + bround;
                u[3] = u3;
                negate = -ady;
                ti1 = bdxtail * negate;
                c = this.splitter * bdxtail;
                abig = c - bdxtail;
                ahi = c - abig;
                alo = bdxtail - ahi;
                c = this.splitter * negate;
                abig = c - negate;
                bhi = c - abig;
                blo = negate - bhi;
                err1 = ti1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ti0 = alo * blo - err3;
                negate = -adytail;
                tj1 = bdx * negate;
                c = this.splitter * bdx;
                abig = c - bdx;
                ahi = c - abig;
                alo = bdx - ahi;
                c = this.splitter * negate;
                abig = c - negate;
                bhi = c - abig;
                blo = negate - bhi;
                err1 = tj1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                tj0 = alo * blo - err3;
                _i = ti0 + tj0;
                bvirt = _i - ti0;
                avirt = _i - bvirt;
                bround = tj0 - bvirt;
                around = ti0 - avirt;
                v[0] = around + bround;
                _j = ti1 + _i;
                bvirt = _j - ti1;
                avirt = _j - bvirt;
                bround = _i - bvirt;
                around = ti1 - avirt;
                _0 = around + bround;
                _i = _0 + tj1;
                bvirt = _i - _0;
                avirt = _i - bvirt;
                bround = tj1 - bvirt;
                around = _0 - avirt;
                v[1] = around + bround;
                v3 = _j + _i;
                bvirt = v3 - _j;
                avirt = v3 - bvirt;
                bround = _i - bvirt;
                around = _j - avirt;
                v[2] = around + bround;
                v[3] = v3;
                abtlen = this.fast_expansion_sum_zeroelim(4, u, 4, v, abt);
                ti1 = adxtail * bdytail;
                c = this.splitter * adxtail;
                abig = c - adxtail;
                ahi = c - abig;
                alo = adxtail - ahi;
                c = this.splitter * bdytail;
                abig = c - bdytail;
                bhi = c - abig;
                blo = bdytail - bhi;
                err1 = ti1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                ti0 = alo * blo - err3;
                tj1 = bdxtail * adytail;
                c = this.splitter * bdxtail;
                abig = c - bdxtail;
                ahi = c - abig;
                alo = bdxtail - ahi;
                c = this.splitter * adytail;
                abig = c - adytail;
                bhi = c - abig;
                blo = adytail - bhi;
                err1 = tj1 - ahi * bhi;
                err2 = err1 - alo * bhi;
                err3 = err2 - ahi * blo;
                tj0 = alo * blo - err3;
                _i = ti0 - tj0;
                bvirt = ti0 - _i;
                avirt = _i + bvirt;
                bround = bvirt - tj0;
                around = ti0 - avirt;
                abtt[0] = around + bround;
                _j = ti1 + _i;
                bvirt = _j - ti1;
                avirt = _j - bvirt;
                bround = _i - bvirt;
                around = ti1 - avirt;
                _0 = around + bround;
                _i = _0 - tj1;
                bvirt = _0 - _i;
                avirt = _i + bvirt;
                bround = bvirt - tj1;
                around = _0 - avirt;
                abtt[1] = around + bround;
                double abtt3 = _j + _i;
                bvirt = abtt3 - _j;
                avirt = abtt3 - bvirt;
                bround = _i - bvirt;
                around = _j - avirt;
                abtt[2] = around + bround;
                abtt[3] = abtt3;
                abttlen = 4;
            } else {
                abt[0] = 0.0;
                abtlen = 1;
                abtt[0] = 0.0;
                abttlen = 1;
            }
            if (cdxtail != 0.0) {
                temp16alen = this.scale_expansion_zeroelim(cxtablen, cxtab, cdxtail, temp16a);
                int cxtabtlen = this.scale_expansion_zeroelim(abtlen, abt, cdxtail, cxtabt);
                temp32alen = this.scale_expansion_zeroelim(cxtabtlen, cxtabt, 2.0 * cdx, temp32a);
                temp48len = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp32alen, temp32a, temp48);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                if (adytail != 0.0) {
                    temp8len = this.scale_expansion_zeroelim(4, bb, cdxtail, temp8);
                    temp16alen = this.scale_expansion_zeroelim(temp8len, temp8, adytail, temp16a);
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp16alen, temp16a, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
                if (bdytail != 0.0) {
                    temp8len = this.scale_expansion_zeroelim(4, aa, -cdxtail, temp8);
                    temp16alen = this.scale_expansion_zeroelim(temp8len, temp8, bdytail, temp16a);
                    finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp16alen, temp16a, finother);
                    finswap = finnow;
                    finnow = finother;
                    finother = finswap;
                }
                temp32alen = this.scale_expansion_zeroelim(cxtabtlen, cxtabt, cdxtail, temp32a);
                int cxtabttlen = this.scale_expansion_zeroelim(abttlen, abtt, cdxtail, cxtabtt);
                temp16alen = this.scale_expansion_zeroelim(cxtabttlen, cxtabtt, 2.0 * cdx, temp16a);
                temp16blen = this.scale_expansion_zeroelim(cxtabttlen, cxtabtt, cdxtail, temp16b);
                temp32blen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32b);
                temp64len = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp64len, temp64, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
            }
            if (cdytail != 0.0) {
                temp16alen = this.scale_expansion_zeroelim(cytablen, cytab, cdytail, temp16a);
                int cytabtlen = this.scale_expansion_zeroelim(abtlen, abt, cdytail, cytabt);
                temp32alen = this.scale_expansion_zeroelim(cytabtlen, cytabt, 2.0 * cdy, temp32a);
                temp48len = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp32alen, temp32a, temp48);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp48len, temp48, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
                temp32alen = this.scale_expansion_zeroelim(cytabtlen, cytabt, cdytail, temp32a);
                int cytabttlen = this.scale_expansion_zeroelim(abttlen, abtt, cdytail, cytabtt);
                temp16alen = this.scale_expansion_zeroelim(cytabttlen, cytabtt, 2.0 * cdy, temp16a);
                temp16blen = this.scale_expansion_zeroelim(cytabttlen, cytabtt, cdytail, temp16b);
                temp32blen = this.fast_expansion_sum_zeroelim(temp16alen, temp16a, temp16blen, temp16b, temp32b);
                temp64len = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64);
                finlength = this.fast_expansion_sum_zeroelim(finlength, finnow, temp64len, temp64, finother);
                finswap = finnow;
                finnow = finother;
                finother = finswap;
            }
        }
        return finnow[finlength - 1];
    }

    public double incircle(double[] pa, double[] pb, double[] pc, double[] pd) {
        double adx = pa[0] - pd[0];
        double ady = pa[1] - pd[1];
        double alift = adx * adx + ady * ady;
        double bdx = pb[0] - pd[0];
        double cdy = pc[1] - pd[1];
        double bdxcdy = bdx * cdy;
        double cdx = pc[0] - pd[0];
        double bdy = pb[1] - pd[1];
        double cdxbdy = cdx * bdy;
        double blift = bdx * bdx + bdy * bdy;
        double cdxady = cdx * ady;
        double adxcdy = adx * cdy;
        double clift = cdx * cdx + cdy * cdy;
        double adxbdy = adx * bdy;
        double bdxady = bdx * ady;
        double det = alift * (bdxcdy - cdxbdy) + blift * (cdxady - adxcdy) + clift * (adxbdy - bdxady);
        double permanent = ((bdxcdy >= 0.0 ? bdxcdy : -bdxcdy) + (cdxbdy >= 0.0 ? cdxbdy : -cdxbdy)) * alift + ((cdxady >= 0.0 ? cdxady : -cdxady) + (adxcdy >= 0.0 ? adxcdy : -adxcdy)) * blift + ((adxbdy >= 0.0 ? adxbdy : -adxbdy) + (bdxady >= 0.0 ? bdxady : -bdxady)) * clift;
        double errbound = this.iccerrboundA * permanent;
        if (det > errbound || -det > errbound) {
            return det;
        }
        return this.incircleadapt(pa, pb, pc, pd, permanent);
    }

    double inspherefast(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe) {
        double aex = pa[0] - pe[0];
        double bex = pb[0] - pe[0];
        double cex = pc[0] - pe[0];
        double dex = pd[0] - pe[0];
        double aey = pa[1] - pe[1];
        double bey = pb[1] - pe[1];
        double cey = pc[1] - pe[1];
        double dey = pd[1] - pe[1];
        double aez = pa[2] - pe[2];
        double bez = pb[2] - pe[2];
        double cez = pc[2] - pe[2];
        double dez = pd[2] - pe[2];
        double ab = aex * bey - bex * aey;
        double bc = bex * cey - cex * bey;
        double cd = cex * dey - dex * cey;
        double da = dex * aey - aex * dey;
        double ac = aex * cey - cex * aey;
        double bd = bex * dey - dex * bey;
        double abc = aez * bc - bez * ac + cez * ab;
        double bcd = bez * cd - cez * bd + dez * bc;
        double cda = cez * da + dez * ac + aez * cd;
        double dab = dez * ab + aez * bd + bez * da;
        double alift = aex * aex + aey * aey + aez * aez;
        double blift = bex * bex + bey * bey + bez * bez;
        double clift = cex * cex + cey * cey + cez * cez;
        double dlift = dex * dex + dey * dey + dez * dez;
        return dlift * abc - clift * dab + (blift * cda - alift * bcd);
    }

    double insphereexact(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe) {
        int i;
        double[] ab = new double[4];
        double[] bc = new double[4];
        double[] cd = new double[4];
        double[] de = new double[4];
        double[] ea = new double[4];
        double[] ac = new double[4];
        double[] bd = new double[4];
        double[] ce = new double[4];
        double[] da = new double[4];
        double[] eb = new double[4];
        double[] temp8a = new double[8];
        double[] temp8b = new double[8];
        double[] temp16 = new double[16];
        double[] abc = new double[24];
        double[] bcd = new double[24];
        double[] cde = new double[24];
        double[] dea = new double[24];
        double[] eab = new double[24];
        double[] abd = new double[24];
        double[] bce = new double[24];
        double[] cda = new double[24];
        double[] deb = new double[24];
        double[] eac = new double[24];
        double[] temp48a = new double[48];
        double[] temp48b = new double[48];
        double[] abcd = new double[96];
        double[] bcde = new double[96];
        double[] cdea = new double[96];
        double[] deab = new double[96];
        double[] eabc = new double[96];
        double[] temp192 = new double[192];
        double[] det384x = new double[384];
        double[] det384y = new double[384];
        double[] det384z = new double[384];
        double[] detxy = new double[768];
        double[] adet = new double[1152];
        double[] bdet = new double[1152];
        double[] cdet = new double[1152];
        double[] ddet = new double[1152];
        double[] edet = new double[1152];
        double[] abdet = new double[2304];
        double[] cddet = new double[2304];
        double[] cdedet = new double[3456];
        double[] deter = new double[5760];
        double axby1 = pa[0] * pb[1];
        double c = this.splitter * pa[0];
        double abig = c - pa[0];
        double ahi = c - abig;
        double alo = pa[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        double bhi = c - abig;
        double blo = pb[1] - bhi;
        double err1 = axby1 - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double axby0 = alo * blo - err3;
        double bxay1 = pb[0] * pa[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = bxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxay0 = alo * blo - err3;
        double _i = axby0 - bxay0;
        double bvirt = axby0 - _i;
        double avirt = _i + bvirt;
        double bround = bvirt - bxay0;
        double around = axby0 - avirt;
        ab[0] = around + bround;
        double _j = axby1 + _i;
        bvirt = _j - axby1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = axby1 - avirt;
        double _0 = around + bround;
        _i = _0 - bxay1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bxay1;
        around = _0 - avirt;
        ab[1] = around + bround;
        ab[3] = _j + _i;
        bvirt = ab[3] - _j;
        avirt = ab[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ab[2] = around + bround;
        double bxcy1 = pb[0] * pc[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = bxcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxcy0 = alo * blo - err3;
        double cxby1 = pc[0] * pb[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        bhi = c - abig;
        blo = pb[1] - bhi;
        err1 = cxby1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxby0 = alo * blo - err3;
        _i = bxcy0 - cxby0;
        bvirt = bxcy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxby0;
        around = bxcy0 - avirt;
        bc[0] = around + bround;
        _j = bxcy1 + _i;
        bvirt = _j - bxcy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bxcy1 - avirt;
        _0 = around + bround;
        _i = _0 - cxby1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxby1;
        around = _0 - avirt;
        bc[1] = around + bround;
        bc[3] = _j + _i;
        bvirt = bc[3] - _j;
        avirt = bc[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bc[2] = around + bround;
        double cxdy1 = pc[0] * pd[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = cxdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxdy0 = alo * blo - err3;
        double dxcy1 = pd[0] * pc[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = dxcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxcy0 = alo * blo - err3;
        _i = cxdy0 - dxcy0;
        bvirt = cxdy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxcy0;
        around = cxdy0 - avirt;
        cd[0] = around + bround;
        _j = cxdy1 + _i;
        bvirt = _j - cxdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cxdy1 - avirt;
        _0 = around + bround;
        _i = _0 - dxcy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxcy1;
        around = _0 - avirt;
        cd[1] = around + bround;
        cd[3] = _j + _i;
        bvirt = cd[3] - _j;
        avirt = cd[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        cd[2] = around + bround;
        double dxey1 = pd[0] * pe[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pe[1];
        abig = c - pe[1];
        bhi = c - abig;
        blo = pe[1] - bhi;
        err1 = dxey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxey0 = alo * blo - err3;
        double exdy1 = pe[0] * pd[1];
        c = this.splitter * pe[0];
        abig = c - pe[0];
        ahi = c - abig;
        alo = pe[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = exdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double exdy0 = alo * blo - err3;
        _i = dxey0 - exdy0;
        bvirt = dxey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - exdy0;
        around = dxey0 - avirt;
        de[0] = around + bround;
        _j = dxey1 + _i;
        bvirt = _j - dxey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = dxey1 - avirt;
        _0 = around + bround;
        _i = _0 - exdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - exdy1;
        around = _0 - avirt;
        de[1] = around + bround;
        de[3] = _j + _i;
        bvirt = de[3] - _j;
        avirt = de[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        de[2] = around + bround;
        double exay1 = pe[0] * pa[1];
        c = this.splitter * pe[0];
        abig = c - pe[0];
        ahi = c - abig;
        alo = pe[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = exay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double exay0 = alo * blo - err3;
        double axey1 = pa[0] * pe[1];
        c = this.splitter * pa[0];
        abig = c - pa[0];
        ahi = c - abig;
        alo = pa[0] - ahi;
        c = this.splitter * pe[1];
        abig = c - pe[1];
        bhi = c - abig;
        blo = pe[1] - bhi;
        err1 = axey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double axey0 = alo * blo - err3;
        _i = exay0 - axey0;
        bvirt = exay0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axey0;
        around = exay0 - avirt;
        ea[0] = around + bround;
        _j = exay1 + _i;
        bvirt = _j - exay1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = exay1 - avirt;
        _0 = around + bround;
        _i = _0 - axey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axey1;
        around = _0 - avirt;
        ea[1] = around + bround;
        ea[3] = _j + _i;
        bvirt = ea[3] - _j;
        avirt = ea[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ea[2] = around + bround;
        double axcy1 = pa[0] * pc[1];
        c = this.splitter * pa[0];
        abig = c - pa[0];
        ahi = c - abig;
        alo = pa[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = axcy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double axcy0 = alo * blo - err3;
        double cxay1 = pc[0] * pa[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = cxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxay0 = alo * blo - err3;
        _i = axcy0 - cxay0;
        bvirt = axcy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxay0;
        around = axcy0 - avirt;
        ac[0] = around + bround;
        _j = axcy1 + _i;
        bvirt = _j - axcy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = axcy1 - avirt;
        _0 = around + bround;
        _i = _0 - cxay1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cxay1;
        around = _0 - avirt;
        ac[1] = around + bround;
        ac[3] = _j + _i;
        bvirt = ac[3] - _j;
        avirt = ac[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ac[2] = around + bround;
        double bxdy1 = pb[0] * pd[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = bxdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxdy0 = alo * blo - err3;
        double dxby1 = pd[0] * pb[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        bhi = c - abig;
        blo = pb[1] - bhi;
        err1 = dxby1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxby0 = alo * blo - err3;
        _i = bxdy0 - dxby0;
        bvirt = bxdy0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxby0;
        around = bxdy0 - avirt;
        bd[0] = around + bround;
        _j = bxdy1 + _i;
        bvirt = _j - bxdy1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bxdy1 - avirt;
        _0 = around + bround;
        _i = _0 - dxby1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dxby1;
        around = _0 - avirt;
        bd[1] = around + bround;
        bd[3] = _j + _i;
        bvirt = bd[3] - _j;
        avirt = bd[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bd[2] = around + bround;
        double cxey1 = pc[0] * pe[1];
        c = this.splitter * pc[0];
        abig = c - pc[0];
        ahi = c - abig;
        alo = pc[0] - ahi;
        c = this.splitter * pe[1];
        abig = c - pe[1];
        bhi = c - abig;
        blo = pe[1] - bhi;
        err1 = cxey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cxey0 = alo * blo - err3;
        double excy1 = pe[0] * pc[1];
        c = this.splitter * pe[0];
        abig = c - pe[0];
        ahi = c - abig;
        alo = pe[0] - ahi;
        c = this.splitter * pc[1];
        abig = c - pc[1];
        bhi = c - abig;
        blo = pc[1] - bhi;
        err1 = excy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double excy0 = alo * blo - err3;
        _i = cxey0 - excy0;
        bvirt = cxey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - excy0;
        around = cxey0 - avirt;
        ce[0] = around + bround;
        _j = cxey1 + _i;
        bvirt = _j - cxey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cxey1 - avirt;
        _0 = around + bround;
        _i = _0 - excy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - excy1;
        around = _0 - avirt;
        ce[1] = around + bround;
        ce[3] = _j + _i;
        bvirt = ce[3] - _j;
        avirt = ce[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ce[2] = around + bround;
        double dxay1 = pd[0] * pa[1];
        c = this.splitter * pd[0];
        abig = c - pd[0];
        ahi = c - abig;
        alo = pd[0] - ahi;
        c = this.splitter * pa[1];
        abig = c - pa[1];
        bhi = c - abig;
        blo = pa[1] - bhi;
        err1 = dxay1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dxay0 = alo * blo - err3;
        double axdy1 = pa[0] * pd[1];
        c = this.splitter * pa[0];
        abig = c - pa[0];
        ahi = c - abig;
        alo = pa[0] - ahi;
        c = this.splitter * pd[1];
        abig = c - pd[1];
        bhi = c - abig;
        blo = pd[1] - bhi;
        err1 = axdy1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double axdy0 = alo * blo - err3;
        _i = dxay0 - axdy0;
        bvirt = dxay0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axdy0;
        around = dxay0 - avirt;
        da[0] = around + bround;
        _j = dxay1 + _i;
        bvirt = _j - dxay1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = dxay1 - avirt;
        _0 = around + bround;
        _i = _0 - axdy1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - axdy1;
        around = _0 - avirt;
        da[1] = around + bround;
        da[3] = _j + _i;
        bvirt = da[3] - _j;
        avirt = da[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        da[2] = around + bround;
        double exby1 = pe[0] * pb[1];
        c = this.splitter * pe[0];
        abig = c - pe[0];
        ahi = c - abig;
        alo = pe[0] - ahi;
        c = this.splitter * pb[1];
        abig = c - pb[1];
        bhi = c - abig;
        blo = pb[1] - bhi;
        err1 = exby1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double exby0 = alo * blo - err3;
        double bxey1 = pb[0] * pe[1];
        c = this.splitter * pb[0];
        abig = c - pb[0];
        ahi = c - abig;
        alo = pb[0] - ahi;
        c = this.splitter * pe[1];
        abig = c - pe[1];
        bhi = c - abig;
        blo = pe[1] - bhi;
        err1 = bxey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bxey0 = alo * blo - err3;
        _i = exby0 - bxey0;
        bvirt = exby0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bxey0;
        around = exby0 - avirt;
        eb[0] = around + bround;
        _j = exby1 + _i;
        bvirt = _j - exby1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = exby1 - avirt;
        _0 = around + bround;
        _i = _0 - bxey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bxey1;
        around = _0 - avirt;
        eb[1] = around + bround;
        eb[3] = _j + _i;
        bvirt = eb[3] - _j;
        avirt = eb[3] - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        eb[2] = around + bround;
        int temp8alen = this.scale_expansion_zeroelim(4, bc, pa[2], temp8a);
        int temp8blen = this.scale_expansion_zeroelim(4, ac, -pb[2], temp8b);
        int temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, ab, pc[2], temp8a);
        int abclen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, abc);
        temp8alen = this.scale_expansion_zeroelim(4, cd, pb[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, bd, -pc[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, bc, pd[2], temp8a);
        int bcdlen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, bcd);
        temp8alen = this.scale_expansion_zeroelim(4, de, pc[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, ce, -pd[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, cd, pe[2], temp8a);
        int cdelen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, cde);
        temp8alen = this.scale_expansion_zeroelim(4, ea, pd[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, da, -pe[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, de, pa[2], temp8a);
        int dealen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, dea);
        temp8alen = this.scale_expansion_zeroelim(4, ab, pe[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, eb, -pa[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, ea, pb[2], temp8a);
        int eablen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, eab);
        temp8alen = this.scale_expansion_zeroelim(4, bd, pa[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, da, pb[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, ab, pd[2], temp8a);
        int abdlen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, abd);
        temp8alen = this.scale_expansion_zeroelim(4, ce, pb[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, eb, pc[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, bc, pe[2], temp8a);
        int bcelen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, bce);
        temp8alen = this.scale_expansion_zeroelim(4, da, pc[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, ac, pd[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, cd, pa[2], temp8a);
        int cdalen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, cda);
        temp8alen = this.scale_expansion_zeroelim(4, eb, pd[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, bd, pe[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, de, pb[2], temp8a);
        int deblen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, deb);
        temp8alen = this.scale_expansion_zeroelim(4, ac, pe[2], temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, ce, pa[2], temp8b);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp8alen = this.scale_expansion_zeroelim(4, ea, pc[2], temp8a);
        int eaclen = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp16len, temp16, eac);
        int temp48alen = this.fast_expansion_sum_zeroelim(cdelen, cde, bcelen, bce, temp48a);
        int temp48blen = this.fast_expansion_sum_zeroelim(deblen, deb, bcdlen, bcd, temp48b);
        for (i = 0; i < temp48blen; ++i) {
            temp48b[i] = -temp48b[i];
        }
        int bcdelen = this.fast_expansion_sum_zeroelim(temp48alen, temp48a, temp48blen, temp48b, bcde);
        int xlen = this.scale_expansion_zeroelim(bcdelen, bcde, pa[0], temp192);
        xlen = this.scale_expansion_zeroelim(xlen, temp192, pa[0], det384x);
        int ylen = this.scale_expansion_zeroelim(bcdelen, bcde, pa[1], temp192);
        ylen = this.scale_expansion_zeroelim(ylen, temp192, pa[1], det384y);
        int zlen = this.scale_expansion_zeroelim(bcdelen, bcde, pa[2], temp192);
        zlen = this.scale_expansion_zeroelim(zlen, temp192, pa[2], det384z);
        int xylen = this.fast_expansion_sum_zeroelim(xlen, det384x, ylen, det384y, detxy);
        int alen = this.fast_expansion_sum_zeroelim(xylen, detxy, zlen, det384z, adet);
        temp48alen = this.fast_expansion_sum_zeroelim(dealen, dea, cdalen, cda, temp48a);
        temp48blen = this.fast_expansion_sum_zeroelim(eaclen, eac, cdelen, cde, temp48b);
        for (i = 0; i < temp48blen; ++i) {
            temp48b[i] = -temp48b[i];
        }
        int cdealen = this.fast_expansion_sum_zeroelim(temp48alen, temp48a, temp48blen, temp48b, cdea);
        xlen = this.scale_expansion_zeroelim(cdealen, cdea, pb[0], temp192);
        xlen = this.scale_expansion_zeroelim(xlen, temp192, pb[0], det384x);
        ylen = this.scale_expansion_zeroelim(cdealen, cdea, pb[1], temp192);
        ylen = this.scale_expansion_zeroelim(ylen, temp192, pb[1], det384y);
        zlen = this.scale_expansion_zeroelim(cdealen, cdea, pb[2], temp192);
        zlen = this.scale_expansion_zeroelim(zlen, temp192, pb[2], det384z);
        xylen = this.fast_expansion_sum_zeroelim(xlen, det384x, ylen, det384y, detxy);
        int blen = this.fast_expansion_sum_zeroelim(xylen, detxy, zlen, det384z, bdet);
        temp48alen = this.fast_expansion_sum_zeroelim(eablen, eab, deblen, deb, temp48a);
        temp48blen = this.fast_expansion_sum_zeroelim(abdlen, abd, dealen, dea, temp48b);
        for (i = 0; i < temp48blen; ++i) {
            temp48b[i] = -temp48b[i];
        }
        int deablen = this.fast_expansion_sum_zeroelim(temp48alen, temp48a, temp48blen, temp48b, deab);
        xlen = this.scale_expansion_zeroelim(deablen, deab, pc[0], temp192);
        xlen = this.scale_expansion_zeroelim(xlen, temp192, pc[0], det384x);
        ylen = this.scale_expansion_zeroelim(deablen, deab, pc[1], temp192);
        ylen = this.scale_expansion_zeroelim(ylen, temp192, pc[1], det384y);
        zlen = this.scale_expansion_zeroelim(deablen, deab, pc[2], temp192);
        zlen = this.scale_expansion_zeroelim(zlen, temp192, pc[2], det384z);
        xylen = this.fast_expansion_sum_zeroelim(xlen, det384x, ylen, det384y, detxy);
        int clen = this.fast_expansion_sum_zeroelim(xylen, detxy, zlen, det384z, cdet);
        temp48alen = this.fast_expansion_sum_zeroelim(abclen, abc, eaclen, eac, temp48a);
        temp48blen = this.fast_expansion_sum_zeroelim(bcelen, bce, eablen, eab, temp48b);
        for (i = 0; i < temp48blen; ++i) {
            temp48b[i] = -temp48b[i];
        }
        int eabclen = this.fast_expansion_sum_zeroelim(temp48alen, temp48a, temp48blen, temp48b, eabc);
        xlen = this.scale_expansion_zeroelim(eabclen, eabc, pd[0], temp192);
        xlen = this.scale_expansion_zeroelim(xlen, temp192, pd[0], det384x);
        ylen = this.scale_expansion_zeroelim(eabclen, eabc, pd[1], temp192);
        ylen = this.scale_expansion_zeroelim(ylen, temp192, pd[1], det384y);
        zlen = this.scale_expansion_zeroelim(eabclen, eabc, pd[2], temp192);
        zlen = this.scale_expansion_zeroelim(zlen, temp192, pd[2], det384z);
        xylen = this.fast_expansion_sum_zeroelim(xlen, det384x, ylen, det384y, detxy);
        int dlen = this.fast_expansion_sum_zeroelim(xylen, detxy, zlen, det384z, ddet);
        temp48alen = this.fast_expansion_sum_zeroelim(bcdlen, bcd, abdlen, abd, temp48a);
        temp48blen = this.fast_expansion_sum_zeroelim(cdalen, cda, abclen, abc, temp48b);
        for (i = 0; i < temp48blen; ++i) {
            temp48b[i] = -temp48b[i];
        }
        int abcdlen = this.fast_expansion_sum_zeroelim(temp48alen, temp48a, temp48blen, temp48b, abcd);
        xlen = this.scale_expansion_zeroelim(abcdlen, abcd, pe[0], temp192);
        xlen = this.scale_expansion_zeroelim(xlen, temp192, pe[0], det384x);
        ylen = this.scale_expansion_zeroelim(abcdlen, abcd, pe[1], temp192);
        ylen = this.scale_expansion_zeroelim(ylen, temp192, pe[1], det384y);
        zlen = this.scale_expansion_zeroelim(abcdlen, abcd, pe[2], temp192);
        zlen = this.scale_expansion_zeroelim(zlen, temp192, pe[2], det384z);
        xylen = this.fast_expansion_sum_zeroelim(xlen, det384x, ylen, det384y, detxy);
        int elen = this.fast_expansion_sum_zeroelim(xylen, detxy, zlen, det384z, edet);
        int ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        int cdlen = this.fast_expansion_sum_zeroelim(clen, cdet, dlen, ddet, cddet);
        cdelen = this.fast_expansion_sum_zeroelim(cdlen, cddet, elen, edet, cdedet);
        int deterlen = this.fast_expansion_sum_zeroelim(ablen, abdet, cdelen, cdedet, deter);
        return deter[deterlen - 1];
    }

    double insphereslow(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe) {
        double[] axby = new double[8];
        double[] bxcy = new double[8];
        double[] cxdy = new double[8];
        double[] dxay = new double[8];
        double[] axcy = new double[8];
        double[] bxdy = new double[8];
        double[] bxay = new double[8];
        double[] cxby = new double[8];
        double[] dxcy = new double[8];
        double[] axdy = new double[8];
        double[] cxay = new double[8];
        double[] dxby = new double[8];
        double[] ab = new double[16];
        double[] bc = new double[16];
        double[] cd = new double[16];
        double[] da = new double[16];
        double[] ac = new double[16];
        double[] bd = new double[16];
        double[] temp32a = new double[32];
        double[] temp32b = new double[32];
        double[] temp64a = new double[64];
        double[] temp64b = new double[64];
        double[] temp64c = new double[64];
        double[] temp128 = new double[128];
        double[] temp192 = new double[192];
        double[] detx = new double[384];
        double[] detxx = new double[768];
        double[] detxt = new double[384];
        double[] detxxt = new double[768];
        double[] detxtxt = new double[768];
        double[] x1 = new double[1536];
        double[] x2 = new double[2304];
        double[] dety = new double[384];
        double[] detyy = new double[768];
        double[] detyt = new double[384];
        double[] detyyt = new double[768];
        double[] detytyt = new double[768];
        double[] y1 = new double[1536];
        double[] y2 = new double[2304];
        double[] detz = new double[384];
        double[] detzz = new double[768];
        double[] detzt = new double[384];
        double[] detzzt = new double[768];
        double[] detztzt = new double[768];
        double[] z1 = new double[1536];
        double[] z2 = new double[2304];
        double[] detxy = new double[4608];
        double[] adet = new double[6912];
        double[] bdet = new double[6912];
        double[] cdet = new double[6912];
        double[] ddet = new double[6912];
        double[] abdet = new double[13824];
        double[] cddet = new double[13824];
        double[] deter = new double[27648];
        double aex = pa[0] - pe[0];
        double bvirt = pa[0] - aex;
        double avirt = aex + bvirt;
        double bround = bvirt - pe[0];
        double around = pa[0] - avirt;
        double aextail = around + bround;
        double aey = pa[1] - pe[1];
        bvirt = pa[1] - aey;
        avirt = aey + bvirt;
        bround = bvirt - pe[1];
        around = pa[1] - avirt;
        double aeytail = around + bround;
        double aez = pa[2] - pe[2];
        bvirt = pa[2] - aez;
        avirt = aez + bvirt;
        bround = bvirt - pe[2];
        around = pa[2] - avirt;
        double aeztail = around + bround;
        double bex = pb[0] - pe[0];
        bvirt = pb[0] - bex;
        avirt = bex + bvirt;
        bround = bvirt - pe[0];
        around = pb[0] - avirt;
        double bextail = around + bround;
        double bey = pb[1] - pe[1];
        bvirt = pb[1] - bey;
        avirt = bey + bvirt;
        bround = bvirt - pe[1];
        around = pb[1] - avirt;
        double beytail = around + bround;
        double bez = pb[2] - pe[2];
        bvirt = pb[2] - bez;
        avirt = bez + bvirt;
        bround = bvirt - pe[2];
        around = pb[2] - avirt;
        double beztail = around + bround;
        double cex = pc[0] - pe[0];
        bvirt = pc[0] - cex;
        avirt = cex + bvirt;
        bround = bvirt - pe[0];
        around = pc[0] - avirt;
        double cextail = around + bround;
        double cey = pc[1] - pe[1];
        bvirt = pc[1] - cey;
        avirt = cey + bvirt;
        bround = bvirt - pe[1];
        around = pc[1] - avirt;
        double ceytail = around + bround;
        double cez = pc[2] - pe[2];
        bvirt = pc[2] - cez;
        avirt = cez + bvirt;
        bround = bvirt - pe[2];
        around = pc[2] - avirt;
        double ceztail = around + bround;
        double dex = pd[0] - pe[0];
        bvirt = pd[0] - dex;
        avirt = dex + bvirt;
        bround = bvirt - pe[0];
        around = pd[0] - avirt;
        double dextail = around + bround;
        double dey = pd[1] - pe[1];
        bvirt = pd[1] - dey;
        avirt = dey + bvirt;
        bround = bvirt - pe[1];
        around = pd[1] - avirt;
        double deytail = around + bround;
        double dez = pd[2] - pe[2];
        bvirt = pd[2] - dez;
        avirt = dez + bvirt;
        bround = bvirt - pe[2];
        around = pd[2] - avirt;
        double deztail = around + bround;
        double c = this.splitter * aextail;
        double abig = c - aextail;
        double a0hi = c - abig;
        double a0lo = aextail - a0hi;
        c = this.splitter * beytail;
        abig = c - beytail;
        double bhi = c - abig;
        double blo = beytail - bhi;
        double _i = aextail * beytail;
        double err1 = _i - a0hi * bhi;
        double err2 = err1 - a0lo * bhi;
        double err3 = err2 - a0hi * blo;
        axby[0] = a0lo * blo - err3;
        c = this.splitter * aex;
        abig = c - aex;
        double a1hi = c - abig;
        double a1lo = aex - a1hi;
        double _j = aex * beytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        double _0 = a1lo * blo - err3;
        double _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        double _1 = around + bround;
        double _l = _j + _k;
        bvirt = _l - _j;
        double _2 = _k - bvirt;
        c = this.splitter * bey;
        abig = c - bey;
        bhi = c - abig;
        blo = bey - bhi;
        _i = aextail * bey;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        double _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = aex * bey;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        double _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axby[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        axby[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        axby[5] = around + bround;
        double axby7 = _m + _k;
        bvirt = axby7 - _m;
        avirt = axby7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        axby[6] = around + bround;
        axby[7] = axby7;
        double negate = -aey;
        double negatetail = -aeytail;
        c = this.splitter * bextail;
        abig = c - bextail;
        a0hi = c - abig;
        a0lo = bextail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = bextail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        bxay[0] = a0lo * blo - err3;
        c = this.splitter * bex;
        abig = c - bex;
        a1hi = c - abig;
        a1lo = bex - a1hi;
        _j = bex * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = bextail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = bex * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxay[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        bxay[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        bxay[5] = around + bround;
        double bxay7 = _m + _k;
        bvirt = bxay7 - _m;
        avirt = bxay7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        bxay[6] = around + bround;
        bxay[7] = bxay7;
        int ablen = this.fast_expansion_sum_zeroelim(8, axby, 8, bxay, ab);
        c = this.splitter * bextail;
        abig = c - bextail;
        a0hi = c - abig;
        a0lo = bextail - a0hi;
        c = this.splitter * ceytail;
        abig = c - ceytail;
        bhi = c - abig;
        blo = ceytail - bhi;
        _i = bextail * ceytail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        bxcy[0] = a0lo * blo - err3;
        c = this.splitter * bex;
        abig = c - bex;
        a1hi = c - abig;
        a1lo = bex - a1hi;
        _j = bex * ceytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * cey;
        abig = c - cey;
        bhi = c - abig;
        blo = cey - bhi;
        _i = bextail * cey;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxcy[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = bex * cey;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxcy[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxcy[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        bxcy[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        bxcy[5] = around + bround;
        double bxcy7 = _m + _k;
        bvirt = bxcy7 - _m;
        avirt = bxcy7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        bxcy[6] = around + bround;
        bxcy[7] = bxcy7;
        negate = -bey;
        negatetail = -beytail;
        c = this.splitter * cextail;
        abig = c - cextail;
        a0hi = c - abig;
        a0lo = cextail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = cextail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        cxby[0] = a0lo * blo - err3;
        c = this.splitter * cex;
        abig = c - cex;
        a1hi = c - abig;
        a1lo = cex - a1hi;
        _j = cex * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = cextail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxby[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = cex * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxby[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxby[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        cxby[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        cxby[5] = around + bround;
        double cxby7 = _m + _k;
        bvirt = cxby7 - _m;
        avirt = cxby7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        cxby[6] = around + bround;
        cxby[7] = cxby7;
        int bclen = this.fast_expansion_sum_zeroelim(8, bxcy, 8, cxby, bc);
        c = this.splitter * cextail;
        abig = c - cextail;
        a0hi = c - abig;
        a0lo = cextail - a0hi;
        c = this.splitter * deytail;
        abig = c - deytail;
        bhi = c - abig;
        blo = deytail - bhi;
        _i = cextail * deytail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        cxdy[0] = a0lo * blo - err3;
        c = this.splitter * cex;
        abig = c - cex;
        a1hi = c - abig;
        a1lo = cex - a1hi;
        _j = cex * deytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * dey;
        abig = c - dey;
        bhi = c - abig;
        blo = dey - bhi;
        _i = cextail * dey;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxdy[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = cex * dey;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxdy[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxdy[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        cxdy[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        cxdy[5] = around + bround;
        double cxdy7 = _m + _k;
        bvirt = cxdy7 - _m;
        avirt = cxdy7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        cxdy[6] = around + bround;
        cxdy[7] = cxdy7;
        negate = -cey;
        negatetail = -ceytail;
        c = this.splitter * dextail;
        abig = c - dextail;
        a0hi = c - abig;
        a0lo = dextail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = dextail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        dxcy[0] = a0lo * blo - err3;
        c = this.splitter * dex;
        abig = c - dex;
        a1hi = c - abig;
        a1lo = dex - a1hi;
        _j = dex * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = dextail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        dxcy[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = dex * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        dxcy[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        dxcy[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        dxcy[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        dxcy[5] = around + bround;
        double dxcy7 = _m + _k;
        bvirt = dxcy7 - _m;
        avirt = dxcy7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        dxcy[6] = around + bround;
        dxcy[7] = dxcy7;
        int cdlen = this.fast_expansion_sum_zeroelim(8, cxdy, 8, dxcy, cd);
        c = this.splitter * dextail;
        abig = c - dextail;
        a0hi = c - abig;
        a0lo = dextail - a0hi;
        c = this.splitter * aeytail;
        abig = c - aeytail;
        bhi = c - abig;
        blo = aeytail - bhi;
        _i = dextail * aeytail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        dxay[0] = a0lo * blo - err3;
        c = this.splitter * dex;
        abig = c - dex;
        a1hi = c - abig;
        a1lo = dex - a1hi;
        _j = dex * aeytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * aey;
        abig = c - aey;
        bhi = c - abig;
        blo = aey - bhi;
        _i = dextail * aey;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        dxay[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = dex * aey;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        dxay[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        dxay[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        dxay[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        dxay[5] = around + bround;
        double dxay7 = _m + _k;
        bvirt = dxay7 - _m;
        avirt = dxay7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        dxay[6] = around + bround;
        dxay[7] = dxay7;
        negate = -dey;
        negatetail = -deytail;
        c = this.splitter * aextail;
        abig = c - aextail;
        a0hi = c - abig;
        a0lo = aextail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = aextail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        axdy[0] = a0lo * blo - err3;
        c = this.splitter * aex;
        abig = c - aex;
        a1hi = c - abig;
        a1lo = aex - a1hi;
        _j = aex * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = aextail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axdy[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = aex * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axdy[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axdy[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        axdy[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        axdy[5] = around + bround;
        double axdy7 = _m + _k;
        bvirt = axdy7 - _m;
        avirt = axdy7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        axdy[6] = around + bround;
        axdy[7] = axdy7;
        int dalen = this.fast_expansion_sum_zeroelim(8, dxay, 8, axdy, da);
        c = this.splitter * aextail;
        abig = c - aextail;
        a0hi = c - abig;
        a0lo = aextail - a0hi;
        c = this.splitter * ceytail;
        abig = c - ceytail;
        bhi = c - abig;
        blo = ceytail - bhi;
        _i = aextail * ceytail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        axcy[0] = a0lo * blo - err3;
        c = this.splitter * aex;
        abig = c - aex;
        a1hi = c - abig;
        a1lo = aex - a1hi;
        _j = aex * ceytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * cey;
        abig = c - cey;
        bhi = c - abig;
        blo = cey - bhi;
        _i = aextail * cey;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axcy[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = aex * cey;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axcy[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        axcy[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        axcy[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        axcy[5] = around + bround;
        double axcy7 = _m + _k;
        bvirt = axcy7 - _m;
        avirt = axcy7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        axcy[6] = around + bround;
        axcy[7] = axcy7;
        negate = -aey;
        negatetail = -aeytail;
        c = this.splitter * cextail;
        abig = c - cextail;
        a0hi = c - abig;
        a0lo = cextail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = cextail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        cxay[0] = a0lo * blo - err3;
        c = this.splitter * cex;
        abig = c - cex;
        a1hi = c - abig;
        a1lo = cex - a1hi;
        _j = cex * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = cextail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxay[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = cex * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxay[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        cxay[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        cxay[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        cxay[5] = around + bround;
        double cxay7 = _m + _k;
        bvirt = cxay7 - _m;
        avirt = cxay7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        cxay[6] = around + bround;
        cxay[7] = cxay7;
        int aclen = this.fast_expansion_sum_zeroelim(8, axcy, 8, cxay, ac);
        c = this.splitter * bextail;
        abig = c - bextail;
        a0hi = c - abig;
        a0lo = bextail - a0hi;
        c = this.splitter * deytail;
        abig = c - deytail;
        bhi = c - abig;
        blo = deytail - bhi;
        _i = bextail * deytail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        bxdy[0] = a0lo * blo - err3;
        c = this.splitter * bex;
        abig = c - bex;
        a1hi = c - abig;
        a1lo = bex - a1hi;
        _j = bex * deytail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * dey;
        abig = c - dey;
        bhi = c - abig;
        blo = dey - bhi;
        _i = bextail * dey;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxdy[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = bex * dey;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxdy[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        bxdy[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        bxdy[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        bxdy[5] = around + bround;
        double bxdy7 = _m + _k;
        bvirt = bxdy7 - _m;
        avirt = bxdy7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        bxdy[6] = around + bround;
        bxdy[7] = bxdy7;
        negate = -bey;
        negatetail = -beytail;
        c = this.splitter * dextail;
        abig = c - dextail;
        a0hi = c - abig;
        a0lo = dextail - a0hi;
        c = this.splitter * negatetail;
        abig = c - negatetail;
        bhi = c - abig;
        blo = negatetail - bhi;
        _i = dextail * negatetail;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        dxby[0] = a0lo * blo - err3;
        c = this.splitter * dex;
        abig = c - dex;
        a1hi = c - abig;
        a1lo = dex - a1hi;
        _j = dex * negatetail;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _k = _i + _0;
        bvirt = _k - _i;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _1 = around + bround;
        _l = _j + _k;
        bvirt = _l - _j;
        _2 = _k - bvirt;
        c = this.splitter * negate;
        abig = c - negate;
        bhi = c - abig;
        blo = negate - bhi;
        _i = dextail * negate;
        err1 = _i - a0hi * bhi;
        err2 = err1 - a0lo * bhi;
        err3 = err2 - a0hi * blo;
        _0 = a0lo * blo - err3;
        _k = _1 + _0;
        bvirt = _k - _1;
        avirt = _k - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        dxby[1] = around + bround;
        _j = _2 + _k;
        bvirt = _j - _2;
        avirt = _j - bvirt;
        bround = _k - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _j;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _j - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _j = dex * negate;
        err1 = _j - a1hi * bhi;
        err2 = err1 - a1lo * bhi;
        err3 = err2 - a1hi * blo;
        _0 = a1lo * blo - err3;
        _n = _i + _0;
        bvirt = _n - _i;
        avirt = _n - bvirt;
        bround = _0 - bvirt;
        around = _i - avirt;
        _0 = around + bround;
        _i = _1 + _0;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        dxby[2] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _l = _m + _k;
        bvirt = _l - _m;
        avirt = _l - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        _2 = around + bround;
        _k = _j + _n;
        bvirt = _k - _j;
        avirt = _k - bvirt;
        bround = _n - bvirt;
        around = _j - avirt;
        _0 = around + bround;
        _j = _1 + _0;
        bvirt = _j - _1;
        avirt = _j - bvirt;
        bround = _0 - bvirt;
        around = _1 - avirt;
        dxby[3] = around + bround;
        _i = _2 + _j;
        bvirt = _i - _2;
        avirt = _i - bvirt;
        bround = _j - bvirt;
        around = _2 - avirt;
        _1 = around + bround;
        _m = _l + _i;
        bvirt = _m - _l;
        avirt = _m - bvirt;
        bround = _i - bvirt;
        around = _l - avirt;
        _2 = around + bround;
        _i = _1 + _k;
        bvirt = _i - _1;
        avirt = _i - bvirt;
        bround = _k - bvirt;
        around = _1 - avirt;
        dxby[4] = around + bround;
        _k = _2 + _i;
        bvirt = _k - _2;
        avirt = _k - bvirt;
        bround = _i - bvirt;
        around = _2 - avirt;
        dxby[5] = around + bround;
        double dxby7 = _m + _k;
        bvirt = dxby7 - _m;
        avirt = dxby7 - bvirt;
        bround = _k - bvirt;
        around = _m - avirt;
        dxby[6] = around + bround;
        dxby[7] = dxby7;
        int bdlen = this.fast_expansion_sum_zeroelim(8, bxdy, 8, dxby, bd);
        int temp32alen = this.scale_expansion_zeroelim(cdlen, cd, -bez, temp32a);
        int temp32blen = this.scale_expansion_zeroelim(cdlen, cd, -beztail, temp32b);
        int temp64alen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64a);
        temp32alen = this.scale_expansion_zeroelim(bdlen, bd, cez, temp32a);
        temp32blen = this.scale_expansion_zeroelim(bdlen, bd, ceztail, temp32b);
        int temp64blen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64b);
        temp32alen = this.scale_expansion_zeroelim(bclen, bc, -dez, temp32a);
        temp32blen = this.scale_expansion_zeroelim(bclen, bc, -deztail, temp32b);
        int temp64clen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64c);
        int temp128len = this.fast_expansion_sum_zeroelim(temp64alen, temp64a, temp64blen, temp64b, temp128);
        int temp192len = this.fast_expansion_sum_zeroelim(temp64clen, temp64c, temp128len, temp128, temp192);
        int xlen = this.scale_expansion_zeroelim(temp192len, temp192, aex, detx);
        int xxlen = this.scale_expansion_zeroelim(xlen, detx, aex, detxx);
        int xtlen = this.scale_expansion_zeroelim(temp192len, temp192, aextail, detxt);
        int xxtlen = this.scale_expansion_zeroelim(xtlen, detxt, aex, detxxt);
        int i = 0;
        while (i < xxtlen) {
            int n = i++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        int xtxtlen = this.scale_expansion_zeroelim(xtlen, detxt, aextail, detxtxt);
        int x1len = this.fast_expansion_sum_zeroelim(xxlen, detxx, xxtlen, detxxt, x1);
        int x2len = this.fast_expansion_sum_zeroelim(x1len, x1, xtxtlen, detxtxt, x2);
        int ylen = this.scale_expansion_zeroelim(temp192len, temp192, aey, dety);
        int yylen = this.scale_expansion_zeroelim(ylen, dety, aey, detyy);
        int ytlen = this.scale_expansion_zeroelim(temp192len, temp192, aeytail, detyt);
        int yytlen = this.scale_expansion_zeroelim(ytlen, detyt, aey, detyyt);
        i = 0;
        while (i < yytlen) {
            int n = i++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        int ytytlen = this.scale_expansion_zeroelim(ytlen, detyt, aeytail, detytyt);
        int y1len = this.fast_expansion_sum_zeroelim(yylen, detyy, yytlen, detyyt, y1);
        int y2len = this.fast_expansion_sum_zeroelim(y1len, y1, ytytlen, detytyt, y2);
        int zlen = this.scale_expansion_zeroelim(temp192len, temp192, aez, detz);
        int zzlen = this.scale_expansion_zeroelim(zlen, detz, aez, detzz);
        int ztlen = this.scale_expansion_zeroelim(temp192len, temp192, aeztail, detzt);
        int zztlen = this.scale_expansion_zeroelim(ztlen, detzt, aez, detzzt);
        i = 0;
        while (i < zztlen) {
            int n = i++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        int ztztlen = this.scale_expansion_zeroelim(ztlen, detzt, aeztail, detztzt);
        int z1len = this.fast_expansion_sum_zeroelim(zzlen, detzz, zztlen, detzzt, z1);
        int z2len = this.fast_expansion_sum_zeroelim(z1len, z1, ztztlen, detztzt, z2);
        int xylen = this.fast_expansion_sum_zeroelim(x2len, x2, y2len, y2, detxy);
        int alen = this.fast_expansion_sum_zeroelim(z2len, z2, xylen, detxy, adet);
        temp32alen = this.scale_expansion_zeroelim(dalen, da, cez, temp32a);
        temp32blen = this.scale_expansion_zeroelim(dalen, da, ceztail, temp32b);
        temp64alen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64a);
        temp32alen = this.scale_expansion_zeroelim(aclen, ac, dez, temp32a);
        temp32blen = this.scale_expansion_zeroelim(aclen, ac, deztail, temp32b);
        temp64blen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64b);
        temp32alen = this.scale_expansion_zeroelim(cdlen, cd, aez, temp32a);
        temp32blen = this.scale_expansion_zeroelim(cdlen, cd, aeztail, temp32b);
        temp64clen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64c);
        temp128len = this.fast_expansion_sum_zeroelim(temp64alen, temp64a, temp64blen, temp64b, temp128);
        temp192len = this.fast_expansion_sum_zeroelim(temp64clen, temp64c, temp128len, temp128, temp192);
        xlen = this.scale_expansion_zeroelim(temp192len, temp192, bex, detx);
        xxlen = this.scale_expansion_zeroelim(xlen, detx, bex, detxx);
        xtlen = this.scale_expansion_zeroelim(temp192len, temp192, bextail, detxt);
        xxtlen = this.scale_expansion_zeroelim(xtlen, detxt, bex, detxxt);
        i = 0;
        while (i < xxtlen) {
            int n = i++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = this.scale_expansion_zeroelim(xtlen, detxt, bextail, detxtxt);
        x1len = this.fast_expansion_sum_zeroelim(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = this.fast_expansion_sum_zeroelim(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = this.scale_expansion_zeroelim(temp192len, temp192, bey, dety);
        yylen = this.scale_expansion_zeroelim(ylen, dety, bey, detyy);
        ytlen = this.scale_expansion_zeroelim(temp192len, temp192, beytail, detyt);
        yytlen = this.scale_expansion_zeroelim(ytlen, detyt, bey, detyyt);
        i = 0;
        while (i < yytlen) {
            int n = i++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = this.scale_expansion_zeroelim(ytlen, detyt, beytail, detytyt);
        y1len = this.fast_expansion_sum_zeroelim(yylen, detyy, yytlen, detyyt, y1);
        y2len = this.fast_expansion_sum_zeroelim(y1len, y1, ytytlen, detytyt, y2);
        zlen = this.scale_expansion_zeroelim(temp192len, temp192, bez, detz);
        zzlen = this.scale_expansion_zeroelim(zlen, detz, bez, detzz);
        ztlen = this.scale_expansion_zeroelim(temp192len, temp192, beztail, detzt);
        zztlen = this.scale_expansion_zeroelim(ztlen, detzt, bez, detzzt);
        i = 0;
        while (i < zztlen) {
            int n = i++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        ztztlen = this.scale_expansion_zeroelim(ztlen, detzt, beztail, detztzt);
        z1len = this.fast_expansion_sum_zeroelim(zzlen, detzz, zztlen, detzzt, z1);
        z2len = this.fast_expansion_sum_zeroelim(z1len, z1, ztztlen, detztzt, z2);
        xylen = this.fast_expansion_sum_zeroelim(x2len, x2, y2len, y2, detxy);
        int blen = this.fast_expansion_sum_zeroelim(z2len, z2, xylen, detxy, bdet);
        temp32alen = this.scale_expansion_zeroelim(ablen, ab, -dez, temp32a);
        temp32blen = this.scale_expansion_zeroelim(ablen, ab, -deztail, temp32b);
        temp64alen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64a);
        temp32alen = this.scale_expansion_zeroelim(bdlen, bd, -aez, temp32a);
        temp32blen = this.scale_expansion_zeroelim(bdlen, bd, -aeztail, temp32b);
        temp64blen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64b);
        temp32alen = this.scale_expansion_zeroelim(dalen, da, -bez, temp32a);
        temp32blen = this.scale_expansion_zeroelim(dalen, da, -beztail, temp32b);
        temp64clen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64c);
        temp128len = this.fast_expansion_sum_zeroelim(temp64alen, temp64a, temp64blen, temp64b, temp128);
        temp192len = this.fast_expansion_sum_zeroelim(temp64clen, temp64c, temp128len, temp128, temp192);
        xlen = this.scale_expansion_zeroelim(temp192len, temp192, cex, detx);
        xxlen = this.scale_expansion_zeroelim(xlen, detx, cex, detxx);
        xtlen = this.scale_expansion_zeroelim(temp192len, temp192, cextail, detxt);
        xxtlen = this.scale_expansion_zeroelim(xtlen, detxt, cex, detxxt);
        i = 0;
        while (i < xxtlen) {
            int n = i++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = this.scale_expansion_zeroelim(xtlen, detxt, cextail, detxtxt);
        x1len = this.fast_expansion_sum_zeroelim(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = this.fast_expansion_sum_zeroelim(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = this.scale_expansion_zeroelim(temp192len, temp192, cey, dety);
        yylen = this.scale_expansion_zeroelim(ylen, dety, cey, detyy);
        ytlen = this.scale_expansion_zeroelim(temp192len, temp192, ceytail, detyt);
        yytlen = this.scale_expansion_zeroelim(ytlen, detyt, cey, detyyt);
        i = 0;
        while (i < yytlen) {
            int n = i++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = this.scale_expansion_zeroelim(ytlen, detyt, ceytail, detytyt);
        y1len = this.fast_expansion_sum_zeroelim(yylen, detyy, yytlen, detyyt, y1);
        y2len = this.fast_expansion_sum_zeroelim(y1len, y1, ytytlen, detytyt, y2);
        zlen = this.scale_expansion_zeroelim(temp192len, temp192, cez, detz);
        zzlen = this.scale_expansion_zeroelim(zlen, detz, cez, detzz);
        ztlen = this.scale_expansion_zeroelim(temp192len, temp192, ceztail, detzt);
        zztlen = this.scale_expansion_zeroelim(ztlen, detzt, cez, detzzt);
        i = 0;
        while (i < zztlen) {
            int n = i++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        ztztlen = this.scale_expansion_zeroelim(ztlen, detzt, ceztail, detztzt);
        z1len = this.fast_expansion_sum_zeroelim(zzlen, detzz, zztlen, detzzt, z1);
        z2len = this.fast_expansion_sum_zeroelim(z1len, z1, ztztlen, detztzt, z2);
        xylen = this.fast_expansion_sum_zeroelim(x2len, x2, y2len, y2, detxy);
        int clen = this.fast_expansion_sum_zeroelim(z2len, z2, xylen, detxy, cdet);
        temp32alen = this.scale_expansion_zeroelim(bclen, bc, aez, temp32a);
        temp32blen = this.scale_expansion_zeroelim(bclen, bc, aeztail, temp32b);
        temp64alen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64a);
        temp32alen = this.scale_expansion_zeroelim(aclen, ac, -bez, temp32a);
        temp32blen = this.scale_expansion_zeroelim(aclen, ac, -beztail, temp32b);
        temp64blen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64b);
        temp32alen = this.scale_expansion_zeroelim(ablen, ab, cez, temp32a);
        temp32blen = this.scale_expansion_zeroelim(ablen, ab, ceztail, temp32b);
        temp64clen = this.fast_expansion_sum_zeroelim(temp32alen, temp32a, temp32blen, temp32b, temp64c);
        temp128len = this.fast_expansion_sum_zeroelim(temp64alen, temp64a, temp64blen, temp64b, temp128);
        temp192len = this.fast_expansion_sum_zeroelim(temp64clen, temp64c, temp128len, temp128, temp192);
        xlen = this.scale_expansion_zeroelim(temp192len, temp192, dex, detx);
        xxlen = this.scale_expansion_zeroelim(xlen, detx, dex, detxx);
        xtlen = this.scale_expansion_zeroelim(temp192len, temp192, dextail, detxt);
        xxtlen = this.scale_expansion_zeroelim(xtlen, detxt, dex, detxxt);
        i = 0;
        while (i < xxtlen) {
            int n = i++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = this.scale_expansion_zeroelim(xtlen, detxt, dextail, detxtxt);
        x1len = this.fast_expansion_sum_zeroelim(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = this.fast_expansion_sum_zeroelim(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = this.scale_expansion_zeroelim(temp192len, temp192, dey, dety);
        yylen = this.scale_expansion_zeroelim(ylen, dety, dey, detyy);
        ytlen = this.scale_expansion_zeroelim(temp192len, temp192, deytail, detyt);
        yytlen = this.scale_expansion_zeroelim(ytlen, detyt, dey, detyyt);
        i = 0;
        while (i < yytlen) {
            int n = i++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = this.scale_expansion_zeroelim(ytlen, detyt, deytail, detytyt);
        y1len = this.fast_expansion_sum_zeroelim(yylen, detyy, yytlen, detyyt, y1);
        y2len = this.fast_expansion_sum_zeroelim(y1len, y1, ytytlen, detytyt, y2);
        zlen = this.scale_expansion_zeroelim(temp192len, temp192, dez, detz);
        zzlen = this.scale_expansion_zeroelim(zlen, detz, dez, detzz);
        ztlen = this.scale_expansion_zeroelim(temp192len, temp192, deztail, detzt);
        zztlen = this.scale_expansion_zeroelim(ztlen, detzt, dez, detzzt);
        i = 0;
        while (i < zztlen) {
            int n = i++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        ztztlen = this.scale_expansion_zeroelim(ztlen, detzt, deztail, detztzt);
        z1len = this.fast_expansion_sum_zeroelim(zzlen, detzz, zztlen, detzzt, z1);
        z2len = this.fast_expansion_sum_zeroelim(z1len, z1, ztztlen, detztzt, z2);
        xylen = this.fast_expansion_sum_zeroelim(x2len, x2, y2len, y2, detxy);
        int dlen = this.fast_expansion_sum_zeroelim(z2len, z2, xylen, detxy, ddet);
        ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        cdlen = this.fast_expansion_sum_zeroelim(clen, cdet, dlen, ddet, cddet);
        int deterlen = this.fast_expansion_sum_zeroelim(ablen, abdet, cdlen, cddet, deter);
        return deter[deterlen - 1];
    }

    double insphereadapt(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe, double permanent) {
        double errbound;
        int cdlen;
        double[] ab = new double[4];
        double[] bc = new double[4];
        double[] cd = new double[4];
        double[] da = new double[4];
        double[] ac = new double[4];
        double[] bd = new double[4];
        double[] temp8a = new double[8];
        double[] temp8b = new double[8];
        double[] temp8c = new double[8];
        double[] temp16 = new double[16];
        double[] temp24 = new double[24];
        double[] temp48 = new double[48];
        double[] xdet = new double[96];
        double[] ydet = new double[96];
        double[] zdet = new double[96];
        double[] xydet = new double[192];
        double[] adet = new double[288];
        double[] bdet = new double[288];
        double[] cdet = new double[288];
        double[] ddet = new double[288];
        double[] abdet = new double[576];
        double[] cddet = new double[576];
        double[] fin1 = new double[1152];
        double aex = pa[0] - pe[0];
        double bex = pb[0] - pe[0];
        double cex = pc[0] - pe[0];
        double dex = pd[0] - pe[0];
        double aey = pa[1] - pe[1];
        double bey = pb[1] - pe[1];
        double cey = pc[1] - pe[1];
        double dey = pd[1] - pe[1];
        double aez = pa[2] - pe[2];
        double bez = pb[2] - pe[2];
        double cez = pc[2] - pe[2];
        double dez = pd[2] - pe[2];
        double aexbey1 = aex * bey;
        double c = this.splitter * aex;
        double abig = c - aex;
        double ahi = c - abig;
        double alo = aex - ahi;
        c = this.splitter * bey;
        abig = c - bey;
        double bhi = c - abig;
        double blo = bey - bhi;
        double err1 = aexbey1 - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        double aexbey0 = alo * blo - err3;
        double bexaey1 = bex * aey;
        c = this.splitter * bex;
        abig = c - bex;
        ahi = c - abig;
        alo = bex - ahi;
        c = this.splitter * aey;
        abig = c - aey;
        bhi = c - abig;
        blo = aey - bhi;
        err1 = bexaey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bexaey0 = alo * blo - err3;
        double _i = aexbey0 - bexaey0;
        double bvirt = aexbey0 - _i;
        double avirt = _i + bvirt;
        double bround = bvirt - bexaey0;
        double around = aexbey0 - avirt;
        ab[0] = around + bround;
        double _j = aexbey1 + _i;
        bvirt = _j - aexbey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = aexbey1 - avirt;
        double _0 = around + bround;
        _i = _0 - bexaey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - bexaey1;
        around = _0 - avirt;
        ab[1] = around + bround;
        double ab3 = _j + _i;
        bvirt = ab3 - _j;
        avirt = ab3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ab[2] = around + bround;
        ab[3] = ab3;
        double bexcey1 = bex * cey;
        c = this.splitter * bex;
        abig = c - bex;
        ahi = c - abig;
        alo = bex - ahi;
        c = this.splitter * cey;
        abig = c - cey;
        bhi = c - abig;
        blo = cey - bhi;
        err1 = bexcey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bexcey0 = alo * blo - err3;
        double cexbey1 = cex * bey;
        c = this.splitter * cex;
        abig = c - cex;
        ahi = c - abig;
        alo = cex - ahi;
        c = this.splitter * bey;
        abig = c - bey;
        bhi = c - abig;
        blo = bey - bhi;
        err1 = cexbey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cexbey0 = alo * blo - err3;
        _i = bexcey0 - cexbey0;
        bvirt = bexcey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cexbey0;
        around = bexcey0 - avirt;
        bc[0] = around + bround;
        _j = bexcey1 + _i;
        bvirt = _j - bexcey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bexcey1 - avirt;
        _0 = around + bround;
        _i = _0 - cexbey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cexbey1;
        around = _0 - avirt;
        bc[1] = around + bround;
        double bc3 = _j + _i;
        bvirt = bc3 - _j;
        avirt = bc3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bc[2] = around + bround;
        bc[3] = bc3;
        double cexdey1 = cex * dey;
        c = this.splitter * cex;
        abig = c - cex;
        ahi = c - abig;
        alo = cex - ahi;
        c = this.splitter * dey;
        abig = c - dey;
        bhi = c - abig;
        blo = dey - bhi;
        err1 = cexdey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cexdey0 = alo * blo - err3;
        double dexcey1 = dex * cey;
        c = this.splitter * dex;
        abig = c - dex;
        ahi = c - abig;
        alo = dex - ahi;
        c = this.splitter * cey;
        abig = c - cey;
        bhi = c - abig;
        blo = cey - bhi;
        err1 = dexcey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dexcey0 = alo * blo - err3;
        _i = cexdey0 - dexcey0;
        bvirt = cexdey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dexcey0;
        around = cexdey0 - avirt;
        cd[0] = around + bround;
        _j = cexdey1 + _i;
        bvirt = _j - cexdey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = cexdey1 - avirt;
        _0 = around + bround;
        _i = _0 - dexcey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dexcey1;
        around = _0 - avirt;
        cd[1] = around + bround;
        double cd3 = _j + _i;
        bvirt = cd3 - _j;
        avirt = cd3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        cd[2] = around + bround;
        cd[3] = cd3;
        double dexaey1 = dex * aey;
        c = this.splitter * dex;
        abig = c - dex;
        ahi = c - abig;
        alo = dex - ahi;
        c = this.splitter * aey;
        abig = c - aey;
        bhi = c - abig;
        blo = aey - bhi;
        err1 = dexaey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dexaey0 = alo * blo - err3;
        double aexdey1 = aex * dey;
        c = this.splitter * aex;
        abig = c - aex;
        ahi = c - abig;
        alo = aex - ahi;
        c = this.splitter * dey;
        abig = c - dey;
        bhi = c - abig;
        blo = dey - bhi;
        err1 = aexdey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double aexdey0 = alo * blo - err3;
        _i = dexaey0 - aexdey0;
        bvirt = dexaey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - aexdey0;
        around = dexaey0 - avirt;
        da[0] = around + bround;
        _j = dexaey1 + _i;
        bvirt = _j - dexaey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = dexaey1 - avirt;
        _0 = around + bround;
        _i = _0 - aexdey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - aexdey1;
        around = _0 - avirt;
        da[1] = around + bround;
        double da3 = _j + _i;
        bvirt = da3 - _j;
        avirt = da3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        da[2] = around + bround;
        da[3] = da3;
        double aexcey1 = aex * cey;
        c = this.splitter * aex;
        abig = c - aex;
        ahi = c - abig;
        alo = aex - ahi;
        c = this.splitter * cey;
        abig = c - cey;
        bhi = c - abig;
        blo = cey - bhi;
        err1 = aexcey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double aexcey0 = alo * blo - err3;
        double cexaey1 = cex * aey;
        c = this.splitter * cex;
        abig = c - cex;
        ahi = c - abig;
        alo = cex - ahi;
        c = this.splitter * aey;
        abig = c - aey;
        bhi = c - abig;
        blo = aey - bhi;
        err1 = cexaey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double cexaey0 = alo * blo - err3;
        _i = aexcey0 - cexaey0;
        bvirt = aexcey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cexaey0;
        around = aexcey0 - avirt;
        ac[0] = around + bround;
        _j = aexcey1 + _i;
        bvirt = _j - aexcey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = aexcey1 - avirt;
        _0 = around + bround;
        _i = _0 - cexaey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - cexaey1;
        around = _0 - avirt;
        ac[1] = around + bround;
        double ac3 = _j + _i;
        bvirt = ac3 - _j;
        avirt = ac3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        ac[2] = around + bround;
        ac[3] = ac3;
        double bexdey1 = bex * dey;
        c = this.splitter * bex;
        abig = c - bex;
        ahi = c - abig;
        alo = bex - ahi;
        c = this.splitter * dey;
        abig = c - dey;
        bhi = c - abig;
        blo = dey - bhi;
        err1 = bexdey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double bexdey0 = alo * blo - err3;
        double dexbey1 = dex * bey;
        c = this.splitter * dex;
        abig = c - dex;
        ahi = c - abig;
        alo = dex - ahi;
        c = this.splitter * bey;
        abig = c - bey;
        bhi = c - abig;
        blo = bey - bhi;
        err1 = dexbey1 - ahi * bhi;
        err2 = err1 - alo * bhi;
        err3 = err2 - ahi * blo;
        double dexbey0 = alo * blo - err3;
        _i = bexdey0 - dexbey0;
        bvirt = bexdey0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dexbey0;
        around = bexdey0 - avirt;
        bd[0] = around + bround;
        _j = bexdey1 + _i;
        bvirt = _j - bexdey1;
        avirt = _j - bvirt;
        bround = _i - bvirt;
        around = bexdey1 - avirt;
        _0 = around + bround;
        _i = _0 - dexbey1;
        bvirt = _0 - _i;
        avirt = _i + bvirt;
        bround = bvirt - dexbey1;
        around = _0 - avirt;
        bd[1] = around + bround;
        double bd3 = _j + _i;
        bvirt = bd3 - _j;
        avirt = bd3 - bvirt;
        bround = _i - bvirt;
        around = _j - avirt;
        bd[2] = around + bround;
        bd[3] = bd3;
        int temp8alen = this.scale_expansion_zeroelim(4, cd, bez, temp8a);
        int temp8blen = this.scale_expansion_zeroelim(4, bd, -cez, temp8b);
        int temp8clen = this.scale_expansion_zeroelim(4, bc, dez, temp8c);
        int temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        int temp24len = this.fast_expansion_sum_zeroelim(temp8clen, temp8c, temp16len, temp16, temp24);
        int temp48len = this.scale_expansion_zeroelim(temp24len, temp24, aex, temp48);
        int xlen = this.scale_expansion_zeroelim(temp48len, temp48, -aex, xdet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, aey, temp48);
        int ylen = this.scale_expansion_zeroelim(temp48len, temp48, -aey, ydet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, aez, temp48);
        int zlen = this.scale_expansion_zeroelim(temp48len, temp48, -aez, zdet);
        int xylen = this.fast_expansion_sum_zeroelim(xlen, xdet, ylen, ydet, xydet);
        int alen = this.fast_expansion_sum_zeroelim(xylen, xydet, zlen, zdet, adet);
        temp8alen = this.scale_expansion_zeroelim(4, da, cez, temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, ac, dez, temp8b);
        temp8clen = this.scale_expansion_zeroelim(4, cd, aez, temp8c);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp24len = this.fast_expansion_sum_zeroelim(temp8clen, temp8c, temp16len, temp16, temp24);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, bex, temp48);
        xlen = this.scale_expansion_zeroelim(temp48len, temp48, bex, xdet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, bey, temp48);
        ylen = this.scale_expansion_zeroelim(temp48len, temp48, bey, ydet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, bez, temp48);
        zlen = this.scale_expansion_zeroelim(temp48len, temp48, bez, zdet);
        xylen = this.fast_expansion_sum_zeroelim(xlen, xdet, ylen, ydet, xydet);
        int blen = this.fast_expansion_sum_zeroelim(xylen, xydet, zlen, zdet, bdet);
        temp8alen = this.scale_expansion_zeroelim(4, ab, dez, temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, bd, aez, temp8b);
        temp8clen = this.scale_expansion_zeroelim(4, da, bez, temp8c);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp24len = this.fast_expansion_sum_zeroelim(temp8clen, temp8c, temp16len, temp16, temp24);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, cex, temp48);
        xlen = this.scale_expansion_zeroelim(temp48len, temp48, -cex, xdet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, cey, temp48);
        ylen = this.scale_expansion_zeroelim(temp48len, temp48, -cey, ydet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, cez, temp48);
        zlen = this.scale_expansion_zeroelim(temp48len, temp48, -cez, zdet);
        xylen = this.fast_expansion_sum_zeroelim(xlen, xdet, ylen, ydet, xydet);
        int clen = this.fast_expansion_sum_zeroelim(xylen, xydet, zlen, zdet, cdet);
        temp8alen = this.scale_expansion_zeroelim(4, bc, aez, temp8a);
        temp8blen = this.scale_expansion_zeroelim(4, ac, -bez, temp8b);
        temp8clen = this.scale_expansion_zeroelim(4, ab, cez, temp8c);
        temp16len = this.fast_expansion_sum_zeroelim(temp8alen, temp8a, temp8blen, temp8b, temp16);
        temp24len = this.fast_expansion_sum_zeroelim(temp8clen, temp8c, temp16len, temp16, temp24);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, dex, temp48);
        xlen = this.scale_expansion_zeroelim(temp48len, temp48, dex, xdet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, dey, temp48);
        ylen = this.scale_expansion_zeroelim(temp48len, temp48, dey, ydet);
        temp48len = this.scale_expansion_zeroelim(temp24len, temp24, dez, temp48);
        zlen = this.scale_expansion_zeroelim(temp48len, temp48, dez, zdet);
        xylen = this.fast_expansion_sum_zeroelim(xlen, xdet, ylen, ydet, xydet);
        int dlen = this.fast_expansion_sum_zeroelim(xylen, xydet, zlen, zdet, ddet);
        int ablen = this.fast_expansion_sum_zeroelim(alen, adet, blen, bdet, abdet);
        int finlength = this.fast_expansion_sum_zeroelim(ablen, abdet, cdlen = this.fast_expansion_sum_zeroelim(clen, cdet, dlen, ddet, cddet), cddet, fin1);
        double det = this.estimate(finlength, fin1);
        if (det >= (errbound = this.isperrboundB * permanent) || -det >= errbound) {
            return det;
        }
        bvirt = pa[0] - aex;
        avirt = aex + bvirt;
        bround = bvirt - pe[0];
        around = pa[0] - avirt;
        double aextail = around + bround;
        bvirt = pa[1] - aey;
        avirt = aey + bvirt;
        bround = bvirt - pe[1];
        around = pa[1] - avirt;
        double aeytail = around + bround;
        bvirt = pa[2] - aez;
        avirt = aez + bvirt;
        bround = bvirt - pe[2];
        around = pa[2] - avirt;
        double aeztail = around + bround;
        bvirt = pb[0] - bex;
        avirt = bex + bvirt;
        bround = bvirt - pe[0];
        around = pb[0] - avirt;
        double bextail = around + bround;
        bvirt = pb[1] - bey;
        avirt = bey + bvirt;
        bround = bvirt - pe[1];
        around = pb[1] - avirt;
        double beytail = around + bround;
        bvirt = pb[2] - bez;
        avirt = bez + bvirt;
        bround = bvirt - pe[2];
        around = pb[2] - avirt;
        double beztail = around + bround;
        bvirt = pc[0] - cex;
        avirt = cex + bvirt;
        bround = bvirt - pe[0];
        around = pc[0] - avirt;
        double cextail = around + bround;
        bvirt = pc[1] - cey;
        avirt = cey + bvirt;
        bround = bvirt - pe[1];
        around = pc[1] - avirt;
        double ceytail = around + bround;
        bvirt = pc[2] - cez;
        avirt = cez + bvirt;
        bround = bvirt - pe[2];
        around = pc[2] - avirt;
        double ceztail = around + bround;
        bvirt = pd[0] - dex;
        avirt = dex + bvirt;
        bround = bvirt - pe[0];
        around = pd[0] - avirt;
        double dextail = around + bround;
        bvirt = pd[1] - dey;
        avirt = dey + bvirt;
        bround = bvirt - pe[1];
        around = pd[1] - avirt;
        double deytail = around + bround;
        bvirt = pd[2] - dez;
        avirt = dez + bvirt;
        bround = bvirt - pe[2];
        around = pd[2] - avirt;
        double deztail = around + bround;
        if (aextail == 0.0 && aeytail == 0.0 && aeztail == 0.0 && bextail == 0.0 && beytail == 0.0 && beztail == 0.0 && cextail == 0.0 && ceytail == 0.0 && ceztail == 0.0 && dextail == 0.0 && deytail == 0.0 && deztail == 0.0) {
            return det;
        }
        errbound = this.isperrboundC * permanent + this.resulterrbound * (det >= 0.0 ? det : -det);
        double daeps = dex * aeytail + aey * dextail - (dey * aextail + aex * deytail);
        double aceps = aex * ceytail + cey * aextail - (aey * cextail + cex * aeytail);
        double cdeps = cex * deytail + dey * cextail - (cey * dextail + dex * ceytail);
        double bceps = bex * ceytail + cey * bextail - (bey * cextail + cex * beytail);
        double abeps = aex * beytail + bey * aextail - (aey * bextail + bex * aeytail);
        double bdeps = bex * deytail + dey * bextail - (bey * dextail + dex * beytail);
        if ((det += (bex * bex + bey * bey + bez * bez) * (cez * daeps + dez * aceps + aez * cdeps + (ceztail * da3 + deztail * ac3 + aeztail * cd3)) + (dex * dex + dey * dey + dez * dez) * (aez * bceps - bez * aceps + cez * abeps + (aeztail * bc3 - beztail * ac3 + ceztail * ab3)) - ((aex * aex + aey * aey + aez * aez) * (bez * cdeps - cez * bdeps + dez * bceps + (beztail * cd3 - ceztail * bd3 + deztail * bc3)) + (cex * cex + cey * cey + cez * cez) * (dez * abeps + aez * bdeps + bez * daeps + (deztail * ab3 + aeztail * bd3 + beztail * da3))) + 2.0 * ((bex * bextail + bey * beytail + bez * beztail) * (cez * da3 + dez * ac3 + aez * cd3) + (dex * dextail + dey * deytail + dez * deztail) * (aez * bc3 - bez * ac3 + cez * ab3) - ((aex * aextail + aey * aeytail + aez * aeztail) * (bez * cd3 - cez * bd3 + dez * bc3) + (cex * cextail + cey * ceytail + cez * ceztail) * (dez * ab3 + aez * bd3 + bez * da3)))) >= errbound || -det >= errbound) {
            return det;
        }
        return this.insphereexact(pa, pb, pc, pd, pe);
    }

    double insphere(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe) {
        double bexaeyplus;
        double aexbeyplus;
        double aezplus;
        double cexaeyplus;
        double aexceyplus;
        double aexdeyplus;
        double dexaeyplus;
        double dezplus;
        double cexbeyplus;
        double bexceyplus;
        double cezplus;
        double bexdeyplus;
        double dexbeyplus;
        double bezplus;
        double dexceyplus;
        double dex = pd[0] - pe[0];
        double dey = pd[1] - pe[1];
        double dez = pd[2] - pe[2];
        double dlift = dex * dex + dey * dey + dez * dez;
        double aez = pa[2] - pe[2];
        double bex = pb[0] - pe[0];
        double cey = pc[1] - pe[1];
        double bexcey = bex * cey;
        double cex = pc[0] - pe[0];
        double bey = pb[1] - pe[1];
        double cexbey = cex * bey;
        double bc = bexcey - cexbey;
        double bez = pb[2] - pe[2];
        double aex = pa[0] - pe[0];
        double aexcey = aex * cey;
        double aey = pa[1] - pe[1];
        double cexaey = cex * aey;
        double ac = aexcey - cexaey;
        double cez = pc[2] - pe[2];
        double aexbey = aex * bey;
        double bexaey = bex * aey;
        double ab = aexbey - bexaey;
        double abc = aez * bc - bez * ac + cez * ab;
        double clift = cex * cex + cey * cey + cez * cez;
        double bexdey = bex * dey;
        double dexbey = dex * bey;
        double bd = bexdey - dexbey;
        double dexaey = dex * aey;
        double aexdey = aex * dey;
        double da = dexaey - aexdey;
        double dab = dez * ab + aez * bd + bez * da;
        double blift = bex * bex + bey * bey + bez * bez;
        double cexdey = cex * dey;
        double dexcey = dex * cey;
        double cd = cexdey - dexcey;
        double cda = cez * da + dez * ac + aez * cd;
        double alift = aex * aex + aey * aey + aez * aez;
        double bcd = bez * cd - cez * bd + dez * bc;
        double det = dlift * abc - clift * dab + (blift * cda - alift * bcd);
        double cexdeyplus = cexdey >= 0.0 ? cexdey : -cexdey;
        double permanent = ((cexdeyplus + (dexceyplus = dexcey >= 0.0 ? dexcey : -dexcey)) * (bezplus = bez >= 0.0 ? bez : -bez) + ((dexbeyplus = dexbey >= 0.0 ? dexbey : -dexbey) + (bexdeyplus = bexdey >= 0.0 ? bexdey : -bexdey)) * (cezplus = cez >= 0.0 ? cez : -cez) + ((bexceyplus = bexcey >= 0.0 ? bexcey : -bexcey) + (cexbeyplus = cexbey >= 0.0 ? cexbey : -cexbey)) * (dezplus = dez >= 0.0 ? dez : -dez)) * alift + (((dexaeyplus = dexaey >= 0.0 ? dexaey : -dexaey) + (aexdeyplus = aexdey >= 0.0 ? aexdey : -aexdey)) * cezplus + ((aexceyplus = aexcey >= 0.0 ? aexcey : -aexcey) + (cexaeyplus = cexaey >= 0.0 ? cexaey : -cexaey)) * dezplus + (cexdeyplus + dexceyplus) * (aezplus = aez >= 0.0 ? aez : -aez)) * blift + (((aexbeyplus = aexbey >= 0.0 ? aexbey : -aexbey) + (bexaeyplus = bexaey >= 0.0 ? bexaey : -bexaey)) * dezplus + (bexdeyplus + dexbeyplus) * aezplus + (dexaeyplus + aexdeyplus) * bezplus) * clift + ((bexceyplus + cexbeyplus) * aezplus + (cexaeyplus + aexceyplus) * bezplus + (aexbeyplus + bexaeyplus) * cezplus) * dlift;
        double errbound = this.isperrboundA * permanent;
        if (det > errbound || -det > errbound) {
            return det;
        }
        return this.insphereadapt(pa, pb, pc, pd, pe, permanent);
    }

    private double insphere(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, double x5, double y5, double z5) {
        this.p0[0] = x1;
        this.p0[1] = y1;
        this.p0[2] = z1;
        this.p1[0] = x2;
        this.p1[1] = y2;
        this.p1[2] = z2;
        this.p2[0] = x3;
        this.p2[1] = y3;
        this.p2[2] = z3;
        this.p3[0] = x4;
        this.p3[1] = y4;
        this.p3[2] = z4;
        this.p4[0] = x5;
        this.p4[1] = y5;
        this.p4[2] = z5;
        return this.insphere(this.p0, this.p1, this.p2, this.p3, this.p4);
    }

    private double orient3d(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4) {
        this.p0[0] = x1;
        this.p0[1] = y1;
        this.p0[2] = z1;
        this.p1[0] = x2;
        this.p1[1] = y2;
        this.p1[2] = z2;
        this.p2[0] = x3;
        this.p2[1] = y3;
        this.p2[2] = z3;
        this.p3[0] = x4;
        this.p3[1] = y4;
        this.p3[2] = z4;
        return this.orient3d(this.p0, this.p1, this.p2, this.p3);
    }

    private void tetcircumcenter(double[] a, double[] b, double[] c, double[] d, double[] circumcenter, double[] xi, double[] eta, double[] zeta) {
        double xba = b[0] - a[0];
        double yba = b[1] - a[1];
        double zba = b[2] - a[2];
        double xca = c[0] - a[0];
        double yca = c[1] - a[1];
        double zca = c[2] - a[2];
        double xda = d[0] - a[0];
        double yda = d[1] - a[1];
        double zda = d[2] - a[2];
        double balength = xba * xba + yba * yba + zba * zba;
        double calength = xca * xca + yca * yca + zca * zca;
        double dalength = xda * xda + yda * yda + zda * zda;
        double xcrosscd = yca * zda - yda * zca;
        double ycrosscd = zca * xda - zda * xca;
        double zcrosscd = xca * yda - xda * yca;
        double xcrossdb = yda * zba - yba * zda;
        double ycrossdb = zda * xba - zba * xda;
        double zcrossdb = xda * yba - xba * yda;
        double xcrossbc = yba * zca - yca * zba;
        double ycrossbc = zba * xca - zca * xba;
        double zcrossbc = xba * yca - xca * yba;
        double denominator = 0.5 / (xba * xcrosscd + yba * ycrosscd + zba * zcrosscd);
        double xcirca = (balength * xcrosscd + calength * xcrossdb + dalength * xcrossbc) * denominator;
        double ycirca = (balength * ycrosscd + calength * ycrossdb + dalength * ycrossbc) * denominator;
        double zcirca = (balength * zcrosscd + calength * zcrossdb + dalength * zcrossbc) * denominator;
        circumcenter[0] = xcirca + a[0];
        circumcenter[1] = ycirca + a[1];
        circumcenter[2] = zcirca + a[2];
        if (xi != null) {
            xi[0] = (xcirca * xcrosscd + ycirca * ycrosscd + zcirca * zcrosscd) * (2.0 * denominator);
            eta[0] = (xcirca * xcrossdb + ycirca * ycrossdb + zcirca * zcrossdb) * (2.0 * denominator);
            zeta[0] = (xcirca * xcrossbc + ycirca * ycrossbc + zcirca * zcrossbc) * (2.0 * denominator);
        }
    }

    private double tetcircumradius(double a1, double a2, double a3, double b1, double b2, double b3, double c1, double c2, double c3, double d1, double d2, double d3) {
        double[] a = new double[3];
        double[] b = new double[3];
        double[] c = new double[3];
        double[] d = new double[3];
        double[] circumcenter = new double[3];
        a[0] = a1;
        a[1] = a2;
        a[2] = a3;
        b[0] = b1;
        b[1] = b2;
        b[2] = b3;
        c[0] = c1;
        c[1] = c2;
        c[2] = c3;
        d[0] = d1;
        d[1] = d2;
        d[2] = d3;
        this.tetcircumcenter(a, b, c, d, circumcenter, null, null, null);
        double t1 = circumcenter[0] - a[0];
        t1 *= t1;
        double t2 = circumcenter[1] - a[1];
        t2 *= t2;
        double t3 = circumcenter[2] - a[2];
        t3 *= t3;
        return Math.sqrt(t1 + t2 + t3);
    }

    private void tricircumcenter3d(double[] a, double[] b, double[] c, double[] circumcenter) {
        double xba = b[0] - a[0];
        double yba = b[1] - a[1];
        double zba = b[2] - a[2];
        double xca = c[0] - a[0];
        double yca = c[1] - a[1];
        double zca = c[2] - a[2];
        double balength = xba * xba + yba * yba + zba * zba;
        double calength = xca * xca + yca * yca + zca * zca;
        double xcrossbc = yba * zca - yca * zba;
        double ycrossbc = zba * xca - zca * xba;
        double zcrossbc = xba * yca - xca * yba;
        double denominator = 0.5 / (xcrossbc * xcrossbc + ycrossbc * ycrossbc + zcrossbc * zcrossbc);
        double xcirca = ((balength * yca - calength * yba) * zcrossbc - (balength * zca - calength * zba) * ycrossbc) * denominator;
        double ycirca = ((balength * zca - calength * zba) * xcrossbc - (balength * xca - calength * xba) * zcrossbc) * denominator;
        double zcirca = ((balength * xca - calength * xba) * ycrossbc - (balength * yca - calength * yba) * xcrossbc) * denominator;
        circumcenter[0] = xcirca + a[0];
        circumcenter[1] = ycirca + a[1];
        circumcenter[2] = zcirca + a[2];
    }

    private double tricircumradius3d(double a1, double a2, double a3, double b1, double b2, double b3, double c1, double c2, double c3) {
        double[] a = new double[3];
        double[] b = new double[3];
        double[] c = new double[3];
        double[] circumcenter = new double[3];
        a[0] = a1;
        a[1] = a2;
        a[2] = a3;
        b[0] = b1;
        b[1] = b2;
        b[2] = b3;
        c[0] = c1;
        c[1] = c2;
        c[2] = c3;
        this.tricircumcenter3d(a, b, c, circumcenter);
        double t1 = circumcenter[0] - a[0];
        t1 *= t1;
        double t2 = circumcenter[1] - a[1];
        t2 *= t2;
        double t3 = circumcenter[2] - a[2];
        t3 *= t3;
        return Math.sqrt(t1 + t2 + t3);
    }

    private double inspheretri(double a1, double a2, double a3, double b1, double b2, double b3, double c1, double c2, double c3, double q1, double q2, double q3) {
        double[] a = new double[3];
        double[] b = new double[3];
        double[] c = new double[3];
        double[] q = new double[3];
        double[] circumcenter = new double[3];
        a[0] = a1;
        a[1] = a2;
        a[2] = a3;
        b[0] = b1;
        b[1] = b2;
        b[2] = b3;
        c[0] = c1;
        c[1] = c2;
        c[2] = c3;
        q[0] = q1;
        q[1] = q2;
        q[2] = q3;
        this.tricircumcenter3d(a, b, c, circumcenter);
        double t1 = circumcenter[0] - a[0];
        t1 *= t1;
        double t2 = circumcenter[1] - a[1];
        t2 *= t2;
        double t3 = circumcenter[2] - a[2];
        t3 *= t3;
        double r = t1 + t2 + t3;
        double s1 = circumcenter[0] - q[0];
        s1 *= s1;
        double s2 = circumcenter[1] - q[1];
        s2 *= s2;
        double s3 = circumcenter[2] - q[2];
        s3 *= s3;
        double u = s1 + s2 + s3;
        return r - u;
    }
}

