/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.math;

import ProGAL.math.Constants;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Polynomial {
    public final double[] coeff;
    private int deg;

    Polynomial() {
        this.coeff = new double[1];
        this.deg = 0;
    }

    public Polynomial(double[] pars) {
        this.coeff = pars;
        this.deg = pars.length - 1;
    }

    public Polynomial clone() {
        double[] coefficients = new double[this.coeff.length];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = this.coeff[i];
        }
        return new Polynomial(coefficients);
    }

    public boolean isZeroPolynomial() {
        return this.deg == 0 && this.coeff[0] == 0.0;
    }

    public boolean dominates(Polynomial p) {
        if (this.deg > p.deg) {
            return true;
        }
        if (this.deg < p.deg) {
            return false;
        }
        for (int i = this.deg; i >= 0; --i) {
            if (this.coeff[i] > p.coeff[i]) {
                return true;
            }
            if (!(this.coeff[i] < p.coeff[i])) continue;
            return false;
        }
        return false;
    }

    public Polynomial leadingTerm() {
        double[] coefficients = new double[this.deg + 1];
        coefficients[this.deg] = this.coeff[this.deg];
        return new Polynomial(coefficients);
    }

    public int getDeg() {
        return this.deg;
    }

    public Polynomial plus(Polynomial b) {
        int i;
        int degree;
        for (degree = Math.max(this.deg, b.deg); degree != -1 && degree <= this.deg && degree <= b.deg && this.coeff[degree] == -b.coeff[degree]; --degree) {
        }
        if (degree == -1) {
            return new Polynomial(new double[1]);
        }
        double[] coeff = new double[degree + 1];
        for (i = 0; i <= this.deg; ++i) {
            if (i > degree) continue;
            coeff[i] = this.coeff[i];
        }
        for (i = 0; i <= b.deg; ++i) {
            if (i > degree) continue;
            int n = i;
            coeff[n] = coeff[n] + b.coeff[i];
        }
        return new Polynomial(coeff);
    }

    public Polynomial minus(Polynomial b) {
        int i;
        int degree;
        for (degree = Math.max(this.deg, b.deg); degree != -1 && degree <= this.deg && degree <= b.deg && this.coeff[degree] == b.coeff[degree]; --degree) {
        }
        if (degree == -1) {
            return new Polynomial(new double[1]);
        }
        double[] coeff = new double[degree + 1];
        for (i = 0; i <= this.deg; ++i) {
            if (i > degree) continue;
            coeff[i] = this.coeff[i];
        }
        for (i = 0; i <= b.deg; ++i) {
            if (i > degree) continue;
            int n = i;
            coeff[n] = coeff[n] - b.coeff[i];
        }
        return new Polynomial(coeff);
    }

    public Polynomial times(Polynomial b) {
        double[] coeffZero = new double[]{0.0};
        Polynomial zero = new Polynomial(coeffZero);
        if (this.equal(zero) || b.equal(zero)) {
            return zero;
        }
        double[] coeff = new double[this.deg + b.deg + 1];
        for (int i = 0; i <= this.deg; ++i) {
            for (int j = 0; j <= b.deg; ++j) {
                int n = i + j;
                coeff[n] = coeff[n] + this.coeff[i] * b.coeff[j];
            }
        }
        return new Polynomial(coeff);
    }

    public Polynomial compose(Polynomial b) {
        double[] coeff = new double[this.deg + b.deg];
        for (int i = this.deg; i >= 0; --i) {
            for (int j = b.deg; j >= 0; --j) {
                int n = i + j;
                coeff[n] = coeff[n] + this.coeff[i] * b.coeff[j];
            }
        }
        return new Polynomial(coeff);
    }

    public boolean equal(Polynomial b) {
        if (this.deg != b.deg) {
            return false;
        }
        for (int i = this.deg; i >= 0; --i) {
            if (this.coeff[i] == b.coeff[i]) continue;
            return false;
        }
        return true;
    }

    public double evaluate(int x) {
        double p = 0.0;
        for (int i = this.deg; i >= 0; --i) {
            p = this.coeff[i] + (double)x * p;
        }
        return p;
    }

    public Polynomial toMonic() {
        Polynomial p = this.clone();
        for (int i = 0; i <= this.deg; ++i) {
            p.coeff[i] = p.coeff[i] / p.coeff[this.deg];
        }
        return p;
    }

    public Polynomial differentiate() {
        if (this.deg == 0) {
            return new Polynomial(new double[1]);
        }
        double[] par = new double[this.deg];
        for (int i = 0; i < this.deg; ++i) {
            par[i] = (double)(i + 1) * this.coeff[i + 1];
        }
        return new Polynomial(par);
    }

    public String toString() {
        if (this.deg == 0) {
            return "" + this.coeff[0];
        }
        if (this.deg == 1) {
            return this.coeff[1] + "x + " + this.coeff[0];
        }
        String s = this.coeff[this.deg] + "x^" + this.deg;
        for (int i = this.deg - 1; i >= 0; --i) {
            if (this.coeff[i] == 0.0) continue;
            if (this.coeff[i] > 0.0) {
                s = s + " + " + this.coeff[i];
            } else if (this.coeff[i] < 0.0) {
                s = s + " - " + -this.coeff[i];
            }
            if (i == 1) {
                s = s + "x";
                continue;
            }
            if (i <= 1) continue;
            s = s + "x^" + i;
        }
        return s;
    }

    public double[] calcRoots() {
        return Polynomial.calcRoots(this.coeff);
    }

    public static double[] calcRoots(double[] parameters) {
        if (parameters.length - 1 == 2) {
            return Polynomial.solveSecondDegree(parameters);
        }
        if (parameters.length - 1 == 3) {
            return Polynomial.solveThirdDegree(parameters);
        }
        return null;
    }

    public static double[] calcRoots(double a, double b, double c) {
        return Polynomial.solveSecondDegree(new double[]{a, b, c});
    }

    public static double[] calcRoots(double a, double b, double c, double d) {
        double[] roots = Polynomial.solveThirdDegree(new double[]{a, b, c, d});
        if (roots.length < 4) {
            return roots;
        }
        if (roots[3] > Constants.EPSILON) {
            return new double[]{roots[0]};
        }
        int l = 1;
        for (int i = 1; i < 3; ++i) {
            if (Double.isNaN(roots[i]) || roots[i - 1] == roots[i]) continue;
            ++l;
        }
        double[] ret = new double[l];
        l = 0;
        for (int i = 0; i < 3; ++i) {
            if (Double.isNaN(roots[i]) || i != 0 && roots[i - 1] == roots[i]) continue;
            ret[l++] = roots[i];
        }
        Arrays.sort(ret);
        return ret;
    }

    private static double[] solveQuadric(double p2, double p1, double p0) {
        double b = p1 / p2;
        double c = p0 / p2;
        double D = b * b - 4.0 * c;
        if (D > 0.0) {
            double sqrtD = Math.sqrt(D);
            return new double[]{(sqrtD - b) / 2.0, (-sqrtD - b) / 2.0};
        }
        if (D < 0.0) {
            return new double[0];
        }
        return new double[]{-b / 2.0};
    }

    public Double solveFirstDegree() {
        return -this.coeff[0] / this.coeff[1];
    }

    public Double[] solveSecondDegree() {
        double b = this.coeff[1];
        double a = this.coeff[2];
        double p = -0.5 * b / a;
        double c = this.coeff[0];
        double D = p * p - c / a;
        if (D < 0.0) {
            return new Double[0];
        }
        if (D == 0.0) {
            return new Double[]{p};
        }
        double sqD = Math.sqrt(D);
        return new Double[]{p - sqD, p + sqD};
    }

    private static double[] solveSecondDegree(double[] parameters) {
        double b = parameters[1];
        double a = parameters[2];
        double p = -0.5 * b / a;
        double c = parameters[0];
        double D = p * p - c / a;
        if (D < 0.0) {
            return new double[0];
        }
        if (D == 0.0) {
            return new double[]{p};
        }
        double sqD = Math.sqrt(D);
        return new double[]{p - sqD, p + sqD};
    }

    public static double[] solveThirdDegree(double[] parameters) {
        double im;
        double root3;
        double root2;
        double root1;
        if (parameters[0] == 0.0) {
            return Polynomial.solveSecondDegree(new double[]{parameters[1], parameters[2], parameters[3]});
        }
        double a = parameters[1] / parameters[0];
        double b = parameters[2] / parameters[0];
        double c = parameters[3] / parameters[0];
        double Q = (3.0 * b - a * a) / 9.0;
        double R = (9.0 * a * b - 27.0 * c - 2.0 * a * a * a) / 54.0;
        double D = Q * Q * Q + R * R;
        double aThirds = a / 3.0;
        if (D >= 0.0) {
            double sqrtD = Math.sqrt(D);
            double S = Polynomial.sign(R + sqrtD) * Math.cbrt(Math.abs(R + sqrtD));
            double T = Polynomial.sign(R - sqrtD) * Math.cbrt(Math.abs(R - sqrtD));
            root1 = -aThirds + S + T;
            root3 = root2 = -aThirds - (S + T) / 2.0;
            im = Math.abs(Constants.SQRT3 * (S - T) / 2.0);
        } else {
            double sqrtMQ = Math.sqrt(-Q);
            double th = Math.acos(R / (-Q * sqrtMQ));
            root1 = 2.0 * sqrtMQ * Math.cos(th / 3.0) - aThirds;
            root2 = 2.0 * sqrtMQ * Math.cos((th + Math.PI * 2) / 3.0) - aThirds;
            root3 = 2.0 * sqrtMQ * Math.cos((th + Math.PI * 4) / 3.0) - aThirds;
            im = 0.0;
        }
        return new double[]{root1, root2, root3, im};
    }

    private static double[] depressQuarticEquation(double[] parameters) {
        double a = parameters[0];
        double b = parameters[1];
        double c = parameters[2];
        double d = parameters[3];
        double e = parameters[4];
        return new double[]{a, 0.0, -3.0 * b * b / (8.0 * a) + c, b * b * b / (8.0 * a * a) - b * c / (2.0 * a) + d, -3.0 * b * b * b * b / (256.0 * a * a * a) + b * b * c / (16.0 * a * a) - b * d / (4.0 * a) + e};
    }

    private static double[] solveDepressedQuartic(double[] parameters) {
        double A = parameters[2];
        double B = parameters[3];
        double C = parameters[4];
        double[] thirdDegree = Polynomial.solveThirdDegree(new double[]{-8.0, 4.0 * A - 24.0 * Math.sqrt(C), 8.0 * A * Math.sqrt(C) - 16.0 * C, B * B});
        return thirdDegree;
    }

    private static double[] solveFourthDegree(double[] parameters) {
        if (parameters[0] == 0.0) {
            return Polynomial.solveThirdDegree(new double[]{parameters[1], parameters[2], parameters[3], parameters[4]});
        }
        double a1 = parameters[1] / parameters[0];
        double a2 = parameters[2] / parameters[0];
        double a3 = parameters[3] / parameters[0];
        double a4 = parameters[4] / parameters[0];
        double b1 = -a2;
        double b2 = a1 * a3 - 4.0 * a4;
        double b3 = 4.0 * a2 * a4 - a3 * a3 - a1 * a1 * a4;
        double[] cubicRoots = Polynomial.solveThirdDegree(new double[]{1.0, b1, b2, b3});
        double y1 = cubicRoots[0];
        double d1 = Math.sqrt(a1 * a1 - 4.0 * a2 + 4.0 * y1);
        double d2 = Math.sqrt(y1 - 4.0 * a4);
        double c1 = (a1 + d1) / 2.0;
        double c2 = (y1 * y1 - d2) / 2.0;
        double[] firstPair = Polynomial.solveSecondDegree(new double[]{1.0, c1, c2});
        c1 = (a1 - d1) / 2.0;
        c2 = (y1 * y1 + d2) / 2.0;
        double[] secondPair = Polynomial.solveSecondDegree(new double[]{1.0, c1, c2});
        return new double[]{firstPair[0], firstPair[1], secondPair[0], secondPair[1]};
    }

    public static Double[] solveQuartic(double[] c) {
        Double[] s;
        DecimalFormat newFormat = new DecimalFormat("#.#########");
        c[0] = Double.valueOf(newFormat.format(c[0]));
        c[1] = Double.valueOf(newFormat.format(c[1]));
        c[2] = Double.valueOf(newFormat.format(c[2]));
        c[3] = Double.valueOf(newFormat.format(c[3]));
        c[4] = Double.valueOf(newFormat.format(c[4]));
        Double[] roots = new Double[4];
        double[] coeffs = new double[4];
        int num = 0;
        double A = c[3] / c[4];
        double B = c[2] / c[4];
        double C = c[1] / c[4];
        double D = c[0] / c[4];
        double sq_A = A * A;
        double p = -0.375 * sq_A + B;
        double q = 0.125 * sq_A * A - 0.5 * A * B + C;
        double r = -0.01171875 * sq_A * sq_A + 0.0625 * sq_A * B - 0.25 * A * C + D;
        if (Math.abs(r) == 0.0) {
            coeffs[0] = q;
            coeffs[1] = p;
            coeffs[2] = 0.0;
            coeffs[3] = 1.0;
            s = Polynomial.solveCubic(coeffs);
            int sLen = 0;
            for (Double d : s) {
                if (d == null) continue;
                ++sLen;
            }
            num = sLen;
            roots[num++] = 0.0;
        } else {
            coeffs[0] = 0.5 * r * p - 0.125 * q * q;
            coeffs[1] = -r;
            coeffs[2] = -0.5 * p;
            coeffs[3] = 1.0;
            s = Polynomial.solveCubic(coeffs);
            double z = s[0];
            double u = z * z - r;
            double v = 2.0 * z - p;
            if (Math.abs(u) == 0.0) {
                u = 0.0;
            } else if (u > 0.0) {
                u = Math.sqrt(u);
            } else {
                return null;
            }
            if (Math.abs(v) == 0.0) {
                v = 0.0;
            } else if (v > 0.0) {
                v = Math.sqrt(v);
            } else {
                return null;
            }
            coeffs[0] = z - u;
            coeffs[1] = q < 0.0 ? -v : v;
            coeffs[2] = 1.0;
            Double[] s1 = Polynomial.solveQuadric(coeffs);
            coeffs[0] = z + u;
            coeffs[1] = q < 0.0 ? v : -v;
            coeffs[2] = 1.0;
            Double[] s2 = Polynomial.solveQuadric(coeffs);
            int s1Len = 0;
            int s2Len = 0;
            if (s1 != null) {
                for (Double d : s1) {
                    if (d == null) continue;
                    ++s1Len;
                }
            }
            if (s2 != null) {
                for (Double d : s2) {
                    if (d == null) continue;
                    ++s2Len;
                }
            }
            roots = new Double[s1Len + s2Len];
            int k = 0;
            if (s1Len > 0) {
                for (Double d : s1) {
                    if (d == null) break;
                    roots[k] = s1[k];
                    ++k;
                }
            }
            if (s2Len > 0) {
                for (Double d : s2) {
                    if (d == null) break;
                    roots[k] = s2[k % 2];
                    ++k;
                }
            }
            if ((num = s1Len + s2Len) == 0) {
                return null;
            }
        }
        double sub = 0.25 * A;
        int i = 0;
        while (i < num) {
            Double[] doubleArray = roots;
            int n = i++;
            Double.valueOf(doubleArray[n] - sub);
        }
        return roots;
    }

    public static Double[] solveCubic(double[] c) {
        int num;
        Double[] roots = new Double[3];
        double A = c[2] / c[3];
        double sq_A = A * A;
        double B = c[1] / c[3];
        double C = c[0] / c[3];
        double q = 0.5 * (0.07407407407407407 * A * sq_A - 0.3333333333333333 * A * B + C);
        double p = 0.3333333333333333 * (-0.3333333333333333 * sq_A + B);
        double cb_p = p * p * p;
        double D = q * q + cb_p;
        if (Math.abs(D) == 0.0) {
            if (Math.abs(q) < Constants.EPSILON) {
                roots[0] = 0.0;
                num = 1;
            } else {
                double u = Math.cbrt(-q);
                roots[0] = 2.0 * u;
                roots[1] = -u;
                num = 2;
            }
        } else if (D < 0.0) {
            double phi = 0.3333333333333333 * Math.acos(-q / Math.sqrt(-cb_p));
            double t = 2.0 * Math.sqrt(-p);
            roots[0] = t * Math.cos(phi);
            roots[1] = -t * Math.cos(phi + 1.0471975511965976);
            roots[2] = -t * Math.cos(phi - 1.0471975511965976);
            num = 3;
        } else {
            double sqrt_D = Math.sqrt(D);
            double u = Math.cbrt(sqrt_D - q);
            double v = -Math.cbrt(sqrt_D + q);
            roots[0] = u + v;
            num = 1;
        }
        double sub = 0.3333333333333333 * A;
        int i = 0;
        while (i < num) {
            Double[] doubleArray = roots;
            int n = i++;
            Double.valueOf(doubleArray[n] - sub);
        }
        return roots;
    }

    public static Double[] solveQuadric(double[] c) {
        Double[] roots = new Double[2];
        double p = c[1] / (2.0 * c[2]);
        double q = c[0] / c[2];
        double D = p * p - q;
        if (Math.abs(D) < Constants.EPSILON) {
            roots[0] = -p;
            return roots;
        }
        if (D < 0.0) {
            return null;
        }
        if (D > 0.0) {
            double sqrt_D = Math.sqrt(D);
            roots[0] = sqrt_D - p;
            roots[1] = -sqrt_D - p;
            return roots;
        }
        return null;
    }

    private double gcd(double a, double b) {
        while (b != 0.0) {
            double tmp = Math.abs(a) % Math.abs(b);
            a = Math.abs(b);
            b = tmp;
            if (!(Math.abs(b) <= Constants.EPSILON)) continue;
            b = 0.0;
        }
        return a;
    }

    public List<Polynomial> squareFreeFact() {
        double gcd1 = this.gcd(this.coeff[4], this.coeff[3]);
        double gcd2 = this.gcd(gcd1, this.coeff[2]);
        double gcd3 = this.gcd(gcd2, this.coeff[1]);
        double gcd4 = this.gcd(gcd3, this.coeff[0]);
        System.out.println("GCD = " + gcd4);
        System.out.println("Old f = " + this.toString());
        double[] f_newCoeff = new double[]{this.coeff[0] / gcd4, this.coeff[1] / gcd4, this.coeff[2] / gcd4, this.coeff[3] / gcd4, this.coeff[4] / gcd4};
        Polynomial f_new = new Polynomial(f_newCoeff);
        System.out.println("New f = " + f_new.toString());
        System.out.println("SquareFree going!");
        List<Object> ret = new ArrayList();
        Polynomial fPrime = this.differentiate();
        System.out.println("func' = " + fPrime.toString());
        Polynomial d = Polynomial.gcd(this, fPrime);
        System.out.println("d1 = " + d.toString());
        Polynomial e = this.longDivision(d)[0];
        System.out.println("e1 = " + e.toString());
        double[] coeffOne = new double[]{1.0};
        Polynomial one = new Polynomial(coeffOne);
        while (!d.equal(one)) {
            Polynomial dPrime = d.differentiate();
            System.out.println("d = " + d.toString());
            System.out.println("dPrime = " + dPrime.toString());
            Polynomial d_new = Polynomial.gcd(d, dPrime);
            System.out.println("d_new = " + d_new.toString());
            Polynomial e_new = d.longDivision(d_new)[0];
            System.out.println("eNew = d/dNew = " + d.toString() + " / " + d_new.toString());
            System.out.println("e/eNew = " + e.toString() + " / " + e_new.toString());
            System.out.println("         " + e.longDivision(e_new)[0]);
            ret.add(e.longDivision(e_new)[0].makeMonic());
            if (d_new.equal(one)) {
                ret.add(d);
            }
            d = d_new;
            e = e_new;
            double greatCoeff = d.coeff[d.deg];
            for (int i = 0; i < d.deg + 1; ++i) {
                d.coeff[i] = d.coeff[i] / greatCoeff;
            }
        }
        if (ret.size() == 0) {
            ret = this.makeMonic().distinctFact();
        }
        System.out.println("SFF result = " + ret.toString());
        return ret;
    }

    public static Polynomial gcd(Polynomial a, Polynomial b) {
        if (b.deg > a.deg) {
            Polynomial tmp = a;
            a = b;
            b = tmp;
        }
        do {
            System.out.println("gcd Call");
            Polynomial r = a.longDivision(b)[1];
            System.out.println("intermediate remaining = " + r.toString());
            a = b;
            b = r;
        } while (b.deg != 0 || !(Math.abs(b.coeff[0]) < Constants.EPSILON));
        return a.makeMonic();
    }

    private Polynomial[] longDivision(Polynomial d) {
        if (d == null) {
            System.out.println("d is null!");
            return null;
        }
        Polynomial[] ret = new Polynomial[2];
        double[] coeffZero = new double[]{0.0};
        Polynomial q = new Polynomial(coeffZero);
        Polynomial zero = new Polynomial(coeffZero);
        if (d.equal(zero)) {
            System.out.println("d is zero!");
            return null;
        }
        Polynomial r = this;
        int dDeg = d.deg;
        System.out.println("New longDivision round!");
        while (r.deg >= dDeg) {
            Polynomial t = this.leadDiv(r, d);
            if (t == null) {
                ret[0] = q;
                ret[1] = zero;
                return ret;
            }
            System.out.println("t = " + t.toString());
            q = q.plus(t);
            r = r.minus(t.times(d));
            if (r.deg != 0 || !(Math.abs(r.coeff[0]) < Constants.EPSILON)) continue;
            break;
        }
        ret[0] = q;
        ret[1] = r;
        return ret;
    }

    private Polynomial leadDiv(Polynomial r, Polynomial d) {
        int rDeg = r.deg;
        int dDeg = d.deg;
        int newDeg = rDeg - dDeg;
        double coef = r.coeff[rDeg] / d.coeff[dDeg];
        if (Math.abs(coef) < Constants.EPSILON) {
            return null;
        }
        double[] pars = new double[newDeg + 1];
        pars[newDeg] = coef;
        return new Polynomial(pars);
    }

    public Polynomial makeMonic() {
        double div = this.coeff[this.deg];
        double[] monicPars = new double[this.deg + 1];
        monicPars[this.deg] = 1.0;
        for (int i = 0; i < this.deg; ++i) {
            monicPars[i] = this.coeff[i] / div;
            if (!(Math.abs(monicPars[i]) <= Constants.EPSILON + 1.0) || !(Math.abs(monicPars[i]) >= 1.0 - Constants.EPSILON)) continue;
            System.out.println("rounding : " + monicPars[i]);
            System.out.println("because    " + Math.abs(monicPars[i]) + " <= " + (Constants.EPSILON + 1.0));
            monicPars[i] = 1.0;
        }
        return new Polynomial(monicPars);
    }

    private List<Polynomial> distinctFact() {
        ArrayList<Polynomial> ret = new ArrayList<Polynomial>();
        Polynomial f = this;
        double[] coeffOne = new double[]{1.0};
        Polynomial one = new Polynomial(coeffOne);
        int i = 1;
        while (f.getDeg() >= 2 * i) {
            double[] tmpPars = new double[i + 1];
            tmpPars[i] = 1.0;
            tmpPars[1] = -1.0;
            Polynomial g = Polynomial.gcd(f, new Polynomial(tmpPars));
            if (!g.equal(one)) {
                ret.add(g);
                f = f.longDivision(g)[0];
            }
            ++i;
        }
        if (!f.equal(one)) {
            ret.add(f);
        }
        return ret;
    }

    private static double sign(double n) {
        return n < 0.0 ? -1.0 : 1.0;
    }

    public int numberPositiveRoots() {
        int count = 0;
        for (int i = 0; i < this.deg; ++i) {
            if (!(this.coeff[i] * this.coeff[i + 1] < 0.0)) continue;
            ++count;
        }
        return count;
    }

    public int numberNegativeRoots() {
        int count = this.deg + 1 - this.numberPositiveRoots();
        for (int i = 1; i <= this.deg; ++i) {
            if (this.coeff[i] != 0.0) continue;
            --count;
        }
        return count;
    }

    public static double solveHighDegree(double[] a) {
        boolean convergence = false;
        boolean divisionByZero = false;
        double x = 1.0;
        double xNext = 1.0;
        double[] d = new double[a.length - 1];
        for (int j = 0; j < d.length; ++j) {
            d[j] = (double)(j + 1) * a[j + 1];
        }
        double tolerance = 1.0E-8;
        int maxIterations = 100;
        double num = 0.0;
        double denum = 0.0;
        int i = 0;
        while (i < maxIterations && !convergence && !divisionByZero) {
            ++i;
            num = a[a.length - 2] + x * a[a.length - 1];
            denum = d[a.length - 2];
            for (int j = a.length - 3; j >= 0; --j) {
                num = a[j] + x * num;
                denum = d[j] + x * denum;
            }
            if (Math.abs(denum) < Constants.EPSILON) {
                System.out.println("WARNING: denominator is too small");
                divisionByZero = true;
                continue;
            }
            xNext = x - num / denum;
            if (Math.abs(xNext - x) < tolerance) {
                convergence = true;
            }
            x = xNext;
        }
        if (divisionByZero) {
            System.out.println("WARNING: division by zero");
        }
        if (convergence) {
            if (Math.abs(num) > Constants.EPSILON) {
                System.out.println("WARNING: convergence not to the root");
            }
            return xNext;
        }
        System.out.println("WARNING: solution not within specified tolerance");
        return xNext;
    }

    public static void main(String[] args) {
        double[] solution = Polynomial.solveQuadric(3.0, -2.0, -5.0);
        double[] depressedQuartic = Polynomial.depressQuarticEquation(new double[]{1.0, 8.0, 12.0, 2.0 * Math.sqrt(30.0) - 16.0, 4.0 * Math.sqrt(30.0) - 28.0});
        Polynomial.solveDepressedQuartic(depressedQuartic);
        Polynomial.solveFourthDegree(new double[]{3.0, 6.0, -123.0, -126.0, 1080.0});
    }
}

