/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;

public class JoinDataSet
extends AbstractDataSet {
    private static final int NO_DATASET_SIZE = 999;
    List<QDataSet> datasets;
    int rank;

    public static QDataSet deepCopy(QDataSet rds) {
        if (DataSetUtil.isQube(rds)) {
            return ArrayDataSet.copy(rds);
        }
        JoinDataSet result = new JoinDataSet(rds.rank());
        for (int i = 0; i < rds.length(); ++i) {
            QDataSet s1 = rds.slice(i);
            if (DataSetUtil.isQube(s1)) {
                result.join(ArrayDataSet.copy(s1));
                continue;
            }
            result.join(JoinDataSet.deepCopy(s1));
        }
        Map<String, Object> srcProps = DataSetUtil.getProperties(rds);
        DataSetUtil.putProperties(srcProps, result);
        return result;
    }

    public JoinDataSet(int rank) {
        this.rank = rank;
        this.putProperty("JOIN_0", DDataSet.create(new int[0]));
        this.datasets = new ArrayList<QDataSet>();
    }

    public JoinDataSet(QDataSet ds1) {
        this(ds1.rank() + 1);
        this.join(ds1);
    }

    public static JoinDataSet copy(JoinDataSet joinDataSet) {
        JoinDataSet result = new JoinDataSet(joinDataSet.rank());
        result.datasets.addAll(joinDataSet.datasets);
        DataSetUtil.putProperties(joinDataSet.properties, result);
        DataSetUtil.putProperties(DataSetUtil.getProperties(joinDataSet), result);
        result.putProperty("DEPEND_0", joinDataSet.property("DEPEND_0"));
        result.putProperty("JOIN_0", joinDataSet.property("JOIN_0"));
        return result;
    }

    public void joinAll(JoinDataSet ds1) {
        for (int j = 0; j < ds1.length(); ++j) {
            this.join(ds1.slice(j));
        }
        QDataSet dep0 = (QDataSet)ds1.property("DEPEND_0");
        if (dep0 != null) {
            QDataSet thisDep0 = (QDataSet)this.property("DEPEND_0");
            if (thisDep0 != null) {
                DDataSet dd1;
                DDataSet dd = (DDataSet)DDataSet.maybeCopy(thisDep0);
                if (!dd.canAppend(dd1 = (DDataSet)DDataSet.maybeCopy(dep0))) {
                    dd.grow(dd.length() + dd1.length());
                }
                dd.append(dd1);
                this.putProperty("DEPEND_0", dd);
            } else {
                throw new IllegalArgumentException("joinAll datasets one has depend_0 but other doesn't");
            }
        }
    }

    public final void join(QDataSet ds) {
        QDataSet dep0;
        QDataSet context;
        if (ds == null) {
            throw new IllegalArgumentException("dataset is null");
        }
        if (ds.rank() != this.rank - 1) {
            throw new IllegalArgumentException("dataset rank must be " + (this.rank - 1) + ", it is rank " + ds.rank());
        }
        if (this.properties.get("JOIN_0") != null && this.datasets.size() > 0) {
            QDataSet firstDataSet = this.datasets.get(0);
            Units units0 = SemanticOps.getUnits(firstDataSet);
            Units units1 = SemanticOps.getUnits(ds);
            if (!units1.isConvertibleTo(units0)) {
                this.properties.remove("JOIN_0");
                this.properties.remove("UNITS");
            } else if (units0 == units1) {
                this.properties.put("UNITS", units0);
            }
        }
        if (ds.rank() == 0 && (context = (QDataSet)ds.property("CONTEXT_0")) != null && (dep0 = (QDataSet)this.property("DEPEND_0")) instanceof JoinDataSet) {
            ((JoinDataSet)dep0).join(context);
        }
        this.datasets.add(ds);
    }

    public final void join(int index, QDataSet ds) {
        if (ds == null) {
            throw new IllegalArgumentException("dataset is null");
        }
        if (ds.rank() != this.rank - 1) {
            throw new IllegalArgumentException("dataset rank must be " + (this.rank - 1) + ", it is rank " + ds.rank());
        }
        if (index == this.datasets.size()) {
            this.datasets.add(index, ds);
        } else {
            this.datasets.set(index, ds);
        }
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public double value(int i0) {
        if (this.rank != 1) {
            throw new IllegalArgumentException("rank 1 access on rank " + this.rank + " join dataset");
        }
        return this.datasets.get(i0).value();
    }

    @Override
    public double value(int i0, int i1) {
        if (this.rank != 2) {
            throw new IllegalArgumentException("rank 2 access on rank " + this.rank + " join dataset");
        }
        return this.datasets.get(i0).value(i1);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        if (this.rank != 3) {
            throw new IllegalArgumentException("rank 3 access on rank " + this.rank + " join dataset");
        }
        return this.datasets.get(i0).value(i1, i2);
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        if (this.rank != 4) {
            throw new IllegalArgumentException("rank 4 access on rank " + this.rank + " join dataset");
        }
        return this.datasets.get(i0).value(i1, i2, i3);
    }

    @Override
    public Object property(String name, int i0) {
        Object result = super.property(name, i0);
        if (result == null) {
            if (i0 >= this.datasets.size()) {
                throw new IndexOutOfBoundsException("no dataset at index: " + i0);
            }
            return this.datasets.get(i0).property(name);
        }
        return result;
    }

    @Override
    public Object property(String name) {
        Object result = this.properties.get(name);
        if (result == null && name.equals("UNITS") && this.datasets.size() > 0) {
            Object p1;
            Object p0 = this.datasets.get(0).property(name);
            if (p0 == (p1 = this.datasets.get(this.datasets.size() - 1).property(name)) || p0 != null && p0.equals(p1)) {
                return p0;
            }
            return null;
        }
        return result;
    }

    @Override
    public final void putProperty(String name, Object value) {
        super.putProperty(name, value);
        if (name.equals("DEPEND_0")) {
            super.putProperty("JOIN_0", null);
        }
    }

    @Override
    public int length() {
        return this.datasets.size();
    }

    @Override
    public int length(int i0) {
        if (this.datasets.isEmpty() && i0 == 0) {
            return 999;
        }
        return this.datasets.get(i0).length();
    }

    @Override
    public int length(int i0, int i1) {
        if (this.datasets.isEmpty() && i0 == 0) {
            return 999;
        }
        return this.datasets.get(i0).length(i1);
    }

    @Override
    public int length(int i0, int i1, int i2) {
        if (this.datasets.isEmpty() && i0 == 0) {
            return 999;
        }
        return this.datasets.get(i0).length(i1, i2);
    }

    @Override
    public String toString() {
        return DataSetUtil.toString(this);
    }

    @Override
    public JoinDataSet trim(int imin, int imax) {
        JoinDataSet result = new JoinDataSet(this.rank);
        result.datasets = new ArrayList<QDataSet>(imax - imin);
        result.datasets.addAll(this.datasets.subList(imin, imax));
        result.properties.putAll(this.properties);
        QDataSet dep0 = (QDataSet)this.property("DEPEND_0");
        if (dep0 != null) {
            result.properties.put("DEPEND_0", dep0.trim(imin, imax));
        }
        for (int i = 1; i < this.rank; ++i) {
            QDataSet dep = (QDataSet)this.property("DEPEND_" + i);
            if (dep == null || dep.rank() <= 1) continue;
            result.properties.put("DEPEND_" + i, dep.trim(imin, imax));
        }
        return result;
    }

    @Override
    public QDataSet slice(int idx) {
        QDataSet result = this.datasets.get(idx);
        MutablePropertyDataSet mpds = DataSetOps.makePropertiesMutable(result);
        Map<String, Object> props = DataSetOps.sliceProperties0(idx, this.properties);
        DataSetUtil.putProperties(props, mpds);
        mpds.makeImmutable();
        return result;
    }
}

