/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;

public final class RepeatIndexDataSet
extends AbstractDataSet {
    QDataSet source;
    int count;
    int insertIndex;

    public RepeatIndexDataSet(QDataSet s, int insertIndex, int length) {
        this.source = s;
        if (s.rank() > 3) {
            throw new IllegalArgumentException("rank must be less than 4");
        }
        this.count = length;
        this.insertIndex = insertIndex;
        if (DataSetUtil.isQube(s)) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
    }

    @Override
    public int rank() {
        return this.source.rank() + 1;
    }

    @Override
    public double value(int il) {
        return this.source.value();
    }

    @Override
    public double value(int i0, int i1) {
        if (this.insertIndex == 1) {
            return this.source.value(i0);
        }
        return this.source.value(i1);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        assert (this.insertIndex >= 0);
        assert (this.insertIndex < 4);
        switch (this.insertIndex) {
            case 0: {
                return this.source.value(i1, i2);
            }
            case 1: {
                return this.source.value(i0, i2);
            }
            case 2: {
                return this.source.value(i0, i1);
            }
        }
        throw new RuntimeException("implementation error");
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        assert (this.insertIndex >= 0);
        assert (this.insertIndex < 4);
        switch (this.insertIndex) {
            case 0: {
                return this.source.value(i1, i2, i3);
            }
            case 1: {
                return this.source.value(i0, i2, i3);
            }
            case 2: {
                return this.source.value(i0, i1, i3);
            }
            case 3: {
                return this.source.value(i0, i1, i2);
            }
        }
        throw new RuntimeException("implementation error");
    }

    @Override
    public int length() {
        if (this.insertIndex == 0) {
            return this.count;
        }
        return this.source.length();
    }

    @Override
    public int length(int i) {
        switch (this.insertIndex) {
            case 0: {
                return this.source.length();
            }
            case 1: {
                return this.count;
            }
            case 2: {
                return this.source.length(i);
            }
            case 3: {
                return this.source.length(i);
            }
        }
        throw new RuntimeException("implementation error");
    }

    @Override
    public int length(int i0, int i1) {
        switch (this.insertIndex) {
            case 0: {
                return this.source.length(i0);
            }
            case 1: {
                return this.source.length(i0);
            }
            case 2: {
                return this.count;
            }
            case 3: {
                return this.source.length(i0, i1);
            }
        }
        throw new RuntimeException("implementation error");
    }

    @Override
    public int length(int i0, int i1, int i2) {
        assert (this.insertIndex >= 0);
        assert (this.insertIndex < 4);
        switch (this.insertIndex) {
            case 0: {
                return this.source.length(i1, i2);
            }
            case 1: {
                return this.source.length(i0, i2);
            }
            case 2: {
                return this.source.length(i0, i1);
            }
            case 3: {
                return this.count;
            }
        }
        throw new RuntimeException("implementation error");
    }

    @Override
    public Object property(String name) {
        Object o = super.property(name);
        return o == null ? this.source.property(name) : o;
    }

    @Override
    public Object property(String name, int i) {
        Object o = super.property(name);
        if (o != null) {
            return o;
        }
        if (this.insertIndex == 0) {
            return this.source.property(name);
        }
        return this.source.property(name, i);
    }
}

