/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.Slice0DataSet;

public class TrimDataSet
extends AbstractDataSet {
    final int offset;
    final int len;
    final QDataSet ds;

    public TrimDataSet(QDataSet ds, int start, int stop) {
        String[] p;
        String prop;
        QDataSet plane0;
        QDataSet bds3;
        QDataSet bds2;
        QDataSet dep1;
        QDataSet bundle0;
        if (ds.rank() > 4) {
            throw new IllegalArgumentException("rank>4 not supported");
        }
        if (ds.rank() < 1) {
            throw new IllegalArgumentException("trim called on a rank 0 dataset");
        }
        this.ds = ds;
        this.offset = start;
        this.len = stop - start;
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            this.putProperty("DEPEND_0", new TrimDataSet(dep0, start, stop));
        }
        if ((bundle0 = (QDataSet)ds.property("BUNDLE_0")) != null) {
            this.putProperty("BUNDLE_0", new TrimDataSet(bundle0, start, stop));
        }
        if ((dep1 = (QDataSet)ds.property("DEPEND_1")) != null && dep1.rank() == 2) {
            this.putProperty("DEPEND_1", new TrimDataSet(dep1, start, stop));
        } else if (dep1 != null) {
            this.putProperty("DEPEND_1", dep1);
        }
        QDataSet dep2 = (QDataSet)ds.property("DEPEND_2");
        if (dep2 != null && dep2.rank() == 2) {
            this.putProperty("DEPEND_2", new TrimDataSet(dep2, start, stop));
        } else if (dep2 != null) {
            this.putProperty("DEPEND_2", dep2);
        }
        QDataSet dep3 = (QDataSet)ds.property("DEPEND_3");
        if (dep3 != null && dep3.rank() == 2) {
            this.putProperty("DEPEND_3", new TrimDataSet(dep3, start, stop));
        } else if (dep3 != null) {
            this.putProperty("DEPEND_3", dep3);
        }
        QDataSet bds1 = (QDataSet)ds.property("BUNDLE_1");
        if (bds1 != null) {
            this.putProperty("BUNDLE_1", bds1);
        }
        if ((bds2 = (QDataSet)ds.property("BUNDLE_2")) != null) {
            this.putProperty("BUNDLE_2", bds2);
        }
        if ((bds3 = (QDataSet)ds.property("BUNDLE_3")) != null) {
            this.putProperty("BUNDLE_3", bds3);
        }
        for (int i = 0; i < 50 && (plane0 = (QDataSet)ds.property(prop = "PLANE_" + i)) != null; ++i) {
            if (plane0.rank() < 1) {
                this.putProperty(prop, plane0);
                continue;
            }
            this.putProperty(prop, new TrimDataSet(plane0, start, stop));
        }
        for (String p1 : p = DataSetUtil.correlativeProperties()) {
            QDataSet delta = (QDataSet)ds.property(p1);
            if (delta == null || delta.rank() <= 0) continue;
            this.putProperty(p1, new TrimDataSet(delta, start, stop));
        }
    }

    @Override
    public int rank() {
        return this.ds.rank();
    }

    @Override
    public double value(int i) {
        return this.ds.value(this.offset + i);
    }

    @Override
    public double value(int i0, int i1) {
        return this.ds.value(i0 + this.offset, i1);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.ds.value(i0 + this.offset, i1, i2);
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.ds.value(i0 + this.offset, i1, i2, i3);
    }

    @Override
    public Object property(String name) {
        Object p = super.property(name);
        if (p != null) {
            return p;
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name);
        }
        return null;
    }

    @Override
    public Object property(String name, int i) {
        Object p = super.property(name, i);
        if (p != null) {
            return p;
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name, i + this.offset);
        }
        return null;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public int length(int i0) {
        return this.ds.length(this.offset + i0);
    }

    @Override
    public int length(int i0, int i1) {
        return this.ds.length(this.offset + i0, i1);
    }

    @Override
    public int length(int i0, int i1, int i2) {
        return this.ds.length(this.offset + i0, i1, i2);
    }

    @Override
    public QDataSet slice(int i) {
        return new Slice0DataSet(this.ds, this.offset + i);
    }

    @Override
    public QDataSet trim(int start, int end) {
        if (start == 0 && end == this.len) {
            return this;
        }
        if (start > this.len) {
            throw new IndexOutOfBoundsException("start=" + start + " > " + this.len);
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("start=" + start + " < 0");
        }
        if (end > this.len) {
            throw new IndexOutOfBoundsException("end=" + end + " > " + this.len);
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException("end=" + end + " < 0");
        }
        if (start > end) {
            throw new IllegalArgumentException("trim called with start>end: " + start + ">" + end);
        }
        return new TrimDataSet(this.ds, start + this.offset, end + this.offset);
    }
}

