/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.das2.qds.QDataSet;
import org.das2.qds.filters.FilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanelUtil;

public class CollapseFilterEditorPanel
extends JPanel
implements FilterEditorPanel {
    private JComboBox dimensionCB;
    private JLabel jLabel2;

    public CollapseFilterEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.dimensionCB = new JComboBox();
        this.jLabel2.setText("Collapse Dimension:");
        this.dimensionCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dimensionCB, 0, 267, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dimensionCB, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public String getFilter() {
        return String.format("|collapse%d()", this.dimensionCB.getSelectedIndex());
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile("\\|collapse(\\d)\\(\\)");
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            this.dimensionCB.setSelectedIndex(Integer.parseInt(m.group(1)));
        }
    }

    @Override
    public void setInput(QDataSet ds) {
        String[] depNames1 = FilterEditorPanelUtil.getDimensionNames(ds);
        int index = this.dimensionCB.getSelectedIndex();
        this.dimensionCB.setModel(new DefaultComboBoxModel<String>(depNames1));
        try {
            this.dimensionCB.setSelectedIndex(index);
        }
        catch (IllegalArgumentException ex) {
            this.dimensionCB.setSelectedIndex(depNames1.length - 1);
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public boolean validateFilter(String filter, QDataSet in) {
        return true;
    }

    @Override
    public void setExpertMode(boolean expert) {
        this.dimensionCB.setEnabled(expert);
    }
}

