/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.das2.qds.filters.AbstractFilterEditorPanel;

public class PutPropertyFilterEditorPanel
extends AbstractFilterEditorPanel {
    private JLabel documentationLabel;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;

    public PutPropertyFilterEditorPanel() {
        this.initComponents();
    }

    private void update() {
        String name = (String)this.jComboBox1.getSelectedItem();
        String[] vv = null;
        switch (name) {
            case "VALID_MIN": {
                vv = new String[]{"-1e30", "-999", "0", "1"};
                this.documentationLabel.setText("the smallest valid value");
                break;
            }
            case "VALID_MAX": {
                vv = new String[]{"1e30", "999", "0"};
                this.documentationLabel.setText("the largest valid value");
                break;
            }
            case "DELTA_MINUS": {
                vv = new String[]{"None"};
                this.documentationLabel.setText("use None to remove error bars");
                break;
            }
            case "DELTA_PLUS": {
                vv = new String[]{"None"};
                this.documentationLabel.setText("use None to remove error bars");
                break;
            }
            case "FILL_VALUE": {
                vv = new String[]{"0", "-999", "-1e31"};
                this.documentationLabel.setText("values that indicate missing measurements");
                break;
            }
            case "DEPEND_0": {
                vv = new String[]{"None"};
                this.documentationLabel.setText("use None to remove the DEPEND_0 tags");
                break;
            }
            case "FORMAT": {
                vv = new String[]{"%5.2f", "%d", "%05d", "%x"};
                this.documentationLabel.setText("format specifier for digital display");
                break;
            }
            case "UNITS": {
                vv = new String[]{"None"};
                this.documentationLabel.setText("reset the units");
                break;
            }
            case "NAME": {
                vv = new String[]{"MyData"};
                this.documentationLabel.setText("set the name used for the data");
                break;
            }
            case "METADATA.NOMINAL_RANGE": {
                vv = new String[]{"0 to 100"};
                this.documentationLabel.setText("set the nominal range for the data");
                break;
            }
            case "METADATA.WARN_RANGE": {
                vv = new String[]{"-1 to 150"};
                this.documentationLabel.setText("set the warning range for the data");
                break;
            }
            default: {
                vv = new String[]{""};
                this.documentationLabel.setText(" ");
            }
        }
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(vv));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jComboBox2 = new JComboBox();
        this.documentationLabel = new JLabel();
        this.jLabel1.setText("Put Property");
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"VALID_MIN", "VALID_MAX", "FILL_VALUE", "TITLE", "LABEL", "NAME", "DEPEND_0", "FORMAT", "DELTA_PLUS", "DELTA_MINUS", "UNITS", "METADATA.WARN_RANGE", "METADATA.NOMINAL_RANGE", " "}));
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PutPropertyFilterEditorPanel.this.jComboBox1ItemStateChanged(evt);
            }
        });
        this.jComboBox2.setEditable(true);
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.documentationLabel.setText("jLabel2");
        this.documentationLabel.setToolTipText("");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.documentationLabel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jComboBox1, -2, 186, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, -2, 185, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.documentationLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        this.update();
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile("\\|putProperty\\((\\S+),(\\S+)\\)");
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            this.jComboBox1.setSelectedItem(m.group(1));
            this.update();
            this.jComboBox2.setSelectedItem(m.group(2));
            return;
        }
        p = Pattern.compile("\\|putProperty\\((\\S+),\\'(.+)\\'\\)");
        m = p.matcher(filter);
        if (m.matches()) {
            this.jComboBox1.setSelectedItem(m.group(1));
            this.update();
            this.jComboBox2.setSelectedItem(m.group(2));
        }
    }

    @Override
    public String getFilter() {
        String s = String.valueOf(this.jComboBox2.getSelectedItem());
        if (s.contains(" ")) {
            return "|putProperty(" + this.jComboBox1.getSelectedItem() + ",'" + s + "')";
        }
        return "|putProperty(" + this.jComboBox1.getSelectedItem() + "," + s + ")";
    }
}

