/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.ops;

import ProGAL.geom2d.Point;
import ProGAL.geom2d.delaunay.DTWithBigPoints;
import ProGAL.geom2d.delaunay.Triangle;
import ProGAL.geom2d.delaunay.Vertex;
import ProGAL.geom3d.PointWeighted;
import ProGAL.geom3d.tessellation.BowyerWatson.RegularTessellation;
import ProGAL.geom3d.tessellation.BowyerWatson.Tetr;
import java.awt.Color;
import java.lang.reflect.Array;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math.special.Gamma;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.math.filter.Butterworth;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.BDataSet;
import org.das2.qds.BundleDataSet;
import org.das2.qds.CdfSparseDataSet;
import org.das2.qds.ConstantDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetAnnotations;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.FDataSet;
import org.das2.qds.IDataSet;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.IndexListDataSetIterator;
import org.das2.qds.JoinDataSet;
import org.das2.qds.LDataSet;
import org.das2.qds.LongReadAccess;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.ReplicateDataSet;
import org.das2.qds.ReverseDataSet;
import org.das2.qds.SDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.SortDataSet;
import org.das2.qds.SparseDataSet;
import org.das2.qds.SubsetDataSet;
import org.das2.qds.TagGenDataSet;
import org.das2.qds.TailBundleDataSet;
import org.das2.qds.TransposeRank2DataSet;
import org.das2.qds.TrimStrideWrapper;
import org.das2.qds.WritableDataSet;
import org.das2.qds.WritableJoinDataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.demos.RipplesDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.math.Contour;
import org.das2.qds.math.fft.ComplexArray;
import org.das2.qds.math.fft.GeneralFFT;
import org.das2.qds.math.fft.WaveformToSpectrum;
import org.das2.qds.ops.CoerceUtil;
import org.das2.qds.util.AutoHistogram;
import org.das2.qds.util.BinAverage;
import org.das2.qds.util.DataSetBuilder;
import org.das2.qds.util.FFTUtil;
import org.das2.qds.util.LSpec;
import org.das2.qds.util.LinFit;
import org.das2.util.ClassMap;
import org.das2.util.ColorUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;
import org.das2.util.monitor.UncheckedCancelledOperationException;

public final class Ops {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset.ops");
    private static final String CLASSNAME = Ops.class.getCanonicalName();
    private static final String[] _dependProperties = new String[]{"DEPEND_0", "DEPEND_1", "DEPEND_2", "DEPEND_3", "BINS_0", "BINS_1"};
    private static Random random = new Random();
    public static final double PI = Math.PI;
    public static final double TAU = Math.PI * 2;
    public static final double E = Math.E;

    private Ops() {
    }

    public static MutablePropertyDataSet applyUnaryOp(QDataSet ds1, UnaryOp op) {
        WritableDataSet result = SemanticOps.isJoin(ds1) || !DataSetUtil.isQube(ds1) ? Ops.copy(ds1) : DDataSet.create(DataSetUtil.qubeDims(ds1));
        QDataSet wds = DataSetUtil.weightsDataSet(ds1);
        double fill = -1.0E38;
        int n0 = ds1.rank() == 0 ? 0 : ds1.length();
        switch (ds1.rank()) {
            case 1: {
                for (int i = 0; i < n0; ++i) {
                    double w1 = wds.value(i);
                    result.putValue(i, w1 == 0.0 ? fill : op.op(ds1.value(i)));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n0; ++i) {
                    int n1 = ds1.length(i);
                    for (int j = 0; j < n1; ++j) {
                        double w1 = wds.value(i, j);
                        result.putValue(i, j, w1 == 0.0 ? fill : op.op(ds1.value(i, j)));
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n0; ++i) {
                    int n1 = ds1.length(i);
                    for (int j = 0; j < n1; ++j) {
                        int n2 = ds1.length(i, j);
                        for (int k = 0; k < n2; ++k) {
                            double w1 = wds.value(i, j, k);
                            result.putValue(i, j, k, w1 == 0.0 ? fill : op.op(ds1.value(i, j, k)));
                        }
                    }
                }
                break;
            }
            default: {
                QubeDataSetIterator it1 = new QubeDataSetIterator(ds1);
                while (it1.hasNext()) {
                    it1.next();
                    double d1 = it1.getValue(ds1);
                    double w1 = it1.getValue(wds);
                    it1.putValue(result, w1 == 0.0 ? fill : op.op(d1));
                }
                break block0;
            }
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("DEPEND_0", ds1.property("DEPEND_0"));
        m.put("DEPEND_1", ds1.property("DEPEND_1"));
        m.put("DEPEND_2", ds1.property("DEPEND_2"));
        m.put("DEPEND_3", ds1.property("DEPEND_3"));
        DataSetUtil.putProperties(m, result);
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static MutablePropertyDataSet applyUnaryOp(Object ds1, UnaryOp op) {
        return Ops.applyUnaryOp(Ops.dataset(ds1), op);
    }

    private static void applyProperties(QDataSet ds1, QDataSet ds2, MutablePropertyDataSet result) {
        String[] ss;
        boolean resultIsQube;
        Map<String, Object> m1 = DataSetUtil.getProperties(ds1, _dependProperties, null);
        Map<String, Object> m2 = DataSetUtil.getProperties(ds2, _dependProperties, null);
        boolean bl = resultIsQube = Boolean.TRUE.equals(m1.get("QUBE")) || Boolean.TRUE.equals(m2.get("QUBE"));
        if (m1.size() == 1) {
            m1.remove("QUBE");
        }
        if (m2.size() == 1) {
            m2.remove("QUBE");
        }
        if (m2.isEmpty() && !m1.isEmpty() || ds2.rank() == 0) {
            m2.put("DEPEND_0", m1.get("DEPEND_0"));
            m2.put("DEPEND_1", m1.get("DEPEND_1"));
            m2.put("DEPEND_2", m1.get("DEPEND_2"));
            m2.put("DEPEND_3", m1.get("DEPEND_3"));
            m2.put("CONTEXT_0", m1.get("CONTEXT_0"));
            m2.put("BINS_0", m1.get("BINS_0"));
            m2.put("BINS_1", m1.get("BINS_1"));
        }
        if (m1.isEmpty() && !m2.isEmpty() || ds1.rank() == 0) {
            m1.put("DEPEND_0", m2.get("DEPEND_0"));
            m1.put("DEPEND_1", m2.get("DEPEND_1"));
            m1.put("DEPEND_2", m2.get("DEPEND_2"));
            m1.put("DEPEND_3", m2.get("DEPEND_3"));
            m1.put("CONTEXT_0", m2.get("CONTEXT_0"));
            m1.put("BINS_0", m2.get("BINS_0"));
            m1.put("BINS_1", m2.get("BINS_1"));
        }
        HashMap<String, Object> m3 = Ops.equalProperties(m1, m2);
        if (resultIsQube) {
            m3.put("QUBE", Boolean.TRUE);
        }
        for (String s : ss = DataSetUtil.dimensionProperties()) {
            m3.remove(s);
        }
        String rt = (String)ds1.property("RENDER_TYPE");
        if (rt != null) {
            result.putProperty("RENDER_TYPE", rt);
        }
        m3.remove("BUNDLE_1");
        DataSetUtil.putProperties(m3, result);
    }

    public static MutablePropertyDataSet applyBinaryOp(QDataSet ds1, QDataSet ds2, BinaryOp op) {
        if (ds1.rank() == ds2.rank() && ds1.rank() > 0 && ds1.length() != ds2.length()) {
            throw new IllegalArgumentException("binary operation on datasets of different lengths: " + ds1 + " " + ds2);
        }
        QDataSet[] operands = new QDataSet[2];
        WritableDataSet result = CoerceUtil.coerce(ds1, ds2, true, operands);
        QDataSet op1 = operands[0];
        QDataSet op2 = operands[1];
        QDataSet w1 = DataSetUtil.weightsDataSet(op1);
        QDataSet w2 = DataSetUtil.weightsDataSet(op2);
        int n0 = w1.rank() > 0 ? w1.length() : 0;
        double fill = -1.0E38;
        switch (w1.rank()) {
            case 1: {
                for (int i = 0; i < n0; ++i) {
                    double d1 = op1.value(i);
                    double d2 = op2.value(i);
                    double w = w1.value(i) * w2.value(i);
                    result.putValue(i, w == 0.0 ? fill : op.op(d1, d2));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n0; ++i) {
                    int n1 = w1.length(i);
                    for (int j = 0; j < n1; ++j) {
                        double d1 = op1.value(i, j);
                        double d2 = op2.value(i, j);
                        double w = w1.value(i, j) * w2.value(i, j);
                        result.putValue(i, j, w == 0.0 ? fill : op.op(d1, d2));
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n0; ++i) {
                    int n1 = w1.length(i);
                    for (int j = 0; j < n1; ++j) {
                        int n2 = w1.length(i, j);
                        for (int k = 0; k < n2; ++k) {
                            double d1 = op1.value(i, j, k);
                            double d2 = op2.value(i, j, k);
                            double w = w1.value(i, j, k) * w2.value(i, j, k);
                            result.putValue(i, j, k, w == 0.0 ? fill : op.op(d1, d2));
                        }
                    }
                }
                break;
            }
            default: {
                QubeDataSetIterator it1 = new QubeDataSetIterator(operands[0]);
                QubeDataSetIterator it2 = new QubeDataSetIterator(operands[1]);
                while (it1.hasNext()) {
                    it1.next();
                    it2.next();
                    double d1 = it1.getValue(operands[0]);
                    double d2 = it2.getValue(operands[1]);
                    double w = it1.getValue(w1) * it2.getValue(w2);
                    it1.putValue(result, w == 0.0 ? fill : op.op(d1, d2));
                }
                break block0;
            }
        }
        Ops.applyProperties(ds1, ds2, result);
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static MutablePropertyDataSet applyBinaryOp(Object ds1, Object ds2, BinaryOp op) {
        return Ops.applyBinaryOp(Ops.dataset(ds1), Ops.dataset(ds2), op);
    }

    public static HashMap<String, Object> equalProperties(Map<String, Object> m1, Map<String, Object> m2) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        m1.entrySet().forEach(e -> {
            String k = (String)e.getKey();
            Object v = e.getValue();
            if (v != null) {
                Object v2 = m2.get(k);
                if (v.equals(v2)) {
                    result.put(k, v);
                } else if (v instanceof QDataSet && v2 instanceof QDataSet && Ops.equivalent((QDataSet)v, (QDataSet)v2)) {
                    result.put(k, v);
                }
            }
        });
        return result;
    }

    private static BinaryOp addGen(QDataSet ds1, QDataSet ds2, Map<String, Object> properties) {
        BinaryOp result;
        Units units1 = SemanticOps.getUnits(ds1);
        Units units2 = SemanticOps.getUnits(ds2);
        if (units2.isConvertibleTo(units1) && UnitsUtil.isRatioMeasurement((Units)units1)) {
            UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1);
            result = (d1, d2) -> d1 + uc.convert(d2);
            if (units1 != Units.dimensionless) {
                properties.put("UNITS", units1);
            }
        } else if (UnitsUtil.isIntervalMeasurement((Units)units1)) {
            if (UnitsUtil.isIntervalMeasurement((Units)units2)) {
                throw new IllegalArgumentException("two location units cannot be added: " + units1 + ", " + units2);
            }
            if (units2 == Units.dimensionless && !UnitsUtil.isTimeLocation((Units)units1)) {
                units2 = units1.getOffsetUnits();
            }
            UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1.getOffsetUnits());
            result = (d1, d2) -> d1 + uc.convert(d2);
            properties.put("UNITS", units1);
        } else if (UnitsUtil.isIntervalMeasurement((Units)units2)) {
            UnitsConverter uc = UnitsConverter.getConverter((Units)units1, (Units)units2.getOffsetUnits());
            result = (d1, d2) -> uc.convert(d1) + d2;
            properties.put("UNITS", units2);
        } else if (UnitsUtil.isRatioMeasurement((Units)units1) && units2.isConvertibleTo(Units.dimensionless)) {
            result = (d1, d2) -> d1 + d2;
            properties.put("UNITS", units1);
        } else {
            throw new IllegalArgumentException("units cannot be added: " + units1 + ", " + units2);
        }
        return result;
    }

    private static LongBinaryOp longAddGen(QDataSet ds1, QDataSet ds2, Map<String, Object> properties) {
        LongBinaryOp result;
        Units units1 = SemanticOps.getUnits(ds1);
        Units units2 = SemanticOps.getUnits(ds2);
        if (units2.isConvertibleTo(units1) && UnitsUtil.isRatioMeasurement((Units)units1)) {
            UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1);
            result = (d1, d2) -> d1 + (long)uc.convert((double)d2);
            if (units1 != Units.dimensionless) {
                properties.put("UNITS", units1);
            }
        } else if (UnitsUtil.isIntervalMeasurement((Units)units1)) {
            if (UnitsUtil.isIntervalMeasurement((Units)units2)) {
                throw new IllegalArgumentException("two location units cannot be added: " + units1 + ", " + units2);
            }
            if (units2 == Units.dimensionless && !UnitsUtil.isTimeLocation((Units)units1)) {
                units2 = units1.getOffsetUnits();
            }
            UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1.getOffsetUnits());
            result = (d1, d2) -> d1 + (long)uc.convert((double)d2);
            properties.put("UNITS", units1);
        } else if (UnitsUtil.isIntervalMeasurement((Units)units2)) {
            UnitsConverter uc = UnitsConverter.getConverter((Units)units1, (Units)units2.getOffsetUnits());
            result = (d1, d2) -> (long)uc.convert((double)d1) + d2;
            properties.put("UNITS", units2);
        } else if (UnitsUtil.isRatioMeasurement((Units)units1) && units2.isConvertibleTo(Units.dimensionless)) {
            result = (d1, d2) -> d1 + d2;
            properties.put("UNITS", units1);
        } else {
            throw new IllegalArgumentException("units cannot be added: " + units1 + ", " + units2);
        }
        return result;
    }

    private static MutablePropertyDataSet maybeAddTT2000(QDataSet ds1, QDataSet ds2) {
        if (ds1.rank() == 1 && ds2.rank() == 0) {
            LongReadAccess l1 = ds1.capability(LongReadAccess.class);
            if (l1 == null) {
                return null;
            }
            if (ds2.value() != Math.floor(ds2.value())) {
                return null;
            }
            long[] ll = new long[ds1.length()];
            long l2 = (long)ds2.value();
            HashMap<String, Object> props = new HashMap<String, Object>();
            LongBinaryOp addop = Ops.longAddGen(ds1, ds2, props);
            for (int i = 0; i < ll.length; ++i) {
                ll[i] = addop.op(l1.lvalue(i), l2);
            }
            LDataSet result = LDataSet.wrap(ll);
            Ops.applyProperties(ds1, ds2, result);
            result.putProperty("UNITS", props.get("UNITS"));
            result.putProperty("NAME", null);
            result.putProperty("LABEL", Ops.maybeLabelInfixOp(ds1, ds2, "+"));
            return result;
        }
        if (ds1.rank() == 0 && ds2.rank() == 1) {
            LongReadAccess l1 = ds1.capability(LongReadAccess.class);
            if (l1 == null) {
                return null;
            }
            if (ds2.length() < 100) {
                for (int i = 0; i < ds2.length(); ++i) {
                    double d = ds2.value(i);
                    if (d == Math.floor(d)) continue;
                    return null;
                }
            }
            long[] ll = new long[ds2.length()];
            long lc1 = l1.lvalue();
            int n = ds2.length();
            HashMap<String, Object> props = new HashMap<String, Object>();
            LongBinaryOp addop = Ops.longAddGen(ds1, ds2, props);
            for (int i = 0; i < n; ++i) {
                ll[i] = addop.op(lc1, (long)ds2.value(i));
            }
            LDataSet result = LDataSet.wrap(ll);
            Ops.applyProperties(ds1, ds2, result);
            result.putProperty("UNITS", props.get("UNITS"));
            result.putProperty("NAME", null);
            result.putProperty("LABEL", Ops.maybeLabelInfixOp(ds1, ds2, "+"));
            return result;
        }
        return null;
    }

    public static QDataSet add(QDataSet ds1, QDataSet ds2) {
        MutablePropertyDataSet result = Ops.maybeAddTT2000(ds1, ds2);
        if (result != null) {
            return result;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        BinaryOp b = Ops.addGen(ds1, ds2, props);
        result = Ops.applyBinaryOp(ds1, ds2, b);
        result.putProperty("UNITS", props.get("UNITS"));
        result.putProperty("NAME", null);
        result.putProperty("LABEL", Ops.maybeLabelInfixOp(ds1, ds2, "+"));
        return result;
    }

    public static QDataSet add(Object ds1, Object ds2) {
        return Ops.add(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet add(QDataSet ds1, QDataSet ds2, QDataSet ds3) {
        String label3;
        String label2;
        QDataSet result = Ops.add(Ops.add(ds1, ds2), ds3);
        String label1 = (String)ds1.property("LABEL");
        if (label1 == null) {
            label1 = (String)ds1.property("NAME");
        }
        if ((label2 = (String)ds2.property("LABEL")) == null) {
            label2 = (String)ds2.property("NAME");
        }
        if ((label3 = (String)ds3.property("LABEL")) == null) {
            label3 = (String)ds3.property("NAME");
        }
        if (label1 != null && label2 != null && label3 != null) {
            result = Ops.putProperty(result, "LABEL", (Object)String.format("%s + %s + %s", label1, label2, label3));
        }
        return result;
    }

    public static QDataSet subtract(QDataSet ds1, QDataSet ds2) {
        MutablePropertyDataSet result;
        Units units1 = SemanticOps.getUnits(ds1);
        Units units2 = SemanticOps.getUnits(ds2);
        if (units2.isConvertibleTo(units1) && UnitsUtil.isRatioMeasurement((Units)units1)) {
            UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1);
            result = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> d1 - uc.convert(d2));
            if (units1 != Units.dimensionless) {
                result.putProperty("UNITS", units1);
            }
        } else if (UnitsUtil.isIntervalMeasurement((Units)units1) && UnitsUtil.isIntervalMeasurement((Units)units2)) {
            UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1);
            result = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> d1 - uc.convert(d2));
            result.putProperty("UNITS", units1.getOffsetUnits());
        } else if (UnitsUtil.isIntervalMeasurement((Units)units1) && !UnitsUtil.isIntervalMeasurement((Units)units2)) {
            if (units2 == Units.dimensionless && !UnitsUtil.isTimeLocation((Units)units1)) {
                units2 = units1.getOffsetUnits();
            }
            UnitsConverter uc = UnitsConverter.getConverter((Units)units2, (Units)units1.getOffsetUnits());
            result = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> d1 - uc.convert(d2));
            result.putProperty("UNITS", units1);
        } else {
            if (UnitsUtil.isIntervalMeasurement((Units)units2) && !UnitsUtil.isIntervalMeasurement((Units)units1)) {
                throw new IllegalArgumentException("cannot subtract interval measurement from ratio measurement: " + units1 + " - " + units2);
            }
            if (UnitsUtil.isRatioMeasurement((Units)units1) && units2.isConvertibleTo(Units.dimensionless)) {
                result = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> d1 - d2);
                result.putProperty("UNITS", units1);
            } else if (UnitsUtil.isRatioMeasurement((Units)units2) && units1.isConvertibleTo(Units.dimensionless)) {
                result = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> d1 - d2);
                result.putProperty("UNITS", units2);
            } else {
                throw new IllegalArgumentException("cannot subtract: " + units1 + " - " + units2);
            }
        }
        result.putProperty("NAME", null);
        result.putProperty("MONOTONIC", null);
        result.putProperty("LABEL", Ops.maybeLabelInfixOp(ds1, ds2, "-"));
        return result;
    }

    public static QDataSet subtract(Object ds1, Object ds2) {
        return Ops.subtract(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    private static String maybeLabelUnaryOp(QDataSet ds1, String opStr) {
        String label1 = (String)ds1.property("LABEL");
        if (label1 == null) {
            label1 = (String)ds1.property("NAME");
        }
        if (label1 == null) {
            return null;
        }
        String l1Str = label1;
        return opStr + "(" + l1Str + ")";
    }

    private static String maybeLabelBinaryOp(QDataSet ds1, QDataSet ds2, String opStr) {
        String label2;
        String label1 = (String)ds1.property("LABEL");
        if (label1 == null) {
            label1 = (String)ds1.property("NAME");
        }
        if ((label2 = (String)ds2.property("LABEL")) == null) {
            label2 = (String)ds2.property("NAME");
        }
        if (label1 == null || label2 == null) {
            return null;
        }
        String l1Str = label1;
        String l2Str = label2;
        String result = opStr + "(" + l1Str + "," + l2Str + ")";
        if (result.length() > 120) {
            return null;
        }
        return opStr + "(" + l1Str + "," + l2Str + ")";
    }

    private static String maybeLabelInfixOp(QDataSet ds1, QDataSet ds2, String opStr) {
        String l2Str;
        String l1Str;
        String label2;
        String label1 = (String)ds1.property("LABEL");
        if (label1 == null) {
            label1 = (String)ds1.property("NAME");
        }
        if ((label2 = (String)ds2.property("LABEL")) == null) {
            label2 = (String)ds2.property("NAME");
        }
        if (label1 == null || label2 == null) {
            return null;
        }
        if (label1.equals(label2)) {
            return null;
        }
        Pattern idpat = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");
        if (!idpat.matcher(l1Str = label1).matches()) {
            l1Str = "(" + l1Str + ")";
        }
        if (!idpat.matcher(l2Str = label2).matches()) {
            l2Str = "(" + l2Str + ")";
        }
        if (l1Str != null && l2Str != null) {
            String result = l1Str + opStr + l2Str;
            if (result.length() > 120) {
                return null;
            }
            return result;
        }
        return null;
    }

    private static void maybeCopyProperty(String name, QDataSet src, MutablePropertyDataSet dest) {
        Object o = src.property(name);
        if (o != null) {
            dest.putProperty(name, o);
        } else if (dest.property(name) != null) {
            dest.putProperty(name, null);
        }
    }

    public static QDataSet negate(QDataSet ds1) {
        Units u = SemanticOps.getUnits(ds1);
        if (!UnitsUtil.isRatioMeasurement((Units)u)) {
            throw new IllegalArgumentException("Units are not ratiometric units");
        }
        MutablePropertyDataSet mpds = Ops.applyUnaryOp(ds1, (double d1) -> -d1);
        mpds.putProperty("UNITS", u);
        return mpds;
    }

    public static QDataSet negate(Object ds1) {
        return Ops.negate(Ops.dataset(ds1));
    }

    public static QDataSet magnitude(QDataSet ds) {
        boolean isCart;
        if (ds == null) {
            throw new IllegalArgumentException("input ds is null");
        }
        int r = ds.rank();
        if (r == 0) {
            return DataSetUtil.asDataSet(Math.abs(ds.value()), (Units)ds.property("UNITS"));
        }
        QDataSet depn = (QDataSet)ds.property("DEPEND_" + (r - 1));
        if (depn != null) {
            isCart = depn.property("COORDINATE_FRAME") != null ? true : ("cartesian".equals(depn.property("NAME")) ? true : depn.length() < 4);
        } else {
            int[] qubedims = DataSetUtil.qubeDims(ds);
            boolean bl = isCart = qubedims[r - 1] < 4;
        }
        if (isCart) {
            Units u = (Units)ds.property("UNITS");
            QDataSet wds = DataSetUtil.weightsDataSet(ds);
            double fill = ((Number)wds.property("SUGGEST_FILL")).doubleValue();
            Map<String, Object> props = DataSetUtil.getProperties(ds);
            props.remove("DEPEND_" + (ds.rank() - 1));
            props.remove("BUNDLE_" + (ds.rank() - 1));
            props.put("FILL_VALUE", fill);
            switch (ds.rank()) {
                case 2: {
                    DDataSet result = DDataSet.create(Arrays.copyOf(DataSetUtil.qubeDims(ds), ds.rank() - 1));
                    for (int i0 = 0; i0 < ds.length(); ++i0) {
                        int n = ds.length(0);
                        double a = 0.0;
                        boolean valid = true;
                        for (int i1 = 0; i1 < n; ++i1) {
                            double w = wds.value(i0, i1);
                            if (w == 0.0) {
                                valid = false;
                                break;
                            }
                            double d = ds.value(i0, i1);
                            a += d * d;
                        }
                        if (valid) {
                            a = Math.sqrt(a);
                            result.putValue(i0, a);
                            continue;
                        }
                        result.putValue(i0, fill);
                    }
                    DataSetUtil.putProperties(props, result);
                    ds = result;
                    break;
                }
                case 3: {
                    DDataSet result = DDataSet.create(Arrays.copyOf(DataSetUtil.qubeDims(ds), ds.rank() - 1));
                    for (int i0 = 0; i0 < ds.length(); ++i0) {
                        int n = ds.length(0, 0);
                        for (int i1 = 0; i1 < ds.length(0); ++i1) {
                            double a = 0.0;
                            boolean valid = true;
                            for (int i2 = 0; i2 < n; ++i2) {
                                double w = wds.value(i0, i1, i2);
                                if (w == 0.0) {
                                    valid = false;
                                    break;
                                }
                                double d = ds.value(i0, i1, i2);
                                a += d * d;
                            }
                            if (valid) {
                                a = Math.sqrt(a);
                                result.putValue(i0, i1, a);
                                continue;
                            }
                            result.putValue(i0, fill);
                        }
                    }
                    DataSetUtil.putProperties(DataSetUtil.getProperties(ds), result);
                    ds = result;
                    break;
                }
                default: {
                    ds = Ops.pow((Object)ds, (Object)2);
                    ds = Ops.total(ds, r - 1);
                    ds = Ops.sqrt(ds);
                    if (u == null) break;
                    ((MutablePropertyDataSet)ds).putProperty("UNITS", u);
                }
            }
            return ds;
        }
        throw new IllegalArgumentException("last dim must have COORDINATE_FRAME property.  See also abs() method. ds=" + ds);
    }

    public static QDataSet magnitude(Object ds1) {
        return Ops.magnitude(Ops.dataset(ds1));
    }

    public static double total(QDataSet ds) {
        return Ops.total(ds, (ProgressMonitor)new NullProgressMonitor());
    }

    public static double total(QDataSet ds, ProgressMonitor mon) {
        double s = 0.0;
        QubeDataSetIterator it1 = new QubeDataSetIterator(ds);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double fill = ((Number)wds.property("SUGGEST_FILL")).doubleValue();
        it1.setMonitor(mon);
        while (it1.hasNext()) {
            it1.next();
            double w = it1.getValue(wds);
            if (w == 0.0) {
                return fill;
            }
            s += it1.getValue(ds);
        }
        return s;
    }

    public static double total(Object ds1) {
        return Ops.total(Ops.dataset(ds1));
    }

    private static QDataSet averageGen(QDataSet ds, int dim, AverageOp op, ProgressMonitor mon) throws CancelledOperationException {
        int i;
        int[] newQube;
        if (ds == null) {
            throw new NullPointerException("ds reference is null");
        }
        int[] qube = DataSetUtil.qubeDims(ds);
        if (qube == null && dim < ds.rank() - 1) {
            throw new IllegalArgumentException("dataset is not a qube, operations can only be done on the last index");
        }
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        if (dim >= ds.rank()) {
            throw new IllegalArgumentException(String.format("dimension index (%d) exceeds rank (%d)", dim, ds.rank()));
        }
        if (qube != null && qube[dim] == 1) {
            switch (dim) {
                case 0: {
                    return ds.slice(0);
                }
                case 1: {
                    return Ops.slice1(ds, 0);
                }
                case 2: {
                    return Ops.slice2(ds, 0);
                }
                case 3: {
                    return Ops.slice3(ds, 0);
                }
            }
        }
        if (qube != null) {
            newQube = DataSetOps.removeElement(qube, dim);
        } else {
            switch (ds.rank()) {
                case 2: {
                    newQube = new int[]{ds.length()};
                    break;
                }
                case 3: {
                    newQube = new int[]{ds.length(), ds.length(0)};
                    break;
                }
                case 4: {
                    newQube = new int[]{ds.length(), ds.length(0), ds.length(0, 0)};
                    break;
                }
                default: {
                    throw new IllegalArgumentException("implementation error");
                }
            }
        }
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        DDataSet result = DDataSet.create(newQube);
        DDataSet wresult = DDataSet.create(newQube);
        QubeDataSetIterator it1 = new QubeDataSetIterator(result);
        it1.setMonitor(mon.getSubtaskMonitor("reduce"));
        double fill = ((Number)wds.property("SUGGEST_FILL")).doubleValue();
        double[] store = new double[2];
        while (it1.hasNext()) {
            if (mon.isCancelled()) {
                throw new CancelledOperationException("User pressed cancel");
            }
            it1.next();
            op.initStore(store);
            QubeDataSetIterator it0 = new QubeDataSetIterator(ds);
            for (i = 0; i < ds.rank(); ++i) {
                int ndim;
                int n = ndim = i < dim ? i : i - 1;
                if (i == dim) continue;
                it0.setIndexIteratorFactory(i, new QubeDataSetIterator.SingletonIteratorFactory(it1.index(ndim)));
            }
            while (it0.hasNext()) {
                it0.next();
                op.accum(it0.getValue(ds), it0.getValue(wds), store);
            }
            op.normalize(store);
            it1.putValue(result, store[1] > 0.0 ? store[0] : fill);
            it1.putValue(wresult, store[1]);
        }
        Map<String, Object> props = DataSetUtil.getProperties(ds);
        props = DataSetOps.sliceProperties(props, dim);
        DataSetUtil.putProperties(props, result);
        result.putProperty("FILL_VALUE", fill);
        result.putProperty("WEIGHTS", wresult);
        for (i = dim + 1; i < ds.rank(); ++i) {
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
            if (dep == null || dep.rank() <= 2) continue;
            dep = Ops.reduceMean(dep, dim, mon.getSubtaskMonitor("average DEPEND_" + dim));
            result.putProperty("DEPEND_" + (i - 1), dep);
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dim == 0 && dep0 != null && dep0.length() > 0) {
            QDataSet extent = Ops.extent(dep0);
            DataSetUtil.addContext(result, extent);
        }
        return result;
    }

    public static QDataSet total(QDataSet ds, int dim) {
        try {
            return Ops.total(ds, dim, (ProgressMonitor)new NullProgressMonitor());
        }
        catch (CancelledOperationException ex) {
            throw new IllegalArgumentException("null monitor cannot be cancelled");
        }
    }

    public static QDataSet total(QDataSet ds, int dim, ProgressMonitor mon) throws CancelledOperationException {
        int i;
        int[] qube = DataSetUtil.qubeDims(ds);
        if (qube == null) {
            throw new IllegalArgumentException("argument does not appear to be qube");
        }
        int[] newQube = DataSetOps.removeElement(qube, dim);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        DDataSet result = DDataSet.create(newQube);
        DDataSet weights = DDataSet.create(newQube);
        double fill = ((Number)wds.property("SUGGEST_FILL")).doubleValue();
        if (ds.rank() == 2 && dim == 1) {
            int jlen = ds.length(0);
            mon.setTaskSize((long)result.length());
            mon.started();
            for (i = 0; i < result.length(); ++i) {
                mon.setTaskProgress((long)i);
                boolean isfill = false;
                for (int j = 0; j < jlen; ++j) {
                    if (wds.value(i, j) == 0.0) {
                        isfill = true;
                        continue;
                    }
                    result.addValue(i, ds.value(i, j));
                }
                if (isfill) {
                    result.putValue(i, fill);
                    continue;
                }
                weights.putValue(i, 1.0);
            }
        } else {
            QubeDataSetIterator it1 = new QubeDataSetIterator(result);
            it1.setMonitor(mon);
            while (it1.hasNext()) {
                if (mon.isCancelled()) {
                    throw new CancelledOperationException("total cancelled");
                }
                it1.next();
                double s = 0.0;
                double w = 0.0;
                QubeDataSetIterator it0 = new QubeDataSetIterator(ds);
                for (int i2 = 0; i2 < ds.rank(); ++i2) {
                    int ndim;
                    int n = ndim = i2 < dim ? i2 : i2 - 1;
                    if (i2 == dim) continue;
                    it0.setIndexIteratorFactory(i2, new QubeDataSetIterator.SingletonIteratorFactory(it1.index(ndim)));
                }
                while (it0.hasNext()) {
                    it0.next();
                    double w1 = it0.getValue(wds) > 0.0 ? 1.0 : 0.0;
                    s += w1 * it0.getValue(ds);
                    w += w1;
                }
                it1.putValue(result, w > 0.0 ? s : fill);
                it1.putValue(weights, w);
            }
        }
        Map<String, Object> props = DataSetUtil.getProperties(ds);
        props = DataSetOps.sliceProperties(props, dim);
        for (i = dim + 1; i < ds.rank(); ++i) {
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
            if (dep == null || dep.rank() <= 1 || !DataSetUtil.isConstant(dep, dim)) continue;
            switch (dim) {
                case 0: {
                    dep = Ops.slice0(dep, 0);
                    break;
                }
                case 1: {
                    dep = Ops.slice1(dep, 0);
                    break;
                }
                case 2: {
                    dep = Ops.slice2(dep, 0);
                    break;
                }
                case 3: {
                    dep = Ops.slice3(dep, 0);
                    break;
                }
                default: {
                    dep = null;
                }
            }
            props.put("DEPEND_" + (i - 1), dep);
        }
        DataSetUtil.putProperties(props, result);
        result.putProperty("WEIGHTS", weights);
        result.putProperty("FILL_VALUE", fill);
        return result;
    }

    public static QDataSet reduceMax(QDataSet ds, int dim) {
        return Ops.reduceMax(ds, dim, null);
    }

    public static QDataSet reduceMax(QDataSet ds, int dim, ProgressMonitor mon) {
        try {
            return Ops.averageGen(ds, dim, new AverageOp(){

                @Override
                public void accum(double d1, double w1, double[] accum) {
                    if (w1 > 0.0) {
                        accum[0] = Math.max(d1, accum[0]);
                        accum[1] = accum[1] + w1;
                    }
                }

                @Override
                public void initStore(double[] accum) {
                    accum[0] = Double.NEGATIVE_INFINITY;
                    accum[1] = 0.0;
                }

                @Override
                public void normalize(double[] accum) {
                }
            }, mon);
        }
        catch (CancelledOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet reduceSum(QDataSet ds, int dim) {
        try {
            return Ops.averageGen(ds, dim, new AverageOp(){

                @Override
                public void accum(double d1, double w1, double[] accum) {
                    if (w1 > 0.0) {
                        accum[0] = accum[0] + d1;
                        accum[1] = accum[1] + w1;
                    }
                }

                @Override
                public void initStore(double[] accum) {
                    accum[0] = 0.0;
                    accum[1] = 0.0;
                }

                @Override
                public void normalize(double[] accum) {
                }
            }, (ProgressMonitor)new NullProgressMonitor());
        }
        catch (CancelledOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet reduceMin(QDataSet ds, int dim) {
        return Ops.reduceMin(ds, dim, null);
    }

    public static QDataSet reduceMin(QDataSet ds, int dim, ProgressMonitor mon) {
        try {
            return Ops.averageGen(ds, dim, new AverageOp(){

                @Override
                public void accum(double d1, double w1, double[] accum) {
                    if (w1 > 0.0) {
                        accum[0] = Math.min(d1, accum[0]);
                        accum[1] = accum[1] + w1;
                    }
                }

                @Override
                public void initStore(double[] accum) {
                    accum[0] = Double.POSITIVE_INFINITY;
                    accum[1] = 0.0;
                }

                @Override
                public void normalize(double[] accum) {
                }
            }, mon);
        }
        catch (CancelledOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet reduceMean(QDataSet ds, int dim) {
        try {
            return Ops.reduceMean(ds, dim, (ProgressMonitor)new NullProgressMonitor());
        }
        catch (CancelledOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet reduceMean(QDataSet ds, int dim, ProgressMonitor mon) throws CancelledOperationException {
        int[] qube;
        if (dim == 1 && (qube = DataSetUtil.qubeDims(ds)) != null && qube[1] == 2) {
            QDataSet left = Ops.slice1(ds, 0);
            QDataSet right = Ops.slice1(ds, 1);
            return Ops.add(left, Ops.divide((Object)Ops.subtract(right, left), 2));
        }
        return Ops.averageGen(ds, dim, new AverageOp(){

            @Override
            public void accum(double d1, double w1, double[] accum) {
                if (w1 > 0.0) {
                    accum[0] = accum[0] + w1 * d1;
                    accum[1] = accum[1] + w1;
                }
            }

            @Override
            public void initStore(double[] accum) {
                accum[0] = 0.0;
                accum[1] = 0.0;
            }

            @Override
            public void normalize(double[] accum) {
                if (accum[1] > 0.0) {
                    accum[0] = accum[0] / accum[1];
                }
            }
        }, mon);
    }

    public static QDataSet reduceMedian(QDataSet ds, int dim, ProgressMonitor mon) throws CancelledOperationException {
        return Ops.averageGen(ds, dim, new AverageOp(){
            DataSetBuilder b;

            @Override
            public void accum(double d1, double w1, double[] accum) {
                if (w1 > 0.0) {
                    this.b.nextRecord(d1);
                    accum[1] = accum[1] + w1;
                }
            }

            @Override
            public void initStore(double[] accum) {
                this.b = new DataSetBuilder(1, 100);
                accum[1] = 0.0;
            }

            @Override
            public void normalize(double[] accum) {
                DDataSet all = this.b.getDataSet();
                if (all.length() == 0) {
                    accum[0] = Double.NaN;
                    accum[1] = 0.0;
                } else {
                    accum[0] = Ops.median(all).value();
                }
            }
        }, mon);
    }

    public static QDataSet reduceBins(QDataSet dep1) {
        if (dep1.property("BINS_1").equals("min,max")) {
            DDataSet result = DDataSet.createRank1(dep1.length());
            int n = result.length();
            if ("log".equals(dep1.property("SCALE_TYPE"))) {
                for (int i = 0; i < n; ++i) {
                    result.putValue(i, Math.sqrt(dep1.value(i, 0) * dep1.value(i, 1)));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    result.putValue(i, (dep1.value(i, 0) + dep1.value(i, 1)) / 2.0);
                }
            }
            DataSetUtil.copyDimensionProperties(dep1, result);
            return result;
        }
        throw new IllegalArgumentException("dataset must be rank 2 bins dataset, with min,max");
    }

    public static QDataSet binData(QDataSet ds, DatumRange bin) {
        JoinDataSet resultx = new JoinDataSet(2);
        JoinDataSet resulty = new JoinDataSet(2);
        DataSetBuilder resultDep = new DataSetBuilder(1, 100);
        QDataSet xds = SemanticOps.xtagsDataSet(ds);
        QDataSet yds = SemanticOps.ytagsDataSet(ds);
        DataSetBuilder currentAccumY = new DataSetBuilder(1, 100);
        DataSetBuilder currentAccumX = new DataSetBuilder(1, 100);
        for (int i = 0; i < ds.length(); ++i) {
            DatumRange pbin;
            Datum x = DataSetUtil.asDatum(xds.slice(i));
            while (bin.min().gt(x) && (pbin = bin.previous()) != bin) {
                if (currentAccumX.getLength() > 0) {
                    resultDep.nextRecord(bin.middle());
                    resultx.join(currentAccumX.getDataSet());
                    resulty.join(currentAccumY.getDataSet());
                    currentAccumY = new DataSetBuilder(1, 100);
                    currentAccumX = new DataSetBuilder(1, 100);
                }
                bin = pbin;
            }
            while (bin.max().le(x) && (pbin = bin.next()) != bin) {
                if (currentAccumX.getLength() > 0) {
                    resultDep.nextRecord(bin.middle());
                    resultx.join(currentAccumX.getDataSet());
                    resulty.join(currentAccumY.getDataSet());
                    currentAccumY = new DataSetBuilder(1, 100);
                    currentAccumX = new DataSetBuilder(1, 100);
                }
                bin = pbin;
            }
            if (!bin.contains(x)) continue;
            currentAccumX.nextRecord(x);
            currentAccumY.nextRecord(yds.slice(i));
        }
        if (currentAccumX.getLength() > 0) {
            resultDep.nextRecord(bin.middle());
            resultx.join(currentAccumX.getDataSet());
            resulty.join(currentAccumY.getDataSet());
        }
        JoinDataSet result = resulty;
        JoinDataSet dep1 = resultx;
        DDataSet dep0 = resultDep.getDataSet();
        return Ops.link(dep0, dep1, result);
    }

    public static QDataSet normalize(QDataSet ds) {
        QDataSet n = Ops.abs(Ops.extent(ds));
        n = n.value(0) > n.value(1) ? n.slice(0) : n.slice(1);
        WritableDataSet result = Ops.maybeCopy(Ops.divide(ds, n));
        Map<String, Object> props = DataSetUtil.getProperties(ds);
        props.put("UNITS", Units.dimensionless);
        props.put("TITLE", "" + props.get("TITLE") + " (normalized)");
        props.put("LABEL", "" + props.get("LABEL") + " (normalized)");
        DataSetUtil.putProperties(props, result);
        return result;
    }

    public static QDataSet normalize(QDataSet ds, int dim) {
        QDataSet n = Ops.reduceMax(ds, dim);
        WritableDataSet result = Ops.maybeCopy(Ops.divide(ds, n));
        Map<String, Object> props = DataSetUtil.getProperties(ds);
        props.put("UNITS", Units.dimensionless);
        props.put("TITLE", "" + props.get("TITLE") + " (normalized)");
        props.put("LABEL", "" + props.get("LABEL") + " (normalized)");
        DataSetUtil.putProperties(props, result);
        return result;
    }

    public static QDataSet decimate(QDataSet ds) {
        return Ops.decimate(ds, 10);
    }

    public static QDataSet decimate(QDataSet ds, int m) {
        if (Schemes.isIrregularJoin(ds)) {
            throw new IllegalArgumentException("not supported");
        }
        int newlen = ds.length() / m;
        int imax = newlen * m - m;
        return DataSetOps.applyIndex(ds, Ops.linspace(0.0, imax, newlen));
    }

    private static QDataSet decimateBufferDataSet(BufferDataSet ds, int m, int n) {
        QDataSet dep1;
        BufferDataSet result = BufferDataSet.copy(ds);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null && m > 1) {
            dep0 = Ops.decimate(dep0, m);
        }
        if ((dep1 = (QDataSet)ds.property("DEPEND_1")) != null) {
            dep1 = dep1.rank() == 1 ? Ops.decimate(dep1, n) : Ops.decimate(dep1, m, n);
        }
        result.setRecordStride(result.getRecordStride() * m);
        result.setLength(result.length() / m);
        result.setFieldStride(result.getFieldStride() * n);
        result.setLength1(result.length(0) / n);
        if (dep0 != null) {
            result.putProperty("DEPEND_0", dep0);
        }
        if (dep1 != null) {
            result.putProperty("DEPEND_1", dep1);
        }
        DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(ds, null), result);
        return result;
    }

    public static QDataSet decimate(QDataSet ds, int m, int n) {
        if (Schemes.isIrregularJoin(ds)) {
            throw new IllegalArgumentException("not supported");
        }
        if (ds instanceof BufferDataSet && ds.rank() == 2) {
            return Ops.decimateBufferDataSet((BufferDataSet)ds, m, n);
        }
        int newlen0 = ds.length() / m;
        int max0 = newlen0 * m;
        int newlen1 = ds.length(0) / n;
        int max1 = newlen1 * n;
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        iter.setIndexIteratorFactory(0, new QubeDataSetIterator.StartStopStepIteratorFactory(0, max0, m));
        iter.setIndexIteratorFactory(1, new QubeDataSetIterator.StartStopStepIteratorFactory(0, max1, n));
        DDataSet result = iter.createEmptyDs();
        QubeDataSetIterator iterout = new QubeDataSetIterator(result);
        while (iter.hasNext()) {
            iter.next();
            iterout.next();
            iterout.putValue(result, iter.getValue(ds));
        }
        result.putProperty("RENDER_TYPE", ds.property("RENDER_TYPE"));
        return result;
    }

    public static QDataSet collapse0(QDataSet fillDs, int st, int en) {
        fillDs = fillDs.trim(st, en);
        fillDs = Ops.reduceMean(fillDs, 0);
        return fillDs;
    }

    public static QDataSet collapse0(QDataSet fillDs) {
        if (fillDs.rank() == 4) {
            return Ops.collapse0R4(fillDs, (ProgressMonitor)new NullProgressMonitor());
        }
        fillDs = Ops.reduceMean(fillDs, 0);
        return fillDs;
    }

    public static QDataSet collapse0R4(QDataSet ds, ProgressMonitor mon) {
        if (ds.rank() == 4) {
            int[] qube = DataSetUtil.qubeDims(ds);
            if (qube == null) {
                throw new IllegalArgumentException("dataset is not a qube");
            }
            int[] newQube = DataSetOps.removeElement(qube, 0);
            QDataSet mpds = ds;
            QDataSet wds = DataSetUtil.weightsDataSet(mpds);
            DDataSet result = DDataSet.create(newQube);
            DDataSet wresult = DDataSet.create(newQube);
            mon.setTaskSize((long)qube[1]);
            mon.started();
            for (int i1 = 0; i1 < qube[1]; ++i1) {
                mon.setTaskProgress((long)i1);
                for (int i2 = 0; i2 < qube[2]; ++i2) {
                    for (int i3 = 0; i3 < qube[3]; ++i3) {
                        for (int i0 = 0; i0 < qube[0]; ++i0) {
                            double w = wds.value(i0, i1, i2, i3);
                            if (!(w > 0.0)) continue;
                            result.addValue(i1, i2, i3, w * ds.value(i0, i1, i2, i3));
                            wresult.addValue(i1, i2, i3, w);
                        }
                    }
                }
            }
            double fill = Double.NaN;
            for (int i0 = 0; i0 < qube[1]; ++i0) {
                for (int i1 = 0; i1 < qube[2]; ++i1) {
                    for (int i2 = 0; i2 < qube[3]; ++i2) {
                        double w = wresult.value(i0, i1, i2);
                        if (w > 0.0) {
                            double n = result.value(i0, i1, i2);
                            result.putValue(i0, i1, i2, n / w);
                            continue;
                        }
                        result.putValue(i0, i1, i2, fill);
                    }
                }
            }
            mon.finished();
            Map<String, Object> props = DataSetUtil.getProperties(ds);
            props = DataSetOps.sliceProperties(props, 0);
            DataSetUtil.putProperties(props, result);
            result.putProperty("WEIGHTS", wresult);
            return result;
        }
        throw new IllegalArgumentException("only rank 4");
    }

    public static QDataSet collapse1R4(QDataSet ds, ProgressMonitor mon) {
        if (ds.rank() == 4) {
            int[] qube = DataSetUtil.qubeDims(ds);
            if (qube == null) {
                throw new IllegalArgumentException("dataset is not a qube");
            }
            int[] newQube = DataSetOps.removeElement(qube, 1);
            QDataSet mpds = ds;
            QDataSet wds = DataSetUtil.weightsDataSet(mpds);
            DDataSet result = DDataSet.create(newQube);
            DDataSet wresult = DDataSet.create(newQube);
            mon.setTaskSize((long)qube[0]);
            mon.started();
            for (int i0 = 0; i0 < qube[0]; ++i0) {
                mon.setTaskProgress((long)i0);
                for (int i2 = 0; i2 < qube[2]; ++i2) {
                    for (int i3 = 0; i3 < qube[3]; ++i3) {
                        for (int i1 = 0; i1 < qube[1]; ++i1) {
                            double w = wds.value(i0, i1, i2, i3);
                            if (!(w > 0.0)) continue;
                            result.addValue(i0, i2, i3, w * ds.value(i0, i1, i2, i3));
                            wresult.addValue(i0, i2, i3, w);
                        }
                    }
                }
            }
            double fill = Double.NaN;
            for (int i0 = 0; i0 < qube[0]; ++i0) {
                for (int i2 = 0; i2 < qube[2]; ++i2) {
                    for (int i3 = 0; i3 < qube[3]; ++i3) {
                        double w = wresult.value(i0, i2, i3);
                        if (w > 0.0) {
                            double n = result.value(i0, i2, i3);
                            result.putValue(i0, i2, i3, n / w);
                            continue;
                        }
                        result.putValue(i0, i2, i3, fill);
                    }
                }
            }
            mon.finished();
            Map<String, Object> props = DataSetUtil.getProperties(ds);
            props = DataSetOps.sliceProperties(props, 1);
            DataSetUtil.putProperties(props, result);
            result.putProperty("WEIGHTS", wresult);
            return result;
        }
        throw new IllegalArgumentException("only rank 4");
    }

    public static QDataSet collapse1(QDataSet ds) {
        if (ds.rank() == 4) {
            return Ops.collapse1R4(ds, (ProgressMonitor)new NullProgressMonitor());
        }
        ds = Ops.reduceMean(ds, 1);
        return ds;
    }

    public static QDataSet collapse2(QDataSet fillDs) {
        if (fillDs.rank() == 4) {
            return Ops.collapse2R4(fillDs, (ProgressMonitor)new NullProgressMonitor());
        }
        fillDs = Ops.reduceMean(fillDs, 2);
        return fillDs;
    }

    public static QDataSet collapse2R4(QDataSet ds, ProgressMonitor mon) {
        if (ds.rank() == 4) {
            int[] qube = DataSetUtil.qubeDims(ds);
            if (qube == null) {
                throw new IllegalArgumentException("dataset is not a qube");
            }
            int[] newQube = DataSetOps.removeElement(qube, 2);
            QDataSet mpds = ds;
            QDataSet wds = DataSetUtil.weightsDataSet(mpds);
            DDataSet result = DDataSet.create(newQube);
            DDataSet wresult = DDataSet.create(newQube);
            mon.setTaskSize((long)qube[0]);
            mon.started();
            for (int i0 = 0; i0 < qube[0]; ++i0) {
                mon.setTaskProgress((long)i0);
                for (int i1 = 0; i1 < qube[1]; ++i1) {
                    for (int i3 = 0; i3 < qube[3]; ++i3) {
                        for (int i2 = 0; i2 < qube[2]; ++i2) {
                            double w = wds.value(i0, i1, i2, i3);
                            if (!(w > 0.0)) continue;
                            result.addValue(i0, i1, i3, w * ds.value(i0, i1, i2, i3));
                            wresult.addValue(i0, i1, i3, w);
                        }
                    }
                }
            }
            double fill = Double.NaN;
            for (int i0 = 0; i0 < qube[0]; ++i0) {
                for (int i1 = 0; i1 < qube[1]; ++i1) {
                    for (int i2 = 0; i2 < qube[3]; ++i2) {
                        double w = wresult.value(i0, i1, i2);
                        if (w > 0.0) {
                            double n = result.value(i0, i1, i2);
                            result.putValue(i0, i1, i2, n / w);
                            continue;
                        }
                        result.putValue(i0, i1, i2, fill);
                    }
                }
            }
            mon.finished();
            Map<String, Object> props = DataSetUtil.getProperties(ds);
            props = DataSetOps.sliceProperties(props, 2);
            DataSetUtil.putProperties(props, result);
            result.putProperty("WEIGHTS", wresult);
            return result;
        }
        throw new IllegalArgumentException("only rank 4");
    }

    public static QDataSet collapse3(QDataSet fillDs) {
        if (fillDs.rank() == 4) {
            return Ops.collapse3R4(fillDs, (ProgressMonitor)new NullProgressMonitor());
        }
        fillDs = Ops.reduceMean(fillDs, 3);
        return fillDs;
    }

    public static QDataSet collapse3R4(QDataSet ds, ProgressMonitor mon) {
        if (ds.rank() == 4) {
            int[] qube = DataSetUtil.qubeDims(ds);
            if (qube == null) {
                throw new IllegalArgumentException("dataset is not a qube");
            }
            int[] newQube = DataSetOps.removeElement(qube, 3);
            QDataSet mpds = ds;
            QDataSet wds = DataSetUtil.weightsDataSet(mpds);
            DDataSet result = DDataSet.create(newQube);
            DDataSet wresult = DDataSet.create(newQube);
            mon.setTaskSize((long)qube[1]);
            mon.started();
            for (int i0 = 0; i0 < qube[0]; ++i0) {
                mon.setTaskProgress((long)i0);
                for (int i1 = 0; i1 < qube[1]; ++i1) {
                    for (int i2 = 0; i2 < qube[2]; ++i2) {
                        for (int i3 = 0; i3 < qube[3]; ++i3) {
                            double w = wds.value(i0, i1, i2, i3);
                            if (!(w > 0.0)) continue;
                            result.addValue(i0, i1, i2, w * ds.value(i0, i1, i2, i3));
                            wresult.addValue(i0, i1, i2, w);
                        }
                    }
                }
            }
            double fill = Double.NaN;
            for (int i0 = 0; i0 < qube[0]; ++i0) {
                for (int i1 = 0; i1 < qube[1]; ++i1) {
                    for (int i2 = 0; i2 < qube[2]; ++i2) {
                        double w = wresult.value(i0, i1, i2);
                        if (w > 0.0) {
                            double n = result.value(i0, i1, i2);
                            result.putValue(i0, i1, i2, n / w);
                            continue;
                        }
                        result.putValue(i0, i1, i2, fill);
                    }
                }
            }
            mon.finished();
            Map<String, Object> props = DataSetUtil.getProperties(ds);
            props = DataSetOps.sliceProperties(props, 2);
            DataSetUtil.putProperties(props, result);
            result.putProperty("WEIGHTS", wresult);
            return result;
        }
        throw new IllegalArgumentException("only rank 4");
    }

    public static QDataSet trim(QDataSet ds, int st, int en) {
        return ds.trim(st, en);
    }

    public static QDataSet trim(QDataSet ds, DatumRange dr) {
        return Ops.trim(ds, Ops.dataset(dr.min()), Ops.dataset(dr.max()));
    }

    public static QDataSet trim(QDataSet ds, Object odr) {
        DatumRange dr = Ops.datumRange(odr);
        return Ops.trim(ds, Ops.dataset(dr.min()), Ops.dataset(dr.max()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QDataSet trim(QDataSet ds, QDataSet st, QDataSet en) {
        double f2;
        double f1;
        QDataSet dep0;
        if (st.rank() != 0 || en.rank() != 0) {
            if (st.rank() != 1 || st.length() != 2 || en.rank() != 1 || en.length() != 2) throw new IllegalArgumentException("start and end parameters must be both rank 0 or both rank 1");
            return SemanticOps.trim(ds, Ops.datumRange(st), Ops.datumRange(en));
        }
        if (ds == null) {
            throw new NullPointerException("ds is null");
        }
        if (ds.length() == 0) {
            return ds;
        }
        QDataSet dep0en = dep0 = SemanticOps.xtagsDataSet(ds);
        if (dep0.rank() != 1 && dep0.rank() == 2) {
            WritableDataSet dep0enc = Ops.copy(Ops.slice1(dep0, 0));
            dep0enc.putProperty("UNITS", SemanticOps.getUnits(dep0));
            WritableDataSet dep0stc = Ops.copy(dep0enc);
            dep0stc.putProperty("UNITS", SemanticOps.getUnits(dep0));
            for (int i = 0; i < dep0.length(); ++i) {
                double d2;
                QDataSet dep0slice = dep0.slice(i);
                double d1 = dep0slice.slice(dep0slice.length() - 1).value();
                if (d1 > (d2 = dep0slice.slice(0).value())) {
                    double t = d1;
                    d1 = d2;
                    d2 = t;
                }
                dep0enc.putValue(i, d1);
                dep0stc.putValue(i, d2);
            }
            dep0 = dep0stc;
            dep0en = dep0enc;
            Ops.lt(dep0, dep0en);
        }
        if (dep0.length() < 1) {
            return ds;
        }
        if (dep0.length() < 2) {
            Datum startDatum = Ops.datum(st);
            Datum stopDatum = Ops.datum(en);
            Datum t = Ops.datum(dep0.slice(0));
            if (!startDatum.le(t) || !t.le(stopDatum)) return ds.trim(0, 0);
            return ds;
        }
        if (!DataSetUtil.isMonotonic(dep0)) {
            logger.fine("Using O(N) branch on non-monotonic times of dataset");
            DatumRange range = DatumRangeUtil.union((Datum)Ops.datum(st), (Datum)Ops.datum(en));
            QDataSet r = Ops.where(Ops.within((Object)dep0, range));
            if (Ops.reduceMax(Ops.diff(r), 0).value() != 1.0) return Ops.applyIndex(ds, r);
            f1 = r.value(0);
            f2 = r.value(r.length() - 1) + 1.0;
        } else {
            QDataSet findex = Ops.findex(dep0, st);
            f1 = Math.ceil(findex.value());
            findex = Ops.findex(dep0en, en);
            f2 = Math.ceil(findex.value());
        }
        int n = dep0.length();
        f1 = 0.0 > f1 ? 0.0 : f1;
        f1 = (double)n < f1 ? (double)n : f1;
        f2 = 0.0 > f2 ? 0.0 : f2;
        double d = f2 = (double)n < f2 ? (double)n : f2;
        if (!(f1 > f2)) return ds.trim((int)f1, (int)f2);
        if (!(Ops.ge(st, en).value() > 0.0)) return ds.trim((int)f1, (int)f1);
        throw new IllegalArgumentException("st must be less than (or earlier than) en");
    }

    public static QDataSet trim(int dim, QDataSet ds, int st, int en) {
        if (dim == 0) {
            return Ops.trim(ds, st, en);
        }
        TrimStrideWrapper tsw = new TrimStrideWrapper(ds);
        tsw.setTrim(dim, st, en, 1);
        return tsw;
    }

    public static QDataSet trim(int dim, QDataSet ds, QDataSet st, QDataSet en) {
        if (dim == 0) {
            return Ops.trim(ds, st, en);
        }
        QDataSet dep = (QDataSet)ds.property("DEPEND_" + dim);
        if (dep.rank() == 2) {
            JoinDataSet result = new JoinDataSet(ds.rank());
            for (int i = 0; i < ds.length(); ++i) {
                QDataSet sliceds = Ops.trim(dim - 1, ds.slice(i), st, en);
                result.join(sliceds);
            }
            DataSetUtil.copyDimensionProperties(ds, result);
            result.putProperty("DEPEND_0", ds.property("DEPEND_0"));
            JoinDataSet dep1 = new JoinDataSet(2);
            for (int i = 0; i < result.length(); ++i) {
                QDataSet sliceds = (QDataSet)result.slice(i).property("DEPEND_0");
                dep1.join(sliceds);
            }
            result.putProperty("DEPEND_1", dep1);
            result.property("JOIN_0");
            return result;
        }
        if (dep.rank() != 1) {
            throw new IllegalArgumentException("depend rank must be 1 or 2 for trim");
        }
        QDataSet findex = Ops.findex(dep, st);
        double f1 = Math.ceil(findex.value());
        findex = Ops.findex(dep, en);
        double f2 = Math.ceil(findex.value());
        int n = dep.length();
        f1 = 0.0 > f1 ? 0.0 : f1;
        f1 = (double)n < f1 ? (double)n : f1;
        f2 = 0.0 > f2 ? 0.0 : f2;
        f2 = (double)n < f2 ? (double)n : f2;
        TrimStrideWrapper tsw = new TrimStrideWrapper(ds);
        tsw.setTrim(dim, (int)f1, (int)f2, 1);
        return tsw;
    }

    public static QDataSet trim1(QDataSet ds, QDataSet st, QDataSet en) {
        if (st.rank() != 0 || en.rank() != 0) {
            throw new IllegalArgumentException("bounds must be rank 0");
        }
        if (ds == null) {
            throw new NullPointerException("ds is null");
        }
        QDataSet dep1 = SemanticOps.ytagsDataSet(ds);
        if (dep1.rank() != 1) {
            return Ops.trim(1, ds, st, en);
        }
        QDataSet findex = Ops.findex(dep1, st);
        double f1 = Math.ceil(findex.value());
        findex = Ops.findex(dep1, en);
        double f2 = Math.ceil(findex.value());
        int n = dep1.length();
        f1 = 0.0 > f1 ? 0.0 : f1;
        f1 = (double)n < f1 ? (double)n : f1;
        f2 = 0.0 > f2 ? 0.0 : f2;
        double d = f2 = (double)n < f2 ? (double)n : f2;
        if (f1 > f2) {
            throw new IllegalArgumentException("st must be less than (or earlier than) en");
        }
        return Ops.trim1(ds, (int)f1, (int)f2);
    }

    public static QDataSet trim1(QDataSet ds, int st, int en) {
        if (ds.rank() == 2) {
            QDataSet bundle1 = (QDataSet)ds.property("BUNDLE_1");
            if (bundle1 != null) {
                bundle1 = bundle1.trim(st, en);
            }
            ds = DataSetOps.leafTrim(ds, st, en);
            if (bundle1 != null) {
                ds = Ops.putProperty(ds, "BUNDLE_1", (Object)bundle1);
            }
            return ds;
        }
        TrimStrideWrapper tsw = new TrimStrideWrapper(ds);
        tsw.setTrim(1, st, en, 1);
        return tsw;
    }

    public static QDataSet setDepend0Cadence(QDataSet ds, String arg) throws ParseException {
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            Map<String, Object> props = DataSetUtil.getDimensionProperties(ds, null);
            Units dep0units = SemanticOps.getUnits(dep0);
            DRank0DataSet cadence = DataSetUtil.asDataSet(dep0units.getOffsetUnits().parse(arg));
            MutablePropertyDataSet mdep0 = Ops.putProperty(dep0, "CADENCE", (Object)cadence);
            ds = Ops.putProperty(ds, "DEPEND_0", (Object)mdep0);
            DataSetUtil.putProperties(props, (MutablePropertyDataSet)ds);
        } else if (SemanticOps.isJoin(ds)) {
            JoinDataSet n = new JoinDataSet(ds.rank());
            Map<String, Object> props = DataSetUtil.getDimensionProperties(ds, null);
            for (int ii = 0; ii < ds.length(); ++ii) {
                QDataSet fillDs1 = ds.slice(ii);
                Map<String, Object> props1 = DataSetUtil.getDimensionProperties(fillDs1, null);
                dep0 = (QDataSet)fillDs1.property("DEPEND_0");
                Units dep0units = SemanticOps.getUnits(dep0);
                DRank0DataSet cadence = DataSetUtil.asDataSet(dep0units.getOffsetUnits().parse(arg));
                MutablePropertyDataSet mdep0 = Ops.putProperty(dep0, "CADENCE", (Object)cadence);
                fillDs1 = Ops.putProperty(fillDs1, "DEPEND_0", (Object)mdep0);
                DataSetUtil.putProperties(props1, (MutablePropertyDataSet)fillDs1);
                n.join(fillDs1);
            }
            ds = n;
            DataSetUtil.putProperties(props, (MutablePropertyDataSet)ds);
        }
        return ds;
    }

    public static QDataSet setDepend1Cadence(QDataSet ds, String arg) throws ParseException {
        Map<String, Object> props = DataSetUtil.getDimensionProperties(ds, null);
        QDataSet dep1 = (QDataSet)(ds = Ops.copy(ds)).property("DEPEND_1");
        if (dep1 != null) {
            Datum news;
            Units dep1units = SemanticOps.getUnits(dep1);
            try {
                news = dep1units.getOffsetUnits().parse(arg);
            }
            catch (ParseException | InconvertibleUnitsException ex) {
                news = DatumUtil.parse((String)arg);
            }
            MutablePropertyDataSet mdep0 = Ops.putProperty(dep1, "CADENCE", (Object)DataSetUtil.asDataSet(news));
            ds = Ops.putProperty(ds, "DEPEND_1", (Object)mdep0);
        }
        DataSetUtil.putProperties(props, (MutablePropertyDataSet)ds);
        return ds;
    }

    public static QDataSet setValidRange(QDataSet ds, String arg) throws ParseException {
        Units u = SemanticOps.getUnits(ds);
        DatumRange d = DatumRangeUtil.parseDatumRange((String)arg, (Units)u);
        ds = Ops.putProperty(ds, "VALID_MIN", (Object)d.min().doubleValue(u));
        ds = Ops.putProperty(ds, "VALID_MAX", (Object)d.max().doubleValue(u));
        return ds;
    }

    public static QDataSet setNominalRange(QDataSet ds, String arg) throws ParseException {
        Units u = SemanticOps.getUnits(ds);
        DatumRange d = DatumRangeUtil.parseDatumRange((String)arg, (Units)u);
        HashMap<String, Double> meta = (HashMap<String, Double>)ds.property("METADATA");
        meta = meta == null ? new HashMap<String, Double>() : new HashMap(meta);
        meta.put("LIMITS_NOMINAL_MIN", d.min().doubleValue(u));
        meta.put("LIMITS_NOMINAL_MAX", d.max().doubleValue(u));
        ds = Ops.putProperty(ds, "METADATA", meta);
        return ds;
    }

    public static QDataSet setWarnRange(QDataSet ds, String arg) throws ParseException {
        Units u = SemanticOps.getUnits(ds);
        DatumRange d = DatumRangeUtil.parseDatumRange((String)arg, (Units)u);
        HashMap<String, Double> meta = (HashMap<String, Double>)ds.property("METADATA");
        meta = meta == null ? new HashMap<String, Double>() : new HashMap(meta);
        meta.put("LIMITS_WARN_MIN", d.min().doubleValue(u));
        meta.put("LIMITS_WARN_MAX", d.max().doubleValue(u));
        ds = Ops.putProperty(ds, "METADATA", meta);
        return ds;
    }

    public static QDataSet sqrt(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double d1) -> Math.sqrt(d1));
        String ll = (String)ds.property("LABEL");
        if (ll == null) {
            ll = (String)ds.property("NAME");
        }
        if (ll != null) {
            result.putProperty("LABEL", String.format("sqrt(%s)", ll));
        }
        return result;
    }

    public static double sqrt(double ds1) {
        return Math.sqrt(ds1);
    }

    public static QDataSet sqrt(Object ds1) {
        return Ops.sqrt(Ops.dataset(ds1));
    }

    public static QDataSet butterworth(QDataSet in, int order, Datum f, boolean lowp) {
        if (in.rank() == 2) {
            AbstractDataSet result;
            if (Schemes.isRank2Waveform(in)) {
                JoinDataSet jds = new JoinDataSet(2);
                for (int i = 0; i < in.length(); ++i) {
                    Butterworth b = new Butterworth(in.slice(i), order, f, lowp);
                    jds.join(b.filter());
                }
                result = jds;
            } else if (Schemes.isBundleDataSet(in)) {
                BundleDataSet bds = new BundleDataSet(in.rank());
                for (int i = 0; i < in.length(0); ++i) {
                    Butterworth b = new Butterworth(Ops.unbundle(in, i), order, f, lowp);
                    bds.bundle(b.filter());
                }
                result = bds;
            } else {
                throw new IllegalArgumentException("unsupported scheme, must be waveform or bundle of waveforms");
            }
            DataSetUtil.putProperties(DataSetUtil.getProperties(in), result);
            return result;
        }
        Butterworth b = new Butterworth(in, order, f, lowp);
        return b.filter();
    }

    public static QDataSet butterworth(QDataSet in, int order, Datum flow, Datum fhigh, boolean pass) {
        if (in.rank() == 2) {
            AbstractDataSet result;
            if (Schemes.isRank2Waveform(in)) {
                JoinDataSet jds = new JoinDataSet(2);
                for (int i = 0; i < in.length(); ++i) {
                    Butterworth b = new Butterworth(in.slice(i), order, flow, fhigh, pass);
                    jds.join(b.filter());
                }
                result = jds;
            } else if (Schemes.isBundleDataSet(in)) {
                BundleDataSet bds = new BundleDataSet(in.rank());
                for (int i = 0; i < in.length(0); ++i) {
                    Butterworth b = new Butterworth(Ops.unbundle(in, i), order, flow, fhigh, pass);
                    bds.bundle(b.filter());
                }
                result = bds;
            } else {
                throw new IllegalArgumentException("unsupported scheme, must be waveform or bundle of waveforms");
            }
            DataSetUtil.putProperties(DataSetUtil.getProperties(in), result);
            return result;
        }
        Butterworth b = new Butterworth(in, order, flow, fhigh, pass);
        return b.filter();
    }

    public static QDataSet cubicRoot(QDataSet coefficients) {
        if (coefficients.rank() != 2) {
            throw new IllegalArgumentException("Must pass rank 2 QDataSet to cubicRoot");
        }
        if (coefficients.length(0) != 4 || !DataSetUtil.isQube(coefficients)) {
            throw new IllegalArgumentException("Each row must be length 4 for cubicRoot");
        }
        DDataSet result = DDataSet.createRank2(coefficients.length(), 3);
        for (int i = 0; i < coefficients.length(); ++i) {
            double[] answers = Ops.cubicRoot(coefficients.value(i, 0), coefficients.value(i, 1), coefficients.value(i, 2), coefficients.value(i, 3));
            result.putValue(i, 0, answers[0]);
            result.putValue(i, 1, answers[1]);
            result.putValue(i, 2, answers[2]);
        }
        return result;
    }

    public static double[] cubicRoot(double a, double b, double c, double d) throws ArithmeticException {
        double[] result;
        if (a == 0.0) {
            throw new IllegalArgumentException("Coefficient of x^3 cannot be 0 for cubicRoot.");
        }
        double g = (2.0 * b * b * b / (a * a * a) - 9.0 * b * c / (a * a) + 27.0 * d / a) / 27.0;
        double f = (3.0 * c / a - b * b / (a * a)) / 3.0;
        double h = g * g / 4.0 + f * f * f / 27.0;
        if (h > 0.0) {
            double r = -g / 2.0 + Math.sqrt(h);
            double s = r > 0.0 ? Math.pow(r, 0.3333333333333333) : -Math.pow(-r, 0.3333333333333333);
            double t = -g / 2.0 - Math.sqrt(h);
            double u = t > 0.0 ? Math.pow(t, 0.3333333333333333) : -Math.pow(-t, 0.3333333333333333);
            result = new double[]{s + u - b / (3.0 * a), Double.NaN, Double.NaN};
        } else if (f == 0.0 && g == 0.0 && h == 0.0) {
            result = new double[3];
            result[1] = result[2] = -Math.pow(d / a, 0.3333333333333333);
            result[0] = result[2];
        } else if (h <= 0.0) {
            double i = Math.sqrt(g * g / 4.0 - h);
            double j = Math.pow(i, 0.3333333333333333);
            double k = Math.acos(-g / (2.0 * i));
            double l = -j;
            double m = Math.cos(k / 3.0);
            double n = Math.sqrt(3.0) * Math.sin(k / 3.0);
            double P = -b / (3.0 * a);
            result = new double[]{2.0 * j * Math.cos(k / 3.0) - b / (3.0 * a), l * (m + n) + P, l * (m - n) + P};
        } else {
            throw new ArithmeticException("Undefined case in cubicRoot.");
        }
        return result;
    }

    public static QDataSet abs(QDataSet ds1) {
        Units u = (Units)ds1.property("UNITS");
        if (u != null && u instanceof EnumerationUnits) {
            throw new IllegalArgumentException("data is from an enumeration, and abs cannot be used.");
        }
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds1, (double d1) -> Math.abs(d1));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(ds1, "abs"));
        if (u != null && UnitsUtil.isRatioMeasurement((Units)u)) {
            result.putProperty("UNITS", u);
        }
        return result;
    }

    public static long abs(long x) {
        return Math.abs(x);
    }

    public static double abs(double v) {
        return Math.abs(v);
    }

    public static QDataSet abs(Object ds1) {
        return Ops.abs(Ops.dataset(ds1));
    }

    public static QDataSet pow(QDataSet ds1, QDataSet pow) {
        Units units1 = SemanticOps.getUnits(ds1);
        Units units2 = SemanticOps.getUnits(pow);
        if (UnitsUtil.isTimeLocation((Units)units1)) {
            throw new IllegalArgumentException("ds1 is time location");
        }
        if (UnitsUtil.isTimeLocation((Units)units2)) {
            throw new IllegalArgumentException("pow is time location");
        }
        MutablePropertyDataSet result = Ops.applyBinaryOp(ds1, pow, (double d1, double d2) -> Math.pow(d1, d2));
        if (pow.rank() == 0) {
            double v = pow.value();
            String l = (String)ds1.property("LABEL");
            if (l == null) {
                l = (String)ds1.property("NAME");
            }
            if (l != null) {
                if (v == (double)((int)v)) {
                    result.putProperty("LABEL", String.format("%s**%d", l, (int)v));
                } else {
                    result.putProperty("LABEL", String.format("%s**%f", l, v));
                }
            }
        } else {
            result.putProperty("LABEL", Ops.maybeLabelBinaryOp(ds1, pow, "pow"));
        }
        return result;
    }

    public static long pow(long x, long y) {
        return (long)Math.pow(x, y);
    }

    public static double pow(double x, double y) {
        return Math.pow(x, y);
    }

    public static QDataSet pow(Object ds1, Object pow) {
        return Ops.pow(Ops.dataset(ds1), Ops.dataset(pow));
    }

    public static QDataSet exp(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double d1) -> Math.pow(Math.E, d1));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(ds, "exp"));
        return result;
    }

    public static double exp(double d) {
        return Math.exp(d);
    }

    public static QDataSet exp(Object ds1) {
        return Ops.exp(Ops.dataset(ds1));
    }

    public static QDataSet exp10(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double d1) -> Math.pow(10.0, d1));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(ds, "exp10"));
        return result;
    }

    public static double exp10(double ds1) {
        return Math.pow(10.0, ds1);
    }

    public static QDataSet exp10(Object ds1) {
        return Ops.exp10(Ops.dataset(ds1));
    }

    public static QDataSet log(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double d1) -> Math.log(d1));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(ds, "log"));
        return result;
    }

    public static double log(double ds1) {
        return Math.log(ds1);
    }

    public static QDataSet log(Object ds1) {
        return Ops.log(Ops.dataset(ds1));
    }

    public static QDataSet log10(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double d1) -> Math.log10(d1));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(ds, "log10"));
        return result;
    }

    public static double log10(double ds1) {
        return Math.log10(ds1);
    }

    public static QDataSet log10(Object ds1) {
        return Ops.log10(Ops.dataset(ds1));
    }

    private static Units multiplyUnits(Units units1, Units units2) {
        Units resultUnits;
        if (units1 == Units.dimensionless && units2 == Units.dimensionless) {
            resultUnits = Units.dimensionless;
        } else if (units2 == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)units1)) {
            resultUnits = units1;
        } else if (units1 == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)units2)) {
            resultUnits = units2;
        } else {
            if (!UnitsUtil.isRatioMeasurement((Units)units1)) {
                throw new IllegalArgumentException("ds1 units are not ratio scale units: " + units1);
            }
            if (!UnitsUtil.isRatioMeasurement((Units)units2)) {
                throw new IllegalArgumentException("ds2 units are not ratio scale units: " + units2);
            }
            logger.fine("throwing out units until we improve the units library, both arguments have physical units");
            resultUnits = null;
        }
        return resultUnits;
    }

    private static boolean checkComplexArgument(QDataSet ds1) {
        QDataSet dep = (QDataSet)ds1.property("DEPEND_" + (ds1.rank() - 1));
        if (dep == null) {
            return false;
        }
        return "ComplexNumber".equals(dep.property("COORDINATE_FRAME"));
    }

    public static QDataSet multiply(QDataSet ds1, QDataSet ds2) {
        Units units1 = SemanticOps.getUnits(ds1);
        Units units2 = SemanticOps.getUnits(ds2);
        Units resultUnits = Ops.multiplyUnits(units1, units2);
        if (Ops.checkComplexArgument(ds1) && Ops.checkComplexArgument(ds2)) {
            logger.warning("multiply used with two complex arguments, perhaps complexMultiply was intended");
        }
        MutablePropertyDataSet result = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> d1 * d2);
        if (resultUnits != Units.dimensionless) {
            result.putProperty("UNITS", resultUnits);
        }
        result.putProperty("LABEL", Ops.maybeLabelInfixOp(ds1, ds2, "*"));
        return result;
    }

    public static QDataSet multiply(Object ds1, Object ds2) {
        return Ops.multiply(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet divide(QDataSet ds1, QDataSet ds2) {
        UnitsConverter uc;
        Units resultUnits;
        Units units2;
        Units units1 = SemanticOps.getUnits(ds1);
        if (units1 == (units2 = SemanticOps.getUnits(ds2))) {
            resultUnits = Units.dimensionless;
            uc = UnitsConverter.IDENTITY;
        } else if (units2 == Units.dimensionless && UnitsUtil.isRatioMeasurement((Units)units1)) {
            resultUnits = units1;
            uc = UnitsConverter.IDENTITY;
        } else if (units2.isConvertibleTo(units1)) {
            resultUnits = Units.dimensionless;
            uc = units2.getConverter(units1);
        } else {
            if (!UnitsUtil.isRatioMeasurement((Units)units1)) {
                throw new IllegalArgumentException("ds1 units are not ratio scale units: " + units1);
            }
            if (!UnitsUtil.isRatioMeasurement((Units)units2)) {
                throw new IllegalArgumentException("ds2 units are not ratio scale units: " + units2);
            }
            if (units1 == Units.dimensionless) {
                try {
                    resultUnits = UnitsUtil.getInverseUnit((Units)units2);
                }
                catch (IllegalArgumentException ex) {
                    logger.info(String.format("unable to invert ds2 units (%s), arguments have unequal units in divide (/)", units2));
                    resultUnits = null;
                }
            } else {
                logger.info("throwing out units until we improve the units library, arguments have unequal units");
                resultUnits = null;
            }
            uc = UnitsConverter.IDENTITY;
        }
        MutablePropertyDataSet result = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> d1 / uc.convert(d2));
        if (resultUnits != Units.dimensionless) {
            result.putProperty("UNITS", resultUnits);
        }
        result.putProperty("LABEL", Ops.maybeLabelInfixOp(ds1, ds2, "/"));
        return result;
    }

    public static QDataSet divide(Object ds1, Object ds2) {
        return Ops.divide(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet mod(QDataSet ds1, QDataSet ds2) {
        Units u1 = SemanticOps.getUnits(ds1).getOffsetUnits();
        Units u = SemanticOps.getUnits(ds2);
        UnitsConverter uc = u1.getConverter(u);
        double base = 0.0;
        MutablePropertyDataSet result = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> uc.convert(d1 - 0.0) % d2);
        result.putProperty("UNITS", u);
        if (ds2.rank() == 0) {
            double d = ds2.value();
            if (d == 24.0) {
                result.putProperty("AVERAGE_TYPE", "mod24");
            } else if (d == 360.0) {
                result.putProperty("AVERAGE_TYPE", "mod360");
            } else if (d == Math.PI) {
                result.putProperty("AVERAGE_TYPE", "modpi");
            } else if (d == Math.PI * 2) {
                result.putProperty("AVERAGE_TYPE", "modtau");
            }
        }
        return result;
    }

    public static QDataSet mod(Object ds1, Object ds2) {
        return Ops.mod(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet modp(QDataSet ds1, QDataSet ds2) {
        Units u1 = SemanticOps.getUnits(ds1).getOffsetUnits();
        Units u = SemanticOps.getUnits(ds2);
        UnitsConverter uc = u1.getConverter(u);
        double base = 0.0;
        MutablePropertyDataSet result = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> {
            double t = uc.convert(d1 - 0.0) % d2;
            return t < 0.0 ? t + d2 : t;
        });
        result.putProperty("UNITS", u);
        if (ds2.rank() == 0) {
            double d = ds2.value();
            if (d == 24.0) {
                result.putProperty("AVERAGE_TYPE", "mod24");
            } else if (d == 360.0) {
                result.putProperty("AVERAGE_TYPE", "mod360");
            } else if (d == Math.PI) {
                result.putProperty("AVERAGE_TYPE", "modpi");
            } else if (d == Math.PI * 2) {
                result.putProperty("AVERAGE_TYPE", "modtau");
            }
        }
        return result;
    }

    public static QDataSet modp(Object ds1, Object ds2) {
        return Ops.modp(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet divp(QDataSet ds1, QDataSet ds2) {
        Units resultUnits;
        UnitsConverter uc1;
        Units u1 = SemanticOps.getUnits(ds1);
        Units u = SemanticOps.getUnits(ds2);
        try {
            uc1 = u1.getConverter(u);
        }
        catch (IllegalArgumentException ex) {
            uc1 = UnitsConverter.IDENTITY;
        }
        UnitsConverter uc = uc1;
        MutablePropertyDataSet result = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> Math.floor(uc.convert(d1) / d2));
        Units units = resultUnits = uc == UnitsConverter.IDENTITY ? u1 : Units.dimensionless;
        if (resultUnits != null) {
            result.putProperty("UNITS", resultUnits);
        }
        return result;
    }

    public static QDataSet divp(Object ds1, Object ds2) {
        return Ops.divp(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet div(QDataSet ds1, QDataSet ds2) {
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> (int)(d1 / d2));
    }

    public static QDataSet div(Object ds1, Object ds2) {
        return Ops.div(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet eq(QDataSet ds1, QDataSet ds2) {
        UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> uc.convert(d1) == d2 ? 1.0 : 0.0);
    }

    private static QDataSet enumerationUnitsCheck(QDataSet ds1, Object o2, QDataSet ds2) {
        if (ds1 == null) {
            return ds2;
        }
        Units u = SemanticOps.getUnits(ds1);
        if (u instanceof EnumerationUnits) {
            return Ops.dataset(o2, u);
        }
        return ds2;
    }

    public static QDataSet eq(Object ds1, Object ds2) {
        QDataSet dds2;
        QDataSet dds1;
        try {
            dds1 = Ops.dataset(ds1);
        }
        catch (IllegalArgumentException ex) {
            dds1 = null;
        }
        try {
            dds2 = Ops.dataset(ds2);
        }
        catch (IllegalArgumentException ex) {
            dds2 = null;
        }
        dds2 = Ops.enumerationUnitsCheck(dds1, ds2, dds2);
        dds1 = Ops.enumerationUnitsCheck(dds2, ds1, dds1);
        return Ops.eq(dds1, dds2);
    }

    public static QDataSet ne(QDataSet ds1, QDataSet ds2) {
        UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> uc.convert(d1) != d2 ? 1.0 : 0.0);
    }

    public static QDataSet ne(Object ds1, Object ds2) {
        QDataSet dds2;
        QDataSet dds1;
        try {
            dds1 = Ops.dataset(ds1);
        }
        catch (IllegalArgumentException ex) {
            dds1 = null;
        }
        try {
            dds2 = Ops.dataset(ds2);
        }
        catch (IllegalArgumentException ex) {
            dds2 = null;
        }
        dds2 = Ops.enumerationUnitsCheck(dds1, ds2, dds2);
        dds1 = Ops.enumerationUnitsCheck(dds2, ds1, dds1);
        return Ops.ne(dds1, dds2);
    }

    public static QDataSet gt(QDataSet ds1, QDataSet ds2) {
        UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> uc.convert(d1) > d2 ? 1.0 : 0.0);
    }

    public static QDataSet gt(Object ds1, Object ds2) {
        return Ops.gt(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet greaterOf(QDataSet ds1, QDataSet ds2) {
        UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds2, ds1);
        MutablePropertyDataSet mpds = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> uc.convert(d2) > d1 ? d2 : d1);
        mpds.putProperty("UNITS", ds1.property("UNITS"));
        return mpds;
    }

    public static QDataSet greaterOf(Object ds1, Object ds2) {
        return Ops.greaterOf(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet lesserOf(QDataSet ds1, QDataSet ds2) {
        UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds2, ds1);
        MutablePropertyDataSet mpds = Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> uc.convert(d2) < d1 ? d2 : d1);
        mpds.putProperty("UNITS", ds1.property("UNITS"));
        return mpds;
    }

    public static QDataSet lesserOf(Object ds1, Object ds2) {
        return Ops.lesserOf(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet ge(QDataSet ds1, QDataSet ds2) {
        UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> uc.convert(d1) >= d2 ? 1.0 : 0.0);
    }

    public static QDataSet ge(Object ds1, Object ds2) {
        return Ops.ge(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet lt(QDataSet ds1, QDataSet ds2) {
        UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> uc.convert(d1) < d2 ? 1.0 : 0.0);
    }

    public static QDataSet lt(Object ds1, Object ds2) {
        return Ops.lt(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet le(QDataSet ds1, QDataSet ds2) {
        UnitsConverter uc = SemanticOps.getLooseUnitsConverter(ds1, ds2);
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> uc.convert(d1) <= d2 ? 1.0 : 0.0);
    }

    public static QDataSet le(Object ds1, Object ds2) {
        return Ops.le(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet or(QDataSet ds1, QDataSet ds2) {
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> d1 != 0.0 || d2 != 0.0 ? 1.0 : 0.0);
    }

    public static QDataSet or(Object ds1, Object ds2) {
        return Ops.or(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet and(QDataSet ds1, QDataSet ds2) {
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> d1 != 0.0 && d2 != 0.0 ? 1.0 : 0.0);
    }

    public static QDataSet and(Object ds1, Object ds2) {
        return Ops.and(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet bitwiseAnd(QDataSet ds1, QDataSet ds2) {
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> (long)d1 & (long)d2);
    }

    public static QDataSet bitwiseAnd(Object ds1, Object ds2) {
        return Ops.bitwiseAnd(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet bitwiseOr(QDataSet ds1, QDataSet ds2) {
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> (long)d1 | (long)d2);
    }

    public static QDataSet bitwiseOr(Object ds1, Object ds2) {
        return Ops.bitwiseOr(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet bitwiseXor(QDataSet ds1, QDataSet ds2) {
        return Ops.applyBinaryOp(ds1, ds2, (double d1, double d2) -> (long)d1 ^ (long)d2);
    }

    public static QDataSet bitwiseXor(Object ds1, Object ds2) {
        return Ops.bitwiseXor(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet not(QDataSet ds1) {
        return Ops.applyUnaryOp(ds1, (double d1) -> d1 != 0.0 ? 0.0 : 1.0);
    }

    public static QDataSet not(Object ds1) {
        return Ops.not(Ops.dataset(ds1));
    }

    public static Iterator<Integer> irange(double min, double max, int step) {
        double imin = Math.floor(min);
        double imax = Math.floor(max);
        double istep = step;
        if (istep % 1.0 != 0.0) {
            throw new IllegalArgumentException("step must be an integer");
        }
        int length = (int)((imax - imin) / istep);
        final TagGenDataSet result = new TagGenDataSet(length, istep, imin);
        result.putProperty("FORMAT", "%d");
        return new Iterator<Integer>(){
            int p = 0;

            @Override
            public boolean hasNext() {
                return this.p < result.length();
            }

            @Override
            public Integer next() {
                int i = (int)result.value(this.p);
                ++this.p;
                return i;
            }
        };
    }

    public static Iterator<Integer> irange(double min, double max) {
        return Ops.irange(min, max, 1);
    }

    public static Iterator<Integer> irange(double max) {
        return Ops.irange(0.0, max, 1);
    }

    public static QDataSet indgen(int len0) {
        return new IndexGenDataSet(len0);
    }

    public static QDataSet indgen(int len0, int len1) {
        int size = len0 * len1;
        int[] back = new int[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return IDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static QDataSet indgen(int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        int[] back = new int[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return IDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static QDataSet dindgen(int len0) {
        int size = len0;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return DDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static QDataSet dindgen(int len0, int len1) {
        int size = len0 * len1;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return DDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static QDataSet dindgen(int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return DDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static QDataSet dindgen(int len0, int len1, int len2, int len3) {
        int size = len0 * len1 * len2 * len3;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return DDataSet.wrap(back, new int[]{len0, len1, len2, len3});
    }

    public static String convertToString(QDataSet bytes) {
        char[] chs = new char[bytes.length()];
        for (int i = 0; i < bytes.length(); ++i) {
            chs[i] = (char)bytes.value(i);
        }
        return new String(chs);
    }

    public static QDataSet arange(int len0) {
        return Ops.findgen(len0);
    }

    public static QDataSet findgen(int len0) {
        int size = len0;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return FDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static QDataSet findgen(int len0, int len1) {
        int size = len0 * len1;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return FDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static QDataSet findgen(int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return FDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static QDataSet findgen(int len0, int len1, int len2, int len3) {
        int size = len0 * len1 * len2 * len3;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        return FDataSet.wrap(back, new int[]{len0, len1, len2, len3});
    }

    public static QDataSet strarr(int len0) {
        EnumerationUnits u;
        String context = "default";
        try {
            Units uu = Units.getByName((String)context);
            u = uu != null && uu instanceof EnumerationUnits ? (EnumerationUnits)uu : new EnumerationUnits(context);
        }
        catch (IllegalArgumentException ex) {
            u = new EnumerationUnits(context);
        }
        IDataSet result = IDataSet.createRank1(len0);
        Datum d = u.createDatum((Object)"");
        double dval = d.doubleValue((Units)u);
        for (int i = 0; i < len0; ++i) {
            result.putValue(i, dval);
        }
        result.putProperty("UNITS", u);
        return result;
    }

    public static QDataSet strarr(int len0, int len1) {
        EnumerationUnits u;
        String context = "default";
        try {
            Units uu = Units.getByName((String)context);
            u = uu != null && uu instanceof EnumerationUnits ? (EnumerationUnits)uu : new EnumerationUnits(context);
        }
        catch (IllegalArgumentException ex) {
            u = new EnumerationUnits(context);
        }
        IDataSet result = IDataSet.createRank2(len0, len1);
        Datum d = u.createDatum((Object)"");
        double dval = d.doubleValue((Units)u);
        for (int i = 0; i < len0; ++i) {
            for (int j = 0; j < len1; ++j) {
                result.putValue(i, j, dval);
            }
        }
        result.putProperty("UNITS", u);
        return result;
    }

    public static QDataSet fltarr(int len0) {
        return Ops.replicate(0.0f, len0);
    }

    public static QDataSet fltarr(int len0, int len1) {
        return Ops.replicate(0.0f, len0, len1);
    }

    public static QDataSet fltarr(int len0, int len1, int len2) {
        return Ops.replicate(0.0f, len0, len1, len2);
    }

    public static QDataSet bytarr(int len0) {
        return BufferDataSet.createRank1(BufferDataSet.UBYTE, len0);
    }

    public static QDataSet bytarr(int len0, int len1) {
        return BufferDataSet.createRank2(BufferDataSet.UBYTE, len0, len1);
    }

    public static QDataSet bytarr(int len0, int len1, int len2) {
        return BufferDataSet.createRank3(BufferDataSet.UBYTE, len0, len1, len2);
    }

    public static QDataSet shortarr(int len0) {
        return Ops.replicate((short)0, len0);
    }

    public static QDataSet shortarr(int len0, int len1) {
        return Ops.replicate((short)0, len0, len1);
    }

    public static QDataSet shortarr(int len0, int len1, int len2) {
        return Ops.replicate((short)0, len0, len1, len2);
    }

    public static QDataSet intarr(int len0) {
        return Ops.replicate(0, len0);
    }

    public static QDataSet intarr(int len0, int len1) {
        return Ops.replicate(0, len0, len1);
    }

    public static QDataSet intarr(int len0, int len1, int len2) {
        return Ops.replicate(0, len0, len1, len2);
    }

    public static QDataSet lonarr(int len0) {
        return Ops.replicate(0L, len0);
    }

    public static QDataSet lonarr(int len0, int len1) {
        return Ops.replicate(0L, len0, len1);
    }

    public static QDataSet dblarr(int len0) {
        return Ops.replicate(0.0, len0);
    }

    public static QDataSet dblarr(int len0, int len1) {
        return Ops.replicate(0.0, len0, len1);
    }

    public static QDataSet dblarr(int len0, int len1, int len2) {
        return Ops.replicate(0.0, len0, len1, len2);
    }

    public static QDataSet timegen(String baseTime, String cadence, int len0) throws ParseException {
        double base = TimeUtil.create((String)baseTime).doubleValue((Units)Units.us2000);
        String[] ss = cadence.split(" ");
        Datum cad = null;
        if (ss.length == 2) {
            try {
                Units u = Units.lookupUnits((String)ss[1]);
                cad = u.parse(ss[0]);
            }
            catch (ParseException u) {
                // empty catch block
            }
        }
        if (cad == null) {
            cad = Units.us2000.getOffsetUnits().parse(cadence);
        }
        double dcadence = cad.doubleValue(Units.us2000.getOffsetUnits());
        return Ops.taggen(base, dcadence, len0, (Units)Units.us2000);
    }

    public static QDataSet toTimeDataSet(QDataSet years, QDataSet mons, QDataSet days, QDataSet hour, QDataSet minute, QDataSet second, QDataSet nano) {
        boolean isRank0;
        QDataSet[] operands = new QDataSet[2];
        for (int i = 0; i < 2; ++i) {
            if (mons != null) {
                CoerceUtil.coerce(years, mons, true, operands);
                years = operands[0];
                mons = operands[1];
            }
            if (days != null) {
                CoerceUtil.coerce(years, days, true, operands);
                years = operands[0];
                days = operands[1];
            }
            if (hour != null) {
                CoerceUtil.coerce(years, hour, true, operands);
                years = operands[0];
                hour = operands[1];
            }
            if (minute != null) {
                CoerceUtil.coerce(years, minute, true, operands);
                years = operands[0];
                minute = operands[1];
            }
            if (second != null) {
                CoerceUtil.coerce(years, second, true, operands);
                years = operands[0];
                second = operands[1];
            }
            if (nano == null) continue;
            CoerceUtil.coerce(years, nano, true, operands);
            years = operands[0];
            nano = operands[1];
        }
        boolean bl = isRank0 = years.rank() == 0;
        if (years.rank() > 1) {
            throw new IllegalArgumentException("toTimeDataSet only supports rank 0 and rank 1 data.");
        }
        DDataSet result = DDataSet.createRank1(isRank0 ? 1 : years.length());
        result.putProperty("UNITS", Units.us2000);
        if (mons == null) {
            mons = Ops.ones(years.length());
        }
        ConstantDataSet zeros = ConstantDataSet.create(0.0, DataSetUtil.qubeDims(years));
        if (hour == null) {
            hour = zeros;
        }
        if (minute == null) {
            minute = zeros;
        }
        if (second == null) {
            second = zeros;
        }
        if (nano == null) {
            nano = zeros;
        }
        if (isRank0) {
            years = Ops.join(null, years);
            mons = Ops.join(null, mons);
            days = Ops.join(null, days);
            hour = Ops.join(null, hour);
            minute = Ops.join(null, minute);
            second = Ops.join(null, second);
            nano = Ops.join(null, nano);
        }
        if (years.length() == 0) {
            throw new IllegalArgumentException("Empty year array");
        }
        if (years.value(0) < 100.0) {
            years = Ops.add(years, DataSetUtil.asDataSet(1900.0));
        }
        if (years.rank() != 1) {
            throw new IllegalArgumentException("years must be rank 1");
        }
        if (mons.rank() != 1) {
            throw new IllegalArgumentException("months must be rank 1 or null");
        }
        if (days.rank() != 1) {
            throw new IllegalArgumentException("days must be rank 1 or null");
        }
        if (hour.rank() != 1) {
            throw new IllegalArgumentException("hours must be rank 1 or null");
        }
        if (minute.rank() != 1) {
            throw new IllegalArgumentException("minutes must be rank 1 or null");
        }
        if (second.rank() != 1) {
            throw new IllegalArgumentException("seconds must be rank 1 or null");
        }
        if (nano.rank() != 1) {
            throw new IllegalArgumentException("nanos must be rank 1 or null");
        }
        for (int i = 0; i < result.length(); ++i) {
            int year = (int)years.value(i);
            double fyear = years.value(i) - (double)year;
            int month = (int)mons.value(i);
            double fmonth = mons.value(i) - (double)month;
            int day = (int)days.value(i);
            double fday = days.value(i) - (double)day;
            if (fyear > 0.0) {
                throw new IllegalArgumentException("fractional year not allowed: " + years.value(i));
            }
            if (fmonth > 0.0) {
                throw new IllegalArgumentException("fractional month not allowed: " + mons.value(i));
            }
            int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
            double microseconds = nano.value(i) / 1000.0 + second.value(i) * 1000000.0 + hour.value(i) * 3.6E9 + minute.value(i) * 6.0E7 + fday * 8.64E10;
            double us2000 = UnitsConverter.getConverter((Units)Units.mj1958, (Units)Units.us2000).convert((double)(jd - 2436205)) + microseconds;
            result.putValue(i, us2000);
        }
        if (isRank0) {
            return result.slice(0);
        }
        return result;
    }

    public static QDataSet toTimeDataSet(Object years, Object mons, Object days, Object hour, Object minute, Object second, Object nano) {
        return Ops.toTimeDataSet(Ops.dataset(years), Ops.dataset(mons), Ops.dataset(days), Ops.dataset(hour), Ops.dataset(minute), Ops.dataset(second), Ops.dataset(nano));
    }

    public static MutablePropertyDataSet taggen(double base, double dcadence, int len0, Units units) {
        double[] back = new double[len0];
        for (int i = 0; i < len0; ++i) {
            back[i] = base + (double)i * dcadence;
        }
        DDataSet result = DDataSet.wrap(back, 1, len0, 1, 1);
        result.putProperty("UNITS", units);
        result.putProperty("MONOTONIC", Boolean.TRUE);
        return result;
    }

    public static QDataSet linspace(double min, double max, int len0) {
        double[] back = new double[len0];
        if (len0 == 0) {
            return DDataSet.wrap(new double[]{0.0});
        }
        if (len0 == 1) {
            return DDataSet.wrap(new double[]{max});
        }
        if (len0 < 0) {
            throw new IllegalArgumentException("len0 cannot be less than 0");
        }
        double delta = (max - min) / (double)(len0 - 1);
        for (int i = 0; i < len0; ++i) {
            back[i] = min + (double)i * delta;
        }
        return DDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static QDataSet linspace(Object omin, Object omax, int len0) {
        QDataSet dsmin = Ops.dataset(omin);
        QDataSet dsmax = Ops.dataset(omax);
        Units u = SemanticOps.getUnits(dsmin);
        double min = dsmin.value();
        double max = Ops.convertUnitsTo(dsmax, u).value();
        QDataSet result = Ops.linspace(min, max, len0);
        return Ops.putProperty(result, "UNITS", (Object)u);
    }

    public static QDataSet logspace(double min, double max, int len0) {
        if (len0 < 1) {
            return DDataSet.wrap(new double[]{max});
        }
        return Ops.pow((Object)10, (Object)Ops.linspace(Math.log10(min), Math.log10(max), len0));
    }

    public static QDataSet logspace(Object omin, Object omax, int len0) {
        QDataSet dsmin = Ops.dataset(omin);
        QDataSet dsmax = Ops.dataset(omax);
        Units u = SemanticOps.getUnits(dsmin);
        double min = dsmin.value();
        double max = Ops.convertUnitsTo(dsmax, u).value();
        QDataSet result = Ops.pow((Object)10, (Object)Ops.linspace(Math.log10(min), Math.log10(max), len0));
        return Ops.putProperty(result, "UNITS", (Object)u);
    }

    public static WritableDataSet replicate(short val, int len0) {
        int size = len0;
        short[] back = new short[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return SDataSet.wrap(back, 1, len0, 1, 1, 1);
    }

    public static WritableDataSet replicate(short val, int len0, int len1) {
        int size = len0 * len1;
        short[] back = new short[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return SDataSet.wrap(back, 2, len0, len1, 1, 1);
    }

    public static WritableDataSet replicate(short val, int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        short[] back = new short[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return SDataSet.wrap(back, 3, len0, len1, len2, 1);
    }

    public static WritableDataSet replicate(int val, int len0) {
        int size = len0;
        int[] back = new int[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return IDataSet.wrap(back, 1, len0, 1, 1, 1);
    }

    public static WritableDataSet replicate(int val, int len0, int len1) {
        int size = len0 * len1;
        int[] back = new int[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return IDataSet.wrap(back, 2, len0, len1, 1, 1);
    }

    public static WritableDataSet replicate(int val, int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        int[] back = new int[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return IDataSet.wrap(back, 3, len0, len1, len2, 1);
    }

    public static WritableDataSet replicate(long val, int len0) {
        int size = len0;
        long[] back = new long[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return LDataSet.wrap(back, 1, len0, 1, 1, 1);
    }

    public static WritableDataSet replicate(long val, int len0, int len1) {
        int size = len0 * len1;
        long[] back = new long[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return LDataSet.wrap(back, 2, len0, len1, 1, 1);
    }

    public static WritableDataSet replicate(long val, int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        long[] back = new long[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return LDataSet.wrap(back, 3, len0, len1, len2, 1);
    }

    public static WritableDataSet replicate(double val, int len0) {
        int size = len0;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return DDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static WritableDataSet replicate(double val, int len0, int len1) {
        int size = len0 * len1;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return DDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static WritableDataSet replicate(double val, int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return DDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static WritableDataSet replicate(double val, int len0, int len1, int len2, int len3) {
        int size = len0 * len1 * len2 * len3;
        double[] back = new double[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return DDataSet.wrap(back, 4, len0, len1, len2, len3);
    }

    public static WritableDataSet replicate(float val, int len0) {
        int size = len0;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return FDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static WritableDataSet replicate(float val, int len0, int len1) {
        int size = len0 * len1;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return FDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static WritableDataSet replicate(float val, int len0, int len1, int len2) {
        int size = len0 * len1 * len2;
        float[] back = new float[size];
        for (int i = 0; i < size; ++i) {
            back[i] = val;
        }
        return FDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static MutablePropertyDataSet replicate(QDataSet val, int len0) {
        return new ReplicateDataSet(val, len0);
    }

    public static MutablePropertyDataSet replicate(QDataSet val, int len0, int len1) {
        return new ReplicateDataSet(new ReplicateDataSet(val, len1), len0);
    }

    public static WritableDataSet zeros(int len0) {
        return Ops.replicate(0.0, len0);
    }

    public static WritableDataSet zeros(int len0, int len1) {
        return Ops.replicate(0.0, len0, len1);
    }

    public static WritableDataSet zeros(int len0, int len1, int len2) {
        return Ops.replicate(0.0, len0, len1, len2);
    }

    public static WritableDataSet zeros(int len0, int len1, int len2, int len3) {
        return Ops.replicate(0.0, len0, len1, len2, len3);
    }

    public static WritableDataSet zeros(QDataSet ds) {
        return DDataSet.create(DataSetUtil.qubeDims(ds));
    }

    public static QDataSet ones(int len0) {
        return Ops.replicate(1.0, len0);
    }

    public static QDataSet ones(final int len0, final int len1) {
        boolean returnMutableCopy = true;
        if (returnMutableCopy) {
            return Ops.replicate(1.0, len0, len1);
        }
        return new AbstractDataSet(){

            @Override
            public int rank() {
                return 2;
            }

            @Override
            public int length() {
                return len0;
            }

            @Override
            public int length(int i0) {
                return len1;
            }

            @Override
            public double value(int i0, int i1) {
                return 1.0;
            }
        };
    }

    public static QDataSet ones(int len0, int len1, int len2) {
        return Ops.replicate(1.0, len0, len1, len2);
    }

    public static QDataSet ones(int len0, int len1, int len2, int len3) {
        return Ops.replicate(1.0, len0, len1, len2, len3);
    }

    public static QDataSet concatenate(QDataSet ds1, QDataSet ds2) {
        return Ops.append(ds1, ds2);
    }

    public static QDataSet concatenate(Object ds1, Object ds2) {
        return Ops.append(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    private static QDataSet randu(int[] qube, Random rand) {
        DDataSet result = DDataSet.create(qube);
        QubeDataSetIterator it = new QubeDataSetIterator(result);
        while (it.hasNext()) {
            it.next();
            it.putValue(result, rand.nextDouble());
        }
        return result;
    }

    private static QDataSet randn(int[] qube, Random rand) {
        DDataSet result = DDataSet.create(qube);
        QubeDataSetIterator it = new QubeDataSetIterator(result);
        while (it.hasNext()) {
            it.next();
            it.putValue(result, rand.nextGaussian());
        }
        return result;
    }

    public static QDataSet rand() {
        return Ops.randu();
    }

    public static QDataSet rand(int len0) {
        return Ops.randu(len0);
    }

    public static QDataSet rand(int len0, int len1) {
        return Ops.randu(len0, len1);
    }

    public static QDataSet rand(int len0, int len1, int len2) {
        return Ops.randu(len0, len1, len2);
    }

    public static QDataSet randu() {
        return Ops.randu(new int[0], random);
    }

    public static QDataSet randu(int len0) {
        return Ops.randu(new int[]{len0}, random);
    }

    public static QDataSet randu(int len0, int len1) {
        return Ops.randu(new int[]{len0, len1}, random);
    }

    public static QDataSet randu(int len0, int len1, int len2) {
        return Ops.randu(new int[]{len0, len1, len2}, random);
    }

    public static QDataSet randu(int len0, int len1, int len2, int len3) {
        return Ops.randu(new int[]{len0, len1, len2, len3}, random);
    }

    public static QDataSet randn() {
        return Ops.randn(new int[0], random);
    }

    public static QDataSet randn(int len0) {
        return Ops.randn(new int[]{len0}, random);
    }

    public static QDataSet randn(int len0, int len1) {
        return Ops.randn(new int[]{len0, len1}, random);
    }

    public static QDataSet randn(int len0, int len1, int len2) {
        return Ops.randn(new int[]{len0, len1, len2}, random);
    }

    public static QDataSet randn(int len0, int len1, int len2, int len3) {
        return Ops.randn(new int[]{len0, len1, len2, len3}, random);
    }

    public static long randomSeed() {
        long seed;
        try {
            seed = SecureRandom.getInstance("SHA1PRNG").nextLong();
        }
        catch (NoSuchAlgorithmException ex) {
            seed = 0L;
        }
        random = new Random(seed);
        return seed;
    }

    public static long randomSeed(long seed) {
        random = new Random(seed);
        return seed;
    }

    public static QDataSet randomn(long seed) {
        double[] back = Ops.randomnBack(seed, 1);
        return DDataSet.wrap(back, 0, 1, 1, 1);
    }

    public static QDataSet randomn(long seed, int len0) {
        double[] back = Ops.randomnBack(seed, len0);
        return DDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static QDataSet randomn(long seed, int len0, int len1) {
        double[] back = Ops.randomnBack(seed, len0 * len1);
        return DDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static QDataSet randomn(long seed, int len0, int len1, int len2) {
        double[] back = Ops.randomnBack(seed, len0 * len1 * len2);
        return DDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static QDataSet randomn(long seed, int len0, int len1, int len2, int len3) {
        double[] back = Ops.randomnBack(seed, len0 * len1 * len2);
        return DDataSet.wrap(back, 4, len0, len1, len2, len3);
    }

    private static double[] randomnBack(long seed, int size) {
        double[] back = new double[size];
        Random r = new Random(seed);
        for (int i = 0; i < size; ++i) {
            back[i] = r.nextGaussian();
        }
        return back;
    }

    private static double[] randomuBack(long seed, int size) {
        double[] back = new double[size];
        Random r = new Random(seed);
        for (int i = 0; i < size; ++i) {
            back[i] = r.nextDouble();
        }
        return back;
    }

    public static QDataSet randomu(long seed) {
        double[] back = Ops.randomuBack(seed, 1);
        return DDataSet.wrap(back, 0, 1, 1, 1);
    }

    public static QDataSet randomu(long seed, int len0) {
        double[] back = Ops.randomuBack(seed, len0);
        return DDataSet.wrap(back, 1, len0, 1, 1);
    }

    public static QDataSet randomu(long seed, int len0, int len1) {
        double[] back = Ops.randomuBack(seed, len0 * len1);
        return DDataSet.wrap(back, 2, len0, len1, 1);
    }

    public static QDataSet randomu(long seed, int len0, int len1, int len2) {
        double[] back = Ops.randomuBack(seed, len0 * len1 * len2);
        return DDataSet.wrap(back, 3, len0, len1, len2);
    }

    public static QDataSet randomu(long seed, int len0, int len1, int len2, int len3) {
        double[] back = Ops.randomuBack(seed, len0 * len1 * len2);
        return DDataSet.wrap(back, 4, len0, len1, len2, len3);
    }

    public static QDataSet distance(int len0, double c0, double r0) {
        DDataSet result = DDataSet.createRank1(len0);
        for (int i = 0; i < len0; ++i) {
            double r = Math.abs((double)i - c0) / r0;
            result.putValue(i, r);
        }
        return result;
    }

    public static QDataSet distance(int len0, int len1, double c0, double c1, double r0, double r1) {
        DDataSet result = DDataSet.createRank2(len0, len1);
        for (int i = 0; i < len0; ++i) {
            for (int j = 0; j < len1; ++j) {
                double r = Math.sqrt(Math.pow(((double)i - c0) / r0, 2.0) + Math.pow(((double)j - c1) / r1, 2.0));
                result.putValue(i, j, r);
            }
        }
        return result;
    }

    public static QDataSet ripples(int len0) {
        return new RipplesDataSet(len0);
    }

    public static QDataSet ripples(int len0, int len1) {
        return new RipplesDataSet(len0, len1);
    }

    public static QDataSet ripples(int len0, int len1, int len2) {
        FDataSet result = FDataSet.createRank3(len0, len1, len2);
        for (int i = 0; i < len0; ++i) {
            double eps = 1.0f + (float)i / (float)len0;
            double eps2 = 1.0f + (float)(i * 5) / (float)len0;
            RipplesDataSet d2 = new RipplesDataSet((double)len1 * eps / 10.0, (double)len2 / 10.0, (double)len2 * eps2 / 20.0, (double)len1 * eps / 2.0, (double)len2 / 2.0, (double)len2 * eps / 10.0, len1, len2);
            QubeDataSetIterator it = new QubeDataSetIterator(d2);
            while (it.hasNext()) {
                it.next();
                result.putValue(i, it.index(0), it.index(1), it.getValue(d2));
            }
            if (i != 0) continue;
            result.putProperty("FILL_VALUE", d2.property("FILL_VALUE"));
        }
        return result;
    }

    public static QDataSet ripples(int len0, int len1, int len2, int len3) {
        FDataSet result = FDataSet.createRank4(len0, len1, len2, len3);
        Random r = new Random(0L);
        for (int j = 0; j < len3; ++j) {
            double d = r.nextDouble();
            for (int i = 0; i < len0; ++i) {
                double eps = 1.0f + (float)i / (float)len0;
                double eps2 = 1.0f + (float)(i * 5) / (float)len0;
                RipplesDataSet d2 = new RipplesDataSet((double)len1 * eps / 10.0, (double)len2 / 10.0, (double)len2 * eps2 / 20.0, (double)len1 * eps / 2.0, (double)len2 / 2.0, (double)len2 * eps / 10.0, len1, len2);
                QubeDataSetIterator it = new QubeDataSetIterator(d2);
                while (it.hasNext()) {
                    it.next();
                    result.putValue(i, it.index(0), it.index(1), j, it.getValue(d2) + d);
                }
                if (i != 0) continue;
                result.putProperty("FILL_VALUE", d2.property("FILL_VALUE"));
            }
        }
        return result;
    }

    public static QDataSet ripplesTimeSeries(int len) {
        QDataSet rip = Ops.ripples(len, 100);
        ArrayDataSet result = ArrayDataSet.copy(DataSetOps.slice1(rip, 20));
        try {
            MutablePropertyDataSet t = (MutablePropertyDataSet)Ops.timegen("2011-10-24", String.format(Locale.US, "%f sec", 86400.0 / (double)len), len);
            t.putProperty("NAME", "Epoch");
            result.putProperty("DEPEND_0", t);
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet ripplesWaveformTimeSeries(int len) {
        MutablePropertyDataSet rip = (MutablePropertyDataSet)Ops.multiply(Ops.add(Ops.ripples(len, 512), Ops.sin(Ops.divide(Ops.findgen(len, 512), DataSetUtil.asDataSet(10.0)))), DataSetUtil.asDataSet(5000.0));
        MutablePropertyDataSet toffset = Ops.taggen(0.0, 1.953125E-4, 512, Units.seconds);
        toffset.putProperty("UNITS", Units.seconds);
        rip.putProperty("DEPEND_1", toffset);
        try {
            QDataSet ttag = Ops.timegen("2012-10-02T12:03", "0.1 s", len);
            rip.putProperty("DEPEND_0", ttag);
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return rip;
    }

    public static QDataSet ripplesVectorTimeSeries(int len) {
        QDataSet rip = Ops.ripples(len, 100);
        ArrayDataSet x = ArrayDataSet.copy(DataSetOps.slice1(rip, 20));
        ArrayDataSet y = ArrayDataSet.copy(DataSetOps.slice1(rip, 30));
        ArrayDataSet z = ArrayDataSet.copy(DataSetOps.slice1(rip, 40));
        x.putProperty("NAME", "X");
        y.putProperty("NAME", "Y");
        z.putProperty("NAME", "Z");
        MutablePropertyDataSet result = (MutablePropertyDataSet)Ops.bundle(x, y, z);
        try {
            MutablePropertyDataSet t = (MutablePropertyDataSet)Ops.timegen("2011-10-24", String.format(Locale.US, "%f sec", 86400.0 / (double)len), len);
            t.putProperty("NAME", "Epoch");
            result.putProperty("DEPEND_0", t);
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet ripplesSpectrogramTimeSeries(int len) {
        QDataSet rip = Ops.ripples(len, 100);
        ArrayDataSet result = ArrayDataSet.copy(DataSetOps.leafTrim(rip, 0, 27));
        result.putProperty("NAME", "Flux");
        MutablePropertyDataSet y = DataSetOps.makePropertiesMutable(Ops.pow(DataSetUtil.asDataSet(10.0), Ops.linspace(1.0, 4.0, 27)));
        y.putProperty("LABEL", "Energy");
        y.putProperty("NAME", "Energy");
        result.putProperty("DEPEND_1", y);
        try {
            MutablePropertyDataSet t = (MutablePropertyDataSet)Ops.timegen("2011-10-24", String.format(Locale.US, "%f sec", 86400.0 / (double)len), len);
            t.putProperty("NAME", "Epoch");
            result.putProperty("DEPEND_0", t);
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet ripplesJoinSpectrogramTimeSeries(int len) {
        int len3 = len / 3;
        try {
            QDataSet rip = Ops.ripples(len3, 100);
            ArrayDataSet result = ArrayDataSet.copy(DataSetOps.leafTrim(rip, 0, 27));
            result.putProperty("NAME", "Flux");
            MutablePropertyDataSet y = DataSetOps.makePropertiesMutable(Ops.pow(DataSetUtil.asDataSet(10.0), Ops.linspace(1.0, 4.0, 27)));
            y.putProperty("LABEL", "Energy");
            y.putProperty("NAME", "Energy");
            result.putProperty("DEPEND_1", y);
            MutablePropertyDataSet t = (MutablePropertyDataSet)Ops.timegen("2011-10-24", String.format(Locale.US, "%f sec", 86400.0 / (double)len3), len3);
            t.putProperty("NAME", "Epoch");
            result.putProperty("DEPEND_0", t);
            JoinDataSet jds = new JoinDataSet(result);
            rip = Ops.ripples(len3, 20);
            result = ArrayDataSet.copy(DataSetOps.leafTrim(rip, 0, 20));
            result.putProperty("NAME", "Flux");
            y = DataSetOps.makePropertiesMutable(Ops.pow(DataSetUtil.asDataSet(10.0), Ops.linspace(3.1, 8.1, 20)));
            y.putProperty("LABEL", "Energy");
            y.putProperty("NAME", "Energy");
            result.putProperty("DEPEND_1", y);
            t = (MutablePropertyDataSet)Ops.timegen("2011-10-25", String.format(Locale.US, "%f sec", 86400.0 / (double)len3), len3);
            t.putProperty("NAME", "Epoch");
            result.putProperty("DEPEND_0", t);
            jds.join(result);
            int lenr = len - 2 * len3;
            rip = Ops.ripples(lenr, 50);
            result = ArrayDataSet.copy(DataSetOps.leafTrim(rip, 0, 24));
            result.putProperty("NAME", "Flux");
            y = DataSetOps.makePropertiesMutable(Ops.pow(DataSetUtil.asDataSet(10.0), Ops.linspace(2.1, 5.1, 24)));
            y.putProperty("LABEL", "Energy");
            y.putProperty("NAME", "Energy");
            result.putProperty("DEPEND_1", y);
            t = (MutablePropertyDataSet)Ops.timegen("2011-10-26", String.format(Locale.US, "%f sec", 86400.0 / (double)lenr), lenr);
            t.putProperty("NAME", "Epoch");
            result.putProperty("DEPEND_0", t);
            jds.join(result);
            return jds;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet ripplesPitchAngleDistribution() {
        ArrayDataSet rip = ArrayDataSet.maybeCopy(Ops.ripples(30, 15));
        QDataSet angle = Ops.linspace(0.05235987755982988, 3.0892327760299634, 30);
        QDataSet rad = Ops.linspace(1.0, 5.0, 15);
        rip.putProperty("DEPEND_0", angle);
        rip.putProperty("DEPEND_1", rad);
        rip.putProperty("RENDER_TYPE", "pitchAngleDistribution");
        return rip;
    }

    public static QDataSet sawtooth(QDataSet t) {
        QDataSet modt = Ops.divide((Object)Ops.modp(t, DataSetUtil.asDataSet(Math.PI * 2)), Math.PI * 2);
        return Ops.link(t, modt);
    }

    public static QDataSet square(QDataSet t) {
        QDataSet modt = Ops.lt((Object)Ops.modp(t, DataSetUtil.asDataSet(Math.PI * 2)), Math.PI);
        return Ops.link(t, modt);
    }

    public static QDataSet appendEvents(QDataSet ev1, QDataSet ev2) {
        QDataSet result = ev1;
        for (int i = 0; i < ev2.length(); ++i) {
            String sval = ev2.slice(i).slice(3).toString();
            int k = sval.indexOf("=");
            sval = sval.substring(k + 1);
            result = Ops.createEvent(result, DataSetUtil.asDatumRange(ev2.slice(i).trim(0, 2)), (int)ev2.value(i, 2), sval);
        }
        return result;
    }

    public static QDataSet createEvent(String timeRange, int rgbcolor, String annotation) {
        return Ops.createEvent(null, timeRange, rgbcolor, annotation);
    }

    public static QDataSet createEvent(QDataSet append, String timeRange, int rgbcolor, String annotation) {
        try {
            DatumRange dr = DatumRangeUtil.parseTimeRangeValid((String)timeRange);
            return Ops.createEvent(append, dr, rgbcolor, annotation);
        }
        catch (IllegalArgumentException ex) {
            Pattern p = Pattern.compile("(\\d+)-(\\d+)|(\\d{4}).*through.*(\\d{4})");
            Matcher m = p.matcher(timeRange);
            if (m.matches()) {
                int d2;
                int d1;
                if (m.group(1) != null) {
                    d1 = Integer.parseInt(m.group(1));
                    d2 = Integer.parseInt(m.group(2));
                } else {
                    d1 = Integer.parseInt(m.group(3));
                    d2 = Integer.parseInt(m.group(4));
                }
                if (d1 <= d2) {
                    DatumRange dr = DatumRange.newRange((double)d1, (double)d2);
                    return Ops.createEvent(append, dr, rgbcolor, annotation);
                }
                throw ex;
            }
            throw ex;
        }
    }

    public static QDataSet createEvent(DatumRange dr, int rgbcolor, String annotation) {
        return Ops.createEvent(null, dr, rgbcolor, annotation);
    }

    public static QDataSet createEvent(QDataSet append, DatumRange dr, int rgbcolor, String annotation) {
        Units tu;
        EnumerationUnits evu;
        MutablePropertyDataSet bds = null;
        if (append != null) {
            bds = (MutablePropertyDataSet)append.property("BUNDLE_1");
            if (bds == null) {
                throw new IllegalArgumentException("append argument must be the output of createEvent");
            }
            evu = (EnumerationUnits)bds.property("UNITS", 3);
            tu = (Units)bds.property("UNITS", 0);
            if (bds.property("UNITS", 1) != tu) {
                throw new IllegalArgumentException("first two columns must be time locations");
            }
        } else {
            evu = EnumerationUnits.create((Object)"createEvent");
            tu = dr.getUnits();
        }
        DataSetBuilder dsb = new DataSetBuilder(2, 100, 4);
        dsb.putValue(-1, 0, dr.min().doubleValue(tu));
        dsb.putValue(-1, 1, dr.max().doubleValue(tu));
        dsb.putValue(-1, 2, rgbcolor);
        dsb.putValue(-1, 3, evu.createDatum((Object)annotation).doubleValue((Units)evu));
        dsb.nextRecord();
        DDataSet ds = dsb.getDataSet();
        if (bds == null) {
            bds = DDataSet.createRank2(4, 0);
            bds.putProperty("NAME__0", "Time");
            bds.putProperty("UNITS__0", tu);
            bds.putProperty("NAME__1", "StopTime");
            bds.putProperty("UNITS__1", tu);
            bds.putProperty("NAME__2", "Color");
            bds.putProperty("FORMAT__2", "0x%06x");
            bds.putProperty("NAME__3", "Event");
            bds.putProperty("UNITS__3", evu);
        }
        ds.putProperty("BUNDLE_1", bds);
        append = Ops.append(append, ds);
        ((MutablePropertyDataSet)append).putProperty("RENDER_TYPE", "eventsBar");
        return append;
    }

    public static QDataSet createEvents(QDataSet vds) {
        return Ops.createEvents(vds, Color.GRAY);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QDataSet createEvents(QDataSet vds, Color deftColor) {
        void var3_22;
        void var3_18;
        QDataSet msgs;
        QDataSet colors;
        QDataSet xmins;
        if (vds == null) {
            return null;
        }
        int defaultColor = deftColor.getRGB();
        switch (vds.rank()) {
            case 2: {
                Datum width;
                Units u0;
                QDataSet dep0 = (QDataSet)vds.property("DEPEND_0");
                if (dep0 == null) {
                    xmins = DataSetOps.unbundle(vds, 0);
                    QDataSet qDataSet = DataSetOps.unbundle(vds, 1);
                    colors = vds.length(0) > 3 ? DataSetOps.unbundle(vds, 2) : Ops.replicate(defaultColor, xmins.length());
                } else if (dep0.rank() == 2) {
                    if (!SemanticOps.isBins(dep0)) throw new IllegalArgumentException("DEPEND_0 is rank 2 but not bins");
                    xmins = DataSetOps.slice1(dep0, 0);
                    MutablePropertyDataSet mutablePropertyDataSet = DataSetOps.slice1(dep0, 1);
                    colors = Ops.replicate(0x808080, xmins.length());
                    u0 = SemanticOps.getUnits(xmins);
                    Units u1 = SemanticOps.getUnits(mutablePropertyDataSet);
                    if (!u1.isConvertibleTo(u0) && u1.isConvertibleTo(u0.getOffsetUnits())) {
                        QDataSet qDataSet = Ops.add(xmins, mutablePropertyDataSet);
                    }
                } else {
                    if (dep0.rank() != 1) throw new IllegalArgumentException("rank 2 dataset must have dep0 of rank 1 or rank 2 bins");
                    width = SemanticOps.guessXTagWidth(dep0, null).divide(2.0);
                    xmins = Ops.subtract(dep0, DataSetUtil.asDataSet(width));
                    QDataSet qDataSet = Ops.add(dep0, DataSetUtil.asDataSet(width));
                    colors = Ops.replicate(defaultColor, xmins.length());
                }
                if (vds.length(0) == 2) {
                    msgs = Ops.replicate(Ops.dataset(EnumerationUnits.create((Object)"default").createDatum((Object)"_")), vds.length());
                    break;
                }
                msgs = DataSetOps.unbundle(vds, vds.length(0) - 1);
                break;
            }
            case 1: {
                Datum width;
                Units u0;
                QDataSet dep0 = (QDataSet)vds.property("DEPEND_0");
                if (dep0 == null && UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits(vds))) {
                    dep0 = vds;
                }
                if (dep0 == null) {
                    throw new IllegalArgumentException("cannot make events data set from this rank 1 dataset with no timetags.");
                }
                if (dep0.rank() == 2) {
                    if (!SemanticOps.isBins(dep0)) throw new IllegalArgumentException("DEPEND_0 is rank 2 but not bins");
                    xmins = DataSetOps.slice1(dep0, 0);
                    MutablePropertyDataSet mutablePropertyDataSet = DataSetOps.slice1(dep0, 1);
                    u0 = SemanticOps.getUnits(xmins);
                    Units u1 = SemanticOps.getUnits(mutablePropertyDataSet);
                    if (!u1.isConvertibleTo(u0) && u1.isConvertibleTo(u0.getOffsetUnits())) {
                        QDataSet qDataSet = Ops.add(xmins, mutablePropertyDataSet);
                    }
                    msgs = vds;
                } else if (dep0.rank() == 1 && SemanticOps.isBins(dep0)) {
                    xmins = Ops.replicate(DataSetOps.slice0(dep0, 0), 1);
                    MutablePropertyDataSet mutablePropertyDataSet = Ops.replicate(DataSetOps.slice0(dep0, 1), 1);
                    msgs = Ops.replicate(Ops.dataset(EnumerationUnits.create((Object)"default").createDatum((Object)"_")), 1);
                } else {
                    if (dep0.rank() != 1) throw new IllegalArgumentException("dataset is not correct form");
                    width = SemanticOps.guessXTagWidth(dep0, null);
                    if (width != null) {
                        width = width.divide(2.0);
                    } else {
                        QDataSet sort = Ops.sort(dep0);
                        QDataSet diffs = Ops.diff(DataSetOps.applyIndex(dep0, 0, sort, false));
                        QDataSet w = Ops.reduceMin(diffs, 0);
                        width = DataSetUtil.asDatum(w);
                    }
                    xmins = Ops.subtract(dep0, DataSetUtil.asDataSet(width));
                    QDataSet qDataSet = Ops.add(dep0, DataSetUtil.asDataSet(width));
                    msgs = vds == dep0 ? Ops.replicate(Ops.dataset(EnumerationUnits.create((Object)"default").createDatum((Object)"_")), vds.length()) : vds;
                }
                Color c0 = new Color(defaultColor);
                Color c1 = new Color(c0.getRed(), c0.getGreen(), c0.getBlue(), c0.getAlpha() == 255 ? 128 : c0.getAlpha());
                int irgb = c1.getRGB();
                colors = Ops.replicate(irgb, xmins.length());
                break;
            }
            case 0: {
                xmins = Ops.replicate(vds, 1);
                MutablePropertyDataSet mutablePropertyDataSet = xmins;
                Color c0 = new Color(defaultColor);
                Color c1 = new Color(c0.getRed(), c0.getGreen(), c0.getBlue(), c0.getAlpha() == 255 ? 128 : c0.getAlpha());
                int irgb = c1.getRGB();
                colors = Ops.replicate(irgb, xmins.length());
                msgs = Ops.replicate(vds, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("dataset must be rank 0, 1 or 2");
            }
        }
        Units u0 = SemanticOps.getUnits(xmins);
        Units u1 = SemanticOps.getUnits((QDataSet)var3_18);
        if (u1.isConvertibleTo(u0.getOffsetUnits()) && !u1.isConvertibleTo(u0)) {
            QDataSet qDataSet = Ops.add(xmins, (QDataSet)var3_18);
            MutablePropertyDataSet mutablePropertyDataSet2 = Ops.putProperty(qDataSet, "DEPEND_0", null);
            mutablePropertyDataSet2 = Ops.putProperty(mutablePropertyDataSet2, "LABEL", null);
        }
        xmins = Ops.putProperty(xmins, "NAME", (Object)"startTime");
        MutablePropertyDataSet mutablePropertyDataSet = Ops.putProperty((QDataSet)var3_22, "NAME", (Object)"stopTime");
        colors = Ops.putProperty(colors, "NAME", (Object)"color");
        msgs = Ops.putProperty(msgs, "NAME", (Object)"messages");
        colors = Ops.putProperty(colors, "FORMAT", (Object)"0x%08x");
        return Ops.bundle(xmins, mutablePropertyDataSet, colors, msgs);
    }

    public static int[] dataIntersection(int[] itE, int[] itB) {
        QDataSet tE = Ops.dataset(itE);
        QDataSet tB = Ops.dataset(itB);
        QDataSet dsr = Ops.dataIntersection(tE, tB);
        int[] result = new int[dsr.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int)dsr.value(i);
        }
        return result;
    }

    public static QDataSet dataIntersection(QDataSet tE, QDataSet tB) {
        QDataSet lE = Ops.sort(tE);
        QDataSet lB = Ops.sort(tB);
        tE = Ops.applyIndex(tE, lE);
        tB = Ops.applyIndex(tB, lB);
        int iE = 0;
        int iB = 0;
        DataSetBuilder dsb = new DataSetBuilder(1, 100);
        while (iE < tE.length() && iB < tB.length()) {
            double b;
            double e = tE.value(iE);
            if (e == (b = tB.value(iB))) {
                dsb.nextRecord(e);
                ++iE;
                ++iB;
                continue;
            }
            if (e > b) {
                ++iB;
                continue;
            }
            if (!(e < b)) continue;
            ++iE;
        }
        dsb.putProperty("UNITS", tE.property("UNITS"));
        return dsb.getDataSet();
    }

    public static QDataSet dataGroupDifference(QDataSet tE, QDataSet tB) {
        QDataSet lE = Ops.sort(tE);
        QDataSet lB = Ops.sort(tB);
        tE = Ops.applyIndex(tE, lE);
        tB = Ops.applyIndex(tB, lB);
        int iE = 0;
        int iB = 0;
        DataSetBuilder dsb = new DataSetBuilder(1, 100);
        while (iE < tE.length() && iB < tB.length()) {
            double b;
            double e = tE.value(iE);
            if (e == (b = tB.value(iB))) {
                ++iE;
                ++iB;
                continue;
            }
            if (e > b) {
                ++iB;
                continue;
            }
            if (!(e < b)) continue;
            dsb.nextRecord(e);
            ++iE;
        }
        dsb.putProperty("UNITS", tE.property("UNITS"));
        return dsb.getDataSet();
    }

    public static QDataSet eventsDiff(QDataSet tE, QDataSet tB) {
        int iE = 0;
        int iB = 0;
        QDataSet tE4 = Ops.createEvents(tE);
        tB = Ops.createEvents(tB);
        tE = Ops.trim1(tE4, 0, 2);
        Units tu = (Units)tE.slice(0).slice(0).property("UNITS");
        tB = Ops.trim1(tB, 0, 2);
        Units bu = (Units)tB.slice(0).slice(0).property("UNITS");
        tB = Ops.putProperty(tB, "UNITS", (Object)bu);
        tB = Ops.convertUnitsTo(tB, tu);
        DataSetBuilder dsb = new DataSetBuilder(2, 100, 4);
        EnumerationUnits eu = (EnumerationUnits)((QDataSet)tE4.property("BUNDLE_1")).property("UNITS", 3);
        dsb.setUnits(3, (Units)eu);
        while (iE < tE.length() || iB < tB.length()) {
            if (iE == tE.length()) {
                logger.log(Level.FINE, "eventsDiff xxx {0}", tB.slice(iB).slice(0).svalue());
            } else if (iB == tB.length()) {
                logger.log(Level.FINE, "eventsDiff {0} xxx", tE.slice(iE).slice(0).svalue());
            } else {
                logger.log(Level.FINE, "eventsDiff {0} {1}", new Object[]{tE.slice(iE).slice(0).svalue(), tB.slice(iB).slice(0).svalue()});
            }
            if (iE == tE.length()) {
                dsb.nextRecord(tB.value(iB, 0), tB.value(iB, 1), 0xA0F0A0, "insert " + tB.slice(iB).slice(3).svalue());
                ++iB;
                continue;
            }
            if (iB == tB.length()) {
                dsb.nextRecord(tE.value(iE, 0), tE.value(iE, 1), 0xF0A0A0, "delete " + tE.slice(iE).slice(3).svalue());
                ++iE;
                continue;
            }
            if (tE.value(iE, 0) > tB.value(iB, 0)) {
                dsb.nextRecord(tB.value(iB, 0), tB.value(iB, 1), 0xA0F0A0, "insert " + tB.slice(iB).slice(3).svalue());
                ++iB;
                continue;
            }
            if (tE.value(iE, 0) < tB.value(iB, 0)) {
                dsb.nextRecord(tE.value(iE, 0), tE.value(iE, 1), 0xF0A0A0, "delete " + tE.slice(iE).slice(3).svalue());
                ++iE;
                continue;
            }
            if (!tE.slice(iE).slice(3).svalue().equals(tB.slice(iB).slice(3).svalue())) {
                String msg = "modify " + tE.slice(iE).slice(3).svalue() + " &rarr; " + tB.slice(iB).slice(3).svalue();
                dsb.nextRecord(tB.value(iB, 0), tB.value(iB, 1), 0xA0A0F0, eu.createDatum((Object)msg));
            }
            ++iB;
            ++iE;
        }
        dsb.putProperty("BUNDLE_1", tE4.property("BUNDLE_1"));
        return dsb.getDataSet();
    }

    public static QDataSet eventsConjunction(QDataSet tE, QDataSet tB) {
        int iE = 0;
        int iB = 0;
        String state = "open";
        QDataSet start = null;
        QDataSet tE4 = Ops.createEvents(tE);
        tB = Ops.createEvents(tB);
        tE = Ops.trim1(tE4, 0, 2);
        Units tu = (Units)tE.slice(0).slice(0).property("UNITS");
        tB = Ops.trim1(tB, 0, 2);
        Units bu = (Units)tB.slice(0).slice(0).property("UNITS");
        tB = Ops.putProperty(tB, "UNITS", (Object)bu);
        tB = Ops.convertUnitsTo(tB, tu);
        DataSetBuilder dsb = new DataSetBuilder(2, 100, 4);
        EnumerationUnits eu = EnumerationUnits.create((Object)"default");
        while (iE < tE.length() && iB < tB.length()) {
            switch (state) {
                case "tE": {
                    if (tE.value(iE, 1) <= tB.value(iB, 0)) {
                        state = "open";
                        ++iE;
                        break;
                    }
                    if (!(tE.value(iE, 1) > tB.value(iB, 0))) break;
                    state = "tEB";
                    start = tB.slice(iB).slice(0);
                    break;
                }
                case "tB": {
                    if (tB.value(iB, 1) <= tE.value(iE, 0)) {
                        state = "open";
                        ++iB;
                        break;
                    }
                    if (!(tB.value(iB, 1) > tE.value(iE, 0))) break;
                    state = "tEB";
                    start = tE.slice(iE).slice(0);
                    break;
                }
                case "tEB": {
                    if (tE.value(iE, 1) <= tB.value(iB, 1)) {
                        state = "tB";
                        dsb.nextRecord(start, tE.slice(iE).slice(1), 0xA0A0A0, eu.createDatum((Object)"x"));
                        start = null;
                        ++iE;
                        break;
                    }
                    if (tB.value(iB, 1) <= tE.value(iE, 1)) {
                        state = "tE";
                        dsb.nextRecord(start, tB.slice(iB).slice(1), 0xA0A0A0, eu.createDatum((Object)"x"));
                        start = null;
                        ++iB;
                        break;
                    }
                    System.err.println("huh");
                    break;
                }
                case "open": {
                    if (tE.value(iE, 0) <= tB.value(iB, 0)) {
                        state = "tE";
                        break;
                    }
                    if (!(tE.value(iE, 0) > tB.value(iB, 0))) break;
                    state = "tB";
                    break;
                }
            }
        }
        dsb.putProperty("BUNDLE_1", tE4.property("BUNDLE_1"));
        DDataSet result = dsb.getDataSet();
        return result;
    }

    public static QDataSet eventsComplement(QDataSet events, DatumRange range, int color, String msg) {
        events = Ops.createEvents(events);
        QDataSet s = Ops.sort(Ops.slice1(events, 0));
        events = Ops.applyIndex(events, s);
        Datum st = range.min();
        QDataSet r = Ops.where(Ops.and(Ops.lt((Object)Ops.slice1(events, 0), range.max()), Ops.gt((Object)Ops.slice1(events, 1), range.min())));
        QDataSet bds = (QDataSet)(events = Ops.applyIndex(events, r)).property("BUNDLE_1");
        Units eu = (Units)bds.property("UNITS", 3);
        Datum dmsg = eu != null && eu instanceof EnumerationUnits ? ((EnumerationUnits)eu).createDatum((Object)msg) : Units.nominal().createDatum((Object)msg);
        DataSetBuilder dsb = new DataSetBuilder(2, 1000, 4);
        dsb.setUnits(0, (Units)bds.property("UNITS", 0));
        dsb.setUnits(1, (Units)bds.property("UNITS", 1));
        dsb.setUnits(2, (Units)bds.property("UNITS", 2));
        dsb.setUnits(3, (Units)bds.property("UNITS", 3));
        for (int i = 0; i < events.length(); ++i) {
            QDataSet e1 = events.slice(i);
            Datum t1 = Ops.datum(e1.slice(0));
            if (t1.gt(st)) {
                dsb.nextRecord(st, t1, color, dmsg);
            }
            st = Ops.datum(e1.slice(1));
        }
        if (st.lt(range.max())) {
            dsb.nextRecord(st, range.max(), color, dmsg);
        }
        return dsb.getDataSet();
    }

    public static QDataSet eventsCoalesce(QDataSet cds) {
        if (cds.rank() != 2) {
            throw new IllegalArgumentException("Expected rank 2 events dataset");
        }
        DataSetBuilder build = new DataSetBuilder(2, cds.length() / 2, cds.length(0));
        build.putProperty("BUNDLE_1", cds.property("BUNDLE_1"));
        WritableDataSet prev = Ops.copy(cds.slice(0));
        for (int i = 1; i < cds.length(); ++i) {
            QDataSet current = cds.slice(i);
            double d = Math.abs((prev.value(1) - current.value(0)) / (prev.value(1) - prev.value(0)));
            if (d < 0.001 && prev.value(3) == current.value(3) && prev.value(2) == current.value(2)) {
                prev.putValue(1, current.value(1));
                continue;
            }
            build.nextRecord(prev);
            prev = Ops.copy(current);
        }
        build.nextRecord(prev);
        return build.getDataSet();
    }

    public static QDataSet circle(QDataSet radius, QDataSet x, QDataSet y) {
        if (radius == null) {
            radius = DataSetUtil.asDataSet(1.0);
        }
        MutablePropertyDataSet result = (MutablePropertyDataSet)Ops.link(Ops.add(x, Ops.multiply(radius, Ops.sin(Ops.linspace(0.0, 6.2936572826915524, 601)))), Ops.add(y, Ops.multiply(radius, Ops.cos(Ops.linspace(0.0, 6.2936572826915524, 601)))));
        result.putProperty("RENDER_TYPE", "series");
        return result;
    }

    public static QDataSet circle(double radius, double x, double y) {
        return Ops.circle(Ops.dataset(radius), Ops.dataset(x), Ops.dataset(y));
    }

    public static QDataSet circle(QDataSet radius) {
        if (radius == null) {
            radius = DataSetUtil.asDataSet(1.0);
        }
        MutablePropertyDataSet result = (MutablePropertyDataSet)Ops.link(Ops.multiply(radius, Ops.sin(Ops.linspace(0.0, 6.2936572826915524, 601))), Ops.multiply(radius, Ops.cos(Ops.linspace(0.0, 6.2936572826915524, 601))));
        result.putProperty("RENDER_TYPE", "series");
        return result;
    }

    public static QDataSet circle(double dradius) {
        DRank0DataSet radius = DataSetUtil.asDataSet(dradius);
        return Ops.circle(radius);
    }

    public static QDataSet circle(String sradius) throws ParseException {
        DRank0DataSet radius;
        if (sradius == null) {
            radius = DataSetUtil.asDataSet(1.0);
        } else {
            Datum d;
            try {
                d = DatumUtil.parse((String)sradius);
            }
            catch (ParseException ex) {
                String[] ss = sradius.split(" ", 2);
                if (ss.length == 2) {
                    Units u = Units.lookupUnits((String)ss[1]);
                    d = u.parse(ss[0]);
                }
                throw new IllegalArgumentException("unable to parse: " + sradius);
            }
            radius = DataSetUtil.asDataSet(d);
        }
        return Ops.circle(radius);
    }

    public static QDataSet ellipse(double xwidth, double ywidth) {
        MutablePropertyDataSet result = (MutablePropertyDataSet)Ops.link(Ops.multiply(xwidth, (Object)Ops.sin(Ops.linspace(0.0, 6.2936572826915524, 601))), Ops.multiply(ywidth, (Object)Ops.cos(Ops.linspace(0.0, 6.2936572826915524, 601))));
        result.putProperty("RENDER_TYPE", "series");
        return result;
    }

    public static Map<String, Object> copyProperties(QDataSet ds) {
        QDataSet plane0;
        int i;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> srcProps = DataSetUtil.getProperties(ds);
        if (ds.rank() == 2) {
            boolean isBundle = false;
            String n = (String)ds.property("NAME");
            if (n == null && ds.length() > 0) {
                n = (String)ds.property("NAME", 0);
            }
            for (int i2 = 0; i2 < ds.length(); ++i2) {
                if (n == ds.property("NAME", i2)) continue;
                isBundle = true;
                break;
            }
            if (isBundle) {
                String[] nn = new String[]{"NAME", "UNITS", "LABEL"};
                for (int i3 = 0; i3 < ds.length(); ++i3) {
                    for (String nn1 : nn) {
                        Object val = ds.property(nn1, i3);
                        if (val == null) continue;
                        result.put(nn1 + "__" + i3, val);
                    }
                }
            }
        }
        result.putAll(srcProps);
        for (i = 0; i < ds.rank(); ++i) {
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
            if (dep == ds) {
                throw new IllegalArgumentException("dataset is dependent on itsself!");
            }
            if (dep == null) continue;
            result.put("DEPEND_" + i, Ops.copy(dep));
        }
        for (i = 0; i < 50 && (plane0 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            result.put("PLANE_" + i, Ops.copy(plane0));
        }
        return result;
    }

    public static void copyIndexedProperties(QDataSet srcds, MutablePropertyDataSet mds) {
        String[] moreNames;
        String[] names;
        for (String name : names = DataSetUtil.propertyNames()) {
            for (int i = 0; i < srcds.length(); ++i) {
                Object p = srcds.property(name, i);
                if (p == null) continue;
                mds.putProperty(name, i, p);
            }
        }
        for (String name : moreNames = new String[]{"DEPENDNAME_0", "DEPENDNAME_1", "CONTEXT_0", "CONTEXT_1"}) {
            for (int i = 0; i < srcds.length(); ++i) {
                Object p = srcds.property(name, i);
                if (p == null) continue;
                mds.putProperty(name, i, p);
            }
        }
    }

    public static WritableDataSet copy(QDataSet src) {
        logger.log(Level.FINE, "copy({0})", src);
        if (SemanticOps.isJoin(src) || !DataSetUtil.isQube(src)) {
            return WritableJoinDataSet.copy(src);
        }
        if (src instanceof BufferDataSet) {
            return BufferDataSet.copy(src);
        }
        return ArrayDataSet.copy(src);
    }

    public static WritableDataSet maybeCopy(QDataSet ads0) {
        if (ads0 instanceof BufferDataSet) {
            return BufferDataSet.maybeCopy(ads0);
        }
        return ArrayDataSet.maybeCopy(ads0);
    }

    public static QDataSet sortInTime(QDataSet ds) {
        QDataSet t = (QDataSet)ds.property("DEPEND_0");
        if (t == null) {
            throw new IllegalArgumentException("data does not contain DEPEND_0");
        }
        QDataSet s = Ops.sort(t);
        return Ops.applyIndex(ds, s);
    }

    public static MutablePropertyDataSet monotonicSubset(QDataSet ds) {
        QDataSet sdep0;
        AbstractDataSet mds = ds instanceof BufferDataSet ? (BufferDataSet)ds : (ds instanceof ArrayDataSet ? (ArrayDataSet)ds : ArrayDataSet.copy(ds));
        assert (mds instanceof ArrayDataSet || mds instanceof BufferDataSet);
        if (mds.isImmutable()) {
            mds = mds instanceof ArrayDataSet ? ArrayDataSet.copy(mds) : BufferDataSet.copy(mds);
            logger.warning("immutabilty forced copy.");
        }
        if ((sdep0 = (QDataSet)mds.property("DEPEND_0")) == null && UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits(mds))) {
            sdep0 = mds;
        } else if (sdep0 == null) {
            return mds;
        }
        WritableDataSet dep0 = Ops.maybeCopy(sdep0);
        if (dep0.length() < 2) {
            return mds;
        }
        if (dep0.rank() != 1) {
            return mds;
        }
        QDataSet vdep0 = Ops.valid(dep0);
        int[] rback = new int[dep0.length()];
        rback[dep0.length() / 2] = dep0.length() / 2;
        int rindex = dep0.length() / 2 + 1;
        double a = dep0.value(rindex - 1);
        for (int i = rindex; i < dep0.length(); ++i) {
            if (!(vdep0.value(i) > 0.0)) continue;
            double a1 = dep0.value(i);
            if (a1 > a) {
                rback[rindex] = i;
                a = a1;
                ++rindex;
                continue;
            }
            logger.log(Level.FINER, "data point breaks monotonic rule: {0}", i);
        }
        int lindex = dep0.length() / 2;
        a = dep0.value(lindex + 1);
        for (int i = lindex; i >= 0; --i) {
            if (!(vdep0.value(i) > 0.0)) continue;
            double a1 = dep0.value(i);
            if (a1 < a) {
                rback[lindex] = i;
                a = a1;
                --lindex;
                continue;
            }
            logger.log(Level.FINER, "data point breaks monotonic rule: {0}", i);
        }
        int nrm = dep0.length() - (rindex - ++lindex);
        if (nrm > 0) {
            AbstractDataSet dep0copy;
            if (rindex == 1) {
                logger.log(Level.FINE, "ensureMono removes all points, assume it's monotonic decreasing");
                return mds;
            }
            logger.log(Level.FINE, "ensureMono removes {0} points", nrm);
            int[] idx = new int[rindex - lindex];
            System.arraycopy(rback, lindex, idx, 0, rindex - lindex);
            mds.putProperty("DEPEND_0", null);
            if (mds instanceof ArrayDataSet) {
                Class c = ((ArrayDataSet)mds).getComponentType();
                mds = ArrayDataSet.copy(c, new SortDataSet(mds, Ops.dataset(idx)));
                Class depclass = ((ArrayDataSet)dep0).getComponentType();
                dep0copy = ArrayDataSet.copy(depclass, new SortDataSet(dep0, Ops.dataset(idx)));
            } else if (mds instanceof BufferDataSet) {
                Object c = ((BufferDataSet)mds).getType();
                mds = BufferDataSet.copy(c, new SortDataSet(mds, Ops.dataset(idx)));
                Object depclass = ((BufferDataSet)dep0).getType();
                dep0copy = BufferDataSet.copy(depclass, new SortDataSet(dep0, Ops.dataset(idx)));
            } else {
                throw new IllegalArgumentException("dataset must be ArrayDataSet or BufferDataSet");
            }
            dep0copy.putProperty("MONOTONIC", Boolean.TRUE);
            mds.putProperty("DEPEND_0", dep0copy);
        } else {
            dep0.putProperty("MONOTONIC", Boolean.TRUE);
            mds.putProperty("DEPEND_0", dep0);
        }
        return mds;
    }

    public static QDataSet sin(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double d1) -> Math.sin(d1));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "sin"));
        return result;
    }

    public static double sin(double ds) {
        return Math.sin(ds);
    }

    public static QDataSet sin(Object ds) {
        return Ops.sin(Ops.dataset(ds));
    }

    public static QDataSet asin(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double d1) -> Math.asin(d1));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "asin"));
        return result;
    }

    public static double asin(double ds) {
        return Math.asin(ds);
    }

    public static QDataSet asin(Object ds) {
        return Ops.asin(Ops.dataset(ds));
    }

    public static QDataSet cos(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double d1) -> Math.cos(d1));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "cos"));
        return result;
    }

    public static double cos(double ds) {
        return Math.cos(ds);
    }

    public static QDataSet cos(Object ds) {
        return Ops.cos(Ops.dataset(ds));
    }

    public static QDataSet acos(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double d1) -> Math.acos(d1));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "acos"));
        return result;
    }

    public static double acos(double ds) {
        return Math.acos(ds);
    }

    public static QDataSet acos(Object ds) {
        return Ops.acos(Ops.dataset(ds));
    }

    public static QDataSet tan(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double a) -> Math.tan(a));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "tan"));
        return result;
    }

    public static double tan(double ds) {
        return Math.tan(ds);
    }

    public static QDataSet tan(Object ds) {
        return Ops.tan(Ops.dataset(ds));
    }

    public static QDataSet atan(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double a) -> Math.atan(a));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "atan"));
        return result;
    }

    public static double atan(double ds) {
        return Math.atan(ds);
    }

    public static QDataSet atan(Object ds) {
        return Ops.atan(Ops.dataset(ds));
    }

    public static QDataSet atan2(QDataSet y, QDataSet x) {
        MutablePropertyDataSet result = Ops.applyBinaryOp(y, x, (double y1, double x1) -> Math.atan2(y1, x1));
        result.putProperty("LABEL", Ops.maybeLabelBinaryOp(y, x, "atan2"));
        return result;
    }

    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static QDataSet atan2(Object dsy, Object dsx) {
        return Ops.atan2(Ops.dataset(dsy), Ops.dataset(dsx));
    }

    public static QDataSet cosh(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double a) -> Math.cosh(a));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "cosh"));
        return result;
    }

    public static double cosh(double ds) {
        return Math.cosh(ds);
    }

    public static QDataSet cosh(Object ds) {
        return Ops.cosh(Ops.dataset(ds));
    }

    public static QDataSet sinh(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double a) -> Math.sinh(a));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "sinh"));
        return result;
    }

    public static double sinh(double ds) {
        return Math.sinh(ds);
    }

    public static QDataSet sinh(Object ds) {
        return Ops.sinh(Ops.dataset(ds));
    }

    public static QDataSet tanh(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double a) -> Math.tanh(a));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "tanh"));
        return result;
    }

    public static double tanh(double ds) {
        return Math.tanh(ds);
    }

    public static QDataSet tanh(Object ds) {
        return Ops.tanh(Ops.dataset(ds));
    }

    public static QDataSet expm1(QDataSet xx) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(xx, (double a) -> Math.expm1(a));
        result.putProperty("LABEL", Ops.maybeLabelUnaryOp(result, "expm1"));
        return result;
    }

    public static double expm1(double x) {
        return Math.expm1(x);
    }

    public static QDataSet expm1(Object x) {
        return Ops.expm1(Ops.dataset(x));
    }

    public static int[] getQubeDimsForArray(Object arg0) {
        ArrayList<Integer> qqube = new ArrayList<Integer>();
        qqube.add(Array.getLength(arg0));
        if ((Integer)qqube.get(0) > 0) {
            Object slice = Array.get(arg0, 0);
            try {
                while (slice.getClass().isArray()) {
                    qqube.add(Array.getLength(slice));
                    slice = Array.get(slice, 0);
                }
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
                Array.getLength(slice);
            }
        }
        int[] qube = new int[qqube.size()];
        for (int i = 0; i < qube.length; ++i) {
            qube[i] = (Integer)qqube.get(i);
        }
        return qube;
    }

    public static QDataSet dataset(Object arg0) {
        if (arg0 == null) {
            return null;
        }
        if (arg0 instanceof QDataSet) {
            return (QDataSet)arg0;
        }
        if (arg0 instanceof Number) {
            return DataSetUtil.asDataSet(((Number)arg0).doubleValue());
        }
        if (arg0 instanceof Datum) {
            return DataSetUtil.asDataSet((Datum)arg0);
        }
        if (arg0 instanceof DatumVector) {
            return DataSetUtil.asDataSet((DatumVector)arg0);
        }
        if (arg0 instanceof Boolean) {
            return DataSetUtil.asDataSet((Boolean)arg0 != false ? 1.0 : 0.0);
        }
        if (arg0 instanceof DatumRange) {
            return DataSetUtil.asDataSet((DatumRange)arg0);
        }
        if (arg0 instanceof Color) {
            return DataSetUtil.asDataSet(((Color)arg0).getRGB(), Units.rgbColor);
        }
        if (arg0 instanceof String) {
            String sarg = (String)arg0;
            try {
                return DataSetUtil.asDataSet(DatumUtil.parse((String)sarg));
            }
            catch (ParseException ex) {
                try {
                    DatumRange dr = DatumRangeUtil.parseTimeRange((String)sarg);
                    return DataSetUtil.asDataSet(dr);
                }
                catch (ParseException ex2) {
                    try {
                        return DataSetUtil.asDataSet(Units.us2000.parse(sarg));
                    }
                    catch (ParseException ex1) {
                        EnumerationUnits eu = EnumerationUnits.create((Object)"default");
                        Datum d = eu.createDatum((Object)sarg);
                        return DataSetUtil.asDataSet(d);
                    }
                }
            }
        }
        if (arg0 instanceof List) {
            List p = (List)arg0;
            double[] j = new double[p.size()];
            Units u = null;
            for (int i = 0; i < p.size(); ++i) {
                Object n = p.get(i);
                if (n instanceof Number) {
                    j[i] = ((Number)n).doubleValue();
                    continue;
                }
                if (!(n instanceof String)) continue;
                QDataSet ds1 = Ops.dataset(n);
                if (u == null) {
                    u = SemanticOps.getUnits(ds1);
                }
                j[i] = ds1.value();
            }
            DDataSet q = DDataSet.wrap(j);
            if (u != null) {
                q.putProperty("UNITS", u);
            }
            return q;
        }
        if (arg0.getClass().isArray()) {
            int[] qube = Ops.getQubeDimsForArray(arg0);
            return ArrayDataSet.wrap(arg0, qube, true);
        }
        String sarg0 = String.valueOf(arg0);
        if (sarg0.startsWith("<") && sarg0.endsWith(">")) {
            throw new IllegalArgumentException("Ops.dataset is unable to coerce \"" + sarg0.substring(1, sarg0.length() - 1) + "\" to QDataSet");
        }
        throw new IllegalArgumentException("Ops.dataset is unable to coerce " + arg0 + " to QDataSet");
    }

    public static QDataSet dataset(Object arg0, Units u) {
        if (arg0 == null) {
            return null;
        }
        if (arg0 instanceof QDataSet) {
            Units u0;
            QDataSet result = (QDataSet)arg0;
            if (UnitsUtil.isTimeLocation((Units)u)) {
                result = Ops.putProperty(result, "FORMAT", null);
            }
            if ((u0 = SemanticOps.getUnits(result)).isConvertibleTo(u)) {
                return Ops.convertUnitsTo(result, u);
            }
            if (u0 == Units.dimensionless) {
                return Ops.putProperty(result, "UNITS", (Object)u);
            }
            throw new InconvertibleUnitsException(u0, u);
        }
        if (arg0 instanceof Number) {
            return DataSetUtil.asDataSet(u.createDatum(((Number)arg0).doubleValue()));
        }
        if (arg0 instanceof Datum) {
            return Ops.dataset(DataSetUtil.asDataSet((Datum)arg0), u);
        }
        if (arg0 instanceof DatumRange) {
            return Ops.dataset(DataSetUtil.asDataSet((DatumRange)arg0), u);
        }
        if (arg0 instanceof Color) {
            if (u == Units.rgbColor) {
                return Ops.dataset(arg0);
            }
            throw new IllegalArgumentException("Units must be rgbColor");
        }
        if (arg0 instanceof String) {
            String sarg = (String)arg0;
            try {
                if (u instanceof EnumerationUnits) {
                    return DataSetUtil.asDataSet(((EnumerationUnits)u).createDatum((Object)sarg));
                }
                return DataSetUtil.asDataSet(u.parse(sarg));
            }
            catch (ParseException ex) {
                try {
                    return DataSetUtil.asDataSet(TimeUtil.create((String)sarg));
                }
                catch (ParseException ex2) {
                    try {
                        DatumRange dr = DatumRangeUtil.parseISO8601Range((String)sarg);
                        if (dr == null) {
                            throw new IllegalArgumentException("unable to parse string: " + sarg);
                        }
                        return DataSetUtil.asDataSet(dr);
                    }
                    catch (ParseException ex1) {
                        throw new IllegalArgumentException("unable to parse string: " + sarg, ex1);
                    }
                }
            }
        }
        if (arg0 instanceof List) {
            List p = (List)arg0;
            double[] j = new double[p.size()];
            for (int i = 0; i < p.size(); ++i) {
                Object n = p.get(i);
                if (n instanceof Number) {
                    j[i] = ((Number)n).doubleValue();
                    continue;
                }
                try {
                    if (u instanceof EnumerationUnits) {
                        j[i] = ((EnumerationUnits)u).createDatum((Object)((String)n)).doubleValue(u);
                        continue;
                    }
                    j[i] = u.parse((String)n).doubleValue(u);
                    continue;
                }
                catch (ParseException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            DDataSet q = DDataSet.wrap(j, u);
            return q;
        }
        if (arg0.getClass().isArray()) {
            ArrayList<Integer> qqube = new ArrayList<Integer>();
            qqube.add(Array.getLength(arg0));
            if ((Integer)qqube.get(0) > 0) {
                Object slice = Array.get(arg0, 0);
                while (slice.getClass().isArray()) {
                    qqube.add(Array.getLength(slice));
                    slice = Array.get(slice, 0);
                }
            }
            int[] qube = new int[qqube.size()];
            for (int i = 0; i < qube.length; ++i) {
                qube[i] = (Integer)qqube.get(i);
            }
            if (arg0.getClass().getComponentType() == String.class) {
                double[] dd = new double[Array.getLength(arg0)];
                for (int i = 0; i < dd.length; ++i) {
                    try {
                        dd[i] = u.parse((String)Array.get(arg0, i)).doubleValue(u);
                        continue;
                    }
                    catch (ParseException ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
                return ArrayDataSet.wrap(dd, qube, true).setUnits(u);
            }
            return ArrayDataSet.wrap(arg0, qube, true).setUnits(u);
        }
        String sarg0 = String.valueOf(arg0);
        if (sarg0.startsWith("<") && sarg0.endsWith(">")) {
            throw new IllegalArgumentException("Ops.dataset is unable to coerce \"" + sarg0.substring(1, sarg0.length() - 1) + "\" to QDataSet");
        }
        throw new IllegalArgumentException("Ops.dataset is unable to coerce " + arg0 + " to QDataSet");
    }

    public static Datum datum(Object arg0) {
        if (arg0 == null) {
            return null;
        }
        if (arg0 instanceof QDataSet) {
            return DataSetUtil.asDatum((QDataSet)arg0);
        }
        if (arg0 instanceof Number) {
            return Datum.create((double)((Number)arg0).doubleValue());
        }
        if (arg0 instanceof Datum) {
            return (Datum)arg0;
        }
        if (arg0 instanceof Color) {
            return Units.rgbColor.createDatum(((Color)arg0).getRGB());
        }
        if (arg0 instanceof String) {
            String sarg = (String)arg0;
            try {
                return DatumUtil.parse((String)sarg);
            }
            catch (ParseException ex) {
                try {
                    return TimeUtil.create((String)sarg);
                }
                catch (ParseException ex2) {
                    throw new IllegalArgumentException("unable to parse string: " + sarg, ex2);
                }
            }
        }
        throw new IllegalArgumentException("unable to coerce " + arg0 + " to Datum");
    }

    public static DatumRange datumRange(Object arg0) {
        if (arg0 == null) {
            return null;
        }
        if (arg0 instanceof QDataSet) {
            return DataSetUtil.asDatumRange((QDataSet)arg0);
        }
        if (arg0 instanceof DatumRange) {
            return (DatumRange)arg0;
        }
        if (arg0 instanceof String) {
            String sarg = (String)arg0;
            try {
                return DatumRangeUtil.parseDatumRange((String)sarg);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("unable to parse string as DatumRange: " + sarg);
            }
        }
        if (arg0 instanceof List) {
            List p = (List)arg0;
            double[] j = new double[p.size()];
            if (j.length != 2) {
                throw new IllegalArgumentException("list should have two elements when creating DatumRange: " + arg0);
            }
            Units u = null;
            for (int i = 0; i < p.size(); ++i) {
                Object n = p.get(i);
                Datum d = Ops.datum(n);
                if (u == null) {
                    u = d.getUnits();
                } else if (d.getUnits() != u) {
                    throw new IllegalArgumentException("units cannot change when creating DatumRange:" + arg0);
                }
                j[i] = d.doubleValue(u);
            }
            return DatumRange.newRange((double)j[0], (double)j[1], u);
        }
        if (arg0.getClass().isArray()) {
            double[] j = new double[Array.getLength(arg0)];
            Units u = null;
            if (j.length != 2) {
                throw new IllegalArgumentException("array should have two elements when creating DatumRange: " + arg0);
            }
            for (int i = 0; i < j.length; ++i) {
                Object n = Array.get(arg0, i);
                Datum d = Ops.datum(n);
                if (u == null) {
                    u = d.getUnits();
                } else if (d.getUnits() != u) {
                    throw new IllegalArgumentException("units cannot change when creating DatumRange:" + arg0);
                }
                j[i] = d.doubleValue(u);
            }
            return DatumRange.newRange((double)j[0], (double)j[1], u);
        }
        String sarg0 = String.valueOf(arg0);
        if (sarg0.startsWith("<") && sarg0.endsWith(">")) {
            throw new IllegalArgumentException("Ops.dataset is unable to coerce \"" + sarg0.substring(1, sarg0.length() - 1) + "\" to QDataSet");
        }
        throw new IllegalArgumentException("Ops.dataset is unable to coerce " + arg0 + " to QDataSet");
    }

    public static QDataSet toRadians(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double y) -> y * Math.PI / 180.0);
        result.putProperty("UNITS", Units.radians);
        return result;
    }

    public static QDataSet toRadians(Object ds) {
        return Ops.toRadians(Ops.dataset(ds));
    }

    public static QDataSet toDegrees(QDataSet ds) {
        MutablePropertyDataSet result = Ops.applyUnaryOp(ds, (double y) -> y * 180.0 / Math.PI);
        result.putProperty("UNITS", Units.degrees);
        return result;
    }

    public static QDataSet toDegrees(Object ds) {
        return Ops.toDegrees(Ops.dataset(ds));
    }

    public static int imax(QDataSet ds) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("rank 1 only");
        }
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        int result = -1;
        double v = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < ds.length(); ++i) {
            double d;
            if (!(wds.value(i) > 0.0) || !((d = ds.value(i)) > v)) continue;
            result = i;
            v = d;
        }
        return result;
    }

    public static int imax(Object ds) {
        return Ops.imax(Ops.dataset(ds));
    }

    public static int imin(QDataSet ds) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("rank 1 only");
        }
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        int result = -1;
        double v = Double.POSITIVE_INFINITY;
        for (int i = 0; i < ds.length(); ++i) {
            double d;
            if (!(wds.value(i) > 0.0) || !((d = ds.value(i)) < v)) continue;
            result = i;
            v = d;
        }
        return result;
    }

    public static int imin(Object ds) {
        return Ops.imin(Ops.dataset(ds));
    }

    public static QDataSet subset(QDataSet ds, QDataSet w) {
        return DataSetOps.applyIndex(ds, 0, w, true);
    }

    public static QDataSet whereR1(QDataSet ds) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("data input to whereR1 must be rank 1");
        }
        return Ops.where(ds);
    }

    public static QDataSet where(QDataSet ds) {
        DataSetBuilder builder;
        if (ds == null) {
            throw new NullPointerException("dataset is null");
        }
        if (ds.rank() < 1) {
            throw new IllegalArgumentException("dataset is rank 0");
        }
        if (ds.rank() == 1 && DataSetAnnotations.VALUE_0.equals(DataSetAnnotations.getInstance().getAnnotation(ds, "zeroCount")) && DataSetAnnotations.VALUE_0.equals(DataSetAnnotations.getInstance().getAnnotation(ds, "invalidCount"))) {
            return Ops.indgen(ds.length());
        }
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        int blocksize = Math.max(100, ds.length() / 4);
        if (ds.rank() == 1) {
            builder = new DataSetBuilder(1, blocksize);
            while (iter.hasNext()) {
                iter.next();
                if (!(iter.getValue(wds) > 0.0) || iter.getValue(ds) == 0.0) continue;
                builder.putValue(-1, iter.index(0));
                builder.nextRecord();
            }
            builder.putProperty("MONOTONIC", Boolean.TRUE);
            if (builder.getLength() == ds.length()) {
                DataSetAnnotations.getInstance().putAnnotation(ds, "invalidCount", DataSetAnnotations.VALUE_0);
                DataSetAnnotations.getInstance().putAnnotation(ds, "zeroCount", DataSetAnnotations.VALUE_0);
            }
            builder.putProperty("VALID_MAX", ds.length());
        } else {
            builder = new DataSetBuilder(2, blocksize, ds.rank());
            while (iter.hasNext()) {
                iter.next();
                if (!(iter.getValue(wds) > 0.0) || iter.getValue(ds) == 0.0) continue;
                builder.putValue(-1, 0, iter.index(0));
                if (ds.rank() > 1) {
                    builder.putValue(-1, 1, iter.index(1));
                }
                if (ds.rank() > 2) {
                    builder.putValue(-1, 2, iter.index(2));
                }
                if (ds.rank() > 3) {
                    builder.putValue(-1, 3, iter.index(3));
                }
                builder.nextRecord();
            }
            switch (ds.rank()) {
                case 2: {
                    builder.putProperty("DEPEND_1", Ops.labelsDataset(new String[]{"dim0", "dim1"}));
                    break;
                }
                case 3: {
                    builder.putProperty("DEPEND_1", Ops.labelsDataset(new String[]{"dim0", "dim1", "dim2"}));
                    break;
                }
                case 4: {
                    builder.putProperty("DEPEND_1", Ops.labelsDataset(new String[]{"dim0", "dim1", "dim2", "dim4"}));
                    break;
                }
            }
        }
        builder.putProperty("CADENCE", DataSetUtil.asDataSet(1.0));
        builder.putProperty("FORMAT", "%d");
        return builder.getDataSet();
    }

    public static QDataSet where(Object ds) {
        return Ops.where(Ops.dataset(ds));
    }

    public static QDataSet withinSet(QDataSet ds, QDataSet set) {
        ArrayDataSet ids = ArrayDataSet.create(Integer.TYPE, DataSetUtil.qubeDims(ds));
        if (ds.rank() == 1) {
            for (int i = 0; i < ds.length(); ++i) {
                if (Ops.total(Ops.eq(ds.slice(i), set)) > 0.0) {
                    ids.putValue(i, 1.0);
                    continue;
                }
                ids.putValue(i, 0.0);
            }
        } else {
            QubeDataSetIterator it = new QubeDataSetIterator(ds);
            while (it.hasNext()) {
                it.next();
                if (Ops.total(Ops.eq(it.getRank0Value(ds), set)) > 0.0) {
                    it.putValue(ids, 1.0);
                    continue;
                }
                it.putValue(ids, 0.0);
            }
        }
        return ids;
    }

    public static QDataSet within(QDataSet ds, QDataSet bounds) {
        if (bounds == null) {
            throw new NullPointerException("bounds is null");
        }
        if (bounds.rank() == 0) {
            throw new IllegalArgumentException("bounds must be not be rank 0, but a rank 1 bounding box or rank 2 array of events");
        }
        if (bounds.rank() == 2) {
            return Ops.withinListOfBounds(ds, bounds);
        }
        UnitsConverter uc = SemanticOps.getLooseUnitsConverter(bounds.slice(0), ds);
        double min = uc.convert(bounds.value(0));
        double max = uc.convert(bounds.value(1));
        return Ops.applyUnaryOp(ds, (double d1) -> d1 >= min && d1 < max ? 1.0 : 0.0);
    }

    private static QDataSet withinListOfBounds(QDataSet ds, QDataSet bounds) {
        if (bounds.rank() != 2) {
            throw new IllegalArgumentException("bounds should be rank 2 array of bounds");
        }
        UnitsConverter uc = SemanticOps.getLooseUnitsConverter(bounds.slice(0).slice(0), ds);
        return Ops.applyUnaryOp(ds, (double d1) -> {
            for (int i = 0; i < bounds.length(); ++i) {
                double min1 = uc.convert(bounds.value(i, 0));
                double max1 = uc.convert(bounds.value(i, 1));
                if (!(d1 >= min1) || !(d1 < max1)) continue;
                return 1.0;
            }
            return 0.0;
        });
    }

    public static QDataSet within(Object ds, Object bounds) {
        return Ops.within(Ops.dataset(ds), Ops.dataset(Ops.datumRange(bounds)));
    }

    public static QDataSet binsWithin(QDataSet ds, QDataSet bounds) {
        return Ops.and(Ops.ge(Ops.slice1(ds, 1), bounds.slice(0)), Ops.lt(Ops.slice1(ds, 0), bounds.slice(1)));
    }

    private static QDataSet withoutListOfBounds(QDataSet ds, QDataSet bounds) {
        if (bounds.rank() != 2) {
            throw new IllegalArgumentException("bounds should be rank 2 array of bounds");
        }
        UnitsConverter uc = SemanticOps.getLooseUnitsConverter(bounds.slice(0).slice(0), ds);
        return Ops.applyUnaryOp(ds, (double d1) -> {
            for (int i = 0; i < bounds.length(); ++i) {
                double min1 = uc.convert(bounds.value(i, 0));
                double max1 = uc.convert(bounds.value(i, 1));
                if (!(d1 >= min1) || !(d1 < max1)) continue;
                return 0.0;
            }
            return 1.0;
        });
    }

    public static QDataSet without(QDataSet ds, QDataSet bounds) {
        if (bounds == null) {
            throw new NullPointerException("bounds is null");
        }
        if (bounds.rank() == 0) {
            throw new IllegalArgumentException("bounds must be not be rank 0, but a rank 1 bounding box or rank 2 list of bounding boxes");
        }
        if (bounds.rank() > 2) {
            throw new IllegalArgumentException("bounds must be a rank 1 bounding box or rank 2 list of bounding boxes");
        }
        if (bounds.rank() == 1) {
            return Ops.or(Ops.lt(ds, bounds.slice(0)), Ops.ge(ds, bounds.slice(1)));
        }
        return Ops.withoutListOfBounds(ds, bounds);
    }

    public static QDataSet without(Object ds, Object bounds) {
        QDataSet boundsDs = Ops.dataset(Ops.datumRange(bounds));
        return Ops.or(Ops.lt(ds, (Object)boundsDs.slice(0)), Ops.ge(ds, (Object)boundsDs.slice(1)));
    }

    public static QDataSet binsWithout(QDataSet ds, QDataSet bounds) {
        return Ops.or(Ops.lt(Ops.slice1(ds, 0), bounds.slice(0)), Ops.ge(Ops.slice1(ds, 1), bounds.slice(1)));
    }

    public static QDataSet sort(QDataSet ds) {
        return DataSetOps.sort(ds);
    }

    public static QDataSet sort(Object ds) {
        return DataSetOps.sort(Ops.dataset(ds));
    }

    public static QDataSet uniq(QDataSet ds) {
        return Ops.uniq(ds, null);
    }

    public static QDataSet hashcodes(QDataSet ds) {
        if (ds.rank() == 0) {
            throw new IllegalArgumentException("rank 0 not supported");
        }
        if (ds.rank() == 1) {
            return ds;
        }
        IDataSet result = IDataSet.createRank1(ds.length());
        for (int i = 0; i < ds.length(); ++i) {
            QDataSet slice = ds.slice(i);
            QDataSet wds = Ops.valid(slice);
            int hash = 0;
            QubeDataSetIterator it = new QubeDataSetIterator(slice);
            while (it.hasNext()) {
                it.next();
                if (it.getValue(wds) > 0.0) {
                    hash = hash * 31 + Double.valueOf(it.getValue(slice)).hashCode();
                    continue;
                }
                hash *= 31;
            }
            result.putValue(i, hash);
        }
        return result;
    }

    public static QDataSet uniq(QDataSet ds, QDataSet sort) {
        int didx;
        if (ds.rank() > 1) {
            throw new IllegalArgumentException("ds.rank()>1");
        }
        if (sort != null && sort.rank() > 1) {
            throw new IllegalArgumentException("sort.rank()>1");
        }
        DataSetBuilder builder = new DataSetBuilder(1, 100);
        if (sort == null) {
            QubeDataSetIterator it = new QubeDataSetIterator(ds);
            if (!it.hasNext()) {
                return builder.getDataSet();
            }
            it.next();
            double d = it.getValue(ds);
            didx = it.index(0);
            while (it.hasNext()) {
                it.next();
                double d1 = it.getValue(ds);
                if (d != d1) {
                    builder.putValue(-1, didx);
                    builder.nextRecord();
                    d = d1;
                }
                didx = it.index(0);
            }
        } else {
            QubeDataSetIterator it = new QubeDataSetIterator(sort);
            if (!it.hasNext()) {
                return builder.getDataSet();
            }
            it.next();
            didx = (int)it.getValue(sort);
            double d = ds.value(didx);
            while (it.hasNext()) {
                it.next();
                int i = (int)it.getValue(sort);
                double d1 = ds.value(i);
                if (d != d1) {
                    builder.putValue(-1, didx);
                    builder.nextRecord();
                    d = d1;
                }
                didx = i;
            }
        }
        builder.putValue(-1, didx);
        builder.nextRecord();
        return builder.getDataSet();
    }

    public static QDataSet uniqValues(QDataSet ds, QDataSet sort) {
        QDataSet idx = Ops.uniq(ds, sort);
        return DataSetOps.applyIndex(ds, 0, idx, true);
    }

    public static Object getProperty(QDataSet ds, String name) {
        return ds.property(name);
    }

    public static MutablePropertyDataSet putProperty(Object ds, String name, Object value) {
        return Ops.putProperty(Ops.dataset(ds), name, value);
    }

    public static MutablePropertyDataSet putProperty(QDataSet ds, String name, Object value) {
        if (ds == null) {
            throw new IllegalArgumentException("dataset ds is null");
        }
        MutablePropertyDataSet mds = !(ds instanceof MutablePropertyDataSet) ? ArrayDataSet.maybeCopy(ds) : (((MutablePropertyDataSet)ds).isImmutable() ? Ops.copy(ds) : (MutablePropertyDataSet)ds);
        if (value != null && (value.equals("null") || value.equals("None") || value.equals("Null")) && !"String".equals(DataSetUtil.getPropertyType(name)) && !name.equals("TITLE") && !name.equals("LABEL")) {
            value = null;
        }
        if (value == null) {
            mds.putProperty(name, null);
            return mds;
        }
        if (value == ds && !name.equals("DEPEND_0")) {
            throw new IllegalArgumentException("a dataset cannot have itself as a property");
        }
        String type = DataSetUtil.getPropertyType(name);
        if (type == null) {
            logger.log(Level.FINE, "unrecognized property {0}...", name);
            mds.putProperty(name, value);
        } else {
            switch (type) {
                case "QDataSet": {
                    QDataSet arg = Ops.dataset(value);
                    if (name.equals("DEPEND_0") && arg.rank() > 0 && mds.rank() > 0 && arg.length() != mds.length()) {
                        if (Schemes.isPolyMesh(arg)) {
                            if (arg.slice(1).length() != mds.length()) {
                                throw new IllegalArgumentException("DEPEND_0 must have the same number of triangles as dataset");
                            }
                        } else {
                            throw new IllegalArgumentException("DEPEND_0 must be the same length as dataset");
                        }
                    }
                    mds.putProperty(name, arg);
                    break;
                }
                case "Units": {
                    if (value instanceof String) {
                        String svalue = (String)value;
                        value = Units.lookupUnits((String)svalue);
                    }
                    mds.putProperty(name, value);
                    break;
                }
                case "Boolean": {
                    if (value instanceof String) {
                        String svalue = (String)value;
                        value = Boolean.valueOf(svalue);
                    } else if (value instanceof Number) {
                        value = !((Number)value).equals(0);
                    } else if (value instanceof QDataSet) {
                        value = ((QDataSet)value).value() != 0.0;
                    }
                    mds.putProperty(name, value);
                    break;
                }
                case "Number": {
                    if (value instanceof String) {
                        String svalue = (String)value;
                        Units u = (Units)mds.property("UNITS");
                        if (u != null) {
                            try {
                                value = u.parse(svalue).doubleValue(u);
                            }
                            catch (ParseException ex) {
                                try {
                                    value = Integer.valueOf(svalue);
                                }
                                catch (NumberFormatException ex2) {
                                    throw new IllegalArgumentException(ex);
                                }
                            }
                        } else {
                            value = svalue.contains(".") || svalue.contains("e") || svalue.contains("E") ? (Number)Double.valueOf(svalue) : (Number)Integer.valueOf(svalue);
                        }
                    } else if (value instanceof QDataSet) {
                        QDataSet qvalue = (QDataSet)value;
                        if (qvalue.rank() > 1) {
                            throw new IllegalArgumentException("rank 0 dataset needed for putProperty");
                        }
                        value = qvalue.value();
                    }
                    mds.putProperty(name, value);
                    break;
                }
                case "CacheTag": {
                    if (value instanceof String) {
                        String svalue = (String)value;
                        int i = svalue.indexOf("@");
                        try {
                            DatumRange tr = DatumRangeUtil.parseTimeRange((String)svalue.substring(0, i));
                            if (i == -1) {
                                value = new CacheTag(tr, null);
                            } else if (svalue.substring(i + 1).trim().equals("intrinsic")) {
                                value = new CacheTag(tr, null);
                            } else {
                                Datum res = Units.seconds.parse(svalue.substring(i + 1));
                                value = new CacheTag(tr, res);
                            }
                        }
                        catch (ParseException ex) {
                            throw new IllegalArgumentException(ex);
                        }
                    }
                    mds.putProperty(name, value);
                    break;
                }
                case "Map": {
                    if (!(value instanceof Map)) {
                        logger.log(Level.WARNING, "unable to convert to Map, is it a Python Dictionary: {0}", value);
                        break;
                    }
                    mds.putProperty(name, value);
                    break;
                }
                case "String": {
                    String svalue = (String)value;
                    if (svalue.startsWith("'") && svalue.endsWith("'")) {
                        svalue = svalue.substring(1, svalue.length() - 1);
                    }
                    mds.putProperty(name, svalue);
                    break;
                }
                default: {
                    mds.putProperty(name, value);
                }
            }
        }
        return mds;
    }

    public static Object convertPropertyValue(QDataSet context, String name, Object value) {
        if (value == null) {
            return value;
        }
        String type = DataSetUtil.getPropertyType(name);
        if (type == null) {
            throw new IllegalArgumentException("unrecognized property: " + name);
        }
        Units u = context == null ? Units.dimensionless : (Units)context.property("UNITS");
        switch (type) {
            case "QDataSet": {
                return Ops.dataset(value);
            }
            case "Units": {
                if (value instanceof String) {
                    String svalue = (String)value;
                    value = Units.lookupUnits((String)svalue);
                    return value;
                }
                if (value instanceof Units) {
                    return value;
                }
                throw new IllegalArgumentException("cannot convert to value for " + name + ": " + value);
            }
            case "Boolean": {
                if (value instanceof String) {
                    String svalue = (String)value;
                    value = Boolean.valueOf(svalue);
                    return value;
                }
                if (value instanceof Number) {
                    value = !((Number)value).equals(0);
                    return value;
                }
                if (value instanceof QDataSet) {
                    value = ((QDataSet)value).value() != 0.0;
                    return value;
                }
                if (value instanceof Boolean) {
                    return value;
                }
                throw new IllegalArgumentException("cannot convert to value for " + name + ": " + value);
            }
            case "Number": {
                if (value instanceof String) {
                    String svalue = (String)value;
                    if (u != null) {
                        try {
                            value = u.parse(svalue).doubleValue(u);
                        }
                        catch (ParseException ex) {
                            try {
                                value = Integer.valueOf(svalue);
                            }
                            catch (NumberFormatException ex2) {
                                throw new IllegalArgumentException(ex);
                            }
                        }
                    } else {
                        value = svalue.contains(".") || svalue.contains("e") || svalue.contains("E") ? (Number)Double.valueOf(svalue) : (Number)Integer.valueOf(svalue);
                    }
                    return value;
                }
                if (value instanceof QDataSet) {
                    QDataSet qvalue = (QDataSet)value;
                    if (qvalue.rank() > 1) {
                        throw new IllegalArgumentException("rank 0 dataset needed for property of type Number: " + name);
                    }
                    value = Ops.datum(qvalue).doubleValue(u);
                    return value;
                }
                if (value instanceof Datum) {
                    value = ((Datum)value).doubleValue(u);
                    return value;
                }
                if (value instanceof Number) {
                    return value;
                }
            }
            case "CacheTag": {
                if (value instanceof String) {
                    String svalue = (String)value;
                    int i = svalue.indexOf("@");
                    try {
                        DatumRange tr = DatumRangeUtil.parseTimeRange((String)svalue.substring(0, i));
                        if (i == -1) {
                            value = new CacheTag(tr, null);
                        } else if (svalue.substring(i + 1).trim().equals("intrinsic")) {
                            value = new CacheTag(tr, null);
                        } else {
                            Datum res = Units.seconds.parse(svalue.substring(i + 1));
                            value = new CacheTag(tr, res);
                        }
                        return value;
                    }
                    catch (ParseException ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
                if (value instanceof CacheTag) {
                    return value;
                }
                throw new IllegalArgumentException("cannot convert to value for " + name + ": " + value);
            }
            case "Map": {
                if (value instanceof Map) {
                    return value;
                }
            }
            case "String": {
                return value.toString();
            }
        }
        return value;
    }

    public static MutablePropertyDataSet putIndexedProperty(QDataSet ds, String name, int index, Object value) {
        MutablePropertyDataSet mds = !(ds instanceof MutablePropertyDataSet) ? ArrayDataSet.maybeCopy(ds) : (((MutablePropertyDataSet)ds).isImmutable() ? ArrayDataSet.copy(ds) : (MutablePropertyDataSet)ds);
        if (!(value == null || !value.equals("Null") && !value.equals("None") || "String".equals(DataSetUtil.getPropertyType(name)) || name.equals("TITLE") || name.equals("LABEL"))) {
            value = null;
        }
        if (value == null) {
            mds.putProperty(name, index, null);
            return mds;
        }
        String type = DataSetUtil.getPropertyType(name);
        if (type == null) {
            logger.log(Level.FINE, "unrecognized property {0}...", name);
            mds.putProperty(name, value);
        } else {
            switch (type) {
                case "QDataSet": {
                    mds.putProperty(name, Ops.dataset(value));
                    break;
                }
                case "Units": {
                    if (value instanceof String) {
                        String svalue = (String)value;
                        value = Units.lookupUnits((String)svalue);
                    }
                    mds.putProperty(name, value);
                    break;
                }
                case "Boolean": {
                    if (value instanceof String) {
                        String svalue = (String)value;
                        value = Boolean.valueOf(svalue);
                    } else if (value instanceof Number) {
                        value = !((Number)value).equals(0);
                    }
                    mds.putProperty(name, value);
                    break;
                }
                case "Number": {
                    if (value instanceof String) {
                        String svalue = (String)value;
                        Units u = (Units)mds.property("UNITS");
                        if (u != null) {
                            try {
                                value = u.parse(svalue).doubleValue(u);
                            }
                            catch (ParseException ex) {
                                try {
                                    value = Integer.valueOf(svalue);
                                }
                                catch (NumberFormatException ex2) {
                                    throw new IllegalArgumentException(ex);
                                }
                            }
                        } else {
                            value = svalue.contains(".") || svalue.contains("e") || svalue.contains("E") ? (Number)Double.valueOf(svalue) : (Number)Integer.valueOf(svalue);
                        }
                    }
                    mds.putProperty(name, value);
                    break;
                }
                case "CacheTag": {
                    if (value instanceof String) {
                        String svalue = (String)value;
                        int i = svalue.indexOf("@");
                        try {
                            DatumRange tr = DatumRangeUtil.parseTimeRange((String)svalue.substring(0, i));
                            if (i == -1) {
                                value = new CacheTag(tr, null);
                            } else if (svalue.substring(i + 1).trim().equals("intrinsic")) {
                                value = new CacheTag(tr, null);
                            } else {
                                Datum res = Units.seconds.parse(svalue.substring(i + 1));
                                value = new CacheTag(tr, res);
                            }
                        }
                        catch (ParseException ex) {
                            throw new IllegalArgumentException(ex);
                        }
                    }
                    mds.putProperty(name, index, value);
                    break;
                }
                default: {
                    mds.putProperty(name, index, value);
                }
            }
        }
        return mds;
    }

    public static MutablePropertyDataSet putBundleProperty(QDataSet ds, String name, int index, Object value) {
        int dim = ds.rank() - 1;
        String bundleProp = "BUNDLE_" + dim;
        QDataSet bds = (QDataSet)ds.property(bundleProp);
        if (bds == null) {
            bds = SparseDataSet.createRank(2);
        }
        MutablePropertyDataSet wbds = Ops.putIndexedProperty(bds, name, index, value);
        MutablePropertyDataSet mds = Ops.putProperty(ds, bundleProp, (Object)wbds);
        return mds;
    }

    public static WritableDataSet putValues(Object ds, Object indices, Object values) {
        QDataSet qvalues = Ops.dataset(values);
        QDataSet qindices = Ops.dataset(indices);
        QDataSet qds = Ops.dataset(ds);
        return Ops.putValues(qds, qindices, qvalues);
    }

    public static WritableDataSet putValues(QDataSet ds, QDataSet indices, QDataSet value) {
        WritableDataSet wds;
        DataSetUtil.checkListOfIndeces(ds, indices);
        WritableDataSet result = ds instanceof WritableDataSet ? ((wds = (WritableDataSet)ds).isImmutable() ? Ops.copy(wds) : wds) : Ops.copy(ds);
        if (result.rank() > 1 && indices.rank() == 1) {
            DataSetBuilder dsb = new DataSetBuilder(2, indices.length() * result.length(0), result.rank());
            Object[] iii = new Object[result.rank()];
            for (int i = 0; i < indices.length(); ++i) {
                int i0 = (int)indices.value(i);
                iii[0] = i0;
                QubeDataSetIterator it = new QubeDataSetIterator(result.slice(i0));
                while (it.hasNext()) {
                    it.next();
                    for (int j = 1; j < result.rank(); ++j) {
                        iii[j] = it.index(j - 1);
                        dsb.nextRecord(iii);
                    }
                }
            }
            indices = dsb.getDataSet();
        }
        double dvalue = Double.NaN;
        UnitsConverter uc = null;
        if (value != null) {
            Units vu = SemanticOps.getUnits(value);
            if (vu != Units.dimensionless) {
                uc = SemanticOps.getUnitsConverter(value, ds);
                if (value.rank() == 0) {
                    dvalue = uc.convert(value.value());
                }
            } else {
                dvalue = value.value();
            }
        }
        if (indices.rank() == 1) {
            indices = new BundleDataSet(indices);
        }
        IndexListDataSetIterator iter = new IndexListDataSetIterator(indices);
        if (value == null || value.rank() == 0) {
            while (iter.hasNext()) {
                iter.next();
                iter.putValue(result, dvalue);
            }
        } else {
            int i = 0;
            while (iter.hasNext()) {
                assert (uc != null);
                iter.next();
                dvalue = uc.convert(value.value(i));
                iter.putValue(result, dvalue);
                ++i;
            }
        }
        return result;
    }

    public static WritableDataSet removeValues(QDataSet ds, QDataSet indices) {
        DataSetUtil.checkListOfIndeces(ds, indices);
        return Ops.putValues(ds, indices, null);
    }

    public static WritableDataSet removeValues(Object ds, Object indices) {
        return Ops.putValues(Ops.dataset(ds), Ops.dataset(indices), null);
    }

    public static WritableDataSet removeValuesGreaterThan(QDataSet ds, QDataSet v) {
        QDataSet r = Ops.where(Ops.gt(ds, v));
        return Ops.putValues(ds, r, null);
    }

    public static WritableDataSet removeValuesGreaterThan(Object ds, Object v) {
        return Ops.removeValuesGreaterThan(Ops.dataset(ds), Ops.dataset(v));
    }

    public static WritableDataSet removeValuesLessThan(QDataSet ds, QDataSet v) {
        QDataSet r = Ops.where(Ops.lt(ds, v));
        return Ops.putValues(ds, r, null);
    }

    public static WritableDataSet removeValuesLessThan(Object ds, Object v) {
        return Ops.removeValuesLessThan(Ops.dataset(ds), Ops.dataset(v));
    }

    public static WritableDataSet removeFill(QDataSet ds) {
        QDataSet r = Ops.where(Ops.valid(ds));
        return Ops.applyIndex(ds, r);
    }

    public static WritableDataSet applyIndex(QDataSet vv, QDataSet ds, Number fillValue) {
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        DDataSet result = iter.createEmptyDs();
        while (iter.hasNext()) {
            iter.next();
            int idx = (int)iter.getValue(ds);
            try {
                iter.putValue(result, vv.value(idx));
            }
            catch (IndexOutOfBoundsException ex) {
                iter.putValue(result, fillValue.doubleValue());
            }
        }
        result.putProperty("UNITS", vv.property("UNITS"));
        result.putProperty("FILL_VALUE", fillValue);
        return result;
    }

    public static WritableDataSet applyIndex(QDataSet ds, QDataSet r) {
        return Ops.copy(new SortDataSet(ds, r));
    }

    public static WritableDataSet applyIndex(Object dso, QDataSet r) {
        QDataSet ds = Ops.dataset(dso);
        return Ops.copy(new SortDataSet(ds, r));
    }

    public static MutablePropertyDataSet applyIndex(QDataSet ds, int dimension, QDataSet indices) {
        SubsetDataSet sds = new SubsetDataSet(ds);
        sds.applyIndex(dimension, indices);
        return sds;
    }

    public static QDataSet removeIndeces(QDataSet vv, QDataSet indices) {
        DataSetBuilder build;
        if (indices.length() == 0) {
            return vv;
        }
        if (!DataSetUtil.isMonotonic(indices)) {
            QDataSet s = Ops.sort(indices);
            indices = Ops.applyIndex(indices, s);
        }
        if (indices.value(0) % 1.0 > 0.0) {
            throw new IllegalArgumentException("indices must be counting numbers.");
        }
        int currentSkipIndex = 0;
        int nextSkepIndex = (int)indices.value(currentSkipIndex);
        int currentIndex = 0;
        switch (vv.rank()) {
            case 1: {
                build = new DataSetBuilder(1, 100 * (int)Math.ceil((double)(vv.length() - indices.length()) / 100.0));
                break;
            }
            case 2: {
                build = new DataSetBuilder(2, 100 * (int)Math.ceil((double)(vv.length() - indices.length()) / 100.0), vv.length(0));
                break;
            }
            default: {
                throw new IllegalArgumentException("only rank 1 and rank 2 datasets are supported");
            }
        }
        while (currentIndex < vv.length()) {
            if (currentIndex == nextSkepIndex) {
                nextSkepIndex = ++currentSkipIndex == indices.length() ? -1 : (int)indices.value(currentSkipIndex);
            } else {
                build.nextRecord(vv.slice(currentIndex));
            }
            ++currentIndex;
        }
        DDataSet result = build.getDataSet();
        DataSetUtil.putProperties(DataSetUtil.getProperties(vv), result);
        QDataSet dep0 = (QDataSet)vv.property("DEPEND_0");
        if (dep0 != null) {
            result.putProperty("DEPEND_0", Ops.removeIndeces(dep0, indices));
        }
        return result;
    }

    public static QDataSet reverse(QDataSet ds) {
        return new ReverseDataSet(ds);
    }

    public static QDataSet reverse(Object ds) {
        return new ReverseDataSet(Ops.dataset(ds));
    }

    public static QDataSet shuffle(QDataSet ds) {
        int size = ds.length();
        int[] back = new int[size];
        for (int i = 0; i < size; ++i) {
            back[i] = i;
        }
        IDataSet wds = IDataSet.wrap(back, 1, size, 1, 1);
        Random r = random;
        for (int i = 0; i < size; ++i) {
            int i1 = r.nextInt(size - i) + i;
            double t = wds.value(i1);
            wds.putValue(i1, wds.value(i));
            wds.putValue(i, t);
        }
        return wds;
    }

    public static QDataSet shuffle(Object ds) {
        return Ops.shuffle(Ops.dataset(ds));
    }

    public static QDataSet slice0(QDataSet ds, int idx) {
        return ds.slice(idx);
    }

    public static QDataSet slice0(QDataSet ds, QDataSet sliceds) {
        if (sliceds.rank() != 0) {
            throw new IllegalArgumentException("sliceds must be rank 0");
        }
        QDataSet dep = SemanticOps.xtagsDataSet(ds);
        if (dep.rank() != 1) {
            throw new IllegalArgumentException("dataset must have rank 1 tags");
        }
        QDataSet findex = Ops.findex(dep, sliceds);
        double f = findex.value();
        if (f >= 0.0 && f < (double)dep.length()) {
            return Ops.slice0(ds, (int)Math.round(f));
        }
        if (f < 0.0) {
            return Ops.slice0(ds, 0);
        }
        return Ops.slice0(ds, dep.length() - 1);
    }

    public static QDataSet slice1(QDataSet ds, int idx) {
        return DataSetOps.slice1(ds, idx);
    }

    public static QDataSet slice1(QDataSet ds, QDataSet sliceds) {
        if (sliceds.rank() != 0) {
            throw new IllegalArgumentException("sliceds must be rank 0");
        }
        QDataSet dep = SemanticOps.ytagsDataSet(ds);
        if (dep.rank() != 1) {
            throw new IllegalArgumentException("dataset must have rank 1 tags");
        }
        QDataSet findex = Ops.findex(dep, sliceds);
        double f = findex.value();
        if (f >= 0.0 && f < (double)dep.length()) {
            return Ops.slice1(ds, (int)Math.round(f));
        }
        if (f < 0.0) {
            return Ops.slice1(ds, 0);
        }
        return Ops.slice1(ds, dep.length() - 1);
    }

    public static QDataSet slice2(QDataSet ds, int idx) {
        return DataSetOps.slice2(ds, idx);
    }

    public static QDataSet slice2(QDataSet ds, QDataSet sliceds) {
        if (sliceds.rank() != 0) {
            throw new IllegalArgumentException("sliceds must be rank 0");
        }
        QDataSet dep = SemanticOps.ytagsDataSet(ds);
        if (dep.rank() != 1) {
            throw new IllegalArgumentException("dataset must have rank 1 tags");
        }
        QDataSet findex = Ops.findex(dep, sliceds);
        double f = findex.value();
        if (f >= 0.0 && f < (double)dep.length()) {
            return Ops.slice2(ds, (int)Math.round(f));
        }
        if (f < 0.0) {
            return Ops.slice2(ds, 0);
        }
        return Ops.slice2(ds, dep.length() - 1);
    }

    public static QDataSet slice3(QDataSet ds, int idx) {
        return DataSetOps.slice3(ds, idx);
    }

    public static QDataSet slice3(QDataSet ds, QDataSet sliceds) {
        if (sliceds.rank() != 0) {
            throw new IllegalArgumentException("sliceds must be rank 0");
        }
        QDataSet dep = SemanticOps.ytagsDataSet(ds);
        if (dep.rank() != 1) {
            throw new IllegalArgumentException("dataset must have rank 1 tags");
        }
        QDataSet findex = Ops.findex(dep, sliceds);
        double f = findex.value();
        if (f >= 0.0 && f < (double)dep.length()) {
            return Ops.slice3(ds, (int)Math.round(f));
        }
        if (f < 0.0) {
            return Ops.slice3(ds, 0);
        }
        return Ops.slice3(ds, dep.length() - 1);
    }

    public static QDataSet fftFilter(QDataSet ds, int len, FFTFilterType filt) {
        NullProgressMonitor mon = new NullProgressMonitor();
        if (ds.rank() == 1) {
            QDataSet c = (QDataSet)ds.property("CONTEXT_0");
            QDataSet dep0ds = (QDataSet)ds.property("DEPEND_0");
            Units cunits = null;
            Units dep0units = null;
            if (c != null) {
                cunits = SemanticOps.getUnits(c);
                if (dep0ds != null) {
                    dep0units = SemanticOps.getUnits(dep0ds);
                    if (!cunits.getOffsetUnits().isConvertibleTo(dep0units.getOffsetUnits())) {
                        c = null;
                    }
                }
            } else {
                dep0units = SemanticOps.getUnits(dep0ds);
            }
            if (c == null && dep0ds != null) {
                c = dep0ds.slice(0);
                cunits = dep0units;
            }
            JoinDataSet jds = new JoinDataSet(ds);
            if (c != null && c.rank() == 0) {
                JoinDataSet dep0 = new JoinDataSet(c);
                dep0.putProperty("UNITS", cunits);
                jds.putProperty("DEPEND_0", dep0);
                if (dep0units != null && (dep0units.isConvertibleTo(cunits) || dep0units.getOffsetUnits().isConvertibleTo(cunits))) {
                    jds.putProperty("DEPEND_1", Ops.subtract(dep0ds, c));
                } else {
                    jds.putProperty("DEPEND_1", dep0ds);
                }
            }
            jds.putProperty("UNITS", ds.property("UNITS"));
            ds = jds;
        }
        switch (ds.rank()) {
            case 3: {
                JoinDataSet result = new JoinDataSet(3);
                mon.setTaskSize((long)(ds.length() * 10));
                mon.started();
                for (int i = 0; i < ds.length(); ++i) {
                    mon.setTaskProgress((long)(i * 10));
                    QDataSet pow1 = Ops.fftFilter(ds.slice(i), len, filt);
                    result.join(pow1);
                }
                mon.finished();
                return result;
            }
            case 2: {
                QDataSet filter;
                JoinDataSet result = new JoinDataSet(2);
                result.putProperty("JOIN_0", null);
                int nsam = ds.length() * (ds.length(0) / len);
                DataSetBuilder dep0b = new DataSetBuilder(1, nsam);
                QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
                QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
                if (dep0 == null) {
                    dep0 = Ops.findgen(ds.length());
                }
                if (dep1 == null) {
                    dep1 = Ops.findgen(ds.length(0));
                }
                Units dep0u = SemanticOps.getUnits(dep0);
                Units dep1u = SemanticOps.getUnits(dep1);
                UnitsConverter uc = dep1u.getConverter(dep0u.getOffsetUnits());
                switch (filt) {
                    case Hanning: {
                        filter = FFTUtil.getWindowHanning(len);
                        break;
                    }
                    case Hann: {
                        filter = FFTUtil.getWindowHanning(len);
                        break;
                    }
                    case TenPercentEdgeCosine: {
                        filter = FFTUtil.getWindow10PercentEdgeCosine(len);
                        break;
                    }
                    case Unity: {
                        filter = FFTUtil.getWindowUnity(len);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unsupported op: " + (Object)((Object)filt));
                    }
                }
                boolean convertToFloat = ds instanceof FDataSet;
                mon.setTaskSize((long)ds.length());
                mon.started();
                mon.setProgressMessage("performing fftFilter");
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i) / len; ++j) {
                        QDataSet wave = ds.slice(i).trim(j * len, (j + 1) * len);
                        QDataSet vds = Ops.multiply(wave, filter);
                        if (convertToFloat) {
                            vds = ArrayDataSet.copy(Float.TYPE, vds);
                        }
                        result.join(vds);
                        dep0b.putValue(-1, dep0.value(i) + uc.convert(dep1.value(j * len + len / 2)));
                        dep0b.nextRecord();
                    }
                    mon.setTaskProgress((long)i);
                }
                mon.finished();
                if (dep0 != null) {
                    dep0b.putProperty("UNITS", dep0.property("UNITS"));
                    result.putProperty("DEPEND_0", dep0b.getDataSet());
                }
                if (dep1 != null) {
                    result.putProperty("DEPEND_1", dep1.trim(0, len));
                }
                result.putProperty("UNITS", ds.slice(0).property("UNITS"));
                logger.log(Level.FINE, "*** Set units to {0}", ds.slice(0).property("UNITS"));
                return result;
            }
        }
        throw new IllegalArgumentException("rank not supported: " + ds.rank());
    }

    public static QDataSet hanning(QDataSet ds, int len) {
        return Ops.fftFilter(ds, len, FFTFilterType.Hanning);
    }

    public static QDataSet fftPower(QDataSet ds, int len, ProgressMonitor mon) {
        QDataSet unity = Ops.ones(len);
        return Ops.fftPower(ds, unity, 1, mon);
    }

    public static QDataSet windowFunction(FFTFilterType filt, int len) {
        assert (filt != null);
        switch (filt) {
            case Hanning: {
                return FFTUtil.getWindowHanning(len);
            }
            case Hann: {
                return FFTUtil.getWindowHanning(len);
            }
            case TenPercentEdgeCosine: {
                return FFTUtil.getWindow10PercentEdgeCosine(len);
            }
            case Unity: {
                return FFTUtil.getWindowUnity(len);
            }
            case Boxcar: {
                return FFTUtil.getWindowUnity(len);
            }
        }
        throw new UnsupportedOperationException("unsupported op: " + (Object)((Object)filt));
    }

    public static QDataSet windowFunction(String type, int len) {
        assert (type != null);
        switch (type) {
            case "Hanning": {
                return FFTUtil.getWindowHanning(len);
            }
            case "Hann": {
                return FFTUtil.getWindowHanning(len);
            }
            case "TenPercentEdgeCosine": {
                return FFTUtil.getWindow10PercentEdgeCosine(len);
            }
            case "Unity": {
                return FFTUtil.getWindowUnity(len);
            }
            case "Boxcar": {
                return FFTUtil.getWindowUnity(len);
            }
        }
        throw new UnsupportedOperationException("unsupported op: " + type);
    }

    public static QDataSet fftPower(QDataSet ds, QDataSet window, ProgressMonitor mon) {
        return Ops.fftPower(ds, window, 1, mon);
    }

    public static QDataSet fftPower(QDataSet ds, int windowLen, int stepFraction, String windowName, ProgressMonitor mon) {
        QDataSet window = Ops.windowFunction(FFTFilterType.valueOf(windowName), windowLen);
        return Ops.fftPower(ds, window, stepFraction, mon);
    }

    public static <T> T getProperty(QDataSet ds, String propertyName, Class<T> clazz) {
        Class correctClass = DataSetUtil.getPropertyClass(propertyName);
        if (!clazz.isAssignableFrom(correctClass)) {
            throw new IllegalArgumentException("requested class is not of correct type: " + clazz + " (should be " + correctClass + ")");
        }
        Object o = ds.property(propertyName);
        if (o == null) {
            return null;
        }
        if (clazz.isInstance(o)) {
            return clazz.cast(o);
        }
        logger.log(Level.WARNING, "ds property is not of the correct type: {0} have {1}, want {2}", new Object[]{propertyName, o.getClass(), clazz});
        return null;
    }

    public static QDataSet fftPowerSpectralDensity(QDataSet ds, QDataSet window, int stepFraction, ProgressMonitor mon) {
        Units u = (Units)ds.property("UNITS");
        String su = u == null || u == Units.dimensionless ? "(dimensionless)" : u.toString();
        QDataSet r = Ops.fftPower(ds, window, stepFraction, mon);
        QDataSet ytags = Ops.ytags(r);
        r = Ops.divide(r, Ops.replicate(ytags, r.length()));
        r = Ops.putProperty(r, "UNITS", (Object)(su + "**2 / Hz"));
        return r;
    }

    public static QDataSet fftLinearSpectralDensity(QDataSet ds, QDataSet window, int stepFraction, ProgressMonitor mon) {
        Units u = (Units)ds.property("UNITS");
        String su = u == null || u == Units.dimensionless ? "(dimensionless)" : u.toString();
        QDataSet r = Ops.fftPower(ds, window, stepFraction, mon);
        QDataSet ytags = Ops.ytags(r);
        r = Ops.divide(Ops.sqrt(r), Ops.replicate(Ops.sqrt(ytags), r.length()));
        r = Ops.putProperty(r, "UNITS", (Object)(su + " * Hz**-1/2"));
        return r;
    }

    public static QDataSet fftLinearSpectrum(QDataSet ds, QDataSet window, int stepFraction, ProgressMonitor mon) {
        Units u = (Units)ds.property("UNITS");
        String su = u == null || u == Units.dimensionless ? "(dimensionless)" : u.toString();
        QDataSet r = Ops.fftPower(ds, window, stepFraction, mon);
        r = Ops.sqrt(r);
        r = Ops.putProperty(r, "UNITS", (Object)su);
        return r;
    }

    public static QDataSet fftPowerSpectrum(QDataSet ds, QDataSet window, int stepFraction, ProgressMonitor mon) {
        QDataSet r = Ops.fftPower(ds, window, stepFraction, mon);
        return r;
    }

    public static QDataSet fftPower(QDataSet ds, QDataSet window, int stepFraction, ProgressMonitor mon) {
        int dataWindowLength;
        String title;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        if ((title = (String)ds.property("TITLE")) != null) {
            title = "FFTPower of " + title;
        }
        Map userProperties = Ops.getProperty(ds, "USER_PROPERTIES", Map.class);
        if (ds.rank() == 2 && (dataWindowLength = ds.slice(0).length()) < window.length()) {
            logger.fine("flattening rank 2 waveform to support FFT with longer window size.");
            QDataSet flattenedDataSet = Ops.flattenWaveform(ds);
            return Ops.fftPower(flattenedDataSet, window, stepFraction, mon);
        }
        if (ds.rank() == 1) {
            QDataSet c = (QDataSet)ds.property("CONTEXT_0");
            if (c != null && SemanticOps.getUnits(c).equals(Units.dimensionless)) {
                c = null;
            }
            JoinDataSet jds = new JoinDataSet(ds);
            if (c != null && c.rank() == 0) {
                Units dep0u = (Units)c.property("UNITS");
                JoinDataSet dep0 = new JoinDataSet(c);
                QDataSet dep1 = (QDataSet)ds.property("DEPEND_0");
                if (dep0u != null) {
                    Units dep1u = SemanticOps.getUnits(dep1);
                    dep0.putProperty("UNITS", dep0u);
                    if (dep1u.getOffsetUnits().isConvertibleTo(dep0u)) {
                        jds.putProperty("DEPEND_0", dep0);
                    }
                }
            }
            ds = jds;
        }
        switch (ds.rank()) {
            case 3: {
                JoinDataSet result = new JoinDataSet(3);
                mon.setTaskSize((long)(ds.length() * 10));
                mon.started();
                Datum lastCadence = null;
                boolean sameCadence = true;
                int recCount = 0;
                for (int i = 0; i < ds.length(); ++i) {
                    mon.setTaskProgress((long)(i * 10));
                    QDataSet pow1 = Ops.fftPower(ds.slice(i), window, stepFraction, (ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)mon, (long)(i * 10), (long)((i + 1) * 10)));
                    recCount += pow1.length();
                    if (lastCadence == null) {
                        lastCadence = DataSetUtil.asDatum(((QDataSet)pow1.property("DEPEND_1")).slice(0));
                    } else if (!DataSetUtil.asDatum(((QDataSet)pow1.property("DEPEND_1")).slice(0)).equals(lastCadence)) {
                        sameCadence = false;
                    }
                    result.join(pow1);
                }
                if (sameCadence) {
                    QDataSet dep1 = (QDataSet)result.slice(0).property("DEPEND_1");
                    JoinDataSet newResult = new JoinDataSet(2);
                    DataSetBuilder xdsb = new DataSetBuilder(1, recCount);
                    for (int i = 0; i < result.length(); ++i) {
                        QDataSet result1 = result.slice(i);
                        QDataSet dep0 = (QDataSet)result1.property("DEPEND_0");
                        for (int j = 0; j < result1.length(); ++j) {
                            newResult.join(result1.slice(j));
                            xdsb.nextRecord(dep0.slice(j));
                        }
                    }
                    result = newResult;
                    result.putProperty("DEPEND_0", xdsb.getDataSet());
                    result.putProperty("DEPEND_1", dep1);
                }
                mon.finished();
                result.putProperty("QUBE", Boolean.TRUE);
                result.putProperty("SCALE_TYPE", "log");
                if (title != null) {
                    result.putProperty("TITLE", title);
                }
                if (userProperties != null) {
                    result.putProperty("USER_PROPERTIES", userProperties);
                }
                return result;
            }
            case 2: {
                QDataSet dep1;
                Units u0;
                JoinDataSet result = new JoinDataSet(2);
                result.putProperty("JOIN_0", null);
                int len = window.length();
                if (stepFraction < 0) {
                    throw new IllegalArgumentException(String.format("fractional step size (%d) is negative.", stepFraction));
                }
                if (stepFraction > 32) {
                    throw new IllegalArgumentException(String.format("fractional step size (%d) is bigger than 32, the max allowed.", stepFraction));
                }
                int step = len / stepFraction;
                boolean windowNonUnity = false;
                for (int i = 0; !windowNonUnity && i < len; ++i) {
                    if (window.value(i) == 1.0) continue;
                    windowNonUnity = true;
                }
                double normalization = windowNonUnity ? Ops.total(Ops.pow((Object)window, (Object)2)) / (double)window.length() : 1.0;
                int nsam = ds.length() * (ds.length(0) / step);
                DataSetBuilder dep0b = new DataSetBuilder(1, nsam);
                QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
                if (dep0 != null && UnitsUtil.isNominalMeasurement((Units)(u0 = SemanticOps.getUnits(dep0)))) {
                    dep0 = null;
                }
                if ((dep1 = (QDataSet)ds.property("DEPEND_1")) == null) {
                    dep1 = (QDataSet)ds.slice(0).property("DEPEND_0");
                }
                if (dep1 == null) {
                    dep1 = Ops.dindgen(ds.slice(0).length());
                }
                UnitsConverter uc = UnitsConverter.IDENTITY;
                QDataSet translation = null;
                Map user = userProperties;
                if (user != null && (translation = (QDataSet)user.get("FFT_Translation")) != null && translation.rank() == 1 && dep0 != null && translation.length() != dep0.length()) {
                    throw new IllegalArgumentException("rank 1 FFT_Translation should be the same length as depend_0");
                }
                if (translation != null) {
                    logger.fine("translation will be applied");
                }
                double currentDeltaTime = dep1.rank() == 1 ? (dep1.value(10) - dep1.value(0)) / 10.0 : (dep1.value(0, 10) - dep1.value(0, 0)) / 10.0;
                double lastDeltaTime = currentDeltaTime;
                int itt = 0;
                QDataSet tt = dep1.trim(0, len);
                while (itt + len < dep1.length() && !FFTUtil.uniformCadence(tt)) {
                    tt = dep1.trim(itt, itt + len);
                    itt += len;
                }
                QDataSet powxtags = FFTUtil.getFrequencyDomainTagsForPower(tt);
                double minD = Double.NEGATIVE_INFINITY;
                double maxD = Double.POSITIVE_INFINITY;
                if (dep1.rank() == 1) {
                    Units dep0Units;
                    QDataSet ytags = powxtags;
                    if (translation == null) {
                        result.putProperty("DEPEND_1", ytags);
                    }
                    Units dep1Units = (Units)dep1.property("UNITS");
                    Units units = dep0Units = dep0 == null ? null : (Units)dep0.property("UNITS");
                    if (dep0Units != null && dep1Units != null) {
                        uc = dep1Units.getConverter(dep0Units.getOffsetUnits());
                    }
                    if (dep0 != null && dep0.property("VALID_MIN") != null) {
                        minD = ((Number)dep0.property("VALID_MIN")).doubleValue();
                    }
                    if (dep0 != null && dep0.property("VALID_MAX") != null) {
                        maxD = ((Number)dep0.property("VALID_MAX")).doubleValue();
                    }
                }
                int len1 = (ds.length(0) - len) / step + 1;
                int len1D = ds.length(0) / step;
                mon.setTaskSize((long)(ds.length() * len1D));
                mon.started();
                mon.setProgressMessage("performing fftPower");
                boolean isMono = dep0 == null ? true : DataSetUtil.isMonotonic(dep0);
                double lastTranslation = -999.0;
                QDataSet nextSlice = null;
                for (int i = 0; i < ds.length(); ++i) {
                    QDataSet slicei;
                    if (nextSlice != null) {
                        slicei = nextSlice;
                        nextSlice = null;
                    } else {
                        slicei = ds.slice(i);
                    }
                    QDataSet dep0i = (QDataSet)slicei.property("DEPEND_0");
                    if (dep0i != null && dep0 == null) {
                        dep0b.putProperty("UNITS", dep0i.property("UNITS"));
                        if (!Boolean.TRUE.equals(dep0i.property("MONOTONIC"))) {
                            isMono = false;
                        }
                        minD = dep0i.property("VALID_MIN") != null ? ((Number)dep0i.property("VALID_MIN")).doubleValue() : Double.NEGATIVE_INFINITY;
                        maxD = dep0i.property("VALID_MAX") != null ? ((Number)dep0i.property("VALID_MAX")).doubleValue() : Double.POSITIVE_INFINITY;
                    }
                    for (int j = 0; j < len1D; ++j) {
                        double avgCadence;
                        boolean cadenceChangeDetect;
                        QDataSet offs;
                        QDataSet wave;
                        mon.setTaskProgress((long)(i * len1D + j));
                        int istart = j * step;
                        GeneralFFT fft = GeneralFFT.newDoubleFFT(len);
                        if (istart + len <= slicei.length()) {
                            wave = slicei.trim(istart, istart + len);
                            offs = dep1.rank() == 1 ? dep1.trim(istart, istart + len) : dep1.slice(i).trim(istart, istart + len);
                        } else if (i + 1 < ds.length()) {
                            QDataSet offs2;
                            QDataSet offs1;
                            if (nextSlice == null) {
                                nextSlice = ds.slice(i + 1);
                            }
                            QDataSet wave2 = nextSlice.trim(0, istart + len - slicei.length());
                            wave = Ops.append(slicei.trim(istart, slicei.length()), wave2);
                            assert (dep0 != null);
                            if (dep1.rank() == 1) {
                                offs1 = dep1.trim(istart, slicei.length());
                                offs2 = Ops.add(Ops.subtract(dep0.slice(i + 1), dep0.slice(i)), dep1.trim(0, istart + len - slicei.length()));
                            } else {
                                offs1 = dep1.slice(i).trim(istart, slicei.length());
                                offs2 = Ops.add(Ops.subtract(dep0.slice(i + 1), dep0.slice(i)), dep1.slice(i + 1).trim(0, istart + len - slicei.length()));
                            }
                            offs = Ops.append(offs1, offs2);
                        } else {
                            wave = null;
                            offs = null;
                        }
                        if (wave == null || offs == null) continue;
                        QDataSet waveDep0 = (QDataSet)wave.property("DEPEND_0");
                        if (waveDep0 != null) {
                            Datum t0 = Ops.datum(waveDep0.slice(0));
                            logger.log(Level.FINER, "fftPower t0:{0}", t0);
                        }
                        QDataSet wds = DataSetUtil.weightsDataSet(wave);
                        double d0 = 0.0;
                        if (dep0 != null) {
                            d0 = dep0.value(i) + uc.convert(offs.value(len / 2));
                        } else if (dep0i != null) {
                            d0 = dep0i.value(j * step + len / 2);
                        } else {
                            dep0b = null;
                        }
                        boolean hasFill = false;
                        for (int k = 0; k < wds.length(); ++k) {
                            if (wds.value(k) != 0.0) continue;
                            hasFill = true;
                        }
                        if (hasFill) {
                            logger.log(Level.FINER, "fill at {0}", Units.us2000.createDatum(d0));
                            continue;
                        }
                        double packetEndDeltaTime = (offs.value(len - 1) - offs.value(len - 11)) / 10.0;
                        boolean bl = cadenceChangeDetect = Math.abs(packetEndDeltaTime - currentDeltaTime) / currentDeltaTime > 0.01;
                        if (cadenceChangeDetect) {
                            logger.finer("cadence changes");
                        }
                        if (Math.abs(packetEndDeltaTime - (avgCadence = (offs.value(len - 1) - offs.value(0)) / (double)(len - 1))) / currentDeltaTime > 0.01) {
                            if (translation != null) {
                                logger.finer("gap detected");
                                continue;
                            }
                            logger.finer("gap detected");
                            continue;
                        }
                        currentDeltaTime = (offs.value(10) - offs.value(0)) / 10.0;
                        boolean newTranslationMode = false;
                        if (translation != null && translation.rank() == 1) {
                            boolean bl2 = newTranslationMode = translation.value(istart) != lastTranslation;
                        }
                        if (newTranslationMode || Math.abs(lastDeltaTime - currentDeltaTime) / currentDeltaTime > 0.01) {
                            QDataSet ytags;
                            QDataSet powxtags1 = FFTUtil.getFrequencyDomainTagsForPower(dep1.trim(istart, istart + len));
                            if (translation != null) {
                                switch (translation.rank()) {
                                    case 0: {
                                        powxtags1 = Ops.add(powxtags1, translation);
                                        lastTranslation = translation.value();
                                        break;
                                    }
                                    case 1: {
                                        powxtags1 = Ops.add(powxtags1, translation.slice(istart));
                                        lastTranslation = translation.value(istart);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("bad rank on FFT_Translation, expected rank 0 or rank 1");
                                    }
                                }
                            }
                            if ((ytags = (QDataSet)result.property("DEPEND_1")) instanceof CdfSparseDataSet) {
                                ((CdfSparseDataSet)ytags).putValues(result.length(), powxtags1);
                            } else {
                                if (ytags == null) {
                                    ytags = powxtags1;
                                }
                                CdfSparseDataSet newYtags = new CdfSparseDataSet(2, ds.length() * len1, ytags);
                                newYtags.putValues(result.length(), powxtags1);
                                newYtags.putProperty("UNITS", powxtags1.property("UNITS"));
                                ytags = newYtags;
                                result.putProperty("DEPEND_1", ytags);
                            }
                            powxtags = powxtags1;
                            lastDeltaTime = currentDeltaTime;
                        }
                        QDataSet vds = FFTUtil.fftPower(fft, wave, window, powxtags);
                        if (windowNonUnity) {
                            vds = Ops.multiply(vds, DataSetUtil.asDataSet(1.0 / normalization));
                        }
                        if (translation != null) {
                            QDataSet fftDep1 = (QDataSet)vds.property("DEPEND_0");
                            switch (translation.rank()) {
                                case 0: {
                                    fftDep1 = Ops.add(fftDep1, translation);
                                    break;
                                }
                                case 1: {
                                    fftDep1 = Ops.add(fftDep1, translation.slice(istart));
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("bad rank on FFT_Translation, expected rank 0 or rank 1");
                                }
                            }
                            ((MutablePropertyDataSet)vds).putProperty("DEPEND_0", fftDep1);
                        }
                        if (d0 >= minD && d0 <= maxD) {
                            if (translation == null) {
                                ((MutablePropertyDataSet)vds).putProperty("DEPEND_0", null);
                            }
                            result.join(vds);
                            if (dep0b != null) {
                                dep0b.putValue(-1, d0);
                                dep0b.nextRecord();
                            }
                        } else {
                            System.err.println("dropping record with invalid timetag: " + d0);
                        }
                        if (!mon.isCancelled()) continue;
                        throw new UncheckedCancelledOperationException("fftPower was cancelled");
                    }
                }
                mon.finished();
                QDataSet dep1_ = (QDataSet)result.property("DEPEND_1");
                if (dep1_ == null) {
                    dep1_ = (QDataSet)result.slice(0).property("DEPEND_0");
                }
                if (dep1_ != null && dep1_.rank() == 2 && dep1_.length() != result.length()) {
                    ((CdfSparseDataSet)dep1_).setLength(result.length());
                }
                if (dep0 != null && dep0b != null) {
                    dep0b.putProperty("UNITS", dep0.property("UNITS"));
                    if (isMono) {
                        dep0b.putProperty("MONOTONIC", true);
                    }
                    result.putProperty("DEPEND_0", dep0b.getDataSet());
                } else if (dep0b != null) {
                    if (isMono) {
                        dep0b.putProperty("MONOTONIC", true);
                    }
                    result.putProperty("DEPEND_0", dep0b.getDataSet());
                }
                if (title != null) {
                    result.putProperty("TITLE", title);
                }
                if (userProperties != null) {
                    result.putProperty("USER_PROPERTIES", userProperties);
                }
                if (translation != null && result.property("DEPEND_1") == null) {
                    JoinDataSet dep1jds = new JoinDataSet(2);
                    for (int i = 0; i < result.length(); ++i) {
                        QDataSet sl1 = (QDataSet)result.slice(i).property("DEPEND_0");
                        dep1jds.join(sl1);
                    }
                    dep1_ = dep1jds;
                    result.putProperty("DEPEND_1", dep1_);
                }
                if (dep1_.rank() == 1) {
                    result.putProperty("QUBE", Boolean.TRUE);
                }
                result.putProperty("SCALE_TYPE", "log");
                return result;
            }
        }
        throw new IllegalArgumentException("rank not supported: " + ds.rank());
    }

    private static QDataSet fftPowerRank2(QDataSet ds) {
        JoinDataSet result = new JoinDataSet(2);
        for (int i = 0; i < ds.length(); ++i) {
            GeneralFFT fft = GeneralFFT.newDoubleFFT(ds.length(i));
            QDataSet vds = FFTUtil.fftPower(fft, DataSetOps.slice0(ds, i));
            result.join(vds);
        }
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep1 != null && dep1.rank() == 1) {
            QDataSet ytags = FFTUtil.getFrequencyDomainTagsForPower(dep1);
            result.putProperty("DEPEND_1", ytags);
        }
        result.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        return result;
    }

    private static QDataSet fftPowerRank3(QDataSet ds) {
        JoinDataSet result = new JoinDataSet(3);
        for (int i = 0; i < ds.length(); ++i) {
            QDataSet vds = Ops.fftPowerRank2(DataSetOps.slice0(ds, i));
            result.join(vds);
        }
        result.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        return result;
    }

    public static QDataSet fftPower(QDataSet ds) {
        RankZeroDataSet cadence;
        if (ds.rank() == 2) {
            return Ops.fftPowerRank2(ds);
        }
        if (ds.rank() == 3) {
            return Ops.fftPowerRank3(ds);
        }
        GeneralFFT fft = GeneralFFT.newDoubleFFT(ds.length());
        ComplexArray.Double ca = FFTUtil.fft(fft, ds);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        RankZeroDataSet rankZeroDataSet = cadence = dep0 == null ? DRank0DataSet.create(1.0) : DataSetUtil.guessCadenceNew(dep0, null);
        if (cadence == null) {
            throw new IllegalArgumentException("can't establish data cadence");
        }
        double[] xtags = FFTUtil.getFrequencyDomainTags(1.0 / cadence.value(), ds.length());
        double binsize = 2.0 * xtags[xtags.length / 2] / (double)ds.length();
        Units invUnits = null;
        try {
            invUnits = UnitsUtil.getInverseUnit((Units)SemanticOps.getUnits(cadence));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DDataSet result = DDataSet.createRank1(ds.length() / 2);
        DDataSet resultDep0 = DDataSet.createRank1(ds.length() / 2);
        for (int i = 0; i < ds.length() / 2; ++i) {
            result.putValue(i, (double)(i == 0 ? 1 : 2) * ComplexArray.magnitude2(ca, i) / binsize);
            resultDep0.putValue(i, xtags[i]);
        }
        if (invUnits != null) {
            resultDep0.putProperty("UNITS", invUnits);
        }
        result.putProperty("DEPEND_0", resultDep0);
        return result;
    }

    public static QDataSet fft(QDataSet ds) {
        GeneralFFT fft = GeneralFFT.newDoubleFFT(ds.length());
        ComplexArray.Double cc = FFTUtil.fft(fft, ds);
        DDataSet result = DDataSet.createRank2(ds.length(), 2);
        for (int i = 0; i < ds.length(); ++i) {
            result.putValue(i, 0, cc.getReal(i));
            result.putValue(i, 1, cc.getImag(i));
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 == null) {
            dep0 = Ops.findgen(ds.length());
        }
        QDataSet tags = FFTUtil.getFrequencyDomainTags(dep0);
        result.putProperty("DEPEND_0", tags);
        QDataSet dep1 = Ops.complexCoordinateSystem();
        result.putProperty("DEPEND_1", dep1);
        return result;
    }

    public static QDataSet ifft(QDataSet ds) {
        GeneralFFT fft = GeneralFFT.newDoubleFFT(ds.length());
        ComplexArray.Double cc = FFTUtil.ifft(fft, ds);
        DDataSet result = DDataSet.createRank2(ds.length(), 2);
        for (int i = 0; i < ds.length(); ++i) {
            result.putValue(i, 0, cc.getReal(i));
            result.putValue(i, 1, cc.getImag(i));
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            QDataSet tags = FFTUtil.getTimeDomainTags(dep0);
            result.putProperty("DEPEND_0", tags);
        }
        QDataSet dep1 = Ops.complexCoordinateSystem();
        result.putProperty("DEPEND_1", dep1);
        return result;
    }

    public static final QDataSet complexConj(QDataSet ds) {
        QDataSet complexCoords = Ops.complexCoordinateSystem();
        if (ds.rank() == 1) {
            ArrayDataSet result = ArrayDataSet.copy(ds);
            result.putValue(1, -1.0 * ds.value(1));
            result.putProperty("DEPEND_0", complexCoords);
            return result;
        }
        if (ds.rank() == 2) {
            ArrayDataSet result = ArrayDataSet.copy(ds);
            for (int i = 0; i < ds.length(); ++i) {
                result.putValue(i, 1, -1.0 * ds.value(i, 1));
            }
            result.putProperty("DEPEND_1", complexCoords);
            return result;
        }
        if (ds.rank() == 3) {
            ArrayDataSet result = ArrayDataSet.copy(ds);
            for (int i = 0; i < ds.length(); ++i) {
                int n = ds.length(i);
                for (int j = 0; j < n; ++j) {
                    result.putValue(i, j, 1, -1.0 * ds.value(i, j, 1));
                }
            }
            result.putProperty("DEPEND_2", complexCoords);
            return result;
        }
        throw new IllegalArgumentException("unsupported rank in complexConj: " + ds.rank());
    }

    public static final QDataSet complexInvert(QDataSet ds1) {
        QDataSet imag;
        QDataSet real;
        if (!Schemes.isComplexNumbers(ds1)) {
            ds1 = Ops.complexDataset(ds1, null);
        }
        QDataSet denom = Ops.complexMultiply(ds1, Ops.complexConj(ds1));
        switch (ds1.rank()) {
            case 1: {
                real = Ops.slice0(ds1, 0);
                imag = Ops.slice0(ds1, 1);
                denom = Ops.slice0(denom, 0);
                break;
            }
            case 2: {
                real = Ops.slice1(ds1, 0);
                imag = Ops.slice1(ds1, 1);
                denom = Ops.slice1(denom, 0);
                break;
            }
            case 3: {
                real = Ops.slice2(ds1, 0);
                imag = Ops.slice2(ds1, 1);
                denom = Ops.slice2(denom, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("ds1 rank is too high, must be 1, 2, or 3: " + ds1);
            }
        }
        QDataSet result = Ops.complexDataset(Ops.divide(real, denom), Ops.multiply(-1, (Object)Ops.divide(imag, denom)));
        return result;
    }

    public static final QDataSet complexDivide(QDataSet ds1, QDataSet ds2) {
        if (ds1.rank() > 3) {
            throw new IllegalArgumentException("ds1 rank is too high, must be 1, 2, or 3: " + ds1);
        }
        if (ds2.rank() > 3) {
            throw new IllegalArgumentException("ds2 rank is too high, must be 1, 2, or 3: " + ds2);
        }
        if (!Schemes.isComplexNumbers(ds1)) {
            ds1 = Ops.complexDataset(ds1, null);
        }
        if (!Schemes.isComplexNumbers(ds2)) {
            ds2 = Ops.complexDataset(ds2, null);
        }
        return Ops.complexMultiply(ds1, Ops.complexInvert(ds2));
    }

    public static final QDataSet complexMultiply(QDataSet ds1, QDataSet ds2) {
        if (ds1.rank() > 3) {
            throw new IllegalArgumentException("ds1 rank is too high, must be 1, 2, or 3: " + ds1);
        }
        if (ds2.rank() > 3) {
            throw new IllegalArgumentException("ds2 rank is too high, must be 1, 2, or 3: " + ds2);
        }
        if (!Schemes.isComplexNumbers(ds1)) {
            ds1 = Ops.complexDataset(ds1, null);
        }
        if (!Schemes.isComplexNumbers(ds2)) {
            ds2 = Ops.complexDataset(ds2, null);
        }
        if (ds1.rank() == 1 && ds2.rank() == 2) {
            ds1 = Ops.replicate(ds1, ds2.length());
        }
        if (ds1.rank() == 2 && ds1.rank() == 1) {
            ds2 = Ops.replicate(ds2, ds1.length());
        }
        if (ds1.rank() != ds2.rank()) {
            throw new IllegalArgumentException("ds1 and ds2 must have the same rank");
        }
        QDataSet dep1 = Ops.complexCoordinateSystem();
        ArrayDataSet result = ArrayDataSet.copy(ds1);
        switch (ds1.rank()) {
            case 1: {
                result.putValue(0, ds1.value(0) * ds2.value(0) - ds1.value(1) * ds2.value(1));
                result.putValue(1, ds1.value(0) * ds2.value(1) + ds1.value(1) * ds2.value(0));
                result.putProperty("DEPEND_0", dep1);
                break;
            }
            case 2: {
                for (int i = 0; i < ds1.length(); ++i) {
                    result.putValue(i, 0, ds1.value(i, 0) * ds2.value(i, 0) - ds1.value(i, 1) * ds2.value(i, 1));
                    result.putValue(i, 1, ds1.value(i, 0) * ds2.value(i, 1) + ds1.value(i, 1) * ds2.value(i, 0));
                }
                result.putProperty("DEPEND_1", dep1);
                break;
            }
            case 3: {
                for (int i = 0; i < ds1.length(); ++i) {
                    for (int j = 0; j < ds1.length(i); ++j) {
                        result.putValue(i, j, 0, ds1.value(i, j, 0) * ds2.value(i, j, 0) - ds1.value(i, j, 1) * ds2.value(i, j, 1));
                        result.putValue(1, j, 1, ds1.value(i, j, 0) * ds2.value(i, j, 1) + ds1.value(i, j, 1) * ds2.value(i, j, 0));
                    }
                }
                result.putProperty("DEPEND_2", dep1);
                break;
            }
            default: {
                throw new IllegalArgumentException("rank not supported: " + ds1.rank());
            }
        }
        return result;
    }

    public static QDataSet crossProduct(QDataSet a, QDataSet b) {
        QDataSet bz;
        QDataSet by;
        QDataSet bx;
        QDataSet az;
        QDataSet ay;
        QDataSet ax;
        if (a.rank() == 1 && b.rank() == 1) {
            ax = a.slice(0);
            ay = a.slice(1);
            az = a.length() == 2 ? Ops.dataset(0) : a.slice(2);
            bx = b.slice(0);
            by = b.slice(1);
            bz = b.length() == 2 ? Ops.dataset(0) : b.slice(2);
        } else if (a.rank() == 1) {
            ax = a.slice(0);
            ay = a.slice(1);
            az = a.length() == 2 ? Ops.dataset(0) : a.slice(2);
            bx = Ops.unbundle(b, 0);
            by = Ops.unbundle(b, 1);
            bz = b.length(0) == 2 ? Ops.dataset(0) : Ops.unbundle(b, 2);
        } else if (b.rank() == 1) {
            ax = Ops.unbundle(a, 0);
            ay = Ops.unbundle(a, 1);
            az = a.length(0) == 2 ? Ops.dataset(0) : Ops.unbundle(a, 2);
            bx = b.slice(0);
            by = b.slice(1);
            bz = b.length() == 2 ? Ops.dataset(0) : b.slice(2);
        } else if (a.rank() == 2 && b.rank() == 2) {
            ax = Ops.unbundle(a, 0);
            ay = Ops.unbundle(a, 1);
            az = a.length(0) == 2 ? Ops.dataset(0) : Ops.unbundle(a, 2);
            bx = Ops.unbundle(b, 0);
            by = Ops.unbundle(b, 1);
            bz = b.length(0) == 2 ? Ops.dataset(0) : Ops.unbundle(b, 2);
        } else if (a.rank() == 3 && b.rank() == 3) {
            ax = Ops.slice2(a, 0);
            ay = Ops.slice2(a, 1);
            az = a.length(0, 0) == 2 ? Ops.dataset(0) : Ops.slice2(a, 2);
            bx = Ops.slice2(b, 0);
            by = Ops.slice2(b, 1);
            bz = b.length(0, 0) == 2 ? Ops.dataset(0) : Ops.slice2(b, 2);
        } else {
            throw new IllegalArgumentException("a and b must be either 3-element rank 1 datasets, or rank 2 n by 3-elements");
        }
        QDataSet cx = Ops.subtract(Ops.multiply(ay, bz), Ops.multiply(az, by));
        QDataSet cy = Ops.subtract(Ops.multiply(az, bx), Ops.multiply(ax, bz));
        QDataSet cz = Ops.subtract(Ops.multiply(ax, by), Ops.multiply(ay, bx));
        QDataSet tt = (QDataSet)cx.property("DEPEND_0");
        if (a.rank() < 3 && b.rank() < 3) {
            return Ops.link(tt, Ops.bundle(cx, cy, cz));
        }
        return Ops.link(tt, Ops.bundle(cx, cy, cz));
    }

    private static QDataSet complexCoordinateSystem() {
        return Schemes.complexCoordinateSystemDepend();
    }

    public static QDataSet complexDataset(QDataSet realPart, QDataSet imaginaryPart) {
        if (imaginaryPart == null) {
            DDataSet im = DDataSet.createRank0();
            im.putValue(0.0);
            imaginaryPart = im;
        }
        QDataSet[] operands = new QDataSet[2];
        CoerceUtil.coerce(realPart, imaginaryPart, false, operands);
        realPart = operands[0];
        imaginaryPart = operands[1];
        QDataSet result = Ops.bundle(realPart, imaginaryPart);
        MutablePropertyDataSet result1 = Ops.putProperty(result, "DEPEND_" + (result.rank() - 1), (Object)Ops.complexCoordinateSystem());
        DataSetUtil.copyDimensionProperties(realPart, result1);
        return result1;
    }

    public static QDataSet expandWaveform(QDataSet ds) {
        if (!Schemes.isRank2Waveform(ds)) {
            throw new IllegalArgumentException("dataset must be a rank 2 waveform");
        }
        QDataSet deltaT = (QDataSet)ds.property("DEPEND_1");
        QDataSet baseT = (QDataSet)ds.property("DEPEND_0");
        QDataSet cadence = Ops.reduceMin(Ops.diff(baseT), 0);
        QDataSet extent = Ops.extent(deltaT);
        QDataSet qf = Ops.multiply((Object)Ops.divide((Object)cadence, DataSetUtil.asDatumRange(extent).width()), 0.95);
        deltaT = Ops.multiply(deltaT, qf);
        ds = Ops.link(baseT, deltaT, ds);
        return ds;
    }

    public static QDataSet expandToFillGaps(QDataSet ds) {
        return Ops.expandToFillGaps(ds, 0.9);
    }

    public static QDataSet expandToFillGaps(QDataSet ds, Datum cadenceMin, double multiplier) {
        QDataSet ttags = (QDataSet)ds.property("DEPEND_0");
        Units toffUnits = ((Units)ttags.property("UNITS")).getOffsetUnits();
        QDataSet dts = Ops.abs(Ops.diff(ttags));
        int basei = 0;
        Datum baset = Ops.datum(ttags.slice(0));
        DataSetBuilder tb = new DataSetBuilder(1, ds.length());
        tb.setUnits((Units)ttags.property("UNITS"));
        tb.putValue(0, baset);
        Datum twiceCadenceMin = cadenceMin.multiply(2.0);
        for (int i = 1; i < ttags.length(); ++i) {
            if (Ops.datum(dts.slice(i - 1)).lt(twiceCadenceMin)) {
                tb.putValue(i, baset.add((ttags.value(i) - ttags.value(basei)) * multiplier, toffUnits));
                continue;
            }
            baset = Ops.datum(ttags.slice(i));
            basei = i;
            tb.putValue(i, baset);
        }
        DDataSet newTTags = tb.getDataSet();
        return Ops.link(newTTags, ds);
    }

    public static QDataSet expandToFillGaps(QDataSet ds, double factor) {
        if (Schemes.isRank2Waveform(ds)) {
            return Ops.expandWaveform(ds);
        }
        if (ds.rank() == 2) {
            Datum cadenceMin;
            Datum twiceCadenceMin;
            QDataSet ttags = (QDataSet)ds.property("DEPEND_0");
            QDataSet dts = Ops.abs(Ops.diff(ttags));
            QDataSet r = Ops.where(Ops.gt((Object)dts, twiceCadenceMin = (cadenceMin = Ops.datum(Ops.reduceMin(dts, 0))).multiply(2.0)));
            if (r.length() < 1) {
                return ds;
            }
            int[] startIndexes = new int[r.length() + 1];
            startIndexes[0] = 0;
            Datum cadenceMax = null;
            int count = 0;
            for (int i = 0; i < r.length(); ++i) {
                startIndexes[i + 1] = (int)r.value(i);
                Datum cadence = Ops.datum(Ops.subtract(ttags.slice(startIndexes[i + 1] + 1), ttags.slice(startIndexes[i])));
                if (cadenceMax != null && (!(cadence.value() > 0.0) || !cadence.lt(cadenceMax))) continue;
                cadenceMax = cadence;
                count = startIndexes[i + 1] + 1 - startIndexes[i];
            }
            assert (cadenceMax != null);
            logger.log(Level.FINE, "expandToFillGaps: cadenceMin={0} cadenceMax={1}", new Object[]{cadenceMin, cadenceMax});
            DataSetBuilder tb = new DataSetBuilder(1, ds.length());
            tb.setUnits((Units)ttags.property("UNITS"));
            double stepFactor = cadenceMax.divide(cadenceMin).divide((double)count).value();
            return Ops.expandToFillGaps(ds, cadenceMin, stepFactor * factor);
        }
        throw new IllegalArgumentException("data must be rank 2 spectrogram or waveform");
    }

    public static QDataSet identifyContinuousBlocks(Datum cadence, DatumRange extent, QDataSet lastBlocks, QDataSet times) {
        int lastBreakIndex;
        Datum lastBreak;
        if (extent == null) {
            extent = Ops.datumRange(Ops.extent(times));
        }
        if (cadence == null) {
            QDataSet cadenceDs = DataSetUtil.guessCadence(times, null);
            if (cadenceDs == null) {
                throw new IllegalArgumentException("Cadence is not specified and could not guess cadence of the data.");
            }
            cadence = DataSetUtil.asDatum(cadenceDs);
        }
        if (times == null) {
            throw new NullPointerException("times dataset is null");
        }
        Datum lastTime = extent.min();
        if (Ops.datum(times.slice(0)).subtract(lastTime).le(cadence)) {
            if (lastBlocks != null) {
                if (lastBlocks.property("partialBlockStart") != null) {
                    lastBreak = Ops.datum(lastBlocks.property("partialBlockStart"));
                    lastBreakIndex = (Integer)lastBlocks.property("partialBlockStartIndex");
                    if (lastBreak == null) {
                        lastBreak = Ops.datum(times.slice(0));
                        lastBreakIndex = 0;
                    }
                } else {
                    lastBreak = null;
                    lastBreakIndex = 0;
                }
            } else {
                lastBreak = lastTime = Ops.datum(times.slice(0));
                lastBreakIndex = 0;
            }
        } else {
            lastBreak = lastTime = Ops.datum(times.slice(0));
            lastBreakIndex = 0;
        }
        QDataSet events = null;
        for (int i = 0; i < times.length(); ++i) {
            Datum t = Ops.datum(times.slice(i));
            if (t.subtract(lastTime).gt(cadence)) {
                if (lastBreak != null) {
                    events = Ops.createEvent(events, DatumRange.newRange((Datum)lastBreak, (Datum)lastTime), 0, String.format("%d to %d", lastBreakIndex, i));
                }
                lastBreak = t;
                lastBreakIndex = i;
            }
            lastTime = t;
        }
        if (extent.max().subtract(lastTime).lt(cadence)) {
            if (events == null) {
                events = Ops.createEvent(events, DatumRange.newRange((Datum)lastBreak, (Datum)lastTime), 0, String.format("%d to %d", lastBreakIndex, times.length()));
            }
            events = Ops.putProperty(events, "partialBlockStart", (Object)lastBreak);
            events = Ops.putProperty(events, "partialBlockStartIndex", (Object)(lastBreakIndex - times.length()));
        } else if (lastBreak != null) {
            events = Ops.createEvent(events, DatumRange.newRange((Datum)lastBreak, (Datum)lastTime), 0, String.format("%d to %d", lastBreakIndex, times.length()));
        }
        return events;
    }

    public static QDataSet chirp(QDataSet t, Datum df0, Datum dt1, Datum df1) {
        Units tu = SemanticOps.getUnits(t);
        if (dt1.value() <= 0.0) {
            throw new IllegalArgumentException("dt1 must be greater than 0.");
        }
        t = Ops.putProperty(Ops.copy(t), "UNITS", null);
        double f0 = df0.value();
        double f1 = df1.value();
        double t1 = dt1.value();
        double phi = 0.0;
        QDataSet beta = Ops.divide((Object)Ops.subtract(f1, f0), t1);
        QDataSet phase = Ops.multiply(Ops.dataset(Math.PI * 2), Ops.add(Ops.multiply((Object)t, f0), Ops.multiply(Ops.multiply(0.5, (Object)beta), Ops.multiply(t, t))));
        t = Ops.putProperty(t, "UNITS", (Object)tu);
        return Ops.link(t, Ops.cos(Ops.add((Object)phase, phi *= Math.PI / 180)));
    }

    public static QDataSet hilbertSciPy(QDataSet ds) {
        int i;
        int N = ds.length();
        WritableDataSet ff = Ops.maybeCopy(Ops.fft(ds));
        double[] h = new double[N];
        if (N % 2 == 0) {
            h[0] = 1.0;
            for (i = 1; i < N / 2; ++i) {
                h[i] = 2.0;
            }
            h[N / 2] = 1.0;
            for (i = N / 2 + 1; i < N; ++i) {
                h[i] = 0.0;
            }
        } else {
            h[0] = 1.0;
            for (i = 1; i < N / 2; ++i) {
                h[i] = 2.0;
            }
            for (i = N / 2; i < N; ++i) {
                h[i] = 0.0;
            }
        }
        for (i = 0; i < N; ++i) {
            double t = ff.value(i, 1);
            ff.putValue(i, 0, h[i] * ff.value(i, 0));
            ff.putValue(i, 1, h[i] * t);
        }
        QDataSet result = Ops.ifft(ff);
        result = Ops.putProperty(result, "DEPEND_0", ds.property("DEPEND_0"));
        return result;
    }

    public static QDataSet hilbert(QDataSet ds) {
        QDataSet ff = Ops.fft(ds);
        WritableDataSet h2 = Ops.copy(ff);
        int n2 = h2.length() / 2;
        for (int i = 1; i < n2; ++i) {
            h2.putValue(i, 0, -1.0 * ff.value(i, 1));
            h2.putValue(i, 1, ff.value(i, 0));
        }
        int l = h2.length();
        for (int i = n2; i < l; ++i) {
            h2.putValue(i, 0, ff.value(i, 1));
            h2.putValue(i, 1, -1.0 * ff.value(i, 0));
        }
        WritableDataSet h = Ops.maybeCopy(Ops.ifft(h2));
        DataSetUtil.putProperties(DataSetUtil.getProperties(ds), h);
        return h;
    }

    public static QDataSet unwrap(QDataSet ds, double discont) {
        QDataSet d = Ops.diff(ds);
        Units u = SemanticOps.getUnits(d).getOffsetUnits();
        QDataSet h = Ops.dataset(discont / 2.0, u);
        d = Ops.subtract(Ops.modp(Ops.add(d, h), Ops.dataset(discont, u)), h);
        WritableDataSet result = Ops.maybeCopy(Ops.append(Ops.join(null, ds.slice(0)), Ops.accum(ds.slice(0), d)));
        DataSetUtil.putProperties(DataSetUtil.getProperties(ds), result);
        return result;
    }

    public static Double isAngleRange(QDataSet ds, boolean strict) {
        Units u = SemanticOps.getUnits(ds);
        if (u == Units.radians) {
            return 1.0;
        }
        if (u == Units.deg || u == Units.degrees) {
            return Math.PI / 180;
        }
        QDataSet extent = Ops.extent(ds);
        double delta = extent.value(1) - extent.value(0);
        if (u == Units.dimensionless && (delta > 160.0 && delta < 181.0 || delta > 320.0 && delta < 362.0)) {
            return Math.PI / 180;
        }
        if (u == Units.hours) {
            return 0.2617993877991494;
        }
        if (u == Units.dimensionless && (delta > 2.792526803190927 && delta < 3.159045946109736 || delta > 5.585053606381854 && delta < 6.318091892219472)) {
            return 1.0;
        }
        if (strict) {
            return null;
        }
        return Math.PI / 180;
    }

    public static QDataSet polarToCartesian(QDataSet ds) {
        QDataSet rad = Ops.unbundle(ds, 0);
        Units runits = SemanticOps.getUnits(rad);
        QDataSet angle = Ops.unbundle(ds, 1);
        Double mult = Ops.isAngleRange(angle, true);
        if (mult == null && (mult = Ops.isAngleRange(rad, true)) != null) {
            logger.fine("assuming first bundled dataset is angle");
            angle = rad;
            rad = Ops.unbundle(ds, 1);
        }
        WritableDataSet result = Ops.copy(ds);
        for (int i = 0; i < result.length(); ++i) {
            double r = rad.value(i);
            double x = r * Ops.cos(angle.value(i) * mult);
            double y = r * Ops.sin(angle.value(i) * mult);
            result.putValue(i, 0, x);
            result.putValue(i, 1, y);
        }
        QDataSet b1 = (QDataSet)ds.property("BUNDLE_1");
        if (b1 != null) {
            WritableDataSet wb1 = Ops.copy(b1);
            Ops.copyIndexedProperties(b1, wb1);
            wb1.putProperty("LABEL", 0, "X");
            wb1.putProperty("LABEL", 1, "Y");
            wb1.putProperty("TITLE", 0, "X");
            wb1.putProperty("TITLE", 1, "Y");
            wb1.putProperty("UNITS", 0, runits);
            wb1.putProperty("UNITS", 1, runits);
            result.putProperty("BUNDLE_1", wb1);
        }
        return result;
    }

    public static QDataSet ifft(QDataSet ds, QDataSet window, int stepFraction, ProgressMonitor mon) {
        Units u0;
        String title = (String)ds.property("TITLE");
        if (title != null) {
            title = "IFFT of " + title;
        }
        if (ds.rank() < 3 || ds.rank() > 4) {
            throw new IllegalArgumentException("rank exception, expected rank 3 or 4: got " + ds);
        }
        if (ds.rank() == 4) {
            JoinDataSet result = new JoinDataSet(4);
            mon.setTaskSize((long)(ds.length() * 10));
            mon.started();
            for (int i = 0; i < ds.length(); ++i) {
                mon.setTaskProgress((long)(i * 10));
                QDataSet pow1 = Ops.ifft(ds.slice(i), window, stepFraction, (ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)mon, (long)(i * 10), (long)((i + 1) * 10)));
                result.join(pow1);
            }
            mon.finished();
            result.putProperty("QUBE", Boolean.TRUE);
            if (title != null) {
                result.putProperty("TITLE", title);
            }
            return result;
        }
        assert (ds.rank() == 3);
        int len = window.length();
        if (stepFraction < 0) {
            throw new IllegalArgumentException(String.format("fractional step size (%d) is negative.", stepFraction));
        }
        if (stepFraction > 32) {
            throw new IllegalArgumentException(String.format("fractional step size (%d) is bigger than 32, the max allowed.", stepFraction));
        }
        int step = len / stepFraction;
        boolean windowNonUnity = false;
        for (int i = 0; !windowNonUnity && i < len; ++i) {
            if (window.value(i) == 1.0) continue;
            windowNonUnity = true;
        }
        double normalization = windowNonUnity ? Ops.total(Ops.pow((Object)window, (Object)2)) / (double)window.length() : 1.0;
        JoinDataSet result = new JoinDataSet(3);
        result.putProperty("JOIN_0", null);
        int nsam = ds.length() * (ds.length(0) / step);
        DataSetBuilder dep0Builder = new DataSetBuilder(1, nsam);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null && UnitsUtil.isNominalMeasurement((Units)(u0 = SemanticOps.getUnits(dep0)))) {
            dep0 = null;
        }
        UnitsConverter uc = UnitsConverter.IDENTITY;
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep1 == null && (dep1 = (QDataSet)ds.slice(0).property("DEPEND_0")) == null) {
            logger.finer("No time offsets found.");
        }
        QDataSet ytags = null;
        double minD = Double.NEGATIVE_INFINITY;
        double maxD = Double.POSITIVE_INFINITY;
        if (dep1 != null && dep1.rank() == 1) {
            Units dep0Units;
            ytags = FFTUtil.getTimeDomainTags(dep1.trim(0, len));
            result.putProperty("DEPEND_1", ytags);
            Units dep1Units = (Units)dep1.property("UNITS");
            Units units = dep0Units = dep0 == null ? null : (Units)dep0.property("UNITS");
            if (dep0Units != null && dep1Units != null) {
                uc = UnitsConverter.IDENTITY;
            }
            if (dep0 != null && dep0.property("VALID_MIN") != null) {
                minD = ((Number)dep0.property("VALID_MIN")).doubleValue();
            }
            if (dep0 != null && dep0.property("VALID_MAX") != null) {
                maxD = ((Number)dep0.property("VALID_MAX")).doubleValue();
            }
        } else {
            throw new IllegalArgumentException("must have ytags...");
        }
        int len1 = (ds.length(0) - len) / step + 1;
        mon.setTaskSize((long)(ds.length() * len1));
        mon.started();
        mon.setProgressMessage("performing ifft");
        boolean isMono = dep0 == null ? true : DataSetUtil.isMonotonic(dep0);
        for (int i = 0; i < ds.length(); ++i) {
            QDataSet slicei = ds.slice(i);
            QDataSet dep0i = (QDataSet)slicei.property("DEPEND_0");
            if (dep0i != null && dep0 == null) {
                dep0Builder.putProperty("UNITS", dep0i.property("UNITS"));
                if (!Boolean.TRUE.equals(dep0i.property("MONOTONIC"))) {
                    isMono = false;
                }
                minD = dep0i.property("VALID_MIN") != null ? ((Number)dep0i.property("VALID_MIN")).doubleValue() : Double.NEGATIVE_INFINITY;
                maxD = dep0i.property("VALID_MAX") != null ? ((Number)dep0i.property("VALID_MAX")).doubleValue() : Double.POSITIVE_INFINITY;
            }
            for (int j = 0; j < len1; ++j) {
                GeneralFFT fft = GeneralFFT.newDoubleFFT(len);
                QDataSet wave = slicei.trim(j * step, j * step + len);
                QDataSet wds = DataSetUtil.weightsDataSet(wave);
                boolean hasFill = false;
                for (int k = 0; k < wds.length(); ++k) {
                    if (wds.value(k, 0) != 0.0) continue;
                    hasFill = true;
                }
                if (hasFill) continue;
                QDataSet vds = FFTUtil.ifft(fft, wave, null);
                if (windowNonUnity) {
                    vds = Ops.multiply(vds, DataSetUtil.asDataSet(1.0 / normalization));
                }
                double d0 = 0.0;
                if (dep0 != null && ytags != null) {
                    d0 = dep0.value(i) + uc.convert(ytags.value(j * step + len / 2));
                } else if (dep0 != null) {
                    d0 = dep0.value(i);
                } else if (dep0i != null) {
                    d0 = dep0i.value(j * step + len / 2);
                } else {
                    dep0Builder = null;
                }
                if (d0 >= minD && d0 <= maxD) {
                    result.join(vds);
                    if (dep0Builder != null) {
                        dep0Builder.putValue(-1, d0);
                        dep0Builder.nextRecord();
                    }
                } else {
                    System.err.println("dropping record with invalid timetag: " + d0);
                }
                mon.setTaskProgress((long)(i * len1 + j));
            }
        }
        mon.finished();
        if (dep0 != null && dep0Builder != null) {
            dep0Builder.putProperty("UNITS", dep0.property("UNITS"));
            if (isMono) {
                dep0Builder.putProperty("MONOTONIC", true);
            }
            result.putProperty("DEPEND_0", dep0Builder.getDataSet());
        } else if (dep0Builder != null) {
            if (isMono) {
                dep0Builder.putProperty("MONOTONIC", true);
            }
            result.putProperty("DEPEND_0", dep0Builder.getDataSet());
        }
        if (title != null) {
            result.putProperty("TITLE", title);
        }
        result.putProperty("QUBE", Boolean.TRUE);
        return result;
    }

    public static QDataSet fft(QDataSet ds, QDataSet window, int stepFraction, ProgressMonitor mon) {
        Units u0;
        String title;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        if ((title = (String)ds.property("TITLE")) != null) {
            title = "FFT of " + title;
        }
        if (ds.rank() < 1 || ds.rank() > 3) {
            throw new IllegalArgumentException("rank exception, expected rank 1,2 or 3: got " + ds);
        }
        if (ds.rank() == 1) {
            QDataSet c = (QDataSet)ds.property("CONTEXT_0");
            JoinDataSet jds = new JoinDataSet(ds);
            if (c != null && c.rank() == 0) {
                Units dep0u = (Units)c.property("UNITS");
                JoinDataSet dep0 = new JoinDataSet(c);
                if (dep0u != null) {
                    dep0.putProperty("UNITS", dep0u);
                    jds.putProperty("DEPEND_0", dep0);
                }
            }
            ds = jds;
        } else if (ds.rank() == 3) {
            JoinDataSet result = new JoinDataSet(3);
            mon.setTaskSize((long)(ds.length() * 10));
            mon.started();
            for (int i = 0; i < ds.length(); ++i) {
                mon.setTaskProgress((long)(i * 10));
                QDataSet pow1 = Ops.fft(ds.slice(i), window, stepFraction, (ProgressMonitor)SubTaskMonitor.create((ProgressMonitor)mon, (long)(i * 10), (long)((i + 1) * 10)));
                result.join(pow1);
            }
            mon.finished();
            result.putProperty("QUBE", Boolean.TRUE);
            if (title != null) {
                result.putProperty("TITLE", title);
            }
            return result;
        }
        int len = window.length();
        if (stepFraction < 0) {
            throw new IllegalArgumentException(String.format("fractional step size (%d) is negative.", stepFraction));
        }
        if (stepFraction > 32) {
            throw new IllegalArgumentException(String.format("fractional step size (%d) is bigger than 32, the max allowed.", stepFraction));
        }
        int step = len / stepFraction;
        boolean windowNonUnity = false;
        for (int i = 0; !windowNonUnity && i < len; ++i) {
            if (window.value(i) == 1.0) continue;
            windowNonUnity = true;
        }
        double normalization = windowNonUnity ? Ops.total(Ops.pow((Object)window, (Object)2)) / (double)window.length() : 1.0;
        JoinDataSet result = new JoinDataSet(3);
        result.putProperty("JOIN_0", null);
        int nsam = ds.length() * (ds.length(0) / step);
        DataSetBuilder dep0b = new DataSetBuilder(1, nsam);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null && UnitsUtil.isNominalMeasurement((Units)(u0 = SemanticOps.getUnits(dep0)))) {
            dep0 = null;
        }
        UnitsConverter uc = UnitsConverter.IDENTITY;
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep1 == null) {
            dep1 = (QDataSet)ds.slice(0).property("DEPEND_0");
        }
        double minD = Double.NEGATIVE_INFINITY;
        double maxD = Double.POSITIVE_INFINITY;
        if (dep1 != null && dep1.rank() == 1) {
            Units dep0Units;
            QDataSet ytags = FFTUtil.getFrequencyDomainTags(dep1.trim(0, len));
            result.putProperty("DEPEND_1", ytags);
            Units dep1Units = (Units)dep1.property("UNITS");
            Units units = dep0Units = dep0 == null ? null : (Units)dep0.property("UNITS");
            if (dep0Units != null && dep1Units != null) {
                uc = dep1Units.getConverter(dep0Units.getOffsetUnits());
            }
            if (dep0 != null && dep0.property("VALID_MIN") != null) {
                minD = ((Number)dep0.property("VALID_MIN")).doubleValue();
            }
            if (dep0 != null && dep0.property("VALID_MAX") != null) {
                maxD = ((Number)dep0.property("VALID_MAX")).doubleValue();
            }
        }
        int len1 = (ds.length(0) - len) / step + 1;
        mon.setTaskSize((long)(ds.length() * len1));
        mon.started();
        mon.setProgressMessage("performing fft");
        boolean isMono = dep0 == null ? true : DataSetUtil.isMonotonic(dep0);
        for (int i = 0; i < ds.length(); ++i) {
            QDataSet slicei = ds.slice(i);
            QDataSet dep0i = (QDataSet)slicei.property("DEPEND_0");
            if (dep0i != null && dep0 == null) {
                dep0b.putProperty("UNITS", dep0i.property("UNITS"));
                if (!Boolean.TRUE.equals(dep0i.property("MONOTONIC"))) {
                    isMono = false;
                }
                minD = dep0i.property("VALID_MIN") != null ? ((Number)dep0i.property("VALID_MIN")).doubleValue() : Double.NEGATIVE_INFINITY;
                maxD = dep0i.property("VALID_MAX") != null ? ((Number)dep0i.property("VALID_MAX")).doubleValue() : Double.POSITIVE_INFINITY;
            }
            for (int j = 0; j < len1; ++j) {
                GeneralFFT fft = GeneralFFT.newDoubleFFT(len);
                QDataSet wave = slicei.trim(j * step, j * step + len);
                QDataSet wds = DataSetUtil.weightsDataSet(wave);
                boolean hasFill = false;
                for (int k = 0; k < wds.length(); ++k) {
                    if (wds.value(k) != 0.0) continue;
                    hasFill = true;
                }
                if (hasFill) continue;
                QDataSet vds = FFTUtil.fft(fft, wave, windowNonUnity ? wds : null);
                if (windowNonUnity) {
                    vds = Ops.multiply(vds, DataSetUtil.asDataSet(1.0 / normalization));
                }
                double d0 = 0.0;
                if (dep0 != null && dep1 != null) {
                    d0 = dep0.value(i) + uc.convert(dep1.value(j * step + len / 2));
                } else if (dep0 != null) {
                    d0 = dep0.value(i);
                } else if (dep0i != null) {
                    d0 = dep0i.value(j * step + len / 2);
                } else {
                    dep0b = null;
                }
                if (d0 >= minD && d0 <= maxD) {
                    result.join(vds);
                    if (dep0b != null) {
                        dep0b.putValue(-1, d0);
                        dep0b.nextRecord();
                    }
                } else {
                    System.err.println("dropping record with invalid timetag: " + d0);
                }
                mon.setTaskProgress((long)(i * len1 + j));
            }
        }
        mon.finished();
        if (dep0 != null && dep0b != null) {
            dep0b.putProperty("UNITS", dep0.property("UNITS"));
            if (isMono) {
                dep0b.putProperty("MONOTONIC", true);
            }
            result.putProperty("DEPEND_0", dep0b.getDataSet());
        } else if (dep0b != null) {
            if (isMono) {
                dep0b.putProperty("MONOTONIC", true);
            }
            result.putProperty("DEPEND_0", dep0b.getDataSet());
        }
        if (title != null) {
            result.putProperty("TITLE", title);
        }
        result.putProperty("QUBE", Boolean.TRUE);
        result.putProperty("DEPEND_2", Ops.complexCoordinateSystem());
        return result;
    }

    public static QDataSet fftWindow(QDataSet ds, int len) {
        QDataSet result = WaveformToSpectrum.getTableDataSet(ds, len);
        return result;
    }

    public static QDataSet extent(QDataSet ds) {
        return Ops.extent(ds, null);
    }

    public static QDataSet extent(QDataSet ds, QDataSet range) {
        if (ds == null) {
            throw new IllegalArgumentException("dataset is null");
        }
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        return Ops.extent(ds, wds, range);
    }

    public static QDataSet extentSimple(QDataSet ds, QDataSet wds, QDataSet range) {
        int ifirst;
        boolean monoCheck;
        int ilast;
        double[] result;
        Number dfill;
        double fill;
        logger.entering(CLASSNAME, "extentSimple");
        if (ds == null) {
            throw new IllegalArgumentException("dataset is null");
        }
        int count = 0;
        if (wds == null) {
            wds = DataSetUtil.weightsDataSet(ds);
        }
        double d = fill = (dfill = (Number)wds.property("SUGGEST_FILL")) != null ? dfill.doubleValue() : -1.0E31;
        if (range == null) {
            result = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        } else {
            result = new double[]{range.value(0), range.value(1)};
            if (range.value(0) == fill) {
                System.err.println("range passed into extent contained fill");
            }
        }
        QDataSet min = ds;
        QDataSet max = ds;
        if (ds.rank() == 2 && SemanticOps.isBins(ds)) {
            min = Ops.slice1(ds, 0);
            max = Ops.slice1(ds, 1);
            ds = min;
            wds = Ops.slice1(wds, 0);
        }
        if (ds.rank() > 0) {
            int n = ds.length();
            ilast = n - 1;
            monoCheck = Boolean.TRUE.equals(ds.property("MONOTONIC"));
            if (ds.rank() == 1 && monoCheck && n > 0) {
                for (ifirst = 0; ifirst < n && wds.value(ifirst) == 0.0; ++ifirst) {
                }
                while (ilast >= 0 && wds.value(ilast) == 0.0) {
                    --ilast;
                }
                int imiddle = (ifirst + ilast) / 2;
                if (wds.value(imiddle) > 0.0) {
                    double dir = ds.value(ilast) - ds.value(ifirst);
                    if ((ds.value(imiddle) - ds.value(ifirst)) * dir < 0.0) {
                        logger.fine("this data isn't really monotonic.");
                        monoCheck = false;
                    }
                }
            }
        } else {
            monoCheck = false;
            ifirst = 0;
            ilast = 0;
        }
        if (ds.rank() == 1 && monoCheck) {
            count = Math.max(0, ilast - ifirst + 1);
            if (count > 0) {
                result[0] = Math.min(result[0], ds.value(ifirst));
                result[1] = Math.max(result[1], ds.value(ilast));
            } else {
                result[0] = range == null ? fill : range.value(0);
                double d2 = result[1] = range == null ? fill : range.value(1);
            }
            if (result[0] > result[1]) {
                double t = result[1];
                result[1] = result[0];
                result[0] = t;
            }
        } else {
            QubeDataSetIterator it = new QubeDataSetIterator(ds);
            while (it.hasNext()) {
                it.next();
                if (!(it.getValue(wds) > 0.0)) continue;
                ++count;
                result[0] = Math.min(result[0], it.getValue(min));
                result[1] = Math.max(result[1], it.getValue(max));
            }
            if (count == 0) {
                result[0] = fill;
                result[1] = fill;
            }
        }
        DDataSet qresult = DDataSet.wrap(result);
        qresult.putProperty("SCALE_TYPE", ds.property("SCALE_TYPE"));
        qresult.putProperty("USER_PROPERTIES", Collections.singletonMap("count", count));
        qresult.putProperty("BINS_0", "min,maxInclusive");
        qresult.putProperty("UNITS", ds.property("UNITS"));
        if (result[0] == fill) {
            qresult.putProperty("FILL_VALUE", fill);
        }
        logger.exiting(CLASSNAME, "extentSimple");
        return qresult;
    }

    public static QDataSet extent(QDataSet ds, QDataSet wds, QDataSet range) {
        boolean monoCheck;
        int ilast;
        int ifirst;
        double[] result;
        Number dfill;
        double fill;
        Units u;
        logger.entering(CLASSNAME, "extent");
        if (!DataSetUtil.validate(ds, null)) {
            throw new IllegalArgumentException("data does not validate: " + ds);
        }
        QDataSet max = ds;
        QDataSet min = ds;
        QDataSet deltaplus = (QDataSet)ds.property("DELTA_PLUS");
        QDataSet deltaminus = (QDataSet)ds.property("DELTA_MINUS");
        if (ds.property("BIN_PLUS") != null) {
            deltaplus = (QDataSet)ds.property("BIN_PLUS");
        }
        if (ds.property("BIN_MINUS") != null) {
            deltaminus = (QDataSet)ds.property("BIN_MINUS");
        }
        if (deltaplus != null) {
            u = SemanticOps.getUnits(deltaplus);
            deltaplus = Ops.greaterOf(u.createDatum(0), (Object)deltaplus);
        }
        if (deltaminus != null) {
            u = SemanticOps.getUnits(deltaminus);
            deltaminus = Ops.greaterOf(u.createDatum(0), (Object)deltaminus);
        }
        if (ds.rank() == 2 && SemanticOps.isBins(ds)) {
            min = Ops.slice1(ds, 0);
            max = Ops.slice1(ds, 1);
            ds = min;
            if (wds != null) {
                wds = Ops.slice1(wds, 0);
            }
        }
        if (ds.property("BIN_MAX") != null) {
            max = (QDataSet)ds.property("BIN_MAX");
        }
        if (ds.property("BIN_MIN") != null) {
            min = (QDataSet)ds.property("BIN_MIN");
        }
        int count = 0;
        if (wds == null) {
            wds = DataSetUtil.weightsDataSet(ds);
        }
        double d = fill = (dfill = (Number)wds.property("SUGGEST_FILL")) != null ? dfill.doubleValue() : -1.0E31;
        if (range == null) {
            result = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        } else {
            result = new double[]{range.value(0), range.value(1)};
            if (range.value(0) == fill) {
                logger.warning("range passed into extent contained fill");
            }
        }
        if (ds.rank() > 0) {
            ifirst = 0;
            int n = ds.length();
            ilast = n - 1;
            monoCheck = Boolean.TRUE.equals(ds.property("MONOTONIC"));
            if (ds.rank() == 1 && monoCheck && n > 0) {
                monoCheck = DataSetUtil.isMonotonicQuick(ds);
                if (!monoCheck) {
                    logger.log(Level.WARNING, "this data isn''t really monotonic: {0}", ds);
                }
                if (monoCheck) {
                    while (wds.value(ilast) == 0.0 && ilast > 0) {
                        --ilast;
                    }
                    if (ilast < ifirst) {
                        ilast = ifirst;
                    }
                }
            }
        } else {
            monoCheck = false;
            ifirst = 0;
            ilast = 0;
        }
        if (ds.rank() == 1 && monoCheck && deltaplus == null) {
            count = Math.max(0, ilast - ifirst + 1);
            if (count > 0) {
                result[0] = Math.min(result[0], min.value(ifirst));
                result[1] = Math.max(result[1], max.value(ilast));
            } else {
                result[0] = range == null ? fill : range.value(0);
                double d2 = result[1] = range == null ? fill : range.value(1);
            }
            if (result[0] > result[1]) {
                double t = result[1];
                result[1] = result[0];
                result[0] = t;
            }
        } else {
            if (deltaplus != null) {
                max = Ops.add(max, deltaplus);
            }
            if (deltaminus != null) {
                min = Ops.subtract(min, deltaminus);
            }
            switch (ds.rank()) {
                case 1: {
                    int i;
                    int ni = min.length();
                    for (i = 0; i < ni; ++i) {
                        if (!(wds.value(i) > 0.0)) continue;
                        ++count;
                        double a = result[0];
                        double b = min.value(i);
                        result[0] = a <= b ? a : b;
                        a = result[1];
                        b = max.value(i);
                        result[1] = a >= b ? a : b;
                    }
                    break;
                }
                case 2: {
                    int i;
                    int ni = min.length();
                    for (i = 0; i < ni; ++i) {
                        int nj = min.length(i);
                        for (int j = 0; j < nj; ++j) {
                            if (!(wds.value(i, j) > 0.0)) continue;
                            ++count;
                            result[0] = Math.min(result[0], min.value(i, j));
                            result[1] = Math.max(result[1], max.value(i, j));
                        }
                    }
                    break;
                }
                default: {
                    QubeDataSetIterator it = new QubeDataSetIterator(ds);
                    while (it.hasNext()) {
                        it.next();
                        if (!(it.getValue(wds) > 0.0)) continue;
                        ++count;
                        result[0] = Math.min(result[0], it.getValue(min));
                        result[1] = Math.max(result[1], it.getValue(max));
                    }
                    break block0;
                }
            }
            if (count == 0) {
                result[0] = fill;
                result[1] = fill;
            }
        }
        DDataSet qresult = DDataSet.wrap(result);
        qresult.putProperty("SCALE_TYPE", ds.property("SCALE_TYPE"));
        qresult.putProperty("USER_PROPERTIES", Collections.singletonMap("count", count));
        qresult.putProperty("BINS_0", "min,maxInclusive");
        qresult.putProperty("UNITS", ds.property("UNITS"));
        String format = (String)ds.property("FORMAT");
        if (format != null) {
            qresult.putProperty("FORMAT", format);
        }
        if (result[0] == fill) {
            qresult.putProperty("FILL_VALUE", fill);
        }
        logger.exiting(CLASSNAME, "extent");
        return qresult;
    }

    public static QDataSet extent445(QDataSet ds) {
        return Ops.extentSimple(ds, null);
    }

    public static QDataSet extentSimple(QDataSet ds, QDataSet range) {
        Number nfill;
        logger.entering(CLASSNAME, "extentSimple");
        QDataSet max = ds;
        QDataSet min = ds;
        if (ds.rank() == 2 && SemanticOps.isBins(ds)) {
            min = Ops.slice1(ds, 0);
            max = Ops.slice1(ds, 1);
            ds = min;
        }
        double fill = (nfill = (Number)ds.property("FILL_VALUE")) == null ? 1.0E38 : nfill.doubleValue();
        int count = 0;
        double[] result = range == null ? new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY} : new double[]{range.value(0), range.value(1)};
        QDataSet valid = Ops.valid(ds);
        switch (ds.rank()) {
            case 1: {
                int n = ds.length();
                for (int i = 0; i < n; ++i) {
                    if (!(valid.value(i) > 0.0)) continue;
                    double min1 = min.value(i);
                    result[0] = result[0] < min1 ? result[0] : min1;
                    double max1 = max.value(i);
                    result[1] = result[1] > max1 ? result[1] : max1;
                    ++count;
                }
                break;
            }
            case 2: {
                int n0 = ds.length();
                for (int i0 = 0; i0 < n0; ++i0) {
                    int n1 = ds.length(i0);
                    for (int i1 = 0; i1 < n1; ++i1) {
                        if (!(valid.value(i0, i1) > 0.0)) continue;
                        double min1 = min.value(i0, i1);
                        result[0] = result[0] < min1 ? result[0] : min1;
                        double max1 = max.value(i0, i1);
                        result[1] = result[1] > max1 ? result[1] : max1;
                        ++count;
                    }
                }
                break;
            }
            case 3: {
                int n0 = ds.length();
                for (int i0 = 0; i0 < n0; ++i0) {
                    int n1 = ds.length(i0);
                    for (int i1 = 0; i1 < n1; ++i1) {
                        int n2 = ds.length(i0, i1);
                        for (int i2 = 0; i2 < n2; ++i2) {
                            if (!(valid.value(i0, i1, i2) > 0.0)) continue;
                            double min1 = min.value(i0, i1, i2);
                            result[0] = result[0] < min1 ? result[0] : min1;
                            double max1 = max.value(i0, i1, i2);
                            result[1] = result[1] > max1 ? result[1] : max1;
                            ++count;
                        }
                    }
                }
                break;
            }
            case 4: {
                int n0 = ds.length();
                for (int i0 = 0; i0 < n0; ++i0) {
                    int n1 = ds.length(i0);
                    for (int i1 = 0; i1 < n1; ++i1) {
                        int n2 = ds.length(i0, i1);
                        for (int i2 = 0; i2 < n2; ++i2) {
                            int n3 = ds.length(i0, i1, i2);
                            for (int i3 = 0; i3 < n3; ++i3) {
                                if (!(valid.value(i0, i1, i2, i3) > 0.0)) continue;
                                result[0] = Math.min(result[0], min.value(i0, i1, i2, i3));
                                result[1] = Math.max(result[1], max.value(i0, i1, i2, i3));
                                ++count;
                            }
                        }
                    }
                }
                break;
            }
            case 0: {
                result[0] = ds.value();
                result[1] = ds.value();
                ++count;
                break;
            }
        }
        DDataSet qresult = DDataSet.wrap(result);
        qresult.putProperty("SCALE_TYPE", ds.property("SCALE_TYPE"));
        qresult.putProperty("USER_PROPERTIES", Collections.singletonMap("count", count));
        qresult.putProperty("BINS_0", "min,maxInclusive");
        qresult.putProperty("UNITS", ds.property("UNITS"));
        if (result[0] == fill) {
            qresult.putProperty("FILL_VALUE", fill);
        }
        logger.exiting(CLASSNAME, "extentSimple");
        return qresult;
    }

    public static QDataSet rescale(QDataSet data, QDataSet min, QDataSet max) {
        QDataSet extent = Ops.extent(data);
        QDataSet w = Ops.subtract(extent.slice(1), extent.slice(0));
        if (w.value() == 0.0) {
            switch (data.rank()) {
                case 0: {
                    return min;
                }
                case 1: {
                    return Ops.replicate(min, data.length());
                }
                case 2: {
                    return Ops.replicate(min, data.length(), data.length(0));
                }
                case 3: {
                    return Ops.multiply(min, Ops.ones(data.length(), data.length(0), data.length(0, 0)));
                }
                case 4: {
                    return Ops.multiply(min, Ops.ones(data.length(), data.length(0), data.length(0, 0), data.length(0, 0, 0)));
                }
            }
        }
        QDataSet xxx = Ops.divide(Ops.subtract(data, extent.slice(0)), w);
        xxx = Ops.multiply(xxx, Ops.subtract(max, min));
        data = Ops.add(min, xxx);
        return data;
    }

    public static QDataSet rescaleRange(QDataSet dr, double min, double max) {
        if (dr.rank() != 1) {
            throw new IllegalArgumentException("Rank must be 1");
        }
        if (dr.length() != 2) {
            throw new IllegalArgumentException("length must be 2");
        }
        double w = dr.value(1) - dr.value(0);
        if (Double.isInfinite(w) || Double.isNaN(w)) {
            throw new RuntimeException("width is not finite in rescaleRange");
        }
        if (w == 0.0) {
            throw new RuntimeException("width is zero in rescaleRange!");
        }
        DDataSet result = DDataSet.createRank1(2);
        result.putValue(0, dr.value(0) + w * min);
        result.putValue(1, dr.value(0) + w * max);
        DataSetUtil.copyDimensionProperties(dr, result);
        result.putProperty("BINS_0", dr.property("BINS_0"));
        return result;
    }

    public static QDataSet rescaleRangeLogLin(QDataSet dr, double min, double max) {
        if (dr.rank() != 1) {
            throw new IllegalArgumentException("Rank must be 1");
        }
        if (dr.length() != 2) {
            throw new IllegalArgumentException("length must be 2");
        }
        DDataSet result = DDataSet.createRank1(2);
        if ("log".equals(dr.property("SCALE_TYPE"))) {
            double s1 = Math.log10(dr.value(0));
            double s2 = Math.log10(dr.value(1));
            double w = s2 - s1;
            if (Double.isInfinite(w) || Double.isNaN(w)) {
                throw new RuntimeException("width is not finite in rescaleRangeLogLin");
            }
            if (w == 0.0) {
                throw new RuntimeException("width is zero in rescaleRangeLogLin!");
            }
            s2 = Math.pow(10.0, s1 + max * w);
            s1 = Math.pow(10.0, s1 + min * w);
            result.putValue(0, s1);
            result.putValue(1, s2);
        } else {
            double w = dr.value(1) - dr.value(0);
            if (Double.isInfinite(w) || Double.isNaN(w)) {
                throw new RuntimeException("width is not finite in rescaleRangeLogLin");
            }
            if (w == 0.0) {
                throw new RuntimeException("width is zero in rescaleRangeLogLin!");
            }
            result.putValue(0, dr.value(0) + w * min);
            result.putValue(1, dr.value(0) + w * max);
        }
        DataSetUtil.copyDimensionProperties(dr, result);
        result.putProperty("BINS_0", dr.property("BINS_0"));
        return result;
    }

    public static QDataSet histogram2d(QDataSet x, QDataSet y, int[] bins, QDataSet xrange, QDataSet yrange) {
        int ny;
        int nx;
        if (bins == null) {
            nx = 20;
            ny = 20;
        } else {
            nx = bins[0];
            ny = bins[1];
        }
        if (SemanticOps.getUnits(xrange) == Units.dimensionless) {
            xrange = Ops.putProperty(xrange, "UNITS", (Object)SemanticOps.getUnits(x));
        }
        if (SemanticOps.getUnits(yrange) == Units.dimensionless) {
            yrange = Ops.putProperty(yrange, "UNITS", (Object)SemanticOps.getUnits(y));
        }
        if (x == null) {
            throw new NullPointerException("x is null");
        }
        if (y == null) {
            throw new NullPointerException("y is null");
        }
        if (xrange.rank() != 1 || xrange.length() != 2) {
            throw new IllegalArgumentException("xrange should be rank 1, two-element dataset");
        }
        if (yrange.rank() != 1 || yrange.length() != 2) {
            throw new IllegalArgumentException("yrange should be rank 1, two-element dataset");
        }
        double minx = xrange.value(0);
        double miny = yrange.value(0);
        double binsizex = (xrange.value(1) - xrange.value(0)) / (double)nx;
        double binsizey = (yrange.value(1) - yrange.value(0)) / (double)ny;
        MutablePropertyDataSet xtags = DataSetUtil.tagGenDataSet(nx, minx + binsizex / 2.0, binsizex, SemanticOps.getUnits(xrange));
        xtags.putProperty("NAME", x.property("NAME"));
        xtags.putProperty("LABEL", x.property("LABEL"));
        xtags.putProperty("TITLE", x.property("TITLE"));
        xtags.putProperty("TYPICAL_MAX", x.property("TYPICAL_MAX"));
        xtags.putProperty("TYPICAL_MIN", x.property("TYPICAL_MIN"));
        MutablePropertyDataSet ytags = DataSetUtil.tagGenDataSet(ny, miny + binsizey / 2.0, binsizey, SemanticOps.getUnits(yrange));
        ytags.putProperty("NAME", y.property("NAME"));
        ytags.putProperty("LABEL", y.property("LABEL"));
        ytags.putProperty("TITLE", y.property("TITLE"));
        ytags.putProperty("TYPICAL_MAX", y.property("TYPICAL_MAX"));
        ytags.putProperty("TYPICAL_MIN", y.property("TYPICAL_MIN"));
        int[] hits = new int[nx * ny];
        QubeDataSetIterator iter = new QubeDataSetIterator(x);
        QDataSet wdsx = DataSetUtil.weightsDataSet(x);
        QDataSet wdsy = DataSetUtil.weightsDataSet(y);
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            double x1 = iter.getValue(x);
            double y1 = iter.getValue(y);
            double w = iter.getValue(wdsx) * iter.getValue(wdsy);
            if (!(w > 0.0)) continue;
            int ibinx = (int)Math.floor((x1 - minx) / binsizex);
            int ibiny = (int)Math.floor((y1 - miny) / binsizey);
            if (ibinx >= 0 && ibinx < nx && ibiny >= 0 && ibiny < ny) {
                int n = ibinx * ny + ibiny;
                hits[n] = hits[n] + 1;
            }
            ++count;
        }
        IDataSet result = IDataSet.wrap(hits, new int[]{nx, ny});
        result.putProperty("DEPEND_0", xtags);
        result.putProperty("DEPEND_1", ytags);
        result.putProperty("count", count);
        result.putProperty("RENDER_TYPE", "nnSpectrogram");
        return result;
    }

    public static QDataSet histogram(QDataSet ds, double min, double max, double binSize) {
        return DataSetOps.histogram(ds, min, max, binSize);
    }

    public static QDataSet histogram(QDataSet ds, Datum min, Datum max, Datum binsize) {
        Units u = SemanticOps.getUnits(ds);
        return Ops.histogram(ds, min.doubleValue(u), max.doubleValue(u), binsize.doubleValue(u.getOffsetUnits()));
    }

    public static QDataSet histogram(QDataSet ds, String min, String max, String binsize) throws ParseException {
        Units u = SemanticOps.getUnits(ds);
        return Ops.histogram(ds, u.parse(min), u.parse(max), u.getOffsetUnits().parse(binsize));
    }

    public static QDataSet histogram(QDataSet ds, int binCount) {
        if ("log".equals(ds.property("SCALE_TYPE"))) {
            QDataSet linds = Ops.log10(ds);
            QDataSet range = Ops.extent(linds);
            double width = range.value(1) - range.value(0);
            MutablePropertyDataSet h = (MutablePropertyDataSet)Ops.histogram(linds, range.value(0), range.value(1), width / (double)binCount);
            MutablePropertyDataSet bins = (MutablePropertyDataSet)h.property("DEPEND_0");
            bins = (MutablePropertyDataSet)Ops.exp10(bins);
            bins.putProperty("SCALE_TYPE", "log");
            bins.putProperty("LABEL", ds.property("LABEL"));
            bins.putProperty("TITLE", ds.property("TITLE"));
            h.putProperty("DEPEND_0", bins);
            return h;
        }
        QDataSet range = Ops.extent(ds);
        double width = range.value(1) - range.value(0);
        return Ops.histogram(ds, range.value(0), range.value(1), width / (double)binCount);
    }

    public static QDataSet autoHistogram(QDataSet ds) {
        if (ds == null) {
            throw new NullPointerException("ds is null");
        }
        AutoHistogram ah = new AutoHistogram();
        return ah.doit(ds);
    }

    public static QDataSet outerProduct(QDataSet ds1, QDataSet ds2) {
        if (ds1.rank() != 1) {
            throw new IllegalArgumentException("rank must be 1: ds1");
        }
        if (ds2.rank() != 1) {
            throw new IllegalArgumentException("rank must be 1: ds2");
        }
        QDataSet w1 = DataSetUtil.weightsDataSet(ds1);
        QDataSet w2 = DataSetUtil.weightsDataSet(ds2);
        double fill = -1.0E38;
        boolean hasFill = false;
        DDataSet result = DDataSet.createRank2(ds1.length(), ds2.length());
        for (int i = 0; i < ds1.length(); ++i) {
            for (int j = 0; j < ds2.length(); ++j) {
                if (w1.value(i) * w2.value(j) > 0.0) {
                    result.putValue(i, j, ds1.value(i) * ds2.value(j));
                    continue;
                }
                result.putValue(i, j, fill);
                hasFill = true;
            }
        }
        result.putProperty("DEPEND_0", ds1.property("DEPEND_0"));
        result.putProperty("DEPEND_1", ds2.property("DEPEND_0"));
        if (hasFill) {
            result.putProperty("FILL_VALUE", fill);
        }
        Units units1 = SemanticOps.getUnits(ds1);
        Units units2 = SemanticOps.getUnits(ds2);
        Units units = units1 == Units.dimensionless ? units2 : (units2 == Units.dimensionless ? units1 : Ops.multiplyUnits(units1, units2));
        if (units != Units.dimensionless) {
            result.putProperty("UNITS", units);
        }
        return result;
    }

    public static QDataSet outerProduct(Object ds1, Object ds2) {
        return Ops.outerProduct(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet outerSum(QDataSet ds1, QDataSet ds2) {
        QDataSet w1 = DataSetUtil.weightsDataSet(ds1);
        QDataSet w2 = DataSetUtil.weightsDataSet(ds2);
        double fill = -1.0E38;
        boolean hasFill = false;
        DDataSet result = DDataSet.createRank2(ds1.length(), ds2.length());
        HashMap<String, Object> props = new HashMap<String, Object>();
        BinaryOp b = Ops.addGen(ds1, ds2, props);
        for (int i = 0; i < ds1.length(); ++i) {
            for (int j = 0; j < ds2.length(); ++j) {
                if (w1.value(i) * w2.value(j) > 0.0) {
                    result.putValue(i, j, b.op(ds1.value(i), ds2.value(j)));
                    continue;
                }
                result.putValue(i, j, fill);
                hasFill = true;
            }
        }
        result.putProperty("DEPEND_0", ds2.property("DEPEND_0"));
        result.putProperty("DEPEND_1", ds2.property("DEPEND_0"));
        if (hasFill) {
            result.putProperty("FILL_VALUE", fill);
        }
        result.putProperty("UNITS", props.get("UNITS"));
        return result;
    }

    public static QDataSet outerSum(Object ds1, Object ds2) {
        return Ops.outerSum(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static QDataSet floor(QDataSet ds1) {
        return Ops.applyUnaryOp(ds1, (double a) -> Math.floor(a));
    }

    public static double floor(double x) {
        return Math.floor(x);
    }

    public static QDataSet floor(Object ds1) {
        return Ops.floor(Ops.dataset(ds1));
    }

    public static QDataSet ceil(QDataSet ds1) {
        return Ops.applyUnaryOp(ds1, (double a) -> Math.ceil(a));
    }

    public static double ceil(double x) {
        return Math.ceil(x);
    }

    public static QDataSet ceil(Object x) {
        return Ops.ceil(Ops.dataset(x));
    }

    public static QDataSet round(QDataSet ds1) {
        return Ops.applyUnaryOp(ds1, (double a) -> Math.round(a));
    }

    public static double round(double x) {
        return Math.round(x);
    }

    public static QDataSet round(Object x) {
        return Ops.round(Ops.dataset(x));
    }

    public static QDataSet round(QDataSet ds1, int ndigits) {
        double res = Math.pow(10.0, ndigits);
        return Ops.applyUnaryOp(ds1, (double a) -> (double)Math.round(a * res) / res);
    }

    public static double round(double x, int ndigits) {
        double res = Math.pow(10.0, ndigits);
        return (double)Math.round(x * res) / res;
    }

    public static QDataSet round(Object ds1, int ndigits) {
        return Ops.round(Ops.dataset(ds1), ndigits);
    }

    public static QDataSet signum(QDataSet ds1) {
        return Ops.applyUnaryOp(ds1, (double a) -> Math.signum(a));
    }

    public static double signum(double x) {
        return Math.signum(x);
    }

    public static QDataSet signum(Object x) {
        return Ops.signum(Ops.dataset(x));
    }

    public static QDataSet copysign(QDataSet magnitude, QDataSet sign) {
        return Ops.applyBinaryOp(magnitude, sign, (double m, double s) -> {
            double s1 = Math.signum(s);
            return Math.abs(m) * (s1 == 0.0 ? 1.0 : s1);
        });
    }

    public static double copysign(double x, double y) {
        return Math.abs(x) * Math.signum(y);
    }

    public static QDataSet copysign(Object x, Object y) {
        return Ops.multiply(Ops.abs(Ops.dataset(x)), Ops.signum(Ops.dataset(y)));
    }

    public static QDataSet whereSequence(QDataSet ds, QDataSet seq) {
        DataSetBuilder builder = new DataSetBuilder(1, 100);
        int n = ds.length();
        int ifind = 0;
        int nfind = seq.length();
        for (int i = 0; i < n; ++i) {
            if (ds.value(i) == seq.value(ifind)) {
                if (++ifind != nfind) continue;
                builder.nextRecord(i - nfind + 1);
                ifind = 0;
                continue;
            }
            ifind = ds.value(i) == seq.value(0) ? 1 : 0;
        }
        builder.putProperty("CADENCE", DataSetUtil.asDataSet(1.0));
        builder.putProperty("FORMAT", "%d");
        return builder.getDataSet();
    }

    public static QDataSet findex(QDataSet uu, QDataSet vv) {
        if (uu == null) {
            throw new IllegalArgumentException("uu parameter of findex is null");
        }
        if (vv == null) {
            throw new IllegalArgumentException("vv parameter of findex is null");
        }
        if (uu.length() == 0) {
            throw new IllegalArgumentException("uu has length=0");
        }
        if (uu.rank() != 1) {
            throw new IllegalArgumentException("uu must be rank 1");
        }
        if (!DataSetUtil.isMonotonic(uu)) {
            DataSetUtil.isMonotonic(uu);
            throw new IllegalArgumentException("u must be monotonic");
        }
        if (!DataSetUtil.isMonotonicAndIncreasingQuick(uu)) {
            if (Ops.reduceMin(Ops.diff(uu), 0).value() == 0.0) {
                throw new IllegalArgumentException("u must be non-repeating");
            }
            throw new IllegalArgumentException("u must be monotonically increasing and non-repeating");
        }
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(vv));
        QubeDataSetIterator it = new QubeDataSetIterator(vv);
        int ic0 = 0;
        int ic1 = 1;
        double uc0 = uu.value(ic0);
        double uc1 = uu.value(ic1);
        int n = uu.length();
        Units vvunits = SemanticOps.getUnits(vv);
        Units uuunits = SemanticOps.getUnits(uu);
        QDataSet ww = DataSetUtil.weightsDataSet(vv);
        UnitsConverter uc = UnitsConverter.getConverter((Units)vvunits, (Units)uuunits);
        double fill = -1.0E31;
        boolean hasFill = false;
        int extentWarning = 0;
        while (it.hasNext()) {
            double ff;
            it.next();
            double d = uc.convert(it.getValue(vv));
            double w = it.getValue(ww);
            if (w == 0.0) {
                it.putValue(result, fill);
                hasFill = true;
                continue;
            }
            if (uc0 <= d && d <= uc1) {
                double ff2;
                double d2 = ff2 = d == uc0 ? 0.0 : (d - uc0) / (uc1 - uc0);
                if (((double)ic0 + ff2) / (double)n < -3.0 || ((double)ic0 + ff2 - (double)n) / (double)n > 3.0) {
                    ++extentWarning;
                }
                it.putValue(result, (double)ic0 + ff2);
                continue;
            }
            int index = DataSetUtil.binarySearch(uu, d, 0, uu.length() - 1);
            if (index == -1) {
                ic0 = 0;
                ic1 = 1;
            } else if (index < -n) {
                ic0 = n - 2;
                ic1 = n - 1;
            } else if (index < 0) {
                ic1 = ~index;
                ic0 = ic1 - 1;
            } else if (index >= n - 1) {
                ic0 = n - 2;
                ic1 = n - 1;
            } else {
                ic0 = index;
                ic1 = index + 1;
            }
            uc0 = uu.value(ic0);
            uc1 = uu.value(ic1);
            double d3 = ff = d == uc0 ? 0.0 : (d - uc0) / (uc1 - uc0);
            if (((double)ic0 + ff) / (double)n < -3.0 || ((double)ic0 + ff - (double)n) / (double)n > 3.0) {
                ++extentWarning;
            }
            it.putValue(result, (double)ic0 + ff);
        }
        if (extentWarning > 0) {
            logger.log(Level.WARNING, "alarming extrapolation in findex is suspicious: count:{0} uu:{1} vv:{2}", new Object[]{extentWarning, Ops.extent(uu), Ops.extent(vv)});
        }
        if (result.rank() == 1) {
            result.putProperty("DEPEND_0", vv);
        }
        if (hasFill) {
            result.putProperty("FILL_VALUE", fill);
        }
        return result;
    }

    public static QDataSet findex(Object x, Object y) {
        return Ops.findex(Ops.dataset(x), Ops.dataset(y));
    }

    private static boolean isDimensionless(QDataSet ds) {
        Units u = (Units)ds.property("UNITS");
        return u == null || u == Units.dimensionless;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QDataSet interpolate(QDataSet vv, QDataSet findex) {
        if (vv.rank() == 2) {
            QDataSet result = null;
            for (int j = 0; j < vv.length(0); ++j) {
                QDataSet vvj = Ops.interpolate(Ops.unbundle(vv, j), findex);
                result = Ops.bundle(result, vvj);
            }
            QDataSet dep1 = (QDataSet)vv.property("DEPEND_1");
            if (dep1 != null) {
                if (dep1.rank() == 2 && findex.rank() == 1) {
                    if (Ops.reduceMax(Ops.mod((Object)findex, 1), 0).value() != 0.0) throw new IllegalArgumentException("interpolate used on data which is not a qube");
                    result = Ops.putProperty(result, "DEPEND_1", (Object)Ops.interpolate(dep1, findex));
                } else {
                    result = Ops.putProperty(result, "DEPEND_1", (Object)dep1);
                }
            }
            QDataSet bds = (QDataSet)vv.property("BUNDLE_1");
            return Ops.putProperty(result, "BUNDLE_1", (Object)bds);
        }
        if (vv.rank() != 1) {
            throw new IllegalArgumentException("dataset to be interpolated is not rank1");
        }
        if (!Ops.isDimensionless(findex)) {
            throw new IllegalArgumentException("findex argument should be dimensionless, expected output from findex command.");
        }
        QDataSet fex0 = Ops.extent(findex);
        if ((fex0.value(1) - (double)vv.length()) / (double)vv.length() > 100.0) {
            logger.warning("findex looks suspicious, where its max would result in unrealistic extrapolations");
        }
        if (fex0.value(0) / (double)vv.length() < -100.0) {
            logger.warning("findex looks suspicious, where its min would result in unrealistic extrapolations");
        }
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(findex));
        QubeDataSetIterator it = new QubeDataSetIterator(findex);
        int ic0 = 0;
        int ic1 = 0;
        int n = vv.length();
        QDataSet wds = DataSetUtil.weightsDataSet(vv);
        Number fill = (Number)wds.property("FILL_VALUE");
        double dfill = fill == null ? -1.0E38 : fill.doubleValue();
        result.putProperty("FILL_VALUE", dfill);
        boolean hasFill = false;
        QDataSet wfindex = DataSetUtil.weightsDataSet(findex);
        wfindex = Ops.copy(wfindex);
        boolean noExtrapolate = true;
        String averageType = (String)vv.property("AVERAGE_TYPE");
        if (averageType == null) {
            averageType = "linear";
        }
        double vmin = -1.7976931348623157E308;
        double vmax = Double.MAX_VALUE;
        if (!averageType.equals("linear")) {
            Number v = (Number)vv.property("TYPICAL_MIN");
            if (v == null) {
                v = (Number)vv.property("VALID_MIN");
            }
            if (v != null) {
                vmin = v.doubleValue();
            }
            if ((v = (Number)vv.property("TYPICAL_MAX")) == null) {
                v = (Number)vv.property("VALID_MAX");
            }
            if (v != null) {
                vmax = v.doubleValue();
            }
        }
        while (it.hasNext()) {
            it.next();
            if (it.getValue(wfindex) == 0.0) {
                it.putValue(result, dfill);
                hasFill = true;
                continue;
            }
            double ff = it.getValue(findex);
            if (ff >= 0.0 && ff < (double)(n - 1)) {
                ic0 = (int)Math.floor(ff);
                ic1 = ic0 + 1;
            } else {
                if (noExtrapolate && ff < -0.5) {
                    it.putValue(result, dfill);
                    hasFill = true;
                    continue;
                }
                if (noExtrapolate && ff > (double)n - 0.5) {
                    it.putValue(result, dfill);
                    hasFill = true;
                    continue;
                }
                if (ff < 0.0) {
                    ic0 = 0;
                    ic1 = 1;
                } else if (ff >= (double)(n - 1)) {
                    ic0 = n - 2;
                    ic1 = n - 1;
                }
            }
            double alpha = ff - (double)ic0;
            if (alpha == 0.0 || alpha == 1.0 || averageType.equals("none")) {
                double v = alpha < 0.5 ? (wds.value(ic0) > 0.0 ? vv.value(ic0) : dfill) : (wds.value(ic1) > 0.0 ? vv.value(ic1) : dfill);
                it.putValue(result, v);
                continue;
            }
            if (wds.value(ic0) > 0.0 && wds.value(ic1) > 0.0) {
                double vv0 = vv.value(ic0);
                double vv1 = vv.value(ic1);
                switch (averageType) {
                    case "linear": {
                        it.putValue(result, vv0 + alpha * (vv1 - vv0));
                        break;
                    }
                    case "geometric": {
                        it.putValue(result, Math.exp(Math.log(vv0) + alpha * (vv1 / vv0)));
                        break;
                    }
                    case "mod24": {
                        while (vv1 - vv0 > 12.0) {
                            vv1 -= 24.0;
                        }
                        while (vv0 - vv1 > 12.0) {
                            vv0 -= 24.0;
                        }
                        double v = vv0 + alpha * (vv1 - vv0);
                        if (v < vmin) {
                            v += 24.0;
                        }
                        if (v >= vmax) {
                            v -= 24.0;
                        }
                        it.putValue(result, v);
                        break;
                    }
                    case "mod360": {
                        while (vv1 - vv0 > 180.0) {
                            vv1 -= 360.0;
                        }
                        while (vv0 - vv1 > 180.0) {
                            vv0 -= 360.0;
                        }
                        double v = vv0 + alpha * (vv1 - vv0);
                        if (v < vmin) {
                            v += 360.0;
                        }
                        if (v >= vmax) {
                            v -= 360.0;
                        }
                        it.putValue(result, v);
                        break;
                    }
                    case "modpi": {
                        while (vv1 - vv0 > 1.5707963267948966) {
                            vv1 -= Math.PI;
                        }
                        while (vv0 - vv1 > 1.5707963267948966) {
                            vv0 -= Math.PI;
                        }
                        double v = vv0 + alpha * (vv1 - vv0);
                        if (v < vmin) {
                            v += Math.PI;
                        }
                        if (v >= vmax) {
                            v -= Math.PI;
                        }
                        it.putValue(result, v);
                        break;
                    }
                    case "modtau": {
                        while (vv1 - vv0 > Math.PI) {
                            vv1 -= Math.PI * 2;
                        }
                        while (vv0 - vv1 > Math.PI) {
                            vv0 -= Math.PI * 2;
                        }
                        double v = vv0 + alpha * (vv1 - vv0);
                        if (v < vmin) {
                            v += Math.PI * 2;
                        }
                        if (v >= vmax) {
                            v -= Math.PI * 2;
                        }
                        it.putValue(result, v);
                        break;
                    }
                    case "none": {
                        double v = alpha < 0.5 ? vv0 : vv1;
                        it.putValue(result, v);
                    }
                }
                continue;
            }
            it.putValue(result, dfill);
            hasFill = true;
        }
        DataSetUtil.copyDimensionProperties(vv, result);
        for (int i = 0; i <= findex.rank(); ++i) {
            QDataSet depend = (QDataSet)findex.property("DEPEND_" + i);
            if (depend == null) continue;
            result.putProperty("DEPEND_" + i, depend);
        }
        if (!hasFill) return result;
        result.putProperty("FILL_VALUE", dfill);
        return result;
    }

    public static QDataSet interpolate(Object vv, Object findex) {
        return Ops.interpolate(Ops.dataset(vv), Ops.dataset(findex));
    }

    public static QDataSet interpolate(QDataSet vv, QDataSet findex0, QDataSet findex1) {
        QDataSet fex1;
        QDataSet fex0;
        if (findex0.rank() > 0 && findex0.length() != findex1.length()) {
            throw new IllegalArgumentException("findex0 and findex1 must have the same geometry.");
        }
        if (!Ops.isDimensionless(findex0)) {
            throw new IllegalArgumentException("findex0 argument should be dimensionless, expected output from findex command.");
        }
        if (!Ops.isDimensionless(findex1)) {
            throw new IllegalArgumentException("findex1 argument should be dimensionless, expected output from findex command.");
        }
        if (!DataSetUtil.checkQube(vv)) {
            logger.warning("vv is not a qube");
        }
        if (((fex0 = Ops.extent(findex0)).value(1) - (double)vv.length()) / (double)vv.length() > 100.0) {
            logger.warning("findex0 looks suspicious, where its max would result in unrealistic extrapolations");
        }
        if (fex0.value(0) / (double)vv.length() < -100.0) {
            logger.warning("findex0 looks suspicious, where its min would result in unrealistic extrapolations");
        }
        if (((fex1 = Ops.extent(findex1)).value(1) - (double)vv.length(0)) / (double)vv.length(0) > 100.0) {
            logger.warning("findex1 looks suspicious, where its max would result in unrealistic extrapolations");
        }
        if (fex1.value(0) / (double)vv.length(0) < -100.0) {
            logger.warning("findex1 looks suspicious, where its min would result in unrealistic extrapolations");
        }
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(findex0));
        QDataSet wds = DataSetUtil.weightsDataSet(vv);
        QubeDataSetIterator it = new QubeDataSetIterator(findex0);
        int ic00 = 0;
        int ic01 = 0;
        int ic10 = 0;
        int ic11 = 0;
        int n0 = vv.length();
        int n1 = vv.length(0);
        double fill = -1.0E38;
        boolean hasFill = false;
        boolean noExtrapolate = true;
        while (it.hasNext()) {
            it.next();
            double ff0 = it.getValue(findex0);
            double ff1 = it.getValue(findex1);
            if (ff0 >= 0.0 && ff0 < (double)(n0 - 1)) {
                ic00 = (int)Math.floor(ff0);
                ic01 = ic00 + 1;
            } else {
                if (noExtrapolate && ff0 < -0.5) {
                    it.putValue(result, fill);
                    hasFill = true;
                    continue;
                }
                if (noExtrapolate && ff0 >= (double)n0 - 0.5) {
                    it.putValue(result, fill);
                    hasFill = true;
                    continue;
                }
                if (ff0 < 0.0) {
                    ic00 = 0;
                    ic01 = 1;
                } else if (ff0 >= (double)(n0 - 1)) {
                    ic00 = n0 - 2;
                    ic01 = n0 - 1;
                }
            }
            if (ff1 >= 0.0 && ff1 < (double)(n1 - 1)) {
                ic10 = (int)Math.floor(ff1);
                ic11 = ic10 + 1;
            } else {
                if (noExtrapolate && ff1 < -0.5) {
                    it.putValue(result, fill);
                    hasFill = true;
                    continue;
                }
                if (noExtrapolate && ff1 >= (double)n1 - 0.5) {
                    it.putValue(result, fill);
                    hasFill = true;
                    continue;
                }
                if (ff1 < 0.0) {
                    ic10 = 0;
                    ic11 = 1;
                } else if (ff1 >= (double)(n1 - 1)) {
                    ic10 = n1 - 2;
                    ic11 = n1 - 1;
                }
            }
            double alpha0 = ff0 - (double)ic00;
            double alpha1 = ff1 - (double)ic10;
            double vv00 = vv.value(ic00, ic10);
            double vv01 = vv.value(ic00, ic11);
            double vv10 = vv.value(ic01, ic10);
            double vv11 = vv.value(ic01, ic11);
            double ww00 = wds.value(ic00, ic10);
            double ww01 = wds.value(ic00, ic11);
            double ww10 = wds.value(ic01, ic10);
            double ww11 = wds.value(ic01, ic11);
            if (ww00 * ww01 * ww10 * ww11 > 0.0) {
                double beta0 = 1.0 - alpha0;
                double beta1 = 1.0 - alpha1;
                double value = vv00 * beta0 * beta1 + vv01 * beta0 * alpha1 + vv10 * alpha0 * beta1 + vv11 * alpha0 * alpha1;
                it.putValue(result, value);
                continue;
            }
            it.putValue(result, fill);
            hasFill = true;
        }
        DataSetUtil.copyDimensionProperties(vv, result);
        for (int i = 0; i <= findex0.rank(); ++i) {
            QDataSet depend = (QDataSet)findex0.property("DEPEND_" + i);
            if (depend == null) continue;
            result.putProperty("DEPEND_" + i, depend);
        }
        if (hasFill) {
            result.putProperty("FILL_VALUE", fill);
        }
        return result;
    }

    public static QDataSet interpolate(Object vv, Object findex0, Object findex1) {
        return Ops.interpolate(Ops.dataset(vv), Ops.dataset(findex0), Ops.dataset(findex1));
    }

    public static QDataSet interpolate(QDataSet vv, QDataSet findex0, QDataSet findex1, QDataSet findex2) {
        QDataSet fex2;
        QDataSet fex1;
        QDataSet fex0;
        if (vv.rank() != 3) {
            throw new IllegalArgumentException("vv must be rank 3");
        }
        if (findex0.rank() > 0 && findex0.length() != findex1.length() && findex0.length() != findex2.length()) {
            throw new IllegalArgumentException("findex0, findex1, and findex2 must have the same geometry.");
        }
        if (!Ops.isDimensionless(findex0)) {
            throw new IllegalArgumentException("findex0 argument should be dimensionless, expected output from findex command.");
        }
        if (!Ops.isDimensionless(findex1)) {
            throw new IllegalArgumentException("findex1 argument should be dimensionless, expected output from findex command.");
        }
        if (!Ops.isDimensionless(findex2)) {
            throw new IllegalArgumentException("findex2 argument should be dimensionless, expected output from findex command.");
        }
        if (!DataSetUtil.checkQube(vv)) {
            logger.warning("vv is not a qube");
        }
        if (((fex0 = Ops.extent(findex0)).value(1) - (double)vv.length()) / (double)vv.length() > 100.0) {
            logger.warning("findex0 looks suspicious, where its max would result in unrealistic extrapolations");
        }
        if (fex0.value(0) / (double)vv.length() < -100.0) {
            logger.warning("findex0 looks suspicious, where its min would result in unrealistic extrapolations");
        }
        if (((fex1 = Ops.extent(findex1)).value(1) - (double)vv.length(0)) / (double)vv.length(0) > 100.0) {
            logger.warning("findex1 looks suspicious, where its max would result in unrealistic extrapolations");
        }
        if (fex1.value(0) / (double)vv.length(0) < -100.0) {
            logger.warning("findex1 looks suspicious, where its min would result in unrealistic extrapolations");
        }
        if (((fex2 = Ops.extent(findex2)).value(1) - (double)vv.length(0, 0)) / (double)vv.length(0, 0) > 100.0) {
            logger.warning("findex2 looks suspicious, where its max would result in unrealistic extrapolations");
        }
        if (fex2.value(0) / (double)vv.length(0, 0) < -100.0) {
            logger.warning("findex2 looks suspicious, where its min would result in unrealistic extrapolations");
        }
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(findex0));
        QDataSet wds = DataSetUtil.weightsDataSet(vv);
        QubeDataSetIterator it = new QubeDataSetIterator(findex0);
        int ic00 = 0;
        int ic01 = 0;
        int ic10 = 0;
        int ic11 = 0;
        int ic20 = 0;
        int ic21 = 0;
        int n0 = vv.length();
        int n1 = vv.length(0);
        int n2 = vv.length(0, 0);
        double fill = -1.0E38;
        boolean hasFill = false;
        boolean noExtrapolate = true;
        while (it.hasNext()) {
            it.next();
            double ff0 = it.getValue(findex0);
            double ff1 = it.getValue(findex1);
            double ff2 = it.getValue(findex2);
            if (ff0 >= 0.0 && ff0 < (double)(n0 - 1)) {
                ic00 = (int)Math.floor(ff0);
                ic01 = ic00 + 1;
            } else {
                if (noExtrapolate && ff0 < -0.5) {
                    it.putValue(result, fill);
                    hasFill = true;
                    continue;
                }
                if (noExtrapolate && ff0 >= (double)n0 - 0.5) {
                    it.putValue(result, fill);
                    hasFill = true;
                    continue;
                }
                if (ff0 < 0.0) {
                    ic00 = 0;
                    ic01 = 1;
                } else if (ff0 >= (double)(n0 - 1)) {
                    ic00 = n0 - 2;
                    ic01 = n0 - 1;
                }
            }
            if (ff1 >= 0.0 && ff1 < (double)(n1 - 1)) {
                ic10 = (int)Math.floor(ff1);
                ic11 = ic10 + 1;
            } else {
                if (noExtrapolate && ff1 < -0.5) {
                    it.putValue(result, fill);
                    hasFill = true;
                    continue;
                }
                if (noExtrapolate && ff1 >= (double)n1 - 0.5) {
                    it.putValue(result, fill);
                    hasFill = true;
                    continue;
                }
                if (ff1 < 0.0) {
                    ic10 = 0;
                    ic11 = 1;
                } else if (ff1 >= (double)(n1 - 1)) {
                    ic10 = n1 - 2;
                    ic11 = n1 - 1;
                }
            }
            if (ff2 >= 0.0 && ff2 < (double)(n2 - 1)) {
                ic20 = (int)Math.floor(ff2);
                ic21 = ic20 + 1;
            } else {
                if (noExtrapolate && ff2 < -0.5) {
                    it.putValue(result, fill);
                    hasFill = true;
                    continue;
                }
                if (noExtrapolate && ff2 >= (double)n2 - 0.5) {
                    it.putValue(result, fill);
                    hasFill = true;
                    continue;
                }
                if (ff2 < 0.0) {
                    ic20 = 0;
                    ic21 = 1;
                } else if (ff2 >= (double)(n2 - 1)) {
                    ic20 = n2 - 2;
                    ic21 = n2 - 1;
                }
            }
            double alpha0 = ff0 - (double)ic00;
            double alpha1 = ff1 - (double)ic10;
            double alpha2 = ff2 - (double)ic20;
            double vv000 = vv.value(ic20, ic00, ic10);
            double vv001 = vv.value(ic20, ic00, ic11);
            double vv010 = vv.value(ic20, ic01, ic10);
            double vv011 = vv.value(ic20, ic01, ic11);
            double vv100 = vv.value(ic21, ic00, ic10);
            double vv101 = vv.value(ic21, ic00, ic11);
            double vv110 = vv.value(ic21, ic01, ic10);
            double vv111 = vv.value(ic21, ic01, ic11);
            double ww000 = wds.value(ic20, ic00, ic10);
            double ww001 = wds.value(ic20, ic00, ic11);
            double ww010 = wds.value(ic20, ic01, ic10);
            double ww011 = wds.value(ic20, ic01, ic11);
            double ww100 = wds.value(ic21, ic00, ic10);
            double ww101 = wds.value(ic21, ic00, ic11);
            double ww110 = wds.value(ic21, ic01, ic10);
            double ww111 = wds.value(ic21, ic01, ic11);
            if (ww000 * ww001 * ww010 * ww011 * ww100 * ww101 * ww110 * ww111 > 0.0) {
                double beta0 = 1.0 - alpha0;
                double beta1 = 1.0 - alpha1;
                double beta2 = 1.0 - alpha2;
                double value = vv000 * beta0 * beta1 * beta2 + vv001 * beta0 * alpha1 * beta2 + vv010 * alpha0 * beta1 * beta2 + vv011 * alpha0 * alpha1 * beta2 + vv100 * beta0 * beta1 * alpha2 + vv101 * beta0 * alpha1 * alpha2 + vv110 * alpha0 * beta1 * alpha2 + vv111 * alpha0 * alpha1 * alpha2;
                it.putValue(result, value);
                continue;
            }
            it.putValue(result, fill);
            hasFill = true;
        }
        DataSetUtil.copyDimensionProperties(vv, result);
        for (int i = 0; i <= findex0.rank(); ++i) {
            QDataSet depend = (QDataSet)findex0.property("DEPEND_" + i);
            if (depend == null) continue;
            result.putProperty("DEPEND_" + i, depend);
        }
        if (hasFill) {
            result.putProperty("FILL_VALUE", fill);
        }
        return result;
    }

    public static QDataSet interpolateMod(QDataSet vv, QDataSet mod, QDataSet findex) {
        double top;
        double base;
        double dmodLimit;
        double dmod;
        if (vv.rank() != 1) {
            throw new IllegalArgumentException("vv is not rank1");
        }
        if (!Ops.isDimensionless(findex)) {
            throw new IllegalArgumentException("findex argument should be dimensionless, expected output from findex command.");
        }
        QDataSet fex0 = Ops.extent(findex);
        if ((fex0.value(1) - (double)vv.length()) / (double)vv.length() > 100.0) {
            logger.warning("findex looks suspicious, where its max will result in unrealistic extrapolations");
        }
        if (fex0.value(0) / (double)vv.length() < -100.0) {
            logger.warning("findex looks suspicious, where its min will result in unrealistic extrapolations");
        }
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(findex));
        QubeDataSetIterator it = new QubeDataSetIterator(findex);
        int ic0 = 0;
        int ic1 = 0;
        int n = vv.length();
        QDataSet wds = DataSetUtil.weightsDataSet(vv);
        Number fill = (Number)wds.property("FILL_VALUE");
        double dfill = fill == null ? -1.0E38 : fill.doubleValue();
        result.putProperty("FILL_VALUE", dfill);
        boolean hasFill = false;
        QDataSet wfindex = DataSetUtil.weightsDataSet(findex);
        wfindex = Ops.copy(wfindex);
        if (mod.rank() == 0) {
            dmod = DataSetUtil.asDatum(mod).doubleValue(SemanticOps.getUnits(vv).getOffsetUnits());
            dmodLimit = dmod / 2.0;
            base = 0.0;
            top = dmod;
        } else if (mod.rank() == 1 && mod.length() == 2) {
            dmod = DataSetUtil.asDatum(mod.slice(1)).subtract(DataSetUtil.asDatum(mod.slice(0))).doubleValue(SemanticOps.getUnits(vv).getOffsetUnits());
            dmodLimit = dmod / 2.0;
            vv = Ops.subtract(vv, mod.slice(0));
            base = mod.slice(0).value();
            top = mod.slice(1).value();
        } else {
            throw new IllegalArgumentException("mod must be rank 0 or rank 1 with two elements.");
        }
        boolean noExtrapolate = true;
        while (it.hasNext()) {
            it.next();
            if (it.getValue(wfindex) == 0.0) {
                it.putValue(result, dfill);
                hasFill = true;
                continue;
            }
            double ff = it.getValue(findex);
            if (ff >= 0.0 && ff < (double)(n - 1)) {
                ic0 = (int)Math.floor(ff);
                ic1 = ic0 + 1;
            } else {
                if (noExtrapolate && ff < -0.5) {
                    it.putValue(result, dfill);
                    hasFill = true;
                    continue;
                }
                if (noExtrapolate && ff >= (double)n - 0.5) {
                    it.putValue(result, dfill);
                    hasFill = true;
                    continue;
                }
                if (ff < 0.0) {
                    ic0 = 0;
                    ic1 = 1;
                } else if (ff >= (double)(n - 1)) {
                    ic0 = n - 2;
                    ic1 = n - 1;
                }
            }
            double alpha = ff - (double)ic0;
            if (wds.value(ic0) > 0.0 && wds.value(ic1) > 0.0) {
                double v;
                double vv0 = vv.value(ic0);
                double vv1 = vv.value(ic1);
                while (vv1 - vv0 > dmodLimit) {
                    vv0 += dmod;
                }
                while (vv0 - vv1 > dmodLimit) {
                    vv1 += dmod;
                }
                for (v = vv0 + alpha * (vv1 - vv0) + base; v > top; v -= dmod) {
                }
                while (v < base) {
                    v += dmod;
                }
                it.putValue(result, v);
                continue;
            }
            it.putValue(result, dfill);
            hasFill = true;
        }
        DataSetUtil.copyDimensionProperties(vv, result);
        for (int i = 0; i <= findex.rank(); ++i) {
            QDataSet depend = (QDataSet)findex.property("DEPEND_" + i);
            if (depend == null) continue;
            result.putProperty("DEPEND_" + i, depend);
        }
        if (hasFill) {
            result.putProperty("FILL_VALUE", dfill);
        }
        return result;
    }

    public static QDataSet interpolateGrid(QDataSet vv, QDataSet findex0, QDataSet findex1) {
        QDataSet depend1;
        boolean slice0 = false;
        if (findex0.rank() == 0) {
            slice0 = true;
            findex0 = new JoinDataSet(findex0);
        }
        boolean slice1 = false;
        if (findex1.rank() == 0) {
            slice1 = true;
            findex1 = new JoinDataSet(findex1);
        }
        if (findex0.rank() != 1) {
            throw new IllegalArgumentException("findex0 must be rank 1");
        }
        if (findex1.rank() != 1) {
            throw new IllegalArgumentException("findex1 must be rank 1");
        }
        DDataSet result = DDataSet.createRank2(findex0.length(), findex1.length());
        QDataSet wds = DataSetUtil.weightsDataSet(vv);
        int ic00 = 0;
        int ic01 = 0;
        int ic10 = 0;
        int ic11 = 0;
        int n0 = vv.length();
        int n1 = vv.length(0);
        double fill = -1.0E38;
        QubeDataSetIterator it = new QubeDataSetIterator(findex0);
        boolean noExtrapolate = true;
        boolean hasFill = false;
        while (it.hasNext()) {
            it.next();
            QubeDataSetIterator it2 = new QubeDataSetIterator(findex1);
            while (it2.hasNext()) {
                it2.next();
                double ff0 = it.getValue(findex0);
                if (ff0 >= 0.0 && ff0 < (double)(n0 - 1)) {
                    ic00 = (int)Math.floor(ff0);
                    ic01 = ic00 + 1;
                } else {
                    if (noExtrapolate && ff0 < -0.5) {
                        result.putValue(it.index(0), it2.index(0), fill);
                        hasFill = true;
                        continue;
                    }
                    if (noExtrapolate && ff0 >= (double)n0 - 0.5) {
                        result.putValue(it.index(0), it2.index(0), fill);
                        hasFill = true;
                        continue;
                    }
                    if (ff0 < 0.0) {
                        ic00 = 0;
                        ic01 = 1;
                    } else if (ff0 >= (double)(n0 - 1)) {
                        ic00 = n0 - 2;
                        ic01 = n0 - 1;
                    }
                }
                double ff1 = it2.getValue(findex1);
                if (ff1 >= 0.0 && ff1 < (double)(n1 - 1)) {
                    ic10 = (int)Math.floor(ff1);
                    ic11 = ic10 + 1;
                } else {
                    if (noExtrapolate && ff1 < -0.5) {
                        result.putValue(it.index(0), it2.index(0), fill);
                        hasFill = true;
                        continue;
                    }
                    if (noExtrapolate && ff1 >= (double)n1 - 0.5) {
                        result.putValue(it.index(0), it2.index(0), fill);
                        hasFill = true;
                        continue;
                    }
                    if (ff1 < 0.0) {
                        ic10 = 0;
                        ic11 = 1;
                    } else if (ff1 >= (double)(n1 - 1)) {
                        ic10 = n1 - 2;
                        ic11 = n1 - 1;
                    }
                }
                double alpha0 = ff0 - (double)ic00;
                double alpha1 = ff1 - (double)ic10;
                double beta0 = 1.0 - alpha0;
                double beta1 = 1.0 - alpha1;
                double ww00 = wds.value(ic00, ic10);
                double ww01 = wds.value(ic00, ic11);
                double ww10 = wds.value(ic01, ic10);
                double ww11 = wds.value(ic01, ic11);
                double vv00 = ww00 == 0.0 ? 0.0 : vv.value(ic00, ic10);
                double vv01 = ww01 == 0.0 ? 0.0 : vv.value(ic00, ic11);
                double vv10 = ww10 == 0.0 ? 0.0 : vv.value(ic01, ic10);
                double vv11 = ww11 == 0.0 ? 0.0 : vv.value(ic01, ic11);
                double beta0beta1 = beta0 * beta1;
                double beta0alpha1 = beta0 * alpha1;
                double alpha0beta1 = alpha0 * beta1;
                double alpha0alpha1 = alpha0 * alpha1;
                ww00 = beta0beta1 == 0.0 ? 1.0 : ww00;
                ww01 = beta0alpha1 == 0.0 ? 1.0 : ww01;
                ww10 = alpha0beta1 == 0.0 ? 1.0 : ww10;
                double d = ww11 = alpha0alpha1 == 0.0 ? 1.0 : ww11;
                if (ww00 * ww01 * ww10 * ww11 > 0.0) {
                    double value = vv00 * beta0beta1 + vv01 * beta0alpha1 + vv10 * alpha0beta1 + vv11 * alpha0alpha1;
                    result.putValue(it.index(0), it2.index(0), value);
                    continue;
                }
                hasFill = true;
                result.putValue(it.index(0), it2.index(0), fill);
            }
        }
        DataSetUtil.copyDimensionProperties(vv, result);
        QDataSet depend0 = (QDataSet)findex0.property("DEPEND_0");
        if (depend0 != null) {
            result.putProperty("DEPEND_0", depend0);
        }
        if ((depend1 = (QDataSet)findex1.property("DEPEND_1")) != null) {
            result.putProperty("DEPEND_1", depend1);
        }
        if (hasFill) {
            result.putProperty("FILL_VALUE", fill);
        }
        QDataSet result1 = result;
        if (slice1) {
            result1 = DataSetOps.slice1(result1, 0);
        }
        if (slice0) {
            result1 = result1.slice(0);
        }
        return result1;
    }

    public static QDataSet interpolateGrid(Object x, Object y, Object z) {
        return Ops.interpolateGrid(Ops.dataset(x), Ops.dataset(y), Ops.dataset(z));
    }

    public static QDataSet valid(QDataSet ds) {
        return DataSetUtil.weightsDataSet(ds);
    }

    public static QDataSet invalid(QDataSet ds) {
        return Ops.eq((Object)Ops.valid(ds), 0);
    }

    public static void clearWritable(WritableDataSet ds) {
        if (ds.isImmutable()) {
            throw new IllegalArgumentException("ds has been made immutable");
        }
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        while (it.hasNext()) {
            it.next();
            it.putValue(ds, 0.0);
        }
    }

    public static QDataSet finite(QDataSet ds) {
        ArrayDataSet result = ArrayDataSet.copy(ds);
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        while (it.hasNext()) {
            it.next();
            double d1 = it.getValue(ds);
            it.putValue(result, Double.isInfinite(d1) || Double.isNaN(d1) ? 0.0 : 1.0);
        }
        return result;
    }

    public static QDataSet smooth1(QDataSet ds, int size) {
        switch (ds.rank()) {
            case 1: {
                throw new IllegalArgumentException("data must be rank 2 or more");
            }
            case 2: {
                ArrayDataSet result = ArrayDataSet.copy(ds);
                for (int i = 0; i < ds.length(); ++i) {
                    DDataSet result1 = BinAverage.boxcar(ds.slice(i), size);
                    for (int j = 0; j < ds.length(0); ++j) {
                        result.putValue(i, j, result1.value(j));
                    }
                }
                return result;
            }
        }
        throw new IllegalArgumentException("only rank 1 and rank 2");
    }

    public static QDataSet smooth2d(QDataSet ds, int n0, int n1) {
        if (ds.rank() != 2) {
            throw new IllegalArgumentException("data must be rank 2");
        }
        ds = Ops.smooth(ds, n0);
        ds = Ops.smooth1(ds, n1);
        return ds;
    }

    public static QDataSet smooth(QDataSet ds, int size) {
        switch (ds.rank()) {
            case 1: {
                DDataSet result = BinAverage.boxcar(ds, size);
                DataSetUtil.copyDimensionProperties(ds, result);
                return result;
            }
            case 2: {
                ArrayDataSet result = ArrayDataSet.copy(ds);
                if (SemanticOps.isRank2Waveform(ds)) {
                    throw new IllegalArgumentException("rank 2 waveform is not supported, use flattenWaveform first.");
                }
                for (int j = 0; j < ds.length(0); ++j) {
                    DDataSet result1 = BinAverage.boxcar(Ops.unbundle(ds, j), size);
                    for (int i = 0; i < ds.length(); ++i) {
                        result.putValue(i, j, result1.value(i));
                    }
                }
                return result;
            }
        }
        throw new IllegalArgumentException("only rank 1 and rank 2");
    }

    public static QDataSet smooth(Object ds, int size) {
        return Ops.smooth(Ops.dataset(ds), size);
    }

    public static QDataSet smoothFit(QDataSet xx, QDataSet yy, int size) {
        if (size > yy.length()) {
            size = yy.length();
        }
        if (xx == null) {
            xx = Ops.findgen(yy.length());
        }
        DDataSet yysmooth = (DDataSet)ArrayDataSet.maybeCopy(Double.TYPE, Ops.smooth(yy, size));
        int n = xx.length();
        yysmooth.putProperty("DEPEND_0", xx);
        switch (yy.rank()) {
            case 1: {
                int i;
                LinFit fit = new LinFit(xx.trim(0, size), yy.trim(0, size));
                for (i = 0; i < size / 2; ++i) {
                    yysmooth.putValue(i, xx.value(i) * fit.getB() + fit.getA());
                }
                fit = new LinFit(xx.trim(n - size, n), yy.trim(n - size, n));
                for (i = n - (size + 1) / 2; i < n; ++i) {
                    yysmooth.putValue(i, xx.value(i) * fit.getB() + fit.getA());
                }
                break;
            }
            case 2: {
                for (int j = 0; j < yy.length(0); ++j) {
                    int i;
                    QDataSet yy1 = Ops.unbundle(yy, j);
                    LinFit fit = new LinFit(xx.trim(0, size), yy1.trim(0, size));
                    for (i = 0; i < size / 2; ++i) {
                        yysmooth.putValue(i, j, xx.value(i) * fit.getB() + fit.getA());
                    }
                    fit = new LinFit(xx.trim(n - size, n), yy1.trim(n - size, n));
                    for (i = n - (size + 1) / 2; i < n; ++i) {
                        yysmooth.putValue(i, j, xx.value(i) * fit.getB() + fit.getA());
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("yy must be rank 1 or rank 2: " + yy);
            }
        }
        return yysmooth;
    }

    public static QDataSet smoothFit(Object xx, Object yy, int size) {
        return Ops.smoothFit(Ops.dataset(xx), Ops.dataset(yy), size);
    }

    public static QDataSet detrend(QDataSet yy, int size) {
        return Ops.subtract(yy, Ops.smooth(yy, size));
    }

    public static QDataSet detrend(Object yy, int size) {
        return Ops.detrend(Ops.dataset(yy), size);
    }

    public static QDataSet detrend1(QDataSet yy, int size) {
        return Ops.subtract(yy, Ops.smooth1(yy, size));
    }

    public static QDataSet cleanData(QDataSet ds) {
        return Ops.cleanData(ds, -1);
    }

    public static QDataSet cleanData(QDataSet ds, int size) {
        return Ops.cleanData(ds, 3.0, size);
    }

    public static QDataSet cleanData(QDataSet ds, double nsigma, int size) {
        QDataSet sig3;
        QDataSet mean;
        if (size == -1) {
            mean = Ops.mean(ds);
            sig3 = Ops.multiply((Object)Ops.stddev(ds), nsigma);
        } else {
            mean = Ops.smooth(ds, size);
            sig3 = Ops.multiply((Object)Ops.smooth(Ops.abs(Ops.subtract(ds, mean)), size), nsigma);
        }
        QDataSet w = Ops.where(Ops.gt(Ops.abs(Ops.subtract(ds, mean)), sig3));
        WritableDataSet wds = Ops.copy(ds);
        Number fill = (Number)ds.property("FILL_VALUE");
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        it.setIndexIteratorFactory(0, new QubeDataSetIterator.IndexListIteratorFactory(w));
        double FILL = (fill == null ? (Number)Double.NaN : (Number)fill).doubleValue();
        while (it.hasNext()) {
            it.next();
            it.putValue(wds, FILL);
        }
        return wds;
    }

    public static QDataSet mean(QDataSet ds) {
        double avg = 0.0;
        int n = 0;
        double offs = Double.NaN;
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        QDataSet wds = Ops.valid(ds);
        while (it.hasNext()) {
            it.next();
            if (it.getValue(wds) == 0.0) continue;
            if (++n == 1) {
                offs = it.getValue(ds);
            }
            avg += it.getValue(ds) - offs;
        }
        double m = offs + avg / (double)n;
        return DataSetUtil.asDataSet(m, SemanticOps.getUnits(ds));
    }

    public static QDataSet mean(Object o) {
        return Ops.mean(Ops.dataset(o));
    }

    public static QDataSet mode(QDataSet ds) {
        HashMap<Double, Integer> m = new HashMap<Double, Integer>();
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        QDataSet wds = Ops.valid(ds);
        while (it.hasNext()) {
            it.next();
            double w = it.getValue(wds);
            if (!(w > 0.0)) continue;
            double d = it.getValue(ds);
            Integer i = (Integer)m.get(d);
            if (i == null) {
                m.put(d, 1);
                continue;
            }
            m.put(d, i + 1);
        }
        int max = 0;
        double maxd = Double.NaN;
        for (Map.Entry vv : m.entrySet()) {
            if ((Integer)vv.getValue() <= max) continue;
            max = (Integer)vv.getValue();
            maxd = (Double)vv.getKey();
        }
        DDataSet result = DDataSet.create(new int[0]);
        result.putValue(maxd);
        DataSetUtil.copyDimensionProperties(ds, result);
        return result;
    }

    public static QDataSet median(Object o) {
        return Ops.median(Ops.dataset(o));
    }

    public static QDataSet median(QDataSet ds) {
        LinkedList<Double> less = new LinkedList<Double>();
        LinkedList<Double> more = new LinkedList<Double>();
        QDataSet wds = Ops.valid(ds);
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        while (iter.hasNext()) {
            double mv;
            iter.next();
            if (iter.getValue(wds) == 0.0) continue;
            double d = iter.getValue(ds);
            if (less.isEmpty()) {
                less.add(d);
                Collections.sort(less);
            } else if ((Double)less.getLast() >= d) {
                less.add(d);
                Collections.sort(less);
            } else {
                more.add(d);
                Collections.sort(more);
            }
            if (less.size() < more.size() - 1) {
                mv = (Double)more.getFirst();
                less.add(mv);
                more.remove(mv);
                Collections.sort(less);
                continue;
            }
            if (less.size() - 1 <= more.size()) continue;
            mv = (Double)less.getLast();
            less.remove(mv);
            more.add(mv);
            Collections.sort(more);
        }
        double ans = less.size() > more.size() ? (Double)less.getLast() : (less.size() < more.size() ? (Double)more.getFirst() : (more.isEmpty() ? Double.NaN : (Double)more.getFirst()));
        return DataSetUtil.asDataSet(ans, SemanticOps.getUnits(ds));
    }

    public static QDataSet stddev(Object o) {
        return Ops.stddev(Ops.dataset(o));
    }

    public static QDataSet stddev(QDataSet ds) {
        int n = 0;
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        double sum = 0.0;
        while (iter.hasNext()) {
            iter.next();
            sum += iter.getValue(ds);
            ++n;
        }
        double u = sum / (double)n;
        double square = 0.0;
        iter = new QubeDataSetIterator(ds);
        while (iter.hasNext()) {
            iter.next();
            double sub = iter.getValue(ds) - u;
            square += Math.pow(sub, 2.0);
        }
        double undersqrrt = square / (double)(n - 1);
        double result = Ops.sqrt(undersqrrt);
        return DataSetUtil.asDataSet(result, SemanticOps.getUnits(ds).getOffsetUnits());
    }

    public static QDataSet variance(Object o) {
        return Ops.variance(Ops.dataset(o));
    }

    public static QDataSet variance(QDataSet ds) {
        return Ops.pow((Object)Ops.stddev(ds), (Object)2);
    }

    public static QDataSet meanAverageDeviation(QDataSet ds) {
        QDataSet mean = Ops.mean(ds);
        double meanDouble = mean.value();
        double sum = 0.0;
        int n = 0;
        QDataSet w = DataSetUtil.weightsDataSet(ds);
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        while (iter.hasNext()) {
            iter.next();
            if (!(iter.getValue(w) > 0.0)) continue;
            double sub = iter.getValue(ds) - meanDouble;
            sum += sub < 0.0 ? -sub : sub;
            ++n;
        }
        double result = sum / (double)n;
        DRank0DataSet results = DataSetUtil.asDataSet(result, SemanticOps.getUnits(ds).getOffsetUnits());
        HashMap<String, Object> user = new HashMap<String, Object>();
        user.put("mean", mean);
        user.put("n", n);
        return Ops.putProperty(results, "USER_PROPERTIES", user);
    }

    public static QDataSet neighborFill(QDataSet ds) {
        QDataSet w = Ops.copy(Ops.valid(ds));
        WritableDataSet wds = null;
        while (Ops.reduceMin(w, 0).value() == 0.0) {
            int i;
            wds = Ops.copy(ds);
            for (i = 1; i < ds.length(); ++i) {
                if (w.value(i) != 0.0 || !(w.value(i - 1) > 0.0)) continue;
                wds.putValue(i, w.value(i - 1));
            }
            for (i = ds.length() - 2; i >= 0; --i) {
                if (w.value(i) != 0.0 || !(w.value(i + 1) > 0.0)) continue;
                wds.putValue(i, w.value(i + 1));
            }
            w = Ops.valid(wds);
        }
        return wds == null ? ds : wds;
    }

    public static QDataSet medianFilter(QDataSet ds, int size) {
        double d;
        int i;
        if (ds.rank() == 2) {
            ArrayDataSet res = ArrayDataSet.copy(ds);
            for (int j = 0; j < ds.length(0); ++j) {
                QDataSet in1 = Ops.unbundle(ds, j);
                QDataSet r = Ops.where(Ops.valid(in1));
                if (r.length() <= ds.length() / 2) {
                    for (int i2 = 0; i2 < in1.length(); ++i2) {
                        res.putValue(i2, j, in1.value(i2));
                    }
                    continue;
                }
                if (r.length() < in1.length()) {
                    in1 = Ops.applyIndex(in1, r);
                }
                QDataSet d1 = Ops.medianFilter(in1, size);
                for (int i3 = 0; i3 < in1.length(); ++i3) {
                    res.putValue((int)r.value(i3), j, d1.value(i3));
                }
            }
            return res;
        }
        if (Ops.reduceMin(Ops.valid(ds), 0).value() == 0.0) {
            throw new IllegalArgumentException("fill data is not supported");
        }
        if (size > ds.length() / 2) {
            throw new IllegalArgumentException("size cannot be greater than ds.length()/2");
        }
        if (size < 3) {
            throw new IllegalArgumentException("size cannot be less than 3");
        }
        ArrayDataSet res = ArrayDataSet.copy(ds);
        LinkedList<Double> less = new LinkedList<Double>();
        LinkedList<Double> more = new LinkedList<Double>();
        LinkedList<Double> vv = new LinkedList<Double>();
        int hsize = size / 2;
        for (i = 0; i < size - 1; ++i) {
            d = ds.value(i);
            vv.add(d);
            if (less.isEmpty()) {
                less.add(d);
            } else if ((Double)less.getLast() < d) {
                int index = Collections.binarySearch(more, d);
                if (index < 0) {
                    index ^= 0xFFFFFFFF;
                }
                more.add(index, d);
            } else {
                int index = Collections.binarySearch(less, d);
                if (index < 0) {
                    index ^= 0xFFFFFFFF;
                }
                less.add(index, d);
            }
            if (less.size() < more.size() - 1) {
                double mv = (Double)more.getFirst();
                less.add(mv);
                more.remove(0);
            } else if (less.size() - 1 > more.size()) {
                double mv = (Double)less.getLast();
                more.add(0, mv);
                less.remove(less.size() - 1);
            }
            res.putValue(i, d);
        }
        for (i = hsize; i < ds.length() - hsize; ++i) {
            double mv;
            int index;
            d = ds.value(i + hsize);
            vv.add(d);
            if ((Double)less.getLast() < d) {
                index = Collections.binarySearch(more, d);
                if (index < 0) {
                    index ^= 0xFFFFFFFF;
                }
                more.add(index, d);
            } else {
                index = Collections.binarySearch(less, d);
                if (index < 0) {
                    index ^= 0xFFFFFFFF;
                }
                less.add(index, d);
            }
            if (less.size() > more.size()) {
                res.putValue(i, (Double)less.getLast());
            } else {
                res.putValue(i, (Double)more.getFirst());
            }
            double rm = (Double)vv.remove(0);
            if ((Double)less.getLast() >= rm) {
                less.remove(rm);
            } else {
                more.remove(rm);
            }
            if (less.size() < more.size() - 1) {
                mv = (Double)more.getFirst();
                less.add(mv);
                more.remove(0);
                continue;
            }
            if (less.size() - 1 <= more.size()) continue;
            mv = (Double)less.getLast();
            more.add(0, mv);
            less.remove(less.size() - 1);
        }
        for (i = ds.length() - hsize; i < ds.length(); ++i) {
            d = ds.value(i);
            res.putValue(i, d);
        }
        return res;
    }

    private static QDataSet medianFilter2d(QDataSet ds, int size1, int size2) {
        double d;
        int j;
        int i;
        if (ds.rank() != 2) {
            throw new IllegalArgumentException("dataset must be rank 2");
        }
        int n1 = ds.length();
        int n2 = ds.length(0);
        if (size1 > n1 / 2) {
            throw new IllegalArgumentException("size1 cannot be greater than ds.length()/2");
        }
        if (size2 > n2 / 2) {
            throw new IllegalArgumentException("size2 cannot be greater than ds.length(0)/2");
        }
        if (size1 < 3) {
            throw new IllegalArgumentException("size1 cannot be less than 3");
        }
        if (size2 < 3) {
            throw new IllegalArgumentException("size2 cannot be less than 3");
        }
        ArrayDataSet res = ArrayDataSet.copy(ds);
        LinkedList<Double> vv = new LinkedList<Double>();
        int hsize1 = size1 / 2;
        int hsize2 = size2 / 2;
        for (i = 0; i < size1 - 1; ++i) {
            for (j = 0; j < size2 - 1; ++j) {
                d = ds.value(i, j);
                res.putValue(i, j, d);
            }
        }
        for (i = hsize1; i < n1 - hsize1; ++i) {
            LinkedList<Double> less = new LinkedList<Double>();
            LinkedList<Double> more = new LinkedList<Double>();
            for (int i1 = 0; i1 < size1 - 1; ++i1) {
                for (int j2 = 0; j2 < size2 - 1; ++j2) {
                    double d2 = ds.value(i1, j2);
                    vv.add(d2);
                    if (less.isEmpty()) {
                        less.add(d2);
                    } else if ((Double)less.getLast() < d2) {
                        int index = Collections.binarySearch(more, d2);
                        if (index < 0) {
                            index ^= 0xFFFFFFFF;
                        }
                        more.add(index, d2);
                    } else {
                        int index = Collections.binarySearch(less, d2);
                        if (index < 0) {
                            index ^= 0xFFFFFFFF;
                        }
                        less.add(index, d2);
                    }
                    if (less.size() < more.size() - 1) {
                        double mv = (Double)more.getFirst();
                        less.add(mv);
                        more.remove(0);
                    } else if (less.size() - 1 > more.size()) {
                        double mv = (Double)less.getLast();
                        more.add(0, mv);
                        less.remove(less.size() - 1);
                    }
                    res.putValue(i1, j2, d2);
                }
            }
            for (j = hsize2; j < n2 - hsize2; ++j) {
                double mv;
                int index;
                double d3 = ds.value(i + hsize1, j + hsize2);
                vv.add(d3);
                if ((Double)less.getLast() < d3) {
                    index = Collections.binarySearch(more, d3);
                    if (index < 0) {
                        index ^= 0xFFFFFFFF;
                    }
                    more.add(index, d3);
                } else {
                    index = Collections.binarySearch(less, d3);
                    if (index < 0) {
                        index ^= 0xFFFFFFFF;
                    }
                    less.add(index, d3);
                }
                if (less.size() > more.size()) {
                    res.putValue(i, j, (Double)less.getLast());
                } else {
                    res.putValue(i, j, (Double)more.getFirst());
                }
                double rm = (Double)vv.remove(0);
                if ((Double)less.getLast() >= rm) {
                    less.remove(rm);
                } else {
                    more.remove(rm);
                }
                if (less.size() < more.size() - 1) {
                    mv = (Double)more.getFirst();
                    less.add(mv);
                    more.remove(0);
                    continue;
                }
                if (less.size() - 1 <= more.size()) continue;
                mv = (Double)less.getLast();
                more.add(0, mv);
                less.remove(less.size() - 1);
            }
            for (j = n2 - hsize2; j < n2; ++j) {
                double d4 = ds.value(i, j);
                res.putValue(i, j, d4);
            }
        }
        for (i = n1 - hsize1; i < n1; ++i) {
            for (j = n2 - hsize2; j < n2; ++j) {
                d = ds.value(i, j);
                res.putValue(i, j, d);
            }
        }
        return res;
    }

    public static QDataSet contour(QDataSet tds, QDataSet vv) {
        QDataSet vds = Contour.contour(tds, vv);
        return vds;
    }

    public static QDataSet contour(Object tds, Object vv) {
        return Ops.contour(Ops.dataset(tds), Ops.dataset(vv));
    }

    public static QDataSet diff(QDataSet ds) {
        String label;
        if (ds.rank() > 1) {
            throw new IllegalArgumentException("only rank 1");
        }
        Units u = (Units)ds.property("UNITS");
        if (u != null && UnitsUtil.isNominalMeasurement((Units)u)) {
            throw new IllegalArgumentException("cannot take differences of nominal or enumeration data");
        }
        ArrayDataSet result = ArrayDataSet.createRank1(DataSetOps.getComponentType(ds), ds.length() - 1);
        QDataSet w1 = DataSetUtil.weightsDataSet(ds);
        QDataSet dep0ds = (QDataSet)ds.property("DEPEND_0");
        DDataSet dep0 = null;
        if (dep0ds != null && dep0ds.rank() == 1) {
            dep0 = DDataSet.createRank1(ds.length() - 1);
            DataSetUtil.putProperties(DataSetUtil.getProperties(dep0ds), dep0);
        }
        double fill = DataSetOps.suggestFillForComponentType(DataSetOps.getComponentType(ds));
        for (int i = 0; i < result.length(); ++i) {
            if (w1.value(i) > 0.0 && w1.value(i + 1) > 0.0) {
                result.putValue(i, ds.value(i + 1) - ds.value(i));
            } else {
                result.putValue(i, fill);
            }
            if (dep0ds == null || dep0ds.rank() != 1) continue;
            assert (dep0 != null);
            dep0.putValue(i, dep0ds.value(i) + (dep0ds.value(i + 1) - dep0ds.value(i)) / 2.0);
        }
        result.putProperty("FILL_VALUE", fill);
        if (u != null) {
            result.putProperty("UNITS", u.getOffsetUnits());
        }
        result.putProperty("NAME", null);
        result.putProperty("MONOTONIC", null);
        if (dep0ds != null) {
            result.putProperty("DEPEND_0", dep0);
        }
        if ((label = (String)ds.property("LABEL")) != null) {
            result.putProperty("LABEL", "diff(" + label + ")");
        }
        return result;
    }

    public static QDataSet diff(Object ds) {
        return Ops.diff(Ops.dataset(ds));
    }

    public static QDataSet accum(QDataSet accumDs, QDataSet ds) {
        Units ddUnits;
        Units units;
        if (ds.rank() > 1) {
            throw new IllegalArgumentException("only rank 1");
        }
        double accum = 0.0;
        UnitsConverter uc = null;
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        if (accumDs == null) {
            units = Units.dimensionless;
        } else if (accumDs.rank() == 0) {
            accum = accumDs.value();
            units = SemanticOps.getUnits(accumDs);
            ddUnits = SemanticOps.getUnits(ds);
            uc = UnitsConverter.getConverter((Units)ddUnits, (Units)units.getOffsetUnits());
        } else if (accumDs.rank() == 1) {
            accum = accumDs.value(accumDs.length() - 1);
            units = SemanticOps.getUnits(accumDs);
            ddUnits = SemanticOps.getUnits(ds);
            uc = UnitsConverter.getConverter((Units)ddUnits, (Units)units.getOffsetUnits());
        } else {
            throw new IllegalArgumentException("accumDs must be rank 0 or rank 1");
        }
        if (uc == UnitsConverter.IDENTITY) {
            uc = null;
        }
        WritableDataSet result = Ops.zeros(ds);
        result.putProperty("UNITS", units);
        for (int i = 0; i < result.length(); ++i) {
            if (wds.value(i) > 0.0) {
                double d = ds.value(i);
                result.putValue(i, accum += uc == null ? d : uc.convert(d));
                continue;
            }
            result.putValue(i, accum);
        }
        result.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        String label = (String)ds.property("LABEL");
        if (label != null) {
            result.putProperty("LABEL", "accum(" + label + ")");
        }
        return result;
    }

    public static QDataSet accum(Object accumDs, Object ds) {
        return Ops.accum(Ops.dataset(accumDs), Ops.dataset(ds));
    }

    public static QDataSet accum(QDataSet ds) {
        return Ops.accum(null, ds);
    }

    public static QDataSet accum(Object ds) {
        return Ops.accum(null, Ops.dataset(ds));
    }

    public static QDataSet cumulativeMax(QDataSet ds) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("argument must be rank 1");
        }
        ArrayDataSet result = ArrayDataSet.copy(ds);
        QDataSet w = Ops.valid(ds);
        double max = -1.7976931348623157E308;
        for (int i = 0; i < result.length(); ++i) {
            if (w.value(i) > 0.0) {
                double t = result.value(i);
                if (t > max) {
                    max = t;
                }
                result.putValue(i, max);
                continue;
            }
            result.putValue(i, Double.NaN);
        }
        return result;
    }

    public static QDataSet cumulativeMin(QDataSet ds) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("argument must be rank 1");
        }
        ArrayDataSet result = ArrayDataSet.copy(ds);
        QDataSet w = Ops.valid(ds);
        double min = Double.MAX_VALUE;
        for (int i = 0; i < result.length(); ++i) {
            if (w.value(i) > 0.0) {
                double t = result.value(i);
                if (t < min) {
                    min = t;
                }
                result.putValue(i, min);
                continue;
            }
            result.putValue(i, Double.NaN);
        }
        return result;
    }

    public static QDataSet append(QDataSet ds1, QDataSet ds2) {
        ArrayDataSet result;
        if (ds1 == null) {
            if (ds2.rank() > 0) {
                if (!DataSetUtil.validate(ds2, null)) {
                    throw new RuntimeException("dataset input ds2 to append doesn't validate.");
                }
                return ds2;
            }
            if (!DataSetUtil.validate(ds2, null)) {
                throw new RuntimeException("dataset input ds2 to append doesn't validate.");
            }
            ArrayDataSet result2 = ArrayDataSet.createRank1(ArrayDataSet.guessBackingStore(ds2), 1);
            result2.putValue(0, ds2.value());
            DataSetUtil.copyDimensionProperties(ds2, result2);
            QDataSet c = (QDataSet)ds2.property("CONTEXT_0");
            if (c != null && c.rank() == 0) {
                result2.putProperty("DEPEND_0", Ops.append(null, c));
            }
            return result2;
        }
        if (ds1 instanceof BufferDataSet && ds2 instanceof BufferDataSet) {
            Object c2;
            if (!DataSetUtil.validate(ds1, null)) {
                throw new RuntimeException("dataset input ds1 to append doesn't validate.");
            }
            if (!DataSetUtil.validate(ds2, null)) {
                throw new RuntimeException("dataset input ds2 to append doesn't validate.");
            }
            Object c1 = ((BufferDataSet)ds1).getType();
            if (c1 == (c2 = ((BufferDataSet)ds2).getType())) {
                BufferDataSet result3 = BufferDataSet.append((BufferDataSet)ds1, (BufferDataSet)ds2);
                if (!DataSetUtil.validate(result3, null)) {
                    throw new RuntimeException("appended result didn't validate, contact support.");
                }
                return result3;
            }
            Class<Double> c = Double.TYPE;
            ArrayDataSet result4 = ArrayDataSet.append(ArrayDataSet.maybeCopy(c, ds1), ArrayDataSet.maybeCopy(c, ds2));
            if (!DataSetUtil.validate(result4, null)) {
                throw new RuntimeException("appended result didn't validate, contact support.");
            }
            return result4;
        }
        if (!DataSetUtil.validate(ds1, null)) {
            throw new RuntimeException("dataset input ds1 to append doesn't validate.");
        }
        if (!DataSetUtil.validate(ds2, null)) {
            throw new RuntimeException("dataset input ds2 to append doesn't validate.");
        }
        Class c1 = Double.TYPE;
        Class c2 = Double.TYPE;
        if (ds1 instanceof ArrayDataSet) {
            c1 = ((ArrayDataSet)ds1).getComponentType();
        }
        if (ds2 instanceof ArrayDataSet) {
            c2 = ((ArrayDataSet)ds2).getComponentType();
        }
        Class c = Double.TYPE;
        if (c1 == c2) {
            c = c1;
        }
        if (!DataSetUtil.validate(result = ArrayDataSet.append(ArrayDataSet.maybeCopy(c, ds1), ArrayDataSet.maybeCopy(c, ds2)), null)) {
            throw new RuntimeException("appended result didn't validate, contact support.");
        }
        return result;
    }

    public static QDataSet timeShift(QDataSet ds, Datum delta) {
        if (SemanticOps.isJoin(ds)) {
            JoinDataSet result = new JoinDataSet(ds.rank());
            for (int i = 0; i < ds.length(); ++i) {
                result.join(Ops.timeShift(ds.slice(i), delta));
            }
            return result;
        }
        if (SemanticOps.isBundle(ds) && ds.property("DEPEND_0") == null) {
            QDataSet dep0 = Ops.unbundle(ds, 0);
            dep0 = Ops.add((Object)dep0, delta);
            QDataSet result = Ops.bundle(dep0);
            for (int i = 1; i < ds.length(0); ++i) {
                result = Ops.bundle(result, Ops.unbundle(ds, i));
            }
            return result;
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        dep0 = Ops.add((Object)dep0, delta);
        return Ops.link(dep0, ds);
    }

    public static QDataSet synchronizeOne(QDataSet dsTarget, QDataSet dsSource) {
        int nl;
        boolean interpolationNeeded;
        QDataSet ff;
        QDataSet ttSource;
        QDataSet ttTarget = (QDataSet)dsTarget.property("DEPEND_0");
        if (ttTarget == null && DataSetUtil.isMonotonic(dsTarget)) {
            ttTarget = dsTarget;
        }
        if ((ttSource = (QDataSet)dsSource.property("DEPEND_0")) == null) {
            if (ttTarget == null) {
                if (dsTarget.length() == dsSource.length()) {
                    logger.fine("assume they were already synchronized, since the mashup tool uses this by default.");
                    return dsSource;
                }
                throw new IllegalArgumentException("target dataset sent to synchronizeOne doesn't have timetags: " + dsTarget);
            }
            if (SemanticOps.getUnits(dsSource).isConvertibleTo(SemanticOps.getUnits(ttTarget))) {
                ttSource = dsSource;
            } else {
                throw new IllegalArgumentException("dataset sent to synchronizeOne doesn't have timetags: " + dsSource);
            }
        }
        try {
            ff = Ops.findex(ttSource, ttTarget);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.WARNING, "when calling synchronize, DEPEND_0 was not monotonic for dsSource, using monotonic subset of points");
            MutablePropertyDataSet dsx = Ops.monotonicSubset(dsSource);
            logger.log(Level.INFO, "monotonicSubset removes {0} records", dsSource.length() - dsx.length());
            dsSource = dsx;
            ttSource = (QDataSet)dsSource.property("DEPEND_0");
            ff = Ops.findex(ttSource, ttTarget);
        }
        boolean nn = UnitsUtil.isOrdinalMeasurement((Units)SemanticOps.getUnits(dsSource));
        if (nn) {
            ff = Ops.round(ff);
        }
        boolean bl = interpolationNeeded = (nl = ff.length()) > 0 && ff.value(0) != 0.0 && ff.value(nl - 1) != (double)(dsSource.length() - 1);
        if (!interpolationNeeded) {
            for (int i = 0; i < ff.length(); ++i) {
                if (ff.value(i) == (double)i) continue;
                interpolationNeeded = true;
                break;
            }
        }
        if (interpolationNeeded) {
            dsSource = Ops.interpolate(dsSource, ff);
        } else {
            logger.fine("no interpolation needed");
        }
        return dsSource;
    }

    public static QDataSet synchronize(QDataSet ds1, QDataSet ds) {
        List<QDataSet> dss = Ops.synchronize(ds1, new QDataSet[]{ds});
        return dss.get(0);
    }

    public static List<QDataSet> synchronize(QDataSet dsTarget, QDataSet ... dsSources) {
        QDataSet ttTarget = (QDataSet)dsTarget.property("DEPEND_0");
        if (ttTarget == null && Schemes.isEventsList(dsTarget) && Schemes.isRank2Bins(dsTarget)) {
            QDataSet dt = Ops.subtract(Ops.unbundle(dsTarget, 1), Ops.unbundle(dsTarget, 0));
            ttTarget = Ops.add(Ops.unbundle(dsTarget, 0), Ops.divide((Object)dt, 2));
        }
        if (ttTarget == null && DataSetUtil.isMonotonic(dsTarget)) {
            ttTarget = dsTarget;
        }
        if (ttTarget == null) {
            throw new IllegalArgumentException("unable to find timetags");
        }
        if (ttTarget.length() > 1 && ttTarget.value(0) == ttTarget.value(1)) {
            throw new IllegalArgumentException("Timetags of the target have repeating values");
        }
        ArrayList<QDataSet> result = new ArrayList<QDataSet>();
        int iarg = 0;
        for (QDataSet dsSource : dsSources) {
            int nl;
            boolean interpolationNeeded;
            QDataSet ff;
            if (dsSource == dsTarget) {
                result.add(dsSource);
                continue;
            }
            QDataSet ttSource = (QDataSet)dsSource.property("DEPEND_0");
            if (ttSource == null) {
                if (SemanticOps.getUnits(dsSource).isConvertibleTo(SemanticOps.getUnits(ttTarget))) {
                    result.add(ttTarget);
                    continue;
                }
                throw new IllegalArgumentException("dataset (number " + (iarg + 1) + " of " + dsSources.length + ") sent to synchronize doesn't have timetags: " + dsSource);
            }
            if (ttSource.length() != dsSource.length()) {
                throw new IllegalArgumentException("malformed dataset (number " + (iarg + 1) + " of " + dsSources.length + ") DEPEND_0 length not correct: " + ttSource + " " + dsSource);
            }
            try {
                ff = Ops.findex(ttSource, ttTarget);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.WARNING, "when calling synchronize, DEPEND_0 was not monotonic for dss argument #{0}, using monotonic subset of points", iarg);
                MutablePropertyDataSet dsx = Ops.monotonicSubset(dsSource);
                logger.log(Level.INFO, "monotonicSubset removes {0} records", dsSource.length() - dsx.length());
                dsSource = dsx;
                ttSource = (QDataSet)dsSource.property("DEPEND_0");
                ff = Ops.findex(ttSource, ttTarget);
            }
            boolean nn = UnitsUtil.isOrdinalMeasurement((Units)SemanticOps.getUnits(dsSource));
            QDataSet dep1 = (QDataSet)dsSource.property("DEPEND_1");
            if (dep1 != null && dep1.rank() == 2) {
                logger.info("since dep1 is time-varying, NN interpolation will be used.");
                nn = true;
            }
            if (nn) {
                ff = Ops.round(ff);
            }
            boolean bl = interpolationNeeded = (nl = ff.length()) > 0 && ff.value(0) != 0.0 && ff.value(nl - 1) != (double)(dsSource.length() - 1);
            if (!interpolationNeeded) {
                for (int i = 0; i < ff.length(); ++i) {
                    if (ff.value(i) == (double)i) continue;
                    interpolationNeeded = true;
                    break;
                }
            }
            if (interpolationNeeded) {
                dsSource = Ops.interpolate(dsSource, ff);
            } else {
                logger.fine("no interpolation needed");
            }
            QDataSet tlimit = DataSetUtil.guessCadenceNew(ttSource, null);
            if (tlimit != null) {
                tlimit = Ops.multiply(tlimit, Ops.dataset(1.5));
                Number fillValue = (Number)dsSource.property("FILL_VALUE");
                if (fillValue == null) {
                    fillValue = Double.NaN;
                }
                QDataSet iceil = Ops.lesserOf((Object)Ops.greaterOf((Object)Ops.ceil(ff), 0), ttSource.length() - 1);
                WritableDataSet tcel = Ops.applyIndex(ttSource, iceil);
                QDataSet iflr = Ops.lesserOf((Object)Ops.greaterOf((Object)Ops.floor(ff), 0), ttSource.length() - 1);
                WritableDataSet tflr = Ops.applyIndex(ttSource, iflr);
                QDataSet tdff = Ops.subtract(tcel, tflr);
                QDataSet r = Ops.where(Ops.gt(tdff, tlimit));
                dsSource = Ops.putValues((Object)dsSource, (Object)r, fillValue);
            }
            result.add(dsSource);
            ++iarg;
        }
        return result;
    }

    public static QDataSet synchronizeNN(QDataSet ds1, QDataSet ds) {
        List<QDataSet> dss = Ops.synchronizeNN(ds1, new QDataSet[]{ds});
        return dss.get(0);
    }

    public static List<QDataSet> synchronizeNN(QDataSet dsTarget, QDataSet ... dsSources) {
        QDataSet ttTarget = (QDataSet)dsTarget.property("DEPEND_0");
        if (ttTarget == null && DataSetUtil.isMonotonic(dsTarget)) {
            ttTarget = dsTarget;
        }
        ArrayList<QDataSet> result = new ArrayList<QDataSet>();
        int iarg = 0;
        for (QDataSet dsSource : dsSources) {
            QDataSet ff;
            if (dsSource == dsTarget) {
                result.add(dsSource);
                continue;
            }
            QDataSet tt1 = (QDataSet)dsSource.property("DEPEND_0");
            QDataSet ttSource = (QDataSet)dsSource.property("DEPEND_0");
            if (ttSource == null) {
                if (SemanticOps.getUnits(dsSource).isConvertibleTo(SemanticOps.getUnits(ttTarget))) {
                    result.add(ttTarget);
                    continue;
                }
                throw new IllegalArgumentException("dataset (number " + (iarg + 1) + " of " + dsSources.length + ") sent to synchronize doesn't have timetags: " + dsSource);
            }
            if (ttSource.length() != dsSource.length()) {
                throw new IllegalArgumentException("malformed dataset (number " + (iarg + 1) + " of " + dsSources.length + ") DEPEND_0 length not correct: " + ttSource + " " + dsSource);
            }
            try {
                ff = Ops.findex(tt1, ttTarget);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.WARNING, "when calling synchronize, DEPEND_0 was not monotonic for dss argument #{0}, using monotonic subset of points", iarg);
                MutablePropertyDataSet dsx = Ops.monotonicSubset(dsSource);
                logger.log(Level.INFO, "monotonicSubset removes {0} records", dsSource.length() - dsx.length());
                dsSource = dsx;
                tt1 = (QDataSet)dsSource.property("DEPEND_0");
                if (tt1 == null) {
                    if (iarg == 0) {
                        throw new IllegalArgumentException("unable to find timetags for first dataset: " + dsSource);
                    }
                    throw new IllegalArgumentException("unable to find timetags for dataset #" + (iarg + 1) + ": " + dsSource);
                }
                ff = Ops.findex(tt1, ttTarget);
            }
            QDataSet iff = Ops.round(ff);
            dsSource = Ops.interpolate(dsSource, iff);
            QDataSet tlimit = DataSetUtil.guessCadenceNew(tt1, null);
            if (tlimit != null) {
                tlimit = Ops.multiply(tlimit, Ops.dataset(1.5));
                Number fillValue = (Number)dsSource.property("FILL_VALUE");
                if (fillValue == null) {
                    fillValue = Double.NaN;
                }
                WritableDataSet tcel = Ops.applyIndex(tt1, Ops.ceil(ff), fillValue);
                WritableDataSet tflr = Ops.applyIndex(tt1, Ops.floor(ff), fillValue);
                QDataSet tdff = Ops.subtract(tcel, tflr);
                QDataSet r = Ops.where(Ops.gt(tdff, tlimit));
                dsSource = Ops.putValues((Object)dsSource, (Object)r, fillValue);
            }
            result.add(dsSource);
            ++iarg;
        }
        return result;
    }

    public static QDataSet convertUnitsTo(QDataSet ds, Units u) {
        UnitsConverter uc = Units.getConverter((Units)SemanticOps.getUnits(ds), (Units)u);
        if (uc == UnitsConverter.IDENTITY) {
            return ds;
        }
        Class c = ArrayDataSet.guessBackingStore(ds);
        ArrayDataSet ds2 = c == Float.TYPE || c == Double.TYPE ? ArrayDataSet.copy(ds) : DDataSet.copy(ds);
        for (int i = 0; i < ds.rank(); ++i) {
            if (ds2.property("BUNDLE_" + i) == null) continue;
            ds2.putProperty("BUNDLE_" + i, null);
        }
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        QubeDataSetIterator iter = new QubeDataSetIterator(ds2);
        while (iter.hasNext()) {
            iter.next();
            if (iter.getValue(wds) > 0.0) {
                iter.putValue(ds2, uc.convert(iter.getValue(ds)));
                continue;
            }
            iter.putValue(ds2, -1.0E38);
        }
        ds2.putProperty("UNITS", u);
        ds2.putProperty("FILL_VALUE", -1.0E38);
        ds2.putProperty("VALID_MIN", null);
        ds2.putProperty("VALID_MAX", null);
        return ds2;
    }

    public static DatumRange convertUnitsTo(DatumRange dr, Units u) {
        return dr.convertTo(u);
    }

    public static Datum convertUnitsTo(Datum d, Units u) {
        return d.convertTo(u);
    }

    public static QDataSet flatten(QDataSet ds) {
        switch (ds.rank()) {
            case 0: {
                DDataSet result = DDataSet.createRank2(1, 1);
                result.putValue(0, 0, ds.value());
                DataSetUtil.copyDimensionProperties(ds, result);
                return result;
            }
            case 1: {
                QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
                QDataSet plane0 = (QDataSet)ds.property("PLANE_0");
                if (dep0 != null) {
                    if (plane0 == null) {
                        return Ops.bundle(dep0, ds);
                    }
                    return Ops.bundle(dep0, ds, plane0);
                }
                return Ops.bundle(ds);
            }
            case 2: {
                QDataSet result = DataSetOps.flattenRank2(ds);
                if (result.rank() == 1) {
                    return Ops.reform(ds, new int[]{result.length(), 1});
                }
                return result;
            }
            case 3: {
                return DataSetOps.flattenRank3(ds);
            }
            case 4: {
                return DataSetOps.flattenRank4(ds);
            }
        }
        throw new UnsupportedOperationException("only rank 0,1,and 2 supported");
    }

    public static QDataSet flattenWaveform(QDataSet ds) {
        return DataSetOps.flattenWaveform(ds);
    }

    public static QDataSet grid(QDataSet ds) {
        return DataSetOps.grid(ds);
    }

    public static QDataSet gridIrregularY(QDataSet t, QDataSet y, QDataSet z, QDataSet ytags) {
        QDataSet result = LSpec.rebin(Ops.link(t, y), z, ytags, 0);
        return result;
    }

    public static QDataSet labels(String[] labels, String context) {
        return Ops.labelsDataset(labels, context);
    }

    public static QDataSet labels(String[] labels) {
        return Ops.labelsDataset(labels, "default");
    }

    public static QDataSet labelsDataset(String[] labels, String context) {
        EnumerationUnits u;
        try {
            Units uu = Units.getByName((String)context);
            u = uu != null && uu instanceof EnumerationUnits ? (EnumerationUnits)uu : new EnumerationUnits(context);
        }
        catch (IllegalArgumentException ex) {
            u = new EnumerationUnits(context);
        }
        SDataSet result = SDataSet.createRank1(labels.length);
        for (int i = 0; i < labels.length; ++i) {
            Datum d = u.createDatum((Object)labels[i]);
            result.putValue(i, d.doubleValue((Units)u));
        }
        result.putProperty("UNITS", u);
        return result;
    }

    public static QDataSet labelsDataset(String[] labels) {
        return Ops.labelsDataset(labels, "default");
    }

    public static QDataSet labelsDataset(String label) {
        return Ops.labelsDataset(label, "default");
    }

    public static QDataSet labelsDataset(String label, String context) {
        EnumerationUnits u;
        try {
            Units uu = Units.getByName((String)context);
            u = uu != null && uu instanceof EnumerationUnits ? (EnumerationUnits)uu : new EnumerationUnits(context);
        }
        catch (IllegalArgumentException ex) {
            u = new EnumerationUnits(context);
        }
        IDataSet result = IDataSet.createRank0();
        Datum d = u.createDatum((Object)label);
        result.putValue(d.doubleValue((Units)u));
        result.putProperty("UNITS", u);
        return result;
    }

    public static QDataSet rgbColorDataset(QDataSet red, QDataSet green, QDataSet blue) {
        QDataSet[] operands = new QDataSet[2];
        CoerceUtil.coerce(red, green, false, operands);
        red = operands[0];
        green = operands[1];
        CoerceUtil.coerce(green, blue, false, operands);
        blue = operands[1];
        int[] qube = DataSetUtil.qubeDims(blue);
        IDataSet z = IDataSet.create(qube);
        QubeDataSetIterator iter = new QubeDataSetIterator(z);
        while (iter.hasNext()) {
            iter.next();
            int r1 = (int)iter.getValue(red);
            int g1 = (int)iter.getValue(green);
            int b1 = (int)iter.getValue(blue);
            iter.putValue(z, r1 * 256 * 256 + g1 * 256 + b1);
        }
        z.putProperty("UNITS", Units.rgbColor);
        return z;
    }

    public static int[] size(QDataSet ds) {
        if (ds.rank() > 1 && ds.length() > 1 && ds.length(0) != ds.length(ds.length() - 1)) {
            throw new IllegalArgumentException("dataset is not a qube, so the length of each record differs.");
        }
        return DataSetUtil.qubeDims(ds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Color colorFromString(String sval) {
        try {
            if (!sval.contains(",")) return ColorUtil.decodeColor((String)sval);
            String[] ss = sval.split(",", -2);
            if (ss.length != 3) throw new IllegalArgumentException("color identified in string should be name like 'red' or r,g,b triple like '255,0,0'");
            if (sval.contains(".")) {
                float rr = Float.parseFloat(ss[0].trim());
                float gg = Float.parseFloat(ss[1].trim());
                float bb = Float.parseFloat(ss[2].trim());
                return new Color(rr, gg, bb, 1.0f);
            }
            int rr = Integer.parseInt(ss[0].trim());
            int gg = Integer.parseInt(ss[1].trim());
            int bb = Integer.parseInt(ss[2].trim());
            return new Color(rr, gg, bb, 255);
        }
        catch (NumberFormatException ex) {
            Color c = (Color)ClassMap.getEnumElement(Color.class, (String)sval);
            if (c != null) return c;
            throw new IllegalArgumentException("color identified in string should be name like 'red' or r,g,b triple like '255,0,0'");
        }
    }

    private static void sliceProperties(int removeDim, QDataSet ds, MutablePropertyDataSet result) {
        Ops.size(ds);
        for (int i = 0; i < result.rank(); ++i) {
            if (i >= removeDim) {
                result.putProperty("DEPEND_" + i, ds.property("DEPEND_" + (i + 1)));
                continue;
            }
            result.putProperty("DEPEND_" + i, ds.property("DEPEND_" + i));
        }
    }

    public static QDataSet slices(QDataSet ds, Object ... args) {
        int cdim = 0;
        int sdim = 0;
        QDataSet result = ds;
        StringBuilder docStr = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Integer) {
                int sliceIdx = (Integer)args[i];
                if (cdim == i) {
                    result = result.slice(sliceIdx);
                    ++cdim;
                } else {
                    switch (i - sdim) {
                        case 1: {
                            result = DataSetOps.slice1(result, sliceIdx);
                            break;
                        }
                        case 2: {
                            result = DataSetOps.slice2(result, sliceIdx);
                            break;
                        }
                        case 3: {
                            result = DataSetOps.slice3(result, sliceIdx);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("slice not implemented, too many slices follow non-slice");
                        }
                    }
                }
                docStr.append(sliceIdx);
                ++sdim;
            } else if (args[i] instanceof String) {
                String s = (String)args[i];
                if (s.contains("=")) {
                    throw new IllegalArgumentException("argument not supported in this version: " + s);
                }
                docStr.append(s);
            }
            if (i >= args.length - 1) continue;
            docStr.append(",");
        }
        logger.log(Level.FINER, "slices({0})", docStr.toString());
        return result;
    }

    public static QDataSet reform(QDataSet ds) {
        int[] dsqube = DataSetUtil.qubeDims(ds);
        ArrayList<Integer> newQube = new ArrayList<Integer>();
        boolean foundDim = false;
        int removeDim = -1;
        for (int i = 0; i < dsqube.length; ++i) {
            if (dsqube[i] != 1 || foundDim) {
                newQube.add(dsqube[i]);
                continue;
            }
            foundDim = true;
            removeDim = i;
        }
        if (!foundDim) {
            return ds;
        }
        int[] qube = new int[newQube.size()];
        for (int i = 0; i < newQube.size(); ++i) {
            qube[i] = (Integer)newQube.get(i);
        }
        MutablePropertyDataSet result = (MutablePropertyDataSet)Ops.reform(ds, qube);
        Ops.sliceProperties(removeDim, ds, result);
        return result;
    }

    public static QDataSet reform(QDataSet ds, int nrec, int[] qube) {
        if (nrec != ds.length()) {
            throw new IllegalArgumentException("rec should be equal to the number of records in ds");
        }
        int[] newArray = new int[qube.length + 1];
        newArray[0] = nrec;
        System.arraycopy(qube, 0, newArray, 1, qube.length);
        MutablePropertyDataSet mpds = (MutablePropertyDataSet)Ops.reform(ds, newArray);
        if (nrec == ds.length()) {
            mpds.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        }
        return mpds;
    }

    public static QDataSet reform(QDataSet ds, int[] qube) {
        QubeDataSetIterator it0 = new QubeDataSetIterator(ds);
        DDataSet result = DDataSet.create(qube);
        QubeDataSetIterator it1 = new QubeDataSetIterator(result);
        while (it0.hasNext() && it1.hasNext()) {
            it0.next();
            it1.next();
            double v = it0.getValue(ds);
            it1.putValue(result, v);
        }
        if (it0.hasNext() != it1.hasNext()) {
            throw new IllegalArgumentException("reform fails because different number of elements: " + it0 + " -> " + it1);
        }
        DataSetUtil.copyDimensionProperties(ds, result);
        return result;
    }

    public static QDataSet reform(Object ds, int[] qube) {
        return Ops.reform(Ops.dataset(ds), qube);
    }

    public static QDataSet xtags(QDataSet ds) {
        return SemanticOps.xtagsDataSet(ds);
    }

    public static QDataSet ytags(QDataSet ds) {
        return SemanticOps.ytagsDataSet(ds);
    }

    public static QDataSet boundsDataset(String s) {
        String[] ss = s.split(";", -2);
        if (ss.length == 1) {
            if (s.contains("to")) {
                ss = s.split("to");
                if (ss.length == 2) {
                    Datum d1 = Ops.datum(ss[0]);
                    Datum d2 = Ops.datum(ss[1]);
                    return Ops.dataset(DatumRange.newRange((Datum)d1, (Datum)d2));
                }
                return Ops.dataset(Ops.datumRange(ss[0]));
            }
            return Ops.dataset(Ops.datumRange(ss[0]));
        }
        JoinDataSet jds = new JoinDataSet(2);
        for (int i = 0; i < ss.length; ++i) {
            jds.join(Ops.dataset(Ops.datumRange(ss[i])));
        }
        jds.makeImmutable();
        return jds;
    }

    public static QDataSet bundle(QDataSet ds) {
        return Ops.bundle(null, ds);
    }

    public static QDataSet bundle(QDataSet ds1, QDataSet ds2) {
        if (ds1 == null && ds2 == null) {
            throw new NullPointerException("both ds1 and ds2 are null");
        }
        if (ds1 == null) {
            BundleDataSet ds;
            if (ds2.rank() == 0) {
                ds = BundleDataSet.createRank0Bundle();
                ds.bundle(ds2);
            } else {
                ds = new BundleDataSet(ds2.rank() + 1);
                ds.bundle(ds2);
            }
            QDataSet dep0 = (QDataSet)ds2.property("DEPEND_0");
            if (dep0 != null && ds.rank() < 3) {
                ds.putProperty("DEPEND_0", dep0);
            }
            return ds;
        }
        if (ds2 == null) {
            throw new NullPointerException("ds2 is null while ds1 (" + ds1 + ") is not null.");
        }
        if (ds1.rank() == ds2.rank()) {
            QDataSet dep1;
            if (ds1.rank() > 1) {
                TailBundleDataSet ds = new TailBundleDataSet(ds1.rank() + 1);
                ds.bundle(ds1);
                ds.bundle(ds2);
                for (int k = 0; k < ds1.rank(); ++k) {
                    if (ds1.rank() <= k) continue;
                    String depName = "DEPEND_" + k;
                    QDataSet d1 = (QDataSet)ds1.property(depName);
                    QDataSet d2 = (QDataSet)ds2.property(depName);
                    if (d1 == null || d2 == null || !Ops.equivalent(d1, d2)) continue;
                    ds.putProperty(depName, d1);
                }
                return ds;
            }
            BundleDataSet ds = new BundleDataSet(ds1.rank() + 1);
            ds.bundle(ds1);
            ds.bundle(ds2);
            QDataSet dep0 = (QDataSet)ds1.property("DEPEND_0");
            if (dep0 != null && (dep1 = (QDataSet)ds2.property("DEPEND_0")) != null && dep1.length() > 0 && Ops.equivalent(dep0.slice(0), dep1.slice(0))) {
                logger.fine("consider https://github.com/das-developers/das2java/issues/63");
            }
            return ds;
        }
        if (ds1 instanceof BundleDataSet && ds1.rank() - 1 == ds2.rank()) {
            ((BundleDataSet)ds1).bundle(ds2);
            return ds1;
        }
        if (ds1 instanceof TailBundleDataSet && ds1.rank() - 1 == ds2.rank()) {
            ((TailBundleDataSet)ds1).bundle(ds2);
            return ds1;
        }
        if (ds1.rank() - 1 == ds2.rank()) {
            switch (ds1.rank()) {
                case 4: {
                    TailBundleDataSet bds = new TailBundleDataSet(ds1.rank());
                    for (int i = 0; i < ds1.length(0, 0, 0); ++i) {
                        bds.bundle(DataSetOps.unbundle(ds1, i));
                    }
                    bds.bundle(ds2);
                    return bds;
                }
                case 3: {
                    TailBundleDataSet bds = new TailBundleDataSet(ds1.rank());
                    for (int i = 0; i < ds1.length(0, 0); ++i) {
                        bds.bundle(DataSetOps.unbundle(ds1, i));
                    }
                    bds.bundle(ds2);
                    return bds;
                }
                case 2: {
                    BundleDataSet bds = new BundleDataSet(ds1.rank());
                    for (int i = 0; i < ds1.length(0); ++i) {
                        bds.bundle(DataSetOps.unbundle(ds1, i));
                    }
                    bds.bundle(ds2);
                    return bds;
                }
                case 1: {
                    BundleDataSet bds = new BundleDataSet(ds1.rank());
                    for (int i = 0; i < ds1.length(); ++i) {
                        bds.bundle(DataSetOps.unbundle(ds1, i));
                    }
                    bds.bundle(ds2);
                    return bds;
                }
            }
            throw new IllegalArgumentException("ds1 rank must be 1,2,3, or 4");
        }
        throw new IllegalArgumentException("not supported yet: ds1 rank must be equal to or one more than ds2 rank");
    }

    public static QDataSet bundle(QDataSet ds1, QDataSet ds2, QDataSet ds3) {
        return Ops.bundle(Ops.bundle(ds1, ds2), ds3);
    }

    public static QDataSet bundle(QDataSet ds1, QDataSet ds2, QDataSet ds3, QDataSet ds4) {
        return Ops.bundle(Ops.bundle(Ops.bundle(ds1, ds2), ds3), ds4);
    }

    public static QDataSet bundle(QDataSet ds1, QDataSet ds2, QDataSet ds3, QDataSet ds4, QDataSet ds5) {
        return Ops.bundle(Ops.bundle(Ops.bundle(Ops.bundle(ds1, ds2), ds3), ds4), ds5);
    }

    public static QDataSet bundle(QDataSet ds1, QDataSet ds2, QDataSet ds3, QDataSet ds4, QDataSet ds5, QDataSet ds6) {
        return Ops.bundle(Ops.bundle(Ops.bundle(Ops.bundle(Ops.bundle(ds1, ds2), ds3), ds4), ds5), ds6);
    }

    public static QDataSet bundle(QDataSet ds1, QDataSet ds2, QDataSet ds3, QDataSet ds4, QDataSet ds5, QDataSet ds6, QDataSet ds7) {
        return Ops.bundle(Ops.bundle(Ops.bundle(Ops.bundle(Ops.bundle(Ops.bundle(ds1, ds2), ds3), ds4), ds5), ds6), ds7);
    }

    public static QDataSet unbundle(QDataSet ds, String name) {
        return DataSetOps.unbundle(ds, name);
    }

    public static QDataSet unbundle(QDataSet ds, int i) {
        return DataSetOps.unbundle(ds, i);
    }

    public static QDataSet unbundleBins(QDataSet ds, int i) {
        switch (ds.rank()) {
            case 2: {
                MutablePropertyDataSet result = DataSetOps.leafTrim(ds, i, i + 2);
                QDataSet bds = (QDataSet)result.property("BUNDLE_1");
                if (bds != null) {
                    Units u2;
                    Units u1 = (Units)bds.property("UNITS", 0);
                    if (u1 == (u2 = (Units)bds.property("UNITS", 1))) {
                        result = Ops.copy(result);
                        result.putProperty("BUNDLE_1", null);
                        result.putProperty("BINS_1", "min,max");
                        result.putProperty("UNITS", u1);
                    } else if (u2.isConvertibleTo(u1.getOffsetUnits())) {
                        result = Ops.copy(result);
                        UnitsConverter uc = u2.getConverter(u1.getOffsetUnits());
                        for (int i1 = 0; i1 < result.length(); ++i1) {
                            ((WritableDataSet)result).putValue(i1, 1, result.value(i1, 0) + uc.convert(result.value(i1, 1)));
                        }
                        result.putProperty("BUNDLE_1", null);
                        result.putProperty("BINS_1", "min,max");
                        result.putProperty("UNITS", u1);
                    }
                }
                return result;
            }
            case 1: {
                MutablePropertyDataSet result = DataSetOps.leafTrim(ds, i, i + 2);
                QDataSet bds = (QDataSet)result.property("BUNDLE_0");
                if (bds != null) {
                    Units u2;
                    Units u1 = (Units)bds.property("UNITS", 0);
                    if (u1 == (u2 = (Units)bds.property("UNITS", 1))) {
                        result = Ops.copy(result);
                        result.putProperty("BUNDLE_0", null);
                        result.putProperty("BINS_0", "min,max");
                        result.putProperty("UNITS", u1);
                    } else if (u2.isConvertibleTo(u1.getOffsetUnits())) {
                        result = Ops.copy(result);
                        UnitsConverter uc = u2.getConverter(u1.getOffsetUnits());
                        for (int i1 = 0; i1 < result.length(); ++i1) {
                            ((WritableDataSet)result).putValue(i1, 1, result.value(i1, 0) + uc.convert(result.value(i1, 1)));
                        }
                        result.putProperty("BUNDLE_0", null);
                        result.putProperty("BINS_0", "min,max");
                        result.putProperty("UNITS", u1);
                    }
                }
                return result;
            }
        }
        throw new IllegalArgumentException("rank exception, must be rank 1 or rank 2");
    }

    public static QDataSet rebundle(QDataSet bundle1, String[] names) {
        QDataSet result = null;
        for (String s : names) {
            QDataSet b = Ops.unbundle(bundle1, s);
            result = Ops.bundle(result, b);
        }
        return result;
    }

    public static QDataSet rebundle(QDataSet bundle1, int[] ii) {
        QDataSet result = null;
        for (int i : ii) {
            QDataSet b = Ops.unbundle(bundle1, i);
            result = Ops.bundle(result, b);
        }
        return result;
    }

    public static boolean isLegacyBundle(QDataSet zds) {
        if (zds.rank() == 2) {
            Units u;
            QDataSet dep1 = (QDataSet)zds.property("DEPEND_1");
            if (dep1 != null && (u = (Units)dep1.property("UNITS")) instanceof EnumerationUnits) {
                return true;
            }
        } else if (zds.rank() == 1) {
            Units u;
            Object o = zds.property("DEPEND_0");
            if (o != null && !(o instanceof QDataSet)) {
                logger.info("Somehow a string got into DEPEND_0 property.");
                return false;
            }
            QDataSet dep0 = (QDataSet)zds.property("DEPEND_0");
            if (dep0 != null && (u = (Units)dep0.property("UNITS")) instanceof EnumerationUnits) {
                return true;
            }
        }
        return false;
    }

    public static boolean isBundle(QDataSet zds) {
        if (zds.rank() == 1) {
            return zds.property("BUNDLE_0") != null;
        }
        if (zds.rank() == 2) {
            return zds.property("BUNDLE_1") != null;
        }
        if (zds.rank() == 3) {
            return zds.property("BUNDLE_2") != null;
        }
        return false;
    }

    public static QDataSet ensureMonotonic(QDataSet ds) {
        if (ds.length() == 0) {
            return ds;
        }
        if (SemanticOps.isJoin(ds)) {
            QDataSet ds1 = ds.slice(0);
            QDataSet dep0 = (QDataSet)ds1.property("DEPEND_0");
            if (Boolean.TRUE.equals(dep0.property("MONOTONIC"))) {
                return ds;
            }
            logger.warning("ensure monotonic does not support joins.");
            return ds;
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 == null) {
            return ds;
        }
        logger.entering("org.das2.qds.Ops", "ensureMonotonic");
        if (DataSetUtil.isMonotonic(dep0)) {
            return ds;
        }
        QDataSet sort = Ops.sort(dep0);
        if (ds instanceof WritableDataSet) {
            if (((WritableDataSet)ds).isImmutable()) {
                ds = Ops.copy(ds);
            }
            DataSetOps.applyIndexInSitu((WritableDataSet)ds, sort);
        } else {
            ds = Ops.copy(ds);
            DataSetOps.applyIndexInSitu((WritableDataSet)ds, sort);
        }
        dep0 = (QDataSet)ds.property("DEPEND_0");
        ((WritableDataSet)dep0).putProperty("MONOTONIC", Boolean.TRUE);
        logger.exiting("org.das2.qds.Ops", "ensureMonotonic");
        return ds;
    }

    public static QDataSet ensureMonotonicAndIncreasingWithFill(QDataSet ds) {
        int i;
        if (ds.length() == 0) {
            return ds;
        }
        if (SemanticOps.isJoin(ds)) {
            QDataSet ds1 = ds.slice(0);
            QDataSet dep0 = (QDataSet)ds1.property("DEPEND_0");
            if (Boolean.TRUE.equals(dep0.property("MONOTONIC"))) {
                return ds;
            }
            logger.warning("ensure monotonic does not support joins.");
            return ds;
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 == null) {
            return ds;
        }
        logger.entering("org.das2.qds.Ops", "ensureMonotonicWithFill");
        if (DataSetUtil.isMonotonicAndIncreasing(dep0)) {
            return ds;
        }
        QDataSet wds = DataSetUtil.weightsDataSet(dep0);
        BDataSet wdsNew = BDataSet.create(DataSetUtil.qubeDims(wds));
        for (i = 0; i < dep0.length() && wds.value(i) == 0.0; ++i) {
            wdsNew.putValue(i, 1.0);
        }
        if (i == ds.length()) {
            return ds;
        }
        WritableDataSet mdep0 = Ops.copy(dep0);
        double fill = ((Number)wds.property("SUGGEST_FILL")).doubleValue();
        double last = dep0.value(i);
        ++i;
        while (i < dep0.length()) {
            double d = dep0.value(i);
            double w = wds.value(i);
            if (w != 0.0) {
                if (d <= last) {
                    mdep0.putValue(i, fill);
                } else {
                    last = d;
                    wdsNew.putValue(i, 1.0);
                }
            }
            ++i;
        }
        logger.exiting("org.das2.qds.Ops", "ensureMonotonicWithFill");
        MutablePropertyDataSet mpds = DataSetOps.makePropertiesMutable(ds);
        mpds.putProperty("DEPEND_0", mdep0);
        mpds.putProperty("WEIGHTS", wdsNew);
        return mpds;
    }

    public static QDataSet link(QDataSet x, QDataSet y) {
        ArrayList<String> problems;
        if (y.rank() == 1) {
            ArrayDataSet yds = ArrayDataSet.copy(y);
            yds.putProperty("DEPEND_0", x);
            ArrayList<String> problems2 = new ArrayList<String>();
            if (!DataSetUtil.validate(yds, problems2)) {
                throw new IllegalArgumentException((String)problems2.get(0));
            }
            return yds;
        }
        ArrayDataSet zds = ArrayDataSet.copy(y);
        if (x != null) {
            if (zds.rank() == 0) {
                zds.putProperty("CONTEXT_0", x);
            } else {
                zds.putProperty("DEPEND_0", x);
            }
        }
        if (!DataSetUtil.validate(zds, problems = new ArrayList<String>())) {
            throw new IllegalArgumentException((String)problems.get(0));
        }
        return zds;
    }

    public static QDataSet link(QDataSet x, QDataSet y, QDataSet z) {
        ArrayList<String> problems;
        if (z.rank() == 1) {
            String xname = (String)x.property("NAME");
            String yname = (String)y.property("NAME");
            String zname = (String)z.property("NAME");
            if (xname == null) {
                xname = "data0";
            }
            if (yname == null) {
                yname = "data1";
            }
            if (zname == null) {
                zname = "data2";
            }
            QDataSet result = Ops.bundle(x, y, z);
            BundleDataSet.BundleDescriptor bds = (BundleDataSet.BundleDescriptor)result.property("BUNDLE_1");
            bds.putProperty("CONTEXT_0", 2, xname + "," + yname);
            bds.putProperty("NAME", 0, xname);
            bds.putProperty("NAME", 1, yname);
            bds.putProperty("NAME", 2, zname);
            ArrayList<String> problems2 = new ArrayList<String>();
            if (DataSetUtil.validate(result, problems2)) {
                return result;
            }
            throw new IllegalArgumentException((String)problems2.get(0));
        }
        if (z.rank() == 2 && y.rank() == 1 && Ops.isBundle(z)) {
            QDataSet z1 = DataSetOps.unbundle(z, z.length(0) - 1);
            return Ops.link(x, y, z1);
        }
        if (z.rank() == 2 && x.rank() == 2 && y.rank() == 2) {
            z = Ops.flatten(z);
            z = Ops.slice1(z, z.length(0) - 1);
            y = Ops.flatten(y);
            y = Ops.slice1(y, y.length(0) - 1);
            x = Ops.flatten(x);
            x = Ops.slice1(x, x.length(0) - 1);
            return Ops.link(x, y, z);
        }
        MutablePropertyDataSet zds = DataSetOps.makePropertiesMutable(z);
        if (x != null || zds.property("DEPEND_0") != null) {
            zds.putProperty("DEPEND_0", x);
        }
        if (y != null || zds.property("DEPEND_1") != null) {
            zds.putProperty("DEPEND_1", y);
        }
        if (!DataSetUtil.validate(zds, problems = new ArrayList<String>())) {
            throw new IllegalArgumentException((String)problems.get(0));
        }
        return zds;
    }

    public static QDataSet link(QDataSet d0, QDataSet d1, QDataSet d2, QDataSet z) {
        ArrayList<String> problems;
        if (z.rank() == 1) {
            String a1name = (String)d0.property("NAME");
            String a2name = (String)d1.property("NAME");
            String a3name = (String)d2.property("NAME");
            String a4name = (String)z.property("NAME");
            if (a1name == null) {
                a1name = "data0";
            }
            if (a2name == null) {
                a2name = "data1";
            }
            if (a3name == null) {
                a3name = "data2";
            }
            if (a4name == null) {
                a4name = "data3";
            }
            QDataSet result = Ops.bundle(Ops.bundle(Ops.bundle(d0, d1), d2), z);
            BundleDataSet.BundleDescriptor bds = (BundleDataSet.BundleDescriptor)result.property("BUNDLE_1");
            bds.putProperty("NAME", 0, a1name);
            bds.putProperty("NAME", 1, a2name);
            bds.putProperty("NAME", 2, a3name);
            bds.putProperty("NAME", 3, a4name);
            ArrayList<String> problems2 = new ArrayList<String>();
            if (DataSetUtil.validate(result, problems2)) {
                return result;
            }
            throw new IllegalArgumentException((String)problems2.get(0));
        }
        ArrayDataSet zds = ArrayDataSet.copy(z);
        if (d0 != null) {
            zds.putProperty("DEPEND_0", d0);
        }
        if (d1 != null) {
            zds.putProperty("DEPEND_1", d1);
        }
        if (d2 != null) {
            zds.putProperty("DEPEND_2", d2);
        }
        if (!DataSetUtil.validate(zds, problems = new ArrayList<String>())) {
            throw new IllegalArgumentException((String)problems.get(0));
        }
        return zds;
    }

    public static QDataSet link(QDataSet d0, QDataSet d1, QDataSet d2, QDataSet d3, QDataSet z) {
        ArrayList<String> problems;
        if (z.rank() == 1) {
            String a1name = (String)d0.property("NAME");
            String a2name = (String)d1.property("NAME");
            String a3name = (String)d2.property("NAME");
            String a4name = (String)d3.property("NAME");
            String a5name = (String)z.property("NAME");
            if (a1name == null) {
                a1name = "data0";
            }
            if (a2name == null) {
                a2name = "data1";
            }
            if (a3name == null) {
                a3name = "data2";
            }
            if (a4name == null) {
                a4name = "data3";
            }
            if (a5name == null) {
                a5name = "data4";
            }
            QDataSet result = Ops.bundle(d0, d1, d2, d3, z);
            BundleDataSet.BundleDescriptor bds = (BundleDataSet.BundleDescriptor)result.property("BUNDLE_1");
            bds.putProperty("NAME", 0, a1name);
            bds.putProperty("NAME", 1, a2name);
            bds.putProperty("NAME", 2, a3name);
            bds.putProperty("NAME", 3, a4name);
            bds.putProperty("NAME", 4, a5name);
            ArrayList<String> problems2 = new ArrayList<String>();
            if (DataSetUtil.validate(result, problems2)) {
                return result;
            }
            throw new IllegalArgumentException((String)problems2.get(0));
        }
        ArrayDataSet zds = ArrayDataSet.copy(z);
        if (d0 != null) {
            zds.putProperty("DEPEND_0", d0);
        }
        if (d1 != null) {
            zds.putProperty("DEPEND_1", d1);
        }
        if (d2 != null) {
            zds.putProperty("DEPEND_2", d2);
        }
        if (d3 != null) {
            zds.putProperty("DEPEND_3", d3);
        }
        if (!DataSetUtil.validate(zds, problems = new ArrayList<String>())) {
            throw new IllegalArgumentException((String)problems.get(0));
        }
        return zds;
    }

    public static QDataSet link(Object x, Object y) {
        return Ops.link(Ops.dataset(x), Ops.dataset(y));
    }

    public static QDataSet link(Object x, Object y, Object z) {
        return Ops.link(Ops.dataset(x), Ops.dataset(y), Ops.dataset(z));
    }

    public static QDataSet link(Object d0, Object d1, Object d2, Object z) {
        return Ops.link(Ops.dataset(d0), Ops.dataset(d1), Ops.dataset(d2), Ops.dataset(z));
    }

    public static MutablePropertyDataSet dependsOn(QDataSet ds, int dim, QDataSet dep) {
        MutablePropertyDataSet mds = DataSetOps.makePropertiesMutable(ds);
        switch (dim) {
            case 0: {
                if (dep != null && ds.length() != dep.length()) {
                    throw new IllegalArgumentException(String.format("ds.length()!=dep.length() (%d!=%d)", ds.length(), dep.length()));
                }
                mds.putProperty("DEPEND_0", dep);
                break;
            }
            case 1: {
                if (dep != null && ds.length(0) != dep.length()) {
                    throw new IllegalArgumentException(String.format("ds.length(0)!=dep.length() (%d!=%d)", ds.length(0), dep.length()));
                }
                mds.putProperty("DEPEND_1", dep);
                break;
            }
            case 2: {
                if (dep != null && ds.length(0, 0) != dep.length()) {
                    throw new IllegalArgumentException(String.format("ds.length(0,0)!=dep.length() (%d!=%d)", ds.length(0, 0), dep.length()));
                }
                mds.putProperty("DEPEND_2", dep);
                break;
            }
            case 3: {
                if (dep != null && ds.length(0, 0, 0) != dep.length()) {
                    throw new IllegalArgumentException(String.format("ds.length(0,0,0)!=dep.length() (%d!=%d)", ds.length(0, 0, 0), dep.length()));
                }
                mds.putProperty("DEPEND_3", dep);
                break;
            }
        }
        return mds;
    }

    public static QDataSet join(QDataSet ds2) {
        return Ops.join(null, ds2);
    }

    public static QDataSet join(QDataSet ds1, QDataSet ds2) {
        if (ds1 == null && ds2 == null) {
            throw new NullPointerException("both ds1 and ds2 are null");
        }
        if (ds2 == null) {
            throw new NullPointerException("ds2 is null");
        }
        if (ds1 == null) {
            QDataSet dep0;
            JoinDataSet ds = new JoinDataSet(ds2.rank() + 1);
            ds.join(ds2);
            if (ds2.rank() == 0 && (dep0 = (QDataSet)ds2.property("CONTEXT_0")) != null && dep0.rank() == 0) {
                dep0 = Ops.join(null, dep0);
                ds.putProperty("DEPEND_0", dep0);
            }
            return ds;
        }
        if (ds1.rank() == ds2.rank()) {
            JoinDataSet ds = new JoinDataSet(ds1.rank() + 1);
            ds.join(ds1);
            ds.join(ds2);
            return ds;
        }
        if (ds1 instanceof JoinDataSet && ds1.rank() - 1 == ds2.rank()) {
            ((JoinDataSet)ds1).join(ds2);
            return ds1;
        }
        throw new IllegalArgumentException("not supported yet");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QDataSet merge(QDataSet ds1, QDataSet ds2) {
        void var10_12;
        if (ds1 == null) {
            return ds2;
        }
        JoinDataSet result = new JoinDataSet(ds1.rank());
        QDataSet dep01 = (QDataSet)ds1.property("DEPEND_0");
        QDataSet dep02 = (QDataSet)ds2.property("DEPEND_0");
        if (dep01 == null) {
            if (dep02 != null) throw new IllegalArgumentException("ds1 is missing DEPEND_0");
            dep01 = ds1;
            dep02 = ds2;
        } else if (dep02 == null) {
            throw new IllegalArgumentException("ds2 is missing DEPEND_0");
        }
        DataSetBuilder dep0result = new DataSetBuilder(1, ds1.length() + ds2.length());
        int n1 = dep01.length();
        int n2 = dep02.length();
        int i1 = 0;
        int i2 = 0;
        RankZeroDataSet rankZeroDataSet = DataSetUtil.guessCadenceNew(dep01, null);
        Units dep0u = SemanticOps.getUnits(dep01);
        if (rankZeroDataSet == null) {
            DRank0DataSet dRank0DataSet = DataSetUtil.asDataSet(0.0, dep0u);
        }
        QDataSet qDataSet = Ops.divide(var10_12, 2);
        while (i1 < n1 && i2 < n2) {
            if (Ops.lt(Ops.abs(Ops.subtract(dep01.slice(i1), dep02.slice(i2))), qDataSet).value() != 0.0) {
                dep0result.putValue(-1, DataSetUtil.asDatum(dep01.slice(i1)));
                result.join(ds1.slice(i1++));
                ++i2;
            } else if (Ops.le(dep01.slice(i1), dep02.slice(i2)).value() > 0.0) {
                dep0result.putValue(-1, DataSetUtil.asDatum(dep01.slice(i1)));
                result.join(ds1.slice(i1++));
            } else {
                dep0result.putValue(-1, DataSetUtil.asDatum(dep02.slice(i2)));
                result.join(ds2.slice(i2++));
            }
            dep0result.nextRecord();
        }
        while (i1 < n1) {
            dep0result.putValue(-1, DataSetUtil.asDatum(dep01.slice(i1)));
            dep0result.nextRecord();
            result.join(ds1.slice(i1++));
        }
        while (i2 < n2) {
            dep0result.putValue(-1, DataSetUtil.asDatum(dep02.slice(i2)));
            dep0result.nextRecord();
            result.join(ds2.slice(i2++));
        }
        result.putProperty("DEPEND_0", dep0result.getDataSet());
        return result;
    }

    public static String guessLabel(QDataSet ds) {
        String s = (String)ds.property("LABEL");
        if (s == null || s.equals("")) {
            s = Ops.guessName(ds);
        }
        return s;
    }

    public static String guessLabel(QDataSet ds, String deft) {
        String s = (String)ds.property("LABEL");
        if (s == null) {
            s = Ops.guessName(ds, deft);
        }
        return s;
    }

    public static String guessName(QDataSet ds) {
        return Ops.guessName(ds, null);
    }

    public static String guessName(QDataSet ds, String deft) {
        String label = (String)ds.property("NAME");
        if (label != null && label.length() == 0) {
            logger.log(Level.WARNING, "dataset has zero-length name: {0}", ds);
            label = null;
        }
        if (label == null && (label = (String)ds.property("LABEL")) != null) {
            label = Ops.safeName(label);
        }
        if (label == null) {
            return deft == null ? null : Ops.safeName(deft);
        }
        return Ops.safeName(label);
    }

    public static String saferName(String suggest) {
        return suggest.trim().replaceAll("\\|", "_");
    }

    public static boolean isSafeName(String name) {
        if (name.length() < 1) {
            return false;
        }
        if (Character.isJavaIdentifierStart(name.charAt(0)) && name.charAt(0) < '\u0080') {
            for (int i = 1; i < name.length(); ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i)) && name.charAt(0) < '\u0080') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String safeName(String suggest) {
        StringBuilder result;
        if (suggest.startsWith("|") && suggest.endsWith("|")) {
            suggest = suggest.substring(1, suggest.length() - 1) + "_mag";
        }
        if ((result = new StringBuilder(suggest.replaceAll(" ", "_"))).length() == 0) {
            return "ds";
        }
        if (!Character.isJavaIdentifierStart(result.charAt(0))) {
            if (!Character.isJavaIdentifierPart(result.charAt(0))) {
                result.replace(0, 1, "_");
            } else {
                result.insert(0, "_");
            }
        }
        for (int i = 1; i < result.length(); ++i) {
            if (result.charAt(i) == '.') {
                result.replace(i, i + 1, "pt");
                ++i;
                continue;
            }
            if (result.charAt(i) == '*') {
                result.replace(i, i + 1, "star");
                i += 3;
                continue;
            }
            if (result.charAt(i) == '/') {
                result.replace(i, i + 1, "div");
                i += 2;
                continue;
            }
            if (result.charAt(i) == '+') {
                result.replace(i, i + 1, "plus");
                i += 3;
                continue;
            }
            if (result.charAt(i) == '-') {
                result.replace(i, i + 1, "_");
                i += 0;
                continue;
            }
            if (result.length() > i + 1 && result.charAt(i) == '<' && result.charAt(i + 1) == '=') {
                result.replace(i, i + 2, "le");
                ++i;
                continue;
            }
            if (result.length() > i + 1 && result.charAt(i) == '>' && result.charAt(i + 1) == '=') {
                result.replace(i, i + 2, "ge");
                ++i;
                continue;
            }
            if (result.length() > i + 1 && result.charAt(i) == '<' && result.charAt(i + 1) == '>') {
                result.replace(i, i + 2, "ne");
                ++i;
                continue;
            }
            if (result.length() > i + 1 && result.charAt(i) == '!' && result.charAt(i + 1) == '=') {
                result.replace(i, i + 2, "ne");
                ++i;
                continue;
            }
            if (result.charAt(i) == '=') {
                result.replace(i, i + 1, "eq");
                ++i;
                continue;
            }
            if (result.charAt(i) == '>') {
                result.replace(i, i + 1, "gt");
                ++i;
                continue;
            }
            if (result.charAt(i) == '<') {
                result.replace(i, i + 1, "lt");
                ++i;
                continue;
            }
            if (Character.isJavaIdentifierPart(result.charAt(i))) continue;
            result.replace(i, i + 1, "_");
        }
        return result.toString();
    }

    public static boolean fillIsDifferent(QDataSet ds1, QDataSet ds2) {
        String[] props;
        for (String p : props = new String[]{"FILL_VALUE", "VALID_MIN", "VALID_MAX"}) {
            Number fill1 = (Number)ds1.property(p);
            Number fill2 = (Number)ds2.property(p);
            if (!(fill1 == null ? fill2 != null : !fill1.equals(fill2))) continue;
            return true;
        }
        return false;
    }

    public static QDataSet transpose(QDataSet ds) {
        if (ds.rank() == 1) {
            QDataSet xx = (QDataSet)ds.property("DEPEND_0");
            if (xx == null) {
                throw new IllegalArgumentException("rank 1 data must have DEPEND_0");
            }
            QDataSet yy = ds;
            return Ops.link(yy, xx);
        }
        return new TransposeRank2DataSet(ds);
    }

    public static QDataSet transpose(Object ds) {
        return Ops.transpose(Ops.dataset(ds));
    }

    public static boolean equivalent(QDataSet ds1, QDataSet ds2) {
        Units u2;
        if (ds1 != null && ds1 == ds2) {
            return true;
        }
        if (ds1 == null) {
            throw new NullPointerException("ds1 is null");
        }
        if (ds2 == null) {
            throw new NullPointerException("ds2 is null");
        }
        Units u1 = SemanticOps.getUnits(ds1);
        if (u1 != (u2 = SemanticOps.getUnits(ds2)) && u1 instanceof EnumerationUnits && u2 instanceof EnumerationUnits) {
            if (!CoerceUtil.equalGeom(ds1, ds2)) {
                return false;
            }
            QubeDataSetIterator it = new QubeDataSetIterator(ds1);
            while (it.hasNext()) {
                it.next();
                try {
                    if (u1.createDatum(it.getValue(ds1)).toString().equals(u2.createDatum(it.getValue(ds2)).toString())) continue;
                    return false;
                }
                catch (IndexOutOfBoundsException ex) {
                    return false;
                }
            }
            return true;
        }
        if (!u1.isConvertibleTo(u2)) {
            return false;
        }
        if (!CoerceUtil.equalGeom(ds1, ds2)) {
            return false;
        }
        QDataSet eq = Ops.eq(ds1, ds2);
        QDataSet veq = Ops.eq(Ops.valid(ds1), Ops.valid(ds2));
        QubeDataSetIterator it = new QubeDataSetIterator(eq);
        while (it.hasNext()) {
            it.next();
            if (it.getValue(eq) != 0.0 && it.getValue(veq) != 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean equivalent(Object ds1, Object ds2) {
        return Ops.equivalent(Ops.dataset(ds1), Ops.dataset(ds2));
    }

    public static int dimensionCount(QDataSet dss) {
        return Ops.dimensionCount(dss, false);
    }

    private static int dimensionCount(QDataSet dss, boolean noImplicit) {
        int dim = 1;
        QDataSet ds = dss;
        if (Schemes.isArrayOfBoundingBox(ds)) {
            return 3;
        }
        while (ds.rank() > 0) {
            if (ds.property("JOIN_0") == null && ds.property("BINS_0") == null) {
                if (ds.property("DEPEND_0") != null) {
                    dim += Ops.dimensionCount((QDataSet)ds.property("DEPEND_0"), true);
                } else if (ds.property("BUNDLE_0") != null) {
                    dim += ((QDataSet)ds.property("BUNDLE_0")).length();
                } else if (!noImplicit) {
                    ++dim;
                }
            }
            if (ds.length() > 0) {
                if (ds.rank() > 4) {
                    ds = ds.slice(0);
                    continue;
                }
                ds = DataSetOps.slice0(ds, 0);
                continue;
            }
            return 1;
        }
        return dim;
    }

    public static int dimensionCount(Object dss) {
        return Ops.dimensionCount(Ops.dataset(dss));
    }

    public static QDataSet fftPowerMultiThread(QDataSet ds, int len, ProgressMonitor mon) {
        ArrayList<NullProgressMonitor> mons = new ArrayList<NullProgressMonitor>();
        QDataSet[] out = new QDataSet[4];
        int length = ds.length();
        mons.add(new NullProgressMonitor());
        mons.add(new NullProgressMonitor());
        mons.add(new NullProgressMonitor());
        mons.add(new NullProgressMonitor());
        Runnable run1 = () -> {
            try {
                out[0] = Ops.fftPower(ds.trim(0, length / 4), len, (ProgressMonitor)mons.get(0));
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        };
        Runnable run2 = () -> {
            try {
                out[1] = Ops.fftPower(ds.trim(length / 4, length * 2 / 4), len, (ProgressMonitor)mons.get(1));
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        };
        Runnable run3 = () -> {
            try {
                out[2] = Ops.fftPower(ds.trim(length * 2 / 4, length * 3 / 4), len, (ProgressMonitor)mons.get(2));
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        };
        Runnable run4 = () -> {
            try {
                out[3] = Ops.fftPower(ds.trim(length * 3 / 4, length), len, (ProgressMonitor)mons.get(3));
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        };
        new Thread(run1).start();
        new Thread(run2).start();
        new Thread(run3).start();
        new Thread(run4).start();
        while (!(((ProgressMonitor)mons.get(0)).isFinished() && ((ProgressMonitor)mons.get(1)).isFinished() && ((ProgressMonitor)mons.get(2)).isFinished() && ((ProgressMonitor)mons.get(3)).isFinished())) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        QDataSet concat = null;
        for (QDataSet out1 : out) {
            concat = Ops.append(concat, out1);
        }
        return concat;
    }

    private static double volume(ProGAL.geom3d.Point a, ProGAL.geom3d.Point b, ProGAL.geom3d.Point c) {
        return Math.abs(a.x() * (b.y() * c.z() - b.z() * c.y()) - a.y() * (b.x() * c.z() - b.z() * c.x()) + a.z() * (b.x() * c.y() - b.y() * c.x())) / 6.0;
    }

    private static double area(Point a, Point b, Point c) {
        return Math.abs(a.x() * (b.y() - c.y()) + b.x() * (c.y() - a.y()) + c.x() * (a.y() - b.y())) / 2.0;
    }

    public static QDataSet buckshotInterpolate(QDataSet xyz, QDataSet data, QDataSet xinterp, QDataSet yinterp, QDataSet zinterp) {
        if (xyz.rank() != 2 || xyz.length(0) != 3) {
            throw new IllegalArgumentException("xyz must be rank 2 bundle of x,y,z positions");
        }
        if (xinterp.rank() > 2) {
            throw new IllegalArgumentException("xinterp rank can be 0,1, or 2");
        }
        if (xinterp.rank() == 2) {
            int n = DataSetUtil.totalLength(xinterp);
            xinterp = Ops.reform(xinterp, new int[]{n});
            yinterp = Ops.reform(yinterp, new int[]{n});
            zinterp = Ops.reform(zinterp, new int[]{n});
        } else if (xinterp.rank() == 0) {
            xinterp = Ops.reform(xinterp, new int[]{1});
            yinterp = Ops.reform(yinterp, new int[]{1});
            zinterp = Ops.reform(zinterp, new int[]{1});
        }
        QDataSet xx = Ops.unbundle(xyz, 0);
        QDataSet yy = Ops.unbundle(xyz, 1);
        QDataSet zz = Ops.unbundle(xyz, 2);
        Units u = SemanticOps.getUnits(xyz);
        QDataSet xx1 = Ops.rescale(Ops.append(xx, xinterp), Ops.dataset(u.createDatum(0.1)), Ops.dataset(u.createDatum(0.9)));
        QDataSet yy1 = Ops.rescale(Ops.append(yy, yinterp), Ops.dataset(u.createDatum(0.1)), Ops.dataset(u.createDatum(0.9)));
        QDataSet zz1 = Ops.rescale(Ops.append(zz, zinterp), Ops.dataset(u.createDatum(0.1)), Ops.dataset(u.createDatum(0.9)));
        int inn = xx.length();
        xx = xx1.trim(0, inn);
        yy = yy1.trim(0, inn);
        zz = zz1.trim(0, inn);
        int l = xx1.length();
        xinterp = xx1.trim(inn, l);
        yinterp = yy1.trim(inn, l);
        zinterp = zz1.trim(inn, l);
        ArrayList<PointWeighted> points = new ArrayList<PointWeighted>(xyz.length());
        for (int i = 0; i < xyz.length(); ++i) {
            points.add(new PointWeightedInt(xx.value(i), yy.value(i), zz.value(i), 1.0, i));
        }
        RegularTessellation rt = new RegularTessellation(points);
        if (xyz instanceof MutablePropertyDataSet && !((MutablePropertyDataSet)xyz).isImmutable()) {
            ((MutablePropertyDataSet)xyz).putProperty("TRIANGULATION", rt);
        }
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(xinterp));
        QDataSet wds = DataSetUtil.weightsDataSet(data);
        Number fill = (Number)wds.property("FILL_VALUE");
        double dfill = fill == null ? -1.0E38 : fill.doubleValue();
        result.putProperty("FILL_VALUE", dfill);
        boolean hasFill = false;
        QubeDataSetIterator dsi = new QubeDataSetIterator(xinterp);
        block1: while (dsi.hasNext()) {
            dsi.next();
            ProGAL.geom3d.Point thePoint = new ProGAL.geom3d.Point(dsi.getValue(xinterp), dsi.getValue(yinterp), dsi.getValue(zinterp));
            Tetr t = rt.walk(new PointWeighted(thePoint.x(), thePoint.y(), thePoint.z(), 1.0));
            ProGAL.geom3d.Point[] abcd = Arrays.copyOf(t.getCorners(), t.getCorners().length);
            PointWeightedInt[] abcdi = new PointWeightedInt[4];
            for (int k = 0; k < 4; ++k) {
                if (!(abcd[k] instanceof PointWeightedInt)) {
                    dsi.putValue(result, dfill);
                    hasFill = true;
                    continue block1;
                }
                abcdi[k] = (PointWeightedInt)abcd[k];
                abcd[k] = abcd[k].subtract(thePoint);
            }
            double[] w = new double[]{Ops.volume(abcd[1], abcd[2], abcd[3]), Ops.volume(abcd[0], abcd[2], abcd[3]), Ops.volume(abcd[0], abcd[1], abcd[3]), Ops.volume(abcd[0], abcd[1], abcd[2])};
            double n = w[0] + w[1] + w[2] + w[3];
            int k = 0;
            while (k < 4) {
                int n2 = k++;
                w[n2] = w[n2] / n;
            }
            double d = data.value(abcdi[0].idx) * w[0] + data.value(abcdi[1].idx) * w[1] + data.value(abcdi[2].idx) * w[2] + data.value(abcdi[3].idx) * w[3];
            dsi.putValue(result, d);
        }
        DataSetUtil.copyDimensionProperties(data, result);
        if (!hasFill) {
            result.putProperty("FILL_VALUE", null);
        }
        return result;
    }

    public static QDataSet polyCenters(QDataSet polyMesh) {
        if (!Schemes.isPolyMesh(polyMesh)) {
            throw new IllegalArgumentException("argument must be poly mesh");
        }
        QDataSet tri = polyMesh.slice(1);
        QDataSet xy = polyMesh.slice(0);
        QDataSet xx = Ops.slice1(xy, 0);
        QDataSet yy = Ops.slice1(xy, 1);
        DDataSet xyresult = DDataSet.createRank2(tri.length(), 2);
        for (int i = 0; i < tri.length(); ++i) {
            QDataSet tri1 = tri.slice(i);
            double x = 0.0;
            double y = 0.0;
            for (int j = 0; j < tri1.length(); ++j) {
                int k = (int)tri1.value(j);
                x += xx.value(k);
                y += yy.value(k);
            }
            xyresult.putValue(i, 0, x /= (double)xx.length());
            xyresult.putValue(i, 1, y /= (double)yy.length());
        }
        return xyresult;
    }

    public static QDataSet createPolyMesh(QDataSet append, QDataSet xy) {
        JoinDataSet result;
        if (append == null) {
            result = new JoinDataSet(3);
            result.join(xy);
            result.join(Ops.join(null, Ops.findgen(xy.length())));
        } else {
            QDataSet xy0 = append.slice(0);
            QDataSet poly = Ops.add(xy0.length(), (Object)Ops.indgen(xy.length()));
            QDataSet polys = Ops.join(append.slice(1), poly);
            QDataSet xy1 = Ops.append(xy0, xy);
            result = new JoinDataSet(3);
            result.join(xy1);
            result.join(polys);
        }
        return result;
    }

    public static QDataSet triangulate(QDataSet xx, QDataSet yy) {
        xx = Ops.rescale(xx, Ops.dataset(0), Ops.dataset(1));
        yy = Ops.rescale(yy, Ops.dataset(0), Ops.dataset(1));
        ArrayList<Point> points = new ArrayList<Point>(xx.length());
        for (int i = 0; i < xx.length(); ++i) {
            points.add(new VertexInt(xx.value(i), yy.value(i), i));
        }
        DTWithBigPoints rt = null;
        try {
            rt = new DTWithBigPoints(points);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("data cannot contain close colinear points");
        }
        List<Triangle> triangles = rt.getTriangles();
        DataSetBuilder b = new DataSetBuilder(2, 100, 3);
        triangles.forEach(t -> {
            Point o1 = t.getCorner(0);
            Point o2 = t.getCorner(1);
            Point o3 = t.getCorner(2);
            if (o1 instanceof VertexInt && o2 instanceof VertexInt && o3 instanceof VertexInt) {
                VertexInt c1 = (VertexInt)t.getCorner(0);
                VertexInt c2 = (VertexInt)t.getCorner(1);
                VertexInt c3 = (VertexInt)t.getCorner(2);
                b.nextRecord(new double[]{c1.idx, c2.idx, c3.idx});
            }
        });
        return b.getDataSet();
    }

    public static QDataSet buckshotInterpolate(QDataSet xy, QDataSet data, QDataSet xinterp, QDataSet yinterp) {
        if (xy.rank() != 2 || xy.length(0) != 2) {
            throw new IllegalArgumentException("xy must be rank 2 bundle of x,y positions");
        }
        if (xinterp.rank() > 2) {
            throw new IllegalArgumentException("xinterp rank can be 0,1, or 2");
        }
        if (xinterp.rank() == 2) {
            int n = DataSetUtil.totalLength(xinterp);
            xinterp = Ops.reform(xinterp, new int[]{n});
            yinterp = Ops.reform(yinterp, new int[]{n});
        } else if (xinterp.rank() == 0) {
            xinterp = Ops.reform(xinterp, new int[]{1});
            yinterp = Ops.reform(yinterp, new int[]{1});
        }
        QDataSet xx = Ops.unbundle(xy, 0);
        QDataSet yy = Ops.unbundle(xy, 1);
        Units u = SemanticOps.getUnits(xy);
        boolean rescale = true;
        if (rescale) {
            QDataSet xx1 = Ops.rescale(Ops.append(xx, xinterp), Ops.dataset(u.createDatum(0.1)), Ops.dataset(u.createDatum(0.9)));
            QDataSet yy1 = Ops.rescale(Ops.append(yy, yinterp), Ops.dataset(u.createDatum(0.1)), Ops.dataset(u.createDatum(0.9)));
            int inn = xx.length();
            xx = xx1.trim(0, inn);
            yy = yy1.trim(0, inn);
            int l = xx1.length();
            xinterp = xx1.trim(inn, l);
            yinterp = yy1.trim(inn, l);
        }
        ArrayList<Point> points = new ArrayList<Point>(xy.length());
        for (int i = 0; i < xy.length(); ++i) {
            points.add(new VertexInt(xx.value(i), yy.value(i), i));
        }
        DTWithBigPoints rt = new DTWithBigPoints(points);
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(xinterp));
        QDataSet wds = DataSetUtil.weightsDataSet(data);
        Number fill = (Number)wds.property("FILL_VALUE");
        double dfill = fill == null ? -1.0E38 : fill.doubleValue();
        result.putProperty("FILL_VALUE", dfill);
        boolean hasFill = false;
        QubeDataSetIterator dsi = new QubeDataSetIterator(xinterp);
        block1: while (dsi.hasNext()) {
            dsi.next();
            Point thePoint = new Point(dsi.getValue(xinterp), dsi.getValue(yinterp));
            Triangle t = rt.walk(thePoint, null);
            Point[] abc = new Point[]{t.getCorner(0), t.getCorner(1), t.getCorner(2)};
            VertexInt[] abci = new VertexInt[3];
            for (int k = 0; k < 3; ++k) {
                if (!(abc[k] instanceof VertexInt)) {
                    dsi.putValue(result, dfill);
                    hasFill = true;
                    continue block1;
                }
                abci[k] = (VertexInt)abc[k];
            }
            double[] w = new double[]{Ops.area(thePoint, abc[1], abc[2]), Ops.area(thePoint, abc[0], abc[2]), Ops.area(thePoint, abc[0], abc[1])};
            double n = w[0] + w[1] + w[2];
            int k = 0;
            while (k < 3) {
                int n2 = k++;
                w[n2] = w[n2] / n;
            }
            double d = data.value(abci[0].idx) * w[0] + data.value(abci[1].idx) * w[1] + data.value(abci[2].idx) * w[2];
            dsi.putValue(result, d);
        }
        DataSetUtil.copyDimensionProperties(data, result);
        if (!hasFill) {
            result.putProperty("FILL_VALUE", null);
        }
        result.putProperty("TRIANGULATION", rt);
        return result;
    }

    public static final QDataSet matrixParse(String smat) {
        Pattern p = Pattern.compile("\\[\\[(.*)\\,(.*)\\,(.*)\\]\\,\\[(.*)\\,(.*)\\,(.*)\\]\\,\\[(.*)\\,(.*)\\,(.*)\\]\\]");
        Matcher m = p.matcher(smat);
        if (m.matches()) {
            return DDataSet.wrap(new double[]{Double.parseDouble(m.group(1)), Double.parseDouble(m.group(2)), Double.parseDouble(m.group(3)), Double.parseDouble(m.group(4)), Double.parseDouble(m.group(5)), Double.parseDouble(m.group(6)), Double.parseDouble(m.group(7)), Double.parseDouble(m.group(8)), Double.parseDouble(m.group(9))}, new int[]{3, 3});
        }
        throw new IllegalArgumentException("smat must be [[d,d,d],[d,d,d],[d,d,d]]");
    }

    public static final QDataSet matrixFromEuler(String seq, Datum angle) {
        if (seq.length() != 1) {
            throw new IllegalArgumentException("Only x, y, or z supported");
        }
        double ang = angle.doubleValue(Units.radians);
        switch (seq.charAt(0)) {
            case 'x': {
                return DDataSet.wrap(new double[]{1.0, 0.0, 0.0, 0.0, Math.cos(ang), -Math.sin(ang), 0.0, Math.sin(ang), Math.cos(ang)}, new int[]{3, 3});
            }
            case 'y': {
                return DDataSet.wrap(new double[]{Math.cos(ang), 0.0, Math.sin(ang), 0.0, 1.0, 0.0, -Math.sin(ang), 0.0, Math.cos(ang)}, new int[]{3, 3});
            }
            case 'z': {
                return DDataSet.wrap(new double[]{Math.cos(ang), Math.sin(ang), 0.0, -Math.sin(ang), Math.cos(ang), 0.0, 0.0, 0.0, 1.0}, new int[]{3, 3});
            }
        }
        throw new IllegalArgumentException("component must be x,y, or z");
    }

    public static final QDataSet matrixMultiply(QDataSet m, QDataSet v) {
        if (m.rank() == 2 && m.length() == 3 && m.length(0) == 3) {
            if (v.length() == 3 && v.rank() == 1) {
                DDataSet result = DDataSet.wrap(new double[]{m.value(0, 0) * v.value(0) + m.value(0, 1) * v.value(1) + m.value(0, 2) * v.value(2), m.value(1, 0) * v.value(0) + m.value(1, 1) * v.value(1) + m.value(1, 2) * v.value(2), m.value(2, 0) * v.value(0) + m.value(2, 1) * v.value(1) + m.value(2, 2) * v.value(2)});
                Map<String, Object> props = Ops.copyProperties(v);
                props.remove("LABEL");
                props.remove("TITLE");
                DataSetUtil.putProperties(props, result);
                return result;
            }
            if (v.rank() == 2) {
                MutablePropertyDataSet result = DataSetOps.makePropertiesMutable(Ops.bundle(Ops.add(Ops.add(Ops.multiply(m.value(0, 0), (Object)Ops.slice1(v, 0)), Ops.multiply(m.value(0, 1), (Object)Ops.slice1(v, 1))), Ops.multiply(m.value(0, 2), (Object)Ops.slice1(v, 2))), Ops.add(Ops.add(Ops.multiply(m.value(1, 0), (Object)Ops.slice1(v, 0)), Ops.multiply(m.value(1, 1), (Object)Ops.slice1(v, 1))), Ops.multiply(m.value(1, 2), (Object)Ops.slice1(v, 2))), Ops.add(Ops.add(Ops.multiply(m.value(2, 0), (Object)Ops.slice1(v, 0)), Ops.multiply(m.value(2, 1), (Object)Ops.slice1(v, 1))), Ops.multiply(m.value(2, 2), (Object)Ops.slice1(v, 2)))));
                Map<String, Object> props = Ops.copyProperties(v);
                props.remove("LABEL");
                props.remove("TITLE");
                DataSetUtil.putProperties(props, result);
                return result;
            }
            throw new IllegalArgumentException("v must be vector or array of vectors");
        }
        if (m.rank() == 3 && m.length(0) == 3 && m.length(0, 0) == 3) {
            QDataSet a00 = Ops.slices(m, ":", 0, 0);
            QDataSet a01 = Ops.slices(m, ":", 0, 1);
            QDataSet a02 = Ops.slices(m, ":", 0, 2);
            QDataSet a10 = Ops.slices(m, ":", 1, 0);
            QDataSet a11 = Ops.slices(m, ":", 1, 1);
            QDataSet a12 = Ops.slices(m, ":", 1, 2);
            QDataSet a20 = Ops.slices(m, ":", 2, 0);
            QDataSet a21 = Ops.slices(m, ":", 2, 1);
            QDataSet a22 = Ops.slices(m, ":", 2, 2);
            MutablePropertyDataSet result = DataSetOps.makePropertiesMutable(Ops.bundle(Ops.add(Ops.add(Ops.multiply(a00, Ops.slice1(v, 0)), Ops.multiply(a01, Ops.slice1(v, 1))), Ops.multiply(a02, Ops.slice1(v, 2))), Ops.add(Ops.add(Ops.multiply(a10, Ops.slice1(v, 0)), Ops.multiply(a11, Ops.slice1(v, 1))), Ops.multiply(a12, Ops.slice1(v, 2))), Ops.add(Ops.add(Ops.multiply(a20, Ops.slice1(v, 0)), Ops.multiply(a21, Ops.slice1(v, 1))), Ops.multiply(a22, Ops.slice1(v, 2)))));
            Map<String, Object> props = Ops.copyProperties(v);
            props.remove("LABEL");
            props.remove("TITLE");
            DataSetUtil.putProperties(props, result);
            return result;
        }
        if (m.rank() == 1 && v.rank() == 2) {
            throw new IllegalArgumentException("Use matrixMultiply(transpose(m),v), not matrixMultiply(v,m)");
        }
        throw new IllegalArgumentException("m must be matrix or array of matrices, v must be vector or array of vectors");
    }

    public static String matrixFormat(QDataSet mm, String style) {
        boolean brackets;
        String rowDelim;
        String delim;
        if (mm.rank() != 2) {
            throw new IllegalArgumentException("data must be rank 2 3x3.");
        }
        StringBuilder builder = new StringBuilder();
        if (style == null) {
            style = "newlines";
        }
        if (style.equals("code")) {
            delim = ", ";
            rowDelim = ", ";
            brackets = true;
        } else {
            delim = "\t";
            rowDelim = "\n";
            brackets = false;
        }
        int nrow = 3;
        int ncol = 3;
        String format = "%.3f";
        if (brackets) {
            builder.append("[");
        }
        for (int i = 0; i < nrow; ++i) {
            if (brackets) {
                builder.append("[");
            }
            for (int j = 0; j < ncol; ++j) {
                builder.append(String.format(format, mm.value(i, j)));
                if (j >= ncol - 1) continue;
                builder.append(delim);
            }
            if (brackets) {
                builder.append("]");
            }
            if (i >= nrow - 1) continue;
            builder.append(rowDelim);
        }
        if (brackets) {
            builder.append("]");
        }
        return builder.toString();
    }

    public static final double gamma(double n) {
        double logGamma = Gamma.logGamma((double)n);
        return Math.exp(logGamma);
    }

    public static final QDataSet gamma(Object n) {
        QDataSet nn = Ops.dataset(n);
        WritableDataSet result = Ops.zeros(nn.length());
        for (int i = 0; i < nn.length(); ++i) {
            double logGamma = Gamma.logGamma((double)nn.value(i));
            result.putValue(i, Math.exp(logGamma));
        }
        return result;
    }

    private static class VertexInt
    extends Vertex {
        int idx;

        VertexInt(double x, double y, int idx) {
            super(x, y);
            this.idx = idx;
        }

        @Override
        public String toString() {
            return String.valueOf(this.idx);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof VertexInt) {
                if (((VertexInt)o).idx == this.idx) {
                    return true;
                }
                return super.equals(o);
            }
            return super.equals(o);
        }

        public int hashCode() {
            return this.idx;
        }
    }

    private static class PointWeightedInt
    extends PointWeighted {
        int idx;

        PointWeightedInt(double x, double y, double z, double w, int idx) {
            super(x, y, z, w);
            this.idx = idx;
        }

        @Override
        public String toString() {
            return String.valueOf(this.idx);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof PointWeightedInt) {
                if (((PointWeightedInt)o).idx == this.idx) {
                    return true;
                }
                return super.equals(o);
            }
            return super.equals(o);
        }

        public int hashCode() {
            return this.idx;
        }
    }

    public static enum FFTFilterType {
        Hanning,
        Hann,
        TenPercentEdgeCosine,
        Unity,
        Boxcar;

    }

    private static interface AverageOp {
        public void accum(double var1, double var3, double[] var5);

        public void initStore(double[] var1);

        public void normalize(double[] var1);
    }

    public static interface LongBinaryOp {
        public long op(long var1, long var3);
    }

    public static interface BinaryOp {
        public double op(double var1, double var3);
    }

    public static interface UnaryOp {
        public double op(double var1);
    }
}

