/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.das2Stream;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.autoplot.das2Stream.Das2StreamDataSourceFormat;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class Das2StreamDataSourceFormatEditorPanel
extends JPanel
implements DataSourceFormatEditorPanel {
    URISplit split;
    static final int BASIC_2_2 = 0;
    static final int BASIC_2_3 = 1;
    static final int GENERAL_2_4 = 2;
    static final String[] lVersions = new String[]{"2.2", "2.3/basic", "2.4/general"};
    static final String[] lVerInfo = new String[]{"<html>Version <b>2.2</b>:  The format understood by most das2 clients and utility programs <i>(recommended)</i></html>", "<html>Version <b>2.3/basic</b>:  A new format with more exact syntax for waveforms and offset spectragrams <i>(in beta test)</i></html>"};
    private int iStreamVer = 0;
    private int nSigDigit = 5;
    private int nFracSec = 3;
    private boolean bBinary = false;
    private JRadioButton btnBinary;
    private JRadioButton btnText;
    private ButtonGroup buttonGroup1;
    private JComboBox comboVersion;
    private JLabel lblFormatInfo;
    private JLabel lblFracSec;
    private JLabel lblOutputOpts;
    private JLabel lblSigDigits;
    private JLabel lblTitle;
    private JLabel lblVersion;
    private JLabel lblVersionInfo;
    private JSpinner spinFracSec;
    private JSpinner spinSigDigits;
    private BindingGroup bindingGroup;

    public Das2StreamDataSourceFormatEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.lblVersion = new JLabel();
        this.comboVersion = new JComboBox();
        this.lblTitle = new JLabel();
        this.lblOutputOpts = new JLabel();
        this.btnText = new JRadioButton();
        this.btnBinary = new JRadioButton();
        this.lblSigDigits = new JLabel();
        this.spinSigDigits = new JSpinner();
        this.lblFracSec = new JLabel();
        this.spinFracSec = new JSpinner();
        this.lblFormatInfo = new JLabel();
        this.lblVersionInfo = new JLabel();
        this.setNextFocusableComponent(this.comboVersion);
        this.setPreferredSize(new Dimension(407, 330));
        this.setLayout(new GridBagLayout());
        this.lblVersion.setText("Stream Version");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.lblVersion, gridBagConstraints);
        this.comboVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"2.2", "2.3/basic"}));
        this.comboVersion.setMaximumSize(new Dimension(200, 200));
        this.comboVersion.setMinimumSize(new Dimension(84, 25));
        this.comboVersion.setNextFocusableComponent(this.btnText);
        this.comboVersion.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Das2StreamDataSourceFormatEditorPanel.this.comboVersionItemStateChanged(evt);
            }
        });
        this.comboVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Das2StreamDataSourceFormatEditorPanel.this.comboVersionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 45;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 150);
        this.add((Component)this.comboVersion, gridBagConstraints);
        this.lblTitle.setText("Das2 Stream Export");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.lblTitle, gridBagConstraints);
        this.lblOutputOpts.setText("Output Options");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.lblOutputOpts, gridBagConstraints);
        this.buttonGroup1.add(this.btnText);
        this.btnText.setFont(new Font("Dialog", 0, 12));
        this.btnText.setSelected(true);
        this.btnText.setText("<html><b>Unicode Text</b> - Loadable by text editors</html>");
        this.btnText.setNextFocusableComponent(this.spinSigDigits);
        this.btnText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Das2StreamDataSourceFormatEditorPanel.this.btnTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 10);
        this.add((Component)this.btnText, gridBagConstraints);
        this.buttonGroup1.add(this.btnBinary);
        this.btnBinary.setFont(new Font("Dialog", 0, 12));
        this.btnBinary.setText("<html><b>Binary</b> - Efficient</html>");
        this.btnBinary.setNextFocusableComponent(this.comboVersion);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${binaryFormat}"), (Object)this.btnBinary, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.btnBinary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Das2StreamDataSourceFormatEditorPanel.this.btnBinaryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 10, 10);
        this.add((Component)this.btnBinary, gridBagConstraints);
        this.lblSigDigits.setText("Significant digits in data values");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.add((Component)this.lblSigDigits, gridBagConstraints);
        this.spinSigDigits.setModel(new SpinnerNumberModel(5, 2, 14, 1));
        this.spinSigDigits.setNextFocusableComponent(this.spinFracSec);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${significantDigits}"), (Object)this.spinSigDigits, (Property)BeanProperty.create((String)"value"));
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.btnText, (Property)ELProperty.create((String)"${selected}"), (Object)this.spinSigDigits, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.spinSigDigits.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Das2StreamDataSourceFormatEditorPanel.this.spinSigDigitsStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.spinSigDigits, gridBagConstraints);
        this.lblFracSec.setText("Fractional seconds digits in time values");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.add((Component)this.lblFracSec, gridBagConstraints);
        this.spinFracSec.setModel(new SpinnerNumberModel(3, 0, 12, 1));
        this.spinFracSec.setNextFocusableComponent(this.btnBinary);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.btnText, (Property)ELProperty.create((String)"${selected}"), (Object)this.spinFracSec, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.spinFracSec.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Das2StreamDataSourceFormatEditorPanel.this.spinFracSecStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.spinFracSec, gridBagConstraints);
        this.lblFormatInfo.setFont(new Font("Dialog", 0, 12));
        this.lblFormatInfo.setText("<html>Das2 streams may contain values and intrinsic metadata for multiple heterogeneous arrays.  Format ICD at <a href=\"http://das2.org\">http://das2.org</a></html>");
        this.lblFormatInfo.setVerticalAlignment(1);
        this.lblFormatInfo.setPreferredSize(new Dimension(325, 45));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 20, 20);
        this.add((Component)this.lblFormatInfo, gridBagConstraints);
        this.lblVersionInfo.setFont(new Font("Dialog", 0, 12));
        this.lblVersionInfo.setText("<html>Version <b>2.2</b>:  The current standard format understood by most das2 clients and utility programs <i>(recommended)</i></html>");
        this.lblVersionInfo.setVerticalAlignment(1);
        this.lblVersionInfo.setMinimumSize(new Dimension(158, 30));
        this.lblVersionInfo.setPreferredSize(new Dimension(325, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 20, 20);
        this.add((Component)this.lblVersionInfo, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void comboVersionItemStateChanged(ItemEvent evt) {
        this.iStreamVer = this.comboVersion.getSelectedIndex();
        this.lblVersionInfo.setText(lVerInfo[this.iStreamVer]);
    }

    private void btnTextActionPerformed(ActionEvent evt) {
        this.bBinary = false;
    }

    private void btnBinaryActionPerformed(ActionEvent evt) {
        this.bBinary = true;
    }

    private void spinSigDigitsStateChanged(ChangeEvent evt) {
        this.nSigDigit = ((Number)this.spinSigDigits.getValue()).intValue();
    }

    private void spinFracSecStateChanged(ChangeEvent evt) {
        this.nFracSec = ((Number)this.spinFracSec.getValue()).intValue();
    }

    private void comboVersionActionPerformed(ActionEvent evt) {
    }

    public JPanel getPanel() {
        return this;
    }

    public void setURI(String uri) {
        URISplit lsplit;
        String sVersion;
        switch (sVersion = Das2StreamDataSourceFormat.getVersion(uri)) {
            case "2.3/basic": {
                this.iStreamVer = 1;
                break;
            }
            case "2.4/general": {
                this.iStreamVer = 2;
                break;
            }
            default: {
                this.iStreamVer = 0;
            }
        }
        this.comboVersion.setSelectedIndex(this.iStreamVer);
        this.bBinary = Das2StreamDataSourceFormat.getBinary(uri);
        this.btnBinary.setSelected(this.bBinary);
        this.btnText.setSelected(!this.bBinary);
        this.nSigDigit = Das2StreamDataSourceFormat.getSigDigits(uri);
        this.spinSigDigits.setValue(this.nSigDigit);
        this.nFracSec = Das2StreamDataSourceFormat.getFracSeconds(uri);
        this.spinFracSec.setValue(this.nFracSec);
        this.split = lsplit = URISplit.parse((String)uri);
    }

    public String getURI() {
        this.split = Das2StreamDataSourceFormat.setOptions(this.split, lVersions[this.iStreamVer], this.bBinary, this.nSigDigit, this.nFracSec);
        return URISplit.format((URISplit)this.split);
    }
}

