/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.html;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public class AsciiTableStreamer
implements Iterator<QDataSet> {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.html");
    QDataSet desc = null;
    List<Units> units = null;
    Units defaultUnits = null;
    List<String> labels = null;
    List<String> names = null;
    List<String> format = null;
    List<Double> fillValues = null;
    List<QDataSet> records = Collections.synchronizedList(new LinkedList());
    QDataSet recordDescriptor;
    int fieldCount = -1;
    boolean initializedFields = false;
    boolean hasNextRecord = true;

    protected void setUnits(String units) {
        this.defaultUnits = Units.lookupUnits((String)units);
    }

    private void setUnitsAndFormat(List<String> values) {
        for (int i = 0; i < this.fieldCount; ++i) {
            String field = values.get(i).trim();
            boolean isTime = false;
            try {
                if (TimeParser.isIso8601String((String)field)) {
                    Units.cdfTT2000.parse(field);
                    isTime = true;
                } else if (field.matches("\\d+/\\d+/\\d+")) {
                    Units.cdfTT2000.parse(field);
                    isTime = true;
                }
            }
            catch (ParseException ex) {
                Logger.getLogger(AsciiTableStreamer.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.units.get(i) != null) continue;
            if (field.contains("$")) {
                this.units.set(i, Units.dollars);
                this.format.set(i, "%.2f");
                continue;
            }
            if (field.endsWith("%")) {
                this.units.set(i, Units.percent);
                this.format.set(i, null);
                continue;
            }
            if (isTime) {
                this.units.set(i, (Units)Units.us2000);
                this.format.set(i, null);
                continue;
            }
            try {
                Integer.parseInt(field);
                this.units.set(i, Units.dimensionless);
                this.format.set(i, "%d");
                continue;
            }
            catch (NumberFormatException ex) {
                try {
                    Double.parseDouble(field);
                    this.units.set(i, Units.dimensionless);
                    this.format.set(i, null);
                    continue;
                }
                catch (NumberFormatException ex2) {
                    String[] ss = field.split("\\s", -2);
                    if (ss.length > 1) {
                        try {
                            Double.parseDouble(ss[0]);
                            this.units.set(i, Units.lookupUnits((String)field.substring(ss[0].length()).trim()));
                            this.format.set(i, null);
                        }
                        catch (NumberFormatException ex3) {
                            this.units.set(i, (Units)new EnumerationUnits("default"));
                            this.format.set(i, null);
                        }
                        continue;
                    }
                    this.units.set(i, (Units)new EnumerationUnits("default"));
                    this.format.set(i, null);
                }
            }
        }
    }

    public void addRecord(List<String> values) {
        String s;
        if (this.units == null && (s = values.get(Math.min(1, values.size() - 1)).trim()).length() > 0 && Character.isAlphabetic(s.charAt(0))) {
            this.addHeader(values);
            return;
        }
        if (this.fieldCount == -1) {
            return;
        }
        if (!this.initializedFields) {
            this.setUnitsAndFormat(values);
            this.initializedFields = true;
        }
        DDataSet result = DDataSet.createRank1((int)this.fieldCount);
        for (int i = 0; i < this.fieldCount; ++i) {
            String field = values.get(i).trim();
            if (field.trim().length() == 0) {
                result.putValue(i, this.fillValues.get(i).doubleValue());
                continue;
            }
            try {
                Units u = this.units.get(i);
                double d = u instanceof EnumerationUnits ? ((EnumerationUnits)u).createDatum((Object)field).doubleValue(u) : u.parse(field).doubleValue(u);
                result.putValue(i, d);
                continue;
            }
            catch (ParseException ex) {
                result.putValue(i, this.fillValues.get(i).doubleValue());
            }
        }
        if (this.desc == null) {
            this.desc = this.getBundleDescriptor();
        }
        this.sendRecord((QDataSet)result);
    }

    public void setHasNext(boolean t) {
        this.hasNextRecord = false;
    }

    private void sendRecord(QDataSet result) {
        this.records.add(result);
    }

    protected void initialize(List<String> values) {
        int i;
        this.fieldCount = values.size();
        this.units = new ArrayList<Units>(this.fieldCount);
        for (i = 0; i < this.fieldCount; ++i) {
            this.units.add(i, this.defaultUnits);
        }
        this.format = new ArrayList<String>(this.fieldCount);
        this.labels = new ArrayList<String>(this.fieldCount);
        this.names = new ArrayList<String>(this.fieldCount);
        this.fillValues = new ArrayList<Double>(this.fieldCount);
        if (this.labels.isEmpty()) {
            for (i = 0; i < this.fieldCount; ++i) {
                this.labels.add(i, values.get(i));
                this.names.add(i, Ops.safeName((String)values.get(i)));
                this.format.add("");
                this.fillValues.add(-1.0E38);
            }
        }
    }

    public boolean hasHeader() {
        return this.fieldCount > -1;
    }

    protected void addHeader(List<String> values) {
        if (this.fieldCount == -1) {
            this.initialize(values);
        }
    }

    protected void addUnits(List<String> units) {
    }

    protected void addUnits(int icol, String units) {
    }

    private QDataSet getBundleDescriptor() {
        return new AbstractDataSet(){

            public int rank() {
                return 2;
            }

            public Object property(String name, int i) {
                switch (name) {
                    case "LABEL": {
                        return AsciiTableStreamer.this.labels.get(i);
                    }
                    case "NAME": {
                        return AsciiTableStreamer.this.names.get(i);
                    }
                    case "FORMAT": {
                        return AsciiTableStreamer.this.format.get(i);
                    }
                    case "UNITS": {
                        return AsciiTableStreamer.this.units.get(i);
                    }
                }
                return this.property(name);
            }

            public double value(int i0, int i1) {
                return 0.0;
            }

            public int length() {
                return AsciiTableStreamer.this.labels.size();
            }

            public int length(int i) {
                return 0;
            }
        };
    }

    @Override
    public boolean hasNext() {
        if (!this.records.isEmpty()) {
            return true;
        }
        while (!this.initializedFields && this.hasNextRecord) {
            Thread.yield();
        }
        while (this.records.isEmpty() && this.hasNextRecord) {
            Thread.yield();
        }
        return this.hasNextRecord;
    }

    @Override
    public QDataSet next() {
        while (this.records.isEmpty()) {
            Thread.yield();
        }
        QDataSet result = this.records.remove(0);
        return result;
    }

    @Override
    public void remove() {
    }
}

