/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.xmlfile;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.autoplot.spase.SpaseRecordDataSourceFactory;
import org.autoplot.spase.VOTableReader;
import org.autoplot.spase.XMLTypeCheck;
import org.autoplot.xmlfile.XmlfileDataSource;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class XmlFileDataSourceFactory
extends AbstractDataSourceFactory
implements DataSourceFactory {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.xml");

    public DataSource getDataSource(URI uri) throws Exception {
        return new XmlfileDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        File f = DataSetURI.getFile((String)cc.surl, (ProgressMonitor)mon);
        Object type = new XMLTypeCheck().calculateType(f);
        if (type == XMLTypeCheck.TYPE_VOTABLE) {
            QDataSet bds = new VOTableReader().readHeader(f.toString(), mon);
            if (cc.context.equals(CompletionContext.CONTEXT_PARAMETER_NAME)) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                for (int i = 0; i < bds.length(); ++i) {
                    String label = (String)bds.property("LABEL", i);
                    String name = (String)bds.property("NAME", i);
                    String title = (String)bds.property("TITLE", i);
                    String c = label;
                    if (!Ops.safeName((String)label).equals(label)) {
                        label = label + " (" + name + ")";
                    }
                    if (title == null) {
                        title = label;
                    }
                    int lim = Math.max(20, 120 - label.length());
                    if (title.length() > lim) {
                        title = title.substring(0, lim - 3) + "...";
                    }
                    CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, c, (DataSourceFactory)this, "arg_0", title, title, true);
                    result.add(cc1);
                }
                return result;
            }
            return Collections.emptyList();
        }
        if (type == XMLTypeCheck.TYPE_SPASE) {
            return new SpaseRecordDataSourceFactory().getCompletions(cc, (ProgressMonitor)new NullProgressMonitor());
        }
        return Collections.emptyList();
    }

    public String editPanel(String surl) throws Exception {
        return surl;
    }

    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) throws IllegalArgumentException {
        try {
            File f = DataSetURI.getFile((String)surl, (ProgressMonitor)mon);
            Object type = new XMLTypeCheck().calculateType(f);
            if (type == null) {
                problems.add("XML file is not supported by this reader, not one of HELM, SPASE, or VOTABLE");
                return true;
            }
            if (type == XMLTypeCheck.TYPE_VOTABLE) {
                URISplit split = URISplit.parse((String)surl);
                LinkedHashMap parms = URISplit.parseParams((String)split.params);
                if (parms.get("arg_0") == null) {
                    QDataSet bds = new VOTableReader().readHeader(f.toString(), mon);
                    int ifirstTimeStart = -1;
                    int ifirstTimeStop = -1;
                    for (int i = 0; i < bds.length(); ++i) {
                        if (bds.property("UNITS", i) == null || !UnitsUtil.isTimeLocation((Units)((Units)bds.property("UNITS", i)))) continue;
                        if (ifirstTimeStart == -1) {
                            ifirstTimeStart = i;
                            continue;
                        }
                        if (i != ifirstTimeStart + 1) continue;
                        ifirstTimeStop = ifirstTimeStart + 1;
                        break;
                    }
                    return ifirstTimeStop <= -1;
                }
                return false;
            }
            return false;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return true;
        }
    }

    public String urlForServer(String surl) {
        return surl;
    }
}

