/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDF2Impl;
import gov.nasa.gsfc.spdf.cdfj.CDF3Impl;
import gov.nasa.gsfc.spdf.cdfj.CDFAHuffman;
import gov.nasa.gsfc.spdf.cdfj.CDFHuffman;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.CDFRLE;
import gov.nasa.gsfc.spdf.cdfj.CDFUrl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.zip.GZIPInputStream;

public final class CDFFactory {
    public static final long CDF3_MAGIC = -3606538872298602497L;
    public static final long CDF3_COMPRESSED_MAGIC = -3606538868862746623L;
    public static final long CDF2_MAGIC = -3606820347275313153L;
    public static final long CDF2_MAGIC_DOT5 = 0xFFFF0000FFFFL;
    static Map cdfMap = Collections.synchronizedMap(new WeakHashMap());
    static Long maxMappedMemory;
    public static final long NO_COMPRESSION = 0L;
    public static final long RLE_COMPRESSION = 1L;
    public static final long HUFF_COMPRESSION = 2L;
    public static final long AHUFF_COMPRESSION = 3L;
    public static final long GZIP_COMPRESSION = 5L;

    private CDFFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CDFImpl getCDF(byte[] ba) throws Throwable {
        byte[] byArray = ba;
        synchronized (ba) {
            ByteBuffer buf = ByteBuffer.allocateDirect(ba.length);
            buf.put(ba);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            buf.flip();
            return CDFFactory.getVersion(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CDFImpl getCDF(ByteBuffer buf) throws Throwable {
        ByteBuffer rbuf;
        ByteBuffer byteBuffer = buf;
        synchronized (byteBuffer) {
            ByteBuffer _buf = ByteBuffer.allocateDirect(buf.remaining());
            _buf.put(buf);
            _buf.position(0);
            rbuf = _buf.asReadOnlyBuffer();
            rbuf.order(buf.order());
        }
        return CDFFactory.getVersion(rbuf);
    }

    static CDFImpl getVersion(ByteBuffer buf) throws Throwable {
        LongBuffer lbuf = buf.asLongBuffer();
        long magic = lbuf.get();
        if (magic == -3606538872298602497L) {
            return new CDF3Impl(buf);
        }
        if (magic == -3606538868862746623L) {
            ByteBuffer mbuf = CDFFactory.uncompressed(buf, 3);
            return new CDF3Impl(mbuf);
        }
        if (magic == 0xFFFF0000FFFFL) {
            int release = buf.getInt(24);
            return new CDF2Impl(buf, release);
        }
        ShortBuffer sbuf = buf.asShortBuffer();
        if (sbuf.get() == -12814 && sbuf.get() == 24578) {
            short x = sbuf.get();
            if (x == 0) {
                if (sbuf.get() == -1) {
                    return new CDF2Impl(buf, 6);
                }
            } else if (x == -13108 && sbuf.get() == 1) {
                ByteBuffer mbuf = CDFFactory.uncompressed(buf, 2);
                return new CDF2Impl(mbuf, 6);
            }
        }
        return null;
    }

    public static CDFImpl getCDF(String fname) throws Throwable {
        return CDFFactory.getCDF(fname, false);
    }

    static CDFImpl getCDF(String fname, final boolean option) throws Throwable {
        MappedByteBuffer buf;
        CDFFactory.clean();
        File file = new File(fname);
        final String _fname = file.getPath();
        try (FileInputStream fis = new FileInputStream(file);){
            FileChannel ch = fis.getChannel();
            buf = ch.map(FileChannel.MapMode.READ_ONLY, 0L, ch.size());
        }
        CDFImpl cdf = CDFFactory.getVersion(buf);
        cdf.setOption(new ProcessingOption(){

            public String missingRecordOption() {
                if (option) {
                    return "accept";
                }
                return "reject";
            }
        });
        cdf.setSource(new CDFSource(){

            @Override
            public String getName() {
                return _fname;
            }

            @Override
            public boolean isFile() {
                return true;
            }
        });
        cdfMap.put(cdf, _fname);
        return cdf;
    }

    static CDFImpl getCDF(URL url) throws Throwable {
        int got;
        int remaining;
        final String _url = url.toString();
        URLConnection con = new CDFUrl(url).openConnection();
        InputStream is = con.getInputStream();
        byte[] ba = new byte[remaining];
        int offset = 0;
        for (remaining = con.getContentLength(); remaining > 0; remaining -= got) {
            got = is.read(ba, offset, remaining);
            offset += got;
        }
        CDFImpl cdf = CDFFactory.getCDF(ba);
        cdf.setSource(new CDFSource(){

            @Override
            public String getName() {
                return _url;
            }

            @Override
            public boolean isFile() {
                return false;
            }
        });
        return cdf;
    }

    static ByteBuffer uncompressed(ByteBuffer buf, int version) {
        int offset;
        byte[] ba;
        int compression;
        int CPRoffset;
        int ulen;
        int len;
        int CCRsize;
        int DATA_OFFSET;
        if (version == 3) {
            DATA_OFFSET = 40;
            CCRsize = (int)buf.getLong(8);
            len = CCRsize - 32;
            ulen = (int)buf.getLong(28);
            CPRoffset = CCRsize + 8;
            compression = buf.getInt(CPRoffset + 12);
        } else {
            DATA_OFFSET = 28;
            CCRsize = buf.getInt(8);
            len = CCRsize - 20;
            ulen = buf.getInt(20);
            CPRoffset = CCRsize + 8;
            compression = buf.getInt(CPRoffset + 8);
        }
        byte[] udata = new byte[ulen + 8];
        ByteBuffer buffer = ByteBuffer.allocate(8);
        if (version == 3) {
            buffer.putLong(-3606538872298602497L);
        } else {
            buffer.putLong(-3606820347275313153L);
        }
        buffer.rewind();
        buffer.get(udata, 0, 8);
        if (!buf.hasArray()) {
            ba = new byte[len];
            buf.position(DATA_OFFSET);
            buf.get(ba);
            offset = 0;
        } else {
            ba = buf.array();
            offset = DATA_OFFSET;
        }
        if ((long)compression == 5L) {
            int n = 0;
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(ba, offset, len);
                GZIPInputStream gz = new GZIPInputStream(bais);
                int off = 8;
                for (int toRead = udata.length - 8; toRead > 0 && (n = gz.read(udata, off, toRead)) != -1; toRead -= n) {
                    off += n;
                }
            }
            catch (IOException ex) {
                System.out.println(ex.toString());
                return null;
            }
            if (n < 0) {
                return null;
            }
        } else if ((long)compression == 1L) {
            new CDFRLE();
            byte[] uncompressed = CDFRLE.decompress(ba, ulen);
            System.arraycopy(uncompressed, 0, udata, 8, ulen);
        } else if ((long)compression == 2L) {
            byte[] uncompressed = new CDFHuffman().decompress(ba, ulen);
            System.arraycopy(uncompressed, 0, udata, 8, ulen);
        } else if ((long)compression == 3L) {
            byte[] uncompressed = new CDFAHuffman().decompress(ba, ulen);
            System.arraycopy(uncompressed, 0, udata, 8, ulen);
        } else {
            System.out.println("**** compression: " + compression + " is not supported...");
            return null;
        }
        return ByteBuffer.wrap(udata);
    }

    private static long mappedMemoryUsed() {
        if (cdfMap.size() == 0) {
            return 0L;
        }
        Set set = cdfMap.keySet();
        Iterator it = set.iterator();
        long size = 0L;
        while (it.hasNext()) {
            size += (long)((CDFImpl)it.next()).getBuffer().limit();
        }
        return size;
    }

    public static void setMaxMappedMemory(long value) {
        if (maxMappedMemory != null && maxMappedMemory > value) {
            return;
        }
        maxMappedMemory = value;
    }

    public static void clean() {
        if (maxMappedMemory != null && CDFFactory.mappedMemoryUsed() > maxMappedMemory) {
            System.gc();
        }
    }

    public static class CDFSource {
        public String getName() {
            return "";
        }

        public boolean isFile() {
            return false;
        }

        public boolean isURL() {
            return false;
        }

        public boolean isByteArray() {
            return false;
        }

        public boolean isByteBuffer() {
            return false;
        }
    }

    public static class ProcessingOption {
        String missingRecordsOption() {
            return "reject";
        }
    }
}

