/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.BaseVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.FloatArray;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.LongBuffer;

public final class FloatVarContainer
extends BaseVarContainer
implements VDataContainer.CFloat {
    final float[] fpad;

    public FloatVarContainer(CDFImpl thisCDF, Variable var, int[] pt, boolean preserve, ByteOrder bo) throws IllegalAccessException, InvocationTargetException, Throwable {
        super(thisCDF, var, pt, preserve, bo, Float.TYPE);
        Object pad = this.thisCDF.getPadValue(var);
        if (DataTypes.typeCategory[this.type] == 5) {
            long[] lpad = (long[])pad;
            this.fpad = new float[lpad.length];
            for (int i = 0; i < lpad.length; ++i) {
                this.fpad[i] = lpad[i];
            }
        } else {
            double[] dpad = (double[])pad;
            this.fpad = new float[dpad.length];
            for (int i = 0; i < dpad.length; ++i) {
                this.fpad[i] = (float)dpad[i];
            }
        }
    }

    public FloatVarContainer(CDFImpl thisCDF, Variable var, int[] pt, boolean preserve) throws IllegalAccessException, InvocationTargetException, Throwable {
        this(thisCDF, var, pt, preserve, ByteOrder.nativeOrder());
    }

    @Override
    ByteBuffer allocateBuffer(int words) {
        ByteBuffer _buf = ByteBuffer.allocateDirect(4 * words);
        _buf.order(this.order);
        return _buf;
    }

    @Override
    public Object allocateDataArray(int size) {
        return new float[size];
    }

    @Override
    void doMissing(int records, ByteBuffer _buf, Object _data, int rec) {
        int tofill;
        float[] data = (float[])_data;
        float[] repl = null;
        try {
            repl = rec < 0 ? this.fpad : this.var.asFloatArray(new int[]{rec});
        }
        catch (Throwable th) {
            th.printStackTrace();
            System.out.println("Should not see this.");
        }
        int position = _buf.position();
        FloatBuffer fbuf = _buf.asFloatBuffer();
        for (int rem = records; rem > 0; rem -= tofill) {
            tofill = rem;
            if (tofill * this.elements > data.length) {
                tofill = data.length / this.elements;
            }
            int index = 0;
            for (int i = 0; i < tofill; ++i) {
                for (int e = 0; e < this.elements; ++e) {
                    data[index++] = repl[e];
                }
            }
            fbuf.put(data, 0, tofill * this.elements);
            position += 4 * tofill * this.elements;
        }
        _buf.position(position);
    }

    @Override
    void doData(ByteBuffer bv, int type, int elements, int toprocess, ByteBuffer _buf, Object _data) throws IllegalAccessException, InvocationTargetException {
        float[] data = (float[])_data;
        int position = _buf.position();
        FloatBuffer fbuf = _buf.asFloatBuffer();
        switch (DataTypes.typeCategory[type]) {
            case 0: {
                int processed;
                int _num;
                int ipos = bv.position();
                FloatBuffer bvf = bv.asFloatBuffer();
                for (processed = 0; processed < toprocess; processed += _num / elements) {
                    _num = (toprocess - processed) * elements;
                    if (_num > data.length) {
                        _num = data.length;
                    }
                    bvf.get(data, 0, _num);
                    ipos += 4 * _num;
                    fbuf.put(data, 0, _num);
                    position += 4 * _num;
                }
                bv.position(ipos);
                _buf.position(position);
                break;
            }
            case 1: {
                int processed;
                double[] td = new double[data.length];
                int ipos = bv.position();
                DoubleBuffer bvd = bv.asDoubleBuffer();
                while (processed < toprocess) {
                    int _num = (toprocess - processed) * elements;
                    if (_num > data.length) {
                        _num = data.length;
                    }
                    bvd.get(td, 0, _num);
                    ipos += 8 * _num;
                    for (int n = 0; n < _num; ++n) {
                        data[n] = (float)td[n];
                    }
                    fbuf.put(data, 0, _num);
                    position += 4 * _num;
                    processed += _num / elements;
                }
                bv.position(ipos);
                _buf.position(position);
                break;
            }
            case 2: {
                int processed;
                Method method = DataTypes.method[type];
                while (processed < toprocess) {
                    int _num = (toprocess - processed) * elements;
                    if (_num > data.length) {
                        _num = data.length;
                    }
                    for (int e = 0; e < _num; ++e) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        data[e] = num.floatValue();
                    }
                    fbuf.put(data, 0, _num);
                    position += 4 * _num;
                    processed += _num / elements;
                }
                _buf.position(position);
                break;
            }
            case 3: {
                int processed;
                Method method = DataTypes.method[type];
                long longInt = DataTypes.longInt[type];
                while (processed < toprocess) {
                    int _num = (toprocess - processed) * elements;
                    if (_num > data.length) {
                        _num = data.length;
                    }
                    for (int e = 0; e < _num; ++e) {
                        Number num = (Number)method.invoke((Object)bv, new Object[0]);
                        int x = num.intValue();
                        data[e] = x >= 0 ? (float)x : (float)(longInt + (long)x);
                    }
                    fbuf.put(data, 0, _num);
                    position += 4 * _num;
                    processed += _num / elements;
                }
                _buf.position(position);
                break;
            }
            case 5: {
                int processed;
                int ipos = bv.position();
                LongBuffer bvl = bv.asLongBuffer();
                long[] tl = new long[data.length];
                while (processed < toprocess) {
                    int _num = (toprocess - processed) * elements;
                    if (_num > data.length) {
                        _num = data.length;
                    }
                    bvl.get(tl, 0, _num);
                    ipos += 8 * _num;
                    for (int n = 0; n < _num; ++n) {
                        data[n] = tl[n];
                    }
                    fbuf.put(data, 0, _num);
                    position += 4 * _num;
                    processed += _num / elements;
                }
                bv.position(ipos);
                _buf.position(position);
            }
        }
    }

    public static boolean isCompatible(int type, boolean preserve) {
        return FloatVarContainer.isCompatible(type, preserve, Float.TYPE);
    }

    public Object _asArray() throws Throwable {
        int rank = this.var.getEffectiveRank();
        if (rank > 4) {
            throw new Throwable("Rank > 4 not supported yet.");
        }
        ByteBuffer buf = this.getBuffer();
        if (buf == null) {
            return null;
        }
        int words = buf.remaining() / 4;
        FloatBuffer _buf = buf.asFloatBuffer();
        int records = -1;
        switch (rank) {
            case 0: {
                Object object;
                float[] _a0 = new float[words];
                _buf.get(_a0);
                if (this.singlePoint) {
                    Float f;
                    object = f;
                    f = new Float(_a0[0]);
                } else {
                    object = _a0;
                }
                return object;
            }
            case 1: {
                int n = (Integer)this.var.getElementCount().elementAt(0);
                records = words / n;
                float[][] _a1 = new float[records][n];
                for (int r = 0; r < records; ++r) {
                    _buf.get(_a1[r]);
                }
                return this.singlePoint ? (Object)_a1[0] : _a1;
            }
            case 2: {
                int n0 = (Integer)this.var.getElementCount().elementAt(0);
                int n1 = (Integer)this.var.getElementCount().elementAt(1);
                records = words / (n0 * n1);
                float[][][] _a2 = new float[records][n0][n1];
                if (this.var.rowMajority()) {
                    for (int r = 0; r < records; ++r) {
                        for (int e = 0; e < n0; ++e) {
                            _buf.get(_a2[r][e]);
                        }
                    }
                } else {
                    for (int r = 0; r < records; ++r) {
                        for (int e0 = 0; e0 < n1; ++e0) {
                            for (int e1 = 0; e1 < n0; ++e1) {
                                _a2[r][e1][e0] = _buf.get();
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)_a2[0] : _a2;
            }
            case 3: {
                int n0 = (Integer)this.var.getElementCount().elementAt(0);
                int n1 = (Integer)this.var.getElementCount().elementAt(1);
                int n2 = (Integer)this.var.getElementCount().elementAt(2);
                records = words / (n0 * n1 * n2);
                float[][][][] _a3 = new float[records][n0][n1][n2];
                if (this.var.rowMajority()) {
                    for (int r = 0; r < records; ++r) {
                        for (int e0 = 0; e0 < n0; ++e0) {
                            for (int e1 = 0; e1 < n1; ++e1) {
                                _buf.get(_a3[r][e0][e1]);
                            }
                        }
                    }
                } else {
                    for (int r = 0; r < records; ++r) {
                        for (int e0 = 0; e0 < n2; ++e0) {
                            for (int e1 = 0; e1 < n1; ++e1) {
                                for (int e2 = 0; e2 < n0; ++e2) {
                                    _a3[r][e2][e1][e0] = _buf.get();
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)_a3[0] : _a3;
            }
            case 4: {
                int n0 = (Integer)this.var.getElementCount().elementAt(0);
                int n1 = (Integer)this.var.getElementCount().elementAt(1);
                int n2 = (Integer)this.var.getElementCount().elementAt(2);
                int n3 = (Integer)this.var.getElementCount().elementAt(3);
                records = words / (n0 * n1 * n2 * n3);
                float[][][][][] _a4 = new float[records][n0][n1][n2][n3];
                if (this.var.rowMajority()) {
                    for (int r = 0; r < records; ++r) {
                        for (int e0 = 0; e0 < n0; ++e0) {
                            for (int e1 = 0; e1 < n1; ++e1) {
                                for (int e2 = 0; e2 < n2; ++e2) {
                                    _buf.get(_a4[r][e0][e1][e2]);
                                }
                            }
                        }
                    }
                } else {
                    for (int r = 0; r < records; ++r) {
                        for (int e0 = 0; e0 < n3; ++e0) {
                            for (int e1 = 0; e1 < n2; ++e1) {
                                for (int e2 = 0; e2 < n1; ++e2) {
                                    for (int e3 = 0; e3 < n0; ++e3) {
                                        _a4[r][e3][e2][e1][e0] = _buf.get();
                                    }
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)_a4[0] : _a4;
            }
        }
        throw new Throwable("Internal error");
    }

    public void fillArray(float[] array, int offset, int first, int last) throws Throwable {
        if (this.buffers.size() == 0) {
            throw new Throwable("buffer not available");
        }
        int words = (last - first + 1) * this.elements;
        ByteBuffer b = this.getBuffer();
        int pos = (first - this.getRecordRange()[0]) * this.elements * this.getLength();
        b.position(pos);
        b.asFloatBuffer().get(array, offset, words);
    }

    @Override
    public float[] as1DArray() {
        return (float[])super.as1DArray();
    }

    @Override
    public float[] asOneDArray() {
        return (float[])super.asOneDArray(true);
    }

    @Override
    public float[] asOneDArray(boolean cmtarget) {
        return (float[])super.asOneDArray(cmtarget);
    }

    @Override
    public FloatArray asArray() throws Throwable {
        return new FloatArray(this._asArray());
    }
}

