/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import gov.nasa.gsfc.spdf.cdfj.ByteVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.StringArray;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;

public final class StringVarContainer
extends ByteVarContainer
implements VDataContainer.CString {
    public StringVarContainer(CDFImpl thisCDF, Variable var, int[] pt) throws IllegalAccessException, InvocationTargetException, Throwable {
        super(thisCDF, var, pt);
    }

    public static boolean isCompatible(int type, boolean preserve) {
        if (StringVarContainer.isCompatible(type, preserve, Byte.TYPE)) {
            boolean stringType = DataTypes.isStringType(type);
            return stringType;
        }
        return false;
    }

    @Override
    public Object _asArray() throws Throwable {
        int rank = this.var.getEffectiveRank();
        if (rank > 2) {
            throw new Throwable("Rank > 2 not supported for strings.");
        }
        ByteBuffer buf = this.getBuffer();
        if (buf == null) {
            return null;
        }
        int words = buf.remaining();
        int records = -1;
        int len = this.var.getNumberOfElements();
        byte[] ba = new byte[len];
        switch (rank) {
            case 0: {
                records = words / len;
                String[] sa = new String[records];
                for (int r = 0; r < records; ++r) {
                    buf.get(ba);
                    sa[r] = new String(ba);
                }
                return sa;
            }
            case 1: {
                int n0 = (Integer)this.var.getElementCount().elementAt(0);
                records = words / (n0 * len);
                String[][] sa1 = new String[records][n0];
                for (int r = 0; r < records; ++r) {
                    for (int e = 0; e < n0; ++e) {
                        buf.get(ba);
                        sa1[r][e] = new String(ba);
                    }
                }
                return sa1;
            }
            case 2: {
                int n0 = (Integer)this.var.getElementCount().elementAt(0);
                int n1 = (Integer)this.var.getElementCount().elementAt(1);
                records = words / (n0 * n1 * len);
                String[][][] sa11 = new String[records][n0][n1];
                for (int r = 0; r < records; ++r) {
                    for (int e1 = 0; e1 < n0; ++e1) {
                        for (int e2 = 0; e2 < n1; ++e2) {
                            buf.get(ba);
                            sa11[r][e1][e2] = new String(ba);
                        }
                    }
                }
                return sa11;
            }
        }
        throw new Throwable("Internal error");
    }

    @Override
    public byte[] as1DArray() {
        return super.as1DArray();
    }

    @Override
    public byte[] asOneDArray() {
        return super.asOneDArray();
    }

    @Override
    public byte[] asOneDArray(boolean cmtarget) {
        return super.asOneDArray(cmtarget);
    }

    @Override
    public AArray asArray() throws Throwable {
        return new StringArray(this._asArray());
    }
}

