/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.binarydatasource;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.autoplot.datasource.AbstractDataSource;
import org.das2.datum.Units;
import org.das2.qds.AbstractRank1DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.buffer.AsciiDataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;

public class BinaryDataSource
extends AbstractDataSource {
    public BinaryDataSource(URI uri) {
        super(uri);
    }

    private long parseLong(String sval) {
        String[] ssum = sval.split("\\+");
        if (ssum.length == 1) {
            String[] sprod = sval.split("\\*");
            if (sprod.length == 1) {
                int result = Integer.parseInt(sval);
                return result;
            }
            long prod = this.parseLong(sprod[0]);
            for (int i = 1; i < sprod.length; ++i) {
                prod *= this.parseLong(sprod[i]);
            }
            return prod;
        }
        long sum = this.parseLong(ssum[0]);
        for (int i = 1; i < ssum.length; ++i) {
            sum += this.parseLong(ssum[i]);
        }
        return sum;
    }

    private int getIntParameter(String name, int deflt) {
        String sval = (String)this.params.get(name);
        if (sval == null) {
            return deflt;
        }
        long l = this.parseLong(sval);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("parameter must be 32-bit integer: " + name + "=" + sval);
        }
        return (int)this.parseLong(sval);
    }

    private long getLongParameter(String name, long deflt) {
        String sval = (String)this.params.get(name);
        long result = sval == null ? deflt : this.parseLong(sval);
        return result;
    }

    private String getParameter(String name, String deflt) {
        String sval = (String)this.params.get(name);
        String result = sval == null ? deflt : sval;
        return result;
    }

    private static Object getTypeFromCode(String code) {
        Object result;
        block16: {
            block15: {
                if (code.charAt(0) != 'u') break block15;
                switch (code.charAt(1)) {
                    case 'x': {
                        result = null;
                        break block16;
                    }
                    case 'b': {
                        result = BufferDataSet.UBYTE;
                        break block16;
                    }
                    case 's': {
                        result = BufferDataSet.USHORT;
                        break block16;
                    }
                    case 'i': {
                        result = BufferDataSet.UINT;
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("bad format code: " + code);
                    }
                }
            }
            switch (code.charAt(0)) {
                case 'x': {
                    result = null;
                    break;
                }
                case 'b': {
                    result = BufferDataSet.BYTE;
                    break;
                }
                case 's': {
                    result = BufferDataSet.SHORT;
                    break;
                }
                case 'i': {
                    result = BufferDataSet.INT;
                    break;
                }
                case 'l': {
                    result = BufferDataSet.LONG;
                    break;
                }
                case 'f': {
                    result = BufferDataSet.FLOAT;
                    break;
                }
                case 'd': {
                    result = BufferDataSet.DOUBLE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("bad format code: " + code);
                }
            }
        }
        return result;
    }

    public static Object[] parseRecFormat(String recFormat) {
        Integer count = 99;
        int[] offsets = new int[count.intValue()];
        Object[] types = new Object[count.intValue()];
        String[] ss = recFormat.split(",");
        int ioff = 0;
        int ifield = 0;
        for (String s : ss) {
            Object type;
            int repeat;
            int n = s.length();
            String code = n > 1 && s.charAt(n - 2) == 'u' ? s.substring(n - 2) : s.substring(n - 1);
            if (code.length() == n) {
                repeat = 1;
                type = BinaryDataSource.getTypeFromCode(code);
            } else {
                type = BinaryDataSource.getTypeFromCode(code);
                repeat = Integer.parseInt(s.substring(0, n - code.length()));
            }
            offsets[ifield] = ioff;
            for (int j = 0; j < repeat; ++j) {
                if (type != null) {
                    types[ifield] = type;
                    offsets[ifield] = ioff;
                    ++ifield;
                    ioff += BufferDataSet.byteCount((Object)type);
                    continue;
                }
                ++ioff;
            }
        }
        Object[] result = new Object[]{offsets, types, ifield, ioff};
        return result;
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        BufferDataSet ds;
        String encoding;
        int recOffset;
        File f = this.getFile(mon);
        FileChannel fc = new FileInputStream(f).getChannel();
        final long offset = this.getLongParameter("byteOffset", 0L);
        long defLen = f.length() - offset;
        long length = this.getLongParameter("byteLength", defLen);
        if (length == defLen && f.length() - offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("default length (entire file) is bigger than 2G, which is not supported.");
        }
        int fieldCount = this.getIntParameter("fieldCount", this.params.get("depend0") == null ? 1 : 2);
        int recCount = this.getIntParameter("recCount", Integer.MAX_VALUE);
        if (f.length() < offset + length) {
            String info = String.format("(byteOffset=%d byteLength=%d file.length=%d)", offset, length, f.length());
            throw new IllegalArgumentException("byteLength and byteOffset parameters would read past the end of the file. " + info);
        }
        MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, offset, length);
        fc.close();
        String recFormat = this.getParameter("recFormat", null);
        Object[] recFormatParse = null;
        if (recFormat != null) {
            recFormatParse = BinaryDataSource.parseRecFormat(recFormat);
            fieldCount = (Integer)recFormatParse[2];
        }
        int dep0 = this.getIntParameter("depend0", -1);
        int dep0Offset = this.getIntParameter("depend0Offset", -1);
        int defltcol = dep0 == -1 && dep0Offset == -1 ? 0 : (dep0 > 0 || dep0Offset > 0 ? 0 : 1);
        int col = this.getIntParameter("column", defltcol);
        String colType = String.valueOf(BufferDataSet.UBYTE);
        if (recFormatParse != null) {
            String o = (String)this.params.get("rank2");
            if (o != null) {
                throw new IllegalArgumentException("rank2 and columnFormat are not supported");
            }
            Object[] types = (Object[])recFormatParse[1];
            colType = String.valueOf(types[col]);
        }
        String columnType = this.getParameter("type", colType);
        int recSizeBytes = this.getIntParameter("recLength", -1);
        if (recFormatParse != null) {
            recSizeBytes = (Integer)recFormatParse[3];
        }
        int recSizeBits = recSizeBytes == -1 ? BufferDataSet.bitCount((Object)columnType) * fieldCount : recSizeBytes * 8;
        if (recFormatParse == null) {
            fieldCount = recSizeBits / BufferDataSet.bitCount((Object)columnType);
        }
        int frecCount = Math.min((int)(length * 8L / (long)recSizeBits), recCount);
        int[] rank2 = null;
        String o = (String)this.params.get("rank2");
        if (o != null) {
            String s = o;
            int first = 0;
            int last = -999;
            if (s.contains(":")) {
                String[] ss = s.split(":", -2);
                if (ss[0].length() > 0) {
                    first = (int)this.parseLong(ss[0]);
                }
                if (ss.length > 1 && ss[1].length() > 0) {
                    last = (int)this.parseLong(ss[1]);
                }
            }
            if (last == -999) {
                last = fieldCount;
            }
            rank2 = new int[]{first, last};
            col = first;
            if (col < 0) {
                col = fieldCount + col;
            }
            if (first > fieldCount) {
                throw new IndexOutOfBoundsException("rank 2 index is greater than field count");
            }
            if (last > fieldCount) {
                throw new IndexOutOfBoundsException("rank 2 index is greater than field count");
            }
        }
        int[] dims = null;
        o = (String)this.params.get("dims");
        if (o != null) {
            if (o.startsWith("[")) {
                o = o.substring(1);
            }
            if (o.endsWith("]")) {
                o = o.substring(0, o.length() - 1);
            }
            String[] ss = o.split(",", -2);
            dims = new int[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                dims[i] = (int)this.parseLong(ss[i]);
            }
            rank2 = new int[]{0, DataSetUtil.product((int[])dims)};
        }
        if ((recOffset = this.getIntParameter("recOffset", -1)) == -1) {
            recOffset = recFormatParse != null ? ((int[])recFormatParse[0])[col] : col * BufferDataSet.bitCount((Object)columnType) / 8;
        }
        if ((encoding = this.getParameter("byteOrder", "little")).equals("big")) {
            buf.order(ByteOrder.BIG_ENDIAN);
        } else {
            buf.order(ByteOrder.LITTLE_ENDIAN);
        }
        if (rank2 != null) {
            if (rank2[1] == -999) {
                rank2[1] = frecCount;
            }
            if (rank2[1] < 0) {
                rank2[1] = fieldCount + rank2[1];
            }
            if (rank2[0] < 0) {
                rank2[0] = fieldCount + rank2[0];
            }
            ds = BufferDataSet.makeDataSetBits((int)2, (int)recSizeBits, (int)(recOffset * 8), (int)frecCount, (int)(rank2[1] - rank2[0]), (int)1, (int)1, (ByteBuffer)buf, (Object)columnType);
        } else {
            ds = BufferDataSet.makeDataSetBits((int)1, (int)recSizeBits, (int)(recOffset * 8), (int)frecCount, (int)1, (int)1, (int)1, (ByteBuffer)buf, (Object)columnType);
        }
        if (dep0 > -1 || dep0Offset > -1) {
            String dep0Type = this.getParameter("depend0Type", columnType);
            if (recFormatParse != null) {
                dep0Type = this.getParameter("depend0Type", String.valueOf(((Object[])recFormatParse[1])[dep0]));
            }
            if (dep0Offset == -1) {
                dep0Offset = recFormatParse == null ? BufferDataSet.byteCount((Object)dep0Type) * dep0 : ((int[])recFormatParse[0])[dep0];
            }
            BufferDataSet dep0ds = BufferDataSet.makeDataSetBits((int)1, (int)recSizeBits, (int)(dep0Offset * 8), (int)frecCount, (int)1, (int)1, (int)1, (ByteBuffer)buf, (Object)dep0Type);
            String dep0Units = this.getParameter("depend0Units", "");
            if (dep0Units.length() > 0) {
                dep0Units = dep0Units.replaceAll("\\+", " ");
                Units dep0u = Units.lookupUnits((String)dep0Units);
                dep0ds.putProperty("UNITS", (Object)dep0u);
            }
            ds.putProperty("DEPEND_0", (Object)dep0ds);
        } else {
            boolean reportOffset;
            String ro = this.getParameter("reportOffset", "F");
            boolean bl = reportOffset = !ro.startsWith("F") && !ro.equals("no");
            if (reportOffset) {
                final int finalRecSizeBytes = recSizeBits / 8;
                final int finalRecOffset = recOffset;
                AbstractRank1DataSet dep0ds = new AbstractRank1DataSet(frecCount){

                    public double value(int i) {
                        return offset + (long)finalRecOffset + (long)i * (long)finalRecSizeBytes;
                    }
                };
                dep0ds.putProperty("CADENCE", (Object)DataSetUtil.asDataSet((double)((double)recSizeBits / 8.0)));
                ds.putProperty("DEPEND_0", (Object)dep0ds);
            }
        }
        String s = (String)this.params.get("validMin");
        if (s != null) {
            ds.putProperty("VALID_MIN", (Object)Double.valueOf(s));
        }
        if ((s = (String)this.params.get("validMax")) != null) {
            ds.putProperty("VALID_MAX", (Object)Double.valueOf(s));
        }
        if ((s = (String)this.params.get("fillValue")) != null) {
            ds.putProperty("FILL_VALUE", (Object)Double.valueOf(s));
        }
        if ((s = (String)this.params.get("units")) != null) {
            if (ds instanceof AsciiDataSet) {
                Object u = s.equals("nominal") ? Units.nominal() : Units.lookupUnits((String)s);
                ((AsciiDataSet)ds).setUnits((Units)u);
                ds.putProperty("UNITS", u);
            } else {
                ds.putProperty("UNITS", (Object)Units.lookupUnits((String)s));
            }
        }
        if ((s = (String)this.params.get("format")) != null) {
            if (s.length() == 1 && !s.startsWith("%")) {
                s = "%" + s;
            }
            ds.putProperty("FORMAT", (Object)s);
        }
        if (dims != null) {
            QDataSet dds = Ops.reform((QDataSet)ds, (int)ds.length(), (int[])dims);
            return dds;
        }
        return ds;
    }
}

