/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.binarydatasource;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import org.autoplot.binarydatasource.BinaryDataSourceFactory;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.ui.ParamsTextArea;
import org.das2.qds.QDataSet;
import org.das2.qds.util.QDataSetTableModel;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;

public class BinaryDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = Logger.getLogger("apdss.binary");
    String suri;
    public JLabel infoLabel;
    public JButton jButton1;
    public JLabel jLabel1;
    public JPanel jPanel1;
    public JPopupMenu jPopupMenu1;
    public JScrollPane jScrollPane1;
    public JScrollPane jScrollPane3;
    public JScrollPane jScrollPane4;
    public JSplitPane jSplitPane2;
    public JTable jTable2;
    public JTable jTable3;
    public ParamsTextArea paramsTextArea1;
    public JMenuItem setByteOffsetMenuItem;
    public JMenuItem setDep0Offset;
    public JMenuItem setRecOffsetMenuItem;

    public BinaryDataSourceEditorPanel() {
        this.initComponents();
        InputMap im = this.paramsTextArea1.getInputMap();
        KeyStroke tab = KeyStroke.getKeyStroke("TAB");
        this.paramsTextArea1.getActionMap().put(im.get(tab), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinaryDataSourceEditorPanel.this.jButton1ActionPerformed(e);
                try {
                    Rectangle r = BinaryDataSourceEditorPanel.this.paramsTextArea1.modelToView(BinaryDataSourceEditorPanel.this.paramsTextArea1.getCaretPosition());
                    BinaryDataSourceEditorPanel.this.paramsTextArea1.showPopup(r.x, r.y);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.jTable2.setAutoResizeMode(0);
        this.jTable2.getTableHeader().setReorderingAllowed(false);
        this.jTable3.setAutoResizeMode(0);
        this.jTable3.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < this.jTable2.getColumnCount(); ++i) {
            this.jTable2.getColumnModel().getColumn(i).setPreferredWidth(this.jTable2.getFont().getSize() * 3);
            this.jTable2.getColumnModel().getColumn(i).setHeaderValue("b" + i);
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.setByteOffsetMenuItem = new JMenuItem();
        this.setRecOffsetMenuItem = new JMenuItem();
        this.setDep0Offset = new JMenuItem();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jScrollPane1 = new JScrollPane();
        this.paramsTextArea1 = new ParamsTextArea();
        this.infoLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.jTable3 = new JTable();
        this.setByteOffsetMenuItem.setText("Set Byte Offset");
        this.setByteOffsetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryDataSourceEditorPanel.this.setByteOffsetMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.setByteOffsetMenuItem);
        this.setRecOffsetMenuItem.setText("Set Record Offset");
        this.setRecOffsetMenuItem.setToolTipText("Set the offset of the data within each record");
        this.setRecOffsetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryDataSourceEditorPanel.this.setRecOffsetMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.setRecOffsetMenuItem);
        this.setDep0Offset.setText("Set Depend 0 Offset");
        this.setDep0Offset.setToolTipText("Set the offset for depend0 (the x positions)");
        this.setDep0Offset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryDataSourceEditorPanel.this.setDep0OffsetActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.setDep0Offset);
        this.setPreferredSize(new Dimension(800, 600));
        this.jSplitPane2.setOrientation(0);
        this.jScrollPane3.setHorizontalScrollBarPolicy(32);
        this.jTable2.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "Title 5", "Title 6", "Title 7", "Title 8", "Title 9", "Title 10", "Title 11", "Title 12", "Title 13", "Title 14", "Title 15", "Title 16", "Title 17", "Title 18", "Title 19", "Title 20", "Title 21", "Title 22", "Title 23", "Title 24", "Title 25", "Title 26", "Title 27", "Title 28", "Title 29", "Title 30"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable2.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                BinaryDataSourceEditorPanel.this.jTable2MouseMoved(evt);
            }
        });
        this.jTable2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BinaryDataSourceEditorPanel.this.jTable2MouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTable2);
        this.paramsTextArea1.setColumns(20);
        this.paramsTextArea1.setRows(5);
        this.paramsTextArea1.setMaximumSize(new Dimension(1000, 1000));
        this.jScrollPane1.setViewportView((Component)this.paramsTextArea1);
        this.infoLabel.setFont(new Font("Dialog", 1, 8));
        this.infoLabel.setText("jLabel2");
        this.infoLabel.setAlignmentY(0.0f);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 8));
        this.jLabel1.setText("<html>right-click to get completions.  Click update to see how it parses.</html>");
        this.jLabel1.setVerticalAlignment(1);
        this.jButton1.setText("Update");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryDataSourceEditorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jScrollPane3, -2, 0, Short.MAX_VALUE).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 241, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButton1).add(0, 0, Short.MAX_VALUE)).add((Component)this.infoLabel, -1, -1, Short.MAX_VALUE).add((Component)this.jLabel1, -1, 545, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButton1).addPreferredGap(0).add((Component)this.jLabel1, -2, -1, -2).addPreferredGap(0).add((Component)this.infoLabel, -1, -1, Short.MAX_VALUE).add(12, 12, 12)).add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE)).add(12, 12, 12).add((Component)this.jScrollPane3, -2, 68, -2)));
        this.jSplitPane2.setLeftComponent(this.jPanel1);
        this.jScrollPane4.setHorizontalScrollBarPolicy(32);
        this.jTable3.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane4.setViewportView(this.jTable3);
        this.jSplitPane2.setRightComponent(this.jScrollPane4);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSplitPane2, -1, 800, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane2, -1, 600, Short.MAX_VALUE));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            this.update();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void update() throws Exception {
        String suri1 = this.getURI();
        DataSource dss = DataSetURI.getDataSource((String)suri1);
        QDataSet ds = dss.getDataSet((ProgressMonitor)new NullProgressMonitor());
        QDataSetTableModel model = new QDataSetTableModel(ds);
        this.jTable3.setModel((TableModel)model);
        URISplit split = URISplit.parse((String)suri1);
        Map params = this.paramsTextArea1.getParams();
        LinkedHashMap<String, String> newParams = new LinkedHashMap<String, String>();
        String byteOffset = (String)params.get("byteOffset");
        if (byteOffset != null) {
            newParams.put("byteOffset", byteOffset);
        }
        newParams.put("byteLength", "100");
        split.params = URISplit.formatParams(newParams);
        if (split.params != null && split.params.length() == 0) {
            split.params = null;
        }
        String suriBytes = URISplit.format((URISplit)split);
        DataSource dss2 = DataSetURI.getDataSource((String)suriBytes);
        final QDataSet ds2 = dss2.getDataSet((ProgressMonitor)new NullProgressMonitor());
        AbstractTableModel model2 = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return 1;
            }

            @Override
            public int getColumnCount() {
                return Math.min(120, ds2.length());
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                int v = (int)ds2.value(columnIndex);
                if (v >= 32 && v <= 125) {
                    return Character.toString((char)v);
                }
                return String.format("%2X", v);
            }
        };
        this.jTable2.setModel(model2);
        int n = this.jTable2.getColumnModel().getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.jTable2.getColumnModel().getColumn(i).setPreferredWidth(this.jTable2.getFont().getSize() * 3);
            this.jTable2.getColumnModel().getColumn(i).setHeaderValue("b" + i);
        }
    }

    private void jTable2MouseClicked(MouseEvent evt) {
        this.jPopupMenu1.show((Component)evt.getSource(), evt.getX(), evt.getY());
    }

    private void setByteOffsetMenuItemActionPerformed(ActionEvent evt) {
        int col = this.jTable2.getSelectedColumn();
        int currentOffset = Integer.parseInt(this.getParam("byteOffset", "0"));
        this.setParam("byteOffset", String.valueOf(currentOffset + col));
    }

    private void setRecOffsetMenuItemActionPerformed(ActionEvent evt) {
        int col = this.jTable2.getSelectedColumn();
        this.setParam("recOffset", String.valueOf(col));
    }

    private void setDep0OffsetActionPerformed(ActionEvent evt) {
        int col = this.jTable2.getSelectedColumn();
        this.setParam("dep0Offset", String.valueOf(col));
    }

    private void jTable2MouseMoved(MouseEvent evt) {
        int col = this.jTable2.columnAtPoint(evt.getPoint());
        this.jTable2.setToolTipText("col " + col);
    }

    private String getParam(String param, String deft) {
        String suri1 = this.getURI();
        URISplit split = URISplit.parse((String)suri1);
        LinkedHashMap pp = URISplit.parseParams((String)split.params);
        String o = (String)pp.get(param);
        if (o == null) {
            return deft;
        }
        return o;
    }

    private void setParam(String param, String val) {
        String suri1 = this.getURI();
        URISplit split = URISplit.parse((String)suri1);
        LinkedHashMap pp = URISplit.parseParams((String)split.params);
        if (val == null) {
            pp.remove(param);
        } else {
            pp.put(param, val);
        }
        this.paramsTextArea1.setParams((Map)pp);
    }

    public JPanel getPanel() {
        return this;
    }

    public void setURI(String uri) {
        try {
            this.suri = uri;
            URISplit split = URISplit.parse((String)uri);
            File f = DataSetURI.getFile((URL)new URL(split.file), (ProgressMonitor)new NullProgressMonitor());
            this.infoLabel.setText("" + f.length() + " bytes");
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            this.paramsTextArea1.setParams((Map)params);
            this.paramsTextArea1.setFactory((DataSourceFactory)new BinaryDataSourceFactory(), new ArrayList());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void markProblems(List<String> problems) {
    }

    public String getURI() {
        URISplit split = URISplit.parse((String)this.suri);
        Map params = this.paramsTextArea1.getParams();
        split.params = URISplit.formatParams((Map)params);
        if (split.params != null && split.params.length() == 0) {
            split.params = null;
        }
        return URISplit.format((URISplit)split);
    }

    public boolean reject(String url) throws IOException, URISyntaxException {
        URISplit split = URISplit.parse((String)url);
        FileSystem fs = FileSystem.create((URI)DataSetURI.getWebURL((URI)DataSetURI.toUri((String)split.path)).toURI());
        return fs.isDirectory(split.file.substring(split.path.length()));
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse((String)uri);
        DataSetURI.getFile((URL)new URL(split.file), (ProgressMonitor)mon);
        return true;
    }
}

