/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.TraceFunction;
import org.python.core.imp;

class PythonTraceFunction
extends TraceFunction {
    PyObject tracefunc;

    PythonTraceFunction(PyObject tracefunc) {
        this.tracefunc = tracefunc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraceFunction safeCall(PyFrame frame, String label, PyObject arg) {
        Class clazz = imp.class;
        synchronized (clazz) {
            PythonTraceFunction pythonTraceFunction = this;
            synchronized (pythonTraceFunction) {
                ThreadState ts = Py.getThreadState();
                if (ts.tracing) {
                    return null;
                }
                if (this.tracefunc == null) {
                    return null;
                }
                PyObject ret = null;
                try {
                    ts.tracing = true;
                    ret = this.tracefunc.__call__((PyObject)frame, new PyString(label), arg);
                }
                catch (PyException exc) {
                    frame.tracefunc = null;
                    ts.systemState.tracefunc = null;
                    ts.systemState.profilefunc = null;
                    throw exc;
                }
                finally {
                    ts.tracing = false;
                }
                if (ret == this.tracefunc) {
                    return this;
                }
                if (ret == Py.None) {
                    return null;
                }
                return new PythonTraceFunction(ret);
            }
        }
    }

    public TraceFunction traceCall(PyFrame frame) {
        return this.safeCall(frame, "call", Py.None);
    }

    public TraceFunction traceReturn(PyFrame frame, PyObject ret) {
        return this.safeCall(frame, "return", ret);
    }

    public TraceFunction traceLine(PyFrame frame, int line) {
        return this.safeCall(frame, "line", Py.None);
    }

    public TraceFunction traceException(PyFrame frame, PyException exc) {
        return this.safeCall(frame, "exception", new PyTuple(new PyObject[]{exc.type, exc.value, exc.traceback}));
    }
}

