/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.imagedatasource;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.util.monitor.ProgressMonitor;

public class ImageDataSourceFormat
implements DataSourceFormat {
    public static QDataSet fromRGBtoHSV(QDataSet rgb) {
        ArrayDataSet result = ArrayDataSet.create(Float.TYPE, (int[])DataSetUtil.qubeDims((QDataSet)rgb));
        int rows = rgb.length();
        int cols = rgb.length(0);
        for (int ii = 0; ii < rows; ++ii) {
            for (int jj = 0; jj < cols; ++jj) {
                float hue;
                int cmin;
                int cmax;
                int r = (int)rgb.value(ii, jj, 0);
                int g = (int)rgb.value(ii, jj, 1);
                int b = (int)rgb.value(ii, jj, 2);
                int n = cmax = r > g ? r : g;
                if (b > cmax) {
                    cmax = b;
                }
                int n2 = cmin = r < g ? r : g;
                if (b < cmin) {
                    cmin = b;
                }
                float brightness = (float)cmax / 255.0f;
                float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
                if (saturation == 0.0f) {
                    hue = 0.0f;
                } else {
                    float redc = (float)(cmax - r) / (float)(cmax - cmin);
                    float greenc = (float)(cmax - g) / (float)(cmax - cmin);
                    float bluec = (float)(cmax - b) / (float)(cmax - cmin);
                    hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
                    if ((hue /= 6.0f) < 0.0f) {
                        hue += 1.0f;
                    }
                }
                result.putValue(ii, jj, 0, (double)(hue * 360.0f));
                result.putValue(ii, jj, 1, (double)(saturation * 100.0f));
                result.putValue(ii, jj, 2, (double)(brightness * 100.0f));
            }
        }
        return result;
    }

    public static QDataSet fromHSVtoRGB(QDataSet hsv) {
        ArrayDataSet result = ArrayDataSet.create(Float.TYPE, (int[])DataSetUtil.qubeDims((QDataSet)hsv));
        int rows = hsv.length();
        int cols = hsv.length(0);
        for (int ii = 0; ii < rows; ++ii) {
            for (int jj = 0; jj < cols; ++jj) {
                int r = 0;
                int g = 0;
                int b = 0;
                float saturation = (float)(hsv.value(ii, jj, 1) / 100.0);
                float brightness = (float)(hsv.value(ii, jj, 2) / 100.0);
                if (saturation == 0.0f) {
                    g = b = (int)(brightness * 255.0f + 0.5f);
                    r = b;
                } else {
                    float hue = (float)hsv.value(ii, jj, 0) / 360.0f;
                    float h = (hue - (float)Math.floor(hue)) * 6.0f;
                    float f = h - (float)Math.floor(h);
                    float p = brightness * (1.0f - saturation);
                    float q = brightness * (1.0f - saturation * f);
                    float t = brightness * (1.0f - saturation * (1.0f - f));
                    switch ((int)h) {
                        case 0: {
                            r = (int)(brightness * 255.0f + 0.5f);
                            g = (int)(t * 255.0f + 0.5f);
                            b = (int)(p * 255.0f + 0.5f);
                            break;
                        }
                        case 1: {
                            r = (int)(q * 255.0f + 0.5f);
                            g = (int)(brightness * 255.0f + 0.5f);
                            b = (int)(p * 255.0f + 0.5f);
                            break;
                        }
                        case 2: {
                            r = (int)(p * 255.0f + 0.5f);
                            g = (int)(brightness * 255.0f + 0.5f);
                            b = (int)(t * 255.0f + 0.5f);
                            break;
                        }
                        case 3: {
                            r = (int)(p * 255.0f + 0.5f);
                            g = (int)(q * 255.0f + 0.5f);
                            b = (int)(brightness * 255.0f + 0.5f);
                            break;
                        }
                        case 4: {
                            r = (int)(t * 255.0f + 0.5f);
                            g = (int)(p * 255.0f + 0.5f);
                            b = (int)(brightness * 255.0f + 0.5f);
                            break;
                        }
                        case 5: {
                            r = (int)(brightness * 255.0f + 0.5f);
                            g = (int)(p * 255.0f + 0.5f);
                            b = (int)(q * 255.0f + 0.5f);
                            break;
                        }
                    }
                }
                result.putValue(ii, jj, 0, (double)r);
                result.putValue(ii, jj, 1, (double)g);
                result.putValue(ii, jj, 2, (double)b);
            }
        }
        return result;
    }

    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        String ext;
        int j;
        int i;
        int h;
        int w;
        QDataSet b;
        QDataSet g;
        QDataSet r;
        BufferedImage im;
        MutablePropertyDataSet alpha = null;
        if (data.length() == 3) {
            im = new BufferedImage(data.length(0), data.length(0, 0), 1);
            r = data.slice(0);
            g = data.slice(1);
            b = data.slice(2);
            w = data.length(0);
            h = data.length(0, 0);
        } else if (data.length(0, 0) == 4) {
            im = new BufferedImage(data.length(), data.length(0), 2);
            alpha = DataSetOps.slice2((QDataSet)data, (int)0);
            r = DataSetOps.slice2((QDataSet)data, (int)1);
            g = DataSetOps.slice2((QDataSet)data, (int)2);
            b = DataSetOps.slice2((QDataSet)data, (int)3);
            w = data.length();
            h = data.length(0);
        } else {
            im = new BufferedImage(data.length(), data.length(0), 1);
            r = DataSetOps.slice2((QDataSet)data, (int)0);
            g = DataSetOps.slice2((QDataSet)data, (int)1);
            b = DataSetOps.slice2((QDataSet)data, (int)2);
            w = data.length();
            h = data.length(0);
        }
        URISplit split = URISplit.parse((String)uri);
        QubeDataSetIterator it = new QubeDataSetIterator(data);
        boolean warn = true;
        while (it.hasNext()) {
            it.next();
            double v = it.getValue(data);
            if (!warn || !(v < 0.0) && !(v >= 256.0)) continue;
            System.err.println("element out of range 0-255: " + v);
            warn = false;
        }
        if (alpha == null) {
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    im.setRGB(i, h - j - 1, (int)r.value(i, j) * 256 * 256 + (int)g.value(i, j) * 256 + (int)b.value(i, j));
                }
            }
        } else {
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    im.setRGB(i, h - j - 1, (int)alpha.value(i, j) * 256 * 256 * 256 + (int)r.value(i, j) * 256 * 256 + (int)g.value(i, j) * 256 + (int)b.value(i, j));
                }
            }
        }
        if (!ImageIO.write((RenderedImage)im, ext = split.file.substring((i = split.file.lastIndexOf(".")) + 1), new File(split.resourceUri))) {
            throw new IOException("unable to find writer for " + ext);
        }
    }

    public boolean canFormat(QDataSet ds) {
        return ds.rank() == 3 && (ds.length() < 5 || ds.length(0, 0) < 5);
    }

    public String getDescription() {
        return "Image Format";
    }
}

