/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.Caching;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.CancelledOperationException;
import org.das2.DasException;
import org.das2.client.AccessDeniedException;
import org.das2.client.Authenticator;
import org.das2.client.DasServer;
import org.das2.client.DasServerException;
import org.das2.client.DataSetStreamHandler;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qstream.QDataSetStreamHandler;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamHandler;
import org.das2.qstream.StreamTool;
import org.das2.stream.MIME;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.StreamDescriptor;
import org.das2.util.CredentialsManager;
import org.das2.util.DasProgressMonitorInputStream;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;

public final class Das2ServerDataSource
extends AbstractDataSource {
    private static final Map<String, String> keys = new HashMap<String, String>();
    private Exception offlineException = null;
    private Logger loggerUrl = LoggerManager.getLogger((String)"das2.url");
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.das2server");
    DatumRange timeRange;
    Datum resolution;
    Datum minResolution;
    String interval;
    String dsParams;
    List<String> tcaDesc;
    Map<String, String> dsdfParams = null;

    public Das2ServerDataSource(URI uri) throws ParseException {
        super(uri);
        String str;
        String dataset;
        if (!"no".equals(this.params.get("tsb"))) {
            this.addCapability(TimeSeriesBrowse.class, this.getTimeSeriesBrowse());
        }
        this.addCapability(Caching.class, new Caching(){

            public boolean satisfies(String surl) {
                return false;
            }

            public void resetURI(String surl) {
            }

            public void reset() {
                Das2ServerDataSource.this.offlineException = null;
            }
        });
        HashMap<String, String> params2 = new HashMap<String, String>(this.params);
        params2.put("server", "dataset");
        if (this.params.get("dataset") == null && (dataset = (String)this.params.remove("arg_0")) != null) {
            this.params.put("dataset", dataset);
            params2.put("dataset", dataset);
            params2.remove("arg_0");
        }
        if ((str = (String)this.params.get("timerange")) != null) {
            str = str.replaceAll("\\+", " ");
            try {
                DatumRange tr = DatumRangeUtil.parseTimeRange((String)str);
                params2.put("start_time", tr.min().toString());
                params2.put("end_time", tr.max().toString());
                params2.remove("timerange");
            }
            catch (ParseException ex) {
                logger.log(Level.WARNING, "unable to parse timerange {0}", str);
            }
        }
        LinkedHashMap otherParams = new LinkedHashMap(this.params);
        otherParams.remove("start_time");
        otherParams.remove("end_time");
        otherParams.remove("resolution");
        otherParams.remove("dataset");
        otherParams.remove("tsb");
        otherParams.remove("timerange");
        otherParams.remove("_res");
        otherParams.remove("intrinsic");
        otherParams.remove("item");
        otherParams.remove("interval");
        otherParams.remove("key");
        this.dsParams = URISplit.formatParams(otherParams);
        if (params2.get("start_time") != null && params2.get("end_time") != null) {
            this.timeRange = new DatumRange(Units.us2000.parse((String)params2.get("start_time")), Units.us2000.parse((String)params2.get("end_time")));
        }
        this.resolution = null;
        if (params2.get("resolution") != null) {
            this.minResolution = this.resolution = Units.seconds.parse((String)params2.get("resolution"));
        }
    }

    private static QDataSet tryUnbundle(QDataSet ds, String item) {
        try {
            QDataSet ds1 = Ops.unbundle((QDataSet)ds, (String)item);
            return ds1;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized QDataSet getDataSet(final ProgressMonitor mon) throws Exception {
        mon.started();
        params2 = new LinkedHashMap<String, String>();
        otherParams = new LinkedHashMap<K, V>(this.params);
        otherParams.remove("start_time");
        otherParams.remove("end_time");
        otherParams.remove("resolution");
        otherParams.remove("dataset");
        otherParams.remove("tsb");
        otherParams.remove("timerange");
        otherParams.remove("_res");
        otherParams.remove("intrinsic");
        otherParams.remove("useOldD2sParser");
        otherParams.remove("qubeSubset");
        item = (String)otherParams.remove("item");
        this.interval = (String)otherParams.remove("interval");
        key1 = (String)otherParams.remove("key");
        this.dsParams = URISplit.formatParams(otherParams);
        params2.put("server", "dataset");
        if (this.timeRange == null) {
            throw new IllegalArgumentException("timeRange is null");
        }
        timemin = TimeUtil.fromDatum((Datum)this.timeRange.min());
        timemin[6] = (int)Math.floor((double)timemin[6] / 1000000.0) * 1000000;
        timemax = TimeUtil.fromDatum((Datum)this.timeRange.max());
        timemax[6] = (int)Math.ceil((double)timemax[6] / 1000000.0) * 1000000;
        params2.put("start_time", URLEncoder.encode(TimeUtil.toDatum((int[])timemin).toString(), "US-ASCII"));
        params2.put("end_time", URLEncoder.encode(TimeUtil.toDatum((int[])timemax).toString(), "US-ASCII"));
        sresolution = (String)this.params.get("_res");
        if (sresolution != null) {
            params2.remove("_res");
        }
        if ("true".equals(this.params.get("intrinsic"))) {
            sresolution = "0";
            params2.remove("intrinsic");
        }
        if (sresolution != null) {
            this.resolution = sresolution.trim().length() == 0 || sresolution.equals("0") != false ? null : Units.seconds.parse(sresolution);
        }
        if (this.resolution != null) {
            params2.put("resolution", "" + this.resolution.doubleValue(Units.seconds));
        } else {
            Das2ServerDataSource.logger.fine("resolution is not available, loading at intrinsic resolution");
        }
        dataset = (String)this.params.get("dataset");
        if (dataset == null) {
            dataset = (String)this.params.get("arg_0");
        }
        if (dataset == null) {
            throw new IllegalArgumentException("dataset is not specified");
        }
        mon.setProgressMessage("request " + dataset);
        if (this.interval != null) {
            Das2ServerDataSource.logger.finer("dataset is a TCA, so do not use resolution");
            dsec = this.resolution == null ? Double.parseDouble(this.interval) : this.resolution.doubleValue(Units.seconds);
            iinterval10 = (int)(dsec * 10.0);
            if (iinterval10 < 1) {
                iinterval10 = 1;
            }
            ifmt = String.format("%d.%d", new Object[]{iinterval10 / 10, iinterval10 % 10});
            sinterval = URLEncoder.encode(ifmt, "US-ASCII");
            params2.put("interval", sinterval);
            params2.remove("resolution");
        } else {
            Das2ServerDataSource.logger.finer("dataset is not a TCA, interval parameter is null");
        }
        params2.put("dataset", URLEncoder.encode(dataset, "US-ASCII"));
        if (this.dsParams.length() > 0) {
            if (this.dsParams.contains("+-") && !this.dsParams.startsWith("+")) {
                params2.put("params", this.dsParams);
            } else {
                params2.put("params", URLEncoder.encode(this.dsParams, "US-ASCII"));
            }
        }
        url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
        if (this.dsdfParams == null) {
            dsdfURL = this.resourceURI + "?server=dsdf&dataset=" + dataset;
            url3 = new URL(dsdfURL);
            Das2ServerDataSource.logger.log(Level.FINE, "opening {0}", url3);
            in = this.getInputStream(url3, dataset);
            channel = Channels.newChannel(in);
            map = new LinkedHashMap<String, String>();
            handler = new DataSetStreamHandler(new HashMap<K, V>(), mon){

                public void streamDescriptor(StreamDescriptor sd) throws org.das2.stream.StreamException {
                    super.streamDescriptor(sd);
                    map.putAll(sd.getProperties());
                }
            };
            try {
                org.das2.stream.StreamTool.readStream((ReadableByteChannel)channel, (org.das2.stream.StreamHandler)handler);
            }
            catch (org.das2.stream.StreamException ex) {
                if (ex.getMessage().equals("noSuchDataSet")) {
                    throw new org.das2.stream.StreamException("noSuchDataSet: " + dataset);
                }
                throw new org.das2.stream.StreamException(ex.getMessage() + "\ndsdf request was\n" + url3);
            }
            finally {
                channel.close();
            }
            this.dsdfParams = map;
        }
        this.tcaDesc = new ArrayList<String>();
        iplane = 0;
        label = this.dsdfParams.get("label");
        if (label == null) {
            requiresInterval = this.dsdfParams.get("requiresInterval");
            if ("1".equals(requiresInterval) || "true".equals(requiresInterval) || "on".equals(requiresInterval)) {
                label = this.dsdfParams.get("item_" + String.format("%02d", new Object[]{iplane}));
                if (iplane == 0 && label == null) {
                    label = "item_0";
                }
                while (label != null) {
                    i = label.indexOf("|");
                    label = i == -1 ? label.trim() : label.substring(0, i).trim();
                    this.tcaDesc.add(label);
                    label = this.dsdfParams.get("item_" + String.format("%02d", new Object[]{++iplane}));
                }
            }
        } else {
            while (label != null) {
                this.tcaDesc.add(label);
                label = this.dsdfParams.get("plane_" + ++iplane + ".label");
            }
        }
        if ((groupAccess = this.dsdfParams.get("groupAccess")) != null && groupAccess.trim().length() > 0) {
            if (key1 == null) {
                k = this.resourceURI.toString() + "?" + (String)this.params.get("dataset");
                t = Das2ServerDataSource.keys.get(k);
                if (t == null) {
                    authenticator = new Authenticator(DasServer.create((URL)this.resourceURI.toURL()), groupAccess);
                    key2 = authenticator.authenticate();
                    if (key2 != null) {
                        params2.put("key", key2.toString());
                        url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
                        Das2ServerDataSource.keys.put(k, key2.toString());
                    }
                } else {
                    params2.put("key", t);
                    url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
                }
            } else {
                params2.put("key", key1);
                url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
            }
        }
        qds = "1".equals(this.dsdfParams.get("qstream"));
        Das2ServerDataSource.logger.log(Level.FINE, "opening {0} {1}", new Object[]{qds != false ? "as qstream" : "as das2stream", url2});
        try {
            if (this.offlineException != null) {
                throw this.offlineException;
            }
            in = this.getInputStream(url2, dataset);
        }
        catch (AccessDeniedException ex) {
            this.offlineException = ex;
            throw this.offlineException;
        }
        mpin = new DasProgressMonitorInputStream(in, mon);
        channel = Channels.newChannel((InputStream)mpin);
        mon.setProgressMessage("reading " + dataset);
        techContact = this.dsdfParams.get("techContact");
        techContact = techContact == null ? "" : "\nTechnical Contact: " + techContact;
        useOldDas2SteamParser = this.getParam("useOldD2sParser", "F").equals("T");
        if (qds) {
            try {
                eh = new QDataSetStreamHandler();
                StreamTool.readStream((ReadableByteChannel)channel, (StreamHandler)eh);
                result1 = eh.getDataSet();
                if (!QDataSetStreamHandler.isFlattenableJoin((QDataSet)result1)) ** GOTO lbl265
                result1 = eh.flattenJoin(result1);
            }
            catch (StreamException ex) {
                cause = ex.getCause();
                if (!mon.isFinished()) {
                    mon.finished();
                }
                if (cause != null && cause instanceof InterruptedIOException) {
                    Das2ServerDataSource.logger.log(Level.WARNING, ex.getMessage(), ex);
                    throw (InterruptedIOException)ex.getCause();
                }
                if (cause != null && cause instanceof NoDataInIntervalException) {
                    throw (NoDataInIntervalException)ex.getCause();
                }
                if (ex.getMessage().contains("Empty response from reader")) {
                    throw new NoDataInIntervalException(ex.getMessage() + techContact);
                }
                if (ex.getMessage().contains("No data found")) {
                    throw new NoDataInIntervalException(ex.getMessage());
                }
                throw new org.das2.stream.StreamException(ex.getMessage() + "\ndataset request was\n" + url2 + techContact);
            }
        } else if (useOldDas2SteamParser) {
            handler /* !! */  = new DataSetStreamHandler(new HashMap<K, V>(), mon){

                public void streamDescriptor(StreamDescriptor sd) throws org.das2.stream.StreamException {
                    super.streamDescriptor(sd);
                    if (mon.getTaskSize() != -1L) {
                        mpin.setEnableProgressPosition(false);
                    }
                }
            };
            try {
                org.das2.stream.StreamTool.readStream((ReadableByteChannel)channel, (org.das2.stream.StreamHandler)handler /* !! */ );
            }
            catch (org.das2.stream.StreamException ex) {
                mon.finished();
                cause = ex.getCause();
                if (ex.getCause() != null && ex.getCause() instanceof InterruptedIOException) {
                    Das2ServerDataSource.logger.log(Level.INFO, ex.getMessage(), ex);
                    if (ex.getMessage().contains("Operation cancelled")) {
                        throw new CancelledOperationException(techContact);
                    }
                    throw (InterruptedIOException)ex.getCause();
                }
                if (cause != null && cause instanceof NoDataInIntervalException) {
                    throw (NoDataInIntervalException)ex.getCause();
                }
                if (ex.getMessage().contains("Empty response from reader")) {
                    throw new NoDataInIntervalException(ex.getMessage() + " " + techContact);
                }
                if (ex.getMessage().contains("No data found")) {
                    throw new NoDataInIntervalException(ex.getMessage());
                }
                ex = new org.das2.stream.StreamException(ex.getMessage() + "\ndataset request was \n" + url2 + " " + techContact);
                Das2ServerDataSource.logger.log(Level.INFO, ex.getMessage(), ex);
                throw ex;
            }
            ds = handler /* !! */ .getDataSet();
            if (ds == null) {
                return null;
            }
            if (ds.getXLength() == 0) {
                throw new RuntimeException("empty dataset returned");
            }
            result /* !! */  = item == null || item.equals("") != false ? DataSetAdapter.create((DataSet)ds) : this.unbundleTCAItem(ds, item, this.tcaDesc);
            result1 = result /* !! */ ;
        } else {
            handler /* !! */  = System.getProperty("timetagMonitoringDas2StreamHandler", "false").startsWith("t") != false ? new MonitoringDataSetStreamHandler(mpin, mon, this.timeRange) : new org.das2.client.QDataSetStreamHandler(){

                public void streamDescriptor(StreamDescriptor sd) throws org.das2.stream.StreamException {
                    super.streamDescriptor(sd);
                    if (mon.getTaskSize() != -1L) {
                        mpin.setEnableProgressPosition(false);
                    }
                }
            };
            handler /* !! */ .setMonitor(mon);
            try {
                org.das2.stream.StreamTool.readStream((ReadableByteChannel)channel, (org.das2.stream.StreamHandler)handler /* !! */ );
            }
            catch (org.das2.stream.StreamException ex) {
                mon.finished();
                cause = ex.getCause();
                if (ex.getCause() != null && ex.getCause() instanceof InterruptedIOException) {
                    Das2ServerDataSource.logger.log(Level.INFO, ex.getMessage(), ex);
                    if (ex.getMessage().contains("Operation cancelled")) {
                        throw new CancelledOperationException(techContact);
                    }
                    throw (InterruptedIOException)ex.getCause();
                }
                if (cause != null && cause instanceof NoDataInIntervalException) {
                    throw (NoDataInIntervalException)ex.getCause();
                }
                if (ex.getMessage().contains("Empty response from reader")) {
                    throw new NoDataInIntervalException(ex.getMessage() + " " + techContact);
                }
                if (ex.getMessage().contains("No data found")) {
                    throw new NoDataInIntervalException(ex.getMessage());
                }
                ex = new org.das2.stream.StreamException(ex.getMessage() + "\ndataset request was \n" + url2 + " " + techContact);
                Das2ServerDataSource.logger.log(Level.INFO, ex.getMessage(), ex);
                throw ex;
            }
            if (!mon.isFinished()) {
                mon.finished();
            }
            if ((ds = handler /* !! */ .getDataSet()) == null) {
                return null;
            }
            if (ds.length() == 0) {
                throw new RuntimeException("empty dataset returned");
            }
            if (this.tcaDesc != null && this.tcaDesc.size() > 0 && item != null && !item.equals("")) {
                result /* !! */  = this.unbundleTCAItemQDS((QDataSet)ds, item, this.tcaDesc);
            } else if (this.tcaDesc != null && this.tcaDesc.size() > 0 && item == null) {
                ll = Ops.labelsDataset((String[])this.tcaDesc.toArray(new String[this.tcaDesc.size()]));
                if (ll.length() == ds.length(0)) {
                    bds = (QDataSet)ds.property("BUNDLE_1");
                    if (bds instanceof BundleDataSet.BundleDescriptor) {
                        bdds = (BundleDataSet.BundleDescriptor)bds;
                        for (i = 0; i < ll.length(); ++i) {
                            bdds.putProperty("NAME", i, (Object)ll.slice(i).svalue());
                        }
                        result /* !! */  = ds;
                    } else {
                        result /* !! */  = Ops.putProperty((QDataSet)ds, (String)"DEPEND_1", (Object)ll);
                    }
                } else {
                    result /* !! */  = ds;
                }
            } else {
                result /* !! */  = ds;
            }
            result1 = result /* !! */ ;
        }
lbl265:
        // 4 sources

        qubeSubset = this.getParam("qubeSubset", "F").equals("T");
        if (qubeSubset) {
            if (result1.rank() == 3 && !DataSetUtil.isQube((QDataSet)result1)) {
                result1 = DataSetUtil.qubeSubset((QDataSet)result1, (int)result1.length(0, 0));
            } else if (DataSetUtil.isQube((QDataSet)result1)) {
                Das2ServerDataSource.logger.info("data is already a qube, qubeSubset has no effect");
            } else {
                Das2ServerDataSource.logger.info("data is rank 2, qubeSubset is not supported");
            }
        }
        Das2ServerDataSource.logger.fine("  done. ");
        try {
            prop = "DEPEND_0";
            dep = (QDataSet)result1.property(prop);
            if (dep == null && (o = result1.property(prop = "JOIN_0")) instanceof QDataSet) {
                dep = (QDataSet)o;
            }
            if (dep != null && dep.property("CACHE_TAG") == null) {
                if (SemanticOps.isBundle((QDataSet)result1)) {
                    bounds = SemanticOps.bounds((QDataSet)dep);
                    ct = new CacheTag(DataSetUtil.asDatumRange((QDataSet)bounds.slice(1), (boolean)true), this.resolution);
                } else {
                    bounds = SemanticOps.bounds((QDataSet)result1);
                    ct = new CacheTag(DataSetUtil.asDatumRange((QDataSet)bounds.slice(0), (boolean)true), this.resolution);
                }
                dep2 = DataSetOps.makePropertiesMutable((QDataSet)dep);
                dep2.putProperty("CACHE_TAG", (Object)ct);
                result2 = DataSetOps.makePropertiesMutable((QDataSet)result1);
                result2.putProperty(prop, (Object)dep2);
                return result2;
            }
        }
        catch (IllegalArgumentException ex) {
            Das2ServerDataSource.logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        if (!mon.isFinished()) {
            mon.finished();
        }
        return result1;
    }

    protected MutablePropertyDataSet unbundleTCAItem(DataSet ds, String item, List<String> tcaDesc) throws IllegalArgumentException {
        AbstractDataSet result;
        DataSet das2ds = ds.getPlanarView(item);
        if (das2ds == null) {
            if (item.contains(",")) {
                String[] ss;
                BundleDataSet bds = null;
                for (String s : ss = item.split(",")) {
                    int iitem = -1;
                    das2ds = ds.getPlanarView(s);
                    if (das2ds == null) {
                        iitem = Integer.parseInt(s);
                        das2ds = iitem == 0 ? ds.getPlanarView("") : ds.getPlanarView("plane_" + iitem);
                    }
                    AbstractDataSet bds1 = DataSetAdapter.create((DataSet)das2ds);
                    if (iitem > -1) {
                        bds1 = Ops.putProperty((QDataSet)bds1, (String)"LABEL", (Object)tcaDesc.get(iitem));
                    }
                    bds = (BundleDataSet)Ops.bundle(bds, (QDataSet)bds1);
                }
                result = bds;
            } else {
                try {
                    int iitem = Integer.parseInt(item);
                    das2ds = iitem == 0 ? ds.getPlanarView("") : ds.getPlanarView("plane_" + iitem);
                    if (das2ds == null) {
                        String[] ss = ds.getPlaneIds();
                        das2ds = ds.getPlanarView(ss[iitem]);
                    }
                    if (das2ds == null) {
                        throw new IllegalArgumentException("no such plane, looking for " + item);
                    }
                    result = DataSetAdapter.create((DataSet)das2ds);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("unable to find component \"" + item + "\"");
                }
            }
        } else {
            result = DataSetAdapter.create((DataSet)das2ds);
        }
        return result;
    }

    private static QDataSet unbundleOrNull(QDataSet ds, String item) {
        try {
            return Ops.unbundle((QDataSet)ds, (String)item);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected QDataSet unbundleTCAItemQDS(QDataSet ds, String item, List<String> tcaDesc) throws IllegalArgumentException {
        int iitem;
        QDataSet result;
        if (tcaDesc != null && (item == null || item.equals(""))) {
            StringBuilder sitem = new StringBuilder("0");
            for (int i = 1; i < tcaDesc.size(); ++i) {
                sitem.append(",").append(String.valueOf(i));
            }
            item = sitem.toString();
        }
        if ((result = Das2ServerDataSource.unbundleOrNull(ds, item)) == null) {
            if (item.contains(",")) {
                String[] ss;
                BundleDataSet bds = null;
                String[] stringArray = ss = item.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int iitem2;
                    String s = stringArray[n2];
                    result = Das2ServerDataSource.unbundleOrNull(ds, s);
                    if (result == null && (result = (iitem2 = Integer.parseInt(s)) == 0 ? Ops.unbundle((QDataSet)ds, (int)0) : Ops.unbundle((QDataSet)ds, (String)("plane_" + iitem2))).property("LABEL") == null) {
                        result = Ops.putProperty((QDataSet)result, (String)"LABEL", (Object)tcaDesc.get(iitem2));
                    }
                    bds = (BundleDataSet)Ops.bundle(bds, (QDataSet)result);
                    ++n2;
                }
                return bds;
            }
            try {
                iitem = Integer.parseInt(item);
                result = iitem == 0 ? Ops.unbundle((QDataSet)ds, (int)0) : Ops.unbundle((QDataSet)ds, (String)("plane_" + iitem));
                if (result == null) {
                    throw new IllegalArgumentException("no such plane, looking for " + item);
                }
                if (result.property("LABEL") != null) return result;
                return Ops.putProperty((QDataSet)result, (String)"LABEL", (Object)tcaDesc.get(iitem));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("unable to find component \"" + item + "\"");
            }
        }
        if (!item.startsWith("plane_")) return result;
        iitem = Integer.parseInt(item.substring(6));
        if (result.property("LABEL") != null) return result;
        return Ops.putProperty((QDataSet)result, (String)"LABEL", (Object)tcaDesc.get(iitem));
    }

    private InputStream getInputStream(URL url, String sDataSetId) throws IOException, DasException {
        InputStream in;
        block14: {
            int nStatus;
            block15: {
                in = null;
                int nRedirects = 0;
                String sLocId = null;
                String sBasicHash = null;
                CredentialsManager cm = CredentialsManager.getMannager();
                while (true) {
                    this.loggerUrl.log(Level.FINE, "open {0}", url);
                    URLConnection conn = url.openConnection();
                    if (sBasicHash != null) {
                        conn.setRequestProperty("Authorization", "Basic " + sBasicHash);
                    }
                    conn.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
                    conn.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
                    if (!(conn instanceof HttpURLConnection)) {
                        in = conn.getInputStream();
                        break block14;
                    }
                    HttpURLConnection httpConn = (HttpURLConnection)conn;
                    nStatus = httpConn.getResponseCode();
                    if (nStatus / 100 == 2) {
                        in = conn.getInputStream();
                        break block14;
                    }
                    if (nStatus / 100 == 3) {
                        String sLoc = httpConn.getHeaderField("Location");
                        if (sLoc == null) {
                            throw new DasServerException("Redirection response missing location header");
                        }
                        if (nRedirects > 20) {
                            throw new DasServerException("Client has been redirected more than 20 times");
                        }
                        URISplit split = URISplit.parse((String)sLoc);
                        LinkedHashMap zparams = URISplit.parseParams((String)split.params);
                        for (Map.Entry entry : zparams.entrySet()) {
                            String s = ((String)entry.getValue()).replaceAll(" ", "+");
                            entry.setValue(s);
                        }
                        split.params = URISplit.formatParams((Map)zparams);
                        sLoc = URISplit.format((URISplit)split);
                        url = new URL(sLoc);
                        ++nRedirects;
                        continue;
                    }
                    if (nStatus / 100 == 5) {
                        String sMime = httpConn.getContentType();
                        if (!MIME.isDataStream((String)sMime)) {
                            throw new DasServerException(String.format("Server error encountered accessing URL %s", url.toString()));
                        }
                        in = httpConn.getErrorStream();
                        break block14;
                    }
                    if (nStatus != 401) break block15;
                    if (sLocId != null) {
                        cm.invalidate(sLocId);
                    }
                    String auth = httpConn.getHeaderField("WWW-Authenticate");
                    Pattern p = Pattern.compile("Basic realm=\"(.*)\"");
                    Matcher m = p.matcher(auth);
                    String readAccessGroup = m.matches() ? m.group(1) : "das2 server";
                    sLocId = this.resourceURI.toURL().toString() + "|" + readAccessGroup;
                    if (!cm.hasCredentials(sLocId)) {
                        DasServer dasServer = DasServer.create((URL)url);
                        String sDesc = String.format("<html><h3>%s</h3><hr>Server: <b>%s</b><br>Data Set: <b>%s</b>", dasServer.getName(), dasServer.getHost(), sDataSetId);
                        cm.setDescription(sLocId, sDesc, dasServer.getLogo());
                    }
                    if ((sBasicHash = cm.getHttpBasicHash(sLocId)) == null) break;
                }
                throw new AccessDeniedException("User credentials are not available for URL: " + url);
            }
            if (nStatus == 400 || nStatus == 404) {
                throw new DasServerException("Query error in request for URL: " + url);
            }
            if (nStatus == 403) {
                throw new AccessDeniedException("Access denied for URL:" + url);
            }
            throw new DasServerException(String.format("Completly unexpected server error encountered accessing URL %s, status code %d received from server.", url.toString(), nStatus));
        }
        return in;
    }

    public final TimeSeriesBrowse getTimeSeriesBrowse() {
        return new TimeSeriesBrowse(){

            public void setTimeRange(DatumRange dr) {
                logger.log(Level.FINE, "setTimeRange to {0} ({1})", new Object[]{dr, dr.width().toString()});
                Das2ServerDataSource.this.timeRange = dr;
            }

            public void setTimeResolution(Datum d) {
                logger.log(Level.FINE, "setTimeResolution to {0}", d);
                if (Das2ServerDataSource.this.minResolution != null && d.lt(Das2ServerDataSource.this.minResolution)) {
                    d = Das2ServerDataSource.this.minResolution;
                }
                Das2ServerDataSource.this.resolution = d;
            }

            public String getURI() {
                LinkedHashMap<String, String> c = new LinkedHashMap<String, String>(Das2ServerDataSource.this.params);
                String stime = Das2ServerDataSource.this.timeRange.min().toString().replace(" ", "+");
                String etime = Das2ServerDataSource.this.timeRange.max().toString().replace(" ", "+");
                c.put("start_time", stime);
                c.put("end_time", etime);
                if (Das2ServerDataSource.this.resolution != null) {
                    double resSec = Das2ServerDataSource.this.resolution.doubleValue(Units.seconds);
                    resSec = (double)Math.round(resSec * 1000.0) / 1000.0;
                    c.put("resolution", String.valueOf(resSec));
                } else {
                    logger.fine("no resolution specified");
                }
                if (Das2ServerDataSource.this.params.containsKey("interval")) {
                    c.put("interval", (String)Das2ServerDataSource.this.params.get("interval"));
                }
                String sparams = URISplit.formatParams(c);
                return "vap+das2server:" + Das2ServerDataSource.this.resourceURI + "?" + sparams;
            }

            public String blurURI() {
                String sparams = "dataset=" + (String)Das2ServerDataSource.this.params.get("dataset");
                if (Das2ServerDataSource.this.params.containsKey("interval")) {
                    sparams = sparams + "&interval=" + (String)Das2ServerDataSource.this.params.get("interval");
                }
                if (Das2ServerDataSource.this.dsParams != null && Das2ServerDataSource.this.dsParams.trim().length() > 0) {
                    sparams = sparams + "&" + Das2ServerDataSource.this.dsParams;
                }
                return "vap+das2server:" + Das2ServerDataSource.this.resourceURI + "?" + sparams;
            }

            public DatumRange getTimeRange() {
                return Das2ServerDataSource.this.timeRange;
            }

            public Datum getTimeResolution() {
                return Das2ServerDataSource.this.resolution;
            }

            public void setURI(String suri) throws ParseException {
                URISplit split = URISplit.parse((URI)Das2ServerDataSource.this.uri);
                LinkedHashMap params = URISplit.parseParams((String)split.params);
                String startTime = (String)params.remove("start_time");
                String endTime = (String)params.get("end_time");
                String sresolution = (String)params.get("resolution");
                if (startTime != null && endTime != null) {
                    Das2ServerDataSource.this.timeRange = new DatumRange(Units.us2000.parse(startTime), Units.us2000.parse(endTime));
                }
                if (sresolution != null) {
                    Das2ServerDataSource.this.resolution = Units.seconds.parse(sresolution);
                }
            }
        };
    }

    public String getURI() {
        return super.getURI();
    }

    public String toString() {
        return this.resourceURI + "?" + (String)this.params.get("dataset");
    }

    private static class MonitoringDataSetStreamHandler
    extends org.das2.client.QDataSetStreamHandler {
        private boolean monitorXTags = false;
        private final ProgressMonitor mon;
        private final DasProgressMonitorInputStream mpin;
        private final DatumRange timeRange;
        private Units units;
        private long lastUpdate = -1L;

        private MonitoringDataSetStreamHandler(DasProgressMonitorInputStream mpin, ProgressMonitor mon, DatumRange timeRange) {
            this.mon = mon;
            this.mpin = mpin;
            this.timeRange = timeRange;
            this.units = Units.seconds;
        }

        public void streamDescriptor(StreamDescriptor sd) throws org.das2.stream.StreamException {
            super.streamDescriptor(sd);
            if (this.mon.getTaskSize() != -1L && this.mon.getTaskSize() != 1000L) {
                this.mpin.setEnableProgressPosition(false);
            } else {
                this.monitorXTags = true;
                if (this.timeRange.width().gt(Units.days.createDatum(480))) {
                    this.units = Units.days;
                } else if (this.timeRange.width().gt(Units.hours.createDatum(48))) {
                    this.units = Units.hours;
                }
                this.mon.setTaskSize((long)this.timeRange.width().doubleValue(this.units));
                this.mon.setAdditionalInfo(this.units.toString());
                this.mpin.setEnableProgressPosition(false);
            }
        }

        public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws org.das2.stream.StreamException {
            long t;
            super.packet(pd, xTag, vectors);
            if (this.monitorXTags && (t = System.currentTimeMillis()) - this.lastUpdate > 300L) {
                if (xTag.getUnits().isConvertibleTo(this.timeRange.min().getUnits())) {
                    long taskProgress = xTag.subtract(this.timeRange.min()).intValue(this.units);
                    this.mon.setTaskProgress(taskProgress);
                }
                this.lastUpdate = t;
            }
        }
    }
}

