/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.das2.qstream.AsciiIntegerTransferType;
import org.das2.qstream.TransferType;

public class AsciiHexIntegerTransferType
extends AsciiIntegerTransferType {
    public AsciiHexIntegerTransferType(int sizeBytes) {
        super(sizeBytes);
        this.format = "0x%0" + (sizeBytes - 3) + "x";
    }

    @Override
    public double read(ByteBuffer buffer) {
        try {
            byte[] bytes = new byte[this.sizeBytes];
            buffer.get(bytes);
            String str = new String(bytes, "US-ASCII");
            if (str.startsWith("0x")) {
                str = str.substring(2);
            }
            return Integer.valueOf(str.trim(), 16).intValue();
        }
        catch (UnsupportedEncodingException ex) {
            return Double.NaN;
        }
    }

    @Override
    public void write(double d, ByteBuffer buffer) {
        super.write(d, buffer);
    }

    public static TransferType getByName(String ttype, Map<String, Object> properties) {
        if (ttype.startsWith("hex")) {
            return new AsciiHexIntegerTransferType(Integer.parseInt(ttype.substring(3)));
        }
        return null;
    }

    @Override
    public String name() {
        return "hex" + this.sizeBytes;
    }
}

