/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.qds.Slice0DataSet;
import org.das2.qds.ops.Ops;
import org.das2.qstream.AsciiIntegerTransferType;
import org.das2.qstream.AsciiTimeTransferType;
import org.das2.qstream.AsciiTransferType;
import org.das2.qstream.DoubleTransferType;
import org.das2.qstream.FloatTransferType;
import org.das2.qstream.IntegerTransferType;
import org.das2.qstream.LongTransferType;
import org.das2.qstream.PacketDescriptor;
import org.das2.qstream.PlaneDescriptor;
import org.das2.qstream.SerializeDelegate;
import org.das2.qstream.SerializeRegistry;
import org.das2.qstream.StreamDescriptor;
import org.das2.qstream.StreamException;
import org.das2.qstream.TransferType;
import org.das2.qstream.Util;
import org.das2.qstream.XMLSerializeDelegate;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleStreamFormatter {
    private static final char CHAR_NEWLINE = '\n';
    boolean asciiTypes = true;
    boolean isBigEndian = true;
    private static final Logger logger = Logger.getLogger("qstream");
    boolean newBundle = false;
    Map<QDataSet, String> names = new HashMap<QDataSet, String>();

    Document getNewDocument() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    Element getPacketElement(Document document) {
        Element packet = document.createElement("packet");
        return packet;
    }

    private void doValuesElement(QDataSet ds, PacketDescriptor pd, PlaneDescriptor planeDescriptor, Document document, Element qdatasetElement) throws DOMException {
        QDataSet bundleDescriptor;
        Object sunits = ds.property("UNITS");
        if (sunits != null && !(sunits instanceof Units)) {
            throw new IllegalArgumentException("UNITS property doesn't contain type units, it's type " + sunits.getClass() + ": " + sunits);
        }
        boolean highResKludge = false;
        Units u = (Units)sunits;
        if (u == null && this.isBundle(ds) && ds.rank() == 2 && (bundleDescriptor = (QDataSet)ds.property("BUNDLE_1")) != null) {
            for (int i = 0; i < bundleDescriptor.length(); ++i) {
                Units u1 = (Units)bundleDescriptor.property("UNITS", i);
                if (u1 == null || !UnitsUtil.isTimeLocation((Units)u1)) continue;
                highResKludge = true;
                System.err.println("using high res kludge to format bundle dataset that contains " + u1);
            }
        }
        if (!pd.isValuesInDescriptor()) {
            if (this.asciiTypes) {
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                double absMin = Double.MAX_VALUE;
                double maxFp = 0.0;
                double minFp = 1.0;
                QubeDataSetIterator it = new QubeDataSetIterator(ds);
                while (it.hasNext()) {
                    double dd;
                    double fp;
                    it.next();
                    double d = it.getValue(ds);
                    if (d < min) {
                        min = d;
                    }
                    if ((fp = (dd = Math.abs(d)) - (double)((long)dd)) > maxFp) {
                        maxFp = fp;
                    }
                    if (fp > 0.0 && fp < minFp) {
                        minFp = fp;
                    }
                    if (dd > 0.0 && dd < absMin) {
                        absMin = dd;
                    }
                    if (!(d > max)) continue;
                    max = d;
                }
                if (u instanceof EnumerationUnits) {
                    planeDescriptor.setType(new AsciiIntegerTransferType(10));
                } else if (u instanceof TimeLocationUnits) {
                    AsciiTimeTransferType att = this.getTT(ds);
                    planeDescriptor.setType(att);
                } else if (highResKludge) {
                    planeDescriptor.setType(new AsciiTransferType(18, true));
                } else if (maxFp == 0.0 && min > -1.0E8 && max < 1.0E8) {
                    planeDescriptor.setType(new AsciiIntegerTransferType(10));
                } else if (min > -10000.0 && max < 10000.0 && absMin > 1.0E-4) {
                    planeDescriptor.setType(new AsciiTransferType(10, false));
                } else if (min > -100000.0 && max < 100000.0 && minFp == 0.5 && maxFp == 0.5) {
                    planeDescriptor.setType(new AsciiTransferType(10, false));
                } else if (absMin > 1.0E-100 && max < 1.0E100) {
                    planeDescriptor.setType(new AsciiTransferType(10, true));
                } else {
                    planeDescriptor.setType(new AsciiTransferType(12, true));
                }
            } else if (highResKludge) {
                planeDescriptor.setType(new DoubleTransferType());
            } else if (u instanceof EnumerationUnits) {
                planeDescriptor.setType(new IntegerTransferType());
            } else if (u == Units.cdfTT2000) {
                planeDescriptor.setType(new LongTransferType());
            } else if (u instanceof TimeLocationUnits) {
                planeDescriptor.setType(new DoubleTransferType());
            } else {
                planeDescriptor.setType(new FloatTransferType());
            }
        }
        if (pd.isValuesInDescriptor() && ds.rank() == 2) {
            for (int i = 0; i < ds.length(); ++i) {
                Element values = this.doValues(document, pd, planeDescriptor, (QDataSet)DataSetOps.slice0((QDataSet)ds, (int)i));
                values.setAttribute("index", String.valueOf(i));
                qdatasetElement.appendChild(values);
            }
        } else {
            if (UnitsUtil.isNominalMeasurement((Units)u) && pd.isValuesInDescriptor()) {
                HashMap<Integer, String> enumerations = new HashMap<Integer, String>();
                QubeDataSetIterator it = new QubeDataSetIterator(ds);
                assert (u != null);
                EnumerationUnits eu = (EnumerationUnits)u;
                while (it.hasNext()) {
                    it.next();
                    int i = (int)it.getValue(ds);
                    if (enumerations.containsKey(i)) continue;
                    Datum ed = eu.createDatum(i);
                    String sed = ed.toString();
                    Element enumerationUnit = document.createElement("enumerationUnit");
                    enumerationUnit.setAttribute("name", eu.getId());
                    enumerationUnit.setAttribute("value", String.valueOf(i));
                    enumerationUnit.setAttribute("color", String.format("0x%06x", eu.getColor(ed)));
                    enumerationUnit.setAttribute("label", sed);
                    qdatasetElement.appendChild(enumerationUnit);
                    enumerations.put(i, sed);
                }
            }
            Element values = this.doValues(document, pd, planeDescriptor, ds);
            qdatasetElement.appendChild(values);
        }
    }

    private int timeDigits(QDataSet ds) {
        Units u = SemanticOps.getUnits((QDataSet)ds);
        if (ds.rank() != 0) {
            throw new IllegalArgumentException("data should be rank 0");
        }
        double micros = UnitsUtil.isTimeLocation((Units)u) ? TimeUtil.getMicroSecondsSinceMidnight((Datum)u.createDatum(ds.value())) : u.convertDoubleTo(Units.microseconds, ds.value());
        if (micros == 0.0 || micros >= 6.0E7 && micros % 6.0E7 < 0.1) {
            return 17;
        }
        if (micros >= 1000000.0 && micros % 1000000.0 < 0.001) {
            return 20;
        }
        if (micros >= 1000.0 && micros % 1000.0 < 0.1) {
            return 24;
        }
        if (micros >= 1.0 && micros % 1.0 < 0.001) {
            return 27;
        }
        return 30;
    }

    private AsciiTimeTransferType getTT(QDataSet ds) {
        QDataSet gcd;
        int timeDigits;
        Units u = SemanticOps.getUnits((QDataSet)ds);
        MutablePropertyDataSet t0 = DataSetOps.slice0((QDataSet)ds, (int)0);
        switch (t0.rank()) {
            case 1: {
                timeDigits = this.timeDigits(t0.slice(0));
                for (int i = 1; i > t0.length(); ++i) {
                    timeDigits = Math.max(timeDigits, this.timeDigits(t0.slice(i)));
                }
                break;
            }
            case 0: {
                timeDigits = this.timeDigits((QDataSet)t0);
                break;
            }
            default: {
                throw new IllegalArgumentException("time type rank limit");
            }
        }
        try {
            QDataSet diffs = Ops.subtract((QDataSet)ds, (QDataSet)DataSetOps.slice0((QDataSet)ds, (int)0));
            try {
                gcd = DataSetUtil.gcd((QDataSet)diffs, (QDataSet)DataSetUtil.asDataSet((double)1.0, (Units)Units.picoseconds));
            }
            catch (IndexOutOfBoundsException ex) {
                diffs = Ops.diff((QDataSet)ds);
                gcd = DataSetUtil.gcd((QDataSet)diffs, (QDataSet)DataSetUtil.asDataSet((double)1.0, (Units)Units.picoseconds));
            }
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, ex.getMessage(), ex);
            gcd = null;
        }
        if (gcd == null) {
            return new AsciiTimeTransferType(timeDigits, u);
        }
        int timeDigitsGcd = this.timeDigits(gcd);
        return new AsciiTimeTransferType(Math.max(timeDigits, timeDigitsGcd), u);
    }

    private PlaneDescriptor doPlaneDescriptorBundle(Document document, PacketDescriptor pd, QDataSet ds, int rank) {
        Element qdatasetElement = document.createElement("qdataset");
        qdatasetElement.setAttribute("id", this.nameFor(ds));
        qdatasetElement.setAttribute("rank", String.valueOf(rank));
        logger.log(Level.FINE, "writing qdataset {0}", this.nameFor(ds));
        if (this.isBundle(ds)) {
            for (int i = 0; i < ds.length(0); ++i) {
                QDataSet ds1 = DataSetOps.unbundle((QDataSet)ds, (int)i);
                Element bundle = document.createElement("bundle");
                bundle.setAttribute("id", this.nameFor(ds1));
                qdatasetElement.appendChild(bundle);
            }
        } else {
            throw new IllegalArgumentException("not supported");
        }
        Element props = this.doProperties(document, ds);
        qdatasetElement.appendChild(props);
        PlaneDescriptor planeDescriptor = new PlaneDescriptor();
        planeDescriptor.setRank(ds.rank());
        planeDescriptor.setDs(ds);
        planeDescriptor.setName(this.nameFor(ds));
        planeDescriptor.setDomElement(qdatasetElement);
        return planeDescriptor;
    }

    private PlaneDescriptor doPlaneDescriptor(Document document, PacketDescriptor pd, QDataSet ds, int streamRank) {
        Element qdatasetElement = document.createElement("qdataset");
        qdatasetElement.setAttribute("id", this.nameFor(ds));
        logger.log(Level.FINE, "writing qdataset {0}", this.nameFor(ds));
        if (this.isJoin(ds) || this.isBundle(ds)) {
            qdatasetElement.setAttribute("rank", String.valueOf(ds.rank()));
        } else {
            qdatasetElement.setAttribute("rank", String.valueOf(ds.rank() + (streamRank - 1)));
        }
        if (this.isBundle(ds)) {
            QDataSet bds = ds.rank() == 1 ? (QDataSet)ds.property("BUNDLE_0") : (QDataSet)ds.property("BUNDLE_1");
            if (bds == null) {
                for (int i = 0; i < ds.length(); ++i) {
                    MutablePropertyDataSet ds1 = DataSetOps.slice0((QDataSet)ds, (int)i);
                    Element props = this.doProperties(document, (QDataSet)ds1);
                    props.setAttribute("index", String.valueOf(i));
                    qdatasetElement.appendChild(props);
                }
            }
        } else if (this.isJoin(ds)) {
            Element values = document.createElement("values");
            String sliceName = this.nameFor(ds.slice(0));
            for (int i = 0; i < ds.length(); ++i) {
                this.setNameFor(ds.slice(i), sliceName);
            }
            values.setAttribute("join", sliceName);
            qdatasetElement.appendChild(values);
        }
        Element props = this.doProperties(document, ds);
        qdatasetElement.appendChild(props);
        PlaneDescriptor planeDescriptor = new PlaneDescriptor();
        planeDescriptor.setRank(ds.rank());
        if (!this.isJoin(ds)) {
            int[] qube = DataSetUtil.qubeDims((QDataSet)ds);
            if (!pd.valuesInDescriptor) {
                if (pd.isStream()) {
                    planeDescriptor.setQube(Util.subArray(qube, 1, qube.length - 1));
                } else {
                    planeDescriptor.setQube(qube);
                }
            } else if (ds.length() == 0) {
                logger.severe("here ds.length()==0");
            }
        }
        planeDescriptor.setDs(ds);
        planeDescriptor.setName(this.nameFor(ds));
        if (!this.isJoin(ds)) {
            this.doValuesElement(ds, pd, planeDescriptor, document, qdatasetElement);
        }
        planeDescriptor.setDomElement(qdatasetElement);
        return planeDescriptor;
    }

    private boolean isBundle(QDataSet ds) {
        if (ds.property("BUNDLE_0") != null) {
            return true;
        }
        if (ds.property("BUNDLE_1") != null) {
            return true;
        }
        return ds.property("NAME", 0) != null && ds.property("NAME", 0) != ds.property("NAME");
    }

    private boolean isJoin(QDataSet ds) {
        return ds.property("JOIN_0") != null;
    }

    private Element doProperties(Document document, QDataSet ds) {
        Element properties = document.createElement("properties");
        Map props = DataSetUtil.getProperties((QDataSet)ds);
        for (Map.Entry e : props.entrySet()) {
            String name = (String)e.getKey();
            Element prop = null;
            Object value = e.getValue();
            if (value instanceof QDataSet) {
                if (name.equals("BUNDLE_1") && props.containsKey("BINS_1") && props.get("BINS_1").equals("min,max")) continue;
                QDataSet qds = (QDataSet)value;
                String sliceName = (String)qds.property("NAME");
                if (ds instanceof Slice0DataSet && sliceName != null && sliceName.startsWith("slice")) continue;
                if (qds.rank() == 0) {
                    prop = document.createElement("property");
                    prop.setAttribute("name", name);
                    SerializeDelegate r0d = SerializeRegistry.getByName("rank0dataset");
                    prop.setAttribute("type", "rank0dataset");
                    Units u = (Units)qds.property("UNITS");
                    if (u != null && u instanceof EnumerationUnits) continue;
                    prop.setAttribute("value", r0d.format(value));
                } else {
                    prop = document.createElement("property");
                    prop.setAttribute("name", name);
                    prop.setAttribute("type", "qdataset");
                    prop.setAttribute("value", this.nameFor((QDataSet)value));
                }
            } else {
                SerializeDelegate sd = SerializeRegistry.getDelegate(value.getClass());
                if (sd == null) {
                    System.err.println("dropping " + name + " because unsupported type: " + value.getClass());
                } else {
                    prop = document.createElement("property");
                    prop.setAttribute("name", name);
                    if (sd instanceof XMLSerializeDelegate) {
                        prop.appendChild(((XMLSerializeDelegate)((Object)sd)).xmlFormat(document, value));
                    } else {
                        prop.setAttribute("type", sd.typeId(value.getClass()));
                        prop.setAttribute("value", sd.format(value));
                    }
                }
            }
            if (prop == null) continue;
            properties.appendChild(prop);
        }
        return properties;
    }

    private StreamDescriptor doStreamDescriptor(QDataSet ds) throws ParserConfigurationException {
        StreamDescriptor sd = new StreamDescriptor(DocumentBuilderFactory.newInstance());
        Document document = sd.newDocument(sd);
        Element streamElement = document.createElement("stream");
        String name = this.nameFor(ds);
        streamElement.setAttribute("dataset_id", name);
        streamElement.setAttribute("version", "1.1");
        if (!this.asciiTypes) {
            streamElement.setAttribute("byte_order", this.isBigEndian ? "big_endian" : "little_endian");
        }
        sd.setDomElement(streamElement);
        sd.addDescriptor(sd);
        return sd;
    }

    private Element doValues(Document document, PacketDescriptor packetDescriptor, PlaneDescriptor planeDescriptor, QDataSet ds) {
        Element values = document.createElement("values");
        int[] qubeDims = null;
        if (!packetDescriptor.isValuesInDescriptor()) {
            values.setAttribute("encoding", planeDescriptor.getType().name());
            qubeDims = DataSetUtil.qubeDims((QDataSet)ds);
        }
        if (packetDescriptor.isStream()) {
            if (ds.rank() > 1) {
                assert (qubeDims != null);
                values.setAttribute("length", Util.encodeArray(qubeDims, 1, qubeDims.length - 1));
            } else {
                values.setAttribute("length", "");
            }
        } else {
            if (qubeDims != null) {
                values.setAttribute("length", Util.encodeArray(qubeDims, 0, qubeDims.length));
            }
            if (packetDescriptor.isValuesInDescriptor()) {
                Units u = (Units)ds.property("UNITS");
                StringBuilder s = new StringBuilder("");
                if (u != null && u instanceof EnumerationUnits) {
                    for (int i = 0; i < ds.length(); ++i) {
                        s.append(",").append((int)ds.value(i));
                    }
                } else {
                    for (int i = 0; i < ds.length(); ++i) {
                        s.append(",").append(ds.value(i));
                    }
                }
                values.setAttribute("values", ds.length() == 0 ? "" : s.substring(1));
                if (ds.length() == 0) {
                    values.setAttribute("length", "0");
                }
            }
        }
        return values;
    }

    private void formatPackets(WritableByteChannel channel, StreamDescriptor sd, PacketDescriptor pd) throws IOException {
        int bufferSize = 4 + pd.sizeBytes();
        byte[] bbuf = new byte[bufferSize];
        ByteBuffer buffer = ByteBuffer.wrap(bbuf);
        if (this.isBigEndian) {
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        String packetTag = String.format(":%02d:", sd.descriptorId(pd));
        buffer.put(packetTag.getBytes());
        if (pd.isStream()) {
            int packetCount = pd.planes.get(0).getDs().length();
            int planeCount = pd.planes.size();
            Units[] checkEnumerationUnits = new Units[planeCount];
            HashMap<Integer, String> enumerations = new HashMap<Integer, String>();
            for (int iplane = 0; iplane < planeCount; ++iplane) {
                PlaneDescriptor plane = pd.planes.get(iplane);
                TransferType tt = plane.getType();
                QDataSet planeds = plane.getDs();
                Units u = (Units)planeds.property("UNITS");
                checkEnumerationUnits[iplane] = u != null && u instanceof EnumerationUnits ? u : null;
            }
            for (int i = 0; i < packetCount; ++i) {
                QDataSet planeds;
                TransferType tt;
                PlaneDescriptor plane;
                int iplane;
                for (iplane = 0; iplane < planeCount; ++iplane) {
                    if (checkEnumerationUnits[iplane] == null) continue;
                    plane = pd.planes.get(iplane);
                    tt = plane.getType();
                    planeds = plane.getDs();
                    double v = -1.0;
                    if (planeds.rank() != 1) {
                        if (planeds.rank() == 2) {
                            throw new IllegalArgumentException("not supported rank 2 enumeration units");
                        }
                        throw new IllegalArgumentException("not supported rank N enumeration units");
                    }
                    v = planeds.value(i);
                    int iv = (int)v;
                    if (enumerations.containsKey(iv)) continue;
                    EnumerationUnits eu = (EnumerationUnits)checkEnumerationUnits[iplane];
                    Datum d = eu.createDatum(iv);
                    int c = eu.getColor(d);
                    String label = d.toString();
                    String ss = String.format("<enumerationUnit name=\"%s\"  value=\"%d\" color=\"0x%06x\" label=\"%s\" />\n", eu.getId(), iv, c, label);
                    byte[] bytes = ss.getBytes("UTF-8");
                    channel.write(ByteBuffer.wrap(String.format("[xx]%06d", bytes.length).getBytes("UTF-8")));
                    channel.write(ByteBuffer.wrap(bytes));
                    enumerations.put(iv, label);
                }
                for (iplane = 0; iplane < planeCount; ++iplane) {
                    boolean lastPlane;
                    plane = pd.planes.get(iplane);
                    tt = plane.getType();
                    planeds = plane.getDs();
                    boolean bl = lastPlane = iplane == planeCount - 1;
                    if (planeds.rank() == 1) {
                        tt.write(planeds.value(i), buffer);
                    } else if (planeds.rank() == 2) {
                        for (int j = 0; j < planeds.length(i); ++j) {
                            tt.write(planeds.value(i, j), buffer);
                        }
                    } else {
                        MutablePropertyDataSet slice = DataSetOps.slice0((QDataSet)planeds, (int)i);
                        QubeDataSetIterator it = new QubeDataSetIterator((QDataSet)slice);
                        while (it.hasNext()) {
                            it.next();
                            tt.write(it.getValue((QDataSet)slice), buffer);
                        }
                    }
                    if (!lastPlane || !tt.isAscii() || !Character.isWhitespace(buffer.get(bufferSize - 1))) continue;
                    buffer.put(bufferSize - 1, (byte)10);
                }
                buffer.flip();
                channel.write(buffer);
                buffer.position(4);
            }
            buffer.flip();
        } else {
            int planeCount = pd.planes.size();
            for (int iplane = 0; iplane < planeCount; ++iplane) {
                boolean lastPlane;
                PlaneDescriptor plane = pd.planes.get(iplane);
                TransferType tt = plane.getType();
                QDataSet planeds = plane.getDs();
                QubeDataSetIterator it = new QubeDataSetIterator(planeds);
                while (it.hasNext()) {
                    it.next();
                    tt.write(it.getValue(planeds), buffer);
                }
                boolean bl = lastPlane = iplane == planeCount - 1;
                if (!lastPlane || !tt.isAscii() || !Character.isWhitespace(buffer.get(bufferSize - 1))) continue;
                buffer.put(bufferSize - 1, (byte)10);
            }
            buffer.flip();
            channel.write(buffer);
            buffer.flip();
        }
    }

    private synchronized void setNameFor(QDataSet slice, String name) {
        if (!name.equals(this.names.get(slice))) {
            if (this.names.get(slice) != null) {
                throw new IllegalArgumentException("already have name for: " + slice + "  want to set to " + name);
            }
            this.maybePutName(slice, name);
        }
    }

    private synchronized String nameFor(QDataSet dep0) {
        boolean assignName;
        String name = this.names.get(dep0);
        boolean bl = assignName = name == null;
        if (name == null) {
            name = (String)dep0.property("NAME");
        }
        if (name == null) {
            name = "ds_" + this.names.size();
        }
        if (assignName) {
            this.maybePutName(dep0, name);
        }
        return name;
    }

    PacketDescriptor doPacketDescriptorNonQube(StreamDescriptor sd, QDataSet ds, boolean stream, boolean valuesInDescriptor, int streamRank) throws ParserConfigurationException {
        QDataSet plane0;
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setStream(stream);
        packetDescriptor.setStreamRank(streamRank);
        if (valuesInDescriptor) {
            packetDescriptor.setValuesInDescriptor(true);
        }
        Document document = sd.newDocument(packetDescriptor);
        Element packetElement = this.getPacketElement(document);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            PlaneDescriptor planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, dep0, streamRank);
            packetDescriptor.addPlane(planeDescriptor);
            packetElement.appendChild(planeDescriptor.getDomElement());
        }
        for (int i = 0; i < 50 && (plane0 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            PlaneDescriptor planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, plane0, streamRank);
            packetDescriptor.addPlane(planeDescriptor);
            packetElement.appendChild(planeDescriptor.getDomElement());
        }
        PlaneDescriptor planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, ds, streamRank);
        packetDescriptor.addPlane(planeDescriptor);
        packetElement.appendChild(planeDescriptor.getDomElement());
        packetDescriptor.setDomElement(packetElement);
        return packetDescriptor;
    }

    PacketDescriptor doPacketDescriptorJoin(StreamDescriptor sd, QDataSet ds, boolean stream, boolean valuesInDescriptor, int streamRank) throws ParserConfigurationException {
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setStream(stream);
        packetDescriptor.setStreamRank(streamRank);
        if (valuesInDescriptor) {
            packetDescriptor.setValuesInDescriptor(true);
        }
        Document document = sd.newDocument(packetDescriptor);
        Element packetElement = this.getPacketElement(document);
        Object join = ds.property("JOIN_0");
        if (join == null) {
            throw new IllegalArgumentException("expected join");
        }
        PlaneDescriptor planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, ds, streamRank);
        packetDescriptor.addPlane(planeDescriptor);
        packetElement.appendChild(planeDescriptor.getDomElement());
        packetDescriptor.setDomElement(packetElement);
        return packetDescriptor;
    }

    PacketDescriptor doPacketDescriptorBundle(StreamDescriptor sd, QDataSet ds) throws ParserConfigurationException {
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setStream(true);
        packetDescriptor.setStreamRank(2);
        packetDescriptor.setValuesInDescriptor(true);
        Document document = sd.newDocument(packetDescriptor);
        Element packetElement = this.getPacketElement(document);
        QDataSet bds = (QDataSet)ds.property("BUNDLE_1");
        if (bds == null) {
            throw new IllegalArgumentException("not supported");
        }
        PlaneDescriptor planeDescriptor = this.doPlaneDescriptorBundle(document, packetDescriptor, ds, ds.rank());
        packetDescriptor.addPlane(planeDescriptor);
        packetElement.appendChild(planeDescriptor.getDomElement());
        packetDescriptor.setDomElement(packetElement);
        return packetDescriptor;
    }

    PacketDescriptor doPacketDescriptor(StreamDescriptor sd, QDataSet ds, boolean stream, boolean valuesInDescriptor, int streamRank, String joinId) throws ParserConfigurationException {
        QDataSet plane0;
        PlaneDescriptor planeDescriptor;
        int i;
        if (!valuesInDescriptor && !DataSetUtil.isQube((QDataSet)ds)) {
            throw new IllegalArgumentException("must be qube!");
        }
        PacketDescriptor packetDescriptor = new PacketDescriptor();
        packetDescriptor.setStream(stream);
        packetDescriptor.setStreamRank(streamRank);
        if (valuesInDescriptor) {
            packetDescriptor.setValuesInDescriptor(true);
        }
        Document document = sd.newDocument(packetDescriptor);
        Element packetElement = this.getPacketElement(document);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            PlaneDescriptor planeDescriptor2 = this.doPlaneDescriptor(document, packetDescriptor, dep0, streamRank);
            packetDescriptor.addPlane(planeDescriptor2);
            packetElement.appendChild(planeDescriptor2.getDomElement());
        }
        for (i = 1; i < 4; ++i) {
            QDataSet depi = (QDataSet)ds.property("DEPEND_" + i);
            if (depi == null || depi.rank() != 2) continue;
            planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, depi, streamRank);
            packetDescriptor.addPlane(planeDescriptor);
            packetElement.appendChild(planeDescriptor.getDomElement());
        }
        for (i = 0; i < 50 && (plane0 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, plane0, streamRank);
            packetDescriptor.addPlane(planeDescriptor);
            packetElement.appendChild(planeDescriptor.getDomElement());
        }
        for (i = 0; i < 4; ++i) {
            QDataSet minmax;
            if (i == 0) {
                minmax = (QDataSet)ds.property("DELTA_MINUS");
            } else if (i == 1) {
                minmax = (QDataSet)ds.property("DELTA_PLUS");
            } else if (i == 2) {
                minmax = (QDataSet)ds.property("BIN_MINUS");
            } else if (i == 3) {
                minmax = (QDataSet)ds.property("BIN_PLUS");
            } else {
                throw new IllegalArgumentException("implementation problem");
            }
            if (minmax == null) continue;
            planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, minmax, streamRank);
            packetDescriptor.addPlane(planeDescriptor);
            packetElement.appendChild(planeDescriptor.getDomElement());
        }
        if (this.newBundle && SemanticOps.isBundle((QDataSet)ds)) {
            for (i = 0; i < ds.length(0); ++i) {
                QDataSet ds1 = DataSetOps.unbundle((QDataSet)ds, (int)i);
                planeDescriptor = this.doPlaneDescriptor(document, packetDescriptor, ds1, streamRank);
                packetDescriptor.addPlane(planeDescriptor);
                Element dselement = planeDescriptor.getDomElement();
                if (joinId != null) {
                    dselement.setAttribute("joinId", joinId);
                }
                packetElement.appendChild(dselement);
            }
        } else {
            PlaneDescriptor planeDescriptor3 = this.doPlaneDescriptor(document, packetDescriptor, ds, streamRank);
            packetDescriptor.addPlane(planeDescriptor3);
            Element dselement = planeDescriptor3.getDomElement();
            if (joinId != null) {
                dselement.setAttribute("joinId", joinId);
            }
            packetElement.appendChild(dselement);
        }
        packetDescriptor.setDomElement(packetElement);
        return packetDescriptor;
    }

    public void format(QDataSet ds, OutputStream osout, boolean asciiTypes) throws StreamException, IOException {
        try {
            boolean isjoin;
            int streamRank;
            int packetDescriptorCount;
            this.asciiTypes = asciiTypes;
            WritableByteChannel out = Channels.newChannel(osout);
            StreamDescriptor sd = this.doStreamDescriptor(ds);
            ArrayList probs = new ArrayList();
            if (!DataSetUtil.validate((QDataSet)ds, probs)) {
                throw new IllegalArgumentException("DataSet is not valid: " + (String)probs.get(0));
            }
            ArrayList<PacketDescriptor> depPackets = new ArrayList<PacketDescriptor>();
            sd.send(sd, out);
            String dep0Name = null;
            if (this.isBundle(ds) && asciiTypes) {
                System.err.println("suboptimal implementation doesn't use different formatters for each bundled dataset");
            }
            if (DataSetUtil.isQube((QDataSet)ds)) {
                packetDescriptorCount = 1;
                streamRank = 1;
            } else if (this.isJoin(ds)) {
                packetDescriptorCount = ds.length();
                streamRank = 1;
            } else {
                packetDescriptorCount = ds.length();
                streamRank = 2;
            }
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
            if (dep0 != null) {
                dep0Name = this.nameFor(dep0);
            }
            String joinDataSet = null;
            boolean bl = isjoin = ds.property("JOIN_0") != null;
            if (isjoin) {
                PacketDescriptor join = this.doPacketDescriptorJoin(sd, ds, false, false, streamRank);
                sd.addDescriptor(join);
                sd.send(join, out);
                joinDataSet = this.nameFor(ds);
            }
            for (int ipacket = 0; ipacket < packetDescriptorCount; ++ipacket) {
                PacketDescriptor pd;
                QDataSet depi;
                int i;
                QDataSet packetDs;
                ArrayList<PacketDescriptor> retire = new ArrayList<PacketDescriptor>();
                if (streamRank == 1 && !isjoin) {
                    packetDs = ds;
                } else {
                    packetDs = ds.slice(ipacket);
                    this.maybePutName(packetDs, this.nameFor(packetDs));
                    if (dep0Name != null) {
                        this.maybePutName((QDataSet)packetDs.property("DEPEND_0"), dep0Name);
                    }
                }
                if (this.isJoin(packetDs)) {
                    throw new IllegalArgumentException("join of join not supported");
                }
                PacketDescriptor mainPd = this.doPacketDescriptor(sd, packetDs, true, false, streamRank, joinDataSet);
                sd.addDescriptor(mainPd);
                for (i = 1; i < 4; ++i) {
                    depi = (QDataSet)packetDs.property("DEPEND_" + i);
                    if (depi == null) continue;
                    if (depi == dep0) {
                        throw new RuntimeException("bug in QStream prevents DEPEND_0==DEPEND_1");
                    }
                    if (depi.rank() == 2) continue;
                    boolean valuesInDescriptor = true;
                    if (depi.length() > 100) {
                        valuesInDescriptor = false;
                    }
                    pd = this.doPacketDescriptor(sd, depi, false, valuesInDescriptor, 1, null);
                    pd.setValuesInDescriptor(valuesInDescriptor);
                    sd.addDescriptor(pd);
                    depPackets.add(pd);
                    sd.send(pd, out);
                    if (!valuesInDescriptor) continue;
                    retire.add(pd);
                }
                for (i = 0; i < 2; ++i) {
                    depi = (QDataSet)packetDs.property("BUNDLE_" + i);
                    if (depi == null) continue;
                    ArrayList<QDataSet> retireBundleDep1 = new ArrayList<QDataSet>();
                    for (int j = 0; j < depi.length(); ++j) {
                        QDataSet b1;
                        QDataSet dep1 = (QDataSet)depi.property("DEPEND_1", j);
                        if (dep1 != null && !retireBundleDep1.contains(dep1)) {
                            pd = this.doPacketDescriptor(sd, dep1, false, true, 1, null);
                            sd.addDescriptor(pd);
                            depPackets.add(pd);
                            sd.send(pd, out);
                            retireBundleDep1.add(dep1);
                        }
                        if ((b1 = (QDataSet)depi.property("BUNDLE_1", j)) == null || retireBundleDep1.contains(b1)) continue;
                        pd = this.doPacketDescriptor(sd, b1, false, true, 1, null);
                        sd.addDescriptor(pd);
                        depPackets.add(pd);
                        sd.send(pd, out);
                        retireBundleDep1.add(b1);
                    }
                    boolean valuesInDescriptor = true;
                    pd = this.doPacketDescriptor(sd, depi, false, valuesInDescriptor, 1, null);
                    sd.addDescriptor(pd);
                    depPackets.add(pd);
                    if (!this.newBundle) {
                        sd.send(pd, out);
                    }
                    retire.add(pd);
                }
                sd.send(mainPd, out);
                if (this.newBundle && SemanticOps.isBundle((QDataSet)ds)) {
                    QDataSet bds = (QDataSet)ds.property("BUNDLE_1");
                    PacketDescriptor bdsd = this.doPacketDescriptorNonQube(sd, bds, false, true, 2);
                    sd.addDescriptor(bdsd);
                    sd.send(bdsd, out);
                    PacketDescriptor join = this.doPacketDescriptorBundle(sd, ds);
                    sd.addDescriptor(join);
                    sd.send(join, out);
                    joinDataSet = this.nameFor(ds);
                }
                for (PacketDescriptor deppd : depPackets) {
                    if (deppd.isValuesInDescriptor()) continue;
                    this.formatPackets(out, sd, deppd);
                    sd.retireDescriptor(deppd);
                }
                this.formatPackets(out, sd, mainPd);
                for (PacketDescriptor r : retire) {
                    sd.retireDescriptor(r);
                }
                sd.retireDescriptor(mainPd);
            }
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void maybePutName(QDataSet packetDs, String nameFor) {
        if (!this.names.containsKey(packetDs)) {
            this.names.put(packetDs, nameFor);
        } else {
            System.err.println("already have name for " + packetDs);
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamException {
        QDataSet ds = Ops.ripplesJoinSpectrogramTimeSeries((int)24);
        SimpleStreamFormatter form = new SimpleStreamFormatter();
        FileOutputStream fo = new FileOutputStream("/tmp/foo.simpleformatter.qds");
        form.format(ds, fo, true);
        ((OutputStream)fo).close();
    }
}

