/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream.filter;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qstream.AsciiTimeTransferType;
import org.das2.qstream.PacketDescriptor;
import org.das2.qstream.PlaneDescriptor;
import org.das2.qstream.SerialStreamFormatter;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamTool;
import org.das2.qstream.filter.QDataSetsFilter;

public class MinMaxReduceFilter
extends QDataSetsFilter {
    SerialStreamFormatter form = new SerialStreamFormatter();
    Datum cadence;
    int icadence;
    QDataSet offsets;
    private static final String NAME = "MinMax";
    QDataSetsFilter.QDataSetSink mySink = new QDataSetsFilter.QDataSetSink(){
        QDataSet ttag;

        @Override
        public void packetData(PacketDescriptor pd, PlaneDescriptor pld, QDataSet ds) {
            block17: {
                List<PlaneDescriptor> planes;
                block15: {
                    block16: {
                        planes = pd.getPlanes();
                        if (planes.size() <= 1) break block15;
                        if (pld != planes.get(0)) break block16;
                        this.ttag = ds;
                        break block17;
                    }
                    if (pld != planes.get(planes.size() - 1)) break block17;
                    if (MinMaxReduceFilter.this.icadence < 64) {
                        MutablePropertyDataSet mds = DataSetOps.makePropertiesMutable((QDataSet)ds);
                        mds.putProperty("NAME", (Object)MinMaxReduceFilter.NAME);
                        mds.putProperty("CONTEXT_0", (Object)this.ttag);
                        mds.putProperty("DEPEND_0", (Object)MinMaxReduceFilter.this.offsets);
                        try {
                            MinMaxReduceFilter.this.form.format("waveform", (QDataSet)mds, "streaming");
                        }
                        catch (IOException iOException) {
                        }
                        catch (StreamException streamException) {}
                    } else {
                        int i = 0;
                        while (i + MinMaxReduceFilter.this.icadence < MinMaxReduceFilter.this.offsets.length()) {
                            MutablePropertyDataSet mds = DataSetOps.makePropertiesMutable((QDataSet)Ops.extent((QDataSet)ds.trim(i, i + MinMaxReduceFilter.this.icadence)));
                            mds.putProperty("NAME", (Object)MinMaxReduceFilter.NAME);
                            mds.putProperty("CONTEXT_0", (Object)Ops.add((QDataSet)this.ttag, (QDataSet)MinMaxReduceFilter.this.offsets.slice(i + MinMaxReduceFilter.this.icadence / 2)));
                            mds.putProperty("RENDER_TYPE", (Object)"waveform");
                            try {
                                MinMaxReduceFilter.this.form.format("reduce", (QDataSet)mds, "streaming");
                            }
                            catch (IOException iOException) {
                            }
                            catch (StreamException streamException) {
                                // empty catch block
                            }
                            i += MinMaxReduceFilter.this.icadence;
                        }
                    }
                    break block17;
                }
                if (planes.size() != 1) break block17;
                MinMaxReduceFilter.this.offsets = ds;
                MinMaxReduceFilter.this.icadence = 4;
                while (MinMaxReduceFilter.this.icadence < MinMaxReduceFilter.this.offsets.length() / 2 && MinMaxReduceFilter.this.cadence.gt(DataSetUtil.asDatum((QDataSet)MinMaxReduceFilter.this.offsets.slice(MinMaxReduceFilter.this.icadence)).subtract(DataSetUtil.asDatum((QDataSet)MinMaxReduceFilter.this.offsets.slice(0))))) {
                    MinMaxReduceFilter.this.icadence *= 2;
                }
                MinMaxReduceFilter.this.icadence /= 2;
                if (MinMaxReduceFilter.this.icadence < 2) {
                    throw new IllegalArgumentException("should not happen");
                }
                if (MinMaxReduceFilter.this.icadence < 64) {
                    try {
                        MinMaxReduceFilter.this.form.format("offsets", ds, "oneRecord");
                    }
                    catch (IOException ex) {
                        QDataSetsFilter.logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    catch (StreamException ex) {
                        QDataSetsFilter.logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
        }
    };

    void init(OutputStream out) throws IOException, StreamException {
        this.form.setAsciiTypes(false);
        this.form.setUnitTransferType((Units)Units.us2000, new AsciiTimeTransferType(17, (Units)Units.us2000));
        String name = NAME;
        this.form.init(name, Channels.newChannel(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws StreamException, MalformedURLException, IOException, ParseException {
        InputStream in = System.in;
        OutputStream out = System.out;
        if (args.length == 0 || args[0].trim().length() == 0) {
            System.err.println("java -jar autoplot.jar org.qstream.filter.MinMaxFilter <seconds> [Urlin] [FileOut]");
            System.exit(-1);
        }
        if (args.length > 1) {
            in = new URL(args[1]).openStream();
        }
        if (args.length > 2) {
            out = new FileOutputStream(args[2]);
        }
        try {
            MinMaxReduceFilter me = new MinMaxReduceFilter();
            me.cadence = Units.seconds.parse(args[0]);
            me.init(out);
            me.setSink(me.mySink);
            StreamTool.readStream(Channels.newChannel(in), me);
        }
        finally {
            out.close();
            in.close();
        }
    }
}

