/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.ppi.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class PPITime
implements Comparable<PPITime> {
    public static final String AMERDATE = "MM/dd/yy HH:mm:ss.SSS";
    public static final String EURODATE = "dd-MM-yy HH:mm:ss.SSS";
    public static final String AMER = "MMM dd, yyyy HH:mm:ss.SSS";
    public static final String EURO = "dd MMM yyyy HH:mm:ss.SSS";
    public static final String DOY = "yyyy DD HH:mm:ss.SSS";
    public static final String JAPANDATE = "yyyy.MM.dd HH:mm:ss.SSS";
    public static final String NIPPONDATE = "yyyy.dd.MM yyyy HH:mm:ss.SSS";
    public static final String HIGHLOW = "yyyy MM dd HH:mm:ss.SSS";
    public static final String ISEEDATE = "yyyy DDD MMM dd HH:mm:ss.SSS";
    public static final String DFS = "yyyy-MMM-dd HH:mm:ss.SSS";
    public static final String ABBRDFS = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final String PDS = "T";
    public static final String ISO = "yyyyMMddThhmmss.SSSS";
    public static final String BINARY = "B1966";
    public static final String CLUSTER = "dd-MM-yyy HH:mm:ss.SSS";
    public TimeZone mTimeZone = TimeZone.getTimeZone("GMT-0:00");
    public Calendar mDate = Calendar.getInstance(this.mTimeZone);

    public PPITime() {
    }

    public PPITime(PPITime item) {
        this.mDate = (Calendar)item.mDate.clone();
    }

    public static void main(String[] args) {
        PPITime time = new PPITime();
        if (args.length < 3) {
            System.out.println("Usage: PPITime TimeString InFormat OutFormat");
            return;
        }
        System.out.println("args[0]: " + args[0]);
        time.convert(PPITime.findSpec(args[1]), args[0]);
        System.out.println("Binary: " + time.format(BINARY));
        System.out.print(args[2] + ": ");
        String buffer = time.format(PPITime.findSpec(args[2]));
        System.out.println(buffer);
    }

    public boolean convert(String pattern, String buffer) {
        if (buffer.length() == 0) {
            return false;
        }
        if (pattern.length() == 0) {
            return false;
        }
        try {
            if (pattern.charAt(0) == 'B') {
                int year = pattern.length() < 5 ? 1966 : Integer.parseInt(pattern.substring(1));
                double seconds = Double.parseDouble(buffer);
                long milli = (long)(seconds * 1000.0);
                this.mDate.setTimeInMillis(milli);
                this.mDate.add(1, year - 1970);
            } else if (pattern.charAt(0) == 'T') {
                String[] part;
                String[] piece;
                int year = 0;
                int doy = 1;
                int month = 0;
                int day = 1;
                int hour = 0;
                int minute = 0;
                double seconds = 0.0;
                if (buffer.compareToIgnoreCase("EOM") == 0) {
                    this.eternity();
                    return true;
                }
                if (buffer.compareToIgnoreCase("LAUNCH") == 0) {
                    this.dawn();
                    return true;
                }
                if (buffer.charAt(buffer.length() - 1) == 'Z') {
                    if (buffer.length() < 2) {
                        return false;
                    }
                    buffer = buffer.substring(0, buffer.length() - 1);
                }
                if ((piece = (part = buffer.split(PDS))[0].split("-")).length > 0) {
                    year = Integer.parseInt(piece[0]);
                }
                if (piece.length == 2) {
                    doy = Integer.parseInt(piece[1]);
                }
                if (piece.length > 2) {
                    month = Integer.parseInt(piece[1]);
                    day = Integer.parseInt(piece[2]);
                }
                if (part.length > 1) {
                    piece = part[1].split(":");
                    if (piece.length > 0) {
                        hour = Integer.parseInt(piece[0]);
                    }
                    if (piece.length > 1) {
                        minute = Integer.parseInt(piece[1]);
                    }
                    if (piece.length > 2) {
                        seconds = Double.parseDouble(piece[2]);
                    }
                }
                if (month == 0) {
                    buffer = year + " " + doy + " ";
                    pattern = "yyyy DDD HH:mm:ss.SSS";
                } else {
                    buffer = year + " " + month + " " + day + " ";
                    pattern = HIGHLOW;
                }
                buffer = buffer + hour + ":" + minute + ":" + seconds;
                SimpleDateFormat parser = new SimpleDateFormat(pattern);
                parser.setTimeZone(this.mTimeZone);
                this.mDate.setTime(parser.parse(buffer));
            } else {
                SimpleDateFormat parser = new SimpleDateFormat(pattern);
                parser.setTimeZone(this.mTimeZone);
                this.mDate.setTime(parser.parse(buffer));
                int n = this.mDate.get(1);
                if (n >= 20 && n < 100) {
                    this.mDate.add(1, 1900);
                }
                if (n >= 0 && n < 20) {
                    this.mDate.add(1, 2000);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String format(String pattern) {
        String buffer;
        if (pattern == null) {
            return "Invalid pattern";
        }
        if (pattern.charAt(0) == 'B') {
            int year = pattern.length() < 5 ? 1966 : Integer.parseInt(pattern.substring(1));
            Calendar refYear = Calendar.getInstance(this.mTimeZone);
            refYear.set(year, 1, 1, 0, 0, 0);
            Calendar sysYear = Calendar.getInstance(this.mTimeZone);
            sysYear.set(1970, 1, 1, 0, 0, 0);
            long milli = this.mDate.getTimeInMillis();
            milli -= refYear.getTimeInMillis();
            long seconds = (milli += sysYear.getTimeInMillis()) / 1000L;
            long diff = milli - seconds * 1000L;
            buffer = Long.toString(seconds);
            buffer = buffer + ".";
            String temp = Long.toString(diff);
            for (int i = 0; i < 3 - temp.length(); ++i) {
                buffer = buffer + "0";
            }
            int n = temp.length();
            if (n > 3) {
                n = 3;
            }
            buffer = buffer + temp.substring(0, n);
        } else {
            int n = pattern.indexOf(84);
            if (n != -1) {
                if (pattern.compareTo(PDS) == 0) {
                    SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd");
                    parser.setTimeZone(this.mTimeZone);
                    buffer = parser.format(this.mDate.getTime()) + PDS;
                    parser = new SimpleDateFormat("HH:mm:ss.SSS");
                    parser.setTimeZone(this.mTimeZone);
                    buffer = buffer + parser.format(this.mDate.getTime());
                } else {
                    SimpleDateFormat parser;
                    buffer = "";
                    String temp = pattern.substring(0, n);
                    if (temp.length() > 0) {
                        parser = new SimpleDateFormat(pattern.substring(0, n));
                        parser.setTimeZone(this.mTimeZone);
                        buffer = buffer + parser.format(this.mDate.getTime());
                    }
                    buffer = buffer + PDS;
                    temp = pattern.substring(n + 1);
                    if (temp.length() > 0) {
                        parser = new SimpleDateFormat(temp);
                        parser.setTimeZone(this.mTimeZone);
                        buffer = buffer + parser.format(this.mDate.getTime());
                    }
                }
            } else {
                SimpleDateFormat parser = new SimpleDateFormat(pattern);
                parser.setTimeZone(this.mTimeZone);
                buffer = parser.format(this.mDate.getTime());
            }
        }
        return buffer;
    }

    public static String findSpec(String name) {
        if (name.compareToIgnoreCase("PDS") == 0) {
            return PDS;
        }
        if (name.compareToIgnoreCase("BINARY") == 0) {
            return BINARY;
        }
        if (name.compareToIgnoreCase("CLUSTER") == 0) {
            return CLUSTER;
        }
        if (name.compareToIgnoreCase("DFS") == 0) {
            return DFS;
        }
        if (name.compareToIgnoreCase("ABBRDFS") == 0) {
            return ABBRDFS;
        }
        if (name.compareToIgnoreCase("ISO") == 0) {
            return ISO;
        }
        if (name.compareToIgnoreCase("DOY") == 0) {
            return DOY;
        }
        if (name.compareToIgnoreCase("AMERDATE") == 0) {
            return AMERDATE;
        }
        if (name.compareToIgnoreCase("EURODATE") == 0) {
            return EURODATE;
        }
        if (name.compareToIgnoreCase("AMER") == 0) {
            return AMER;
        }
        if (name.compareToIgnoreCase("EURO") == 0) {
            return EURO;
        }
        if (name.compareToIgnoreCase("JAPANDATE") == 0) {
            return JAPANDATE;
        }
        if (name.compareToIgnoreCase("NIPPONDATE") == 0) {
            return NIPPONDATE;
        }
        if (name.compareToIgnoreCase("HIGHLOW") == 0) {
            return HIGHLOW;
        }
        if (name.compareToIgnoreCase("ISEEDATE") == 0) {
            return ISEEDATE;
        }
        return name;
    }

    public void dawn() {
        Calendar calendar = Calendar.getInstance(this.mTimeZone);
        calendar.set(1, calendar.getMinimum(1));
        calendar.set(2, calendar.getMinimum(2));
        calendar.set(5, calendar.getMinimum(5));
        calendar.set(11, calendar.getMinimum(11));
        calendar.set(12, calendar.getMinimum(12));
        calendar.set(13, calendar.getMinimum(13));
        this.mDate.setTime(calendar.getTime());
    }

    public void eternity() {
        Calendar calendar = Calendar.getInstance(this.mTimeZone);
        calendar.set(1, 9000);
        calendar.set(2, calendar.getMaximum(2));
        calendar.set(5, calendar.getMaximum(5));
        calendar.set(11, calendar.getMaximum(11));
        calendar.set(12, calendar.getMaximum(12));
        calendar.set(13, calendar.getMaximum(13));
        this.mDate.setTime(calendar.getTime());
    }

    @Override
    public int compareTo(PPITime anotherTime) {
        return this.mDate.getTime().compareTo(anotherTime.mDate.getTime());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PPITime)) {
            return false;
        }
        PPITime other = (PPITime)obj;
        return this.mDate.compareTo(other.mDate) == 0;
    }

    public int hashCode() {
        return this.mDate.hashCode();
    }

    public void copy(PPITime item) {
        this.mDate = (Calendar)item.mDate.clone();
    }

    public void advance(double minutes) {
        int min = (int)minutes;
        double seconds = (minutes - (double)min) * 60.0;
        int sec = (int)seconds;
        int milli = (int)((seconds - (double)sec) * 1000.0);
        this.mDate.add(12, min);
        this.mDate.add(13, sec);
        this.mDate.add(14, milli);
    }

    public void now() {
        this.mDate.setTime(Calendar.getInstance(this.mTimeZone).getTime());
    }

    public long span(PPITime other) {
        return this.mDate.getTimeInMillis() - other.mDate.getTimeInMillis();
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("00");
        DecimalFormat dfm = new DecimalFormat("000");
        return this.mDate.get(1) + "-" + df.format(this.mDate.get(2) + 1) + "-" + df.format(this.mDate.get(5)) + PDS + df.format(this.mDate.get(11)) + ":" + df.format(this.mDate.get(12)) + ":" + df.format(this.mDate.get(13)) + "." + dfm.format(this.mDate.get(14));
    }
}

