/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pds;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilePointer {
    private URL url;
    private int offset;
    public static final String PROP_LINE = "line";
    private Unit offsetUnits = Unit.LINES;

    public FilePointer(URL url, int line) {
        this.url = url;
        this.offset = line;
    }

    public FilePointer(URL labelFile, String f) {
        try {
            URL url;
            Pattern p = Pattern.compile("([^,]+)(,\\s*(\\d+)(\\s*\\<BYTES\\>)?)?", 2);
            Matcher m = p.matcher(f);
            if (!m.matches()) {
                throw new IllegalArgumentException("LABEL/POINTER should match ([^,]+)(,\\s*(\\d+)(\\s*\\<BYTES\\>)?)?");
            }
            this.url = url = new URL(labelFile, m.group(1));
            if (m.group(3) != null) {
                this.offsetUnits = m.group(4) != null && m.group(4).toUpperCase().endsWith("<BYTES>") ? Unit.BYTES : Unit.LINES;
                this.offset = Integer.parseInt(m.group(3));
            }
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String toString() {
        return this.url.toString() + (this.offset != 1 ? ", " + this.offset : "");
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Unit getOffsetUnits() {
        return this.offsetUnits;
    }

    public void setOffsetUnits(Unit offsetUnits) {
        this.offsetUnits = offsetUnits;
    }

    public static enum Unit {
        BYTES,
        LINES;

    }
}

