/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pds;

import gov.nasa.pds.label.Label;
import gov.nasa.pds.label.object.ArrayObject;
import gov.nasa.pds.label.object.DataObject;
import gov.nasa.pds.label.object.FieldDescription;
import gov.nasa.pds.label.object.TableObject;
import gov.nasa.pds.objectAccess.ParseException;
import gov.nasa.pds.ppi.label.PDSException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.autoplot.pds.Pds3DataSource;
import org.autoplot.pds.PdsDataSource;
import org.das2.datum.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PdsDataSourceFactory
extends AbstractDataSourceFactory {
    private static Logger logger = LoggerManager.getLogger((String)"apdss.pds");

    public DataSource getDataSource(URI uri) throws Exception {
        URISplit split = URISplit.parse((URI)uri);
        if (split.file.toLowerCase().endsWith(".lbl")) {
            return new Pds3DataSource(uri);
        }
        return new PdsDataSource(uri);
    }

    private DataObject getDataObject(URL url, String name) throws MalformedURLException, ParseException, Exception {
        Label label = Label.open((URL)url);
        for (TableObject t : label.getObjects(TableObject.class)) {
            for (FieldDescription fd : t.getFields()) {
                if (!name.startsWith(fd.getName())) continue;
                return t;
            }
        }
        for (ArrayObject a : label.getObjects(ArrayObject.class)) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public boolean reject(String suri, List<String> problems, ProgressMonitor mon) {
        try {
            URL fileUrl;
            URISplit split = URISplit.parse((String)suri);
            LinkedHashMap params = URISplit.parseParams((String)split.params);
            String id = (String)params.get("arg_0");
            if (id == null) {
                id = (String)params.get("id");
            }
            if (id == null) {
                id = (String)params.get("X");
            }
            if (id == null) {
                id = (String)params.get("Y");
            }
            if (id == null) {
                id = (String)params.get("Z");
            }
            File xmlfile = DataSetURI.getFile((URL)split.resourceUri.toURL(), (ProgressMonitor)new NullProgressMonitor());
            try {
                fileUrl = PdsDataSourceFactory.getFileResource(split.resourceUri.toURL(), mon);
            }
            catch (IOException | URISyntaxException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
                problems.add("uri should point to xml or lblx file");
                return true;
            }
            DataSetURI.getFile((URL)fileUrl, (ProgressMonitor)mon);
            if (id == null) {
                return true;
            }
            try {
                this.getDataObject(xmlfile.toURI().toURL(), id);
                return false;
            }
            catch (Exception ex) {
                problems.add(ex.getMessage());
                return true;
            }
        }
        catch (PDSException | IOException | IllegalArgumentException ex) {
            logger.log(Level.SEVERE, null, ex);
            problems.add(ex.getMessage());
            return false;
        }
    }

    private Map<String, String> getDataObjectNames(URL url, ProgressMonitor mon) throws Exception {
        URL fileUrl = PdsDataSourceFactory.getFileResource(url, mon);
        File xmlfile = DataSetURI.getFile((URL)url, (ProgressMonitor)new NullProgressMonitor());
        DataSetURI.getFile((URL)fileUrl, (ProgressMonitor)mon);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Label label = Label.open((URL)xmlfile.toURI().toURL());
        for (TableObject t : label.getObjects(TableObject.class)) {
            for (FieldDescription fd : t.getFields()) {
                result.put(fd.getName(), fd.getName() + " of a table");
            }
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(false);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.parse(xmlfile);
        for (ArrayObject a : label.getObjects(ArrayObject.class)) {
            String n = a.getName();
            XPathExpression xp = XPathFactory.newInstance().newXPath().compile("//Product_Observational/File_Area_Observational/Array[name='" + n + "']");
            Node n1 = (Node)xp.evaluate(doc, XPathConstants.NODE);
            XPathExpression xp2 = XPathFactory.newInstance().newXPath().compile("Axis_Array/axis_name/text()");
            NodeList nn = (NodeList)xp2.evaluate(n1, XPathConstants.NODESET);
            CharSequence[] ss = new String[nn.getLength()];
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = nn.item(i).getTextContent();
            }
            result.put(a.getName(), a.getName() + " (" + String.join((CharSequence)",", ss) + ")");
        }
        return result;
    }

    protected static URL getFileResource(URL labelFile, ProgressMonitor mon) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, XPathExpressionException, PDSException {
        File file;
        String suri = DataSetURI.fromUri((URI)labelFile.toURI());
        File xmlfile = file = DataSetURI.getFile((String)suri, (ProgressMonitor)mon);
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(false);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.parse(xmlfile);
        XPathExpression xp = XPathFactory.newInstance().newXPath().compile("//Product_Observational/File_Area_Observational/File/file_name/text()");
        String fname = (String)xp.evaluate(doc, XPathConstants.STRING);
        if (fname.length() == 0) {
            throw new IllegalArgumentException("file name is empty or not found at //Product_Observational/File_Area_Observational/File/file_name/text()");
        }
        URL fnameUrl = new URL(labelFile, fname);
        return fnameUrl;
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        String parmname;
        if (cc.context.equals(CompletionContext.CONTEXT_PARAMETER_NAME)) {
            Map<String, String> result;
            URL fileUrl;
            logger.log(Level.FINE, "getCompletions {0}", cc.resourceURI);
            File xmlfile = DataSetURI.getFile((URL)cc.resourceURI.toURL(), (ProgressMonitor)new NullProgressMonitor());
            try {
                fileUrl = PdsDataSourceFactory.getFileResource(cc.resourceURI.toURL(), mon);
            }
            catch (IOException | URISyntaxException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
                ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "point to the xml or lblx file"));
                return ccresult;
            }
            DataSetURI.getFile((URL)fileUrl, (ProgressMonitor)mon);
            try {
                result = this.getDataObjectNames(xmlfile.toURI().toURL(), mon);
            }
            catch (NoClassDefFoundError ex) {
                result = Collections.singletonMap("Java 8 needed", "Must run under Java 8, or use dmg, exe, deb or rpm");
            }
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "", (DataSourceFactory)this, "arg_0", "Select parameter to plot", "", false));
            for (Map.Entry<String, String> e : result.entrySet()) {
                String key = e.getKey();
                String desc = e.getValue();
                CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, key, (DataSourceFactory)this, "arg_0", desc, "", true);
                ccresult.add(cc1);
            }
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "X=", "values typically displayed in horizontal dimension"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "Y=", "values typically displayed in vertical dimension"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "Z=", "values typically color coded"));
            return ccresult;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE && ((parmname = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc)).equals("id") || parmname.equals("X") || parmname.equals("Y") || parmname.equals("Z"))) {
            Map<String, String> result;
            try {
                result = this.getDataObjectNames(cc.resourceURI.toURL(), mon);
            }
            catch (NoClassDefFoundError ex) {
                result = Collections.singletonMap("Java 8 needed", "Must run under Java 8, or use dmg, exe, deb or rpm");
            }
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "", (DataSourceFactory)this, "arg_0", "", null, true));
            for (Map.Entry<String, String> e : result.entrySet()) {
                String key = e.getKey();
                String desc = e.getValue();
                CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key, (DataSourceFactory)this, "arg_0", desc, null, true);
                ccresult.add(cc1);
            }
            return ccresult;
        }
        return Collections.emptyList();
    }
}

