/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.inline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.jythonsupport.Util;
import org.autoplot.jythonsupport.ui.DataMashUp;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.jythoncompletion.ui.CompletionImpl;
import org.das2.util.ColorUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class InlineDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private boolean needTimeRange = false;
    private static final String SCHEME_EVENT_LIST = "eventList";
    private static final String SCHEME_Y_VS_T = "y_vs_t";
    private static final String SCHEME_EVENT_LIST_COLORS = "eventListColors";
    private String scheme = "eventList";
    private static final String[] SINGLE_TEXTFIELD_DELIMS = new String[]{" ", ","};
    private JButton addButton;
    private DataMashUp dataMashUp1;
    private JButton deleteSelectedButton;
    private JLabel directionsLabel;
    private EditorTextPane editorTextPane1;
    private EditorTextPane editorTextPane2;
    private JButton examplesButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTabbedPane jTabbedPane1;
    private JComboBox schemeComboBox;
    private JTable table;
    DefaultTableModel tm;
    String program;
    String jyds;
    JTextField tf;
    String mashupUri = null;

    public DataMashUp getDataMashUp() {
        return this.dataMashUp1;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.schemeComboBox = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.addButton = new JButton();
        this.deleteSelectedButton = new JButton();
        this.jLabel2 = new JLabel();
        this.directionsLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.examplesButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.editorTextPane1 = new EditorTextPane();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.editorTextPane2 = new EditorTextPane();
        this.jPanel3 = new JPanel();
        this.dataMashUp1 = new DataMashUp();
        this.setName("inlineDataSourceEditorPanel");
        this.jTabbedPane1.setToolTipText("jython tab allows short scripts to be constructed");
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                InlineDataSourceEditorPanel.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.schemeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Event List", "Event List w/Colors", "Y(X)"}));
        this.schemeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InlineDataSourceEditorPanel.this.schemeComboBoxActionPerformed(evt);
            }
        });
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Title 1", "Title 2"}));
        this.jScrollPane1.setViewportView(this.table);
        this.addButton.setText("Add...");
        this.addButton.setToolTipText("Add a record");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InlineDataSourceEditorPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.deleteSelectedButton.setText("Delete Selected");
        this.deleteSelectedButton.setToolTipText("Delete selected records");
        this.deleteSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InlineDataSourceEditorPanel.this.deleteSelectedButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Dataset Type:");
        this.directionsLabel.setText("<html><i>Enter a list of times or points</i></html>");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.directionsLabel).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 461, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.deleteSelectedButton, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, -1, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.schemeComboBox, -2, 142, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.schemeComboBox, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.directionsLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteSelectedButton).addGap(0, 188, Short.MAX_VALUE))).addContainerGap()));
        this.jTabbedPane1.addTab("data", this.jPanel1);
        this.jLabel1.setText("<html>Enter lines of jython assignments and expressions.  Expressions are interpreted as the X values, then Y values, then Z values if specified.");
        this.jLabel1.setVerticalAlignment(1);
        this.examplesButton.setText("Examples...");
        this.examplesButton.setToolTipText("Example scripts");
        this.examplesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InlineDataSourceEditorPanel.this.examplesButtonActionPerformed(evt);
            }
        });
        this.editorTextPane1.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                InlineDataSourceEditorPanel.this.editorTextPane1FocusGained(evt);
            }
        });
        this.jScrollPane3.setViewportView((Component)this.editorTextPane1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 325, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.examplesButton, -1, 255, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.examplesButton).addComponent(this.jLabel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 243, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("jython", this.jPanel2);
        this.jLabel3.setText("<html>This shows the equivalent .jy script.  A jy script is a Jython script which loads and manipulates data.  Often a mash-up is converted to a .jy script, and this unmodifiable editor shows an equivalent script.  This \ncan be saved to a .jyds file without the plot command to make a .jyds script.\n");
        this.jLabel3.setVerticalAlignment(1);
        this.jScrollPane4.setViewportView((Component)this.editorTextPane2);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -1, 604, Short.MAX_VALUE).addComponent(this.jLabel3, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, -1, -2).addGap(8, 8, 8).addComponent(this.jScrollPane4, -1, 286, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("jy", this.jPanel4);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dataMashUp1, -2, 616, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dataMashUp1, -1, 321, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("mash up", this.jPanel3);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1));
    }

    private static ComboBoxModel getExamplesComboBoxModel(int icol, String scheme) {
        if (scheme.equals(SCHEME_EVENT_LIST_COLORS)) {
            DefaultComboBoxModel<String> m;
            switch (icol) {
                case 0: {
                    m = new DefaultComboBoxModel<String>(new String[]{"2014-01-01T01:01Z", "2014-01-01T01:01:01.000Z"});
                    break;
                }
                case 1: {
                    m = new DefaultComboBoxModel<String>(new String[]{"2014-01-01T01:01Z", "2014-01-01T01:01:01.000Z"});
                    break;
                }
                case 2: {
                    m = new DefaultComboBoxModel<String>(new String[]{"0x000000", "0xA0A0A0", "0xFFFFFF", "0xFF0000", "0x00FF00", "0x0000FF"});
                    break;
                }
                case 3: {
                    m = new DefaultComboBoxModel<String>(new String[]{"okay", "error"});
                    break;
                }
                default: {
                    throw new IllegalArgumentException("bad column.");
                }
            }
            return m;
        }
        if (icol == 0) {
            return new DefaultComboBoxModel<String>(new String[]{"2014-01-01T01:01Z", "2014-01-01T01:01:01.000Z", "1.23"});
        }
        return new DefaultComboBoxModel<String>(new String[]{"1.23"});
    }

    private static String maybeFindDelim(String s, String[] delims) {
        s = s.trim();
        for (String d : delims) {
            String[] ss = s.split(d, -2);
            if (ss.length <= 1) continue;
            return d;
        }
        return null;
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        JPanel p = new JPanel();
        if (this.tm.getColumnCount() > 3) {
            p.setLayout(new BoxLayout(p, 1));
        } else {
            p.setLayout(new FlowLayout());
        }
        JTextField[] tfs = new JTextField[this.tm.getColumnCount()];
        for (int i = 0; i < this.tm.getColumnCount(); ++i) {
            JComboBox cb1 = new JComboBox();
            cb1.setToolTipText("Examples");
            cb1.setModel(InlineDataSourceEditorPanel.getExamplesComboBoxModel(i, this.scheme));
            cb1.setEditable(true);
            JTextField tf1 = (JTextField)cb1.getEditor().getEditorComponent();
            tf1.setAlignmentX(0.0f);
            tf1.setColumns(20);
            int ir = this.tm.getRowCount() - 1;
            if (this.tm.getRowCount() > 0) {
                tf1.setText(String.valueOf(this.tm.getValueAt(ir, i)));
            }
            p.add(cb1);
            tfs[i] = tf1;
        }
        if (JOptionPane.showConfirmDialog(this.schemeComboBox, p, "Enter Data Point", 2) == 0) {
            StringBuilder sval;
            String[] ss = new String[this.tm.getRowCount() + 1];
            for (int i = 0; i < this.tm.getRowCount(); ++i) {
                if (this.tm.getColumnCount() > 1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append((String)this.tm.getValueAt(i, 0));
                    for (int j = 1; j < this.tm.getColumnCount(); ++j) {
                        sb.append(",").append((String)this.tm.getValueAt(i, j));
                    }
                    ss[i] = sb.toString();
                    continue;
                }
                ss[i] = (String)this.tm.getValueAt(i, 0);
            }
            String s = tfs[0].getText().trim();
            String delim = InlineDataSourceEditorPanel.maybeFindDelim(s, SINGLE_TEXTFIELD_DELIMS);
            if (delim != null) {
                String[] ssval = s.split(delim, -2);
                sval = new StringBuilder(ssval[0]);
                for (int i = 1; i < this.tm.getColumnCount(); ++i) {
                    sval.append(",").append(ssval[i]);
                }
            } else {
                sval = new StringBuilder(tfs[0].getText());
                for (int i = 1; i < this.tm.getColumnCount(); ++i) {
                    sval.append(",").append(tfs[i].getText());
                }
            }
            if (this.tm.getColumnCount() > 1) {
                ss[this.tm.getRowCount()] = sval.toString();
                this.tm = InlineDataSourceEditorPanel.toTableModel(DataSourceUtil.strjoin(Arrays.asList(ss), (String)";"), 2);
            } else {
                ss[this.tm.getRowCount()] = sval.toString();
                this.tm = InlineDataSourceEditorPanel.toTableModel(ss);
            }
            this.setColumnLabels();
            this.table.setModel(this.tm);
        }
    }

    private String getValueAt(TableModel tm, int i, int j) {
        String ss = (String)tm.getValueAt(i, j);
        ss = ss.replaceAll(",", "");
        ss = ss.replaceAll(";", "");
        return ss;
    }

    private void deleteSelectedButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        int[] rows = this.table.getSelectedRows();
        StringBuilder sb = new StringBuilder();
        int irow = 0;
        int k = 0;
        if (rows.length == 0) {
            return;
        }
        boolean rank2Table = this.tm.getColumnCount() > 1;
        for (int i = 0; i < this.tm.getRowCount(); ++i) {
            if (irow < rows.length && rows[irow] == i) {
                ++irow;
                continue;
            }
            if (k > 0) {
                sb.append(rank2Table ? ";" : ",");
            }
            if (rank2Table) {
                for (int j = 0; j < this.tm.getColumnCount(); ++j) {
                    if (j > 0) {
                        sb.append(",");
                    }
                    sb.append(this.getValueAt(this.tm, i, j));
                }
            } else {
                sb.append(this.getValueAt(this.tm, i, 0));
            }
            ++k;
        }
        int rank = this.tm.getColumnCount() > 1 ? 2 : 1;
        this.tm = InlineDataSourceEditorPanel.toTableModel(sb.toString(), rank);
        this.setColumnLabels();
        this.table.setModel(this.tm);
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        LoggerManager.logGuiEvent((ChangeEvent)evt);
        if (this.jTabbedPane1.getSelectedIndex() == 0 && this.tm == null) {
            this.tm = InlineDataSourceEditorPanel.toTableModel(new String[0]);
        }
    }

    private void initializeScheme() {
        switch (this.schemeComboBox.getSelectedIndex()) {
            case 0: {
                this.tm = InlineDataSourceEditorPanel.toTableModel(0, 1);
                this.directionsLabel.setText("<html><i>Enter a list of times or points</i></html>");
                this.scheme = SCHEME_EVENT_LIST;
                this.tm.setColumnIdentifiers(new String[]{"x"});
                break;
            }
            case 1: {
                this.tm = InlineDataSourceEditorPanel.toTableModel(0, 4);
                this.directionsLabel.setText("<html><i>Enter a list of times, colors (0xRRGGBB), and labels</i></html>");
                this.scheme = SCHEME_EVENT_LIST_COLORS;
                this.tm.setColumnIdentifiers(new String[]{"start", "end", "color", "message"});
                break;
            }
            case 2: {
                this.tm = InlineDataSourceEditorPanel.toTableModel(0, 2);
                this.directionsLabel.setText("<html><i>Enter a list X and Y values</i></html>");
                this.scheme = SCHEME_Y_VS_T;
                this.tm.setColumnIdentifiers(new String[]{"x", "y"});
                break;
            }
            default: {
                throw new IllegalArgumentException("whoops");
            }
        }
        this.table.setModel(this.tm);
    }

    private void schemeComboBoxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.initializeScheme();
    }

    private void examplesButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        String t1 = "linspace(0,5*PI,100)\nsin(linspace(0,5*PI,100))";
        String t2 = "t=linspace(0,5*PI,100)\nt,sin(t)";
        String t3 = "createEvent('2014-005',0x00FF00,'On')";
        String t4 = "ds=createEvent('2014-005T12:00/12:10',0x00FF00,'Instrument On')\nds=createEvent(ds,'2014-005T13:00/13:10',0xFF0000,'Instrument Off')\nds=createEvent(ds,'2014-005T14:00/14:10',0x00FF00,'Instrument On')\nds";
        final JTextArea tf1 = new JTextArea(5, 40);
        tf1.setText("linspace(0,5*PI,100)\nsin(linspace(0,5*PI,100))");
        final JComboBox<Object> examples = new JComboBox<Object>(new DefaultComboBoxModel<Object>(new Object[]{"Sine", "Sine With Variable", "createEvent", "multiple events"}));
        examples.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (examples.getSelectedIndex()) {
                    case 0: {
                        tf1.setText("linspace(0,5*PI,100)\nsin(linspace(0,5*PI,100))");
                        break;
                    }
                    case 1: {
                        tf1.setText("t=linspace(0,5*PI,100)\nt,sin(t)");
                        break;
                    }
                    case 2: {
                        tf1.setText("createEvent('2014-005',0x00FF00,'On')");
                        break;
                    }
                    case 3: {
                        tf1.setText("ds=createEvent('2014-005T12:00/12:10',0x00FF00,'Instrument On')\nds=createEvent(ds,'2014-005T13:00/13:10',0xFF0000,'Instrument Off')\nds=createEvent(ds,'2014-005T14:00/14:10',0x00FF00,'Instrument On')\nds");
                        break;
                    }
                }
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add(examples, "North");
        p.add((Component)tf1, "Center");
        if (0 == JOptionPane.showConfirmDialog(this.examplesButton, p, "Example Inline Jython", 2)) {
            this.editorTextPane1.setText(tf1.getText());
        }
    }

    private void editorTextPane1FocusGained(FocusEvent evt) {
        CompletionImpl impl = CompletionImpl.get();
        impl.startPopup((JTextComponent)this.editorTextPane1);
    }

    public boolean reject(String uri) throws Exception {
        return false;
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        return true;
    }

    private static DefaultTableModel toTableModel(int nr, int nc) {
        DefaultTableModel tm = new DefaultTableModel(nr, nc);
        return tm;
    }

    private static DefaultTableModel toTableModel(String s, int rank) {
        final String[] ss = s.split(";");
        if (rank == 1) {
            if (s.trim().length() == 0) {
                return InlineDataSourceEditorPanel.toTableModel(0, 1);
            }
            return InlineDataSourceEditorPanel.toTableModel(s.split(","));
        }
        int nc = ss[0].split(",").length;
        DefaultTableModel tm = new DefaultTableModel(ss.length, nc){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String[] sss = ss[rowIndex].split(",");
                if (sss.length > columnIndex) {
                    return sss[columnIndex];
                }
                return "";
            }

            @Override
            public void setValueAt(Object v, int row, int col) {
                String[] sss = ss[row].split(",");
                sss[col] = String.valueOf(v);
                StringBuilder b = new StringBuilder(sss[0].replaceAll(",", ""));
                for (int j = 1; j < sss.length; ++j) {
                    b.append(',').append(sss[j].replaceAll(",", ""));
                }
                ss[row] = b.toString();
            }
        };
        return tm;
    }

    private void setColumnLabels() {
        switch (this.scheme) {
            case "eventList": {
                this.tm.setColumnIdentifiers(new String[]{"x"});
                break;
            }
            case "eventListColors": {
                this.tm.setColumnIdentifiers(new String[]{"start", "stop", "color", "message"});
                break;
            }
            case "y_vs_t": {
                this.tm.setColumnIdentifiers(new String[]{"x", "y"});
                break;
            }
        }
    }

    private static DefaultTableModel toTableModel(final String[] s) {
        DefaultTableModel tm = new DefaultTableModel(s.length, 1){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return s[rowIndex];
            }

            @Override
            public void setValueAt(Object v, int row, int col) {
                s[row] = String.valueOf(v).replaceAll(",", "");
            }
        };
        return tm;
    }

    private static DefaultTableModel detectRichEventsList(String uri) {
        String[] ss = Util.guardedSplit((String)uri, (char)'&', (char)'\'', (char)'\"');
        DefaultTableModel mtm = new DefaultTableModel(ss.length - 1, 4);
        Pattern p = Pattern.compile("ds=createEvent\\((ds\\,)?\\'(.*)\\'\\,(.*)\\,\\'(.*)\\'\\)");
        boolean foundOne = false;
        for (int i = 0; i < ss.length; ++i) {
            if (i < ss.length - 1) {
                Matcher m = p.matcher(ss[i]);
                if (!m.matches()) continue;
                foundOne = true;
                String time = m.group(2);
                try {
                    DatumRange tr = DatumRangeUtil.parseTimeRange((String)time);
                    mtm.setValueAt(tr.min().toString(), i, 0);
                    mtm.setValueAt(tr.max().toString(), i, 1);
                    mtm.setValueAt(m.group(3), i, 2);
                    mtm.setValueAt(m.group(4), i, 3);
                    continue;
                }
                catch (ParseException ex) {
                    int i1 = time.indexOf("-");
                    if (i1 > 0) {
                        mtm.setValueAt(time.substring(0, i1).trim(), i, 0);
                        mtm.setValueAt(time.substring(i1 + 1).trim(), i, 1);
                        mtm.setValueAt(m.group(3), i, 2);
                        mtm.setValueAt(m.group(4), i, 3);
                        continue;
                    }
                    return null;
                }
            }
            if (i != ss.length - 1 || ss[i].equals("ds")) continue;
            return null;
        }
        if (foundOne) {
            return mtm;
        }
        return null;
    }

    public void setURI(String uri) {
        if (uri.startsWith("vap+inline:")) {
            uri = uri.substring(11);
        }
        if (DataMashUp.isDataMashupJythonInline((String)uri)) {
            this.mashupUri = uri;
        }
        DefaultTableModel mtm = InlineDataSourceEditorPanel.detectRichEventsList(uri);
        if (uri.length() == 0 || Character.isDigit(uri.charAt(0))) {
            String lit;
            int amp = uri.indexOf("&");
            if (amp == -1) {
                amp = uri.length();
            }
            if ((lit = uri.substring(0, amp)).contains(";")) {
                this.tm = InlineDataSourceEditorPanel.toTableModel(lit, 2);
                this.scheme = SCHEME_Y_VS_T;
            } else {
                this.tm = InlineDataSourceEditorPanel.toTableModel(lit, 1);
                this.scheme = SCHEME_EVENT_LIST;
            }
            this.setColumnLabels();
        } else if (mtm != null) {
            this.tm = mtm;
            this.scheme = SCHEME_EVENT_LIST_COLORS;
            this.setColumnLabels();
            String[] ss = Util.guardedSplit((String)uri, (char)'&', (char)'\'', (char)'\"');
            StringBuilder t = new StringBuilder();
            for (int i = 0; i < ss.length; ++i) {
                if (i > 0) {
                    t.append("\n");
                }
                t.append(ss[i]);
            }
            this.program = t.toString();
            this.jyds = this.equivalentScript(uri);
        } else {
            String[] ss = Util.guardedSplit((String)uri, (char)'&', (char)'\'', (char)'\"');
            StringBuilder t = new StringBuilder();
            for (int i = 0; i < ss.length; ++i) {
                if (i > 0) {
                    t.append("\n");
                }
                t.append(ss[i]);
            }
            this.program = t.toString();
            this.jyds = this.equivalentScript(uri);
            this.tm = null;
        }
    }

    public void markProblems(List<String> problems) {
        if (problems.contains("no timerange provided")) {
            this.needTimeRange = true;
        }
    }

    public JPanel getPanel() {
        DefaultTableModel ltm = this.tm;
        this.initComponents();
        if (this.program != null) {
            this.editorTextPane1.setContentType("text/python");
            this.editorTextPane1.setText(this.program);
        }
        if (this.jyds != null) {
            this.editorTextPane2.setContentType("text/python");
            this.editorTextPane2.setText(this.jyds);
            this.editorTextPane2.setEditable(false);
        }
        if (ltm != null) {
            switch (this.tm.getColumnCount()) {
                case 2: {
                    this.schemeComboBox.setSelectedIndex(2);
                    break;
                }
                case 4: {
                    this.schemeComboBox.setSelectedIndex(1);
                    break;
                }
                default: {
                    this.schemeComboBox.setSelectedIndex(0);
                }
            }
            this.tm = ltm;
            this.table.setModel(ltm);
            this.tf = new JTextField();
            this.tf.setEditable(true);
            this.table.setCellEditor(new DefaultCellEditor(this.tf));
            int cellHeight = 21;
            this.table.setRowHeight(cellHeight);
        } else if (this.mashupUri != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    InlineDataSourceEditorPanel.this.dataMashUp1.setAsJythonInline(InlineDataSourceEditorPanel.this.mashupUri);
                }
            };
            new Thread(run).start();
            if (this.needTimeRange) {
                this.dataMashUp1.enableTimeRange();
            }
            this.jTabbedPane1.setSelectedIndex(3);
        } else {
            this.schemeComboBox.setSelectedIndex(0);
            this.jTabbedPane1.setSelectedIndex(1);
        }
        return this;
    }

    public String getURI() {
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 0: {
                StringBuilder s = new StringBuilder("vap+inline:");
                if (this.scheme.equals(SCHEME_EVENT_LIST_COLORS)) {
                    for (int i = 0; i < this.tm.getRowCount(); ++i) {
                        String str = String.format("%s/%s", this.tm.getValueAt(i, 0), this.tm.getValueAt(i, 1));
                        try {
                            DatumRange drtr = DatumRangeUtil.parseTimeRange((String)str);
                            str = drtr.toString().replaceAll(" ", "+");
                        }
                        catch (ParseException ex) {
                            str = String.format("%s-%s", this.tm.getValueAt(i, 0), this.tm.getValueAt(i, 1));
                        }
                        String color = this.tm.getValueAt(i, 2).toString();
                        if (!color.startsWith("0x")) {
                            color = "0x" + Integer.toHexString(ColorUtil.decodeColor((String)color).getRGB());
                        }
                        if (i == 0) {
                            s.append(String.format("ds=createEvent('%s',%s,'%s')", str, color, this.tm.getValueAt(i, 3)));
                            continue;
                        }
                        s.append(String.format("&ds=createEvent(ds,'%s',%s,'%s')", str, color, this.tm.getValueAt(i, 3)));
                    }
                    s.append("&ds");
                } else {
                    for (int i = 0; i < this.tm.getRowCount(); ++i) {
                        if (this.tm.getColumnCount() > 1) {
                            for (int j = 0; j < this.tm.getColumnCount(); ++j) {
                                if (j > 0) {
                                    s.append(",");
                                }
                                s.append(this.tm.getValueAt(i, j));
                            }
                            s.append(";");
                            continue;
                        }
                        if (i > 0) {
                            s.append(",");
                        }
                        s.append(this.tm.getValueAt(i, 0));
                    }
                }
                if (this.tm.getColumnCount() == 1) {
                    s.append("&RENDER_TYPE=eventsBar");
                }
                return s.toString();
            }
            case 1: {
                StringBuilder s = new StringBuilder("vap+inline:");
                String t = this.editorTextPane1.getText();
                String[] ss = t.split("\n");
                for (int i = 0; i < ss.length; ++i) {
                    if (i > 0) {
                        s.append("&");
                    }
                    s.append(ss[i]);
                }
                return s.toString();
            }
        }
        return this.dataMashUp1.getAsJythonInline();
    }

    public static void main(String[] args) {
        String uri = "vap+inline:ds=getDataSet('vap+inline:ripples(10)')&ff=getDataSet('vap+inline:ones(10)')&ds-ff";
        InlineDataSourceEditorPanel ds = new InlineDataSourceEditorPanel();
        ds.setURI(uri);
        if (0 == JOptionPane.showConfirmDialog(null, ds.getPanel(), "Test Inline Editor", 2)) {
            System.err.println(ds.getURI());
        }
    }

    private String equivalentScript(String uri) {
        int lastIndex;
        String[] ss = Util.guardedSplit((String)uri, (char)'&', (char)'\'', (char)'\"');
        Pattern trp = Pattern.compile("timerange=(.*)");
        Matcher m = trp.matcher(ss[ss.length - 1]);
        if (m.matches()) {
            String t = "timerange='" + m.group(1).replaceAll("\\+", " ") + "'";
            for (int i = ss.length - 1; i > 0; --i) {
                String tt1 = ss[i - 1];
                if (tt1.contains("getDataSet('") && tt1.endsWith("')")) {
                    tt1 = tt1.substring(0, tt1.length() - 2) + "',timerange)";
                }
                ss[i] = tt1;
            }
            ss[0] = t;
        }
        if (!ss[lastIndex = ss.length - 1].contains("=")) {
            ss[lastIndex] = "result=" + ss[lastIndex];
        }
        StringBuilder t = new StringBuilder();
        for (int i = 0; i < ss.length; ++i) {
            t.append(ss[i]);
            t.append("\n");
        }
        t.append("plot(result)\n");
        return t.toString();
    }
}

